/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigInteger;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.j2ee.dd.api.web.SessionConfig;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.util.NbBundle;

public class OverviewPanel
extends SectionInnerPanel
implements ItemListener {
    DDDataObject dObj;
    WebApp webApp;
    private JLabel descriptionLabel;
    private JTextArea descriptionTA;
    private JLabel dispNameLabel;
    private JTextField dispNameTF;
    private JPanel filler;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel stLabel;
    private JTextField stTF;

    public OverviewPanel(SectionView sectionView, DDDataObject dObj) {
        super(sectionView);
        this.dObj = dObj;
        this.webApp = dObj.getWebApp();
        this.initComponents();
        this.dispNameTF.setText(this.webApp.getDefaultDisplayName());
        this.addModifier(this.dispNameTF);
        Utils.makeTextAreaLikeTextField((JTextArea)this.descriptionTA, (JTextField)this.dispNameTF);
        this.descriptionTA.setText(this.webApp.getDefaultDescription());
        this.addModifier(this.descriptionTA);
        this.jCheckBox1.setSelected(this.webApp.isDistributable());
        this.jCheckBox1.addItemListener(this);
        this.stTF.setText(this.getSessionTimeout());
        this.addValidatee(this.stTF);
    }

    private String getSessionTimeout() {
        SessionConfig config = this.webApp.getSingleSessionConfig();
        if (config == null) {
            return "";
        }
        BigInteger timeout = config.getSessionTimeout();
        return timeout == null ? "" : timeout.toString();
    }

    private void setSessionTimeout(String text) {
        String val = text.trim();
        SessionConfig config = this.webApp.getSingleSessionConfig();
        if (config != null) {
            if (text.length() == 0) {
                this.webApp.setSessionConfig(null);
            } else {
                config.setSessionTimeout(new BigInteger(val));
            }
        } else if (text.length() > 0) {
            try {
                SessionConfig newConfig = (SessionConfig)this.webApp.createBean("SessionConfig");
                newConfig.setSessionTimeout(new BigInteger(val));
                this.webApp.setSessionConfig(newConfig);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
    }

    public JComponent getErrorComponent(String errorId) {
        return null;
    }

    public void documentChanged(JTextComponent comp, String value) {
        if (comp == this.stTF) {
            String text = value.trim();
            if (text.length() == 0) {
                this.getSectionView().getErrorPanel().clearError();
            } else {
                BigInteger st = null;
                try {
                    st = new BigInteger(text);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                if (st == null) {
                    this.getSectionView().getErrorPanel().setError(new Error(0, 0, "Invalid Value : " + text, (JComponent)this.stTF));
                    return;
                }
                this.getSectionView().getErrorPanel().clearError();
            }
        }
    }

    public void setValue(JComponent source, Object value) {
        String text = ((String)value).trim();
        if (source == this.dispNameTF) {
            this.webApp.setDisplayName(text.length() == 0 ? null : text);
        } else if (source == this.descriptionTA) {
            this.webApp.setDescription(text.length() == 0 ? null : text);
        } else if (source == this.stTF) {
            this.setSessionTimeout(text);
        }
    }

    public void rollbackValue(JTextComponent source) {
        if (source == this.stTF) {
            this.stTF.setText(this.getSessionTimeout());
        }
    }

    public void linkButtonPressed(Object obj, String id) {
    }

    private void initComponents() {
        this.filler = new JPanel();
        this.dispNameLabel = new JLabel();
        this.dispNameTF = new JTextField();
        this.descriptionLabel = new JLabel();
        this.descriptionTA = new JTextArea();
        this.jCheckBox1 = new JCheckBox();
        this.stLabel = new JLabel();
        this.stTF = new JTextField();
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.filler.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.filler, gridBagConstraints);
        this.dispNameLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)OverviewPanel.class, (String)"LBL_displayName_mnem").charAt(0));
        this.dispNameLabel.setLabelFor(this.dispNameTF);
        this.dispNameLabel.setText(NbBundle.getMessage((Class)OverviewPanel.class, (String)"LBL_displayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.dispNameLabel, gridBagConstraints);
        this.dispNameTF.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.dispNameTF, gridBagConstraints);
        this.descriptionLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)OverviewPanel.class, (String)"LBL_description_mnem").charAt(0));
        this.descriptionLabel.setLabelFor(this.descriptionTA);
        this.descriptionLabel.setText(NbBundle.getMessage((Class)OverviewPanel.class, (String)"LBL_description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.descriptionLabel, gridBagConstraints);
        this.descriptionTA.setRows(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.add(this.descriptionTA, gridBagConstraints);
        this.jCheckBox1.setMnemonic(NbBundle.getMessage((Class)OverviewPanel.class, (String)"LBL_distributable_mnem").charAt(0));
        this.jCheckBox1.setText(NbBundle.getMessage((Class)OverviewPanel.class, (String)"LBL_distributable"));
        this.jCheckBox1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.jCheckBox1, gridBagConstraints);
        this.stLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)OverviewPanel.class, (String)"LBL_sessionTimeout_mnem").charAt(0));
        this.stLabel.setLabelFor(this.stTF);
        this.stLabel.setText(NbBundle.getMessage((Class)OverviewPanel.class, (String)"LBL_sessionTimeout"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.add(this.stLabel, gridBagConstraints);
        this.stTF.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add(this.stTF, gridBagConstraints);
        this.jLabel1.setText(NbBundle.getMessage((Class)OverviewPanel.class, (String)"LBL_min"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add(this.jLabel1, gridBagConstraints);
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.jCheckBox1) {
            this.dObj.modelUpdatedFromUI();
            this.dObj.setChangedFromUI(true);
            this.webApp.setDistributable(this.jCheckBox1.isSelected());
            this.dObj.setChangedFromUI(false);
        }
    }

    protected void startUIChange() {
        this.dObj.setChangedFromUI(true);
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
        this.dObj.setChangedFromUI(false);
    }
}

