/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import org.netbeans.modules.options.keymap.ActionImpl;
import org.netbeans.modules.options.keymap.EditorBridge;
import org.netbeans.modules.options.keymap.KeymapModel;
import org.netbeans.modules.options.keymap.LayersBridge;
import org.netbeans.modules.options.keymap.XMLStorage;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class ExportShortcutsAction {
    private static Action exportIDEActionsAction = new AbstractAction(){
        {
            this.putValue("Name", ExportShortcutsAction.loc("CTL_Export_IDE_Actions_Action"));
        }

        public void actionPerformed(ActionEvent e) {
            LayersBridge layersBridge = new LayersBridge();
            Map categoryToActions = layersBridge.getActions();
            Map m = ExportShortcutsAction.resolveNames(categoryToActions);
            ExportShortcutsAction.generateLayersXML(layersBridge, m);
        }
    };
    private static Action exportIDEShortcutsAction = new AbstractAction(){
        {
            this.putValue("Name", ExportShortcutsAction.loc("CTL_Export_IDE_Shortcuts_Action"));
        }

        public void actionPerformed(ActionEvent e) {
            HashMap<String, Map> allKeyMaps = new HashMap<String, Map>();
            LayersBridge layersBridge = new LayersBridge();
            layersBridge.getActions();
            List keyMaps = layersBridge.getProfiles();
            Iterator it3 = keyMaps.iterator();
            while (it3.hasNext()) {
                String keyMapName = (String)it3.next();
                Map actionToShortcuts = layersBridge.getKeymap(keyMapName);
                Map shortcutToAction = LayersBridge.shortcutToAction(actionToShortcuts);
                allKeyMaps.put(keyMapName, shortcutToAction);
            }
            ExportShortcutsAction.generateLayersXML(layersBridge, allKeyMaps);
        }
    };
    private static Action exportEditorShortcutsAction = new AbstractAction(){
        {
            this.putValue("Name", ExportShortcutsAction.loc("CTL_Export_Editor_Shortcuts_Action"));
        }

        public void actionPerformed(ActionEvent e) {
            HashMap allKeyMaps = new HashMap();
            EditorBridge editorBridge = new EditorBridge();
            editorBridge.getActions();
            Map actionToShortcuts = editorBridge.readKeymap(editorBridge.getCurrentProfile());
            ExportShortcutsAction.generateEditorXML(actionToShortcuts);
        }
    };
    private static Action exportShortcutsToHTMLAction = new AbstractAction(){
        {
            this.putValue("Name", ExportShortcutsAction.loc("CTL_Export_Shortcuts_to_HTML_Action"));
        }

        public void actionPerformed(ActionEvent e) {
            ExportShortcutsAction.exportShortcutsToHTML();
        }
    };

    public static Action getExportIDEActionsAction() {
        return exportIDEActionsAction;
    }

    public static Action getExportIDEShortcutsAction() {
        return exportIDEShortcutsAction;
    }

    public static Action getExportEditorShortcutsAction() {
        return exportEditorShortcutsAction;
    }

    public static Action getExportShortcutsToHTMLAction() {
        return exportShortcutsToHTMLAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportShortcutsToHTML() {
        KeymapModel keymapModel = new KeymapModel();
        TreeMap<String, Map> keymaps = new TreeMap<String, Map>();
        Iterator<Object> it = keymapModel.getProfiles().iterator();
        while (it.hasNext()) {
            String profile = (String)it.next();
            keymaps.put(profile, keymapModel.getKeymap(profile));
        }
        try {
            StringBuffer sb = new StringBuffer();
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart(sb, "html", attribs, "");
            XMLStorage.generateFolderStart(sb, "body", attribs, "  ");
            attribs.add("border", "1");
            attribs.add("cellpadding", "1");
            attribs.add("cellspacing", "0");
            XMLStorage.generateFolderStart(sb, "table", attribs, "    ");
            attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart(sb, "tr", attribs, "      ");
            XMLStorage.generateFolderStart(sb, "td", attribs, "        ");
            XMLStorage.generateFolderStart(sb, "h2", attribs, "        ");
            sb.append("Action Name");
            XMLStorage.generateFolderEnd(sb, "h2", "        ");
            XMLStorage.generateFolderEnd(sb, "td", "        ");
            it = keymaps.keySet().iterator();
            while (it.hasNext()) {
                String profile = (String)it.next();
                XMLStorage.generateFolderStart(sb, "td", attribs, "        ");
                XMLStorage.generateFolderStart(sb, "h2", attribs, "        ");
                sb.append(profile);
                XMLStorage.generateFolderEnd(sb, "h2", "        ");
                XMLStorage.generateFolderEnd(sb, "td", "        ");
            }
            ExportShortcutsAction.exportShortcutsToHTML2(keymapModel, sb, keymaps);
            XMLStorage.generateFolderEnd(sb, "table", "    ");
            XMLStorage.generateFolderEnd(sb, "body", "  ");
            XMLStorage.generateFolderEnd(sb, "html", "");
            FileObject fo = FileUtil.createData((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot(), (String)"shortcuts.html");
            FileLock fileLock = fo.lock();
            try {
                OutputStream outputStream = fo.getOutputStream(fileLock);
                OutputStreamWriter writer = new OutputStreamWriter(outputStream);
                writer.write(sb.toString());
                writer.close();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            finally {
                fileLock.releaseLock();
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private static void exportShortcutsToHTML2(KeymapModel keymapModel, StringBuffer sb, Map keymaps) {
        ArrayList categories = new ArrayList(keymapModel.getActionCategories());
        Collections.sort(categories);
        XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
        Iterator it = categories.iterator();
        while (it.hasNext()) {
            String category = (String)it.next();
            XMLStorage.generateFolderStart(sb, "tr", attribs, "      ");
            attribs.add("colspan", Integer.toString(keymaps.size() + 1));
            attribs.add("rowspan", "1");
            XMLStorage.generateFolderStart(sb, "td", attribs, "        ");
            attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart(sb, "h3", attribs, "        ");
            sb.append(category);
            XMLStorage.generateFolderEnd(sb, "h3", "        ");
            XMLStorage.generateFolderEnd(sb, "td", "        ");
            XMLStorage.generateFolderEnd(sb, "tr", "      ");
            ExportShortcutsAction.exportShortcutsToHTML3(sb, keymapModel, category, keymaps);
        }
    }

    private static void exportShortcutsToHTML3(StringBuffer sb, KeymapModel keymapModel, String category, Map keymaps) {
        Set actions = keymapModel.getActions(category);
        TreeMap<String, ActionImpl> sortedActions = new TreeMap<String, ActionImpl>();
        Iterator<Object> it = actions.iterator();
        while (it.hasNext()) {
            ActionImpl action = (ActionImpl)it.next();
            sortedActions.put(action.getDisplayName(), action);
        }
        XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
        it = sortedActions.keySet().iterator();
        while (it.hasNext()) {
            String actionName = (String)it.next();
            ActionImpl action = (ActionImpl)sortedActions.get(actionName);
            XMLStorage.generateFolderStart(sb, "tr", attribs, "      ");
            XMLStorage.generateFolderStart(sb, "td", attribs, "        ");
            sb.append(actionName);
            XMLStorage.generateFolderEnd(sb, "td", "        ");
            Iterator it2 = keymaps.keySet().iterator();
            while (it2.hasNext()) {
                String profile = (String)it2.next();
                Map keymap = (Map)keymaps.get(profile);
                Set shortcuts = (Set)keymap.get(action);
                XMLStorage.generateFolderStart(sb, "td", attribs, "        ");
                ExportShortcutsAction.printShortcuts(shortcuts, sb);
                XMLStorage.generateFolderEnd(sb, "td", "        ");
            }
            XMLStorage.generateFolderEnd(sb, "tr", "      ");
        }
    }

    private static void printShortcuts(Set shortcuts, StringBuffer sb) {
        if (shortcuts == null) {
            sb.append('-');
            return;
        }
        Iterator it = shortcuts.iterator();
        while (it.hasNext()) {
            String shortcut = (String)it.next();
            sb.append(shortcut);
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateLayersXML(LayersBridge layersBridge, Map categoryToActions) {
        Writer fw = null;
        try {
            fw = ExportShortcutsAction.openWriter();
            if (fw == null) {
                return;
            }
            StringBuffer sb = XMLStorage.generateHeader();
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart(sb, "filesystem", attribs, "");
            attribs.add("name", "Keymaps");
            XMLStorage.generateFolderStart(sb, "folder", attribs, "    ");
            ExportShortcutsAction.generateShadowsToXML(layersBridge, sb, categoryToActions, "        ");
            XMLStorage.generateFolderEnd(sb, "folder", "    ");
            XMLStorage.generateFolderEnd(sb, "filesystem", "");
            System.out.println(sb.toString());
            fw.write(sb.toString());
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        finally {
            try {
                if (fw != null) {
                    fw.flush();
                    fw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateEditorXML(Map actionToShortcuts) {
        Writer fw = null;
        try {
            fw = ExportShortcutsAction.openWriter();
            if (fw == null) {
                return;
            }
            StringBuffer sb = XMLStorage.generateHeader();
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart(sb, "bindings", attribs, "");
            TreeMap sortedMap = new TreeMap();
            Iterator it = actionToShortcuts.keySet().iterator();
            while (it.hasNext()) {
                ActionImpl action = (ActionImpl)it.next();
                sortedMap.put(action.getDisplayName(), actionToShortcuts.get(action));
            }
            it = sortedMap.keySet().iterator();
            while (it.hasNext()) {
                String actionName = (String)it.next();
                Set shortcuts = (Set)sortedMap.get(actionName);
                Iterator it2 = shortcuts.iterator();
                while (it2.hasNext()) {
                    String shortcut = (String)it2.next();
                    attribs = new XMLStorage.Attribs(true);
                    attribs.add("actionName", actionName);
                    attribs.add("key", shortcut);
                    XMLStorage.generateLeaf(sb, "bind", attribs, "  ");
                }
            }
            XMLStorage.generateFolderEnd(sb, "bindings", "");
            System.out.println(sb.toString());
            fw.write(sb.toString());
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        finally {
            try {
                if (fw != null) {
                    fw.flush();
                    fw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static Map resolveNames(Map categoryToActions) {
        HashMap result = new HashMap();
        Iterator it = categoryToActions.keySet().iterator();
        while (it.hasNext()) {
            String category = (String)it.next();
            Set actions = (Set)categoryToActions.get(category);
            HashMap<String, ActionImpl> actionsMap = new HashMap<String, ActionImpl>();
            Iterator it1 = actions.iterator();
            while (it1.hasNext()) {
                ActionImpl action = (ActionImpl)it1.next();
                actionsMap.put(action.getDisplayName(), action);
            }
            result.put(category, actionsMap);
        }
        return result;
    }

    private static void generateShadowsToXML(LayersBridge layersBridge, StringBuffer sb, Map shortcutToAction, String indentation) {
        Iterator it = shortcutToAction.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = shortcutToAction.get(key);
            if (value instanceof Map) {
                XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
                attribs.add("name", key);
                XMLStorage.generateFolderStart(sb, "folder", attribs, indentation);
                ExportShortcutsAction.generateShadowsToXML(layersBridge, sb, (Map)value, "    " + indentation);
                XMLStorage.generateFolderEnd(sb, "folder", indentation);
                continue;
            }
            DataObject dob = layersBridge.getDataObject(value);
            if (dob == null) {
                System.out.println("no Dataobject " + value);
                continue;
            }
            FileObject fo = dob.getPrimaryFile();
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            attribs.add("name", key + ".shadow");
            XMLStorage.generateFolderStart(sb, "file", attribs, indentation);
            XMLStorage.Attribs attribs2 = new XMLStorage.Attribs(true);
            attribs2.add("name", "originalFile");
            attribs2.add("stringvalue", fo.getPath());
            XMLStorage.generateLeaf(sb, "attr", attribs2, indentation + "    ");
            XMLStorage.generateFolderEnd(sb, "file", indentation);
        }
    }

    private static Writer openWriter() throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        int result = fileChooser.showSaveDialog(WindowManager.getDefault().getMainWindow());
        if (result != 0) {
            return null;
        }
        File f = fileChooser.getSelectedFile();
        return new FileWriter(f);
    }

    private static String loc(String key) {
        return NbBundle.getMessage((Class)ExportShortcutsAction.class, (String)key);
    }
}

