/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.base;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.navigation.base.NavigatorJList;
import org.netbeans.modules.java.navigation.base.TooltipHack;
import org.netbeans.modules.java.navigation.spi.AbstractModel;
import org.netbeans.modules.java.navigation.spi.NavigatorTreeModel;
import org.openide.util.NbBundle;

public class NavigatorJTree
extends JTree {
    JLabel widthTestLabel = NavigatorJList.widthTestLabel;
    private JComponent enclosingComp;

    public NavigatorJTree(JComponent enclosingComp) {
        this.enclosingComp = enclosingComp;
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)NavigatorJTree.class, (String)"ACC_NavTreeName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)NavigatorJTree.class, (String)"ACC_NavTreeDesc"));
    }

    public void addNotify() {
        super.addNotify();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    private int approximateWidth(String s) {
        this.widthTestLabel.setText(s);
        return this.widthTestLabel.getPreferredSize().width;
    }

    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    public boolean requestFocusInWindow() {
        boolean result = super.requestFocusInWindow();
        if (this.getSelectionPath() == null && this.getModel().getRoot() != null) {
            this.setSelectionRow(0);
        }
        return result;
    }

    public String getToolTipText(MouseEvent me) {
        if (this.getModel() instanceof NavigatorTreeModel) {
            NavigatorTreeModel nlm = (NavigatorTreeModel)this.getModel();
            Point p = me.getPoint();
            TreePath path = this.getPathForLocation(p.x, p.y);
            if (path != null) {
                Object rep = path.getLastPathComponent();
                if (AbstractModel.isWaitMarker(rep) || AbstractModel.isInvalidMarker(rep)) {
                    return null;
                }
                String result = nlm.getTooltip(rep);
                if (result != null) {
                    return result;
                }
            }
        }
        return "";
    }

    public Point getToolTipLocation(MouseEvent e) {
        Point result = e.getPoint();
        Container c = this.getTopLevelAncestor();
        Rectangle r = this.enclosingComp.getBounds();
        Rectangle converted = SwingUtilities.convertRectangle(this, r, c);
        boolean closerToLeft = converted.x + converted.width < c.getWidth() - converted.x;
        result = SwingUtilities.convertPoint(this, result, this.enclosingComp);
        int approxWidth = this.approximateWidth(this.getToolTipText(e));
        int approxHeight = this.widthTestLabel.getPreferredSize().height;
        result.x = closerToLeft ? r.x + r.width + 5 : r.x - (approxWidth + 10);
        result = SwingUtilities.convertPoint(this.enclosingComp, result, this);
        Point orig = e.getPoint();
        TreePath path = this.getPathForLocation(orig.x, orig.y);
        if (path != null) {
            Rectangle r2 = this.getPathBounds(path);
            result.y = r2.y;
        }
        return result;
    }

    public String getToolTipText() {
        Rectangle rect;
        TreePath selPath = this.getSelectionPath();
        if (selPath != null && (rect = this.getPathBounds(selPath)) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TooltipHack.invokeTip(NavigatorJTree.this, (int)rect.getCenterX(), (int)rect.getCenterY(), Integer.MAX_VALUE);
                }
            });
        }
        return "";
    }
}

