/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class JavaDocParser {
    private static final String TEXT_TAG_NAME = "@@@@@";
    protected String rawText;
    protected JavaDocTag[] tags;
    private static final String lineSeparator;
    private static final int lineSeparatorLength;

    public JavaDocParser(String rawText) {
        this.rawText = rawText;
        this.tags = null;
    }

    public JavaDocParser(JavaDocTag[] tags) {
        this.rawText = null;
        this.tags = tags;
    }

    public JavaDocParser(String text, JavaDocTag[] tags) {
        this.rawText = null;
        if (text == null) {
            this.tags = tags;
        } else {
            int newSize = tags != null ? tags.length + 1 : 1;
            JavaDocTag[] newTags = new JavaDocTag[newSize];
            newTags[0] = new JavaDocTag(TEXT_TAG_NAME, text);
            if (tags != null) {
                System.arraycopy(tags, 0, newTags, 1, tags.length);
            }
            this.tags = newTags;
        }
    }

    public String getRawText() {
        return this.getRawText(false);
    }

    public String getRawText(boolean reorder) {
        if (this.rawText != null && !reorder) {
            return this.rawText;
        }
        if (this.rawText != null) {
            this.tags = this.getTags();
        }
        if (reorder) {
            Arrays.sort(this.tags);
        }
        String javadocContent = this.buildComment(this.tags);
        return javadocContent;
    }

    public void clearJavaDoc() {
        this.rawText = null;
    }

    public boolean isEmpty() {
        return this.rawText == null;
    }

    public JavaDocTag[] getTags() {
        if (this.tags != null) {
            return this.tags;
        }
        if (this.rawText == null) {
            return null;
        }
        ArrayList tagList = new ArrayList();
        int[] textIndexes = this.removeJavaDocStars(this.getRawText());
        this.parseComment(tagList, this.getRawText(), textIndexes);
        JavaDocTag[] tagArray = new JavaDocTag[tagList.size()];
        tagList.toArray(tagArray);
        return tagArray;
    }

    public JavaDocTag[] getTags(String name) {
        JavaDocTag[] allTags = this.getTags();
        ArrayList<JavaDocTag> resultList = new ArrayList<JavaDocTag>(allTags.length);
        for (int i = 0; i < allTags.length; ++i) {
            if (!allTags[i].getName().equals(name)) continue;
            resultList.add(allTags[i]);
        }
        JavaDocTag[] result = new JavaDocTag[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    private void parseComment(List tagList, String textWithStars, int[] textIndexes) {
        boolean IN_TEXT = true;
        int TAG_GAP = 2;
        int TAG_NAME = 3;
        int TAG_TEXT = 4;
        int state = 1;
        boolean newLine = true;
        int tagStart = 0;
        int tagEnd = 0;
        int textStart = 0;
        int textEnd = 0;
        int lastNonWhite = -1;
        String rawText = this.rebuildText(textWithStars, textIndexes);
        int len = rawText.length();
        for (int i = 0; i < len; ++i) {
            char ch = rawText.charAt(i);
            boolean isWhite = Character.isWhitespace(ch);
            switch (state) {
                case 1: {
                    if (!newLine || ch != '@') break;
                    this.parseCommentComponent(tagList, rawText, textIndexes, -1, -1, 0, textEnd);
                    tagStart = i;
                    state = 3;
                    break;
                }
                case 3: {
                    if (!isWhite) break;
                    tagEnd = i;
                    state = 2;
                    break;
                }
                case 2: {
                    if (isWhite) break;
                    textStart = i;
                    state = 4;
                }
                case 4: {
                    if (!newLine || ch != '@') break;
                    this.parseCommentComponent(tagList, rawText, textIndexes, tagStart, tagEnd, textStart, lastNonWhite + 1);
                    tagStart = i;
                    state = 3;
                }
            }
            if (lineSeparator != null && i + lineSeparatorLength <= len && rawText.regionMatches(i, lineSeparator, 0, lineSeparatorLength)) {
                newLine = true;
                if (state == 1) {
                    textEnd = i;
                }
                i += lineSeparatorLength - 1;
                continue;
            }
            if (ch == '\n') {
                newLine = true;
                if (state != 1) continue;
                textEnd = i;
                continue;
            }
            if (isWhite) continue;
            lastNonWhite = i;
            newLine = false;
        }
        switch (state) {
            case 3: {
                tagEnd = len;
            }
            case 2: {
                textStart = len;
            }
            case 1: 
            case 4: {
                this.parseCommentComponent(tagList, rawText, textIndexes, tagStart, tagEnd, textStart, lastNonWhite + 1);
            }
        }
    }

    private void parseCommentComponent(List tagList, String text, int[] textIndexes, int tagStart, int tagEnd, int textStart, int textEnd) {
        String tx;
        String tagName = tagStart < 0 || tagEnd < 0 || tagStart > tagEnd || tagStart == 0 && tagEnd == 0 ? TEXT_TAG_NAME : text.substring(tagStart, tagEnd);
        String string = tx = textStart < 0 || textEnd < 0 || textStart > textEnd ? "" : text.substring(textStart, textEnd);
        if (TEXT_TAG_NAME.equals(tagName)) {
            JavaDocTag tag = new JavaDocTag(TEXT_TAG_NAME, tx, -1, -1, textIndexes != null ? textIndexes[textStart] : textStart, textIndexes != null ? textIndexes[textEnd] : textEnd);
            tagList.add(tag);
        } else {
            JavaDocTag tag = new JavaDocTag(tagName, tx, textIndexes != null ? textIndexes[tagStart] : tagStart, textIndexes != null ? textIndexes[tagEnd] : tagEnd, textIndexes != null ? textIndexes[textStart] : textStart, textIndexes != null ? textIndexes[textEnd] : textEnd);
            tagList.add(tag);
        }
    }

    public int[] removeJavaDocStars(String rawText) {
        int[] result;
        boolean SPACE_BEFORE = true;
        int ASTERIX = 2;
        int SPACE_AFTER = 3;
        int TEXT = 4;
        int LINE_BREAK = 5;
        if (rawText == null || rawText.length() < 4) {
            return null;
        }
        int len = rawText.length();
        int[] text = new int[len];
        int j = 0;
        int state = 2;
        int start = rawText.indexOf("/*");
        int end = rawText.lastIndexOf("*/");
        if (start == -1 || end == -1 || start + 2 > end) {
            return null;
        }
        int linebreak = -1;
        for (int i = start + 2; i < end; ++i) {
            char ch = rawText.charAt(i);
            if (ch == '\n' || ch == '\r') {
                linebreak = i;
            } else if (ch == '*' && linebreak >= 0) {
                linebreak = -1;
            }
            switch (state) {
                case 1: {
                    if (ch == '*') {
                        state = 2;
                        break;
                    }
                    if (ch == '\n' || ch == '\r') {
                        state = 5;
                        break;
                    }
                    if (ch == ' ' || ch == '\t') break;
                    state = 4;
                    break;
                }
                case 3: {
                    if (ch == '\n' || ch == '\r') {
                        state = 5;
                        break;
                    }
                    if (ch == ' ' || ch == '\t') break;
                    state = 4;
                    break;
                }
                case 2: {
                    if (ch == '\n' || ch == '\r') {
                        state = 5;
                        break;
                    }
                    if (ch == ' ' || ch == '\t') {
                        state = 3;
                        break;
                    }
                    if (ch == '*') break;
                    state = 4;
                    break;
                }
                case 4: {
                    if (ch != '\n' && ch != '\r') break;
                    state = 5;
                    break;
                }
                case 5: {
                    if (ch == '*') {
                        state = 2;
                        break;
                    }
                    if (ch == ' ' || ch == '\t') {
                        state = 1;
                        break;
                    }
                    if (ch == '\n' || ch == '\r') break;
                    state = 4;
                }
            }
            if (state == 5 || state == 3) {
                text[j++] = i;
                continue;
            }
            if (state != 4) continue;
            if (linebreak != -1) {
                int k = linebreak + 1;
                while (k <= i) {
                    text[j++] = k++;
                }
                linebreak = -1;
                continue;
            }
            text[j++] = i;
        }
        if (j < len) {
            result = new int[j];
            System.arraycopy(text, 0, result, 0, j);
        } else {
            result = text;
        }
        return result;
    }

    private String rebuildText(String text, int[] textIndexes) {
        String rawText = text;
        if (textIndexes != null) {
            char[] rawTextChars = new char[textIndexes.length];
            for (int i = 0; i < textIndexes.length; ++i) {
                rawTextChars[i] = text.charAt(textIndexes[i]);
            }
            rawText = new String(rawTextChars, 0, rawTextChars.length);
        }
        return rawText;
    }

    private String buildComment(JavaDocTag[] tags) {
        if (tags == null) {
            return null;
        }
        if (tags.length == 0) {
            return "";
        }
        String separator = lineSeparator != null ? lineSeparator : "\n";
        String separator2 = separator + separator;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tags.length; ++i) {
            String value;
            if (TEXT_TAG_NAME.equals(tags[i].getName())) {
                value = tags[i].getValue();
                sb.append(value);
                if (value.endsWith(separator2)) continue;
                if (!value.endsWith(separator)) {
                    sb.append('\n');
                }
                sb.append('\n');
                continue;
            }
            value = tags[i].getValue();
            sb.append(tags[i].getName()).append(" ").append(value);
            if (value.endsWith(separator)) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String surroundWithJavaDocStars(String javadocContent) {
        if (javadocContent == null) {
            return null;
        }
        String separator = "\n";
        StringBuffer sb = new StringBuffer("/**\n *");
        String[] tokens = javadocContent.split(separator);
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].startsWith(" ")) {
                sb.append(' ');
            }
            sb.append(tokens[i]);
            sb.append(separator).append(" *");
        }
        sb.append('/');
        return sb.toString();
    }

    static {
        String sep = System.getProperty("line.separator");
        if (sep == null || sep.equals("\n")) {
            lineSeparator = null;
            lineSeparatorLength = 0;
        } else {
            lineSeparator = sep;
            lineSeparatorLength = sep.length();
        }
    }

    public static class JavaDocTag
    implements Comparable {
        public static final HashMap nameValues = new HashMap();
        String name;
        String text;
        private int startName;
        private int endName;
        private int startText;
        private int endText;

        public JavaDocTag(String name, String text) {
            this.name = name;
            this.text = text;
            this.endText = -1;
            this.startText = -1;
            this.endName = -1;
            this.startName = -1;
        }

        JavaDocTag(String name, String text, int startName, int endName, int startText, int endText) {
            this.name = name;
            this.text = text;
            this.startName = startName;
            this.endName = endName;
            this.startText = startText;
            this.endText = endText;
        }

        public String toString() {
            return this.name + " " + this.text;
        }

        public String toInfo() {
            return this.startName + "," + this.endName + "{" + this.name + "} " + this.startText + "," + this.endText + "{" + this.text + "}";
        }

        public String getName() {
            return this.name;
        }

        public String getKind() {
            return this.name;
        }

        public boolean isText() {
            return JavaDocParser.TEXT_TAG_NAME.equals(this.getName());
        }

        public String getValue() {
            return this.text;
        }

        public int getStartName() {
            return this.startName;
        }

        public int getEndName() {
            return this.endName;
        }

        public int getStartText() {
            return this.startText;
        }

        public int getEndText() {
            return this.endText;
        }

        private int getNameValue(String name) {
            Integer value = (Integer)nameValues.get(name);
            if (value != null) {
                return value;
            }
            return 0;
        }

        public int compareTo(Object o) {
            if (o == null || !(o instanceof JavaDocTag)) {
                return -1;
            }
            String name1 = this.getName();
            String name2 = ((JavaDocTag)o).getName();
            int value1 = this.getNameValue(name1);
            int value2 = this.getNameValue(name2);
            if (value1 > 0 && value2 > 0) {
                return value1 - value2;
            }
            if (value1 > 0) {
                return -100;
            }
            if (value2 > 0) {
                return 100;
            }
            return name1.compareTo(name2);
        }

        static {
            nameValues.put(JavaDocParser.TEXT_TAG_NAME, new Integer(1));
            nameValues.put("@author", new Integer(2));
            nameValues.put("@version", new Integer(3));
            nameValues.put("@param", new Integer(4));
            nameValues.put("@return", new Integer(5));
            nameValues.put("@exception", new Integer(6));
            nameValues.put("@see", new Integer(7));
            nameValues.put("@since", new Integer(8));
            nameValues.put("@serial", new Integer(9));
            nameValues.put("@deprecated", new Integer(10));
        }
    }
}

