/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client;

import com.sun.xml.ws.client.BindingProviderProperties;
import com.sun.xml.ws.client.PortInfoBase;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContextMap
extends HashMap<String, Object>
implements BindingProviderProperties {
    private static final Set<String> KNOWN_PROPERTIES;
    private static final HashMap<String, Class> _allowedClass;
    protected BindingProvider _owner;
    protected PortInfoBase portInfo;

    public abstract ContextMap copy();

    public ContextMap(PortInfoBase info, BindingProvider provider) {
        this._owner = provider;
        if (info != null) {
            this.portInfo = info;
        }
    }

    public ContextMap(ContextMap original) {
        super(original);
        this._owner = original._owner;
    }

    public ContextMap(BindingProvider owner) {
        this(null, owner);
    }

    boolean doValidation() {
        return this._owner != null;
    }

    @Override
    public Object put(String name, Object value) {
        if (this.doValidation()) {
            this.validateProperty(name, value, true);
            return super.put(name, value);
        }
        return null;
    }

    public Object get(String name) {
        if (this.doValidation()) {
            this.validateProperty(name, null, false);
            return super.get(name);
        }
        return null;
    }

    public Iterator<String> getPropertyNames() {
        return this.keySet().iterator();
    }

    public Object remove(String name) {
        if (this.doValidation()) {
            this.validateProperty(name, null, false);
            return super.remove(name);
        }
        return null;
    }

    private boolean isAllowedValue(String name, Object value) {
        if (name.equals("javax.xml.ws.http.request.pathinfo") || name.equals("javax.xml.ws.http.request.querystring")) {
            return true;
        }
        return value != null;
    }

    private boolean isAllowedClass(String propName, Object value) {
        Class allowedClass = _allowedClass.get(propName);
        if (allowedClass != null) {
            return allowedClass.isInstance(value);
        }
        return true;
    }

    private void validateProperty(String name, Object value, boolean isSetter) {
        if (name == null) {
            throw new WebServiceException(name + " is a User-defined property - property name can not be null. ", new IllegalArgumentException("Name of property is null.  This is an invalid property name. "));
        }
        if (isSetter) {
            if (!this.isAllowedClass(name, value)) {
                throw new WebServiceException(value + " is Not Allowed Class for property " + name, new IllegalArgumentException("Not Allowed Class for property"));
            }
            if (!this.isAllowedValue(name, value)) {
                throw new WebServiceException(value + " is Not Allowed Value for property " + name, new IllegalArgumentException("Not Allowed value"));
            }
        }
    }

    static {
        _allowedClass = new HashMap();
        _allowedClass.put("javax.xml.ws.security.auth.username", String.class);
        _allowedClass.put("javax.xml.ws.security.auth.password", String.class);
        _allowedClass.put("javax.xml.ws.service.endpoint.address", String.class);
        _allowedClass.put("javax.xml.ws.session.maintain", Boolean.class);
        _allowedClass.put("javax.xml.ws.soap.http.soapaction.use", Boolean.class);
        _allowedClass.put("javax.xml.ws.soap.http.soapaction.uri", String.class);
        _allowedClass.put("com.sun.xml.ws.jaxbcontext", JAXBContext.class);
        HashSet<String> temp = new HashSet<String>();
        temp.add("javax.xml.ws.security.auth.username");
        temp.add("javax.xml.ws.security.auth.password");
        temp.add("javax.xml.ws.service.endpoint.address");
        temp.add("javax.xml.ws.session.maintain");
        temp.add("javax.xml.ws.soap.http.soapaction.use");
        temp.add("javax.xml.ws.soap.http.soapaction.uri");
        temp.add("com.sun.xml.ws.jaxbcontext");
        temp.add("accept.encoding");
        temp.add("com.sun.xml.ws.client.ClientTransportFactory");
        temp.add("com.sun.xml.ws.client.handle");
        temp.add("com.sun.xml.ws.client.handle");
        temp.add("com.sun.xml.ws.client.http.CookieJar");
        temp.add("com.sun.xml.ws.server.OneWayOperation");
        temp.add("com.sun.xml.ws.client.http.HTTPStatusCode");
        temp.add("com.sun.xml.ws.client.http.HostnameVerificationProperty");
        temp.add("com.sun.xml.ws.client.http.RedirectRequestProperty");
        temp.add("com.sun.xml.ws.security.context");
        temp.add("com.sun.xml.ws.attachment.SetAttachmentContext");
        temp.add("com.sun.xml.ws.attachment.GetAttachmentContext");
        temp.add("javax.xml.ws.binding.attachments.inbound");
        temp.add("javax.xml.ws.binding.attachments.outbound");
        temp.add("javax.xml.ws.wsdl.description");
        temp.add("javax.xml.ws.wsdl.interface");
        temp.add("javax.xml.ws.wsdl.operation");
        temp.add("javax.xml.ws.wsdl.port");
        temp.add("javax.xml.ws.wsdl.service");
        temp.add("javax.xml.ws.http.request.method");
        temp.add("javax.xml.ws.http.request.headers");
        temp.add("javax.xml.ws.http.response.code");
        temp.add("javax.xml.ws.http.response.headers");
        temp.add("javax.xml.ws.http.request.pathinfo");
        temp.add("javax.xml.ws.http.request.querystring");
        temp.add("com.sun.xml.ws.client.ContentNegotiation");
        temp.add("com.sun.xml.ws.common.MtomThresholdValue");
        KNOWN_PROPERTIES = temp;
    }
}

