/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.advanced;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.options.ui.TabbedPanelModel;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;

public final class Model
extends TabbedPanelModel {
    private Map categoryToOption = new HashMap();
    private Map categoryToPanel = new HashMap();
    private Map categoryToController = new HashMap();
    private Lookup masterLookup;
    private boolean initialized = false;

    public List getCategories() {
        this.init();
        ArrayList l = new ArrayList(this.categoryToOption.keySet());
        Collections.sort(l);
        return l;
    }

    public JComponent getPanel(String category) {
        this.init();
        JComponent panel = (JComponent)this.categoryToPanel.get(category);
        if (panel != null) {
            return panel;
        }
        AdvancedOption option = (AdvancedOption)this.categoryToOption.get(category);
        OptionsPanelController controller = option.create();
        this.categoryToController.put(category, controller);
        panel = controller.getComponent(this.masterLookup);
        this.categoryToPanel.put(category, panel);
        Border b = panel.getBorder();
        b = b != null ? new CompoundBorder(new EmptyBorder(6, 16, 6, 6), b) : new EmptyBorder(6, 16, 6, 6);
        panel.setBorder(b);
        panel.setBackground(Color.white);
        panel.setMaximumSize(panel.getPreferredSize());
        return panel;
    }

    void update() {
        Iterator it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            ((OptionsPanelController)it.next()).update();
        }
    }

    void applyChanges() {
        Iterator it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            ((OptionsPanelController)it.next()).applyChanges();
        }
    }

    void cancel() {
        Iterator it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            ((OptionsPanelController)it.next()).cancel();
        }
    }

    boolean isValid() {
        Iterator it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            if (((OptionsPanelController)it.next()).isValid()) continue;
            return false;
        }
        return true;
    }

    boolean isChanged() {
        Iterator it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            if (!((OptionsPanelController)it.next()).isChanged()) continue;
            return true;
        }
        return false;
    }

    Lookup getLookup() {
        ArrayList<Lookup> lookups = new ArrayList<Lookup>();
        Iterator it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            lookups.add(((OptionsPanelController)it.next()).getLookup());
        }
        return new ProxyLookup(lookups.toArray(new Lookup[lookups.size()]));
    }

    HelpCtx getHelpCtx(JComponent panel) {
        Iterator it = this.categoryToPanel.keySet().iterator();
        while (it.hasNext()) {
            String category = (String)it.next();
            if (panel != this.categoryToPanel.get(category)) continue;
            OptionsPanelController controller = (OptionsPanelController)this.categoryToController.get(category);
            return controller.getHelpCtx();
        }
        return new HelpCtx("netbeans.optionsDialog.advanced");
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("OptionsDialog/Advanced");
        if (fo == null) {
            return;
        }
        Lookup lookup = new FolderLookup((DataObject.Container)DataFolder.findFolder((FileObject)fo)).getLookup();
        Iterator it = lookup.lookup(new Lookup.Template(AdvancedOption.class)).allInstances().iterator();
        while (it.hasNext()) {
            AdvancedOption option = (AdvancedOption)it.next();
            this.categoryToOption.put(option.getDisplayName(), option);
        }
    }

    void setLoookup(Lookup masterLookup) {
        this.masterLookup = masterLookup;
    }
}

