/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.Serializable;
import javax.enterprise.deploy.spi.Target;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerTarget;

public class ServerString
implements Serializable {
    private final String plugin;
    private final String instance;
    private final String[] targets;
    private final transient ServerInstance serverInstance;
    private transient String[] theTargets;
    private static final long serialVersionUID = 923457209372L;

    public ServerString(String plugin, String instance, String[] targets) {
        this.targets = targets == null ? new String[0] : targets;
        this.plugin = plugin;
        this.instance = instance;
        this.serverInstance = null;
    }

    public ServerString(Server server) {
        this.plugin = server.getShortName();
        this.instance = null;
        this.targets = new String[0];
        this.serverInstance = null;
    }

    public ServerString(ServerInstance instance) {
        assert (instance != null);
        this.plugin = instance.getServer().getShortName();
        this.instance = instance.getUrl();
        this.serverInstance = instance;
        this.targets = null;
    }

    public ServerString(ServerTarget target) {
        this.plugin = target.getInstance().getServer().getShortName();
        this.instance = target.getInstance().getUrl();
        this.targets = new String[]{target.getName()};
        this.serverInstance = null;
    }

    public ServerString(ServerInstance instance, String targetName) {
        this.plugin = instance.getServer().getShortName();
        this.instance = instance.getUrl();
        this.serverInstance = instance;
        this.targets = targetName != null && !"".equals(targetName.trim()) ? new String[]{targetName} : null;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public String getUrl() {
        return this.instance;
    }

    public String[] getTargets() {
        return this.getTargets(false);
    }

    public String[] getTargets(boolean concrete) {
        if (!concrete) {
            if (this.targets == null) {
                return new String[0];
            }
            return this.targets;
        }
        if (this.targets != null && this.targets.length > 0) {
            return this.targets;
        }
        if (this.theTargets != null) {
            return this.theTargets;
        }
        ServerTarget[] serverTargets = this.getServerInstance().getTargets();
        this.theTargets = new String[serverTargets.length];
        for (int i = 0; i < this.theTargets.length; ++i) {
            this.theTargets[i] = serverTargets[i].getName();
        }
        return this.theTargets;
    }

    public Server getServer() {
        return ServerRegistry.getInstance().getServer(this.plugin);
    }

    public ServerInstance getServerInstance() {
        if (this.serverInstance != null) {
            return this.serverInstance;
        }
        return ServerRegistry.getInstance().getServerInstance(this.instance);
    }

    public String toString() {
        if (this.targets == null) {
            return "Server " + this.plugin + " Instance " + this.instance + " Targets none";
        }
        return "Server " + this.plugin + " Instance " + this.instance + " Targets " + this.targets.length;
    }

    public static ServerString fromTarget(ServerInstance instance, Target target) {
        return new ServerString(new ServerTarget(instance, target));
    }

    public Target[] toTargets() {
        String[] targetNames = this.getTargets(true);
        Target[] ret = new Target[targetNames.length];
        for (int i = 0; i < targetNames.length; ++i) {
            ret[i] = this.getServerInstance().getServerTarget(targetNames[i]).getTarget();
        }
        return ret;
    }
}

