/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.config;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.XpathListener;
import org.netbeans.modules.j2ee.deployment.config.DDRoot;
import org.netbeans.modules.j2ee.deployment.config.ModuleDeploymentSupport;
import org.netbeans.modules.j2ee.deployment.config.StandardDDImpl;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BaseProperty;
import org.netbeans.modules.schema2beans.BeanProp;
import org.netbeans.modules.schema2beans.DDParser;

public abstract class DDCommon
implements DDBean {
    StandardDDImpl container;
    DDCommon parent = null;
    final BaseBean bean;
    final String xpath;
    final String dtdname;
    final ModuleDeploymentSupport support;
    final Set childBeans = new HashSet();

    DDCommon(DDCommon copy) {
        this(copy.parent, copy.bean, copy.support, copy.xpath);
    }

    DDCommon(DDCommon parent, BaseBean bean, ModuleDeploymentSupport support, String dtdname) {
        this.parent = parent;
        this.bean = bean;
        this.dtdname = dtdname;
        this.xpath = (parent == null ? "" : parent.xpath) + "/" + dtdname;
        this.support = support;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    void addChild(DDCommon bean) {
        this.childBeans.add(bean);
    }

    void removeChild(DDCommon bean) {
        this.childBeans.remove(bean);
    }

    DDCommon findChild(BaseBean bean) {
        for (DDCommon child : this.childBeans) {
            if (child.bean != bean) continue;
            return child;
        }
        return null;
    }

    public final String getXpath() {
        return this.xpath;
    }

    public final DDBeanRoot getRoot() {
        DDCommon root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        return (DDRoot)this.support.getBean(root.bean);
    }

    public final DDBean[] getChildBean(String xpath) {
        return this.getChildrenImpl(xpath);
    }

    public String getText() {
        StringWriter w = new StringWriter();
        try {
            this.bean.writeNode((Writer)w);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ((Object)w).toString();
    }

    public final String[] getText(String xpath) {
        StandardDDImpl[] dds = this.getChildrenImpl(xpath);
        if (dds == null) {
            return null;
        }
        String[] ret = new String[dds.length];
        for (int i = 0; i < dds.length; ++i) {
            ret[i] = dds[i].proxy.getText();
        }
        return ret;
    }

    private final StandardDDImpl[] getChildrenImpl(String xpath) {
        xpath = ModuleDeploymentSupport.normalizePath(xpath);
        DDCommon searchRoot = this;
        if (xpath == null || xpath.equals("") || xpath.equals(".")) {
            return new StandardDDImpl[]{this.container};
        }
        if (xpath.startsWith("/")) {
            searchRoot = ((DDRoot)this.getRoot()).proxy;
            xpath = xpath.substring(xpath.indexOf("/") + 1);
        } else {
            if (xpath.equals("..")) {
                if (this.parent == null) {
                    return null;
                }
                return new StandardDDImpl[]{this.parent.container};
            }
            while (xpath.startsWith("../") && searchRoot != null) {
                searchRoot = searchRoot.parent;
                xpath = xpath.substring(3);
            }
        }
        Collection ret = searchRoot.search(xpath, true);
        StandardDDImpl[] arr = new StandardDDImpl[ret.size()];
        ret.toArray(arr);
        return arr;
    }

    Collection search(String xpath, boolean addCurrent) {
        String fragment;
        LinkedList<StandardDDImpl> ret = new LinkedList<StandardDDImpl>();
        int index = xpath.indexOf("/");
        String string = fragment = index < 0 ? xpath : xpath.substring(0, index);
        if (this.isProxy()) {
            BeanProp prop = this.bean.beanProp(fragment);
            if (prop != null) {
                String remainder;
                String string2 = remainder = index < 0 ? "" : xpath.substring(index);
                if (prop.isIndexed()) {
                    Object[] values = prop.getValues();
                    for (int i = 0; i < values.length; ++i) {
                        DDCommon ddc = prop.isBean() ? this.support.getBean((BaseBean)((BaseBean)values[i])).proxy : this.support.getBean((BaseProperty)prop, (int)i).proxy;
                        ret.addAll(ddc.search(remainder, true));
                    }
                } else {
                    DDCommon ddc = prop.isBean() ? this.support.getBean((BaseBean)prop.getBean()).proxy : this.support.getBean((BaseProperty)prop, (int)-1).proxy;
                    ret.addAll(ddc.search(remainder, true));
                }
            }
        } else if (addCurrent) {
            DDParser parser = new DDParser(this.bean, xpath);
            while (parser.hasNext()) {
                Object current = parser.next();
                DDParser.DDLocation location = parser.getLocation();
                if (location.isNode()) {
                    BaseBean currentBean = (BaseBean)current;
                    ret.add(this.support.getBean(currentBean));
                    continue;
                }
                ret.add(this.support.getBean(location.getRoot().getProperty(location.getName()), location.getIndex()));
            }
        }
        if (index < 0) {
            return ret;
        }
        for (DDCommon ddc : this.childBeans) {
            if (!ddc.dtdname.equals(fragment)) continue;
            ret.addAll(ddc.search(xpath.substring(index), false));
        }
        return ret;
    }

    boolean isProxy() {
        return false;
    }

    public void addXpathListener(String xpath, XpathListener listener) {
        this.support.addXpathListener(this, xpath, listener);
    }

    public void removeXpathListener(String xpath, XpathListener listener) {
        this.support.removeXpathListener(this, xpath, listener);
    }

    public int hashCode() {
        return this.bean.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DDCommon) {
            return ((DDCommon)o).bean == this.bean;
        }
        return false;
    }

    public static String getRelativePath(String child, String parent) {
        String relPath = child.substring(parent.length());
        if (relPath.startsWith("/")) {
            relPath = relPath.substring(1);
        }
        return relPath;
    }

    public String[] getAttributeNames() {
        return null;
    }

    public String getAttributeValue(String name) {
        return null;
    }

    public String getId() {
        return null;
    }

    public J2eeModuleProvider getModuleProvider() {
        return this.support.getProvider();
    }
}

