/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.util.Arrays;

public final class Inet6Address
extends InetAddress {
    static final long serialVersionUID = 6880410070516793377L;
    byte[] ipaddress;

    public final boolean isMulticastAddress() {
        boolean bl = false;
        if (this.ipaddress[0] == 255) {
            bl = true;
        }
        return bl;
    }

    public final boolean isAnyLocalAddress() {
        byte[] byArray = new byte[16];
        return Arrays.equals(this.ipaddress, byArray);
    }

    public final boolean isLoopbackAddress() {
        byte[] byArray = new byte[16];
        byArray[15] = 1;
        byte[] byArray2 = byArray;
        return Arrays.equals(this.ipaddress, byArray2);
    }

    public final boolean isLinkLocalAddress() {
        boolean bl = false;
        if (this.ipaddress[0] == 250) {
            bl = true;
        }
        return bl;
    }

    public final boolean isSiteLocalAddress() {
        boolean bl = false;
        if (this.ipaddress[0] == 251) {
            bl = true;
        }
        return bl;
    }

    public final boolean isMCGlobal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        boolean bl = false;
        if ((this.ipaddress[1] & 0xF) == 14) {
            bl = true;
        }
        return bl;
    }

    public final boolean isMCNodeLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        boolean bl = false;
        if ((this.ipaddress[1] & 0xF) == 1) {
            bl = true;
        }
        return bl;
    }

    public final boolean isMCLinkLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        boolean bl = false;
        if ((this.ipaddress[1] & 0xF) == 2) {
            bl = true;
        }
        return bl;
    }

    public final boolean isMCSiteLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        boolean bl = false;
        if ((this.ipaddress[1] & 0xF) == 5) {
            bl = true;
        }
        return bl;
    }

    public final boolean isMCOrgLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        boolean bl = false;
        if ((this.ipaddress[1] & 0xF) == 8) {
            bl = true;
        }
        return bl;
    }

    public final byte[] getAddress() {
        return (byte[])this.ipaddress.clone();
    }

    public final String getHostAddress() {
        StringBuffer stringBuffer = new StringBuffer(40);
        int n = 0;
        while (n < 16) {
            int n2 = (this.ipaddress[n] & 0xFF) << 8 | this.ipaddress[n + 1] & 0xFF;
            if (n > 0) {
                stringBuffer.append(':');
            }
            stringBuffer.append(Integer.toHexString(n2));
            n += 2;
        }
        return stringBuffer.toString();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Inet6Address)) {
            return false;
        }
        return super.equals(object);
    }

    public final boolean isIPv4CompatibleAddress() {
        return this.ipaddress[0] == 0 && this.ipaddress[1] == 0 && this.ipaddress[2] == 0 && this.ipaddress[3] == 0 && this.ipaddress[4] == 0 && this.ipaddress[5] == 0 && this.ipaddress[6] == 0 && this.ipaddress[7] == 0 && this.ipaddress[8] == 0 && this.ipaddress[9] == 0 && this.ipaddress[10] == 0 && this.ipaddress[11] == 0;
    }

    Inet6Address(byte[] byArray, String string) {
        super(byArray, string);
        this.ipaddress = this.addr;
    }
}

