/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPException;
import java.awt.Dimension;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class BMPInfoHeader {
    public static final int SIZE = 40;
    public static final int BI_RGB = 0;
    public static final int BI_RLE8 = 1;
    public static final int BI_RLE4 = 2;
    public static final int BI_BITFIELDS = 3;
    protected int biSize;
    protected int biWidth;
    protected int biHeight;
    protected short biPlanes;
    protected short biBitCount;
    protected int biCompression;
    protected int biSizeImage;
    protected int biXPelsPerMeter;
    protected int biYPelsPerMeter;
    protected int biClrUsed;
    protected int biClrImportant;

    private final byte[] intToWord(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        return byArray;
    }

    private final byte[] intToDWord(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return byArray;
    }

    public void setBitCount(short s) throws BMPException {
        switch (s) {
            case 1: 
            case 4: 
            case 8: 
            case 16: 
            case 24: 
            case 32: {
                this.biBitCount = s;
                break;
            }
            default: {
                throw new BMPException("Invalid number of bits per pixel: " + s);
            }
        }
    }

    public short getBitCount() {
        return this.biBitCount;
    }

    public void setCompression(int n) throws BMPException {
        switch (n) {
            case 1: {
                if (this.getBitCount() != 8) {
                    throw new BMPException("Invalid number of bits per pixel.");
                }
                this.biCompression = n;
                break;
            }
            case 2: {
                if (this.getBitCount() != 4) {
                    throw new BMPException("Invalid number of bits per pixel.");
                }
                this.biCompression = n;
                break;
            }
            case 0: 
            case 3: {
                this.biCompression = n;
                break;
            }
            default: {
                throw new BMPException("Unknown bitmap compression type.");
            }
        }
    }

    public int getNumberOfPaletteEntries() {
        if (this.biClrUsed == 0) {
            switch (this.biBitCount) {
                case 1: {
                    return 2;
                }
                case 4: {
                    return 16;
                }
                case 8: {
                    return 256;
                }
            }
            return 0;
        }
        return this.biClrUsed;
    }

    public int getCompression() {
        return this.biCompression;
    }

    public Dimension getSize() {
        return new Dimension(this.biWidth, this.biHeight);
    }

    public int getWidth() {
        return this.biWidth;
    }

    public int getHeight() {
        return this.biHeight;
    }

    public void setSize(Dimension dimension) {
        this.biWidth = (int)dimension.getWidth();
        this.biHeight = (int)dimension.getHeight();
    }

    public BMPInfoHeader(ImageInputStream imageInputStream) throws IOException, BMPException {
        byte[] byArray = new byte[40];
        if (imageInputStream.read(byArray) != 40) {
            throw new IOException("Couldn't read header.");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n = byteBuffer.getInt();
        if (n != 40) {
            throw new BMPException("Invalid BITMAPINFOHEADER size: " + n);
        }
        this.biWidth = byteBuffer.getInt();
        this.biHeight = byteBuffer.getInt();
        this.biPlanes = byteBuffer.getShort();
        this.setBitCount(byteBuffer.getShort());
        this.setCompression(byteBuffer.getInt());
        this.biSizeImage = byteBuffer.getInt();
        this.biXPelsPerMeter = byteBuffer.getInt();
        this.biYPelsPerMeter = byteBuffer.getInt();
        this.biClrUsed = byteBuffer.getInt();
        this.biClrImportant = byteBuffer.getInt();
    }

    public BMPInfoHeader(ImageOutputStream imageOutputStream, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        ColorModel colorModel = renderedImage.getColorModel();
        this.biSize = 40;
        this.biWidth = renderedImage.getWidth();
        this.biHeight = renderedImage.getHeight();
        this.biPlanes = 1;
        if (imageWriteParam != null && imageWriteParam.canWriteCompressed()) {
            String string = imageWriteParam.getCompressionType();
            if (string.equals("BI_RLE8")) {
                this.biCompression = 1;
                this.biBitCount = (short)8;
            } else if (string.equals("BI_RLE4")) {
                this.biCompression = 2;
                this.biBitCount = (short)4;
            } else {
                this.biCompression = 0;
                this.biBitCount = (short)colorModel.getPixelSize();
            }
        } else {
            this.biBitCount = (short)colorModel.getPixelSize();
            this.biCompression = 0;
        }
        this.biCompression = 1;
        this.biBitCount = (short)8;
        this.biXPelsPerMeter = 0;
        this.biYPelsPerMeter = 0;
        this.biClrUsed = 0;
        this.biClrImportant = 0;
        this.biSizeImage = this.biWidth * this.biHeight * 3 + (4 - this.biWidth * 3 % 4) * this.biHeight;
        imageOutputStream.write(this.intToDWord(this.biSize));
        imageOutputStream.write(this.intToDWord(this.biWidth));
        imageOutputStream.write(this.intToDWord(this.biHeight));
        imageOutputStream.write(this.intToWord(this.biPlanes));
        imageOutputStream.write(this.intToWord(this.biBitCount));
        imageOutputStream.write(this.intToDWord(this.biCompression));
        imageOutputStream.write(this.intToDWord(this.biSizeImage));
        imageOutputStream.write(this.intToDWord(this.biXPelsPerMeter));
        imageOutputStream.write(this.intToDWord(this.biYPelsPerMeter));
        imageOutputStream.write(this.intToDWord(this.biClrUsed));
        imageOutputStream.write(this.intToDWord(this.biClrImportant));
    }
}

