/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;

public class ClassLoaderReferenceCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        try {
            switch (by) {
                case 1: {
                    this.executeVisibleClasses(byteBuffer, dataOutputStream);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + by + " not found in ClassLoaderReference Command Set.");
                }
            }
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return false;
    }

    public void executeVisibleClasses(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        ClassLoader classLoader = (ClassLoader)objectId.getObject();
        ArrayList arrayList = VMVirtualMachine.getLoadRequests(classLoader);
        dataOutputStream.writeInt(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            ReferenceTypeId referenceTypeId = this.idMan.getReferenceTypeId(clazz);
            referenceTypeId.writeTagged(dataOutputStream);
        }
    }
}

