/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rdocexport;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.rubypeople.rdt.internal.launching.RdtLaunchingMessages;
import org.rubypeople.rdt.internal.launching.RubyInterpreter;
import org.rubypeople.rdt.internal.launching.RubyRuntime;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.rdocexport.RdocListener;

public class RDocUtility {
    private static Set listeners = new HashSet();
    private static boolean isDebug = false;

    public static void addRdocListener(RdocListener rdocListener) {
        listeners.add(rdocListener);
    }

    public static void removeRdocListener(RdocListener rdocListener) {
        listeners.remove(rdocListener);
    }

    public static void setDebugging(boolean bl) {
        isDebug = bl;
    }

    public static void generateDocumentation(IResource iResource) {
        RubyInvoker rubyInvoker = new RubyInvoker(iResource);
        rubyInvoker.invoke();
        RDocUtility.notifyListeners();
    }

    public static void notifyListeners() {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RdocListener rdocListener = (RdocListener)iterator.next();
            rdocListener.rdocChanged();
        }
    }

    private static class RubyInvoker {
        private IResource resource;

        RubyInvoker(IResource iResource) {
            this.resource = iResource;
            this.findParentProject(iResource);
        }

        private void findParentProject(IResource iResource) {
            IResource iResource2 = iResource;
            while (!this.isProject(iResource2)) {
                if ((iResource2 = iResource2.getParent()) == null) break;
            }
            if (iResource2 != null && this.isProject(iResource2)) {
                this.resource = iResource2;
            }
        }

        private boolean isProject(IResource iResource) {
            return iResource instanceof IProject;
        }

        private void log(String string) {
            if (isDebug) {
                System.out.println(string);
            }
        }

        public final void invoke() {
            this.log("Generating RDoc for " + this.resource.getName());
            RdtLaunchingMessages.getString((String)"RdtLaunchingPlugin.noInterpreterSelected");
            RubyInterpreter rubyInterpreter = RubyRuntime.getDefault().getSelectedInterpreter();
            if (rubyInterpreter == null) {
                MessageDialog.openInformation((Shell)RubyPlugin.getActiveWorkbenchShell(), (String)RdtLaunchingMessages.getString((String)"RdtLaunchingPlugin.noInterpreterSelectedTitle"), (String)RdtLaunchingMessages.getString((String)"RdtLaunchingPlugin.noInterpreterSelected"));
                return;
            }
            Path path = new Path(RubyPlugin.getDefault().getPreferenceStore().getString("rdocDirectoryPath"));
            File file = new File(path.toOSString());
            if (!file.exists() || !file.isFile()) {
                MessageDialog.openError((Shell)RubyPlugin.getActiveWorkbenchShell(), (String)RubyUIMessages.getString("RDocPathErrorTitle"), (String)RubyUIMessages.getString("RDocPathError"));
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(path.toString());
            arrayList.add("-r");
            arrayList.add(this.resource.getLocation().toOSString());
            try {
                Process process = rubyInterpreter.exec(arrayList, null);
                this.handleOutput(process, arrayList);
            }
            catch (CoreException coreException) {
                RubyPlugin.log(coreException);
                this.log(coreException.getMessage());
                ErrorDialog.openError((Shell)RubyPlugin.getActiveWorkbenchShell(), (String)RubyUIMessages.getString("ErrorRunningRdocTitle"), (String)coreException.getMessage(), (IStatus)new StatusInfo(4, coreException.getMessage()));
            }
        }

        private void handleOutput(Process process, List list) {
            String string;
            BufferedReader bufferedReader = null;
            String string2 = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    this.log(string);
                    string2 = string;
                }
            }
            catch (Exception exception) {
                this.log(exception.getMessage());
            }
            try {
                process.waitFor();
                if (process.exitValue() != 0) {
                    string = RubyUIMessages.getFormattedString("RDocExecutionError", Integer.toString(process.exitValue()));
                    String string3 = null;
                    string3 = string2 != null ? RubyUIMessages.getFormattedString("RDocExecutionErrorAdditionalMessageWithStderr", new String[]{list.toString(), string2}) : RubyUIMessages.getFormattedString("RDocExecutionErrorAdditionalMessage", list.toString());
                    String string4 = RubyUIMessages.getFormattedString("RDocExecutionErrorTitle", Integer.toString(process.exitValue()));
                    ErrorDialog.openError((Shell)RubyPlugin.getActiveWorkbenchShell(), (String)string4, (String)string, (IStatus)new StatusInfo(4, string3));
                }
            }
            catch (InterruptedException interruptedException) {
                this.log("InterruptedException while waiting for rdoc process to finish." + interruptedException.getMessage());
            }
            this.log("Done generating RDoc");
        }
    }
}

