/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.core.parsing;

import java.io.IOException;
import org.rubypeople.rdt.internal.debug.core.BreakpointSuspensionPoint;
import org.rubypeople.rdt.internal.debug.core.ExceptionSuspensionPoint;
import org.rubypeople.rdt.internal.debug.core.StepSuspensionPoint;
import org.rubypeople.rdt.internal.debug.core.SuspensionPoint;
import org.rubypeople.rdt.internal.debug.core.parsing.AbstractReadStrategy;
import org.rubypeople.rdt.internal.debug.core.parsing.XmlStreamReader;
import org.rubypeople.rdt.internal.debug.core.parsing.XmlStreamReaderException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SuspensionReader
extends XmlStreamReader {
    private SuspensionPoint suspensionPoint;

    public SuspensionReader(XmlPullParser xmlPullParser) {
        super(xmlPullParser);
    }

    public SuspensionReader(AbstractReadStrategy abstractReadStrategy) {
        super(abstractReadStrategy);
    }

    public SuspensionPoint readSuspension() throws XmlPullParserException, IOException, XmlStreamReaderException {
        this.read();
        return this.suspensionPoint;
    }

    protected boolean processStartElement(XmlPullParser xmlPullParser) throws XmlStreamReaderException {
        String string = xmlPullParser.getName();
        if (string.equals("breakpoint")) {
            this.suspensionPoint = new BreakpointSuspensionPoint();
        } else if (string.equals("exception")) {
            ExceptionSuspensionPoint exceptionSuspensionPoint = new ExceptionSuspensionPoint();
            exceptionSuspensionPoint.setExceptionMessage(xmlPullParser.getAttributeValue("", "message"));
            exceptionSuspensionPoint.setExceptionType(xmlPullParser.getAttributeValue("", "type"));
            this.suspensionPoint = exceptionSuspensionPoint;
        } else if (string.equals("suspended")) {
            StepSuspensionPoint stepSuspensionPoint = new StepSuspensionPoint();
            stepSuspensionPoint.setFramesNumber(Integer.parseInt(xmlPullParser.getAttributeValue("", "frames")));
            this.suspensionPoint = stepSuspensionPoint;
        } else {
            return false;
        }
        this.suspensionPoint.setLine(Integer.parseInt(xmlPullParser.getAttributeValue("", "line")));
        this.suspensionPoint.setFile(xmlPullParser.getAttributeValue("", "file"));
        this.suspensionPoint.setThreadId(Integer.parseInt(xmlPullParser.getAttributeValue("", "threadId")));
        return true;
    }
}

