/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.LineBreakpoint;

public class RubyLineBreakpoint
extends LineBreakpoint {
    protected static final String RUBY_BREAKPOINT_MARKER = "org.rubypeople.rdt.debug.core.RubyBreakpointMarker";

    public RubyLineBreakpoint(final IResource iResource, final int n) throws CoreException {
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                RubyLineBreakpoint.this.setMarker(iResource.createMarker(RubyLineBreakpoint.RUBY_BREAKPOINT_MARKER));
                RubyLineBreakpoint.this.getMarker().setAttribute("lineNumber", n + 1);
                RubyLineBreakpoint.this.getMarker().setAttribute("org.eclipse.debug.core.registered", false);
                RubyLineBreakpoint.this.setRegistered(true);
                RubyLineBreakpoint.this.setEnabled(true);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, null);
        }
        catch (CoreException coreException) {
            throw new DebugException(coreException.getStatus());
        }
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public static String getMarkerType() {
        return RUBY_BREAKPOINT_MARKER;
    }

    public String getModelIdentifier() {
        return "org.rubypeople.rdt.debug";
    }
}

