require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__MACHINE_MVME188_H__)) {
    eval 'sub __MACHINE_MVME188_H__ () {1;}' unless defined(&__MACHINE_MVME188_H__);
    eval 'sub MVME188_EPROM () {0xffc00000;}' unless defined(&MVME188_EPROM);
    eval 'sub MVME188_EPROM_SIZE () {0x80000;}' unless defined(&MVME188_EPROM_SIZE);
    eval 'sub MVME188_SRAM () {0xffe00000;}' unless defined(&MVME188_SRAM);
    eval 'sub MVME188_SRAM_SIZE () {0x20000;}' unless defined(&MVME188_SRAM_SIZE);
    eval 'sub MVME188_UTILITY () {0xfff00000;}' unless defined(&MVME188_UTILITY);
    eval 'sub MVME188_UTILITY_SIZE () {0x90000;}' unless defined(&MVME188_UTILITY_SIZE);
    eval 'sub MVME188_IENBASE () {0xfff84000;}' unless defined(&MVME188_IENBASE);
    eval 'sub MVME188_IEN0 () {0xfff84004;}' unless defined(&MVME188_IEN0);
    eval 'sub MVME188_IEN1 () {0xfff84008;}' unless defined(&MVME188_IEN1);
    eval 'sub MVME188_IEN2 () {0xfff84010;}' unless defined(&MVME188_IEN2);
    eval 'sub MVME188_IEN3 () {0xfff84020;}' unless defined(&MVME188_IEN3);
    eval 'sub MVME188_IENALL () {0xfff8403c;}' unless defined(&MVME188_IENALL);
    eval 'sub MVME188_IEN {
        my($cpu) = @_;
	    eval q(( &MVME188_IENBASE + (4<< ($cpu))));
    }' unless defined(&MVME188_IEN);
    eval 'sub MVME188_IST () {0xfff84040;}' unless defined(&MVME188_IST);
    eval 'sub MVME188_SETSWI () {0xfff84080;}' unless defined(&MVME188_SETSWI);
    eval 'sub MVME188_CLRSWI () {0xfff84084;}' unless defined(&MVME188_CLRSWI);
    eval 'sub MVME188_ISTATE () {0xfff84088;}' unless defined(&MVME188_ISTATE);
    eval 'sub MVME188_CLRINT () {0xfff8408c;}' unless defined(&MVME188_CLRINT);
    eval 'sub MVME188_VIRQLV () {0xfff85000;}' unless defined(&MVME188_VIRQLV);
    eval 'sub MVME188_VIACK1V () {0xfff85004;}' unless defined(&MVME188_VIACK1V);
    eval 'sub MVME188_VIACK2V () {0xfff85008;}' unless defined(&MVME188_VIACK2V);
    eval 'sub MVME188_VIACK3V () {0xfff8500c;}' unless defined(&MVME188_VIACK3V);
    eval 'sub MVME188_VIACK4V () {0xfff85010;}' unless defined(&MVME188_VIACK4V);
    eval 'sub MVME188_VIACK5V () {0xfff85014;}' unless defined(&MVME188_VIACK5V);
    eval 'sub MVME188_VIACK6V () {0xfff85018;}' unless defined(&MVME188_VIACK6V);
    eval 'sub MVME188_VIACK7V () {0xfff8501c;}' unless defined(&MVME188_VIACK7V);
    eval 'sub MVME188_VIRQV () {0xfff85020;}' unless defined(&MVME188_VIRQV);
    eval 'sub M188_IVEC () {0x40;}' unless defined(&M188_IVEC);
    eval 'sub MVME188_GLOBAL0 () {0xfff86001;}' unless defined(&MVME188_GLOBAL0);
    eval 'sub MVME188_GLOBAL1 () {0xfff86003;}' unless defined(&MVME188_GLOBAL1);
    eval 'sub M188_LRST () {0x80;}' unless defined(&M188_LRST);
    eval 'sub M188_SYSCON () {0x40;}' unless defined(&M188_SYSCON);
    eval 'sub MVME188_BRDID () {0xfff86005;}' unless defined(&MVME188_BRDID);
    eval 'sub MVME188_CGCSR0 () {0xfff86007;}' unless defined(&MVME188_CGCSR0);
    eval 'sub MVME188_CGCSR1 () {0xfff86009;}' unless defined(&MVME188_CGCSR1);
    eval 'sub MVME188_CGCSR2 () {0xfff8600b;}' unless defined(&MVME188_CGCSR2);
    eval 'sub MVME188_CGCSR3 () {0xfff8600d;}' unless defined(&MVME188_CGCSR3);
    eval 'sub MVME188_CGCSR4 () {0xfff8600f;}' unless defined(&MVME188_CGCSR4);
    eval 'sub MVME188_UCSR () {0xfff87000;}' unless defined(&MVME188_UCSR);
    eval 'sub MVME188_BASAD () {0xfff87004;}' unless defined(&MVME188_BASAD);
    eval 'sub MVME188_GLBRES () {0xfff8700c;}' unless defined(&MVME188_GLBRES);
    eval 'sub MVME188_CCSR () {0xfff88000;}' unless defined(&MVME188_CCSR);
    eval 'sub MVME188_ERROR () {0xfff88004;}' unless defined(&MVME188_ERROR);
    eval 'sub MVME188_PCNFA () {0xfff88008;}' unless defined(&MVME188_PCNFA);
    eval 'sub MVME188_PCNFB () {0xfff8800c;}' unless defined(&MVME188_PCNFB);
    eval 'sub MVME188_EXTAD () {0xfff88010;}' unless defined(&MVME188_EXTAD);
    eval 'sub MVME188_WHOAMI () {0xfff88018;}' unless defined(&MVME188_WHOAMI);
    eval 'sub MVME188_WMAD () {0xfff88020;}' unless defined(&MVME188_WMAD);
    eval 'sub MVME188_RMAD () {0xfff88024;}' unless defined(&MVME188_RMAD);
    eval 'sub MVME188_WVAD () {0xfff88028;}' unless defined(&MVME188_WVAD);
    eval 'sub MVME188_RVAD () {0xfff8802c;}' unless defined(&MVME188_RVAD);
    eval 'sub IRQ_ABORT () {0x80000000;}' unless defined(&IRQ_ABORT);
    eval 'sub IRQ_ACF () {0x40000000;}' unless defined(&IRQ_ACF);
    eval 'sub IRQ_ARBTO () {0x20000000;}' unless defined(&IRQ_ARBTO);
    eval 'sub IRQ_DTI () {0x10000000;}' unless defined(&IRQ_DTI);
    eval 'sub IRQ_SWI7 () {0x8000000;}' unless defined(&IRQ_SWI7);
    eval 'sub IRQ_SWI6 () {0x4000000;}' unless defined(&IRQ_SWI6);
    eval 'sub IRQ_SWI5 () {0x2000000;}' unless defined(&IRQ_SWI5);
    eval 'sub IRQ_SWI4 () {0x1000000;}' unless defined(&IRQ_SWI4);
    eval 'sub IRQ_VME7 () {0x800000;}' unless defined(&IRQ_VME7);
    eval 'sub IRQ_CIOI () {0x200000;}' unless defined(&IRQ_CIOI);
    eval 'sub IRQ_SF () {0x100000;}' unless defined(&IRQ_SF);
    eval 'sub IRQ_VME6 () {0x80000;}' unless defined(&IRQ_VME6);
    eval 'sub IRQ_DI () {0x20000;}' unless defined(&IRQ_DI);
    eval 'sub IRQ_SIGHPI () {0x10000;}' unless defined(&IRQ_SIGHPI);
    eval 'sub IRQ_VME5 () {0x4000;}' unless defined(&IRQ_VME5);
    eval 'sub IRQ_VME4 () {0x1000;}' unless defined(&IRQ_VME4);
    eval 'sub IRQ_VME3 () {0x400;}' unless defined(&IRQ_VME3);
    eval 'sub IRQ_LMI () {0x100;}' unless defined(&IRQ_LMI);
    eval 'sub IRQ_SIGLPI () {0x80;}' unless defined(&IRQ_SIGLPI);
    eval 'sub IRQ_VME2 () {0x40;}' unless defined(&IRQ_VME2);
    eval 'sub IRQ_VME1 () {0x10;}' unless defined(&IRQ_VME1);
    eval 'sub IRQ_SWI3 () {0x8;}' unless defined(&IRQ_SWI3);
    eval 'sub IRQ_SWI2 () {0x4;}' unless defined(&IRQ_SWI2);
    eval 'sub IRQ_SWI1 () {0x2;}' unless defined(&IRQ_SWI1);
    eval 'sub IRQ_SWI0 () {0x1;}' unless defined(&IRQ_SWI0);
    eval 'sub IST_STRING () {"\\20" "\\40ABRT\\37ACF\\36ARBTO\\35DTI\\34SWI7\\33SWI6\\32SWI5\\31SWI4" "\\30IRQ7\\26CIOI\\25SF\\24IRQ6\\22DI\\21SIGHPI" "\\17IRQ5\\15IRQ4\\13IRQ3\\11LMI" "\\10SIGLPI\\7IRQ2\\5IRQ1\\4SWI3\\3SWI2\\2SWI1\\1SWI0";}' unless defined(&IST_STRING);
    eval 'sub CLOCK_IPI_MASK () {( &IRQ_SWI7 |  &IRQ_SWI6 |  &IRQ_SWI5 |  &IRQ_SWI4);}' unless defined(&CLOCK_IPI_MASK);
    eval 'sub IPI_MASK () {( &IRQ_SWI3 |  &IRQ_SWI2 |  &IRQ_SWI1 |  &IRQ_SWI0);}' unless defined(&IPI_MASK);
    eval 'sub ISR_GET_CURRENT_MASK {
        my($cpu) = @_;
	    eval q((*( &volatile \'u_int\' *) &MVME188_IST &  $int_mask_reg[$cpu]));
    }' unless defined(&ISR_GET_CURRENT_MASK);
    eval 'sub SWI_IPI_BIT {
        my($cpuid) = @_;
	    eval q((0x1 << ($cpuid)));
    }' unless defined(&SWI_IPI_BIT);
    eval 'sub SWI_CLOCK_IPI_BIT {
        my($cpuid) = @_;
	    eval q((0x10 << ($cpuid)));
    }' unless defined(&SWI_CLOCK_IPI_BIT);
    eval 'sub SWI_IPI_MASK {
        my($cpuid) = @_;
	    eval q(( &IRQ_SWI0 << ($cpuid)));
    }' unless defined(&SWI_IPI_MASK);
    eval 'sub SWI_CLOCK_IPI_MASK {
        my($cpuid) = @_;
	    eval q(( &IRQ_SWI4 << ($cpuid)));
    }' unless defined(&SWI_CLOCK_IPI_MASK);
    eval 'sub ISTATE_ABORT () {0x4;}' unless defined(&ISTATE_ABORT);
    eval 'sub ISTATE_ACFAIL () {0x2;}' unless defined(&ISTATE_ACFAIL);
    eval 'sub ISTATE_SYSFAIL () {0x1;}' unless defined(&ISTATE_SYSFAIL);
    eval 'sub UCSR_PWRUPBIT () {0x4000;}' unless defined(&UCSR_PWRUPBIT);
    eval 'sub UCSR_DRVSFBIT () {0x2000;}' unless defined(&UCSR_DRVSFBIT);
    eval 'sub UCSR_BRIRQBIT () {0x1000;}' unless defined(&UCSR_BRIRQBIT);
    eval 'sub UCSR_ROBINBIT () {0x800;}' unless defined(&UCSR_ROBINBIT);
    eval 'sub UCSR_BRLVBITS () {0x600;}' unless defined(&UCSR_BRLVBITS);
    eval 'sub UCSR_RNEVERBIT () {0x100;}' unless defined(&UCSR_RNEVERBIT);
    eval 'sub UCSR_RONRBIT () {0x80;}' unless defined(&UCSR_RONRBIT);
    eval 'sub UCSR_RWDBIT () {0x40;}' unless defined(&UCSR_RWDBIT);
    eval 'sub UCSR_EARBTOBIT () {0x20;}' unless defined(&UCSR_EARBTOBIT);
    eval 'sub VTOSELBITS () {0x18;}' unless defined(&VTOSELBITS);
    eval 'sub VTO32US () {0x;}' unless defined(&VTO32US);
    eval 'sub VTO64US () {0x1;}' unless defined(&VTO64US);
    eval 'sub VTO128US () {0x10;}' unless defined(&VTO128US);
    eval 'sub VTODISABLE () {0x18;}' unless defined(&VTODISABLE);
    eval 'sub CIO_BASE () {0xfff83000;}' unless defined(&CIO_BASE);
    eval 'sub CIO_PORTC () {0xfff83000;}' unless defined(&CIO_PORTC);
    eval 'sub CIO_PORTB () {0xfff83004;}' unless defined(&CIO_PORTB);
    eval 'sub CIO_PORTA () {0xfff83008;}' unless defined(&CIO_PORTA);
    eval 'sub CIO_CTRL () {0xfff8300c;}' unless defined(&CIO_CTRL);
    eval 'sub DART_BASE () {0xfff82000;}' unless defined(&DART_BASE);
    eval 'sub VME_CMMU_I0 () {0xfff7e000;}' unless defined(&VME_CMMU_I0);
    eval 'sub VME_CMMU_I1 () {0xfff7d000;}' unless defined(&VME_CMMU_I1);
    eval 'sub VME_CMMU_I2 () {0xfff7b000;}' unless defined(&VME_CMMU_I2);
    eval 'sub VME_CMMU_I3 () {0xfff77000;}' unless defined(&VME_CMMU_I3);
    eval 'sub VME_CMMU_D0 () {0xfff6f000;}' unless defined(&VME_CMMU_D0);
    eval 'sub VME_CMMU_D1 () {0xfff5f000;}' unless defined(&VME_CMMU_D1);
    eval 'sub VME_CMMU_D2 () {0xfff3f000;}' unless defined(&VME_CMMU_D2);
    eval 'sub VME_CMMU_D3 () {0xfff7f000;}' unless defined(&VME_CMMU_D3);
    if(defined( &_KERNEL)  && !defined( &_LOCORE)) {
    }
}
1;
