require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&WPI_TX_RING_COUNT)) {
    sub WPI_TX_RING_COUNT () {	256;}
}
unless(defined(&WPI_TX_RING_LOMARK)) {
    sub WPI_TX_RING_LOMARK () {	192;}
}
unless(defined(&WPI_TX_RING_HIMARK)) {
    sub WPI_TX_RING_HIMARK () {	224;}
}
unless(defined(&WPI_RX_RING_COUNT_LOG)) {
    sub WPI_RX_RING_COUNT_LOG () {	6;}
}
unless(defined(&WPI_RX_RING_COUNT)) {
    sub WPI_RX_RING_COUNT () {	(1<<  &WPI_RX_RING_COUNT_LOG);}
}
unless(defined(&WPI_NTXQUEUES)) {
    sub WPI_NTXQUEUES () {	8;}
}
unless(defined(&WPI_NDMACHNLS)) {
    sub WPI_NDMACHNLS () {	6;}
}
unless(defined(&WPI_MAX_SCATTER)) {
    sub WPI_MAX_SCATTER () {	4;}
}
unless(defined(&WPI_RBUF_SIZE)) {
    sub WPI_RBUF_SIZE () {	(3* 1024);}
}
unless(defined(&WPI_PCI_BAR0)) {
    sub WPI_PCI_BAR0 () {	 &PCI_MAPREG_START;}
}
unless(defined(&WPI_HW_IF_CONFIG)) {
    sub WPI_HW_IF_CONFIG () {	0x;}
}
unless(defined(&WPI_INT)) {
    sub WPI_INT () {	0x8;}
}
unless(defined(&WPI_MASK)) {
    sub WPI_MASK () {	0xc;}
}
unless(defined(&WPI_FH_INT)) {
    sub WPI_FH_INT () {	0x10;}
}
unless(defined(&WPI_GPIO_IN)) {
    sub WPI_GPIO_IN () {	0x18;}
}
unless(defined(&WPI_RESET)) {
    sub WPI_RESET () {	0x20;}
}
unless(defined(&WPI_GP_CNTRL)) {
    sub WPI_GP_CNTRL () {	0x24;}
}
unless(defined(&WPI_EEPROM)) {
    sub WPI_EEPROM () {	0x2c;}
}
unless(defined(&WPI_EEPROM_GP)) {
    sub WPI_EEPROM_GP () {	0x30;}
}
unless(defined(&WPI_UCODE_GP1_CLR)) {
    sub WPI_UCODE_GP1_CLR () {	0x5c;}
}
unless(defined(&WPI_UCODE_GP2)) {
    sub WPI_UCODE_GP2 () {	0x60;}
}
unless(defined(&WPI_GIO_CHICKEN)) {
    sub WPI_GIO_CHICKEN () {	0x100;}
}
unless(defined(&WPI_ANA_PLL)) {
    sub WPI_ANA_PLL () {	0x20c;}
}
unless(defined(&WPI_MEM_RADDR)) {
    sub WPI_MEM_RADDR () {	0x40c;}
}
unless(defined(&WPI_MEM_WADDR)) {
    sub WPI_MEM_WADDR () {	0x410;}
}
unless(defined(&WPI_MEM_WDATA)) {
    sub WPI_MEM_WDATA () {	0x418;}
}
unless(defined(&WPI_MEM_RDATA)) {
    sub WPI_MEM_RDATA () {	0x41c;}
}
unless(defined(&WPI_PRPH_WADDR)) {
    sub WPI_PRPH_WADDR () {	0x444;}
}
unless(defined(&WPI_PRPH_RADDR)) {
    sub WPI_PRPH_RADDR () {	0x448;}
}
unless(defined(&WPI_PRPH_WDATA)) {
    sub WPI_PRPH_WDATA () {	0x44c;}
}
unless(defined(&WPI_PRPH_RDATA)) {
    sub WPI_PRPH_RDATA () {	0x450;}
}
unless(defined(&WPI_HBUS_TARG_WRPTR)) {
    sub WPI_HBUS_TARG_WRPTR () {	0x460;}
}
unless(defined(&WPI_FH_CBBC_CTRL)) {
    sub WPI_FH_CBBC_CTRL {
	my($qid) = @_;
	eval q((0x940 + ($qid) * 8));
    }
}
unless(defined(&WPI_FH_CBBC_BASE)) {
    sub WPI_FH_CBBC_BASE {
	my($qid) = @_;
	eval q((0x944 + ($qid) * 8));
    }
}
unless(defined(&WPI_FH_RX_CONFIG)) {
    sub WPI_FH_RX_CONFIG () {	0xc00;}
}
unless(defined(&WPI_FH_RX_BASE)) {
    sub WPI_FH_RX_BASE () {	0xc04;}
}
unless(defined(&WPI_FH_RX_WPTR)) {
    sub WPI_FH_RX_WPTR () {	0xc20;}
}
unless(defined(&WPI_FH_RX_RPTR_ADDR)) {
    sub WPI_FH_RX_RPTR_ADDR () {	0xc24;}
}
unless(defined(&WPI_FH_RSSR_TBL)) {
    sub WPI_FH_RSSR_TBL () {	0xcc0;}
}
unless(defined(&WPI_FH_RX_STATUS)) {
    sub WPI_FH_RX_STATUS () {	0xcc4;}
}
unless(defined(&WPI_FH_TX_CONFIG)) {
    sub WPI_FH_TX_CONFIG {
	my($qid) = @_;
	eval q((0xd00 + ($qid) * 32));
    }
}
unless(defined(&WPI_FH_TX_BASE)) {
    sub WPI_FH_TX_BASE () {	0xe80;}
}
unless(defined(&WPI_FH_MSG_CONFIG)) {
    sub WPI_FH_MSG_CONFIG () {	0xe88;}
}
unless(defined(&WPI_FH_TX_STATUS)) {
    sub WPI_FH_TX_STATUS () {	0xe90;}
}
unless(defined(&WPI_ALM_SCHED_MODE)) {
    sub WPI_ALM_SCHED_MODE () {	0x2e00;}
}
unless(defined(&WPI_ALM_SCHED_ARASTAT)) {
    sub WPI_ALM_SCHED_ARASTAT () {	0x2e04;}
}
unless(defined(&WPI_ALM_SCHED_TXFACT)) {
    sub WPI_ALM_SCHED_TXFACT () {	0x2e10;}
}
unless(defined(&WPI_ALM_SCHED_TXF4MF)) {
    sub WPI_ALM_SCHED_TXF4MF () {	0x2e14;}
}
unless(defined(&WPI_ALM_SCHED_TXF5MF)) {
    sub WPI_ALM_SCHED_TXF5MF () {	0x2e20;}
}
unless(defined(&WPI_ALM_SCHED_SBYPASS_MODE1)) {
    sub WPI_ALM_SCHED_SBYPASS_MODE1 () {	0x2e2c;}
}
unless(defined(&WPI_ALM_SCHED_SBYPASS_MODE2)) {
    sub WPI_ALM_SCHED_SBYPASS_MODE2 () {	0x2e30;}
}
unless(defined(&WPI_APMG_CLK_ENA)) {
    sub WPI_APMG_CLK_ENA () {	0x3004;}
}
unless(defined(&WPI_APMG_CLK_DIS)) {
    sub WPI_APMG_CLK_DIS () {	0x3008;}
}
unless(defined(&WPI_APMG_RFKILL)) {
    sub WPI_APMG_RFKILL () {	0x3014;}
}
unless(defined(&WPI_APMG_PS)) {
    sub WPI_APMG_PS () {	0x300c;}
}
unless(defined(&WPI_APMG_PCI_STT)) {
    sub WPI_APMG_PCI_STT () {	0x3010;}
}
unless(defined(&WPI_BSM_WR_CTRL)) {
    sub WPI_BSM_WR_CTRL () {	0x3400;}
}
unless(defined(&WPI_BSM_WR_MEM_SRC)) {
    sub WPI_BSM_WR_MEM_SRC () {	0x3404;}
}
unless(defined(&WPI_BSM_WR_MEM_DST)) {
    sub WPI_BSM_WR_MEM_DST () {	0x3408;}
}
unless(defined(&WPI_BSM_WR_DWCOUNT)) {
    sub WPI_BSM_WR_DWCOUNT () {	0x340c;}
}
unless(defined(&WPI_BSM_SRAM_BASE)) {
    sub WPI_BSM_SRAM_BASE () {	0x3800;}
}
unless(defined(&WPI_BSM_DRAM_TEXT_ADDR)) {
    sub WPI_BSM_DRAM_TEXT_ADDR () {	0x3490;}
}
unless(defined(&WPI_BSM_DRAM_TEXT_SIZE)) {
    sub WPI_BSM_DRAM_TEXT_SIZE () {	0x3494;}
}
unless(defined(&WPI_BSM_DRAM_DATA_ADDR)) {
    sub WPI_BSM_DRAM_DATA_ADDR () {	0x3498;}
}
unless(defined(&WPI_BSM_DRAM_DATA_SIZE)) {
    sub WPI_BSM_DRAM_DATA_SIZE () {	0x349c;}
}
unless(defined(&WPI_HW_IF_CONFIG_ALM_MB)) {
    sub WPI_HW_IF_CONFIG_ALM_MB () {	(1<< 8);}
}
unless(defined(&WPI_HW_IF_CONFIG_ALM_MM)) {
    sub WPI_HW_IF_CONFIG_ALM_MM () {	(1<< 9);}
}
unless(defined(&WPI_HW_IF_CONFIG_SKU_MRC)) {
    sub WPI_HW_IF_CONFIG_SKU_MRC () {	(1<< 10);}
}
unless(defined(&WPI_HW_IF_CONFIG_REV_D)) {
    sub WPI_HW_IF_CONFIG_REV_D () {	(1<< 11);}
}
unless(defined(&WPI_HW_IF_CONFIG_TYPE_B)) {
    sub WPI_HW_IF_CONFIG_TYPE_B () {	(1<< 12);}
}
unless(defined(&WPI_PRPH_DWORD)) {
    sub WPI_PRPH_DWORD () {	(($sizeof{ &uint32_t} - 1) << 24);}
}
unless(defined(&WPI_FW_TEXT_BASE)) {
    sub WPI_FW_TEXT_BASE () {	0x;}
}
unless(defined(&WPI_FW_DATA_BASE)) {
    sub WPI_FW_DATA_BASE () {	0x800000;}
}
unless(defined(&WPI_GPIO_IN_VMAIN)) {
    sub WPI_GPIO_IN_VMAIN () {	(1<< 9);}
}
unless(defined(&WPI_RESET_NEVO)) {
    sub WPI_RESET_NEVO () {	(1<< 0);}
}
unless(defined(&WPI_RESET_SW)) {
    sub WPI_RESET_SW () {	(1<< 7);}
}
unless(defined(&WPI_RESET_MASTER_DISABLED)) {
    sub WPI_RESET_MASTER_DISABLED () {	(1<< 8);}
}
unless(defined(&WPI_RESET_STOP_MASTER)) {
    sub WPI_RESET_STOP_MASTER () {	(1<< 9);}
}
unless(defined(&WPI_GP_CNTRL_MAC_CLOCK_READY)) {
    sub WPI_GP_CNTRL_MAC_CLOCK_READY () {	(1<< 0);}
}
unless(defined(&WPI_GP_CNTRL_MAC_ACCESS_ENA)) {
    sub WPI_GP_CNTRL_MAC_ACCESS_ENA () {	(1<< 0);}
}
unless(defined(&WPI_GP_CNTRL_INIT_DONE)) {
    sub WPI_GP_CNTRL_INIT_DONE () {	(1<< 2);}
}
unless(defined(&WPI_GP_CNTRL_MAC_ACCESS_REQ)) {
    sub WPI_GP_CNTRL_MAC_ACCESS_REQ () {	(1<< 3);}
}
unless(defined(&WPI_GP_CNTRL_SLEEP)) {
    sub WPI_GP_CNTRL_SLEEP () {	(1<< 4);}
}
unless(defined(&WPI_GP_CNTRL_PS_MASK)) {
    sub WPI_GP_CNTRL_PS_MASK () {	(7<< 24);}
}
unless(defined(&WPI_GP_CNTRL_MAC_PS)) {
    sub WPI_GP_CNTRL_MAC_PS () {	(4<< 24);}
}
unless(defined(&WPI_GP_CNTRL_RFKILL)) {
    sub WPI_GP_CNTRL_RFKILL () {	(1<< 27);}
}
unless(defined(&WPI_GIO_CHICKEN_L1A_NO_L0S_RX)) {
    sub WPI_GIO_CHICKEN_L1A_NO_L0S_RX () {	(1<< 23);}
}
unless(defined(&WPI_FH_RX_CONFIG_DMA_ENA)) {
    sub WPI_FH_RX_CONFIG_DMA_ENA () {	(1<< 31);}
}
unless(defined(&WPI_FH_RX_CONFIG_RDRBD_ENA)) {
    sub WPI_FH_RX_CONFIG_RDRBD_ENA () {	(1<< 29);}
}
unless(defined(&WPI_FH_RX_CONFIG_WRSTATUS_ENA)) {
    sub WPI_FH_RX_CONFIG_WRSTATUS_ENA () {	(1<< 27);}
}
unless(defined(&WPI_FH_RX_CONFIG_MAXFRAG)) {
    sub WPI_FH_RX_CONFIG_MAXFRAG () {	(1<< 24);}
}
unless(defined(&WPI_FH_RX_CONFIG_NRBD)) {
    sub WPI_FH_RX_CONFIG_NRBD {
	my($x) = @_;
	eval q((($x) << 20));
    }
}
unless(defined(&WPI_FH_RX_CONFIG_IRQ_DST_HOST)) {
    sub WPI_FH_RX_CONFIG_IRQ_DST_HOST () {	(1<< 12);}
}
unless(defined(&WPI_FH_RX_CONFIG_IRQ_RBTH)) {
    sub WPI_FH_RX_CONFIG_IRQ_RBTH {
	my($x) = @_;
	eval q((($x) << 4));
    }
}
unless(defined(&WPI_ANA_PLL_INIT)) {
    sub WPI_ANA_PLL_INIT () {	(1<< 24);}
}
unless(defined(&WPI_UCODE_GP1_RFKILL)) {
    sub WPI_UCODE_GP1_RFKILL () {	(1<< 1);}
}
unless(defined(&WPI_UCODE_GP1_CMD_BLOCKED)) {
    sub WPI_UCODE_GP1_CMD_BLOCKED () {	(1<< 2);}
}
unless(defined(&WPI_FH_RX_STATUS_IDLE)) {
    sub WPI_FH_RX_STATUS_IDLE () {	(1<< 24);}
}
unless(defined(&WPI_BSM_WR_CTRL_START_EN)) {
    sub WPI_BSM_WR_CTRL_START_EN () {	(1<< 30);}
}
unless(defined(&WPI_BSM_WR_CTRL_START)) {
    sub WPI_BSM_WR_CTRL_START () {	(1<< 31);}
}
unless(defined(&WPI_INT_ALIVE)) {
    sub WPI_INT_ALIVE () {	(1<< 0);}
}
unless(defined(&WPI_INT_WAKEUP)) {
    sub WPI_INT_WAKEUP () {	(1<< 1);}
}
unless(defined(&WPI_INT_SW_RX)) {
    sub WPI_INT_SW_RX () {	(1<< 3);}
}
unless(defined(&WPI_INT_RF_TOGGLED)) {
    sub WPI_INT_RF_TOGGLED () {	(1<< 7);}
}
unless(defined(&WPI_INT_SW_ERR)) {
    sub WPI_INT_SW_ERR () {	(1<< 25);}
}
unless(defined(&WPI_INT_FH_TX)) {
    sub WPI_INT_FH_TX () {	(1<< 27);}
}
unless(defined(&WPI_INT_HW_ERR)) {
    sub WPI_INT_HW_ERR () {	(1<< 29);}
}
unless(defined(&WPI_INT_FH_RX)) {
    sub WPI_INT_FH_RX () {	(1<< 31);}
}
unless(defined(&WPI_INT_MASK)) {
    sub WPI_INT_MASK () {	( &WPI_INT_SW_ERR |  &WPI_INT_HW_ERR |  &WPI_INT_FH_TX |  &WPI_INT_FH_RX |  &WPI_INT_ALIVE |  &WPI_INT_WAKEUP |  &WPI_INT_SW_RX |  &WPI_INT_RF_TOGGLED);}
}
unless(defined(&WPI_FH_INT_RX_CHNL)) {
    sub WPI_FH_INT_RX_CHNL {
	my($x) = @_;
	eval q((1<< (($x) + 16)));
    }
}
unless(defined(&WPI_FH_INT_HI_PRIOR)) {
    sub WPI_FH_INT_HI_PRIOR () {	(1<< 30);}
}
unless(defined(&WPI_FH_INT_RX)) {
    sub WPI_FH_INT_RX () {	( &WPI_FH_INT_RX_CHNL(0) |  &WPI_FH_INT_RX_CHNL(1) |  &WPI_FH_INT_RX_CHNL(2) |  &WPI_FH_INT_HI_PRIOR);}
}
unless(defined(&WPI_FH_TX_STATUS_IDLE)) {
    sub WPI_FH_TX_STATUS_IDLE {
	my($qid) = @_;
	eval q((1<< (($qid) + 24) | 1<< (($qid) + 16)));
    }
}
unless(defined(&WPI_EEPROM_READ_VALID)) {
    sub WPI_EEPROM_READ_VALID () {	(1<< 0);}
}
unless(defined(&WPI_EEPROM_CMD)) {
    sub WPI_EEPROM_CMD () {	(1<< 1);}
}
unless(defined(&WPI_EEPROM_GP_IF_OWNER)) {
    sub WPI_EEPROM_GP_IF_OWNER () {	0x180;}
}
unless(defined(&WPI_APMG_PS_PWR_SRC_MASK)) {
    sub WPI_APMG_PS_PWR_SRC_MASK () {	(3<< 24);}
}
unless(defined(&WPI_APMG_CLK_DMA_CLK_RQT)) {
    sub WPI_APMG_CLK_DMA_CLK_RQT () {	(1<< 9);}
}
unless(defined(&WPI_APMG_CLK_BSM_CLK_RQT)) {
    sub WPI_APMG_CLK_BSM_CLK_RQT () {	(1<< 11);}
}
unless(defined(&WPI_APMG_PCI_STT_L1A_DIS)) {
    sub WPI_APMG_PCI_STT_L1A_DIS () {	(1<< 11);}
}
unless(defined(&WPI_MAX_SEG_LEN)) {
    sub WPI_MAX_SEG_LEN () {	65520;}
}
unless(defined(&WPI_PAD32)) {
    sub WPI_PAD32 {
	my($x) = @_;
	eval q((((($x) + 3) & ~3) - ($x)));
    }
}
unless(defined(&WPI_UC_READY)) {
    sub WPI_UC_READY () {	1;}
}
unless(defined(&WPI_ADD_NODE_DONE)) {
    sub WPI_ADD_NODE_DONE () {	24;}
}
unless(defined(&WPI_RX_DONE)) {
    sub WPI_RX_DONE () {	27;}
}
unless(defined(&WPI_TX_DONE)) {
    sub WPI_TX_DONE () {	28;}
}
unless(defined(&WPI_START_SCAN)) {
    sub WPI_START_SCAN () {	130;}
}
unless(defined(&WPI_STOP_SCAN)) {
    sub WPI_STOP_SCAN () {	132;}
}
unless(defined(&WPI_STATE_CHANGED)) {
    sub WPI_STATE_CHANGED () {	161;}
}
unless(defined(&WPI_CMD_RXON)) {
    sub WPI_CMD_RXON () {	16;}
}
unless(defined(&WPI_CMD_ASSOCIATE)) {
    sub WPI_CMD_ASSOCIATE () {	17;}
}
unless(defined(&WPI_CMD_EDCA_PARAMS)) {
    sub WPI_CMD_EDCA_PARAMS () {	19;}
}
unless(defined(&WPI_CMD_TIMING)) {
    sub WPI_CMD_TIMING () {	20;}
}
unless(defined(&WPI_CMD_ADD_NODE)) {
    sub WPI_CMD_ADD_NODE () {	24;}
}
unless(defined(&WPI_CMD_TX_DATA)) {
    sub WPI_CMD_TX_DATA () {	28;}
}
unless(defined(&WPI_CMD_MRR_SETUP)) {
    sub WPI_CMD_MRR_SETUP () {	71;}
}
unless(defined(&WPI_CMD_SET_LED)) {
    sub WPI_CMD_SET_LED () {	72;}
}
unless(defined(&WPI_CMD_SET_POWER_MODE)) {
    sub WPI_CMD_SET_POWER_MODE () {	119;}
}
unless(defined(&WPI_CMD_SCAN)) {
    sub WPI_CMD_SCAN () {	128;}
}
unless(defined(&WPI_CMD_TXPOWER)) {
    sub WPI_CMD_TXPOWER () {	151;}
}
unless(defined(&WPI_CMD_BT_COEX)) {
    sub WPI_CMD_BT_COEX () {	155;}
}
unless(defined(&WPI_MODE_HOSTAP)) {
    sub WPI_MODE_HOSTAP () {	1;}
}
unless(defined(&WPI_MODE_STA)) {
    sub WPI_MODE_STA () {	3;}
}
unless(defined(&WPI_MODE_IBSS)) {
    sub WPI_MODE_IBSS () {	4;}
}
unless(defined(&WPI_MODE_MONITOR)) {
    sub WPI_MODE_MONITOR () {	6;}
}
unless(defined(&WPI_RXON_24GHZ)) {
    sub WPI_RXON_24GHZ () {	(1<< 0);}
}
unless(defined(&WPI_RXON_CCK)) {
    sub WPI_RXON_CCK () {	(1<< 1);}
}
unless(defined(&WPI_RXON_AUTO)) {
    sub WPI_RXON_AUTO () {	(1<< 2);}
}
unless(defined(&WPI_RXON_SHSLOT)) {
    sub WPI_RXON_SHSLOT () {	(1<< 4);}
}
unless(defined(&WPI_RXON_SHPREAMBLE)) {
    sub WPI_RXON_SHPREAMBLE () {	(1<< 5);}
}
unless(defined(&WPI_RXON_NODIVERSITY)) {
    sub WPI_RXON_NODIVERSITY () {	(1<< 7);}
}
unless(defined(&WPI_RXON_ANT_A)) {
    sub WPI_RXON_ANT_A () {	(1<< 8);}
}
unless(defined(&WPI_RXON_ANT_B)) {
    sub WPI_RXON_ANT_B () {	(1<< 9);}
}
unless(defined(&WPI_RXON_TSF)) {
    sub WPI_RXON_TSF () {	(1<< 15);}
}
unless(defined(&WPI_FILTER_PROMISC)) {
    sub WPI_FILTER_PROMISC () {	(1<< 0);}
}
unless(defined(&WPI_FILTER_CTL)) {
    sub WPI_FILTER_CTL () {	(1<< 1);}
}
unless(defined(&WPI_FILTER_MULTICAST)) {
    sub WPI_FILTER_MULTICAST () {	(1<< 2);}
}
unless(defined(&WPI_FILTER_NODECRYPT)) {
    sub WPI_FILTER_NODECRYPT () {	(1<< 3);}
}
unless(defined(&WPI_FILTER_BSS)) {
    sub WPI_FILTER_BSS () {	(1<< 5);}
}
unless(defined(&WPI_EDCA_UPDATE)) {
    sub WPI_EDCA_UPDATE () {	(1<< 0);}
}
unless(defined(&WPI_EDCA_TXOP)) {
    sub WPI_EDCA_TXOP () {	(1<< 4);}
}
unless(defined(&WPI_NODE_UPDATE)) {
    sub WPI_NODE_UPDATE () {	(1<< 0);}
}
unless(defined(&WPI_ID_BSS)) {
    sub WPI_ID_BSS () {	0;}
}
unless(defined(&WPI_ID_BROADCAST)) {
    sub WPI_ID_BROADCAST () {	24;}
}
unless(defined(&WPI_FLAG_SET_KEY)) {
    sub WPI_FLAG_SET_KEY () {	(1<< 0);}
}
unless(defined(&WPI_KFLAG_CCMP)) {
    sub WPI_KFLAG_CCMP () {	(1<< 1);}
}
unless(defined(&WPI_KFLAG_KID)) {
    sub WPI_KFLAG_KID {
	my($kid) = @_;
	eval q((($kid) << 8));
    }
}
unless(defined(&WPI_ACTION_SET_RATE)) {
    sub WPI_ACTION_SET_RATE () {	(1<< 2);}
}
unless(defined(&WPI_ANTENNA_A)) {
    sub WPI_ANTENNA_A () {	(1<< 6);}
}
unless(defined(&WPI_ANTENNA_B)) {
    sub WPI_ANTENNA_B () {	(1<< 7);}
}
unless(defined(&WPI_ANTENNA_BOTH)) {
    sub WPI_ANTENNA_BOTH () {	( &WPI_ANTENNA_A |  &WPI_ANTENNA_B);}
}
unless(defined(&WPI_TX_NEED_RTS)) {
    sub WPI_TX_NEED_RTS () {	(1<< 1);}
}
unless(defined(&WPI_TX_NEED_CTS)) {
    sub WPI_TX_NEED_CTS () {	(1<< 2);}
}
unless(defined(&WPI_TX_NEED_ACK)) {
    sub WPI_TX_NEED_ACK () {	(1<< 3);}
}
unless(defined(&WPI_TX_FULL_TXOP)) {
    sub WPI_TX_FULL_TXOP () {	(1<< 7);}
}
unless(defined(&WPI_TX_BT_DISABLE)) {
    sub WPI_TX_BT_DISABLE () {	(1<< 12);}
}
unless(defined(&WPI_TX_AUTO_SEQ)) {
    sub WPI_TX_AUTO_SEQ () {	(1<< 13);}
}
unless(defined(&WPI_TX_INSERT_TSTAMP)) {
    sub WPI_TX_INSERT_TSTAMP () {	(1<< 16);}
}
unless(defined(&WPI_CIPHER_WEP40)) {
    sub WPI_CIPHER_WEP40 () {	1;}
}
unless(defined(&WPI_CIPHER_CCMP)) {
    sub WPI_CIPHER_CCMP () {	2;}
}
unless(defined(&WPI_CIPHER_TKIP)) {
    sub WPI_CIPHER_TKIP () {	3;}
}
unless(defined(&WPI_CIPHER_WEP104)) {
    sub WPI_CIPHER_WEP104 () {	9;}
}
unless(defined(&WPI_LIFETIME_INFINITE)) {
    sub WPI_LIFETIME_INFINITE () {	0xffffffff;}
}
unless(defined(&WPI_RIDX_MAX)) {
    sub WPI_RIDX_MAX () {	11;}
}
unless(defined(&WPI_MRR_CTL)) {
    sub WPI_MRR_CTL () {	0;}
}
unless(defined(&WPI_MRR_DATA)) {
    sub WPI_MRR_DATA () {	1;}
}
unless(defined(&WPI_LED_ACTIVITY)) {
    sub WPI_LED_ACTIVITY () {	1;}
}
unless(defined(&WPI_LED_LINK)) {
    sub WPI_LED_LINK () {	2;}
}
unless(defined(&WPI_PS_ALLOW_SLEEP)) {
    sub WPI_PS_ALLOW_SLEEP () {	(1<< 0);}
}
unless(defined(&WPI_PS_SLEEP_OVER_DTIM)) {
    sub WPI_PS_SLEEP_OVER_DTIM () {	(1<< 2);}
}
unless(defined(&WPI_PS_PCI_PMGT)) {
    sub WPI_PS_PCI_PMGT () {	(1<< 3);}
}
unless(defined(&WPI_CHAN_ACTIVE)) {
    sub WPI_CHAN_ACTIVE () {	(1<< 0);}
}
unless(defined(&WPI_CHAN_NPBREQS)) {
    sub WPI_CHAN_NPBREQS {
	my($x) = @_;
	eval q((((1<< ($x)) - 1) << 1));
    }
}
unless(defined(&WPI_SCAN_MAXSZ)) {
    sub WPI_SCAN_MAXSZ () {	( &MCLBYTES - 4);}
}
unless(defined(&WPI_BAND_5GHZ)) {
    sub WPI_BAND_5GHZ () {	0;}
}
unless(defined(&WPI_BAND_2GHZ)) {
    sub WPI_BAND_2GHZ () {	1;}
}
unless(defined(&WPI_BT_COEX_DISABLE)) {
    sub WPI_BT_COEX_DISABLE () {	0;}
}
unless(defined(&WPI_BT_COEX_MODE_2WIRE)) {
    sub WPI_BT_COEX_MODE_2WIRE () {	1;}
}
unless(defined(&WPI_BT_COEX_MODE_3WIRE)) {
    sub WPI_BT_COEX_MODE_3WIRE () {	2;}
}
unless(defined(&WPI_BT_COEX_MODE_4WIRE)) {
    sub WPI_BT_COEX_MODE_4WIRE () {	3;}
}
unless(defined(&WPI_BT_LEAD_TIME_DEF)) {
    sub WPI_BT_LEAD_TIME_DEF () {	30;}
}
unless(defined(&WPI_BT_MAX_KILL_DEF)) {
    sub WPI_BT_MAX_KILL_DEF () {	5;}
}
unless(defined(&WPI_STAT_MAXLEN)) {
    sub WPI_STAT_MAXLEN () {	20;}
}
unless(defined(&WPI_RSSI_OFFSET)) {
    sub WPI_RSSI_OFFSET () {	95;}
}
unless(defined(&WPI_RX_NO_CRC_ERR)) {
    sub WPI_RX_NO_CRC_ERR () {	(1<< 0);}
}
unless(defined(&WPI_RX_NO_OVFL_ERR)) {
    sub WPI_RX_NO_OVFL_ERR () {	(1<< 1);}
}
unless(defined(&WPI_RX_NOERROR)) {
    sub WPI_RX_NOERROR () {	( &WPI_RX_NO_CRC_ERR |  &WPI_RX_NO_OVFL_ERR);}
}
unless(defined(&WPI_RX_CIPHER_MASK)) {
    sub WPI_RX_CIPHER_MASK () {	(7<< 8);}
}
unless(defined(&WPI_RX_CIPHER_CCMP)) {
    sub WPI_RX_CIPHER_CCMP () {	(2<< 8);}
}
unless(defined(&WPI_RX_DECRYPT_MASK)) {
    sub WPI_RX_DECRYPT_MASK () {	(3<< 11);}
}
unless(defined(&WPI_RX_DECRYPT_OK)) {
    sub WPI_RX_DECRYPT_OK () {	(3<< 11);}
}
unless(defined(&WPI_UCODE_INIT)) {
    sub WPI_UCODE_INIT () {	9;}
}
unless(defined(&WPI_FW_TEXT_MAXSZ)) {
    sub WPI_FW_TEXT_MAXSZ () {	(80* 1024);}
}
unless(defined(&WPI_FW_DATA_MAXSZ)) {
    sub WPI_FW_DATA_MAXSZ () {	(32* 1024);}
}
unless(defined(&WPI_FW_BOOT_TEXT_MAXSZ)) {
    sub WPI_FW_BOOT_TEXT_MAXSZ () {	1024;}
}
unless(defined(&WPI_FW_UPDATED)) {
    sub WPI_FW_UPDATED () {	(1<< 31);}
}
unless(defined(&WPI_EEPROM_MAC)) {
    sub WPI_EEPROM_MAC () {	0x15;}
}
unless(defined(&WPI_EEPROM_REVISION)) {
    sub WPI_EEPROM_REVISION () {	0x35;}
}
unless(defined(&WPI_EEPROM_CAPABILITIES)) {
    sub WPI_EEPROM_CAPABILITIES () {	0x45;}
}
unless(defined(&WPI_EEPROM_TYPE)) {
    sub WPI_EEPROM_TYPE () {	0x4a;}
}
unless(defined(&WPI_EEPROM_DOMAIN)) {
    sub WPI_EEPROM_DOMAIN () {	0x60;}
}
unless(defined(&WPI_EEPROM_BAND1)) {
    sub WPI_EEPROM_BAND1 () {	0x63;}
}
unless(defined(&WPI_EEPROM_BAND2)) {
    sub WPI_EEPROM_BAND2 () {	0x72;}
}
unless(defined(&WPI_EEPROM_BAND3)) {
    sub WPI_EEPROM_BAND3 () {	0x80;}
}
unless(defined(&WPI_EEPROM_BAND4)) {
    sub WPI_EEPROM_BAND4 () {	0x8d;}
}
unless(defined(&WPI_EEPROM_BAND5)) {
    sub WPI_EEPROM_BAND5 () {	0x99;}
}
unless(defined(&WPI_EEPROM_POWER_GRP)) {
    sub WPI_EEPROM_POWER_GRP () {	0x100;}
}
unless(defined(&WPI_EEPROM_CHAN_VALID)) {
    sub WPI_EEPROM_CHAN_VALID () {	(1<< 0);}
}
unless(defined(&WPI_EEPROM_CHAN_IBSS)) {
    sub WPI_EEPROM_CHAN_IBSS () {	(1<< 1);}
}
unless(defined(&WPI_EEPROM_CHAN_ACTIVE)) {
    sub WPI_EEPROM_CHAN_ACTIVE () {	(1<< 3);}
}
unless(defined(&WPI_EEPROM_CHAN_RADAR)) {
    sub WPI_EEPROM_CHAN_RADAR () {	(1<< 4);}
}
unless(defined(&WPI_POWER_GROUPS_COUNT)) {
    sub WPI_POWER_GROUPS_COUNT () {	5;}
}
unless(defined(&WPI_CHAN_BANDS_COUNT)) {
    sub WPI_CHAN_BANDS_COUNT () {	5;}
}
unless(defined(&WPI_MAX_CHAN_PER_BAND)) {
    sub WPI_MAX_CHAN_PER_BAND () {	14;}
}
unless(defined(&WPI_RIDX_OFDM6)) {
    sub WPI_RIDX_OFDM6 () {	0;}
}
unless(defined(&WPI_RIDX_OFDM36)) {
    sub WPI_RIDX_OFDM36 () {	5;}
}
unless(defined(&WPI_RIDX_OFDM48)) {
    sub WPI_RIDX_OFDM48 () {	6;}
}
unless(defined(&WPI_RIDX_OFDM54)) {
    sub WPI_RIDX_OFDM54 () {	7;}
}
unless(defined(&WPI_RIDX_CCK1)) {
    sub WPI_RIDX_CCK1 () {	8;}
}
unless(defined(&WPI_RIDX_CCK2)) {
    sub WPI_RIDX_CCK2 () {	9;}
}
unless(defined(&WPI_RIDX_CCK11)) {
    sub WPI_RIDX_CCK11 () {	11;}
}
unless(defined(&WPI_MAX_PWR_INDEX)) {
    sub WPI_MAX_PWR_INDEX () {	77;}
}
unless(defined(&WPI_NDTIMRANGES)) {
    sub WPI_NDTIMRANGES () {	2;}
}
unless(defined(&WPI_NPOWERLEVELS)) {
    sub WPI_NPOWERLEVELS () {	6;}
}
unless(defined(&WPI_READ)) {
    sub WPI_READ {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&WPI_WRITE)) {
    sub WPI_WRITE {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&WPI_WRITE_REGION_4)) {
    sub WPI_WRITE_REGION_4 {
	my($sc, $offset, $datap, $count) = @_;
	eval q( &bus_space_write_region_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($offset), ($datap), ($count)));
    }
}
unless(defined(&WPI_SETBITS)) {
    sub WPI_SETBITS {
	my($sc, $reg, $mask) = @_;
	eval q( &WPI_WRITE($sc, $reg,  &WPI_READ($sc, $reg) | ($mask)));
    }
}
unless(defined(&WPI_CLRBITS)) {
    sub WPI_CLRBITS {
	my($sc, $reg, $mask) = @_;
	eval q( &WPI_WRITE($sc, $reg,  &WPI_READ($sc, $reg) & ~($mask)));
    }
}
unless(defined(&WPI_BARRIER_WRITE)) {
    sub WPI_BARRIER_WRITE {
	my($sc) = @_;
	eval q( &bus_space_barrier(($sc)-> &sc_st, ($sc)-> &sc_sh, 0, ($sc)-> &sc_sz,  &BUS_SPACE_BARRIER_WRITE));
    }
}
unless(defined(&WPI_BARRIER_READ_WRITE)) {
    sub WPI_BARRIER_READ_WRITE {
	my($sc) = @_;
	eval q( &bus_space_barrier(($sc)-> &sc_st, ($sc)-> &sc_sh, 0, ($sc)-> &sc_sz,  &BUS_SPACE_BARRIER_READ |  &BUS_SPACE_BARRIER_WRITE));
    }
}
1;
