require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&VGE_JUMBO_MTU)) {
    sub VGE_JUMBO_MTU () {	9000;}
}
unless(defined(&VGE_IFQ_MAXLEN)) {
    sub VGE_IFQ_MAXLEN () {	64;}
}
unless(defined(&VGE_TX_DESC_CNT)) {
    sub VGE_TX_DESC_CNT () {	256;}
}
unless(defined(&VGE_RX_DESC_CNT)) {
    sub VGE_RX_DESC_CNT () {	256;}
}
unless(defined(&VGE_RING_ALIGN)) {
    sub VGE_RING_ALIGN () {	256;}
}
unless(defined(&VGE_RX_LIST_SZ)) {
    sub VGE_RX_LIST_SZ () {	( &VGE_RX_DESC_CNT * $sizeof{'struct vge_rx_desc'});}
}
unless(defined(&VGE_TX_LIST_SZ)) {
    sub VGE_TX_LIST_SZ () {	( &VGE_TX_DESC_CNT * $sizeof{'struct vge_tx_desc'});}
}
unless(defined(&VGE_TX_DESC_INC)) {
    sub VGE_TX_DESC_INC {
	my($x) = @_;
	eval q(($x = ($x + 1) %  &VGE_TX_DESC_CNT));
    }
}
unless(defined(&VGE_RX_DESC_INC)) {
    sub VGE_RX_DESC_INC {
	my($x) = @_;
	eval q(($x = ($x + 1) %  &VGE_RX_DESC_CNT));
    }
}
unless(defined(&VGE_ADDR_LO)) {
    sub VGE_ADDR_LO {
	my($y) = @_;
	eval q((( &u_int64_t) ($y) & 0xffffffff));
    }
}
unless(defined(&VGE_ADDR_HI)) {
    sub VGE_ADDR_HI {
	my($y) = @_;
	eval q((( &u_int64_t) ($y) >> 32));
    }
}
unless(defined(&VGE_BUFLEN)) {
    sub VGE_BUFLEN {
	my($y) = @_;
	eval q((($y) & 0x7fff));
    }
}
unless(defined(&VGE_OWN)) {
    sub VGE_OWN {
	my($x) = @_;
	eval q(( &letoh32(($x)-> &vge_sts) &  &VGE_RDSTS_OWN));
    }
}
unless(defined(&VGE_RXBYTES)) {
    sub VGE_RXBYTES {
	my($x) = @_;
	eval q((( &letoh32(($x)-> &vge_sts) &  &VGE_RDSTS_BUFSIZ) >> 16));
    }
}
unless(defined(&VGE_MIN_FRAMELEN)) {
    sub VGE_MIN_FRAMELEN () {	60;}
}
unless(defined(&MAX_NUM_MULTICAST_ADDRESSES)) {
    sub MAX_NUM_MULTICAST_ADDRESSES () {	128;}
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{vge_btag}),  ($sc->{vge_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2( ($sc->{vge_btag}),  ($sc->{vge_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1( ($sc->{vge_btag}),  ($sc->{vge_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4( ($sc->{vge_btag}),  ($sc->{vge_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_2( ($sc->{vge_btag}),  ($sc->{vge_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_1( ($sc->{vge_btag}),  ($sc->{vge_bhandle}), $reg));
    }
}
unless(defined(&CSR_SETBIT_1)) {
    sub CSR_SETBIT_1 {
	my($sc, $reg, $x) = @_;
	eval q( &CSR_WRITE_1($sc, $reg,  &CSR_READ_1($sc, $reg) | ($x)));
    }
}
unless(defined(&CSR_SETBIT_2)) {
    sub CSR_SETBIT_2 {
	my($sc, $reg, $x) = @_;
	eval q( &CSR_WRITE_2($sc, $reg,  &CSR_READ_2($sc, $reg) | ($x)));
    }
}
unless(defined(&CSR_SETBIT_4)) {
    sub CSR_SETBIT_4 {
	my($sc, $reg, $x) = @_;
	eval q( &CSR_WRITE_4($sc, $reg,  &CSR_READ_4($sc, $reg) | ($x)));
    }
}
unless(defined(&CSR_CLRBIT_1)) {
    sub CSR_CLRBIT_1 {
	my($sc, $reg, $x) = @_;
	eval q( &CSR_WRITE_1($sc, $reg,  &CSR_READ_1($sc, $reg) & ~($x)));
    }
}
unless(defined(&CSR_CLRBIT_2)) {
    sub CSR_CLRBIT_2 {
	my($sc, $reg, $x) = @_;
	eval q( &CSR_WRITE_2($sc, $reg,  &CSR_READ_2($sc, $reg) & ~($x)));
    }
}
unless(defined(&CSR_CLRBIT_4)) {
    sub CSR_CLRBIT_4 {
	my($sc, $reg, $x) = @_;
	eval q( &CSR_WRITE_4($sc, $reg,  &CSR_READ_4($sc, $reg) & ~($x)));
    }
}
unless(defined(&VGE_TIMEOUT)) {
    sub VGE_TIMEOUT () {	10000;}
}
1;
