require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__MGA_DRV_H__)) {
    eval 'sub __MGA_DRV_H__ () {1;}' unless defined(&__MGA_DRV_H__);
    eval 'sub DRIVER_AUTHOR () {"Gareth Hughes, VA Linux Systems Inc.";}' unless defined(&DRIVER_AUTHOR);
    eval 'sub DRIVER_NAME () {"mga";}' unless defined(&DRIVER_NAME);
    eval 'sub DRIVER_DESC () {"Matrox G200/G400";}' unless defined(&DRIVER_DESC);
    eval 'sub DRIVER_DATE () {"20060319";}' unless defined(&DRIVER_DATE);
    eval 'sub DRIVER_MAJOR () {3;}' unless defined(&DRIVER_MAJOR);
    eval 'sub DRIVER_MINOR () {2;}' unless defined(&DRIVER_MINOR);
    eval 'sub DRIVER_PATCHLEVEL () {2;}' unless defined(&DRIVER_PATCHLEVEL);
    eval 'sub mga_flush_write_combine () {
        eval q( &DRM_WRITEMEMORYBARRIER());
    }' unless defined(&mga_flush_write_combine);
    if(defined( &__linux__)  && defined( &__alpha__)) {
	eval 'sub MGA_BASE {
	    my( $reg ) = @_;
    	    eval q((( ($dev_priv->{mmio}->{handle}))));
	}' unless defined(&MGA_BASE);
	eval 'sub MGA_ADDR {
	    my( $reg ) = @_;
    	    eval q(( &MGA_BASE($reg) + $reg));
	}' unless defined(&MGA_ADDR);
	eval 'sub MGA_DEREF {
	    my( $reg ) = @_;
    	    eval q(*( &volatile  &u32 *) &MGA_ADDR( $reg ));
	}' unless defined(&MGA_DEREF);
	eval 'sub MGA_DEREF8 {
	    my( $reg ) = @_;
    	    eval q(*( &volatile  &u8 *) &MGA_ADDR( $reg ));
	}' unless defined(&MGA_DEREF8);
	eval 'sub MGA_READ {
	    my( $reg ) = @_;
    	    eval q(( &_MGA_READ(( &u32 *) &MGA_ADDR($reg))));
	}' unless defined(&MGA_READ);
	eval 'sub MGA_READ8 {
	    my( $reg ) = @_;
    	    eval q(( &_MGA_READ(( &u8 *) &MGA_ADDR($reg))));
	}' unless defined(&MGA_READ8);
	eval 'sub MGA_WRITE {
	    my( $reg, $val ) = @_;
    	    eval q( &do {  &DRM_WRITEMEMORYBARRIER();  &MGA_DEREF( $reg ) = $val; }  &while (0));
	}' unless defined(&MGA_WRITE);
	eval 'sub MGA_WRITE8 {
	    my( $reg, $val ) = @_;
    	    eval q( &do {  &DRM_WRITEMEMORYBARRIER();  &MGA_DEREF8( $reg ) = $val; }  &while (0));
	}' unless defined(&MGA_WRITE8);
    } else {
	eval 'sub MGA_READ8 {
	    my($reg) = @_;
    	    eval q( &bus_space_read_1( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg)));
	}' unless defined(&MGA_READ8);
	eval 'sub MGA_READ {
	    my($reg) = @_;
    	    eval q( &bus_space_read_4( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg)));
	}' unless defined(&MGA_READ);
	eval 'sub MGA_WRITE8 {
	    my($reg,$val) = @_;
    	    eval q( &bus_space_write_1( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg), ($val)));
	}' unless defined(&MGA_WRITE8);
	eval 'sub MGA_WRITE {
	    my($reg,$val) = @_;
    	    eval q( &bus_space_write_4( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg), ($val)));
	}' unless defined(&MGA_WRITE);
    }
    eval 'sub DWGREG0 () {0x1c00;}' unless defined(&DWGREG0);
    eval 'sub DWGREG0_END () {0x1dff;}' unless defined(&DWGREG0_END);
    eval 'sub DWGREG1 () {0x2c00;}' unless defined(&DWGREG1);
    eval 'sub DWGREG1_END () {0x2dff;}' unless defined(&DWGREG1_END);
    eval 'sub ISREG0 {
        my($r) = @_;
	    eval q(($r >=  &DWGREG0  && $r <=  &DWGREG0_END));
    }' unless defined(&ISREG0);
    eval 'sub DMAREG0 {
        my($r) = @_;
	    eval q(( &u8)(($r -  &DWGREG0) >> 2));
    }' unless defined(&DMAREG0);
    eval 'sub DMAREG1 {
        my($r) = @_;
	    eval q(( &u8)((($r -  &DWGREG1) >> 2) | 0x80));
    }' unless defined(&DMAREG1);
    eval 'sub DMAREG {
        my($r) = @_;
	    eval q(( &ISREG0($r) ?  &DMAREG0($r) :  &DMAREG1($r)));
    }' unless defined(&DMAREG);
    eval 'sub MGA_EMIT_STATE {
        my( $dev_priv, $dirty ) = @_;
	    eval q( &do {  &if ( ($dirty) & ~ &MGA_UPLOAD_CLIPRECTS ) {  &if (  ($dev_priv->{chipset}) >=  &MGA_CARD_TYPE_G400 ) {  &mga_g400_emit_state( $dev_priv ); }  &else {  &mga_g200_emit_state( $dev_priv ); } } }  &while (0));
    }' unless defined(&MGA_EMIT_STATE);
    eval 'sub WRAP_TEST_WITH_RETURN {
        my( $dev_priv ) = @_;
	    eval q( &do {  &if (  &test_bit( 0,  ($dev_priv->{prim}->{wrapped}) ) ) {  &if (  &mga_is_idle( $dev_priv ) ) {  &mga_do_dma_wrap_end( $dev_priv ); }  &else  &if (  ($dev_priv->{prim}->{space}) <  ($dev_priv->{prim}->{high_mark}) ) {  &if (  &MGA_DMA_DEBUG )  &DRM_INFO( \\"wrap...\\\\n\\");  &return  &EBUSY; } } }  &while (0));
    }' unless defined(&WRAP_TEST_WITH_RETURN);
    eval 'sub WRAP_WAIT_WITH_RETURN {
        my( $dev_priv ) = @_;
	    eval q( &do {  &if (  &test_bit( 0,  ($dev_priv->{prim}->{wrapped}) ) ) {  &if (  &mga_do_wait_for_idle( $dev_priv ) < 0) {  &if (  &MGA_DMA_DEBUG )  &DRM_INFO( \\"wrap...\\\\n\\");  &return  &EBUSY; }  &mga_do_dma_wrap_end( $dev_priv ); } }  &while (0));
    }' unless defined(&WRAP_WAIT_WITH_RETURN);
    eval 'sub MGA_VERBOSE () {0;}' unless defined(&MGA_VERBOSE);
    eval 'sub DMA_LOCALS () {\'unsigned int write\';  &volatile  &u8 * &prim;;}' unless defined(&DMA_LOCALS);
    eval 'sub DMA_BLOCK_SIZE () {(5* $sizeof{ &u32});}' unless defined(&DMA_BLOCK_SIZE);
    eval 'sub BEGIN_DMA {
        my( $n ) = @_;
	    eval q( &do {  &if (  &MGA_VERBOSE ) {  &DRM_INFO( \\"BEGIN_DMA( %d )\\\\n\\", ( &n) );  &DRM_INFO( \\"   space=0x%x req=0x%Zx\\\\n\\",  ($dev_priv->{prim}->{space}), ( &n) *  &DMA_BLOCK_SIZE ); }  &prim =  ($dev_priv->{prim}->{start});  &write =  ($dev_priv->{prim}->{tail}); }  &while (0));
    }' unless defined(&BEGIN_DMA);
    eval 'sub BEGIN_DMA_WRAP () {
        eval q( &do {  &if (  &MGA_VERBOSE ) {  &DRM_INFO( \\"BEGIN_DMA()\\\\n\\" );  &DRM_INFO( \\"   space=0x%x\\\\n\\",  ($dev_priv->{prim}->{space}) ); }  &prim =  ($dev_priv->{prim}->{start});  &write =  ($dev_priv->{prim}->{tail}); }  &while (0));
    }' unless defined(&BEGIN_DMA_WRAP);
    eval 'sub ADVANCE_DMA () {
        eval q( &do {  ($dev_priv->{prim}->{tail}) =  &write;  &if (  &MGA_VERBOSE ) {  &DRM_INFO( \\"ADVANCE_DMA() tail=0x%05x sp=0x%x\\\\n\\",  &write,  ($dev_priv->{prim}->{space}) ); } }  &while (0));
    }' unless defined(&ADVANCE_DMA);
    eval 'sub FLUSH_DMA () {
        eval q( &do {  &if ( 0) {  &DRM_INFO( \\"\\\\n\\" );  &DRM_INFO( \\"   tail=0x%06x head=0x%06lx\\\\n\\",  ($dev_priv->{prim}->{tail}),  &MGA_READ(  &MGA_PRIMADDRESS ) -  ($dev_priv->{primary}->{offset}) ); }  &if ( ! &test_bit( 0,  ($dev_priv->{prim}->{wrapped}) ) ) {  &if (  ($dev_priv->{prim}->{space}) <  ($dev_priv->{prim}->{high_mark}) ) {  &mga_do_dma_wrap_start(  &dev_priv ); }  &else {  &mga_do_dma_flush(  &dev_priv ); } } }  &while (0));
    }' unless defined(&FLUSH_DMA);
    eval 'sub DMA_WRITE {
        my( $offset, $val ) = @_;
	    eval q( &do {  &if (  &MGA_VERBOSE ) {  &DRM_INFO( \\"   DMA_WRITE( 0x%08x ) at 0x%04Zx\\\\n\\", ( &u32)($val),  &write + ($offset) * $sizeof{ &u32} ); } *( &volatile  &u32 *)( &prim +  &write + ($offset) * $sizeof{ &u32}) = $val; }  &while (0));
    }' unless defined(&DMA_WRITE);
    eval 'sub DMA_BLOCK {
        my( $reg0, $val0, $reg1, $val1, $reg2, $val2, $reg3, $val3 ) = @_;
	    eval q( &do {  &DMA_WRITE( 0, (( &DMAREG( $reg0 ) << 0) | ( &DMAREG( $reg1 ) << 8) | ( &DMAREG( $reg2 ) << 16) | ( &DMAREG( $reg3 ) << 24)) );  &DMA_WRITE( 1, $val0 );  &DMA_WRITE( 2, $val1 );  &DMA_WRITE( 3, $val2 );  &DMA_WRITE( 4, $val3 );  &write +=  &DMA_BLOCK_SIZE; }  &while (0));
    }' unless defined(&DMA_BLOCK);
    eval 'sub SET_AGE {
        my( $age, $h, $w ) = @_;
	    eval q( &do { ($age)-> &head = $h; ($age)-> &wrap =  &w; }  &while (0));
    }' unless defined(&SET_AGE);
    eval 'sub TEST_AGE {
        my( $age, $h, $w ) = @_;
	    eval q(( ($age)-> &wrap <  &w || ( ($age)-> &wrap ==  &w  && ($age)-> &head < $h ) ));
    }' unless defined(&TEST_AGE);
    eval 'sub AGE_BUFFER {
        my( $buf_priv ) = @_;
	    eval q( &do {  &if ( ($buf_priv)-> &dispatched ) {  ($buf_priv->{age}->{head}) = ( ($dev_priv->{prim}->{tail}) +  ($dev_priv->{primary}->{offset}));  ($buf_priv->{age}->{wrap}) =  ($dev_priv->{sarea_priv}->{last_wrap}); }  &else {  ($buf_priv->{age}->{head}) = 0;  ($buf_priv->{age}->{wrap}) = 0; } }  &while (0));
    }' unless defined(&AGE_BUFFER);
    eval 'sub MGA_ENGINE_IDLE_MASK () {( &MGA_SOFTRAPEN |  &MGA_DWGENGSTS |  &MGA_ENDPRDMASTS);}' unless defined(&MGA_ENGINE_IDLE_MASK);
    eval 'sub MGA_DMA_IDLE_MASK () {( &MGA_SOFTRAPEN |  &MGA_ENDPRDMASTS);}' unless defined(&MGA_DMA_IDLE_MASK);
    eval 'sub MGA_DMA_DEBUG () {0;}' unless defined(&MGA_DMA_DEBUG);
    eval 'sub MGA_CRTC_INDEX () {0x1fd4;}' unless defined(&MGA_CRTC_INDEX);
    eval 'sub MGA_CRTC_DATA () {0x1fd5;}' unless defined(&MGA_CRTC_DATA);
    eval 'sub MGA_VINTCLR () {(1<< 4);}' unless defined(&MGA_VINTCLR);
    eval 'sub MGA_VINTEN () {(1<< 5);}' unless defined(&MGA_VINTEN);
    eval 'sub MGA_ALPHACTRL () {0x2c7c;}' unless defined(&MGA_ALPHACTRL);
    eval 'sub MGA_AR0 () {0x1c60;}' unless defined(&MGA_AR0);
    eval 'sub MGA_AR1 () {0x1c64;}' unless defined(&MGA_AR1);
    eval 'sub MGA_AR2 () {0x1c68;}' unless defined(&MGA_AR2);
    eval 'sub MGA_AR3 () {0x1c6c;}' unless defined(&MGA_AR3);
    eval 'sub MGA_AR4 () {0x1c70;}' unless defined(&MGA_AR4);
    eval 'sub MGA_AR5 () {0x1c74;}' unless defined(&MGA_AR5);
    eval 'sub MGA_AR6 () {0x1c78;}' unless defined(&MGA_AR6);
    eval 'sub MGA_CXBNDRY () {0x1c80;}' unless defined(&MGA_CXBNDRY);
    eval 'sub MGA_CXLEFT () {0x1ca0;}' unless defined(&MGA_CXLEFT);
    eval 'sub MGA_CXRIGHT () {0x1ca4;}' unless defined(&MGA_CXRIGHT);
    eval 'sub MGA_DMAPAD () {0x1c54;}' unless defined(&MGA_DMAPAD);
    eval 'sub MGA_DSTORG () {0x2cb8;}' unless defined(&MGA_DSTORG);
    eval 'sub MGA_DWGCTL () {0x1c00;}' unless defined(&MGA_DWGCTL);
    eval 'sub MGA_OPCOD_MASK () {(15<< 0);}' unless defined(&MGA_OPCOD_MASK);
    eval 'sub MGA_OPCOD_TRAP () {(4<< 0);}' unless defined(&MGA_OPCOD_TRAP);
    eval 'sub MGA_OPCOD_TEXTURE_TRAP () {(6<< 0);}' unless defined(&MGA_OPCOD_TEXTURE_TRAP);
    eval 'sub MGA_OPCOD_BITBLT () {(8<< 0);}' unless defined(&MGA_OPCOD_BITBLT);
    eval 'sub MGA_OPCOD_ILOAD () {(9<< 0);}' unless defined(&MGA_OPCOD_ILOAD);
    eval 'sub MGA_ATYPE_MASK () {(7<< 4);}' unless defined(&MGA_ATYPE_MASK);
    eval 'sub MGA_ATYPE_RPL () {(0<< 4);}' unless defined(&MGA_ATYPE_RPL);
    eval 'sub MGA_ATYPE_RSTR () {(1<< 4);}' unless defined(&MGA_ATYPE_RSTR);
    eval 'sub MGA_ATYPE_ZI () {(3<< 4);}' unless defined(&MGA_ATYPE_ZI);
    eval 'sub MGA_ATYPE_BLK () {(4<< 4);}' unless defined(&MGA_ATYPE_BLK);
    eval 'sub MGA_ATYPE_I () {(7<< 4);}' unless defined(&MGA_ATYPE_I);
    eval 'sub MGA_LINEAR () {(1<< 7);}' unless defined(&MGA_LINEAR);
    eval 'sub MGA_ZMODE_MASK () {(7<< 8);}' unless defined(&MGA_ZMODE_MASK);
    eval 'sub MGA_ZMODE_NOZCMP () {(0<< 8);}' unless defined(&MGA_ZMODE_NOZCMP);
    eval 'sub MGA_ZMODE_ZE () {(2<< 8);}' unless defined(&MGA_ZMODE_ZE);
    eval 'sub MGA_ZMODE_ZNE () {(3<< 8);}' unless defined(&MGA_ZMODE_ZNE);
    eval 'sub MGA_ZMODE_ZLT () {(4<< 8);}' unless defined(&MGA_ZMODE_ZLT);
    eval 'sub MGA_ZMODE_ZLTE () {(5<< 8);}' unless defined(&MGA_ZMODE_ZLTE);
    eval 'sub MGA_ZMODE_ZGT () {(6<< 8);}' unless defined(&MGA_ZMODE_ZGT);
    eval 'sub MGA_ZMODE_ZGTE () {(7<< 8);}' unless defined(&MGA_ZMODE_ZGTE);
    eval 'sub MGA_SOLID () {(1<< 11);}' unless defined(&MGA_SOLID);
    eval 'sub MGA_ARZERO () {(1<< 12);}' unless defined(&MGA_ARZERO);
    eval 'sub MGA_SGNZERO () {(1<< 13);}' unless defined(&MGA_SGNZERO);
    eval 'sub MGA_SHIFTZERO () {(1<< 14);}' unless defined(&MGA_SHIFTZERO);
    eval 'sub MGA_BOP_MASK () {(15<< 16);}' unless defined(&MGA_BOP_MASK);
    eval 'sub MGA_BOP_ZERO () {(0<< 16);}' unless defined(&MGA_BOP_ZERO);
    eval 'sub MGA_BOP_DST () {(10<< 16);}' unless defined(&MGA_BOP_DST);
    eval 'sub MGA_BOP_SRC () {(12<< 16);}' unless defined(&MGA_BOP_SRC);
    eval 'sub MGA_BOP_ONE () {(15<< 16);}' unless defined(&MGA_BOP_ONE);
    eval 'sub MGA_TRANS_SHIFT () {20;}' unless defined(&MGA_TRANS_SHIFT);
    eval 'sub MGA_TRANS_MASK () {(15<< 20);}' unless defined(&MGA_TRANS_MASK);
    eval 'sub MGA_BLTMOD_MASK () {(15<< 25);}' unless defined(&MGA_BLTMOD_MASK);
    eval 'sub MGA_BLTMOD_BMONOLEF () {(0<< 25);}' unless defined(&MGA_BLTMOD_BMONOLEF);
    eval 'sub MGA_BLTMOD_BMONOWF () {(4<< 25);}' unless defined(&MGA_BLTMOD_BMONOWF);
    eval 'sub MGA_BLTMOD_PLAN () {(1<< 25);}' unless defined(&MGA_BLTMOD_PLAN);
    eval 'sub MGA_BLTMOD_BFCOL () {(2<< 25);}' unless defined(&MGA_BLTMOD_BFCOL);
    eval 'sub MGA_BLTMOD_BU32BGR () {(3<< 25);}' unless defined(&MGA_BLTMOD_BU32BGR);
    eval 'sub MGA_BLTMOD_BU32RGB () {(7<< 25);}' unless defined(&MGA_BLTMOD_BU32RGB);
    eval 'sub MGA_BLTMOD_BU24BGR () {(11<< 25);}' unless defined(&MGA_BLTMOD_BU24BGR);
    eval 'sub MGA_BLTMOD_BU24RGB () {(15<< 25);}' unless defined(&MGA_BLTMOD_BU24RGB);
    eval 'sub MGA_PATTERN () {(1<< 29);}' unless defined(&MGA_PATTERN);
    eval 'sub MGA_TRANSC () {(1<< 30);}' unless defined(&MGA_TRANSC);
    eval 'sub MGA_CLIPDIS () {(1<< 31);}' unless defined(&MGA_CLIPDIS);
    eval 'sub MGA_DWGSYNC () {0x2c4c;}' unless defined(&MGA_DWGSYNC);
    eval 'sub MGA_FCOL () {0x1c24;}' unless defined(&MGA_FCOL);
    eval 'sub MGA_FIFOSTATUS () {0x1e10;}' unless defined(&MGA_FIFOSTATUS);
    eval 'sub MGA_FOGCOL () {0x1cf4;}' unless defined(&MGA_FOGCOL);
    eval 'sub MGA_FXBNDRY () {0x1c84;}' unless defined(&MGA_FXBNDRY);
    eval 'sub MGA_FXLEFT () {0x1ca8;}' unless defined(&MGA_FXLEFT);
    eval 'sub MGA_FXRIGHT () {0x1cac;}' unless defined(&MGA_FXRIGHT);
    eval 'sub MGA_ICLEAR () {0x1e18;}' unless defined(&MGA_ICLEAR);
    eval 'sub MGA_SOFTRAPICLR () {(1<< 0);}' unless defined(&MGA_SOFTRAPICLR);
    eval 'sub MGA_VLINEICLR () {(1<< 5);}' unless defined(&MGA_VLINEICLR);
    eval 'sub MGA_IEN () {0x1e1c;}' unless defined(&MGA_IEN);
    eval 'sub MGA_SOFTRAPIEN () {(1<< 0);}' unless defined(&MGA_SOFTRAPIEN);
    eval 'sub MGA_VLINEIEN () {(1<< 5);}' unless defined(&MGA_VLINEIEN);
    eval 'sub MGA_LEN () {0x1c5c;}' unless defined(&MGA_LEN);
    eval 'sub MGA_MACCESS () {0x1c04;}' unless defined(&MGA_MACCESS);
    eval 'sub MGA_PITCH () {0x1c8c;}' unless defined(&MGA_PITCH);
    eval 'sub MGA_PLNWT () {0x1c1c;}' unless defined(&MGA_PLNWT);
    eval 'sub MGA_PRIMADDRESS () {0x1e58;}' unless defined(&MGA_PRIMADDRESS);
    eval 'sub MGA_DMA_GENERAL () {(0<< 0);}' unless defined(&MGA_DMA_GENERAL);
    eval 'sub MGA_DMA_BLIT () {(1<< 0);}' unless defined(&MGA_DMA_BLIT);
    eval 'sub MGA_DMA_VECTOR () {(2<< 0);}' unless defined(&MGA_DMA_VECTOR);
    eval 'sub MGA_DMA_VERTEX () {(3<< 0);}' unless defined(&MGA_DMA_VERTEX);
    eval 'sub MGA_PRIMEND () {0x1e5c;}' unless defined(&MGA_PRIMEND);
    eval 'sub MGA_PRIMNOSTART () {(1<< 0);}' unless defined(&MGA_PRIMNOSTART);
    eval 'sub MGA_PAGPXFER () {(1<< 1);}' unless defined(&MGA_PAGPXFER);
    eval 'sub MGA_PRIMPTR () {0x1e50;}' unless defined(&MGA_PRIMPTR);
    eval 'sub MGA_PRIMPTREN0 () {(1<< 0);}' unless defined(&MGA_PRIMPTREN0);
    eval 'sub MGA_PRIMPTREN1 () {(1<< 1);}' unless defined(&MGA_PRIMPTREN1);
    eval 'sub MGA_RST () {0x1e40;}' unless defined(&MGA_RST);
    eval 'sub MGA_SOFTRESET () {(1<< 0);}' unless defined(&MGA_SOFTRESET);
    eval 'sub MGA_SOFTEXTRST () {(1<< 1);}' unless defined(&MGA_SOFTEXTRST);
    eval 'sub MGA_SECADDRESS () {0x2c40;}' unless defined(&MGA_SECADDRESS);
    eval 'sub MGA_SECEND () {0x2c44;}' unless defined(&MGA_SECEND);
    eval 'sub MGA_SETUPADDRESS () {0x2cd0;}' unless defined(&MGA_SETUPADDRESS);
    eval 'sub MGA_SETUPEND () {0x2cd4;}' unless defined(&MGA_SETUPEND);
    eval 'sub MGA_SGN () {0x1c58;}' unless defined(&MGA_SGN);
    eval 'sub MGA_SOFTRAP () {0x2c48;}' unless defined(&MGA_SOFTRAP);
    eval 'sub MGA_SRCORG () {0x2cb4;}' unless defined(&MGA_SRCORG);
    eval 'sub MGA_SRMMAP_MASK () {(1<< 0);}' unless defined(&MGA_SRMMAP_MASK);
    eval 'sub MGA_SRCMAP_FB () {(0<< 0);}' unless defined(&MGA_SRCMAP_FB);
    eval 'sub MGA_SRCMAP_SYSMEM () {(1<< 0);}' unless defined(&MGA_SRCMAP_SYSMEM);
    eval 'sub MGA_SRCACC_MASK () {(1<< 1);}' unless defined(&MGA_SRCACC_MASK);
    eval 'sub MGA_SRCACC_PCI () {(0<< 1);}' unless defined(&MGA_SRCACC_PCI);
    eval 'sub MGA_SRCACC_AGP () {(1<< 1);}' unless defined(&MGA_SRCACC_AGP);
    eval 'sub MGA_STATUS () {0x1e14;}' unless defined(&MGA_STATUS);
    eval 'sub MGA_SOFTRAPEN () {(1<< 0);}' unless defined(&MGA_SOFTRAPEN);
    eval 'sub MGA_VSYNCPEN () {(1<< 4);}' unless defined(&MGA_VSYNCPEN);
    eval 'sub MGA_VLINEPEN () {(1<< 5);}' unless defined(&MGA_VLINEPEN);
    eval 'sub MGA_DWGENGSTS () {(1<< 16);}' unless defined(&MGA_DWGENGSTS);
    eval 'sub MGA_ENDPRDMASTS () {(1<< 17);}' unless defined(&MGA_ENDPRDMASTS);
    eval 'sub MGA_STENCIL () {0x2cc8;}' unless defined(&MGA_STENCIL);
    eval 'sub MGA_STENCILCTL () {0x2ccc;}' unless defined(&MGA_STENCILCTL);
    eval 'sub MGA_TDUALSTAGE0 () {0x2cf8;}' unless defined(&MGA_TDUALSTAGE0);
    eval 'sub MGA_TDUALSTAGE1 () {0x2cfc;}' unless defined(&MGA_TDUALSTAGE1);
    eval 'sub MGA_TEXBORDERCOL () {0x2c5c;}' unless defined(&MGA_TEXBORDERCOL);
    eval 'sub MGA_TEXCTL () {0x2c30;}' unless defined(&MGA_TEXCTL);
    eval 'sub MGA_TEXCTL2 () {0x2c3c;}' unless defined(&MGA_TEXCTL2);
    eval 'sub MGA_DUALTEX () {(1<< 7);}' unless defined(&MGA_DUALTEX);
    eval 'sub MGA_G400_TC2_MAGIC () {(1<< 15);}' unless defined(&MGA_G400_TC2_MAGIC);
    eval 'sub MGA_MAP1_ENABLE () {(1<< 31);}' unless defined(&MGA_MAP1_ENABLE);
    eval 'sub MGA_TEXFILTER () {0x2c58;}' unless defined(&MGA_TEXFILTER);
    eval 'sub MGA_TEXHEIGHT () {0x2c2c;}' unless defined(&MGA_TEXHEIGHT);
    eval 'sub MGA_TEXORG () {0x2c24;}' unless defined(&MGA_TEXORG);
    eval 'sub MGA_TEXORGMAP_MASK () {(1<< 0);}' unless defined(&MGA_TEXORGMAP_MASK);
    eval 'sub MGA_TEXORGMAP_FB () {(0<< 0);}' unless defined(&MGA_TEXORGMAP_FB);
    eval 'sub MGA_TEXORGMAP_SYSMEM () {(1<< 0);}' unless defined(&MGA_TEXORGMAP_SYSMEM);
    eval 'sub MGA_TEXORGACC_MASK () {(1<< 1);}' unless defined(&MGA_TEXORGACC_MASK);
    eval 'sub MGA_TEXORGACC_PCI () {(0<< 1);}' unless defined(&MGA_TEXORGACC_PCI);
    eval 'sub MGA_TEXORGACC_AGP () {(1<< 1);}' unless defined(&MGA_TEXORGACC_AGP);
    eval 'sub MGA_TEXORG1 () {0x2ca4;}' unless defined(&MGA_TEXORG1);
    eval 'sub MGA_TEXORG2 () {0x2ca8;}' unless defined(&MGA_TEXORG2);
    eval 'sub MGA_TEXORG3 () {0x2cac;}' unless defined(&MGA_TEXORG3);
    eval 'sub MGA_TEXORG4 () {0x2cb0;}' unless defined(&MGA_TEXORG4);
    eval 'sub MGA_TEXTRANS () {0x2c34;}' unless defined(&MGA_TEXTRANS);
    eval 'sub MGA_TEXTRANSHIGH () {0x2c38;}' unless defined(&MGA_TEXTRANSHIGH);
    eval 'sub MGA_TEXWIDTH () {0x2c28;}' unless defined(&MGA_TEXWIDTH);
    eval 'sub MGA_WACCEPTSEQ () {0x1dd4;}' unless defined(&MGA_WACCEPTSEQ);
    eval 'sub MGA_WCODEADDR () {0x1e6c;}' unless defined(&MGA_WCODEADDR);
    eval 'sub MGA_WFLAG () {0x1dc4;}' unless defined(&MGA_WFLAG);
    eval 'sub MGA_WFLAG1 () {0x1de0;}' unless defined(&MGA_WFLAG1);
    eval 'sub MGA_WFLAGNB () {0x1e64;}' unless defined(&MGA_WFLAGNB);
    eval 'sub MGA_WFLAGNB1 () {0x1e08;}' unless defined(&MGA_WFLAGNB1);
    eval 'sub MGA_WGETMSB () {0x1dc8;}' unless defined(&MGA_WGETMSB);
    eval 'sub MGA_WIADDR () {0x1dc0;}' unless defined(&MGA_WIADDR);
    eval 'sub MGA_WIADDR2 () {0x1dd8;}' unless defined(&MGA_WIADDR2);
    eval 'sub MGA_WMODE_SUSPEND () {(0<< 0);}' unless defined(&MGA_WMODE_SUSPEND);
    eval 'sub MGA_WMODE_RESUME () {(1<< 0);}' unless defined(&MGA_WMODE_RESUME);
    eval 'sub MGA_WMODE_JUMP () {(2<< 0);}' unless defined(&MGA_WMODE_JUMP);
    eval 'sub MGA_WMODE_START () {(3<< 0);}' unless defined(&MGA_WMODE_START);
    eval 'sub MGA_WAGP_ENABLE () {(1<< 2);}' unless defined(&MGA_WAGP_ENABLE);
    eval 'sub MGA_WMISC () {0x1e70;}' unless defined(&MGA_WMISC);
    eval 'sub MGA_WUCODECACHE_ENABLE () {(1<< 0);}' unless defined(&MGA_WUCODECACHE_ENABLE);
    eval 'sub MGA_WMASTER_ENABLE () {(1<< 1);}' unless defined(&MGA_WMASTER_ENABLE);
    eval 'sub MGA_WCACHEFLUSH_ENABLE () {(1<< 3);}' unless defined(&MGA_WCACHEFLUSH_ENABLE);
    eval 'sub MGA_WVRTXSZ () {0x1dcc;}' unless defined(&MGA_WVRTXSZ);
    eval 'sub MGA_YBOT () {0x1c9c;}' unless defined(&MGA_YBOT);
    eval 'sub MGA_YDST () {0x1c90;}' unless defined(&MGA_YDST);
    eval 'sub MGA_YDSTLEN () {0x1c88;}' unless defined(&MGA_YDSTLEN);
    eval 'sub MGA_YDSTORG () {0x1c94;}' unless defined(&MGA_YDSTORG);
    eval 'sub MGA_YTOP () {0x1c98;}' unless defined(&MGA_YTOP);
    eval 'sub MGA_ZORG () {0x1c0c;}' unless defined(&MGA_ZORG);
    eval 'sub MGA_EXEC () {0x100;}' unless defined(&MGA_EXEC);
    eval 'sub MGA_AGP_PLL () {0x1e4c;}' unless defined(&MGA_AGP_PLL);
    eval 'sub MGA_AGP2XPLL_DISABLE () {(0<< 0);}' unless defined(&MGA_AGP2XPLL_DISABLE);
    eval 'sub MGA_AGP2XPLL_ENABLE () {(1<< 0);}' unless defined(&MGA_AGP2XPLL_ENABLE);
    eval 'sub MGA_WR0 () {0x2d00;}' unless defined(&MGA_WR0);
    eval 'sub MGA_WR1 () {0x2d04;}' unless defined(&MGA_WR1);
    eval 'sub MGA_WR2 () {0x2d08;}' unless defined(&MGA_WR2);
    eval 'sub MGA_WR3 () {0x2d0c;}' unless defined(&MGA_WR3);
    eval 'sub MGA_WR4 () {0x2d10;}' unless defined(&MGA_WR4);
    eval 'sub MGA_WR5 () {0x2d14;}' unless defined(&MGA_WR5);
    eval 'sub MGA_WR6 () {0x2d18;}' unless defined(&MGA_WR6);
    eval 'sub MGA_WR7 () {0x2d1c;}' unless defined(&MGA_WR7);
    eval 'sub MGA_WR8 () {0x2d20;}' unless defined(&MGA_WR8);
    eval 'sub MGA_WR9 () {0x2d24;}' unless defined(&MGA_WR9);
    eval 'sub MGA_WR10 () {0x2d28;}' unless defined(&MGA_WR10);
    eval 'sub MGA_WR11 () {0x2d2c;}' unless defined(&MGA_WR11);
    eval 'sub MGA_WR12 () {0x2d30;}' unless defined(&MGA_WR12);
    eval 'sub MGA_WR13 () {0x2d34;}' unless defined(&MGA_WR13);
    eval 'sub MGA_WR14 () {0x2d38;}' unless defined(&MGA_WR14);
    eval 'sub MGA_WR15 () {0x2d3c;}' unless defined(&MGA_WR15);
    eval 'sub MGA_WR16 () {0x2d40;}' unless defined(&MGA_WR16);
    eval 'sub MGA_WR17 () {0x2d44;}' unless defined(&MGA_WR17);
    eval 'sub MGA_WR18 () {0x2d48;}' unless defined(&MGA_WR18);
    eval 'sub MGA_WR19 () {0x2d4c;}' unless defined(&MGA_WR19);
    eval 'sub MGA_WR20 () {0x2d50;}' unless defined(&MGA_WR20);
    eval 'sub MGA_WR21 () {0x2d54;}' unless defined(&MGA_WR21);
    eval 'sub MGA_WR22 () {0x2d58;}' unless defined(&MGA_WR22);
    eval 'sub MGA_WR23 () {0x2d5c;}' unless defined(&MGA_WR23);
    eval 'sub MGA_WR24 () {0x2d60;}' unless defined(&MGA_WR24);
    eval 'sub MGA_WR25 () {0x2d64;}' unless defined(&MGA_WR25);
    eval 'sub MGA_WR26 () {0x2d68;}' unless defined(&MGA_WR26);
    eval 'sub MGA_WR27 () {0x2d6c;}' unless defined(&MGA_WR27);
    eval 'sub MGA_WR28 () {0x2d70;}' unless defined(&MGA_WR28);
    eval 'sub MGA_WR29 () {0x2d74;}' unless defined(&MGA_WR29);
    eval 'sub MGA_WR30 () {0x2d78;}' unless defined(&MGA_WR30);
    eval 'sub MGA_WR31 () {0x2d7c;}' unless defined(&MGA_WR31);
    eval 'sub MGA_WR32 () {0x2d80;}' unless defined(&MGA_WR32);
    eval 'sub MGA_WR33 () {0x2d84;}' unless defined(&MGA_WR33);
    eval 'sub MGA_WR34 () {0x2d88;}' unless defined(&MGA_WR34);
    eval 'sub MGA_WR35 () {0x2d8c;}' unless defined(&MGA_WR35);
    eval 'sub MGA_WR36 () {0x2d90;}' unless defined(&MGA_WR36);
    eval 'sub MGA_WR37 () {0x2d94;}' unless defined(&MGA_WR37);
    eval 'sub MGA_WR38 () {0x2d98;}' unless defined(&MGA_WR38);
    eval 'sub MGA_WR39 () {0x2d9c;}' unless defined(&MGA_WR39);
    eval 'sub MGA_WR40 () {0x2da0;}' unless defined(&MGA_WR40);
    eval 'sub MGA_WR41 () {0x2da4;}' unless defined(&MGA_WR41);
    eval 'sub MGA_WR42 () {0x2da8;}' unless defined(&MGA_WR42);
    eval 'sub MGA_WR43 () {0x2dac;}' unless defined(&MGA_WR43);
    eval 'sub MGA_WR44 () {0x2db0;}' unless defined(&MGA_WR44);
    eval 'sub MGA_WR45 () {0x2db4;}' unless defined(&MGA_WR45);
    eval 'sub MGA_WR46 () {0x2db8;}' unless defined(&MGA_WR46);
    eval 'sub MGA_WR47 () {0x2dbc;}' unless defined(&MGA_WR47);
    eval 'sub MGA_WR48 () {0x2dc0;}' unless defined(&MGA_WR48);
    eval 'sub MGA_WR49 () {0x2dc4;}' unless defined(&MGA_WR49);
    eval 'sub MGA_WR50 () {0x2dc8;}' unless defined(&MGA_WR50);
    eval 'sub MGA_WR51 () {0x2dcc;}' unless defined(&MGA_WR51);
    eval 'sub MGA_WR52 () {0x2dd0;}' unless defined(&MGA_WR52);
    eval 'sub MGA_WR53 () {0x2dd4;}' unless defined(&MGA_WR53);
    eval 'sub MGA_WR54 () {0x2dd8;}' unless defined(&MGA_WR54);
    eval 'sub MGA_WR55 () {0x2ddc;}' unless defined(&MGA_WR55);
    eval 'sub MGA_WR56 () {0x2de0;}' unless defined(&MGA_WR56);
    eval 'sub MGA_WR57 () {0x2de4;}' unless defined(&MGA_WR57);
    eval 'sub MGA_WR58 () {0x2de8;}' unless defined(&MGA_WR58);
    eval 'sub MGA_WR59 () {0x2dec;}' unless defined(&MGA_WR59);
    eval 'sub MGA_WR60 () {0x2df0;}' unless defined(&MGA_WR60);
    eval 'sub MGA_WR61 () {0x2df4;}' unless defined(&MGA_WR61);
    eval 'sub MGA_WR62 () {0x2df8;}' unless defined(&MGA_WR62);
    eval 'sub MGA_WR63 () {0x2dfc;}' unless defined(&MGA_WR63);
    eval 'sub MGA_G400_WR_MAGIC () {(1<< 6);}' unless defined(&MGA_G400_WR_MAGIC);
    eval 'sub MGA_G400_WR56_MAGIC () {0x46480000;}' unless defined(&MGA_G400_WR56_MAGIC);
    eval 'sub MGA_ILOAD_ALIGN () {64;}' unless defined(&MGA_ILOAD_ALIGN);
    eval 'sub MGA_ILOAD_MASK () {( &MGA_ILOAD_ALIGN - 1);}' unless defined(&MGA_ILOAD_MASK);
    eval 'sub MGA_DWGCTL_FLUSH () {( &MGA_OPCOD_TEXTURE_TRAP |  &MGA_ATYPE_I |  &MGA_ZMODE_NOZCMP |  &MGA_ARZERO |  &MGA_SGNZERO |  &MGA_BOP_SRC | (15<<  &MGA_TRANS_SHIFT));}' unless defined(&MGA_DWGCTL_FLUSH);
    eval 'sub MGA_DWGCTL_CLEAR () {( &MGA_OPCOD_TRAP |  &MGA_ZMODE_NOZCMP |  &MGA_SOLID |  &MGA_ARZERO |  &MGA_SGNZERO |  &MGA_SHIFTZERO |  &MGA_BOP_SRC | (0<<  &MGA_TRANS_SHIFT) |  &MGA_BLTMOD_BMONOLEF |  &MGA_TRANSC |  &MGA_CLIPDIS);}' unless defined(&MGA_DWGCTL_CLEAR);
    eval 'sub MGA_DWGCTL_COPY () {( &MGA_OPCOD_BITBLT |  &MGA_ATYPE_RPL |  &MGA_SGNZERO |  &MGA_SHIFTZERO |  &MGA_BOP_SRC | (0<<  &MGA_TRANS_SHIFT) |  &MGA_BLTMOD_BFCOL |  &MGA_CLIPDIS);}' unless defined(&MGA_DWGCTL_COPY);
}
1;
