require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UVM_UVM_STAT_H_)) {
    eval 'sub _UVM_UVM_STAT_H_ () {1;}' unless defined(&_UVM_UVM_STAT_H_);
    require 'sys/queue.ph';
    eval 'sub UVMCNT_MASK () {0xf;}' unless defined(&UVMCNT_MASK);
    eval 'sub UVMCNT_CNT () {0;}' unless defined(&UVMCNT_CNT);
    eval 'sub UVMCNT_DEV () {1;}' unless defined(&UVMCNT_DEV);
    if(defined(&_KERNEL)) {
	eval 'sub UVMCNT_INIT {
	    my($CNT,$TYP,$VAL,$NAM,$PRIV) = @_;
    	    eval q( &do {  ($CNT->{c}) = $VAL;  ($CNT->{t}) = $TYP;  ($CNT->{next}) =  &uvm_cnt_head;  &uvm_cnt_head = $CNT;  ($CNT->{name}) = $NAM;  ($CNT->{p}) = $PRIV; }  &while (0));
	}' unless defined(&UVMCNT_INIT);
	eval 'sub UVMCNT_SET {
	    my($C,$V) = @_;
    	    eval q( &do { ($C). &c = ($V); }  &while (0));
	}' unless defined(&UVMCNT_SET);
	eval 'sub UVMCNT_ADD {
	    my($C,$V) = @_;
    	    eval q( &do { ($C). &c += ($V); }  &while (0));
	}' unless defined(&UVMCNT_ADD);
	eval 'sub UVMCNT_INCR {
	    my($C) = @_;
    	    eval q( &UVMCNT_ADD($C,1));
	}' unless defined(&UVMCNT_INCR);
	eval 'sub UVMCNT_DECR {
	    my($C) = @_;
    	    eval q( &UVMCNT_ADD($C,-1));
	}' unless defined(&UVMCNT_DECR);
    }
    eval 'sub MAXHISTS () {32;}' unless defined(&MAXHISTS);
    eval 'sub UVMHIST_MAPHIST () {0x1;}' unless defined(&UVMHIST_MAPHIST);
    eval 'sub UVMHIST_PDHIST () {0x2;}' unless defined(&UVMHIST_PDHIST);
    eval 'sub UVMHIST_UBCHIST () {0x4;}' unless defined(&UVMHIST_UBCHIST);
    eval 'sub UVMHIST_PGHIST () {0x8;}' unless defined(&UVMHIST_PGHIST);
    if(defined(&_KERNEL)) {
	unless(defined(&UVMHIST)) {
	    eval 'sub UVMHIST_DECL {
	        my($NAME) = @_;
    		eval q();
	    }' unless defined(&UVMHIST_DECL);
	    eval 'sub UVMHIST_INIT {
	        my($NAME,$N) = @_;
    		eval q();
	    }' unless defined(&UVMHIST_INIT);
	    eval 'sub UVMHIST_INIT_STATIC {
	        my($NAME,$BUF) = @_;
    		eval q();
	    }' unless defined(&UVMHIST_INIT_STATIC);
	    eval 'sub UVMHIST_LOG {
	        my($NAME,$FMT,$A,$B,$C,$D) = @_;
    		eval q();
	    }' unless defined(&UVMHIST_LOG);
	    eval 'sub UVMHIST_CALLED {
	        my($NAME) = @_;
    		eval q();
	    }' unless defined(&UVMHIST_CALLED);
	    eval 'sub UVMHIST_FUNC {
	        my($FNAME) = @_;
    		eval q();
	    }' unless defined(&UVMHIST_FUNC);
	    eval 'sub uvmhist_dump {
	        my($NAME) = @_;
    		eval q();
	    }' unless defined(&uvmhist_dump);
	} else {
	    eval 'sub UVMHIST_DECL {
	        my($NAME) = @_;
    		eval q(\'struct uvm_history\' $NAME);
	    }' unless defined(&UVMHIST_DECL);
	    eval 'sub UVMHIST_INIT {
	        my($NAME,$N) = @_;
    		eval q( &do { ($NAME). &name =  &__STRING($NAME); ($NAME). &namelen =  &strlen(($NAME). &name); ($NAME). &n = ($N); ($NAME). &f = 0;  &simple_lock_init(($NAME). &l); ($NAME). &e =   &malloc($sizeof{\'struct uvm_history_ent\'} * ($N),  &M_TEMP,  &M_WAITOK| &M_ZERO);  &LIST_INSERT_HEAD( &uvm_histories, ($NAME),  &list); }  &while (0));
	    }' unless defined(&UVMHIST_INIT);
	    eval 'sub UVMHIST_INIT_STATIC {
	        my($NAME,$BUF) = @_;
    		eval q( &do { ($NAME). &name =  &__STRING($NAME); ($NAME). &namelen =  &strlen(($NAME). &name); ($NAME). &n = $sizeof{$BUF} / $sizeof{\'struct uvm_history_ent\'}; ($NAME). &f = 0;  &simple_lock_init(($NAME). &l); ($NAME). &e =  ($BUF);  &memset(($NAME). &e, 0, $sizeof{\'struct uvm_history_ent\'} * ($NAME). &n);  &LIST_INSERT_HEAD( &uvm_histories, ($NAME),  &list); }  &while (0));
	    }' unless defined(&UVMHIST_INIT_STATIC);
	    if(defined( &UVMHIST_PRINT)) {
		eval 'sub UVMHIST_PRINTNOW {
		    my($E) = @_;
    		    eval q( &do {  &if ( &uvmhist_print_enabled) {  &uvmhist_print($E);  &DELAY(100000); } }  &while (0));
		}' unless defined(&UVMHIST_PRINTNOW);
	    } else {
		eval 'sub UVMHIST_PRINTNOW {
		    my($E) = @_;
    		    eval q();
		}' unless defined(&UVMHIST_PRINTNOW);
	    }
	    eval 'sub UVMHIST_LOG {
	        my($NAME,$FMT,$A,$B,$C,$D) = @_;
    		eval q( &do { \'int\'  &_i_,  &_s_ =  &splhigh();  &simple_lock(&. &l);  &_i_ = . &f; . &f = ( &_i_ + 1) % . &n;  &simple_unlock(&. &l);  &splx;  &if (! &cold)  &microtime(&. ($e[&_i_]->{tv})); . ($e[&_i_]->{fmt}) = ; . ($e[&_i_]->{fmtlen}) =  &strlen(. ($e[&_i_]->{fmt})); . ($e[&_i_]->{fn}) =  &_uvmhist_name; . ($e[&_i_]->{fnlen}) =  &strlen(. ($e[&_i_]->{fn})); . ($e[&_i_]->{call}) =  &_uvmhist_call; . ($e[&_i_]->{v[0]}) = ; . ($e[&_i_]->{v[1]}) = ; . ($e[&_i_]->{v[2]}) = ; . ($e[&_i_]->{v[3]}) = ($D);  &UVMHIST_PRINTNOW((($NAME). $e[ &_i_])); }  &while (0));
	    }' unless defined(&UVMHIST_LOG);
	    eval 'sub UVMHIST_CALLED {
	        my($NAME) = @_;
    		eval q( &do { { \'int\'  &s =  &splhigh();  &simple_lock(($NAME). &l);  &_uvmhist_call =  &_uvmhist_cnt++;  &simple_unlock(($NAME). &l);  &splx( &s); }  &UVMHIST_LOG($NAME,\\"called!\\", 0, 0, 0, 0); }  &while (0));
	    }' unless defined(&UVMHIST_CALLED);
	    eval 'sub UVMHIST_FUNC {
	        my($FNAME) = @_;
    		eval q( &static \'int\'  &_uvmhist_cnt = 0;  &static \'char\' * &_uvmhist_name = $FNAME; \'int\'  &_uvmhist_call;);
	    }' unless defined(&UVMHIST_FUNC);
	    eval 'sub uvmhist_print {
	        my($e) = @_;
    		eval q(*$e; {  &printf(\\"%06ld.%06ld \\",  ($e->{tv}->{tv_sec}),  ($e->{tv}->{tv_usec}));  &printf(\\"%s#%ld: \\",  ($e->{fn}),  ($e->{call}));  &printf( ($e->{fmt}),  ($e->{v[0]}),  ($e->{v[1]}),  ($e->{v[2]}),  ($e->{v[3]}));  &printf(\\"\\\\n\\"); });
	    }' unless defined(&uvmhist_print);
	}
    }
}
1;
