require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_UVM_UVM_PAGE_H_)) {
    eval 'sub _UVM_UVM_PAGE_H_ () {1;}' unless defined(&_UVM_UVM_PAGE_H_);
    require 'uvm/uvm_extern.ph';
    require 'uvm/uvm_pglist.ph';
    if(defined(&__HAVE_VM_PAGE_MD)) {
    }
    if(defined( &UVM_PAGE_TRKOWN)) {
    }
    eval 'sub PG_BUSY () {0x1;}' unless defined(&PG_BUSY);
    eval 'sub PG_WANTED () {0x2;}' unless defined(&PG_WANTED);
    eval 'sub PG_TABLED () {0x4;}' unless defined(&PG_TABLED);
    eval 'sub PG_CLEAN () {0x8;}' unless defined(&PG_CLEAN);
    eval 'sub PG_CLEANCHK () {0x10;}' unless defined(&PG_CLEANCHK);
    eval 'sub PG_RELEASED () {0x20;}' unless defined(&PG_RELEASED);
    eval 'sub PG_FAKE () {0x40;}' unless defined(&PG_FAKE);
    eval 'sub PG_RDONLY () {0x80;}' unless defined(&PG_RDONLY);
    eval 'sub PG_ZERO () {0x100;}' unless defined(&PG_ZERO);
    eval 'sub PG_PAGER1 () {0x1000;}' unless defined(&PG_PAGER1);
    eval 'sub PG_MASK () {0xffff;}' unless defined(&PG_MASK);
    eval 'sub PQ_FREE () {0x10000;}' unless defined(&PQ_FREE);
    eval 'sub PQ_INACTIVE () {0x20000;}' unless defined(&PQ_INACTIVE);
    eval 'sub PQ_ACTIVE () {0x40000;}' unless defined(&PQ_ACTIVE);
    eval 'sub PQ_ANON () {0x100000;}' unless defined(&PQ_ANON);
    eval 'sub PQ_AOBJ () {0x200000;}' unless defined(&PQ_AOBJ);
    eval 'sub PQ_SWAPBACKED () {( &PQ_ANON| &PQ_AOBJ);}' unless defined(&PQ_SWAPBACKED);
    eval 'sub PQ_ENCRYPT () {0x400000;}' unless defined(&PQ_ENCRYPT);
    eval 'sub PQ_MASK () {0xff0000;}' unless defined(&PQ_MASK);
    eval 'sub PG_PMAP0 () {0x1000000;}' unless defined(&PG_PMAP0);
    eval 'sub PG_PMAP1 () {0x2000000;}' unless defined(&PG_PMAP1);
    eval 'sub PG_PMAP2 () {0x4000000;}' unless defined(&PG_PMAP2);
    eval 'sub PG_PMAP3 () {0x8000000;}' unless defined(&PG_PMAP3);
    eval 'sub VM_PSTRAT_RANDOM () {1;}' unless defined(&VM_PSTRAT_RANDOM);
    eval 'sub VM_PSTRAT_BSEARCH () {2;}' unless defined(&VM_PSTRAT_BSEARCH);
    eval 'sub VM_PSTRAT_BIGFIRST () {3;}' unless defined(&VM_PSTRAT_BIGFIRST);
    if(defined(&__HAVE_PMAP_PHYSSEG)) {
    }
    if(defined(&_KERNEL)) {
	if(defined( &UVM_PAGE_TRKOWN)) {
	}
	if(!defined( &PMAP_STEAL_MEMORY)) {
	}
	if((defined(&VM_PHYSSEG_MAX) ? &VM_PHYSSEG_MAX : undef) == 1) {
	} else {
	}
	eval 'sub uvm_lock_pageq () {
	    eval q( &simple_lock( ($uvm->{pageqlock})));
	}' unless defined(&uvm_lock_pageq);
	eval 'sub uvm_unlock_pageq () {
	    eval q( &simple_unlock( ($uvm->{pageqlock})));
	}' unless defined(&uvm_unlock_pageq);
	eval 'sub uvm_lock_fpageq () {
	    eval q( &mtx_enter( ($uvm->{fpageqlock})););
	}' unless defined(&uvm_lock_fpageq);
	eval 'sub uvm_unlock_fpageq () {
	    eval q( &mtx_leave( ($uvm->{fpageqlock})););
	}' unless defined(&uvm_unlock_fpageq);
	eval 'sub uvm_pagehash {
	    my($obj,$off) = @_;
    	    eval q((($obj+ &atop($off)) &  ($uvm->{page_hashmask})));
	}' unless defined(&uvm_pagehash);
	eval 'sub UVM_PAGEZERO_TARGET () {( ($uvmexp->{free}));}' unless defined(&UVM_PAGEZERO_TARGET);
	eval 'sub VM_PAGE_TO_PHYS {
	    my($entry) = @_;
    	    eval q((($entry)-> &phys_addr));
	}' unless defined(&VM_PAGE_TO_PHYS);
	eval 'sub VM_PAGE_IS_FREE {
	    my($entry) = @_;
    	    eval q((($entry)-> &pg_flags &  &PQ_FREE));
	}' unless defined(&VM_PAGE_IS_FREE);
    }
}
1;
