require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&HEADER_ENGINE_H)) {
    eval 'sub HEADER_ENGINE_H () {1;}' unless defined(&HEADER_ENGINE_H);
    require 'openssl/opensslconf.ph';
    if(defined(&OPENSSL_NO_ENGINE)) {
	die("ENGINE\ is\ disabled\.");
    }
    unless(defined(&OPENSSL_NO_DEPRECATED)) {
	require 'openssl/bn.ph';
	unless(defined(&OPENSSL_NO_RSA)) {
	    require 'openssl/rsa.ph';
	}
	unless(defined(&OPENSSL_NO_DSA)) {
	    require 'openssl/dsa.ph';
	}
	unless(defined(&OPENSSL_NO_DH)) {
	    require 'openssl/dh.ph';
	}
	unless(defined(&OPENSSL_NO_ECDH)) {
	    require 'openssl/ecdh.ph';
	}
	unless(defined(&OPENSSL_NO_ECDSA)) {
	    require 'openssl/ecdsa.ph';
	}
	require 'openssl/rand.ph';
	require 'openssl/store.ph';
	require 'openssl/ui.ph';
	require 'openssl/err.ph';
    }
    require 'openssl/x509.ph';
    require 'openssl/ossl_typ.ph';
    require 'openssl/symhacks.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub ENGINE_METHOD_RSA () {0x1;}' unless defined(&ENGINE_METHOD_RSA);
    eval 'sub ENGINE_METHOD_DSA () {0x2;}' unless defined(&ENGINE_METHOD_DSA);
    eval 'sub ENGINE_METHOD_DH () {0x4;}' unless defined(&ENGINE_METHOD_DH);
    eval 'sub ENGINE_METHOD_RAND () {0x8;}' unless defined(&ENGINE_METHOD_RAND);
    eval 'sub ENGINE_METHOD_ECDH () {0x10;}' unless defined(&ENGINE_METHOD_ECDH);
    eval 'sub ENGINE_METHOD_ECDSA () {0x20;}' unless defined(&ENGINE_METHOD_ECDSA);
    eval 'sub ENGINE_METHOD_CIPHERS () {0x40;}' unless defined(&ENGINE_METHOD_CIPHERS);
    eval 'sub ENGINE_METHOD_DIGESTS () {0x80;}' unless defined(&ENGINE_METHOD_DIGESTS);
    eval 'sub ENGINE_METHOD_STORE () {0x100;}' unless defined(&ENGINE_METHOD_STORE);
    eval 'sub ENGINE_METHOD_ALL () {0xffff;}' unless defined(&ENGINE_METHOD_ALL);
    eval 'sub ENGINE_METHOD_NONE () {0x;}' unless defined(&ENGINE_METHOD_NONE);
    eval 'sub ENGINE_TABLE_FLAG_NOINIT () {0x1;}' unless defined(&ENGINE_TABLE_FLAG_NOINIT);
    eval 'sub ENGINE_FLAGS_MANUAL_CMD_CTRL () {0x2;}' unless defined(&ENGINE_FLAGS_MANUAL_CMD_CTRL);
    eval 'sub ENGINE_FLAGS_BY_ID_COPY () {0x4;}' unless defined(&ENGINE_FLAGS_BY_ID_COPY);
    eval 'sub ENGINE_CMD_FLAG_NUMERIC () {0x1;}' unless defined(&ENGINE_CMD_FLAG_NUMERIC);
    eval 'sub ENGINE_CMD_FLAG_STRING () {0x2;}' unless defined(&ENGINE_CMD_FLAG_STRING);
    eval 'sub ENGINE_CMD_FLAG_NO_INPUT () {0x4;}' unless defined(&ENGINE_CMD_FLAG_NO_INPUT);
    eval 'sub ENGINE_CMD_FLAG_INTERNAL () {0x8;}' unless defined(&ENGINE_CMD_FLAG_INTERNAL);
    eval 'sub ENGINE_CTRL_SET_LOGSTREAM () {1;}' unless defined(&ENGINE_CTRL_SET_LOGSTREAM);
    eval 'sub ENGINE_CTRL_SET_PASSWORD_CALLBACK () {2;}' unless defined(&ENGINE_CTRL_SET_PASSWORD_CALLBACK);
    eval 'sub ENGINE_CTRL_HUP () {3;}' unless defined(&ENGINE_CTRL_HUP);
    eval 'sub ENGINE_CTRL_SET_USER_INTERFACE () {4;}' unless defined(&ENGINE_CTRL_SET_USER_INTERFACE);
    eval 'sub ENGINE_CTRL_SET_CALLBACK_DATA () {5;}' unless defined(&ENGINE_CTRL_SET_CALLBACK_DATA);
    eval 'sub ENGINE_CTRL_LOAD_CONFIGURATION () {6;}' unless defined(&ENGINE_CTRL_LOAD_CONFIGURATION);
    eval 'sub ENGINE_CTRL_LOAD_SECTION () {7;}' unless defined(&ENGINE_CTRL_LOAD_SECTION);
    eval 'sub ENGINE_CTRL_HAS_CTRL_FUNCTION () {10;}' unless defined(&ENGINE_CTRL_HAS_CTRL_FUNCTION);
    eval 'sub ENGINE_CTRL_GET_FIRST_CMD_TYPE () {11;}' unless defined(&ENGINE_CTRL_GET_FIRST_CMD_TYPE);
    eval 'sub ENGINE_CTRL_GET_NEXT_CMD_TYPE () {12;}' unless defined(&ENGINE_CTRL_GET_NEXT_CMD_TYPE);
    eval 'sub ENGINE_CTRL_GET_CMD_FROM_NAME () {13;}' unless defined(&ENGINE_CTRL_GET_CMD_FROM_NAME);
    eval 'sub ENGINE_CTRL_GET_NAME_LEN_FROM_CMD () {14;}' unless defined(&ENGINE_CTRL_GET_NAME_LEN_FROM_CMD);
    eval 'sub ENGINE_CTRL_GET_NAME_FROM_CMD () {15;}' unless defined(&ENGINE_CTRL_GET_NAME_FROM_CMD);
    eval 'sub ENGINE_CTRL_GET_DESC_LEN_FROM_CMD () {16;}' unless defined(&ENGINE_CTRL_GET_DESC_LEN_FROM_CMD);
    eval 'sub ENGINE_CTRL_GET_DESC_FROM_CMD () {17;}' unless defined(&ENGINE_CTRL_GET_DESC_FROM_CMD);
    eval 'sub ENGINE_CTRL_GET_CMD_FLAGS () {18;}' unless defined(&ENGINE_CTRL_GET_CMD_FLAGS);
    eval 'sub ENGINE_CMD_BASE () {200;}' unless defined(&ENGINE_CMD_BASE);
    eval 'sub ENGINE_CTRL_CHIL_SET_FORKCHECK () {100;}' unless defined(&ENGINE_CTRL_CHIL_SET_FORKCHECK);
    eval 'sub ENGINE_CTRL_CHIL_NO_LOCKING () {101;}' unless defined(&ENGINE_CTRL_CHIL_NO_LOCKING);
    unless(defined(&OPENSSL_NO_STATIC_ENGINE)) {
	unless(defined(&OPENSSL_NO_GMP)) {
	}
    }
    unless(defined(&OPENSSL_NO_CAPIENG)) {
    }
    eval 'sub OSSL_DYNAMIC_VERSION () {0x20000;}' unless defined(&OSSL_DYNAMIC_VERSION);
    eval 'sub OSSL_DYNAMIC_OLDEST () {0x20000;}' unless defined(&OSSL_DYNAMIC_OLDEST);
    eval 'sub IMPLEMENT_DYNAMIC_CHECK_FN () {
        eval q( &OPENSSL_EXPORT  &unsigned long v_check {  &if( &v >=  &OSSL_DYNAMIC_OLDEST)  &return  &OSSL_DYNAMIC_VERSION;  &return 0; });
    }' unless defined(&IMPLEMENT_DYNAMIC_CHECK_FN);
    eval 'sub IMPLEMENT_DYNAMIC_BIND_FN {
        my($fn) = @_;
	    eval q( &OPENSSL_EXPORT \'int\'  &bind_engine( &ENGINE * &e,  &const \'char\' * &id,  &const  &dynamic_fns * &fns) {  &if( &ENGINE_get_static_state() ==  ($fns->{static_state}))  &goto  &skip_cbs;  &if(! &CRYPTO_set_mem_functions( ($fns->{mem_fns}->{malloc_cb}),  ($fns->{mem_fns}->{realloc_cb}),  ($fns->{mem_fns}->{free_cb})))  &return 0;  &CRYPTO_set_locking_callback( ($fns->{lock_fns}->{lock_locking_cb}));  &CRYPTO_set_add_lock_callback( ($fns->{lock_fns}->{lock_add_lock_cb}));  &CRYPTO_set_dynlock_create_callback( ($fns->{lock_fns}->{dynlock_create_cb}));  &CRYPTO_set_dynlock_lock_callback( ($fns->{lock_fns}->{dynlock_lock_cb}));  &CRYPTO_set_dynlock_destroy_callback( ($fns->{lock_fns}->{dynlock_destroy_cb}));  &if(! &CRYPTO_set_ex_data_implementation( ($fns->{ex_data_fns})))  &return 0;  &if(! &ERR_set_implementation( ($fns->{err_fns})))  &return 0;  &skip_cbs:  &if(!$fn( &e, &id))  &return 0;  &return 1; });
    }' unless defined(&IMPLEMENT_DYNAMIC_BIND_FN);
    if(defined( &__OpenBSD__) || defined( &__FreeBSD__)) {
    }
    eval 'sub ENGINE_F_DYNAMIC_CTRL () {180;}' unless defined(&ENGINE_F_DYNAMIC_CTRL);
    eval 'sub ENGINE_F_DYNAMIC_GET_DATA_CTX () {181;}' unless defined(&ENGINE_F_DYNAMIC_GET_DATA_CTX);
    eval 'sub ENGINE_F_DYNAMIC_LOAD () {182;}' unless defined(&ENGINE_F_DYNAMIC_LOAD);
    eval 'sub ENGINE_F_DYNAMIC_SET_DATA_CTX () {183;}' unless defined(&ENGINE_F_DYNAMIC_SET_DATA_CTX);
    eval 'sub ENGINE_F_ENGINE_ADD () {105;}' unless defined(&ENGINE_F_ENGINE_ADD);
    eval 'sub ENGINE_F_ENGINE_BY_ID () {106;}' unless defined(&ENGINE_F_ENGINE_BY_ID);
    eval 'sub ENGINE_F_ENGINE_CMD_IS_EXECUTABLE () {170;}' unless defined(&ENGINE_F_ENGINE_CMD_IS_EXECUTABLE);
    eval 'sub ENGINE_F_ENGINE_CTRL () {142;}' unless defined(&ENGINE_F_ENGINE_CTRL);
    eval 'sub ENGINE_F_ENGINE_CTRL_CMD () {178;}' unless defined(&ENGINE_F_ENGINE_CTRL_CMD);
    eval 'sub ENGINE_F_ENGINE_CTRL_CMD_STRING () {171;}' unless defined(&ENGINE_F_ENGINE_CTRL_CMD_STRING);
    eval 'sub ENGINE_F_ENGINE_FINISH () {107;}' unless defined(&ENGINE_F_ENGINE_FINISH);
    eval 'sub ENGINE_F_ENGINE_FREE_UTIL () {108;}' unless defined(&ENGINE_F_ENGINE_FREE_UTIL);
    eval 'sub ENGINE_F_ENGINE_GET_CIPHER () {185;}' unless defined(&ENGINE_F_ENGINE_GET_CIPHER);
    eval 'sub ENGINE_F_ENGINE_GET_DEFAULT_TYPE () {177;}' unless defined(&ENGINE_F_ENGINE_GET_DEFAULT_TYPE);
    eval 'sub ENGINE_F_ENGINE_GET_DIGEST () {186;}' unless defined(&ENGINE_F_ENGINE_GET_DIGEST);
    eval 'sub ENGINE_F_ENGINE_GET_NEXT () {115;}' unless defined(&ENGINE_F_ENGINE_GET_NEXT);
    eval 'sub ENGINE_F_ENGINE_GET_PREV () {116;}' unless defined(&ENGINE_F_ENGINE_GET_PREV);
    eval 'sub ENGINE_F_ENGINE_INIT () {119;}' unless defined(&ENGINE_F_ENGINE_INIT);
    eval 'sub ENGINE_F_ENGINE_LIST_ADD () {120;}' unless defined(&ENGINE_F_ENGINE_LIST_ADD);
    eval 'sub ENGINE_F_ENGINE_LIST_REMOVE () {121;}' unless defined(&ENGINE_F_ENGINE_LIST_REMOVE);
    eval 'sub ENGINE_F_ENGINE_LOAD_PRIVATE_KEY () {150;}' unless defined(&ENGINE_F_ENGINE_LOAD_PRIVATE_KEY);
    eval 'sub ENGINE_F_ENGINE_LOAD_PUBLIC_KEY () {151;}' unless defined(&ENGINE_F_ENGINE_LOAD_PUBLIC_KEY);
    eval 'sub ENGINE_F_ENGINE_LOAD_SSL_CLIENT_CERT () {192;}' unless defined(&ENGINE_F_ENGINE_LOAD_SSL_CLIENT_CERT);
    eval 'sub ENGINE_F_ENGINE_NEW () {122;}' unless defined(&ENGINE_F_ENGINE_NEW);
    eval 'sub ENGINE_F_ENGINE_REMOVE () {123;}' unless defined(&ENGINE_F_ENGINE_REMOVE);
    eval 'sub ENGINE_F_ENGINE_SET_DEFAULT_STRING () {189;}' unless defined(&ENGINE_F_ENGINE_SET_DEFAULT_STRING);
    eval 'sub ENGINE_F_ENGINE_SET_DEFAULT_TYPE () {126;}' unless defined(&ENGINE_F_ENGINE_SET_DEFAULT_TYPE);
    eval 'sub ENGINE_F_ENGINE_SET_ID () {129;}' unless defined(&ENGINE_F_ENGINE_SET_ID);
    eval 'sub ENGINE_F_ENGINE_SET_NAME () {130;}' unless defined(&ENGINE_F_ENGINE_SET_NAME);
    eval 'sub ENGINE_F_ENGINE_TABLE_REGISTER () {184;}' unless defined(&ENGINE_F_ENGINE_TABLE_REGISTER);
    eval 'sub ENGINE_F_ENGINE_UNLOAD_KEY () {152;}' unless defined(&ENGINE_F_ENGINE_UNLOAD_KEY);
    eval 'sub ENGINE_F_ENGINE_UNLOCKED_FINISH () {191;}' unless defined(&ENGINE_F_ENGINE_UNLOCKED_FINISH);
    eval 'sub ENGINE_F_ENGINE_UP_REF () {190;}' unless defined(&ENGINE_F_ENGINE_UP_REF);
    eval 'sub ENGINE_F_INT_CTRL_HELPER () {172;}' unless defined(&ENGINE_F_INT_CTRL_HELPER);
    eval 'sub ENGINE_F_INT_ENGINE_CONFIGURE () {188;}' unless defined(&ENGINE_F_INT_ENGINE_CONFIGURE);
    eval 'sub ENGINE_F_INT_ENGINE_MODULE_INIT () {187;}' unless defined(&ENGINE_F_INT_ENGINE_MODULE_INIT);
    eval 'sub ENGINE_F_LOG_MESSAGE () {141;}' unless defined(&ENGINE_F_LOG_MESSAGE);
    eval 'sub ENGINE_R_ALREADY_LOADED () {100;}' unless defined(&ENGINE_R_ALREADY_LOADED);
    eval 'sub ENGINE_R_ARGUMENT_IS_NOT_A_NUMBER () {133;}' unless defined(&ENGINE_R_ARGUMENT_IS_NOT_A_NUMBER);
    eval 'sub ENGINE_R_CMD_NOT_EXECUTABLE () {134;}' unless defined(&ENGINE_R_CMD_NOT_EXECUTABLE);
    eval 'sub ENGINE_R_COMMAND_TAKES_INPUT () {135;}' unless defined(&ENGINE_R_COMMAND_TAKES_INPUT);
    eval 'sub ENGINE_R_COMMAND_TAKES_NO_INPUT () {136;}' unless defined(&ENGINE_R_COMMAND_TAKES_NO_INPUT);
    eval 'sub ENGINE_R_CONFLICTING_ENGINE_ID () {103;}' unless defined(&ENGINE_R_CONFLICTING_ENGINE_ID);
    eval 'sub ENGINE_R_CTRL_COMMAND_NOT_IMPLEMENTED () {119;}' unless defined(&ENGINE_R_CTRL_COMMAND_NOT_IMPLEMENTED);
    eval 'sub ENGINE_R_DH_NOT_IMPLEMENTED () {139;}' unless defined(&ENGINE_R_DH_NOT_IMPLEMENTED);
    eval 'sub ENGINE_R_DSA_NOT_IMPLEMENTED () {140;}' unless defined(&ENGINE_R_DSA_NOT_IMPLEMENTED);
    eval 'sub ENGINE_R_DSO_FAILURE () {104;}' unless defined(&ENGINE_R_DSO_FAILURE);
    eval 'sub ENGINE_R_DSO_NOT_FOUND () {132;}' unless defined(&ENGINE_R_DSO_NOT_FOUND);
    eval 'sub ENGINE_R_ENGINES_SECTION_ERROR () {148;}' unless defined(&ENGINE_R_ENGINES_SECTION_ERROR);
    eval 'sub ENGINE_R_ENGINE_IS_NOT_IN_LIST () {105;}' unless defined(&ENGINE_R_ENGINE_IS_NOT_IN_LIST);
    eval 'sub ENGINE_R_ENGINE_SECTION_ERROR () {149;}' unless defined(&ENGINE_R_ENGINE_SECTION_ERROR);
    eval 'sub ENGINE_R_FAILED_LOADING_PRIVATE_KEY () {128;}' unless defined(&ENGINE_R_FAILED_LOADING_PRIVATE_KEY);
    eval 'sub ENGINE_R_FAILED_LOADING_PUBLIC_KEY () {129;}' unless defined(&ENGINE_R_FAILED_LOADING_PUBLIC_KEY);
    eval 'sub ENGINE_R_FINISH_FAILED () {106;}' unless defined(&ENGINE_R_FINISH_FAILED);
    eval 'sub ENGINE_R_GET_HANDLE_FAILED () {107;}' unless defined(&ENGINE_R_GET_HANDLE_FAILED);
    eval 'sub ENGINE_R_ID_OR_NAME_MISSING () {108;}' unless defined(&ENGINE_R_ID_OR_NAME_MISSING);
    eval 'sub ENGINE_R_INIT_FAILED () {109;}' unless defined(&ENGINE_R_INIT_FAILED);
    eval 'sub ENGINE_R_INTERNAL_LIST_ERROR () {110;}' unless defined(&ENGINE_R_INTERNAL_LIST_ERROR);
    eval 'sub ENGINE_R_INVALID_ARGUMENT () {143;}' unless defined(&ENGINE_R_INVALID_ARGUMENT);
    eval 'sub ENGINE_R_INVALID_CMD_NAME () {137;}' unless defined(&ENGINE_R_INVALID_CMD_NAME);
    eval 'sub ENGINE_R_INVALID_CMD_NUMBER () {138;}' unless defined(&ENGINE_R_INVALID_CMD_NUMBER);
    eval 'sub ENGINE_R_INVALID_INIT_VALUE () {151;}' unless defined(&ENGINE_R_INVALID_INIT_VALUE);
    eval 'sub ENGINE_R_INVALID_STRING () {150;}' unless defined(&ENGINE_R_INVALID_STRING);
    eval 'sub ENGINE_R_NOT_INITIALISED () {117;}' unless defined(&ENGINE_R_NOT_INITIALISED);
    eval 'sub ENGINE_R_NOT_LOADED () {112;}' unless defined(&ENGINE_R_NOT_LOADED);
    eval 'sub ENGINE_R_NO_CONTROL_FUNCTION () {120;}' unless defined(&ENGINE_R_NO_CONTROL_FUNCTION);
    eval 'sub ENGINE_R_NO_INDEX () {144;}' unless defined(&ENGINE_R_NO_INDEX);
    eval 'sub ENGINE_R_NO_LOAD_FUNCTION () {125;}' unless defined(&ENGINE_R_NO_LOAD_FUNCTION);
    eval 'sub ENGINE_R_NO_REFERENCE () {130;}' unless defined(&ENGINE_R_NO_REFERENCE);
    eval 'sub ENGINE_R_NO_SUCH_ENGINE () {116;}' unless defined(&ENGINE_R_NO_SUCH_ENGINE);
    eval 'sub ENGINE_R_NO_UNLOAD_FUNCTION () {126;}' unless defined(&ENGINE_R_NO_UNLOAD_FUNCTION);
    eval 'sub ENGINE_R_PROVIDE_PARAMETERS () {113;}' unless defined(&ENGINE_R_PROVIDE_PARAMETERS);
    eval 'sub ENGINE_R_RSA_NOT_IMPLEMENTED () {141;}' unless defined(&ENGINE_R_RSA_NOT_IMPLEMENTED);
    eval 'sub ENGINE_R_UNIMPLEMENTED_CIPHER () {146;}' unless defined(&ENGINE_R_UNIMPLEMENTED_CIPHER);
    eval 'sub ENGINE_R_UNIMPLEMENTED_DIGEST () {147;}' unless defined(&ENGINE_R_UNIMPLEMENTED_DIGEST);
    eval 'sub ENGINE_R_VERSION_INCOMPATIBILITY () {145;}' unless defined(&ENGINE_R_VERSION_INCOMPATIBILITY);
    if(defined(&__cplusplus)) {
    }
}
1;
