require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&BBSIZE)) {
    sub BBSIZE () {	1024;}
}
unless(defined(&BBOFF)) {
    sub BBOFF () {	(( &off_t)(0));}
}
unless(defined(&BBLOCK)) {
    sub BBLOCK () {	0;}
}
unless(defined(&NTFS_MFTINO)) {
    sub NTFS_MFTINO () {	0;}
}
unless(defined(&NTFS_VOLUMEINO)) {
    sub NTFS_VOLUMEINO () {	3;}
}
unless(defined(&NTFS_ATTRDEFINO)) {
    sub NTFS_ATTRDEFINO () {	4;}
}
unless(defined(&NTFS_ROOTINO)) {
    sub NTFS_ROOTINO () {	5;}
}
unless(defined(&NTFS_BITMAPINO)) {
    sub NTFS_BITMAPINO () {	6;}
}
unless(defined(&NTFS_BOOTINO)) {
    sub NTFS_BOOTINO () {	7;}
}
unless(defined(&NTFS_BADCLUSINO)) {
    sub NTFS_BADCLUSINO () {	8;}
}
unless(defined(&NTFS_UPCASEINO)) {
    sub NTFS_UPCASEINO () {	10;}
}
unless(defined(&NTFS_MAXFILENAME)) {
    sub NTFS_MAXFILENAME () {	255;}
}
unless(defined(&NTFS_AF_INRUN)) {
    sub NTFS_AF_INRUN () {	0x1;}
}
unless(defined(&NTFS_A_STD)) {
    sub NTFS_A_STD () {	0x10;}
}
unless(defined(&NTFS_A_ATTRLIST)) {
    sub NTFS_A_ATTRLIST () {	0x20;}
}
unless(defined(&NTFS_A_NAME)) {
    sub NTFS_A_NAME () {	0x30;}
}
unless(defined(&NTFS_A_VOLUMENAME)) {
    sub NTFS_A_VOLUMENAME () {	0x60;}
}
unless(defined(&NTFS_A_DATA)) {
    sub NTFS_A_DATA () {	0x80;}
}
unless(defined(&NTFS_A_INDXROOT)) {
    sub NTFS_A_INDXROOT () {	0x90;}
}
unless(defined(&NTFS_A_INDX)) {
    sub NTFS_A_INDX () {	0xa0;}
}
unless(defined(&NTFS_A_INDXBITMAP)) {
    sub NTFS_A_INDXBITMAP () {	0xb0;}
}
unless(defined(&NTFS_MAXATTRNAME)) {
    sub NTFS_MAXATTRNAME () {	255;}
}
unless(defined(&a_r)) {
    sub a_r () {	 ($a_S->{a_S_r});}
}
unless(defined(&a_nr)) {
    sub a_nr () {	 ($a_S->{a_S_nr});}
}
unless(defined(&NTFS_FFLAG_RDONLY)) {
    sub NTFS_FFLAG_RDONLY () {	0x1;}
}
unless(defined(&NTFS_FFLAG_HIDDEN)) {
    sub NTFS_FFLAG_HIDDEN () {	0x2;}
}
unless(defined(&NTFS_FFLAG_SYSTEM)) {
    sub NTFS_FFLAG_SYSTEM () {	0x4;}
}
unless(defined(&NTFS_FFLAG_ARCHIVE)) {
    sub NTFS_FFLAG_ARCHIVE () {	0x20;}
}
unless(defined(&NTFS_FFLAG_COMPRESSED)) {
    sub NTFS_FFLAG_COMPRESSED () {	0x800;}
}
unless(defined(&NTFS_FFLAG_DIR)) {
    sub NTFS_FFLAG_DIR () {	0x10000000;}
}
unless(defined(&NTFS_IRFLAG_INDXALLOC)) {
    sub NTFS_IRFLAG_INDXALLOC () {	0x1;}
}
unless(defined(&NTFS_INDXMAGIC)) {
    sub NTFS_INDXMAGIC () {	( &u_int32_t)(0x58444e49);}
}
unless(defined(&NTFS_IEFLAG_SUBNODE)) {
    sub NTFS_IEFLAG_SUBNODE () {	0x1;}
}
unless(defined(&NTFS_IEFLAG_LAST)) {
    sub NTFS_IEFLAG_LAST () {	0x2;}
}
unless(defined(&NTFS_FILEMAGIC)) {
    sub NTFS_FILEMAGIC () {	( &u_int32_t)(0x454c4946);}
}
unless(defined(&NTFS_FRFLAG_DIR)) {
    sub NTFS_FRFLAG_DIR () {	0x2;}
}
unless(defined(&NTFS_ATTRNAME_MAXLEN)) {
    sub NTFS_ATTRNAME_MAXLEN () {	0x40;}
}
unless(defined(&NTFS_ADFLAG_NONRES)) {
    sub NTFS_ADFLAG_NONRES () {	0x80;}
}
unless(defined(&NTFS_ADFLAG_INDEX)) {
    sub NTFS_ADFLAG_INDEX () {	0x2;}
}
unless(defined(&NTFS_BBID)) {
    sub NTFS_BBID () {	"NTFS    ";}
}
unless(defined(&NTFS_BBIDLEN)) {
    sub NTFS_BBIDLEN () {	8;}
}
unless(defined(&NTFS_SYSNODESNUM)) {
    sub NTFS_SYSNODESNUM () {	0xb;}
}
unless(defined(&ntm_mftcn)) {
    sub ntm_mftcn () {	 ($ntm_bootfile->{bf_mftcn});}
}
unless(defined(&ntm_mftmirrcn)) {
    sub ntm_mftmirrcn () {	 ($ntm_bootfile->{bf_mftmirrcn});}
}
unless(defined(&ntm_mftrecsz)) {
    sub ntm_mftrecsz () {	 ($ntm_bootfile->{bf_mftrecsz});}
}
unless(defined(&ntm_spc)) {
    sub ntm_spc () {	 ($ntm_bootfile->{bf_spc});}
}
unless(defined(&ntm_bps)) {
    sub ntm_bps () {	 ($ntm_bootfile->{bf_bps});}
}
unless(defined(&NTFS_NEXTREC)) {
    sub NTFS_NEXTREC {
	my($s, $type) = @_;
	eval q((($type)(( $s) + ($s)-> &reclen)));
    }
}
unless(defined(&VFSTONTFS)) {
    sub VFSTONTFS {
	my($mp) = @_;
	eval q(((($mp)-> &mnt_data)));
    }
}
unless(defined(&VTONT)) {
    sub VTONT {
	my($v) = @_;
	eval q( &FTONT( &VTOF($v)));
    }
}
unless(defined(&VTOF)) {
    sub VTOF {
	my($v) = @_;
	eval q(((($v)-> &v_data)));
    }
}
unless(defined(&FTOV)) {
    sub FTOV {
	my($f) = @_;
	eval q((($f)-> &f_vp));
    }
}
unless(defined(&FTONT)) {
    sub FTONT {
	my($f) = @_;
	eval q((($f)-> &f_ip));
    }
}
unless(defined(&ntfs_cntobn)) {
    sub ntfs_cntobn {
	my($cn) = @_;
	eval q(( &daddr64_t)(($cn) * ( ($ntmp->{ntm_spc}))));
    }
}
unless(defined(&ntfs_cntob)) {
    sub ntfs_cntob {
	my($cn) = @_;
	eval q(( &off_t)(($cn) * ( &ntmp)-> &ntm_spc * ( &ntmp)-> &ntm_bps));
    }
}
unless(defined(&ntfs_btocn)) {
    sub ntfs_btocn {
	my($off) = @_;
	eval q(( &cn_t)(($off) / (( &ntmp)-> &ntm_spc * ( &ntmp)-> &ntm_bps)));
    }
}
unless(defined(&ntfs_btocl)) {
    sub ntfs_btocl {
	my($off) = @_;
	eval q(( &cn_t)(($off +  &ntfs_cntob(1) - 1) / (( &ntmp)-> &ntm_spc * ( &ntmp)-> &ntm_bps)));
    }
}
unless(defined(&ntfs_btocnoff)) {
    sub ntfs_btocnoff {
	my($off) = @_;
	eval q(( &off_t)(($off) % (( &ntmp)-> &ntm_spc * ( &ntmp)-> &ntm_bps)));
    }
}
unless(defined(&ntfs_bntob)) {
    sub ntfs_bntob {
	my($bn) = @_;
	eval q(( &int32_t)(($bn) * ( &ntmp)-> &ntm_bps));
    }
}
if((defined(&__FreeBSD_version) ? &__FreeBSD_version : undef) >= 300000|| defined( &__NetBSD__)) {
}
if(defined(&__NetBSD__)) {
    eval 'sub HASHINIT {
        my($a, $b, $c, $d) = @_;
	    eval q( &hashinit(($a),  &HASH_LIST, ($b), ($c), ($d)));
    }' unless defined(&HASHINIT);
    eval 'sub bqrelse {
        my($bp) = @_;
	    eval q( &brelse($bp));
    }' unless defined(&bqrelse);
    eval 'sub VOP__UNLOCK {
        my($a, $b, $c) = @_;
	    eval q( &VOP_UNLOCK(($a), ($b)));
    }' unless defined(&VOP__UNLOCK);
    eval 'sub VGET {
        my($a, $b, $c) = @_;
	    eval q( &vget(($a), ($b)));
    }' unless defined(&VGET);
    eval 'sub VN_LOCK {
        my($a, $b, $c) = @_;
	    eval q( &vn_lock(($a), ($b)));
    }' unless defined(&VN_LOCK);
}
 elsif(defined( &__OpenBSD__)) {
    eval 'sub HASHINIT {
        my($a, $b, $c, $d) = @_;
	    eval q( &hashinit(($a), ($b), ($c), ($d)));
    }' unless defined(&HASHINIT);
    eval 'sub bqrelse {
        my($bp) = @_;
	    eval q( &brelse($bp));
    }' unless defined(&bqrelse);
    eval 'sub VOP__UNLOCK {
        my($a, $b, $c) = @_;
	    eval q( &VOP_UNLOCK(($a), ($b), ($c)));
    }' unless defined(&VOP__UNLOCK);
    eval 'sub VGET {
        my($a, $b, $c) = @_;
	    eval q( &vget(($a), ($b), ($c)));
    }' unless defined(&VGET);
    eval 'sub VN_LOCK {
        my($a, $b, $c) = @_;
	    eval q( &vn_lock(($a), ($b), ($c)));
    }' unless defined(&VN_LOCK);
} else {
    eval 'sub HASHINIT {
        my($a, $b, $c, $d) = @_;
	    eval q( &hashinit(($a), ($b), ($d)));
    }' unless defined(&HASHINIT);
    eval 'sub VOP__UNLOCK {
        my($a, $b, $c) = @_;
	    eval q( &VOP_UNLOCK(($a), ($b), ($c)));
    }' unless defined(&VOP__UNLOCK);
    eval 'sub VGET {
        my($a, $b, $c) = @_;
	    eval q( &vget(($a), ($b), ($c)));
    }' unless defined(&VGET);
    eval 'sub VN_LOCK {
        my($a, $b, $c) = @_;
	    eval q( &vn_lock(($a), ($b), ($c)));
    }' unless defined(&VN_LOCK);
    eval 'sub PDIRUNLOCK () {0;}' unless defined(&PDIRUNLOCK);
}
if(defined( &NTFS_DEBUG)) {
    eval 'sub DPRINTF {
        my($X, $Y) = @_;
	    eval q( &do {  &if( &ntfs_debug >= ($X))  &printf $Y; }  &while(0));
    }' unless defined(&DPRINTF);
    eval 'sub dprintf {
        my($a) = @_;
	    eval q( &DPRINTF(1, $a));
    }' unless defined(&dprintf);
    eval 'sub ddprintf {
        my($a) = @_;
	    eval q( &DPRINTF(2, $a));
    }' unless defined(&ddprintf);
} else {
    eval 'sub DPRINTF {
        my($X, $Y) = @_;
	    eval q();
    }' unless defined(&DPRINTF);
    eval 'sub dprintf {
        my($a) = @_;
	    eval q();
    }' unless defined(&dprintf);
    eval 'sub ddprintf {
        my($a) = @_;
	    eval q();
    }' unless defined(&ddprintf);
}
1;
