require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_VAX_PARAM_H_)) {
    eval 'sub _VAX_PARAM_H_ () {1;}' unless defined(&_VAX_PARAM_H_);
    eval 'sub _MACHINE () { &vax;}' unless defined(&_MACHINE);
    eval 'sub MACHINE () {"vax";}' unless defined(&MACHINE);
    eval 'sub _MACHINE_ARCH () { &vax;}' unless defined(&_MACHINE_ARCH);
    eval 'sub MACHINE_ARCH () {"vax";}' unless defined(&MACHINE_ARCH);
    eval 'sub MID_MACHINE () { &MID_VAX;}' unless defined(&MID_MACHINE);
    eval 'sub ALIGNBYTES () {($sizeof{\'int\'} - 1);}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        my($p) = @_;
	    eval q(((($p) +  &ALIGNBYTES) &~  &ALIGNBYTES));
    }' unless defined(&ALIGN);
    eval 'sub ALIGNED_POINTER {
        my($p,$t) = @_;
	    eval q((((($p)) & ($sizeof{$t}-1)) == 0));
    }' unless defined(&ALIGNED_POINTER);
    eval 'sub PGSHIFT () {12;}' unless defined(&PGSHIFT);
    eval 'sub NBPG () {(1<<  &PGSHIFT);}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG - 1);}' unless defined(&PGOFSET);
    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub VAX_PGSHIFT () {9;}' unless defined(&VAX_PGSHIFT);
    eval 'sub VAX_NBPG () {(1<<  &VAX_PGSHIFT);}' unless defined(&VAX_NBPG);
    eval 'sub VAX_PGOFSET () {( &VAX_NBPG - 1);}' unless defined(&VAX_PGOFSET);
    eval 'sub VAX_NPTEPG () {( &VAX_NBPG / 4);}' unless defined(&VAX_NPTEPG);
    eval 'sub KERNBASE () {0x80000000;}' unless defined(&KERNBASE);
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub DEV_BSIZE () {(1<<  &DEV_BSHIFT);}' unless defined(&DEV_BSIZE);
    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
    eval 'sub MAXBSIZE () {0x4000;}' unless defined(&MAXBSIZE);
    eval 'sub UPAGES () {2;}' unless defined(&UPAGES);
    eval 'sub USPACE () {( &NBPG* &UPAGES);}' unless defined(&USPACE);
    eval 'sub USPACE_ALIGN () {(0);}' unless defined(&USPACE_ALIGN);
    eval 'sub REDZONEADDR () {( &VAX_NBPG*3);}' unless defined(&REDZONEADDR);
    unless(defined(&MSGBUFSIZE)) {
	eval 'sub MSGBUFSIZE () {8192;}' unless defined(&MSGBUFSIZE);
    }
    eval 'sub NMBCLUSTERS () {768;}' unless defined(&NMBCLUSTERS);
    eval 'sub NKMEMPAGES_MIN_DEFAULT () {((4* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
    eval 'sub NKMEMPAGES_MAX_DEFAULT () {((4* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
    eval 'sub ctod {
        my($x) = @_;
	    eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        my($x) = @_;
	    eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub btodb {
        my($x) = @_;
	    eval q((($x) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub dbtob {
        my($x) = @_;
	    eval q((($x) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    eval 'sub vax_atop {
        my($x) = @_;
	    eval q(((($x) +  &VAX_PGOFSET) >>  &VAX_PGSHIFT));
    }' unless defined(&vax_atop);
    eval 'sub vax_btop {
        my($x) = @_;
	    eval q(((($x)) >>  &VAX_PGSHIFT));
    }' unless defined(&vax_btop);
    eval 'sub ovbcopy {
        my($x,$y,$z) = @_;
	    eval q( &bcopy($x, $y, $z));
    }' unless defined(&ovbcopy);
    if(defined(&_KERNEL)) {
	require 'machine/intr.ph';
	unless(defined(&_LOCORE)) {
	    require 'machine/cpu.ph';
	    require 'machine/macros.ph';
	}
	eval 'sub DELAY {
	    my($x) = @_;
    	    eval q( &delay($x));
	}' unless defined(&DELAY);
    }
}
1;
