require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_BNX_H_DEFINED)) {
    eval 'sub _BNX_H_DEFINED () {1;}' unless defined(&_BNX_H_DEFINED);
    if(defined(&_KERNEL)) {
	require 'bpfilter.ph';
	require 'vlan.ph';
	require 'sys/param.ph';
	require 'sys/systm.ph';
	require 'sys/sockio.ph';
	require 'sys/mbuf.ph';
	require 'sys/malloc.ph';
	require 'sys/kernel.ph';
	require 'sys/device.ph';
	require 'sys/socket.ph';
	require 'sys/timeout.ph';
	require 'sys/pool.ph';
	require 'sys/rwlock.ph';
	require 'sys/workq.ph';
	require 'net/if.ph';
	require 'net/if_dl.ph';
	require 'net/if_media.ph';
	if(defined(&INET)) {
	    require 'netinet/in.ph';
	    require 'netinet/in_systm.ph';
	    require 'netinet/in_var.ph';
	    require 'netinet/ip.ph';
	    require 'netinet/if_ether.ph';
	}
	if((defined(&NVLAN) ? &NVLAN : undef) > 0) {
	    require 'net/if_types.ph';
	    require 'net/if_vlan_var.ph';
	}
	if((defined(&NBPFILTER) ? &NBPFILTER : undef) > 0) {
	    require 'net/bpf.ph';
	}
	require 'dev/pci/pcireg.ph';
	require 'dev/pci/pcivar.ph';
	require 'dev/pci/pcidevs.ph';
	require 'dev/mii/mii.ph';
	require 'dev/mii/miivar.ph';
	require 'dev/mii/miidevs.ph';
	require 'dev/mii/brgphyreg.ph';
	eval 'sub BNX_CP_LOAD () {0x1;}' unless defined(&BNX_CP_LOAD);
	eval 'sub BNX_CP_SEND () {0x2;}' unless defined(&BNX_CP_SEND);
	eval 'sub BNX_CP_RECV () {0x4;}' unless defined(&BNX_CP_RECV);
	eval 'sub BNX_CP_INTR () {0x8;}' unless defined(&BNX_CP_INTR);
	eval 'sub BNX_CP_UNLOAD () {0x10;}' unless defined(&BNX_CP_UNLOAD);
	eval 'sub BNX_CP_RESET () {0x20;}' unless defined(&BNX_CP_RESET);
	eval 'sub BNX_CP_ALL () {0xffffff;}' unless defined(&BNX_CP_ALL);
	eval 'sub BNX_CP_MASK () {0xffffff;}' unless defined(&BNX_CP_MASK);
	eval 'sub BNX_LEVEL_FATAL () {0x;}' unless defined(&BNX_LEVEL_FATAL);
	eval 'sub BNX_LEVEL_WARN () {0x1000000;}' unless defined(&BNX_LEVEL_WARN);
	eval 'sub BNX_LEVEL_INFO () {0x2000000;}' unless defined(&BNX_LEVEL_INFO);
	eval 'sub BNX_LEVEL_VERBOSE () {0x3000000;}' unless defined(&BNX_LEVEL_VERBOSE);
	eval 'sub BNX_LEVEL_EXCESSIVE () {0x4000000;}' unless defined(&BNX_LEVEL_EXCESSIVE);
	eval 'sub BNX_LEVEL_MASK () {0xff000000;}' unless defined(&BNX_LEVEL_MASK);
	eval 'sub BNX_WARN_LOAD () {( &BNX_CP_LOAD |  &BNX_LEVEL_WARN);}' unless defined(&BNX_WARN_LOAD);
	eval 'sub BNX_INFO_LOAD () {( &BNX_CP_LOAD |  &BNX_LEVEL_INFO);}' unless defined(&BNX_INFO_LOAD);
	eval 'sub BNX_VERBOSE_LOAD () {( &BNX_CP_LOAD |  &BNX_LEVEL_VERBOSE);}' unless defined(&BNX_VERBOSE_LOAD);
	eval 'sub BNX_EXCESSIVE_LOAD () {( &BNX_CP_LOAD |  &BNX_LEVEL_EXCESSIVE);}' unless defined(&BNX_EXCESSIVE_LOAD);
	eval 'sub BNX_WARN_SEND () {( &BNX_CP_SEND |  &BNX_LEVEL_WARN);}' unless defined(&BNX_WARN_SEND);
	eval 'sub BNX_INFO_SEND () {( &BNX_CP_SEND |  &BNX_LEVEL_INFO);}' unless defined(&BNX_INFO_SEND);
	eval 'sub BNX_VERBOSE_SEND () {( &BNX_CP_SEND |  &BNX_LEVEL_VERBOSE);}' unless defined(&BNX_VERBOSE_SEND);
	eval 'sub BNX_EXCESSIVE_SEND () {( &BNX_CP_SEND |  &BNX_LEVEL_EXCESSIVE);}' unless defined(&BNX_EXCESSIVE_SEND);
	eval 'sub BNX_WARN_RECV () {( &BNX_CP_RECV |  &BNX_LEVEL_WARN);}' unless defined(&BNX_WARN_RECV);
	eval 'sub BNX_INFO_RECV () {( &BNX_CP_RECV |  &BNX_LEVEL_INFO);}' unless defined(&BNX_INFO_RECV);
	eval 'sub BNX_VERBOSE_RECV () {( &BNX_CP_RECV |  &BNX_LEVEL_VERBOSE);}' unless defined(&BNX_VERBOSE_RECV);
	eval 'sub BNX_EXCESSIVE_RECV () {( &BNX_CP_RECV |  &BNX_LEVEL_EXCESSIVE);}' unless defined(&BNX_EXCESSIVE_RECV);
	eval 'sub BNX_WARN_INTR () {( &BNX_CP_INTR |  &BNX_LEVEL_WARN);}' unless defined(&BNX_WARN_INTR);
	eval 'sub BNX_INFO_INTR () {( &BNX_CP_INTR |  &BNX_LEVEL_INFO);}' unless defined(&BNX_INFO_INTR);
	eval 'sub BNX_VERBOSE_INTR () {( &BNX_CP_INTR |  &BNX_LEVEL_VERBOSE);}' unless defined(&BNX_VERBOSE_INTR);
	eval 'sub BNX_EXCESSIVE_INTR () {( &BNX_CP_INTR |  &BNX_LEVEL_EXCESSIVE);}' unless defined(&BNX_EXCESSIVE_INTR);
	eval 'sub BNX_WARN_UNLOAD () {( &BNX_CP_UNLOAD |  &BNX_LEVEL_WARN);}' unless defined(&BNX_WARN_UNLOAD);
	eval 'sub BNX_INFO_UNLOAD () {( &BNX_CP_UNLOAD |  &BNX_LEVEL_INFO);}' unless defined(&BNX_INFO_UNLOAD);
	eval 'sub BNX_VERBOSE_UNLOAD () {( &BNX_CP_UNLOAD |  &BNX_LEVEL_VERBOSE);}' unless defined(&BNX_VERBOSE_UNLOAD);
	eval 'sub BNX_EXCESSIVE_UNLOAD () {( &BNX_CP_UNLOAD |  &BNX_LEVEL_EXCESSIVE);}' unless defined(&BNX_EXCESSIVE_UNLOAD);
	eval 'sub BNX_WARN_RESET () {( &BNX_CP_RESET |  &BNX_LEVEL_WARN);}' unless defined(&BNX_WARN_RESET);
	eval 'sub BNX_INFO_RESET () {( &BNX_CP_RESET |  &BNX_LEVEL_INFO);}' unless defined(&BNX_INFO_RESET);
	eval 'sub BNX_VERBOSE_RESET () {( &BNX_CP_RESET |  &BNX_LEVEL_VERBOSE);}' unless defined(&BNX_VERBOSE_RESET);
	eval 'sub BNX_EXCESSIVE_RESET () {( &BNX_CP_RESET |  &BNX_LEVEL_EXCESSIVE);}' unless defined(&BNX_EXCESSIVE_RESET);
	eval 'sub BNX_FATAL () {( &BNX_CP_ALL |  &BNX_LEVEL_FATAL);}' unless defined(&BNX_FATAL);
	eval 'sub BNX_WARN () {( &BNX_CP_ALL |  &BNX_LEVEL_WARN);}' unless defined(&BNX_WARN);
	eval 'sub BNX_INFO () {( &BNX_CP_ALL |  &BNX_LEVEL_INFO);}' unless defined(&BNX_INFO);
	eval 'sub BNX_VERBOSE () {( &BNX_CP_ALL |  &BNX_LEVEL_VERBOSE);}' unless defined(&BNX_VERBOSE);
	eval 'sub BNX_EXCESSIVE () {( &BNX_CP_ALL |  &BNX_LEVEL_EXCESSIVE);}' unless defined(&BNX_EXCESSIVE);
	eval 'sub BNX_CODE_PATH {
	    my($cp) = @_;
    	    eval q((($cp &  &BNX_CP_MASK) &  &bnx_debug));
	}' unless defined(&BNX_CODE_PATH);
	eval 'sub BNX_MSG_LEVEL {
	    my($lv) = @_;
    	    eval q((($lv &  &BNX_LEVEL_MASK) <= ( &bnx_debug &  &BNX_LEVEL_MASK)));
	}' unless defined(&BNX_MSG_LEVEL);
	eval 'sub BNX_LOG_MSG {
	    my($m) = @_;
    	    eval q(( &BNX_CODE_PATH($m)  &&  &BNX_MSG_LEVEL($m)));
	}' unless defined(&BNX_LOG_MSG);
	if(defined(&BNX_DEBUG)) {
	    eval 'sub DBPRINT () {( &sc,  &level,  &format,  &args...)  &if ( &BNX_LOG_MSG( &level)) {  &printf("%s: "  &format,  ($sc->{bnx_dev}->{dv_xname}),   &args); };}' unless defined(&DBPRINT);
	    eval 'sub DBRUN () {( &m,  &args...)  &if ( &BNX_LOG_MSG( &m)) {  &args; };}' unless defined(&DBRUN);
	    eval 'sub DBRUNLV () {( &level,  &args...)  &if ( &BNX_MSG_LEVEL( &level)) {  &args; };}' unless defined(&DBRUNLV);
	    eval 'sub DBRUNCP () {( &cp,  &args...)  &if ( &BNX_CODE_PATH( &cp)) {  &args; };}' unless defined(&DBRUNCP);
	    eval 'sub DBRUNIF () {( &cond,  &args...)  &if ( &cond) {  &args; };}' unless defined(&DBRUNIF);
	    if(0) {
		require 'sys/random.ph';
	    }
	    eval 'sub DB_RANDOMFALSE {
	        my($defects) = @_;
    		eval q(( &random() > $defects));
	    }' unless defined(&DB_RANDOMFALSE);
	    eval 'sub DB_OR_RANDOMFALSE {
	        my($defects) = @_;
    		eval q(|| ( &random() > $defects));
	    }' unless defined(&DB_OR_RANDOMFALSE);
	    eval 'sub DB_AND_RANDOMFALSE {
	        my($defects) = @_;
    		eval q( && ( &random() >  &ddfects));
	    }' unless defined(&DB_AND_RANDOMFALSE);
	    eval 'sub DB_RANDOMTRUE {
	        my($defects) = @_;
    		eval q(( &random() < $defects));
	    }' unless defined(&DB_RANDOMTRUE);
	    eval 'sub DB_OR_RANDOMTRUE {
	        my($defects) = @_;
    		eval q(|| ( &random() < $defects));
	    }' unless defined(&DB_OR_RANDOMTRUE);
	    eval 'sub DB_AND_RANDOMTRUE {
	        my($defects) = @_;
    		eval q( && ( &random() < $defects));
	    }' unless defined(&DB_AND_RANDOMTRUE);
	} else {
	    eval 'sub DBPRINT () {( &level,  &format,  &args...);}' unless defined(&DBPRINT);
	    eval 'sub DBRUN () {( &m,  &args...);}' unless defined(&DBRUN);
	    eval 'sub DBRUNLV () {( &level,  &args...);}' unless defined(&DBRUNLV);
	    eval 'sub DBRUNCP () {( &cp,  &args...);}' unless defined(&DBRUNCP);
	    eval 'sub DBRUNIF () {( &cond,  &args...);}' unless defined(&DBRUNIF);
	    eval 'sub DB_RANDOMFALSE {
	        my($defects) = @_;
    		eval q();
	    }' unless defined(&DB_RANDOMFALSE);
	    eval 'sub DB_OR_RANDOMFALSE {
	        my($percent) = @_;
    		eval q();
	    }' unless defined(&DB_OR_RANDOMFALSE);
	    eval 'sub DB_AND_RANDOMFALSE {
	        my($percent) = @_;
    		eval q();
	    }' unless defined(&DB_AND_RANDOMFALSE);
	    eval 'sub DB_RANDOMTRUE {
	        my($defects) = @_;
    		eval q();
	    }' unless defined(&DB_RANDOMTRUE);
	    eval 'sub DB_OR_RANDOMTRUE {
	        my($percent) = @_;
    		eval q();
	    }' unless defined(&DB_OR_RANDOMTRUE);
	    eval 'sub DB_AND_RANDOMTRUE {
	        my($percent) = @_;
    		eval q();
	    }' unless defined(&DB_AND_RANDOMTRUE);
	}
	eval 'sub BRCM_VENDORID () {0x14e4;}' unless defined(&BRCM_VENDORID);
	eval 'sub BRCM_DEVICEID_BCM5706 () {0x164a;}' unless defined(&BRCM_DEVICEID_BCM5706);
	eval 'sub BRCM_DEVICEID_BCM5706S () {0x16aa;}' unless defined(&BRCM_DEVICEID_BCM5706S);
	eval 'sub BRCM_DEVICEID_BCM5708 () {0x164c;}' unless defined(&BRCM_DEVICEID_BCM5708);
	eval 'sub BRCM_DEVICEID_BCM5708S () {0x16ac;}' unless defined(&BRCM_DEVICEID_BCM5708S);
	eval 'sub HP_VENDORID () {0x103c;}' unless defined(&HP_VENDORID);
	eval 'sub PCI_ANY_ID () {( &u_int16_t) (~0);}' unless defined(&PCI_ANY_ID);
	eval 'sub BNX_CHIP_NUM {
	    my($sc) = @_;
    	    eval q(((($sc)-> &bnx_chipid) & 0xffff0000));
	}' unless defined(&BNX_CHIP_NUM);
	eval 'sub BNX_CHIP_NUM_5706 () {0x57060000;}' unless defined(&BNX_CHIP_NUM_5706);
	eval 'sub BNX_CHIP_NUM_5708 () {0x57080000;}' unless defined(&BNX_CHIP_NUM_5708);
	eval 'sub BNX_CHIP_NUM_5709 () {0x57090000;}' unless defined(&BNX_CHIP_NUM_5709);
	eval 'sub BNX_CHIP_NUM_5716 () {0x57160000;}' unless defined(&BNX_CHIP_NUM_5716);
	eval 'sub BNX_CHIP_REV {
	    my($sc) = @_;
    	    eval q(((($sc)-> &bnx_chipid) & 0xf000));
	}' unless defined(&BNX_CHIP_REV);
	eval 'sub BNX_CHIP_REV_Ax () {0x;}' unless defined(&BNX_CHIP_REV_Ax);
	eval 'sub BNX_CHIP_REV_Bx () {0x1000;}' unless defined(&BNX_CHIP_REV_Bx);
	eval 'sub BNX_CHIP_REV_Cx () {0x2000;}' unless defined(&BNX_CHIP_REV_Cx);
	eval 'sub BNX_CHIP_METAL {
	    my($sc) = @_;
    	    eval q(((($sc)-> &bnx_chipid) & 0xff0));
	}' unless defined(&BNX_CHIP_METAL);
	eval 'sub BNX_CHIP_BOND {
	    my($bp) = @_;
    	    eval q(((( &sc)-> &bnx_chipid) & 0xf));
	}' unless defined(&BNX_CHIP_BOND);
	eval 'sub BNX_CHIP_ID {
	    my($sc) = @_;
    	    eval q(((($sc)-> &bnx_chipid) & 0xfffffff0));
	}' unless defined(&BNX_CHIP_ID);
	eval 'sub BNX_CHIP_ID_5706_A0 () {0x57060000;}' unless defined(&BNX_CHIP_ID_5706_A0);
	eval 'sub BNX_CHIP_ID_5706_A1 () {0x57060010;}' unless defined(&BNX_CHIP_ID_5706_A1);
	eval 'sub BNX_CHIP_ID_5706_A2 () {0x57060020;}' unless defined(&BNX_CHIP_ID_5706_A2);
	eval 'sub BNX_CHIP_ID_5706_A3 () {0x57060030;}' unless defined(&BNX_CHIP_ID_5706_A3);
	eval 'sub BNX_CHIP_ID_5708_A0 () {0x57080000;}' unless defined(&BNX_CHIP_ID_5708_A0);
	eval 'sub BNX_CHIP_ID_5708_B0 () {0x57081000;}' unless defined(&BNX_CHIP_ID_5708_B0);
	eval 'sub BNX_CHIP_ID_5708_B1 () {0x57081010;}' unless defined(&BNX_CHIP_ID_5708_B1);
	eval 'sub BNX_CHIP_ID_5708_B2 () {0x57081020;}' unless defined(&BNX_CHIP_ID_5708_B2);
	eval 'sub BNX_CHIP_ID_5709_A0 () {0x57090000;}' unless defined(&BNX_CHIP_ID_5709_A0);
	eval 'sub BNX_CHIP_ID_5709_A1 () {0x57090010;}' unless defined(&BNX_CHIP_ID_5709_A1);
	eval 'sub BNX_CHIP_ID_5709_B0 () {0x57091000;}' unless defined(&BNX_CHIP_ID_5709_B0);
	eval 'sub BNX_CHIP_ID_5709_B1 () {0x57091010;}' unless defined(&BNX_CHIP_ID_5709_B1);
	eval 'sub BNX_CHIP_ID_5709_B2 () {0x57091020;}' unless defined(&BNX_CHIP_ID_5709_B2);
	eval 'sub BNX_CHIP_ID_5709_C0 () {0x57092000;}' unless defined(&BNX_CHIP_ID_5709_C0);
	eval 'sub BNX_CHIP_ID_5716_C0 () {0x57162000;}' unless defined(&BNX_CHIP_ID_5716_C0);
	eval 'sub BNX_CHIP_BOND_ID {
	    my($sc) = @_;
    	    eval q(((($sc)-> &bnx_chipid) & 0xf));
	}' unless defined(&BNX_CHIP_BOND_ID);
	eval 'sub BNX_CHIP_BOND_ID_SERDES_BIT () {0x1;}' unless defined(&BNX_CHIP_BOND_ID_SERDES_BIT);
	eval 'sub BNX_ASICREV {
	    my($x) = @_;
    	    eval q((($x) >> 28));
	}' unless defined(&BNX_ASICREV);
	eval 'sub BNX_ASICREV_BCM5700 () {0x6;}' unless defined(&BNX_ASICREV_BCM5700);
	eval 'sub BNX_CHIPREV {
	    my($x) = @_;
    	    eval q((($x) >> 24));
	}' unless defined(&BNX_CHIPREV);
	eval 'sub BNX_CHIPREV_5700_AX () {0x70;}' unless defined(&BNX_CHIPREV_5700_AX);
	eval 'sub BNX_CHIPREV_5700_BX () {0x71;}' unless defined(&BNX_CHIPREV_5700_BX);
	eval 'sub BNX_CHIPREV_5700_CX () {0x72;}' unless defined(&BNX_CHIPREV_5700_CX);
	eval 'sub BNX_CHIPREV_5701_AX () {0x;}' unless defined(&BNX_CHIPREV_5701_AX);
	eval 'sub bnx_htobe16 {
	    my($x) = @_;
    	    eval q( &htobe16($x));
	}' unless defined(&bnx_htobe16);
	eval 'sub bnx_htobe32 {
	    my($x) = @_;
    	    eval q( &htobe32($x));
	}' unless defined(&bnx_htobe32);
	eval 'sub bnx_htobe64 {
	    my($x) = @_;
    	    eval q( &htobe64($x));
	}' unless defined(&bnx_htobe64);
	eval 'sub bnx_htole16 {
	    my($x) = @_;
    	    eval q( &htole16($x));
	}' unless defined(&bnx_htole16);
	eval 'sub bnx_htole32 {
	    my($x) = @_;
    	    eval q( &htole32($x));
	}' unless defined(&bnx_htole32);
	eval 'sub bnx_htole64 {
	    my($x) = @_;
    	    eval q( &htole64($x));
	}' unless defined(&bnx_htole64);
	eval 'sub bnx_be16toh {
	    my($x) = @_;
    	    eval q( &betoh16($x));
	}' unless defined(&bnx_be16toh);
	eval 'sub bnx_be32toh {
	    my($x) = @_;
    	    eval q( &betoh32($x));
	}' unless defined(&bnx_be32toh);
	eval 'sub bnx_be64toh {
	    my($x) = @_;
    	    eval q( &betoh64($x));
	}' unless defined(&bnx_be64toh);
	eval 'sub bnx_le16toh {
	    my($x) = @_;
    	    eval q( &letoh16($x));
	}' unless defined(&bnx_le16toh);
	eval 'sub bnx_le32toh {
	    my($x) = @_;
    	    eval q( &letoh32($x));
	}' unless defined(&bnx_le32toh);
	eval 'sub bnx_le64toh {
	    my($x) = @_;
    	    eval q( &letoh64($x));
	}' unless defined(&bnx_le64toh);
	eval 'sub SEEPROM_PAGE_BITS () {2;}' unless defined(&SEEPROM_PAGE_BITS);
	eval 'sub SEEPROM_PHY_PAGE_SIZE () {(1<<  &SEEPROM_PAGE_BITS);}' unless defined(&SEEPROM_PHY_PAGE_SIZE);
	eval 'sub SEEPROM_BYTE_ADDR_MASK () {( &SEEPROM_PHY_PAGE_SIZE-1);}' unless defined(&SEEPROM_BYTE_ADDR_MASK);
	eval 'sub SEEPROM_PAGE_SIZE () {4;}' unless defined(&SEEPROM_PAGE_SIZE);
	eval 'sub SEEPROM_TOTAL_SIZE () {65536;}' unless defined(&SEEPROM_TOTAL_SIZE);
	eval 'sub BUFFERED_FLASH_PAGE_BITS () {9;}' unless defined(&BUFFERED_FLASH_PAGE_BITS);
	eval 'sub BUFFERED_FLASH_PHY_PAGE_SIZE () {(1<<  &BUFFERED_FLASH_PAGE_BITS);}' unless defined(&BUFFERED_FLASH_PHY_PAGE_SIZE);
	eval 'sub BUFFERED_FLASH_BYTE_ADDR_MASK () {( &BUFFERED_FLASH_PHY_PAGE_SIZE-1);}' unless defined(&BUFFERED_FLASH_BYTE_ADDR_MASK);
	eval 'sub BUFFERED_FLASH_PAGE_SIZE () {264;}' unless defined(&BUFFERED_FLASH_PAGE_SIZE);
	eval 'sub BUFFERED_FLASH_TOTAL_SIZE () {0x21000;}' unless defined(&BUFFERED_FLASH_TOTAL_SIZE);
	eval 'sub SAIFUN_FLASH_PAGE_BITS () {8;}' unless defined(&SAIFUN_FLASH_PAGE_BITS);
	eval 'sub SAIFUN_FLASH_PHY_PAGE_SIZE () {(1<<  &SAIFUN_FLASH_PAGE_BITS);}' unless defined(&SAIFUN_FLASH_PHY_PAGE_SIZE);
	eval 'sub SAIFUN_FLASH_BYTE_ADDR_MASK () {( &SAIFUN_FLASH_PHY_PAGE_SIZE-1);}' unless defined(&SAIFUN_FLASH_BYTE_ADDR_MASK);
	eval 'sub SAIFUN_FLASH_PAGE_SIZE () {256;}' unless defined(&SAIFUN_FLASH_PAGE_SIZE);
	eval 'sub SAIFUN_FLASH_BASE_TOTAL_SIZE () {65536;}' unless defined(&SAIFUN_FLASH_BASE_TOTAL_SIZE);
	eval 'sub ST_MICRO_FLASH_PAGE_BITS () {8;}' unless defined(&ST_MICRO_FLASH_PAGE_BITS);
	eval 'sub ST_MICRO_FLASH_PHY_PAGE_SIZE () {(1<<  &ST_MICRO_FLASH_PAGE_BITS);}' unless defined(&ST_MICRO_FLASH_PHY_PAGE_SIZE);
	eval 'sub ST_MICRO_FLASH_BYTE_ADDR_MASK () {( &ST_MICRO_FLASH_PHY_PAGE_SIZE-1);}' unless defined(&ST_MICRO_FLASH_BYTE_ADDR_MASK);
	eval 'sub ST_MICRO_FLASH_PAGE_SIZE () {256;}' unless defined(&ST_MICRO_FLASH_PAGE_SIZE);
	eval 'sub ST_MICRO_FLASH_BASE_TOTAL_SIZE () {65536;}' unless defined(&ST_MICRO_FLASH_BASE_TOTAL_SIZE);
	eval 'sub BCM5709_FLASH_PAGE_BITS () {8;}' unless defined(&BCM5709_FLASH_PAGE_BITS);
	eval 'sub BCM5709_FLASH_PHY_PAGE_SIZE () {(1<<  &BCM5709_FLASH_PAGE_BITS);}' unless defined(&BCM5709_FLASH_PHY_PAGE_SIZE);
	eval 'sub BCM5709_FLASH_BYTE_ADDR_MASK () {( &BCM5709_FLASH_PHY_PAGE_SIZE-1);}' unless defined(&BCM5709_FLASH_BYTE_ADDR_MASK);
	eval 'sub BCM5709_FLASH_PAGE_SIZE () {256;}' unless defined(&BCM5709_FLASH_PAGE_SIZE);
	eval 'sub NVRAM_TIMEOUT_COUNT () {30000;}' unless defined(&NVRAM_TIMEOUT_COUNT);
	eval 'sub BNX_FLASHDESC_MAX () {64;}' unless defined(&BNX_FLASHDESC_MAX);
	eval 'sub FLASH_STRAP_MASK () {( &BNX_NVM_CFG1_FLASH_MODE |  &BNX_NVM_CFG1_BUFFER_MODE |  &BNX_NVM_CFG1_PROTECT_MODE |  &BNX_NVM_CFG1_FLASH_SIZE);}' unless defined(&FLASH_STRAP_MASK);
	eval 'sub FLASH_BACKUP_STRAP_MASK () {(0xf << 26);}' unless defined(&FLASH_BACKUP_STRAP_MASK);
	eval 'sub BNX_NV_BUFFERED () {0x1;}' unless defined(&BNX_NV_BUFFERED);
	eval 'sub BNX_NV_TRANSLATE () {0x2;}' unless defined(&BNX_NV_TRANSLATE);
	eval 'sub BNX_NV_WREN () {0x4;}' unless defined(&BNX_NV_WREN);
	eval 'sub DRV_PULSE_PERIOD_MS () {250;}' unless defined(&DRV_PULSE_PERIOD_MS);
	eval 'sub FW_ACK_TIME_OUT_MS () {1000;}' unless defined(&FW_ACK_TIME_OUT_MS);
	eval 'sub BNX_DRV_RESET_SIGNATURE () {0x;}' unless defined(&BNX_DRV_RESET_SIGNATURE);
	eval 'sub BNX_DRV_RESET_SIGNATURE_MAGIC () {0x4841564b;}' unless defined(&BNX_DRV_RESET_SIGNATURE_MAGIC);
	eval 'sub BNX_DRV_MB () {0x4;}' unless defined(&BNX_DRV_MB);
	eval 'sub BNX_DRV_MSG_CODE () {0xff000000;}' unless defined(&BNX_DRV_MSG_CODE);
	eval 'sub BNX_DRV_MSG_CODE_RESET () {0x1000000;}' unless defined(&BNX_DRV_MSG_CODE_RESET);
	eval 'sub BNX_DRV_MSG_CODE_UNLOAD () {0x2000000;}' unless defined(&BNX_DRV_MSG_CODE_UNLOAD);
	eval 'sub BNX_DRV_MSG_CODE_SHUTDOWN () {0x3000000;}' unless defined(&BNX_DRV_MSG_CODE_SHUTDOWN);
	eval 'sub BNX_DRV_MSG_CODE_SUSPEND_WOL () {0x4000000;}' unless defined(&BNX_DRV_MSG_CODE_SUSPEND_WOL);
	eval 'sub BNX_DRV_MSG_CODE_FW_TIMEOUT () {0x5000000;}' unless defined(&BNX_DRV_MSG_CODE_FW_TIMEOUT);
	eval 'sub BNX_DRV_MSG_CODE_PULSE () {0x6000000;}' unless defined(&BNX_DRV_MSG_CODE_PULSE);
	eval 'sub BNX_DRV_MSG_CODE_DIAG () {0x7000000;}' unless defined(&BNX_DRV_MSG_CODE_DIAG);
	eval 'sub BNX_DRV_MSG_CODE_SUSPEND_NO_WOL () {0x9000000;}' unless defined(&BNX_DRV_MSG_CODE_SUSPEND_NO_WOL);
	eval 'sub BNX_DRV_MSG_DATA () {0xff0000;}' unless defined(&BNX_DRV_MSG_DATA);
	eval 'sub BNX_DRV_MSG_DATA_WAIT0 () {0x10000;}' unless defined(&BNX_DRV_MSG_DATA_WAIT0);
	eval 'sub BNX_DRV_MSG_DATA_WAIT1 () {0x20000;}' unless defined(&BNX_DRV_MSG_DATA_WAIT1);
	eval 'sub BNX_DRV_MSG_DATA_WAIT2 () {0x30000;}' unless defined(&BNX_DRV_MSG_DATA_WAIT2);
	eval 'sub BNX_DRV_MSG_DATA_WAIT3 () {0x40000;}' unless defined(&BNX_DRV_MSG_DATA_WAIT3);
	eval 'sub BNX_DRV_MSG_SEQ () {0xffff;}' unless defined(&BNX_DRV_MSG_SEQ);
	eval 'sub BNX_FW_MB () {0x8;}' unless defined(&BNX_FW_MB);
	eval 'sub BNX_FW_MSG_ACK () {0xffff;}' unless defined(&BNX_FW_MSG_ACK);
	eval 'sub BNX_FW_MSG_STATUS_MASK () {0xff0000;}' unless defined(&BNX_FW_MSG_STATUS_MASK);
	eval 'sub BNX_FW_MSG_STATUS_OK () {0x;}' unless defined(&BNX_FW_MSG_STATUS_OK);
	eval 'sub BNX_FW_MSG_STATUS_FAILURE () {0xff0000;}' unless defined(&BNX_FW_MSG_STATUS_FAILURE);
	eval 'sub BNX_LINK_STATUS () {0xc;}' unless defined(&BNX_LINK_STATUS);
	eval 'sub BNX_LINK_STATUS_INIT_VALUE () {0xffffffff;}' unless defined(&BNX_LINK_STATUS_INIT_VALUE);
	eval 'sub BNX_LINK_STATUS_LINK_UP () {0x1;}' unless defined(&BNX_LINK_STATUS_LINK_UP);
	eval 'sub BNX_LINK_STATUS_LINK_DOWN () {0x;}' unless defined(&BNX_LINK_STATUS_LINK_DOWN);
	eval 'sub BNX_LINK_STATUS_SPEED_MASK () {0x1e;}' unless defined(&BNX_LINK_STATUS_SPEED_MASK);
	eval 'sub BNX_LINK_STATUS_AN_INCOMPLETE () {(0<<1);}' unless defined(&BNX_LINK_STATUS_AN_INCOMPLETE);
	eval 'sub BNX_LINK_STATUS_10HALF () {(1<<1);}' unless defined(&BNX_LINK_STATUS_10HALF);
	eval 'sub BNX_LINK_STATUS_10FULL () {(2<<1);}' unless defined(&BNX_LINK_STATUS_10FULL);
	eval 'sub BNX_LINK_STATUS_100HALF () {(3<<1);}' unless defined(&BNX_LINK_STATUS_100HALF);
	eval 'sub BNX_LINK_STATUS_100BASE_T4 () {(4<<1);}' unless defined(&BNX_LINK_STATUS_100BASE_T4);
	eval 'sub BNX_LINK_STATUS_100FULL () {(5<<1);}' unless defined(&BNX_LINK_STATUS_100FULL);
	eval 'sub BNX_LINK_STATUS_1000HALF () {(6<<1);}' unless defined(&BNX_LINK_STATUS_1000HALF);
	eval 'sub BNX_LINK_STATUS_1000FULL () {(7<<1);}' unless defined(&BNX_LINK_STATUS_1000FULL);
	eval 'sub BNX_LINK_STATUS_2500HALF () {(8<<1);}' unless defined(&BNX_LINK_STATUS_2500HALF);
	eval 'sub BNX_LINK_STATUS_2500FULL () {(9<<1);}' unless defined(&BNX_LINK_STATUS_2500FULL);
	eval 'sub BNX_LINK_STATUS_AN_ENABLED () {(1<<5);}' unless defined(&BNX_LINK_STATUS_AN_ENABLED);
	eval 'sub BNX_LINK_STATUS_AN_COMPLETE () {(1<<6);}' unless defined(&BNX_LINK_STATUS_AN_COMPLETE);
	eval 'sub BNX_LINK_STATUS_PARALLEL_DET () {(1<<7);}' unless defined(&BNX_LINK_STATUS_PARALLEL_DET);
	eval 'sub BNX_LINK_STATUS_RESERVED () {(1<<8);}' unless defined(&BNX_LINK_STATUS_RESERVED);
	eval 'sub BNX_LINK_STATUS_PARTNER_AD_1000FULL () {(1<<9);}' unless defined(&BNX_LINK_STATUS_PARTNER_AD_1000FULL);
	eval 'sub BNX_LINK_STATUS_PARTNER_AD_1000HALF () {(1<<10);}' unless defined(&BNX_LINK_STATUS_PARTNER_AD_1000HALF);
	eval 'sub BNX_LINK_STATUS_PARTNER_AD_100BT4 () {(1<<11);}' unless defined(&BNX_LINK_STATUS_PARTNER_AD_100BT4);
	eval 'sub BNX_LINK_STATUS_PARTNER_AD_100FULL () {(1<<12);}' unless defined(&BNX_LINK_STATUS_PARTNER_AD_100FULL);
	eval 'sub BNX_LINK_STATUS_PARTNER_AD_100HALF () {(1<<13);}' unless defined(&BNX_LINK_STATUS_PARTNER_AD_100HALF);
	eval 'sub BNX_LINK_STATUS_PARTNER_AD_10FULL () {(1<<14);}' unless defined(&BNX_LINK_STATUS_PARTNER_AD_10FULL);
	eval 'sub BNX_LINK_STATUS_PARTNER_AD_10HALF () {(1<<15);}' unless defined(&BNX_LINK_STATUS_PARTNER_AD_10HALF);
	eval 'sub BNX_LINK_STATUS_TX_FC_ENABLED () {(1<<16);}' unless defined(&BNX_LINK_STATUS_TX_FC_ENABLED);
	eval 'sub BNX_LINK_STATUS_RX_FC_ENABLED () {(1<<17);}' unless defined(&BNX_LINK_STATUS_RX_FC_ENABLED);
	eval 'sub BNX_LINK_STATUS_PARTNER_SYM_PAUSE_CAP () {(1<<18);}' unless defined(&BNX_LINK_STATUS_PARTNER_SYM_PAUSE_CAP);
	eval 'sub BNX_LINK_STATUS_PARTNER_ASYM_PAUSE_CAP () {(1<<19);}' unless defined(&BNX_LINK_STATUS_PARTNER_ASYM_PAUSE_CAP);
	eval 'sub BNX_LINK_STATUS_SERDES_LINK () {(1<<20);}' unless defined(&BNX_LINK_STATUS_SERDES_LINK);
	eval 'sub BNX_LINK_STATUS_PARTNER_AD_2500FULL () {(1<<21);}' unless defined(&BNX_LINK_STATUS_PARTNER_AD_2500FULL);
	eval 'sub BNX_LINK_STATUS_PARTNER_AD_2500HALF () {(1<<22);}' unless defined(&BNX_LINK_STATUS_PARTNER_AD_2500HALF);
	eval 'sub BNX_DRV_PULSE_MB () {0x10;}' unless defined(&BNX_DRV_PULSE_MB);
	eval 'sub BNX_DRV_PULSE_SEQ_MASK () {0x7fff;}' unless defined(&BNX_DRV_PULSE_SEQ_MASK);
	eval 'sub BNX_MB_ARGS_0 () {0x14;}' unless defined(&BNX_MB_ARGS_0);
	eval 'sub BNX_MB_ARGS_1 () {0x18;}' unless defined(&BNX_MB_ARGS_1);
	eval 'sub BNX_DRV_MSG_DATA_PULSE_CODE_ALWAYS_ALIVE () {0x80000;}' unless defined(&BNX_DRV_MSG_DATA_PULSE_CODE_ALWAYS_ALIVE);
	eval 'sub BNX_DEV_INFO_SIGNATURE () {0x20;}' unless defined(&BNX_DEV_INFO_SIGNATURE);
	eval 'sub BNX_DEV_INFO_SIGNATURE_MAGIC () {0x44564900;}' unless defined(&BNX_DEV_INFO_SIGNATURE_MAGIC);
	eval 'sub BNX_DEV_INFO_SIGNATURE_MAGIC_MASK () {0xffffff00;}' unless defined(&BNX_DEV_INFO_SIGNATURE_MAGIC_MASK);
	eval 'sub BNX_DEV_INFO_FEATURE_CFG_VALID () {0x1;}' unless defined(&BNX_DEV_INFO_FEATURE_CFG_VALID);
	eval 'sub BNX_DEV_INFO_SECONDARY_PORT () {0x80;}' unless defined(&BNX_DEV_INFO_SECONDARY_PORT);
	eval 'sub BNX_DEV_INFO_DRV_ALWAYS_ALIVE () {0x40;}' unless defined(&BNX_DEV_INFO_DRV_ALWAYS_ALIVE);
	eval 'sub BNX_SHARED_HW_CFG_PART_NUM () {0x24;}' unless defined(&BNX_SHARED_HW_CFG_PART_NUM);
	eval 'sub BNX_SHARED_HW_CFG_POWER_DISSIPATED () {0x34;}' unless defined(&BNX_SHARED_HW_CFG_POWER_DISSIPATED);
	eval 'sub BNX_SHARED_HW_CFG_POWER_STATE_D3_MASK () {0xff000000;}' unless defined(&BNX_SHARED_HW_CFG_POWER_STATE_D3_MASK);
	eval 'sub BNX_SHARED_HW_CFG_POWER_STATE_D2_MASK () {0xff0000;}' unless defined(&BNX_SHARED_HW_CFG_POWER_STATE_D2_MASK);
	eval 'sub BNX_SHARED_HW_CFG_POWER_STATE_D1_MASK () {0xff00;}' unless defined(&BNX_SHARED_HW_CFG_POWER_STATE_D1_MASK);
	eval 'sub BNX_SHARED_HW_CFG_POWER_STATE_D0_MASK () {0xff;}' unless defined(&BNX_SHARED_HW_CFG_POWER_STATE_D0_MASK);
	eval 'sub BNX_SHARED_HW_CFG_POWER_CONSUMED () {0x38;}' unless defined(&BNX_SHARED_HW_CFG_POWER_CONSUMED);
	eval 'sub BNX_SHARED_HW_CFG_CONFIG () {0x3c;}' unless defined(&BNX_SHARED_HW_CFG_CONFIG);
	eval 'sub BNX_SHARED_HW_CFG_DESIGN_NIC () {0;}' unless defined(&BNX_SHARED_HW_CFG_DESIGN_NIC);
	eval 'sub BNX_SHARED_HW_CFG_DESIGN_LOM () {0x1;}' unless defined(&BNX_SHARED_HW_CFG_DESIGN_LOM);
	eval 'sub BNX_SHARED_HW_CFG_PHY_COPPER () {0;}' unless defined(&BNX_SHARED_HW_CFG_PHY_COPPER);
	eval 'sub BNX_SHARED_HW_CFG_PHY_FIBER () {0x2;}' unless defined(&BNX_SHARED_HW_CFG_PHY_FIBER);
	eval 'sub BNX_SHARED_HW_CFG_PHY_2_5G () {0x20;}' unless defined(&BNX_SHARED_HW_CFG_PHY_2_5G);
	eval 'sub BNX_SHARED_HW_CFG_PHY_BACKPLANE () {0x40;}' unless defined(&BNX_SHARED_HW_CFG_PHY_BACKPLANE);
	eval 'sub BNX_SHARED_HW_CFG_LED_MODE_SHIFT_BITS () {8;}' unless defined(&BNX_SHARED_HW_CFG_LED_MODE_SHIFT_BITS);
	eval 'sub BNX_SHARED_HW_CFG_LED_MODE_MASK () {0x300;}' unless defined(&BNX_SHARED_HW_CFG_LED_MODE_MASK);
	eval 'sub BNX_SHARED_HW_CFG_LED_MODE_MAC () {0;}' unless defined(&BNX_SHARED_HW_CFG_LED_MODE_MAC);
	eval 'sub BNX_SHARED_HW_CFG_LED_MODE_GPHY1 () {0x100;}' unless defined(&BNX_SHARED_HW_CFG_LED_MODE_GPHY1);
	eval 'sub BNX_SHARED_HW_CFG_LED_MODE_GPHY2 () {0x200;}' unless defined(&BNX_SHARED_HW_CFG_LED_MODE_GPHY2);
	eval 'sub BNX_SHARED_HW_CFG_CONFIG2 () {0x40;}' unless defined(&BNX_SHARED_HW_CFG_CONFIG2);
	eval 'sub BNX_SHARED_HW_CFG2_NVM_SIZE_MASK () {0xfff000;}' unless defined(&BNX_SHARED_HW_CFG2_NVM_SIZE_MASK);
	eval 'sub BNX_DEV_INFO_BC_REV () {0x4c;}' unless defined(&BNX_DEV_INFO_BC_REV);
	eval 'sub BNX_PORT_HW_CFG_MAC_UPPER () {0x50;}' unless defined(&BNX_PORT_HW_CFG_MAC_UPPER);
	eval 'sub BNX_PORT_HW_CFG_UPPERMAC_MASK () {0xffff;}' unless defined(&BNX_PORT_HW_CFG_UPPERMAC_MASK);
	eval 'sub BNX_PORT_HW_CFG_MAC_LOWER () {0x54;}' unless defined(&BNX_PORT_HW_CFG_MAC_LOWER);
	eval 'sub BNX_PORT_HW_CFG_CONFIG () {0x58;}' unless defined(&BNX_PORT_HW_CFG_CONFIG);
	eval 'sub BNX_PORT_HW_CFG_CFG_TXCTL3_MASK () {0xffff;}' unless defined(&BNX_PORT_HW_CFG_CFG_TXCTL3_MASK);
	eval 'sub BNX_PORT_HW_CFG_CFG_DFLT_LINK_MASK () {0x1f0000;}' unless defined(&BNX_PORT_HW_CFG_CFG_DFLT_LINK_MASK);
	eval 'sub BNX_PORT_HW_CFG_CFG_DFLT_LINK_AN () {0x;}' unless defined(&BNX_PORT_HW_CFG_CFG_DFLT_LINK_AN);
	eval 'sub BNX_PORT_HW_CFG_CFG_DFLT_LINK_1G () {0x30000;}' unless defined(&BNX_PORT_HW_CFG_CFG_DFLT_LINK_1G);
	eval 'sub BNX_PORT_HW_CFG_CFG_DFLT_LINK_2_5G () {0x40000;}' unless defined(&BNX_PORT_HW_CFG_CFG_DFLT_LINK_2_5G);
	eval 'sub BNX_PORT_HW_CFG_IMD_MAC_A_UPPER () {0x68;}' unless defined(&BNX_PORT_HW_CFG_IMD_MAC_A_UPPER);
	eval 'sub BNX_PORT_HW_CFG_IMD_MAC_A_LOWER () {0x6c;}' unless defined(&BNX_PORT_HW_CFG_IMD_MAC_A_LOWER);
	eval 'sub BNX_PORT_HW_CFG_IMD_MAC_B_UPPER () {0x70;}' unless defined(&BNX_PORT_HW_CFG_IMD_MAC_B_UPPER);
	eval 'sub BNX_PORT_HW_CFG_IMD_MAC_B_LOWER () {0x74;}' unless defined(&BNX_PORT_HW_CFG_IMD_MAC_B_LOWER);
	eval 'sub BNX_PORT_HW_CFG_ISCSI_MAC_UPPER () {0x78;}' unless defined(&BNX_PORT_HW_CFG_ISCSI_MAC_UPPER);
	eval 'sub BNX_PORT_HW_CFG_ISCSI_MAC_LOWER () {0x7c;}' unless defined(&BNX_PORT_HW_CFG_ISCSI_MAC_LOWER);
	eval 'sub BNX_DEV_INFO_PER_PORT_HW_CONFIG2 () {0xb4;}' unless defined(&BNX_DEV_INFO_PER_PORT_HW_CONFIG2);
	eval 'sub BNX_DEV_INFO_FORMAT_REV () {0xc4;}' unless defined(&BNX_DEV_INFO_FORMAT_REV);
	eval 'sub BNX_DEV_INFO_FORMAT_REV_MASK () {0xff000000;}' unless defined(&BNX_DEV_INFO_FORMAT_REV_MASK);
	eval 'sub BNX_DEV_INFO_FORMAT_REV_ID () {(ord(\'A\') << 24);}' unless defined(&BNX_DEV_INFO_FORMAT_REV_ID);
	eval 'sub BNX_SHARED_FEATURE () {0xc8;}' unless defined(&BNX_SHARED_FEATURE);
	eval 'sub BNX_SHARED_FEATURE_MASK () {0xffffffff;}' unless defined(&BNX_SHARED_FEATURE_MASK);
	eval 'sub BNX_PORT_FEATURE () {0xd8;}' unless defined(&BNX_PORT_FEATURE);
	eval 'sub BNX_PORT2_FEATURE () {0x14c;}' unless defined(&BNX_PORT2_FEATURE);
	eval 'sub BNX_PORT_FEATURE_WOL_ENABLED () {0x1000000;}' unless defined(&BNX_PORT_FEATURE_WOL_ENABLED);
	eval 'sub BNX_PORT_FEATURE_MBA_ENABLED () {0x2000000;}' unless defined(&BNX_PORT_FEATURE_MBA_ENABLED);
	eval 'sub BNX_PORT_FEATURE_ASF_ENABLED () {0x4000000;}' unless defined(&BNX_PORT_FEATURE_ASF_ENABLED);
	eval 'sub BNX_PORT_FEATURE_IMD_ENABLED () {0x8000000;}' unless defined(&BNX_PORT_FEATURE_IMD_ENABLED);
	eval 'sub BNX_PORT_FEATURE_BAR1_SIZE_MASK () {0xf;}' unless defined(&BNX_PORT_FEATURE_BAR1_SIZE_MASK);
	eval 'sub BNX_PORT_FEATURE_BAR1_SIZE_DISABLED () {0x;}' unless defined(&BNX_PORT_FEATURE_BAR1_SIZE_DISABLED);
	eval 'sub BNX_PORT_FEATURE_BAR1_SIZE_64K () {0x1;}' unless defined(&BNX_PORT_FEATURE_BAR1_SIZE_64K);
	eval 'sub BNX_PORT_FEATURE_BAR1_SIZE_128K () {0x2;}' unless defined(&BNX_PORT_FEATURE_BAR1_SIZE_128K);
	eval 'sub BNX_PORT_FEATURE_BAR1_SIZE_256K () {0x3;}' unless defined(&BNX_PORT_FEATURE_BAR1_SIZE_256K);
	eval 'sub BNX_PORT_FEATURE_BAR1_SIZE_512K () {0x4;}' unless defined(&BNX_PORT_FEATURE_BAR1_SIZE_512K);
	eval 'sub BNX_PORT_FEATURE_BAR1_SIZE_1M () {0x5;}' unless defined(&BNX_PORT_FEATURE_BAR1_SIZE_1M);
	eval 'sub BNX_PORT_FEATURE_BAR1_SIZE_2M () {0x6;}' unless defined(&BNX_PORT_FEATURE_BAR1_SIZE_2M);
	eval 'sub BNX_PORT_FEATURE_BAR1_SIZE_4M () {0x7;}' unless defined(&BNX_PORT_FEATURE_BAR1_SIZE_4M);
	eval 'sub BNX_PORT_FEATURE_BAR1_SIZE_8M () {0x8;}' unless defined(&BNX_PORT_FEATURE_BAR1_SIZE_8M);
	eval 'sub BNX_PORT_FEATURE_BAR1_SIZE_16M () {0x9;}' unless defined(&BNX_PORT_FEATURE_BAR1_SIZE_16M);
	eval 'sub BNX_PORT_FEATURE_BAR1_SIZE_32M () {0xa;}' unless defined(&BNX_PORT_FEATURE_BAR1_SIZE_32M);
	eval 'sub BNX_PORT_FEATURE_BAR1_SIZE_64M () {0xb;}' unless defined(&BNX_PORT_FEATURE_BAR1_SIZE_64M);
	eval 'sub BNX_PORT_FEATURE_BAR1_SIZE_128M () {0xc;}' unless defined(&BNX_PORT_FEATURE_BAR1_SIZE_128M);
	eval 'sub BNX_PORT_FEATURE_BAR1_SIZE_256M () {0xd;}' unless defined(&BNX_PORT_FEATURE_BAR1_SIZE_256M);
	eval 'sub BNX_PORT_FEATURE_BAR1_SIZE_512M () {0xe;}' unless defined(&BNX_PORT_FEATURE_BAR1_SIZE_512M);
	eval 'sub BNX_PORT_FEATURE_BAR1_SIZE_1G () {0xf;}' unless defined(&BNX_PORT_FEATURE_BAR1_SIZE_1G);
	eval 'sub BNX_PORT_FEATURE_WOL () {0xdc;}' unless defined(&BNX_PORT_FEATURE_WOL);
	eval 'sub BNX_PORT2_FEATURE_WOL () {0x150;}' unless defined(&BNX_PORT2_FEATURE_WOL);
	eval 'sub BNX_PORT_FEATURE_WOL_DEFAULT_SHIFT_BITS () {4;}' unless defined(&BNX_PORT_FEATURE_WOL_DEFAULT_SHIFT_BITS);
	eval 'sub BNX_PORT_FEATURE_WOL_DEFAULT_MASK () {0x30;}' unless defined(&BNX_PORT_FEATURE_WOL_DEFAULT_MASK);
	eval 'sub BNX_PORT_FEATURE_WOL_DEFAULT_DISABLE () {0;}' unless defined(&BNX_PORT_FEATURE_WOL_DEFAULT_DISABLE);
	eval 'sub BNX_PORT_FEATURE_WOL_DEFAULT_MAGIC () {0x10;}' unless defined(&BNX_PORT_FEATURE_WOL_DEFAULT_MAGIC);
	eval 'sub BNX_PORT_FEATURE_WOL_DEFAULT_ACPI () {0x20;}' unless defined(&BNX_PORT_FEATURE_WOL_DEFAULT_ACPI);
	eval 'sub BNX_PORT_FEATURE_WOL_DEFAULT_MAGIC_AND_ACPI () {0x30;}' unless defined(&BNX_PORT_FEATURE_WOL_DEFAULT_MAGIC_AND_ACPI);
	eval 'sub BNX_PORT_FEATURE_WOL_LINK_SPEED_MASK () {0xf;}' unless defined(&BNX_PORT_FEATURE_WOL_LINK_SPEED_MASK);
	eval 'sub BNX_PORT_FEATURE_WOL_LINK_SPEED_AUTONEG () {0;}' unless defined(&BNX_PORT_FEATURE_WOL_LINK_SPEED_AUTONEG);
	eval 'sub BNX_PORT_FEATURE_WOL_LINK_SPEED_10HALF () {1;}' unless defined(&BNX_PORT_FEATURE_WOL_LINK_SPEED_10HALF);
	eval 'sub BNX_PORT_FEATURE_WOL_LINK_SPEED_10FULL () {2;}' unless defined(&BNX_PORT_FEATURE_WOL_LINK_SPEED_10FULL);
	eval 'sub BNX_PORT_FEATURE_WOL_LINK_SPEED_100HALF () {3;}' unless defined(&BNX_PORT_FEATURE_WOL_LINK_SPEED_100HALF);
	eval 'sub BNX_PORT_FEATURE_WOL_LINK_SPEED_100FULL () {4;}' unless defined(&BNX_PORT_FEATURE_WOL_LINK_SPEED_100FULL);
	eval 'sub BNX_PORT_FEATURE_WOL_LINK_SPEED_1000HALF () {5;}' unless defined(&BNX_PORT_FEATURE_WOL_LINK_SPEED_1000HALF);
	eval 'sub BNX_PORT_FEATURE_WOL_LINK_SPEED_1000FULL () {6;}' unless defined(&BNX_PORT_FEATURE_WOL_LINK_SPEED_1000FULL);
	eval 'sub BNX_PORT_FEATURE_WOL_AUTONEG_ADVERTISE_1000 () {0x40;}' unless defined(&BNX_PORT_FEATURE_WOL_AUTONEG_ADVERTISE_1000);
	eval 'sub BNX_PORT_FEATURE_WOL_RESERVED_PAUSE_CAP () {0x400;}' unless defined(&BNX_PORT_FEATURE_WOL_RESERVED_PAUSE_CAP);
	eval 'sub BNX_PORT_FEATURE_WOL_RESERVED_ASYM_PAUSE_CAP () {0x800;}' unless defined(&BNX_PORT_FEATURE_WOL_RESERVED_ASYM_PAUSE_CAP);
	eval 'sub BNX_PORT_FEATURE_MBA () {0xe0;}' unless defined(&BNX_PORT_FEATURE_MBA);
	eval 'sub BNX_PORT2_FEATURE_MBA () {0x154;}' unless defined(&BNX_PORT2_FEATURE_MBA);
	eval 'sub BNX_PORT_FEATURE_MBA_BOOT_AGENT_TYPE_SHIFT_BITS () {0;}' unless defined(&BNX_PORT_FEATURE_MBA_BOOT_AGENT_TYPE_SHIFT_BITS);
	eval 'sub BNX_PORT_FEATURE_MBA_BOOT_AGENT_TYPE_MASK () {0x3;}' unless defined(&BNX_PORT_FEATURE_MBA_BOOT_AGENT_TYPE_MASK);
	eval 'sub BNX_PORT_FEATURE_MBA_BOOT_AGENT_TYPE_PXE () {0;}' unless defined(&BNX_PORT_FEATURE_MBA_BOOT_AGENT_TYPE_PXE);
	eval 'sub BNX_PORT_FEATURE_MBA_BOOT_AGENT_TYPE_RPL () {1;}' unless defined(&BNX_PORT_FEATURE_MBA_BOOT_AGENT_TYPE_RPL);
	eval 'sub BNX_PORT_FEATURE_MBA_BOOT_AGENT_TYPE_BOOTP () {2;}' unless defined(&BNX_PORT_FEATURE_MBA_BOOT_AGENT_TYPE_BOOTP);
	eval 'sub BNX_PORT_FEATURE_MBA_LINK_SPEED_SHIFT_BITS () {2;}' unless defined(&BNX_PORT_FEATURE_MBA_LINK_SPEED_SHIFT_BITS);
	eval 'sub BNX_PORT_FEATURE_MBA_LINK_SPEED_MASK () {0x3c;}' unless defined(&BNX_PORT_FEATURE_MBA_LINK_SPEED_MASK);
	eval 'sub BNX_PORT_FEATURE_MBA_LINK_SPEED_AUTONEG () {0;}' unless defined(&BNX_PORT_FEATURE_MBA_LINK_SPEED_AUTONEG);
	eval 'sub BNX_PORT_FEATURE_MBA_LINK_SPEED_10HALF () {0x4;}' unless defined(&BNX_PORT_FEATURE_MBA_LINK_SPEED_10HALF);
	eval 'sub BNX_PORT_FEATURE_MBA_LINK_SPEED_10FULL () {0x8;}' unless defined(&BNX_PORT_FEATURE_MBA_LINK_SPEED_10FULL);
	eval 'sub BNX_PORT_FEATURE_MBA_LINK_SPEED_100HALF () {0xc;}' unless defined(&BNX_PORT_FEATURE_MBA_LINK_SPEED_100HALF);
	eval 'sub BNX_PORT_FEATURE_MBA_LINK_SPEED_100FULL () {0x10;}' unless defined(&BNX_PORT_FEATURE_MBA_LINK_SPEED_100FULL);
	eval 'sub BNX_PORT_FEATURE_MBA_LINK_SPEED_1000HALF () {0x14;}' unless defined(&BNX_PORT_FEATURE_MBA_LINK_SPEED_1000HALF);
	eval 'sub BNX_PORT_FEATURE_MBA_LINK_SPEED_1000FULL () {0x18;}' unless defined(&BNX_PORT_FEATURE_MBA_LINK_SPEED_1000FULL);
	eval 'sub BNX_PORT_FEATURE_MBA_SETUP_PROMPT_ENABLE () {0x40;}' unless defined(&BNX_PORT_FEATURE_MBA_SETUP_PROMPT_ENABLE);
	eval 'sub BNX_PORT_FEATURE_MBA_HOTKEY_CTRL_S () {0;}' unless defined(&BNX_PORT_FEATURE_MBA_HOTKEY_CTRL_S);
	eval 'sub BNX_PORT_FEATURE_MBA_HOTKEY_CTRL_B () {0x80;}' unless defined(&BNX_PORT_FEATURE_MBA_HOTKEY_CTRL_B);
	eval 'sub BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_SHIFT_BITS () {8;}' unless defined(&BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_SHIFT_BITS);
	eval 'sub BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_MASK () {0xff00;}' unless defined(&BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_MASK);
	eval 'sub BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_DISABLED () {0;}' unless defined(&BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_DISABLED);
	eval 'sub BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_1K () {0x100;}' unless defined(&BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_1K);
	eval 'sub BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_2K () {0x200;}' unless defined(&BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_2K);
	eval 'sub BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_4K () {0x300;}' unless defined(&BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_4K);
	eval 'sub BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_8K () {0x400;}' unless defined(&BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_8K);
	eval 'sub BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_16K () {0x500;}' unless defined(&BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_16K);
	eval 'sub BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_32K () {0x600;}' unless defined(&BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_32K);
	eval 'sub BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_64K () {0x700;}' unless defined(&BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_64K);
	eval 'sub BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_128K () {0x800;}' unless defined(&BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_128K);
	eval 'sub BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_256K () {0x900;}' unless defined(&BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_256K);
	eval 'sub BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_512K () {0xa00;}' unless defined(&BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_512K);
	eval 'sub BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_1M () {0xb00;}' unless defined(&BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_1M);
	eval 'sub BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_2M () {0xc00;}' unless defined(&BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_2M);
	eval 'sub BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_4M () {0xd00;}' unless defined(&BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_4M);
	eval 'sub BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_8M () {0xe00;}' unless defined(&BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_8M);
	eval 'sub BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_16M () {0xf00;}' unless defined(&BNX_PORT_FEATURE_MBA_EXP_ROM_SIZE_16M);
	eval 'sub BNX_PORT_FEATURE_MBA_MSG_TIMEOUT_SHIFT_BITS () {16;}' unless defined(&BNX_PORT_FEATURE_MBA_MSG_TIMEOUT_SHIFT_BITS);
	eval 'sub BNX_PORT_FEATURE_MBA_MSG_TIMEOUT_MASK () {0xf0000;}' unless defined(&BNX_PORT_FEATURE_MBA_MSG_TIMEOUT_MASK);
	eval 'sub BNX_PORT_FEATURE_MBA_BIOS_BOOTSTRAP_SHIFT_BITS () {20;}' unless defined(&BNX_PORT_FEATURE_MBA_BIOS_BOOTSTRAP_SHIFT_BITS);
	eval 'sub BNX_PORT_FEATURE_MBA_BIOS_BOOTSTRAP_MASK () {0x300000;}' unless defined(&BNX_PORT_FEATURE_MBA_BIOS_BOOTSTRAP_MASK);
	eval 'sub BNX_PORT_FEATURE_MBA_BIOS_BOOTSTRAP_AUTO () {0;}' unless defined(&BNX_PORT_FEATURE_MBA_BIOS_BOOTSTRAP_AUTO);
	eval 'sub BNX_PORT_FEATURE_MBA_BIOS_BOOTSTRAP_BBS () {0x100000;}' unless defined(&BNX_PORT_FEATURE_MBA_BIOS_BOOTSTRAP_BBS);
	eval 'sub BNX_PORT_FEATURE_MBA_BIOS_BOOTSTRAP_INT18H () {0x200000;}' unless defined(&BNX_PORT_FEATURE_MBA_BIOS_BOOTSTRAP_INT18H);
	eval 'sub BNX_PORT_FEATURE_MBA_BIOS_BOOTSTRAP_INT19H () {0x300000;}' unless defined(&BNX_PORT_FEATURE_MBA_BIOS_BOOTSTRAP_INT19H);
	eval 'sub BNX_PORT_FEATURE_IMD () {0xe4;}' unless defined(&BNX_PORT_FEATURE_IMD);
	eval 'sub BNX_PORT2_FEATURE_IMD () {0x158;}' unless defined(&BNX_PORT2_FEATURE_IMD);
	eval 'sub BNX_PORT_FEATURE_IMD_LINK_OVERRIDE_DEFAULT () {0;}' unless defined(&BNX_PORT_FEATURE_IMD_LINK_OVERRIDE_DEFAULT);
	eval 'sub BNX_PORT_FEATURE_IMD_LINK_OVERRIDE_ENABLE () {1;}' unless defined(&BNX_PORT_FEATURE_IMD_LINK_OVERRIDE_ENABLE);
	eval 'sub BNX_PORT_FEATURE_VLAN () {0xe8;}' unless defined(&BNX_PORT_FEATURE_VLAN);
	eval 'sub BNX_PORT2_FEATURE_VLAN () {0x15c;}' unless defined(&BNX_PORT2_FEATURE_VLAN);
	eval 'sub BNX_PORT_FEATURE_MBA_VLAN_TAG_MASK () {0xffff;}' unless defined(&BNX_PORT_FEATURE_MBA_VLAN_TAG_MASK);
	eval 'sub BNX_PORT_FEATURE_MBA_VLAN_ENABLE () {0x10000;}' unless defined(&BNX_PORT_FEATURE_MBA_VLAN_ENABLE);
	eval 'sub BNX_BC_STATE_RESET_TYPE () {0x1c0;}' unless defined(&BNX_BC_STATE_RESET_TYPE);
	eval 'sub BNX_BC_STATE_RESET_TYPE_SIG () {0x5254;}' unless defined(&BNX_BC_STATE_RESET_TYPE_SIG);
	eval 'sub BNX_BC_STATE_RESET_TYPE_SIG_MASK () {0xffff;}' unless defined(&BNX_BC_STATE_RESET_TYPE_SIG_MASK);
	eval 'sub BNX_BC_STATE_RESET_TYPE_NONE () {( &BNX_BC_STATE_RESET_TYPE_SIG | 0x10000);}' unless defined(&BNX_BC_STATE_RESET_TYPE_NONE);
	eval 'sub BNX_BC_STATE_RESET_TYPE_PCI () {( &BNX_BC_STATE_RESET_TYPE_SIG | 0x20000);}' unless defined(&BNX_BC_STATE_RESET_TYPE_PCI);
	eval 'sub BNX_BC_STATE_RESET_TYPE_VAUX () {( &BNX_BC_STATE_RESET_TYPE_SIG | 0x30000);}' unless defined(&BNX_BC_STATE_RESET_TYPE_VAUX);
	eval 'sub BNX_BC_STATE_RESET_TYPE_DRV_MASK () { &DRV_MSG_CODE;}' unless defined(&BNX_BC_STATE_RESET_TYPE_DRV_MASK);
	eval 'sub BNX_BC_STATE_RESET_TYPE_DRV_RESET () {( &BNX_BC_STATE_RESET_TYPE_SIG |  &DRV_MSG_CODE_RESET);}' unless defined(&BNX_BC_STATE_RESET_TYPE_DRV_RESET);
	eval 'sub BNX_BC_STATE_RESET_TYPE_DRV_UNLOAD () {( &BNX_BC_STATE_RESET_TYPE_SIG |  &DRV_MSG_CODE_UNLOAD);}' unless defined(&BNX_BC_STATE_RESET_TYPE_DRV_UNLOAD);
	eval 'sub BNX_BC_STATE_RESET_TYPE_DRV_SHUTDOWN () {( &BNX_BC_STATE_RESET_TYPE_SIG |  &DRV_MSG_CODE_SHUTDOWN);}' unless defined(&BNX_BC_STATE_RESET_TYPE_DRV_SHUTDOWN);
	eval 'sub BNX_BC_STATE_RESET_TYPE_DRV_WOL () {( &BNX_BC_STATE_RESET_TYPE_SIG |  &DRV_MSG_CODE_WOL);}' unless defined(&BNX_BC_STATE_RESET_TYPE_DRV_WOL);
	eval 'sub BNX_BC_STATE_RESET_TYPE_DRV_DIAG () {( &BNX_BC_STATE_RESET_TYPE_SIG |  &DRV_MSG_CODE_DIAG);}' unless defined(&BNX_BC_STATE_RESET_TYPE_DRV_DIAG);
	eval 'sub BNX_BC_STATE_RESET_TYPE_VALUE {
	    my($msg) = @_;
    	    eval q(( &BNX_BC_STATE_RESET_TYPE_SIG | ($msg)));
	}' unless defined(&BNX_BC_STATE_RESET_TYPE_VALUE);
	eval 'sub BNX_BC_STATE () {0x1c4;}' unless defined(&BNX_BC_STATE);
	eval 'sub BNX_BC_STATE_ERR_MASK () {0xff00;}' unless defined(&BNX_BC_STATE_ERR_MASK);
	eval 'sub BNX_BC_STATE_SIGN () {0x42530000;}' unless defined(&BNX_BC_STATE_SIGN);
	eval 'sub BNX_BC_STATE_SIGN_MASK () {0xffff0000;}' unless defined(&BNX_BC_STATE_SIGN_MASK);
	eval 'sub BNX_BC_STATE_BC1_START () {( &BNX_BC_STATE_SIGN | 0x1);}' unless defined(&BNX_BC_STATE_BC1_START);
	eval 'sub BNX_BC_STATE_GET_NVM_CFG1 () {( &BNX_BC_STATE_SIGN | 0x2);}' unless defined(&BNX_BC_STATE_GET_NVM_CFG1);
	eval 'sub BNX_BC_STATE_PROG_BAR () {( &BNX_BC_STATE_SIGN | 0x3);}' unless defined(&BNX_BC_STATE_PROG_BAR);
	eval 'sub BNX_BC_STATE_INIT_VID () {( &BNX_BC_STATE_SIGN | 0x4);}' unless defined(&BNX_BC_STATE_INIT_VID);
	eval 'sub BNX_BC_STATE_GET_NVM_CFG2 () {( &BNX_BC_STATE_SIGN | 0x5);}' unless defined(&BNX_BC_STATE_GET_NVM_CFG2);
	eval 'sub BNX_BC_STATE_APPLY_WKARND () {( &BNX_BC_STATE_SIGN | 0x6);}' unless defined(&BNX_BC_STATE_APPLY_WKARND);
	eval 'sub BNX_BC_STATE_LOAD_BC2 () {( &BNX_BC_STATE_SIGN | 0x7);}' unless defined(&BNX_BC_STATE_LOAD_BC2);
	eval 'sub BNX_BC_STATE_GOING_BC2 () {( &BNX_BC_STATE_SIGN | 0x8);}' unless defined(&BNX_BC_STATE_GOING_BC2);
	eval 'sub BNX_BC_STATE_GOING_DIAG () {( &BNX_BC_STATE_SIGN | 0x9);}' unless defined(&BNX_BC_STATE_GOING_DIAG);
	eval 'sub BNX_BC_STATE_RT_FINAL_INIT () {( &BNX_BC_STATE_SIGN | 0x81);}' unless defined(&BNX_BC_STATE_RT_FINAL_INIT);
	eval 'sub BNX_BC_STATE_RT_WKARND () {( &BNX_BC_STATE_SIGN | 0x82);}' unless defined(&BNX_BC_STATE_RT_WKARND);
	eval 'sub BNX_BC_STATE_RT_DRV_PULSE () {( &BNX_BC_STATE_SIGN | 0x83);}' unless defined(&BNX_BC_STATE_RT_DRV_PULSE);
	eval 'sub BNX_BC_STATE_RT_FIOEVTS () {( &BNX_BC_STATE_SIGN | 0x84);}' unless defined(&BNX_BC_STATE_RT_FIOEVTS);
	eval 'sub BNX_BC_STATE_RT_DRV_CMD () {( &BNX_BC_STATE_SIGN | 0x85);}' unless defined(&BNX_BC_STATE_RT_DRV_CMD);
	eval 'sub BNX_BC_STATE_RT_LOW_POWER () {( &BNX_BC_STATE_SIGN | 0x86);}' unless defined(&BNX_BC_STATE_RT_LOW_POWER);
	eval 'sub BNX_BC_STATE_RT_SET_WOL () {( &BNX_BC_STATE_SIGN | 0x87);}' unless defined(&BNX_BC_STATE_RT_SET_WOL);
	eval 'sub BNX_BC_STATE_RT_OTHER_FW () {( &BNX_BC_STATE_SIGN | 0x88);}' unless defined(&BNX_BC_STATE_RT_OTHER_FW);
	eval 'sub BNX_BC_STATE_RT_GOING_D3 () {( &BNX_BC_STATE_SIGN | 0x89);}' unless defined(&BNX_BC_STATE_RT_GOING_D3);
	eval 'sub BNX_BC_STATE_ERR_BAD_VERSION () {( &BNX_BC_STATE_SIGN | 0x100);}' unless defined(&BNX_BC_STATE_ERR_BAD_VERSION);
	eval 'sub BNX_BC_STATE_ERR_BAD_BC2_CRC () {( &BNX_BC_STATE_SIGN | 0x200);}' unless defined(&BNX_BC_STATE_ERR_BAD_BC2_CRC);
	eval 'sub BNX_BC_STATE_ERR_BC1_LOOP () {( &BNX_BC_STATE_SIGN | 0x300);}' unless defined(&BNX_BC_STATE_ERR_BC1_LOOP);
	eval 'sub BNX_BC_STATE_ERR_UNKNOWN_CMD () {( &BNX_BC_STATE_SIGN | 0x400);}' unless defined(&BNX_BC_STATE_ERR_UNKNOWN_CMD);
	eval 'sub BNX_BC_STATE_ERR_DRV_DEAD () {( &BNX_BC_STATE_SIGN | 0x500);}' unless defined(&BNX_BC_STATE_ERR_DRV_DEAD);
	eval 'sub BNX_BC_STATE_ERR_NO_RXP () {( &BNX_BC_STATE_SIGN | 0x600);}' unless defined(&BNX_BC_STATE_ERR_NO_RXP);
	eval 'sub BNX_BC_STATE_ERR_TOO_MANY_RBUF () {( &BNX_BC_STATE_SIGN | 0x700);}' unless defined(&BNX_BC_STATE_ERR_TOO_MANY_RBUF);
	eval 'sub BNX_BC_STATE_DEBUG_CMD () {0x1dc;}' unless defined(&BNX_BC_STATE_DEBUG_CMD);
	eval 'sub BNX_BC_STATE_BC_DBG_CMD_SIGNATURE () {0x42440000;}' unless defined(&BNX_BC_STATE_BC_DBG_CMD_SIGNATURE);
	eval 'sub BNX_BC_STATE_BC_DBG_CMD_SIGNATURE_MASK () {0xffff0000;}' unless defined(&BNX_BC_STATE_BC_DBG_CMD_SIGNATURE_MASK);
	eval 'sub BNX_BC_STATE_BC_DBG_CMD_LOOP_CNT_MASK () {0xffff;}' unless defined(&BNX_BC_STATE_BC_DBG_CMD_LOOP_CNT_MASK);
	eval 'sub BNX_BC_STATE_BC_DBG_CMD_LOOP_INFINITE () {0xffff;}' unless defined(&BNX_BC_STATE_BC_DBG_CMD_LOOP_INFINITE);
	eval 'sub HOST_VIEW_SHMEM_BASE () {0x167c00;}' unless defined(&HOST_VIEW_SHMEM_BASE);
	eval 'sub BNX_PCI_BAR0 () {0x10;}' unless defined(&BNX_PCI_BAR0);
	eval 'sub BNX_PCI_PCIX_CMD () {0x40;}' unless defined(&BNX_PCI_PCIX_CMD);
	eval 'sub BNX_PRINTF () {( &sc,  &fmt,  &args...)  &printf("%s: "  &fmt,  ($sc->{bnx_dev}->{dv_xname}),  &args);}' unless defined(&BNX_PRINTF);
	eval 'sub REG_WR {
	    my($sc, $reg, $val) = @_;
    	    eval q( &bus_space_write_4( ($sc->{bnx_btag}),  ($sc->{bnx_bhandle}), $reg, $val));
	}' unless defined(&REG_WR);
	eval 'sub REG_WR16 {
	    my($sc, $reg, $val) = @_;
    	    eval q( &bus_space_write_2( ($sc->{bnx_btag}),  ($sc->{bnx_bhandle}), $reg, $val));
	}' unless defined(&REG_WR16);
	eval 'sub REG_RD {
	    my($sc, $reg) = @_;
    	    eval q( &bus_space_read_4( ($sc->{bnx_btag}),  ($sc->{bnx_bhandle}), $reg));
	}' unless defined(&REG_RD);
	eval 'sub REG_RD_IND {
	    my($sc, $offset) = @_;
    	    eval q( &bnx_reg_rd_ind($sc, $offset));
	}' unless defined(&REG_RD_IND);
	eval 'sub REG_WR_IND {
	    my($sc, $offset, $val) = @_;
    	    eval q( &bnx_reg_wr_ind($sc, $offset, $val));
	}' unless defined(&REG_WR_IND);
	eval 'sub CTX_WR {
	    my($sc, $cid_addr, $offset, $val) = @_;
    	    eval q( &bnx_ctx_wr($sc, $cid_addr, $offset, $val));
	}' unless defined(&CTX_WR);
	eval 'sub BNX_SETBIT {
	    my($sc, $reg, $x) = @_;
    	    eval q( &REG_WR($sc, $reg, ( &REG_RD($sc, $reg) | ($x))));
	}' unless defined(&BNX_SETBIT);
	eval 'sub BNX_CLRBIT {
	    my($sc, $reg, $x) = @_;
    	    eval q( &REG_WR($sc, $reg, ( &REG_RD($sc, $reg) & ~($x))));
	}' unless defined(&BNX_CLRBIT);
	eval 'sub PCI_SETBIT {
	    my($pc, $tag, $reg, $x) = @_;
    	    eval q( &pci_conf_write($pc, $tag, $reg, ( &pci_conf_read($pc, $tag, $reg) | ($x))));
	}' unless defined(&PCI_SETBIT);
	eval 'sub PCI_CLRBIT {
	    my($pc, $tag, $reg, $x) = @_;
    	    eval q( &pci_conf_write($pc, $tag, $reg, ( &pci_conf_read($pc, $tag, $reg) & ~($x))));
	}' unless defined(&PCI_CLRBIT);
	eval 'sub BNX_STATS {
	    my($x) = @_;
    	    eval q(  ($stats->{stat_})  $x   &_lo);
	}' unless defined(&BNX_STATS);
	eval 'sub TX_BD_FLAGS_CONN_FAULT () {(1<<0);}' unless defined(&TX_BD_FLAGS_CONN_FAULT);
	eval 'sub TX_BD_FLAGS_TCP_UDP_CKSUM () {(1<<1);}' unless defined(&TX_BD_FLAGS_TCP_UDP_CKSUM);
	eval 'sub TX_BD_FLAGS_IP_CKSUM () {(1<<2);}' unless defined(&TX_BD_FLAGS_IP_CKSUM);
	eval 'sub TX_BD_FLAGS_VLAN_TAG () {(1<<3);}' unless defined(&TX_BD_FLAGS_VLAN_TAG);
	eval 'sub TX_BD_FLAGS_COAL_NOW () {(1<<4);}' unless defined(&TX_BD_FLAGS_COAL_NOW);
	eval 'sub TX_BD_FLAGS_DONT_GEN_CRC () {(1<<5);}' unless defined(&TX_BD_FLAGS_DONT_GEN_CRC);
	eval 'sub TX_BD_FLAGS_END () {(1<<6);}' unless defined(&TX_BD_FLAGS_END);
	eval 'sub TX_BD_FLAGS_START () {(1<<7);}' unless defined(&TX_BD_FLAGS_START);
	eval 'sub TX_BD_FLAGS_SW_OPTION_WORD () {(0x1f<<8);}' unless defined(&TX_BD_FLAGS_SW_OPTION_WORD);
	eval 'sub TX_BD_FLAGS_SW_FLAGS () {(1<<13);}' unless defined(&TX_BD_FLAGS_SW_FLAGS);
	eval 'sub TX_BD_FLAGS_SW_SNAP () {(1<<14);}' unless defined(&TX_BD_FLAGS_SW_SNAP);
	eval 'sub TX_BD_FLAGS_SW_LSO () {(1<<15);}' unless defined(&TX_BD_FLAGS_SW_LSO);
	eval 'sub RX_BD_FLAGS_NOPUSH () {(1<<0);}' unless defined(&RX_BD_FLAGS_NOPUSH);
	eval 'sub RX_BD_FLAGS_DUMMY () {(1<<1);}' unless defined(&RX_BD_FLAGS_DUMMY);
	eval 'sub RX_BD_FLAGS_END () {(1<<2);}' unless defined(&RX_BD_FLAGS_END);
	eval 'sub RX_BD_FLAGS_START () {(1<<3);}' unless defined(&RX_BD_FLAGS_START);
	eval 'sub STATUS_ATTN_BITS_LINK_STATE () {(1<<0);}' unless defined(&STATUS_ATTN_BITS_LINK_STATE);
	eval 'sub STATUS_ATTN_BITS_TX_SCHEDULER_ABORT () {(1<<1);}' unless defined(&STATUS_ATTN_BITS_TX_SCHEDULER_ABORT);
	eval 'sub STATUS_ATTN_BITS_TX_BD_READ_ABORT () {(1<<2);}' unless defined(&STATUS_ATTN_BITS_TX_BD_READ_ABORT);
	eval 'sub STATUS_ATTN_BITS_TX_BD_CACHE_ABORT () {(1<<3);}' unless defined(&STATUS_ATTN_BITS_TX_BD_CACHE_ABORT);
	eval 'sub STATUS_ATTN_BITS_TX_PROCESSOR_ABORT () {(1<<4);}' unless defined(&STATUS_ATTN_BITS_TX_PROCESSOR_ABORT);
	eval 'sub STATUS_ATTN_BITS_TX_DMA_ABORT () {(1<<5);}' unless defined(&STATUS_ATTN_BITS_TX_DMA_ABORT);
	eval 'sub STATUS_ATTN_BITS_TX_PATCHUP_ABORT () {(1<<6);}' unless defined(&STATUS_ATTN_BITS_TX_PATCHUP_ABORT);
	eval 'sub STATUS_ATTN_BITS_TX_ASSEMBLER_ABORT () {(1<<7);}' unless defined(&STATUS_ATTN_BITS_TX_ASSEMBLER_ABORT);
	eval 'sub STATUS_ATTN_BITS_RX_PARSER_MAC_ABORT () {(1<<8);}' unless defined(&STATUS_ATTN_BITS_RX_PARSER_MAC_ABORT);
	eval 'sub STATUS_ATTN_BITS_RX_PARSER_CATCHUP_ABORT () {(1<<9);}' unless defined(&STATUS_ATTN_BITS_RX_PARSER_CATCHUP_ABORT);
	eval 'sub STATUS_ATTN_BITS_RX_MBUF_ABORT () {(1<<10);}' unless defined(&STATUS_ATTN_BITS_RX_MBUF_ABORT);
	eval 'sub STATUS_ATTN_BITS_RX_LOOKUP_ABORT () {(1<<11);}' unless defined(&STATUS_ATTN_BITS_RX_LOOKUP_ABORT);
	eval 'sub STATUS_ATTN_BITS_RX_PROCESSOR_ABORT () {(1<<12);}' unless defined(&STATUS_ATTN_BITS_RX_PROCESSOR_ABORT);
	eval 'sub STATUS_ATTN_BITS_RX_V2P_ABORT () {(1<<13);}' unless defined(&STATUS_ATTN_BITS_RX_V2P_ABORT);
	eval 'sub STATUS_ATTN_BITS_RX_BD_CACHE_ABORT () {(1<<14);}' unless defined(&STATUS_ATTN_BITS_RX_BD_CACHE_ABORT);
	eval 'sub STATUS_ATTN_BITS_RX_DMA_ABORT () {(1<<15);}' unless defined(&STATUS_ATTN_BITS_RX_DMA_ABORT);
	eval 'sub STATUS_ATTN_BITS_COMPLETION_ABORT () {(1<<16);}' unless defined(&STATUS_ATTN_BITS_COMPLETION_ABORT);
	eval 'sub STATUS_ATTN_BITS_HOST_COALESCE_ABORT () {(1<<17);}' unless defined(&STATUS_ATTN_BITS_HOST_COALESCE_ABORT);
	eval 'sub STATUS_ATTN_BITS_MAILBOX_QUEUE_ABORT () {(1<<18);}' unless defined(&STATUS_ATTN_BITS_MAILBOX_QUEUE_ABORT);
	eval 'sub STATUS_ATTN_BITS_CONTEXT_ABORT () {(1<<19);}' unless defined(&STATUS_ATTN_BITS_CONTEXT_ABORT);
	eval 'sub STATUS_ATTN_BITS_CMD_SCHEDULER_ABORT () {(1<<20);}' unless defined(&STATUS_ATTN_BITS_CMD_SCHEDULER_ABORT);
	eval 'sub STATUS_ATTN_BITS_CMD_PROCESSOR_ABORT () {(1<<21);}' unless defined(&STATUS_ATTN_BITS_CMD_PROCESSOR_ABORT);
	eval 'sub STATUS_ATTN_BITS_MGMT_PROCESSOR_ABORT () {(1<<22);}' unless defined(&STATUS_ATTN_BITS_MGMT_PROCESSOR_ABORT);
	eval 'sub STATUS_ATTN_BITS_MAC_ABORT () {(1<<23);}' unless defined(&STATUS_ATTN_BITS_MAC_ABORT);
	eval 'sub STATUS_ATTN_BITS_TIMER_ABORT () {(1<<24);}' unless defined(&STATUS_ATTN_BITS_TIMER_ABORT);
	eval 'sub STATUS_ATTN_BITS_DMAE_ABORT () {(1<<25);}' unless defined(&STATUS_ATTN_BITS_DMAE_ABORT);
	eval 'sub STATUS_ATTN_BITS_FLSH_ABORT () {(1<<26);}' unless defined(&STATUS_ATTN_BITS_FLSH_ABORT);
	eval 'sub STATUS_ATTN_BITS_GRC_ABORT () {(1<<27);}' unless defined(&STATUS_ATTN_BITS_GRC_ABORT);
	eval 'sub STATUS_ATTN_BITS_PARITY_ERROR () {(1<<31);}' unless defined(&STATUS_ATTN_BITS_PARITY_ERROR);
	if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
	}
 elsif((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
	}
	eval 'sub L2_FHDR_STATUS_RULE_CLASS () {(0x7<<0);}' unless defined(&L2_FHDR_STATUS_RULE_CLASS);
	eval 'sub L2_FHDR_STATUS_RULE_P2 () {(1<<3);}' unless defined(&L2_FHDR_STATUS_RULE_P2);
	eval 'sub L2_FHDR_STATUS_RULE_P3 () {(1<<4);}' unless defined(&L2_FHDR_STATUS_RULE_P3);
	eval 'sub L2_FHDR_STATUS_RULE_P4 () {(1<<5);}' unless defined(&L2_FHDR_STATUS_RULE_P4);
	eval 'sub L2_FHDR_STATUS_L2_VLAN_TAG () {(1<<6);}' unless defined(&L2_FHDR_STATUS_L2_VLAN_TAG);
	eval 'sub L2_FHDR_STATUS_L2_LLC_SNAP () {(1<<7);}' unless defined(&L2_FHDR_STATUS_L2_LLC_SNAP);
	eval 'sub L2_FHDR_STATUS_RSS_HASH () {(1<<8);}' unless defined(&L2_FHDR_STATUS_RSS_HASH);
	eval 'sub L2_FHDR_STATUS_IP_DATAGRAM () {(1<<13);}' unless defined(&L2_FHDR_STATUS_IP_DATAGRAM);
	eval 'sub L2_FHDR_STATUS_TCP_SEGMENT () {(1<<14);}' unless defined(&L2_FHDR_STATUS_TCP_SEGMENT);
	eval 'sub L2_FHDR_STATUS_UDP_DATAGRAM () {(1<<15);}' unless defined(&L2_FHDR_STATUS_UDP_DATAGRAM);
	eval 'sub L2_FHDR_ERRORS_BAD_CRC () {(1<<17);}' unless defined(&L2_FHDR_ERRORS_BAD_CRC);
	eval 'sub L2_FHDR_ERRORS_PHY_DECODE () {(1<<18);}' unless defined(&L2_FHDR_ERRORS_PHY_DECODE);
	eval 'sub L2_FHDR_ERRORS_ALIGNMENT () {(1<<19);}' unless defined(&L2_FHDR_ERRORS_ALIGNMENT);
	eval 'sub L2_FHDR_ERRORS_TOO_SHORT () {(1<<20);}' unless defined(&L2_FHDR_ERRORS_TOO_SHORT);
	eval 'sub L2_FHDR_ERRORS_GIANT_FRAME () {(1<<21);}' unless defined(&L2_FHDR_ERRORS_GIANT_FRAME);
	eval 'sub L2_FHDR_ERRORS_TCP_XSUM () {(1<<28);}' unless defined(&L2_FHDR_ERRORS_TCP_XSUM);
	eval 'sub L2_FHDR_ERRORS_UDP_XSUM () {(1<<31);}' unless defined(&L2_FHDR_ERRORS_UDP_XSUM);
	if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
	}
 elsif((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
	}
	eval 'sub BNX_L2CTX_TYPE () {0x;}' unless defined(&BNX_L2CTX_TYPE);
	eval 'sub BNX_L2CTX_TYPE_SIZE_L2 () {((0xc0/0x20)<<16);}' unless defined(&BNX_L2CTX_TYPE_SIZE_L2);
	eval 'sub BNX_L2CTX_TYPE_TYPE () {(0xf<<28);}' unless defined(&BNX_L2CTX_TYPE_TYPE);
	eval 'sub BNX_L2CTX_TYPE_TYPE_EMPTY () {(0<<28);}' unless defined(&BNX_L2CTX_TYPE_TYPE_EMPTY);
	eval 'sub BNX_L2CTX_TYPE_TYPE_L2 () {(1<<28);}' unless defined(&BNX_L2CTX_TYPE_TYPE_L2);
	eval 'sub BNX_L2CTX_TYPE_XI () {0x80;}' unless defined(&BNX_L2CTX_TYPE_XI);
	eval 'sub BNX_L2CTX_TX_HOST_BIDX () {0x88;}' unless defined(&BNX_L2CTX_TX_HOST_BIDX);
	eval 'sub BNX_L2CTX_EST_NBD () {0x88;}' unless defined(&BNX_L2CTX_EST_NBD);
	eval 'sub BNX_L2CTX_CMD_TYPE () {0x88;}' unless defined(&BNX_L2CTX_CMD_TYPE);
	eval 'sub BNX_L2CTX_CMD_TYPE_TYPE () {(0xf<<24);}' unless defined(&BNX_L2CTX_CMD_TYPE_TYPE);
	eval 'sub BNX_L2CTX_CMD_TYPE_TYPE_L2 () {(0<<24);}' unless defined(&BNX_L2CTX_CMD_TYPE_TYPE_L2);
	eval 'sub BNX_L2CTX_CMD_TYPE_TYPE_TCP () {(1<<24);}' unless defined(&BNX_L2CTX_CMD_TYPE_TYPE_TCP);
	eval 'sub BNX_L2CTX_TX_HOST_BSEQ () {0x90;}' unless defined(&BNX_L2CTX_TX_HOST_BSEQ);
	eval 'sub BNX_L2CTX_TSCH_BSEQ () {0x94;}' unless defined(&BNX_L2CTX_TSCH_BSEQ);
	eval 'sub BNX_L2CTX_TBDR_BSEQ () {0x98;}' unless defined(&BNX_L2CTX_TBDR_BSEQ);
	eval 'sub BNX_L2CTX_TBDR_BOFF () {0x9c;}' unless defined(&BNX_L2CTX_TBDR_BOFF);
	eval 'sub BNX_L2CTX_TBDR_BIDX () {0x9c;}' unless defined(&BNX_L2CTX_TBDR_BIDX);
	eval 'sub BNX_L2CTX_TBDR_BHADDR_HI () {0xa0;}' unless defined(&BNX_L2CTX_TBDR_BHADDR_HI);
	eval 'sub BNX_L2CTX_TBDR_BHADDR_LO () {0xa4;}' unless defined(&BNX_L2CTX_TBDR_BHADDR_LO);
	eval 'sub BNX_L2CTX_TXP_BOFF () {0xa8;}' unless defined(&BNX_L2CTX_TXP_BOFF);
	eval 'sub BNX_L2CTX_TXP_BIDX () {0xa8;}' unless defined(&BNX_L2CTX_TXP_BIDX);
	eval 'sub BNX_L2CTX_TXP_BSEQ () {0xac;}' unless defined(&BNX_L2CTX_TXP_BSEQ);
	eval 'sub BNX_L2CTX_CMD_TYPE_XI () {0x240;}' unless defined(&BNX_L2CTX_CMD_TYPE_XI);
	eval 'sub BNX_L2CTX_TBDR_BHADDR_HI_XI () {0x258;}' unless defined(&BNX_L2CTX_TBDR_BHADDR_HI_XI);
	eval 'sub BNX_L2CTX_TBDR_BHADDR_LO_XI () {0x25c;}' unless defined(&BNX_L2CTX_TBDR_BHADDR_LO_XI);
	eval 'sub BNX_L2CTX_BD_PRE_READ () {0x;}' unless defined(&BNX_L2CTX_BD_PRE_READ);
	eval 'sub BNX_L2CTX_CTX_SIZE () {0x;}' unless defined(&BNX_L2CTX_CTX_SIZE);
	eval 'sub BNX_L2CTX_CTX_TYPE () {0x;}' unless defined(&BNX_L2CTX_CTX_TYPE);
	eval 'sub BNX_L2CTX_CTX_TYPE_SIZE_L2 () {((0x20/20)<<16);}' unless defined(&BNX_L2CTX_CTX_TYPE_SIZE_L2);
	eval 'sub BNX_L2CTX_CTX_TYPE_CTX_BD_CHN_TYPE () {(0xf<<28);}' unless defined(&BNX_L2CTX_CTX_TYPE_CTX_BD_CHN_TYPE);
	eval 'sub BNX_L2CTX_CTX_TYPE_CTX_BD_CHN_TYPE_UNDEFINED () {(0<<28);}' unless defined(&BNX_L2CTX_CTX_TYPE_CTX_BD_CHN_TYPE_UNDEFINED);
	eval 'sub BNX_L2CTX_CTX_TYPE_CTX_BD_CHN_TYPE_VALUE () {(1<<28);}' unless defined(&BNX_L2CTX_CTX_TYPE_CTX_BD_CHN_TYPE_VALUE);
	eval 'sub BNX_L2CTX_HOST_BDIDX () {0x4;}' unless defined(&BNX_L2CTX_HOST_BDIDX);
	eval 'sub BNX_L2CTX_HOST_BSEQ () {0x8;}' unless defined(&BNX_L2CTX_HOST_BSEQ);
	eval 'sub BNX_L2CTX_NX_BSEQ () {0xc;}' unless defined(&BNX_L2CTX_NX_BSEQ);
	eval 'sub BNX_L2CTX_NX_BDHADDR_HI () {0x10;}' unless defined(&BNX_L2CTX_NX_BDHADDR_HI);
	eval 'sub BNX_L2CTX_NX_BDHADDR_LO () {0x14;}' unless defined(&BNX_L2CTX_NX_BDHADDR_LO);
	eval 'sub BNX_L2CTX_NX_BDIDX () {0x18;}' unless defined(&BNX_L2CTX_NX_BDIDX);
	eval 'sub BNX_L2CTX_RX_WATER_MARK () {0x;}' unless defined(&BNX_L2CTX_RX_WATER_MARK);
	eval 'sub BNX_L2CTX_RX_LO_WATER_MARK_SHIFT () {0;}' unless defined(&BNX_L2CTX_RX_LO_WATER_MARK_SHIFT);
	eval 'sub BNX_L2CTX_RX_LO_WATER_MARK_DEFAULT () {32;}' unless defined(&BNX_L2CTX_RX_LO_WATER_MARK_DEFAULT);
	eval 'sub BNX_L2CTX_RX_LO_WATER_MARK_SCALE () {4;}' unless defined(&BNX_L2CTX_RX_LO_WATER_MARK_SCALE);
	eval 'sub BNX_L2CTX_RX_LO_WATER_MARK_DIS () {0;}' unless defined(&BNX_L2CTX_RX_LO_WATER_MARK_DIS);
	eval 'sub BNX_L2CTX_RX_HI_WATER_MARK_SHIFT () {4;}' unless defined(&BNX_L2CTX_RX_HI_WATER_MARK_SHIFT);
	eval 'sub BNX_L2CTX_RX_HI_WATER_MARK_SCALE () {16;}' unless defined(&BNX_L2CTX_RX_HI_WATER_MARK_SCALE);
	eval 'sub BNX_L2CTX_RX_WATER_MARKS_MSK () {0xff;}' unless defined(&BNX_L2CTX_RX_WATER_MARKS_MSK);
	eval 'sub BNX_L2CTX_RX_BD_PRE_READ () {0x;}' unless defined(&BNX_L2CTX_RX_BD_PRE_READ);
	eval 'sub BNX_L2CTX_RX_BD_PRE_READ_SHIFT () {8;}' unless defined(&BNX_L2CTX_RX_BD_PRE_READ_SHIFT);
	eval 'sub BNX_L2CTX_RX_CTX_SIZE () {0x;}' unless defined(&BNX_L2CTX_RX_CTX_SIZE);
	eval 'sub BNX_L2CTX_RX_CTX_SIZE_SHIFT () {16;}' unless defined(&BNX_L2CTX_RX_CTX_SIZE_SHIFT);
	eval 'sub BNX_L2CTX_RX_CTX_TYPE_SIZE_L2 () {((0x20/20)<< &BNX_L2CTX_RX_CTX_SIZE_SHIFT);}' unless defined(&BNX_L2CTX_RX_CTX_TYPE_SIZE_L2);
	eval 'sub BNX_L2CTX_RX_CTX_TYPE () {0x;}' unless defined(&BNX_L2CTX_RX_CTX_TYPE);
	eval 'sub BNX_L2CTX_RX_CTX_TYPE_SHIFT () {24;}' unless defined(&BNX_L2CTX_RX_CTX_TYPE_SHIFT);
	eval 'sub BNX_L2CTX_RX_CTX_TYPE_CTX_BD_CHN_TYPE () {(0xf<<28);}' unless defined(&BNX_L2CTX_RX_CTX_TYPE_CTX_BD_CHN_TYPE);
	eval 'sub BNX_L2CTX_RX_CTX_TYPE_CTX_BD_CHN_TYPE_UNDEFINED () {(0<<28);}' unless defined(&BNX_L2CTX_RX_CTX_TYPE_CTX_BD_CHN_TYPE_UNDEFINED);
	eval 'sub BNX_L2CTX_RX_CTX_TYPE_CTX_BD_CHN_TYPE_VALUE () {(1<<28);}' unless defined(&BNX_L2CTX_RX_CTX_TYPE_CTX_BD_CHN_TYPE_VALUE);
	eval 'sub BNX_L2CTX_RX_HOST_BDIDX () {0x4;}' unless defined(&BNX_L2CTX_RX_HOST_BDIDX);
	eval 'sub BNX_L2CTX_RX_HOST_BSEQ () {0x8;}' unless defined(&BNX_L2CTX_RX_HOST_BSEQ);
	eval 'sub BNX_L2CTX_RX_NX_BSEQ () {0xc;}' unless defined(&BNX_L2CTX_RX_NX_BSEQ);
	eval 'sub BNX_L2CTX_RX_NX_BDHADDR_HI () {0x10;}' unless defined(&BNX_L2CTX_RX_NX_BDHADDR_HI);
	eval 'sub BNX_L2CTX_RX_NX_BDHADDR_LO () {0x14;}' unless defined(&BNX_L2CTX_RX_NX_BDHADDR_LO);
	eval 'sub BNX_L2CTX_RX_NX_BDIDX () {0x18;}' unless defined(&BNX_L2CTX_RX_NX_BDIDX);
	eval 'sub BNX_L2CTX_RX_HOST_PG_BDIDX () {0x44;}' unless defined(&BNX_L2CTX_RX_HOST_PG_BDIDX);
	eval 'sub BNX_L2CTX_RX_PG_BUF_SIZE () {0x48;}' unless defined(&BNX_L2CTX_RX_PG_BUF_SIZE);
	eval 'sub BNX_L2CTX_RX_RBDC_KEY () {0x4c;}' unless defined(&BNX_L2CTX_RX_RBDC_KEY);
	eval 'sub BNX_L2CTX_RX_RBDC_JUMBO_KEY () {0x3ffe;}' unless defined(&BNX_L2CTX_RX_RBDC_JUMBO_KEY);
	eval 'sub BNX_L2CTX_RX_NX_PG_BDHADDR_HI () {0x50;}' unless defined(&BNX_L2CTX_RX_NX_PG_BDHADDR_HI);
	eval 'sub BNX_L2CTX_RX_NX_PG_BDHADDR_LO () {0x54;}' unless defined(&BNX_L2CTX_RX_NX_PG_BDHADDR_LO);
	eval 'sub BNX_L2CTX_RX_NX_PG_BDIDX () {0x58;}' unless defined(&BNX_L2CTX_RX_NX_PG_BDIDX);
	eval 'sub BNX_PCICFG_MISC_CONFIG () {0x68;}' unless defined(&BNX_PCICFG_MISC_CONFIG);
	eval 'sub BNX_PCICFG_MISC_CONFIG_TARGET_BYTE_SWAP () {(1<<2);}' unless defined(&BNX_PCICFG_MISC_CONFIG_TARGET_BYTE_SWAP);
	eval 'sub BNX_PCICFG_MISC_CONFIG_TARGET_MB_WORD_SWAP () {(1<<3);}' unless defined(&BNX_PCICFG_MISC_CONFIG_TARGET_MB_WORD_SWAP);
	eval 'sub BNX_PCICFG_MISC_CONFIG_CLOCK_CTL_ENA () {(1<<5);}' unless defined(&BNX_PCICFG_MISC_CONFIG_CLOCK_CTL_ENA);
	eval 'sub BNX_PCICFG_MISC_CONFIG_TARGET_GRC_WORD_SWAP () {(1<<6);}' unless defined(&BNX_PCICFG_MISC_CONFIG_TARGET_GRC_WORD_SWAP);
	eval 'sub BNX_PCICFG_MISC_CONFIG_REG_WINDOW_ENA () {(1<<7);}' unless defined(&BNX_PCICFG_MISC_CONFIG_REG_WINDOW_ENA);
	eval 'sub BNX_PCICFG_MISC_CONFIG_CORE_RST_REQ () {(1<<8);}' unless defined(&BNX_PCICFG_MISC_CONFIG_CORE_RST_REQ);
	eval 'sub BNX_PCICFG_MISC_CONFIG_CORE_RST_BSY () {(1<<9);}' unless defined(&BNX_PCICFG_MISC_CONFIG_CORE_RST_BSY);
	eval 'sub BNX_PCICFG_MISC_CONFIG_ASIC_METAL_REV () {(0xff<<16);}' unless defined(&BNX_PCICFG_MISC_CONFIG_ASIC_METAL_REV);
	eval 'sub BNX_PCICFG_MISC_CONFIG_ASIC_BASE_REV () {(0xf<<24);}' unless defined(&BNX_PCICFG_MISC_CONFIG_ASIC_BASE_REV);
	eval 'sub BNX_PCICFG_MISC_CONFIG_ASIC_ID () {(0xf<<28);}' unless defined(&BNX_PCICFG_MISC_CONFIG_ASIC_ID);
	eval 'sub BNX_PCICFG_MISC_CONFIG_ASIC_REV () {(0xffff<<16);}' unless defined(&BNX_PCICFG_MISC_CONFIG_ASIC_REV);
	eval 'sub BNX_PCICFG_MISC_STATUS () {0x6c;}' unless defined(&BNX_PCICFG_MISC_STATUS);
	eval 'sub BNX_PCICFG_MISC_STATUS_INTA_VALUE () {(1<<0);}' unless defined(&BNX_PCICFG_MISC_STATUS_INTA_VALUE);
	eval 'sub BNX_PCICFG_MISC_STATUS_32BIT_DET () {(1<<1);}' unless defined(&BNX_PCICFG_MISC_STATUS_32BIT_DET);
	eval 'sub BNX_PCICFG_MISC_STATUS_M66EN () {(1<<2);}' unless defined(&BNX_PCICFG_MISC_STATUS_M66EN);
	eval 'sub BNX_PCICFG_MISC_STATUS_PCIX_DET () {(1<<3);}' unless defined(&BNX_PCICFG_MISC_STATUS_PCIX_DET);
	eval 'sub BNX_PCICFG_MISC_STATUS_PCIX_SPEED () {(0x3<<4);}' unless defined(&BNX_PCICFG_MISC_STATUS_PCIX_SPEED);
	eval 'sub BNX_PCICFG_MISC_STATUS_PCIX_SPEED_66 () {(0<<4);}' unless defined(&BNX_PCICFG_MISC_STATUS_PCIX_SPEED_66);
	eval 'sub BNX_PCICFG_MISC_STATUS_PCIX_SPEED_100 () {(1<<4);}' unless defined(&BNX_PCICFG_MISC_STATUS_PCIX_SPEED_100);
	eval 'sub BNX_PCICFG_MISC_STATUS_PCIX_SPEED_133 () {(2<<4);}' unless defined(&BNX_PCICFG_MISC_STATUS_PCIX_SPEED_133);
	eval 'sub BNX_PCICFG_MISC_STATUS_PCIX_SPEED_PCI_MODE () {(3<<4);}' unless defined(&BNX_PCICFG_MISC_STATUS_PCIX_SPEED_PCI_MODE);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS () {0x70;}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET () {(0xf<<0);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_32MHZ () {(0<<0);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_32MHZ);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_38MHZ () {(1<<0);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_38MHZ);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_48MHZ () {(2<<0);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_48MHZ);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_55MHZ () {(3<<0);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_55MHZ);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_66MHZ () {(4<<0);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_66MHZ);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_80MHZ () {(5<<0);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_80MHZ);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_95MHZ () {(6<<0);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_95MHZ);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_133MHZ () {(7<<0);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_133MHZ);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_LOW () {(0xf<<0);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_LOW);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_DISABLE () {(1<<6);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_DISABLE);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_ALT () {(1<<7);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_ALT);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC () {(0x7<<8);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_UNDEF () {(0<<8);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_UNDEF);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_12 () {(1<<8);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_12);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_6 () {(2<<8);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_6);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_62 () {(4<<8);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_62);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PLAY_DEAD () {(1<<11);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PLAY_DEAD);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED () {(0xf<<12);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_100 () {(0<<12);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_100);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_80 () {(1<<12);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_80);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_50 () {(2<<12);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_50);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_40 () {(4<<12);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_40);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_25 () {(8<<12);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_25);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_STOP () {(1<<16);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_CORE_CLK_PLL_STOP);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_PLL_STOP () {(1<<17);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_PCI_PLL_STOP);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_RESERVED_18 () {(1<<18);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_RESERVED_18);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_USE_SPD_DET () {(1<<19);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_USE_SPD_DET);
	eval 'sub BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_RESERVED () {(0xfff<<20);}' unless defined(&BNX_PCICFG_PCI_CLOCK_CONTROL_BITS_RESERVED);
	eval 'sub BNX_PCICFG_REG_WINDOW_ADDRESS () {0x78;}' unless defined(&BNX_PCICFG_REG_WINDOW_ADDRESS);
	eval 'sub BNX_PCICFG_REG_WINDOW () {0x80;}' unless defined(&BNX_PCICFG_REG_WINDOW);
	eval 'sub BNX_PCICFG_INT_ACK_CMD () {0x84;}' unless defined(&BNX_PCICFG_INT_ACK_CMD);
	eval 'sub BNX_PCICFG_INT_ACK_CMD_INDEX () {(0xffff<<0);}' unless defined(&BNX_PCICFG_INT_ACK_CMD_INDEX);
	eval 'sub BNX_PCICFG_INT_ACK_CMD_INDEX_VALID () {(1<<16);}' unless defined(&BNX_PCICFG_INT_ACK_CMD_INDEX_VALID);
	eval 'sub BNX_PCICFG_INT_ACK_CMD_USE_INT_HC_PARAM () {(1<<17);}' unless defined(&BNX_PCICFG_INT_ACK_CMD_USE_INT_HC_PARAM);
	eval 'sub BNX_PCICFG_INT_ACK_CMD_MASK_INT () {(1<<18);}' unless defined(&BNX_PCICFG_INT_ACK_CMD_MASK_INT);
	eval 'sub BNX_PCICFG_STATUS_BIT_SET_CMD () {0x88;}' unless defined(&BNX_PCICFG_STATUS_BIT_SET_CMD);
	eval 'sub BNX_PCICFG_STATUS_BIT_CLEAR_CMD () {0x8c;}' unless defined(&BNX_PCICFG_STATUS_BIT_CLEAR_CMD);
	eval 'sub BNX_PCICFG_MAILBOX_QUEUE_ADDR () {0x90;}' unless defined(&BNX_PCICFG_MAILBOX_QUEUE_ADDR);
	eval 'sub BNX_PCICFG_MAILBOX_QUEUE_DATA () {0x94;}' unless defined(&BNX_PCICFG_MAILBOX_QUEUE_DATA);
	eval 'sub BNX_PCI_GRC_WINDOW_ADDR () {0x400;}' unless defined(&BNX_PCI_GRC_WINDOW_ADDR);
	eval 'sub BNX_PCI_GRC_WINDOW_ADDR_PCI_GRC_WINDOW_ADDR_VALUE () {(0x3ffff<<8);}' unless defined(&BNX_PCI_GRC_WINDOW_ADDR_PCI_GRC_WINDOW_ADDR_VALUE);
	eval 'sub BNX_PCI_CONFIG_1 () {0x404;}' unless defined(&BNX_PCI_CONFIG_1);
	eval 'sub BNX_PCI_CONFIG_1_READ_BOUNDARY () {(0x7<<8);}' unless defined(&BNX_PCI_CONFIG_1_READ_BOUNDARY);
	eval 'sub BNX_PCI_CONFIG_1_READ_BOUNDARY_OFF () {(0<<8);}' unless defined(&BNX_PCI_CONFIG_1_READ_BOUNDARY_OFF);
	eval 'sub BNX_PCI_CONFIG_1_READ_BOUNDARY_16 () {(1<<8);}' unless defined(&BNX_PCI_CONFIG_1_READ_BOUNDARY_16);
	eval 'sub BNX_PCI_CONFIG_1_READ_BOUNDARY_32 () {(2<<8);}' unless defined(&BNX_PCI_CONFIG_1_READ_BOUNDARY_32);
	eval 'sub BNX_PCI_CONFIG_1_READ_BOUNDARY_64 () {(3<<8);}' unless defined(&BNX_PCI_CONFIG_1_READ_BOUNDARY_64);
	eval 'sub BNX_PCI_CONFIG_1_READ_BOUNDARY_128 () {(4<<8);}' unless defined(&BNX_PCI_CONFIG_1_READ_BOUNDARY_128);
	eval 'sub BNX_PCI_CONFIG_1_READ_BOUNDARY_256 () {(5<<8);}' unless defined(&BNX_PCI_CONFIG_1_READ_BOUNDARY_256);
	eval 'sub BNX_PCI_CONFIG_1_READ_BOUNDARY_512 () {(6<<8);}' unless defined(&BNX_PCI_CONFIG_1_READ_BOUNDARY_512);
	eval 'sub BNX_PCI_CONFIG_1_READ_BOUNDARY_1024 () {(7<<8);}' unless defined(&BNX_PCI_CONFIG_1_READ_BOUNDARY_1024);
	eval 'sub BNX_PCI_CONFIG_1_WRITE_BOUNDARY () {(0x7<<11);}' unless defined(&BNX_PCI_CONFIG_1_WRITE_BOUNDARY);
	eval 'sub BNX_PCI_CONFIG_1_WRITE_BOUNDARY_OFF () {(0<<11);}' unless defined(&BNX_PCI_CONFIG_1_WRITE_BOUNDARY_OFF);
	eval 'sub BNX_PCI_CONFIG_1_WRITE_BOUNDARY_16 () {(1<<11);}' unless defined(&BNX_PCI_CONFIG_1_WRITE_BOUNDARY_16);
	eval 'sub BNX_PCI_CONFIG_1_WRITE_BOUNDARY_32 () {(2<<11);}' unless defined(&BNX_PCI_CONFIG_1_WRITE_BOUNDARY_32);
	eval 'sub BNX_PCI_CONFIG_1_WRITE_BOUNDARY_64 () {(3<<11);}' unless defined(&BNX_PCI_CONFIG_1_WRITE_BOUNDARY_64);
	eval 'sub BNX_PCI_CONFIG_1_WRITE_BOUNDARY_128 () {(4<<11);}' unless defined(&BNX_PCI_CONFIG_1_WRITE_BOUNDARY_128);
	eval 'sub BNX_PCI_CONFIG_1_WRITE_BOUNDARY_256 () {(5<<11);}' unless defined(&BNX_PCI_CONFIG_1_WRITE_BOUNDARY_256);
	eval 'sub BNX_PCI_CONFIG_1_WRITE_BOUNDARY_512 () {(6<<11);}' unless defined(&BNX_PCI_CONFIG_1_WRITE_BOUNDARY_512);
	eval 'sub BNX_PCI_CONFIG_1_WRITE_BOUNDARY_1024 () {(7<<11);}' unless defined(&BNX_PCI_CONFIG_1_WRITE_BOUNDARY_1024);
	eval 'sub BNX_PCI_CONFIG_2 () {0x408;}' unless defined(&BNX_PCI_CONFIG_2);
	eval 'sub BNX_PCI_CONFIG_2_BAR1_SIZE () {(0xf<<0);}' unless defined(&BNX_PCI_CONFIG_2_BAR1_SIZE);
	eval 'sub BNX_PCI_CONFIG_2_BAR1_SIZE_DISABLED () {(0<<0);}' unless defined(&BNX_PCI_CONFIG_2_BAR1_SIZE_DISABLED);
	eval 'sub BNX_PCI_CONFIG_2_BAR1_SIZE_64K () {(1<<0);}' unless defined(&BNX_PCI_CONFIG_2_BAR1_SIZE_64K);
	eval 'sub BNX_PCI_CONFIG_2_BAR1_SIZE_128K () {(2<<0);}' unless defined(&BNX_PCI_CONFIG_2_BAR1_SIZE_128K);
	eval 'sub BNX_PCI_CONFIG_2_BAR1_SIZE_256K () {(3<<0);}' unless defined(&BNX_PCI_CONFIG_2_BAR1_SIZE_256K);
	eval 'sub BNX_PCI_CONFIG_2_BAR1_SIZE_512K () {(4<<0);}' unless defined(&BNX_PCI_CONFIG_2_BAR1_SIZE_512K);
	eval 'sub BNX_PCI_CONFIG_2_BAR1_SIZE_1M () {(5<<0);}' unless defined(&BNX_PCI_CONFIG_2_BAR1_SIZE_1M);
	eval 'sub BNX_PCI_CONFIG_2_BAR1_SIZE_2M () {(6<<0);}' unless defined(&BNX_PCI_CONFIG_2_BAR1_SIZE_2M);
	eval 'sub BNX_PCI_CONFIG_2_BAR1_SIZE_4M () {(7<<0);}' unless defined(&BNX_PCI_CONFIG_2_BAR1_SIZE_4M);
	eval 'sub BNX_PCI_CONFIG_2_BAR1_SIZE_8M () {(8<<0);}' unless defined(&BNX_PCI_CONFIG_2_BAR1_SIZE_8M);
	eval 'sub BNX_PCI_CONFIG_2_BAR1_SIZE_16M () {(9<<0);}' unless defined(&BNX_PCI_CONFIG_2_BAR1_SIZE_16M);
	eval 'sub BNX_PCI_CONFIG_2_BAR1_SIZE_32M () {(10<<0);}' unless defined(&BNX_PCI_CONFIG_2_BAR1_SIZE_32M);
	eval 'sub BNX_PCI_CONFIG_2_BAR1_SIZE_64M () {(11<<0);}' unless defined(&BNX_PCI_CONFIG_2_BAR1_SIZE_64M);
	eval 'sub BNX_PCI_CONFIG_2_BAR1_SIZE_128M () {(12<<0);}' unless defined(&BNX_PCI_CONFIG_2_BAR1_SIZE_128M);
	eval 'sub BNX_PCI_CONFIG_2_BAR1_SIZE_256M () {(13<<0);}' unless defined(&BNX_PCI_CONFIG_2_BAR1_SIZE_256M);
	eval 'sub BNX_PCI_CONFIG_2_BAR1_SIZE_512M () {(14<<0);}' unless defined(&BNX_PCI_CONFIG_2_BAR1_SIZE_512M);
	eval 'sub BNX_PCI_CONFIG_2_BAR1_SIZE_1G () {(15<<0);}' unless defined(&BNX_PCI_CONFIG_2_BAR1_SIZE_1G);
	eval 'sub BNX_PCI_CONFIG_2_BAR1_64ENA () {(1<<4);}' unless defined(&BNX_PCI_CONFIG_2_BAR1_64ENA);
	eval 'sub BNX_PCI_CONFIG_2_EXP_ROM_RETRY () {(1<<5);}' unless defined(&BNX_PCI_CONFIG_2_EXP_ROM_RETRY);
	eval 'sub BNX_PCI_CONFIG_2_CFG_CYCLE_RETRY () {(1<<6);}' unless defined(&BNX_PCI_CONFIG_2_CFG_CYCLE_RETRY);
	eval 'sub BNX_PCI_CONFIG_2_FIRST_CFG_DONE () {(1<<7);}' unless defined(&BNX_PCI_CONFIG_2_FIRST_CFG_DONE);
	eval 'sub BNX_PCI_CONFIG_2_EXP_ROM_SIZE () {(0xff<<8);}' unless defined(&BNX_PCI_CONFIG_2_EXP_ROM_SIZE);
	eval 'sub BNX_PCI_CONFIG_2_EXP_ROM_SIZE_DISABLED () {(0<<8);}' unless defined(&BNX_PCI_CONFIG_2_EXP_ROM_SIZE_DISABLED);
	eval 'sub BNX_PCI_CONFIG_2_EXP_ROM_SIZE_1K () {(1<<8);}' unless defined(&BNX_PCI_CONFIG_2_EXP_ROM_SIZE_1K);
	eval 'sub BNX_PCI_CONFIG_2_EXP_ROM_SIZE_2K () {(2<<8);}' unless defined(&BNX_PCI_CONFIG_2_EXP_ROM_SIZE_2K);
	eval 'sub BNX_PCI_CONFIG_2_EXP_ROM_SIZE_4K () {(3<<8);}' unless defined(&BNX_PCI_CONFIG_2_EXP_ROM_SIZE_4K);
	eval 'sub BNX_PCI_CONFIG_2_EXP_ROM_SIZE_8K () {(4<<8);}' unless defined(&BNX_PCI_CONFIG_2_EXP_ROM_SIZE_8K);
	eval 'sub BNX_PCI_CONFIG_2_EXP_ROM_SIZE_16K () {(5<<8);}' unless defined(&BNX_PCI_CONFIG_2_EXP_ROM_SIZE_16K);
	eval 'sub BNX_PCI_CONFIG_2_EXP_ROM_SIZE_32K () {(6<<8);}' unless defined(&BNX_PCI_CONFIG_2_EXP_ROM_SIZE_32K);
	eval 'sub BNX_PCI_CONFIG_2_EXP_ROM_SIZE_64K () {(7<<8);}' unless defined(&BNX_PCI_CONFIG_2_EXP_ROM_SIZE_64K);
	eval 'sub BNX_PCI_CONFIG_2_EXP_ROM_SIZE_128K () {(8<<8);}' unless defined(&BNX_PCI_CONFIG_2_EXP_ROM_SIZE_128K);
	eval 'sub BNX_PCI_CONFIG_2_EXP_ROM_SIZE_256K () {(9<<8);}' unless defined(&BNX_PCI_CONFIG_2_EXP_ROM_SIZE_256K);
	eval 'sub BNX_PCI_CONFIG_2_EXP_ROM_SIZE_512K () {(10<<8);}' unless defined(&BNX_PCI_CONFIG_2_EXP_ROM_SIZE_512K);
	eval 'sub BNX_PCI_CONFIG_2_EXP_ROM_SIZE_1M () {(11<<8);}' unless defined(&BNX_PCI_CONFIG_2_EXP_ROM_SIZE_1M);
	eval 'sub BNX_PCI_CONFIG_2_EXP_ROM_SIZE_2M () {(12<<8);}' unless defined(&BNX_PCI_CONFIG_2_EXP_ROM_SIZE_2M);
	eval 'sub BNX_PCI_CONFIG_2_EXP_ROM_SIZE_4M () {(13<<8);}' unless defined(&BNX_PCI_CONFIG_2_EXP_ROM_SIZE_4M);
	eval 'sub BNX_PCI_CONFIG_2_EXP_ROM_SIZE_8M () {(14<<8);}' unless defined(&BNX_PCI_CONFIG_2_EXP_ROM_SIZE_8M);
	eval 'sub BNX_PCI_CONFIG_2_EXP_ROM_SIZE_16M () {(15<<8);}' unless defined(&BNX_PCI_CONFIG_2_EXP_ROM_SIZE_16M);
	eval 'sub BNX_PCI_CONFIG_2_MAX_SPLIT_LIMIT () {(0x1f<<16);}' unless defined(&BNX_PCI_CONFIG_2_MAX_SPLIT_LIMIT);
	eval 'sub BNX_PCI_CONFIG_2_MAX_READ_LIMIT () {(0x3<<21);}' unless defined(&BNX_PCI_CONFIG_2_MAX_READ_LIMIT);
	eval 'sub BNX_PCI_CONFIG_2_MAX_READ_LIMIT_512 () {(0<<21);}' unless defined(&BNX_PCI_CONFIG_2_MAX_READ_LIMIT_512);
	eval 'sub BNX_PCI_CONFIG_2_MAX_READ_LIMIT_1K () {(1<<21);}' unless defined(&BNX_PCI_CONFIG_2_MAX_READ_LIMIT_1K);
	eval 'sub BNX_PCI_CONFIG_2_MAX_READ_LIMIT_2K () {(2<<21);}' unless defined(&BNX_PCI_CONFIG_2_MAX_READ_LIMIT_2K);
	eval 'sub BNX_PCI_CONFIG_2_MAX_READ_LIMIT_4K () {(3<<21);}' unless defined(&BNX_PCI_CONFIG_2_MAX_READ_LIMIT_4K);
	eval 'sub BNX_PCI_CONFIG_2_FORCE_32_BIT_MSTR () {(1<<23);}' unless defined(&BNX_PCI_CONFIG_2_FORCE_32_BIT_MSTR);
	eval 'sub BNX_PCI_CONFIG_2_FORCE_32_BIT_TGT () {(1<<24);}' unless defined(&BNX_PCI_CONFIG_2_FORCE_32_BIT_TGT);
	eval 'sub BNX_PCI_CONFIG_2_KEEP_REQ_ASSERT () {(1<<25);}' unless defined(&BNX_PCI_CONFIG_2_KEEP_REQ_ASSERT);
	eval 'sub BNX_PCI_CONFIG_3 () {0x40c;}' unless defined(&BNX_PCI_CONFIG_3);
	eval 'sub BNX_PCI_CONFIG_3_STICKY_BYTE () {(0xff<<0);}' unless defined(&BNX_PCI_CONFIG_3_STICKY_BYTE);
	eval 'sub BNX_PCI_CONFIG_3_FORCE_PME () {(1<<24);}' unless defined(&BNX_PCI_CONFIG_3_FORCE_PME);
	eval 'sub BNX_PCI_CONFIG_3_PME_STATUS () {(1<<25);}' unless defined(&BNX_PCI_CONFIG_3_PME_STATUS);
	eval 'sub BNX_PCI_CONFIG_3_PME_ENABLE () {(1<<26);}' unless defined(&BNX_PCI_CONFIG_3_PME_ENABLE);
	eval 'sub BNX_PCI_CONFIG_3_PM_STATE () {(0x3<<27);}' unless defined(&BNX_PCI_CONFIG_3_PM_STATE);
	eval 'sub BNX_PCI_CONFIG_3_VAUX_PRESET () {(1<<30);}' unless defined(&BNX_PCI_CONFIG_3_VAUX_PRESET);
	eval 'sub BNX_PCI_CONFIG_3_PCI_POWER () {(1<<31);}' unless defined(&BNX_PCI_CONFIG_3_PCI_POWER);
	eval 'sub BNX_PCI_PM_DATA_A () {0x410;}' unless defined(&BNX_PCI_PM_DATA_A);
	eval 'sub BNX_PCI_PM_DATA_A_PM_DATA_0_PRG () {(0xff<<0);}' unless defined(&BNX_PCI_PM_DATA_A_PM_DATA_0_PRG);
	eval 'sub BNX_PCI_PM_DATA_A_PM_DATA_1_PRG () {(0xff<<8);}' unless defined(&BNX_PCI_PM_DATA_A_PM_DATA_1_PRG);
	eval 'sub BNX_PCI_PM_DATA_A_PM_DATA_2_PRG () {(0xff<<16);}' unless defined(&BNX_PCI_PM_DATA_A_PM_DATA_2_PRG);
	eval 'sub BNX_PCI_PM_DATA_A_PM_DATA_3_PRG () {(0xff<<24);}' unless defined(&BNX_PCI_PM_DATA_A_PM_DATA_3_PRG);
	eval 'sub BNX_PCI_PM_DATA_B () {0x414;}' unless defined(&BNX_PCI_PM_DATA_B);
	eval 'sub BNX_PCI_PM_DATA_B_PM_DATA_4_PRG () {(0xff<<0);}' unless defined(&BNX_PCI_PM_DATA_B_PM_DATA_4_PRG);
	eval 'sub BNX_PCI_PM_DATA_B_PM_DATA_5_PRG () {(0xff<<8);}' unless defined(&BNX_PCI_PM_DATA_B_PM_DATA_5_PRG);
	eval 'sub BNX_PCI_PM_DATA_B_PM_DATA_6_PRG () {(0xff<<16);}' unless defined(&BNX_PCI_PM_DATA_B_PM_DATA_6_PRG);
	eval 'sub BNX_PCI_PM_DATA_B_PM_DATA_7_PRG () {(0xff<<24);}' unless defined(&BNX_PCI_PM_DATA_B_PM_DATA_7_PRG);
	eval 'sub BNX_PCI_SWAP_DIAG0 () {0x418;}' unless defined(&BNX_PCI_SWAP_DIAG0);
	eval 'sub BNX_PCI_SWAP_DIAG1 () {0x41c;}' unless defined(&BNX_PCI_SWAP_DIAG1);
	eval 'sub BNX_PCI_EXP_ROM_ADDR () {0x420;}' unless defined(&BNX_PCI_EXP_ROM_ADDR);
	eval 'sub BNX_PCI_EXP_ROM_ADDR_ADDRESS () {(0x3fffff<<2);}' unless defined(&BNX_PCI_EXP_ROM_ADDR_ADDRESS);
	eval 'sub BNX_PCI_EXP_ROM_ADDR_REQ () {(1<<31);}' unless defined(&BNX_PCI_EXP_ROM_ADDR_REQ);
	eval 'sub BNX_PCI_EXP_ROM_DATA () {0x424;}' unless defined(&BNX_PCI_EXP_ROM_DATA);
	eval 'sub BNX_PCI_VPD_INTF () {0x428;}' unless defined(&BNX_PCI_VPD_INTF);
	eval 'sub BNX_PCI_VPD_INTF_INTF_REQ () {(1<<0);}' unless defined(&BNX_PCI_VPD_INTF_INTF_REQ);
	eval 'sub BNX_PCI_VPD_ADDR_FLAG () {0x42c;}' unless defined(&BNX_PCI_VPD_ADDR_FLAG);
	eval 'sub BNX_PCI_VPD_ADDR_FLAG_ADDRESS () {(0x1fff<<2);}' unless defined(&BNX_PCI_VPD_ADDR_FLAG_ADDRESS);
	eval 'sub BNX_PCI_VPD_ADDR_FLAG_WR () {(1<<15);}' unless defined(&BNX_PCI_VPD_ADDR_FLAG_WR);
	eval 'sub BNX_PCI_VPD_DATA () {0x430;}' unless defined(&BNX_PCI_VPD_DATA);
	eval 'sub BNX_PCI_ID_VAL1 () {0x434;}' unless defined(&BNX_PCI_ID_VAL1);
	eval 'sub BNX_PCI_ID_VAL1_DEVICE_ID () {(0xffff<<0);}' unless defined(&BNX_PCI_ID_VAL1_DEVICE_ID);
	eval 'sub BNX_PCI_ID_VAL1_VENDOR_ID () {(0xffff<<16);}' unless defined(&BNX_PCI_ID_VAL1_VENDOR_ID);
	eval 'sub BNX_PCI_ID_VAL2 () {0x438;}' unless defined(&BNX_PCI_ID_VAL2);
	eval 'sub BNX_PCI_ID_VAL2_SUBSYSTEM_VENDOR_ID () {(0xffff<<0);}' unless defined(&BNX_PCI_ID_VAL2_SUBSYSTEM_VENDOR_ID);
	eval 'sub BNX_PCI_ID_VAL2_SUBSYSTEM_ID () {(0xffff<<16);}' unless defined(&BNX_PCI_ID_VAL2_SUBSYSTEM_ID);
	eval 'sub BNX_PCI_ID_VAL3 () {0x43c;}' unless defined(&BNX_PCI_ID_VAL3);
	eval 'sub BNX_PCI_ID_VAL3_CLASS_CODE () {(0xffffff<<0);}' unless defined(&BNX_PCI_ID_VAL3_CLASS_CODE);
	eval 'sub BNX_PCI_ID_VAL3_REVISION_ID () {(0xff<<24);}' unless defined(&BNX_PCI_ID_VAL3_REVISION_ID);
	eval 'sub BNX_PCI_ID_VAL4 () {0x440;}' unless defined(&BNX_PCI_ID_VAL4);
	eval 'sub BNX_PCI_ID_VAL4_CAP_ENA () {(0xf<<0);}' unless defined(&BNX_PCI_ID_VAL4_CAP_ENA);
	eval 'sub BNX_PCI_ID_VAL4_CAP_ENA_0 () {(0<<0);}' unless defined(&BNX_PCI_ID_VAL4_CAP_ENA_0);
	eval 'sub BNX_PCI_ID_VAL4_CAP_ENA_1 () {(1<<0);}' unless defined(&BNX_PCI_ID_VAL4_CAP_ENA_1);
	eval 'sub BNX_PCI_ID_VAL4_CAP_ENA_2 () {(2<<0);}' unless defined(&BNX_PCI_ID_VAL4_CAP_ENA_2);
	eval 'sub BNX_PCI_ID_VAL4_CAP_ENA_3 () {(3<<0);}' unless defined(&BNX_PCI_ID_VAL4_CAP_ENA_3);
	eval 'sub BNX_PCI_ID_VAL4_CAP_ENA_4 () {(4<<0);}' unless defined(&BNX_PCI_ID_VAL4_CAP_ENA_4);
	eval 'sub BNX_PCI_ID_VAL4_CAP_ENA_5 () {(5<<0);}' unless defined(&BNX_PCI_ID_VAL4_CAP_ENA_5);
	eval 'sub BNX_PCI_ID_VAL4_CAP_ENA_6 () {(6<<0);}' unless defined(&BNX_PCI_ID_VAL4_CAP_ENA_6);
	eval 'sub BNX_PCI_ID_VAL4_CAP_ENA_7 () {(7<<0);}' unless defined(&BNX_PCI_ID_VAL4_CAP_ENA_7);
	eval 'sub BNX_PCI_ID_VAL4_CAP_ENA_8 () {(8<<0);}' unless defined(&BNX_PCI_ID_VAL4_CAP_ENA_8);
	eval 'sub BNX_PCI_ID_VAL4_CAP_ENA_9 () {(9<<0);}' unless defined(&BNX_PCI_ID_VAL4_CAP_ENA_9);
	eval 'sub BNX_PCI_ID_VAL4_CAP_ENA_10 () {(10<<0);}' unless defined(&BNX_PCI_ID_VAL4_CAP_ENA_10);
	eval 'sub BNX_PCI_ID_VAL4_CAP_ENA_11 () {(11<<0);}' unless defined(&BNX_PCI_ID_VAL4_CAP_ENA_11);
	eval 'sub BNX_PCI_ID_VAL4_CAP_ENA_12 () {(12<<0);}' unless defined(&BNX_PCI_ID_VAL4_CAP_ENA_12);
	eval 'sub BNX_PCI_ID_VAL4_CAP_ENA_13 () {(13<<0);}' unless defined(&BNX_PCI_ID_VAL4_CAP_ENA_13);
	eval 'sub BNX_PCI_ID_VAL4_CAP_ENA_14 () {(14<<0);}' unless defined(&BNX_PCI_ID_VAL4_CAP_ENA_14);
	eval 'sub BNX_PCI_ID_VAL4_CAP_ENA_15 () {(15<<0);}' unless defined(&BNX_PCI_ID_VAL4_CAP_ENA_15);
	eval 'sub BNX_PCI_ID_VAL4_PM_SCALE_PRG () {(0x3<<6);}' unless defined(&BNX_PCI_ID_VAL4_PM_SCALE_PRG);
	eval 'sub BNX_PCI_ID_VAL4_PM_SCALE_PRG_0 () {(0<<6);}' unless defined(&BNX_PCI_ID_VAL4_PM_SCALE_PRG_0);
	eval 'sub BNX_PCI_ID_VAL4_PM_SCALE_PRG_1 () {(1<<6);}' unless defined(&BNX_PCI_ID_VAL4_PM_SCALE_PRG_1);
	eval 'sub BNX_PCI_ID_VAL4_PM_SCALE_PRG_2 () {(2<<6);}' unless defined(&BNX_PCI_ID_VAL4_PM_SCALE_PRG_2);
	eval 'sub BNX_PCI_ID_VAL4_PM_SCALE_PRG_3 () {(3<<6);}' unless defined(&BNX_PCI_ID_VAL4_PM_SCALE_PRG_3);
	eval 'sub BNX_PCI_ID_VAL4_MSI_LIMIT () {(0x7<<9);}' unless defined(&BNX_PCI_ID_VAL4_MSI_LIMIT);
	eval 'sub BNX_PCI_ID_VAL4_MSI_ADVERTIZE () {(0x7<<12);}' unless defined(&BNX_PCI_ID_VAL4_MSI_ADVERTIZE);
	eval 'sub BNX_PCI_ID_VAL4_MSI_ENABLE () {(1<<15);}' unless defined(&BNX_PCI_ID_VAL4_MSI_ENABLE);
	eval 'sub BNX_PCI_ID_VAL4_MAX_64_ADVERTIZE () {(1<<16);}' unless defined(&BNX_PCI_ID_VAL4_MAX_64_ADVERTIZE);
	eval 'sub BNX_PCI_ID_VAL4_MAX_133_ADVERTIZE () {(1<<17);}' unless defined(&BNX_PCI_ID_VAL4_MAX_133_ADVERTIZE);
	eval 'sub BNX_PCI_ID_VAL4_MAX_MEM_READ_SIZE () {(0x3<<21);}' unless defined(&BNX_PCI_ID_VAL4_MAX_MEM_READ_SIZE);
	eval 'sub BNX_PCI_ID_VAL4_MAX_SPLIT_SIZE () {(0x7<<23);}' unless defined(&BNX_PCI_ID_VAL4_MAX_SPLIT_SIZE);
	eval 'sub BNX_PCI_ID_VAL4_MAX_CUMULATIVE_SIZE () {(0x7<<26);}' unless defined(&BNX_PCI_ID_VAL4_MAX_CUMULATIVE_SIZE);
	eval 'sub BNX_PCI_ID_VAL5 () {0x444;}' unless defined(&BNX_PCI_ID_VAL5);
	eval 'sub BNX_PCI_ID_VAL5_D1_SUPPORT () {(1<<0);}' unless defined(&BNX_PCI_ID_VAL5_D1_SUPPORT);
	eval 'sub BNX_PCI_ID_VAL5_D2_SUPPORT () {(1<<1);}' unless defined(&BNX_PCI_ID_VAL5_D2_SUPPORT);
	eval 'sub BNX_PCI_ID_VAL5_PME_IN_D0 () {(1<<2);}' unless defined(&BNX_PCI_ID_VAL5_PME_IN_D0);
	eval 'sub BNX_PCI_ID_VAL5_PME_IN_D1 () {(1<<3);}' unless defined(&BNX_PCI_ID_VAL5_PME_IN_D1);
	eval 'sub BNX_PCI_ID_VAL5_PME_IN_D2 () {(1<<4);}' unless defined(&BNX_PCI_ID_VAL5_PME_IN_D2);
	eval 'sub BNX_PCI_ID_VAL5_PME_IN_D3_HOT () {(1<<5);}' unless defined(&BNX_PCI_ID_VAL5_PME_IN_D3_HOT);
	eval 'sub BNX_PCI_PCIX_EXTENDED_STATUS () {0x448;}' unless defined(&BNX_PCI_PCIX_EXTENDED_STATUS);
	eval 'sub BNX_PCI_PCIX_EXTENDED_STATUS_NO_SNOOP () {(1<<8);}' unless defined(&BNX_PCI_PCIX_EXTENDED_STATUS_NO_SNOOP);
	eval 'sub BNX_PCI_PCIX_EXTENDED_STATUS_LONG_BURST () {(1<<9);}' unless defined(&BNX_PCI_PCIX_EXTENDED_STATUS_LONG_BURST);
	eval 'sub BNX_PCI_PCIX_EXTENDED_STATUS_SPLIT_COMP_MSG_CLASS () {(0xf<<16);}' unless defined(&BNX_PCI_PCIX_EXTENDED_STATUS_SPLIT_COMP_MSG_CLASS);
	eval 'sub BNX_PCI_PCIX_EXTENDED_STATUS_SPLIT_COMP_MSG_IDX () {(0xff<<24);}' unless defined(&BNX_PCI_PCIX_EXTENDED_STATUS_SPLIT_COMP_MSG_IDX);
	eval 'sub BNX_PCI_ID_VAL6 () {0x44c;}' unless defined(&BNX_PCI_ID_VAL6);
	eval 'sub BNX_PCI_ID_VAL6_MAX_LAT () {(0xff<<0);}' unless defined(&BNX_PCI_ID_VAL6_MAX_LAT);
	eval 'sub BNX_PCI_ID_VAL6_MIN_GNT () {(0xff<<8);}' unless defined(&BNX_PCI_ID_VAL6_MIN_GNT);
	eval 'sub BNX_PCI_ID_VAL6_BIST () {(0xff<<16);}' unless defined(&BNX_PCI_ID_VAL6_BIST);
	eval 'sub BNX_PCI_MSI_DATA () {0x450;}' unless defined(&BNX_PCI_MSI_DATA);
	eval 'sub BNX_PCI_MSI_DATA_PCI_MSI_DATA () {(0xffff<<0);}' unless defined(&BNX_PCI_MSI_DATA_PCI_MSI_DATA);
	eval 'sub BNX_PCI_MSI_ADDR_H () {0x454;}' unless defined(&BNX_PCI_MSI_ADDR_H);
	eval 'sub BNX_PCI_MSI_ADDR_L () {0x458;}' unless defined(&BNX_PCI_MSI_ADDR_L);
	eval 'sub BNX_MISC_COMMAND () {0x800;}' unless defined(&BNX_MISC_COMMAND);
	eval 'sub BNX_MISC_COMMAND_ENABLE_ALL () {(1<<0);}' unless defined(&BNX_MISC_COMMAND_ENABLE_ALL);
	eval 'sub BNX_MISC_COMMAND_DISABLE_ALL () {(1<<1);}' unless defined(&BNX_MISC_COMMAND_DISABLE_ALL);
	eval 'sub BNX_MISC_COMMAND_SW_RESET () {(1<<4);}' unless defined(&BNX_MISC_COMMAND_SW_RESET);
	eval 'sub BNX_MISC_COMMAND_POR_RESET () {(1<<5);}' unless defined(&BNX_MISC_COMMAND_POR_RESET);
	eval 'sub BNX_MISC_COMMAND_HD_RESET () {(1<<6);}' unless defined(&BNX_MISC_COMMAND_HD_RESET);
	eval 'sub BNX_MISC_COMMAND_CMN_SW_RESET () {(1<<7);}' unless defined(&BNX_MISC_COMMAND_CMN_SW_RESET);
	eval 'sub BNX_MISC_COMMAND_PAR_ERROR () {(1<<8);}' unless defined(&BNX_MISC_COMMAND_PAR_ERROR);
	eval 'sub BNX_MISC_COMMAND_CS16_ERR () {(1<<9);}' unless defined(&BNX_MISC_COMMAND_CS16_ERR);
	eval 'sub BNX_MISC_COMMAND_CS16_ERR_LOC () {(0xf<<12);}' unless defined(&BNX_MISC_COMMAND_CS16_ERR_LOC);
	eval 'sub BNX_MISC_COMMAND_PAR_ERR_RAM () {(0x7f<<16);}' unless defined(&BNX_MISC_COMMAND_PAR_ERR_RAM);
	eval 'sub BNX_MISC_COMMAND_POWERDOWN_EVENT () {(1<<23);}' unless defined(&BNX_MISC_COMMAND_POWERDOWN_EVENT);
	eval 'sub BNX_MISC_COMMAND_SW_SHUTDOWN () {(1<<24);}' unless defined(&BNX_MISC_COMMAND_SW_SHUTDOWN);
	eval 'sub BNX_MISC_COMMAND_SHUTDOWN_EN () {(1<<25);}' unless defined(&BNX_MISC_COMMAND_SHUTDOWN_EN);
	eval 'sub BNX_MISC_COMMAND_DINTEG_ATTN_EN () {(1<<26);}' unless defined(&BNX_MISC_COMMAND_DINTEG_ATTN_EN);
	eval 'sub BNX_MISC_COMMAND_PCIE_LINK_IN_L23 () {(1<<27);}' unless defined(&BNX_MISC_COMMAND_PCIE_LINK_IN_L23);
	eval 'sub BNX_MISC_COMMAND_PCIE_DIS () {(1<<28);}' unless defined(&BNX_MISC_COMMAND_PCIE_DIS);
	eval 'sub BNX_MISC_CFG () {0x804;}' unless defined(&BNX_MISC_CFG);
	eval 'sub BNX_MISC_CFG_PCI_GRC_TMOUT () {(1<<0);}' unless defined(&BNX_MISC_CFG_PCI_GRC_TMOUT);
	eval 'sub BNX_MISC_CFG_NVM_WR_EN () {(0x3<<1);}' unless defined(&BNX_MISC_CFG_NVM_WR_EN);
	eval 'sub BNX_MISC_CFG_NVM_WR_EN_PROTECT () {(0<<1);}' unless defined(&BNX_MISC_CFG_NVM_WR_EN_PROTECT);
	eval 'sub BNX_MISC_CFG_NVM_WR_EN_PCI () {(1<<1);}' unless defined(&BNX_MISC_CFG_NVM_WR_EN_PCI);
	eval 'sub BNX_MISC_CFG_NVM_WR_EN_ALLOW () {(2<<1);}' unless defined(&BNX_MISC_CFG_NVM_WR_EN_ALLOW);
	eval 'sub BNX_MISC_CFG_NVM_WR_EN_ALLOW2 () {(3<<1);}' unless defined(&BNX_MISC_CFG_NVM_WR_EN_ALLOW2);
	eval 'sub BNX_MISC_CFG_BIST_EN () {(1<<3);}' unless defined(&BNX_MISC_CFG_BIST_EN);
	eval 'sub BNX_MISC_CFG_CK25_OUT_ALT_SRC () {(1<<4);}' unless defined(&BNX_MISC_CFG_CK25_OUT_ALT_SRC);
	eval 'sub BNX_MISC_CFG_BYPASS_BSCAN () {(1<<5);}' unless defined(&BNX_MISC_CFG_BYPASS_BSCAN);
	eval 'sub BNX_MISC_CFG_BYPASS_EJTAG () {(1<<6);}' unless defined(&BNX_MISC_CFG_BYPASS_EJTAG);
	eval 'sub BNX_MISC_CFG_CLK_CTL_OVERRIDE () {(1<<7);}' unless defined(&BNX_MISC_CFG_CLK_CTL_OVERRIDE);
	eval 'sub BNX_MISC_CFG_LEDMODE () {(0x3<<8);}' unless defined(&BNX_MISC_CFG_LEDMODE);
	eval 'sub BNX_MISC_CFG_LEDMODE_MAC () {(0<<8);}' unless defined(&BNX_MISC_CFG_LEDMODE_MAC);
	eval 'sub BNX_MISC_CFG_LEDMODE_GPHY1 () {(1<<8);}' unless defined(&BNX_MISC_CFG_LEDMODE_GPHY1);
	eval 'sub BNX_MISC_CFG_LEDMODE_GPHY2 () {(2<<8);}' unless defined(&BNX_MISC_CFG_LEDMODE_GPHY2);
	eval 'sub BNX_MISC_ID () {0x808;}' unless defined(&BNX_MISC_ID);
	eval 'sub BNX_MISC_ID_BOND_ID () {(0xf<<0);}' unless defined(&BNX_MISC_ID_BOND_ID);
	eval 'sub BNX_MISC_ID_CHIP_METAL () {(0xff<<4);}' unless defined(&BNX_MISC_ID_CHIP_METAL);
	eval 'sub BNX_MISC_ID_CHIP_REV () {(0xf<<12);}' unless defined(&BNX_MISC_ID_CHIP_REV);
	eval 'sub BNX_MISC_ID_CHIP_NUM () {(0xffff<<16);}' unless defined(&BNX_MISC_ID_CHIP_NUM);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS () {0x80c;}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_TX_SCHEDULER_ENABLE () {(1<<0);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_TX_SCHEDULER_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_TX_BD_READ_ENABLE () {(1<<1);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_TX_BD_READ_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_TX_BD_CACHE_ENABLE () {(1<<2);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_TX_BD_CACHE_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_TX_PROCESSOR_ENABLE () {(1<<3);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_TX_PROCESSOR_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_TX_DMA_ENABLE () {(1<<4);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_TX_DMA_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_TX_PATCHUP_ENABLE () {(1<<5);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_TX_PATCHUP_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_TX_PAYLOAD_Q_ENABLE () {(1<<6);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_TX_PAYLOAD_Q_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_TX_HEADER_Q_ENABLE () {(1<<7);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_TX_HEADER_Q_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_TX_ASSEMBLER_ENABLE () {(1<<8);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_TX_ASSEMBLER_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_EMAC_ENABLE () {(1<<9);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_EMAC_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_RX_PARSER_MAC_ENABLE () {(1<<10);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_RX_PARSER_MAC_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_RX_PARSER_CATCHUP_ENABLE () {(1<<11);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_RX_PARSER_CATCHUP_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_RX_MBUF_ENABLE () {(1<<12);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_RX_MBUF_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_RX_LOOKUP_ENABLE () {(1<<13);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_RX_LOOKUP_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_RX_PROCESSOR_ENABLE () {(1<<14);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_RX_PROCESSOR_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_RX_V2P_ENABLE () {(1<<15);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_RX_V2P_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_RX_BD_CACHE_ENABLE () {(1<<16);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_RX_BD_CACHE_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_RX_DMA_ENABLE () {(1<<17);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_RX_DMA_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_COMPLETION_ENABLE () {(1<<18);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_COMPLETION_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_HOST_COALESCE_ENABLE () {(1<<19);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_HOST_COALESCE_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_MAILBOX_QUEUE_ENABLE () {(1<<20);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_MAILBOX_QUEUE_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_CONTEXT_ENABLE () {(1<<21);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_CONTEXT_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_CMD_SCHEDULER_ENABLE () {(1<<22);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_CMD_SCHEDULER_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_CMD_PROCESSOR_ENABLE () {(1<<23);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_CMD_PROCESSOR_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_MGMT_PROCESSOR_ENABLE () {(1<<24);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_MGMT_PROCESSOR_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_TIMER_ENABLE () {(1<<25);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_TIMER_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_DMA_ENGINE_ENABLE () {(1<<26);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_DMA_ENGINE_ENABLE);
	eval 'sub BNX_MISC_ENABLE_STATUS_BITS_UMP_ENABLE () {(1<<27);}' unless defined(&BNX_MISC_ENABLE_STATUS_BITS_UMP_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS () {0x810;}' unless defined(&BNX_MISC_ENABLE_SET_BITS);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_TX_SCHEDULER_ENABLE () {(1<<0);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_TX_SCHEDULER_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_TX_BD_READ_ENABLE () {(1<<1);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_TX_BD_READ_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_TX_BD_CACHE_ENABLE () {(1<<2);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_TX_BD_CACHE_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_TX_PROCESSOR_ENABLE () {(1<<3);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_TX_PROCESSOR_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_TX_DMA_ENABLE () {(1<<4);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_TX_DMA_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_TX_PATCHUP_ENABLE () {(1<<5);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_TX_PATCHUP_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_TX_PAYLOAD_Q_ENABLE () {(1<<6);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_TX_PAYLOAD_Q_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_TX_HEADER_Q_ENABLE () {(1<<7);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_TX_HEADER_Q_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_TX_ASSEMBLER_ENABLE () {(1<<8);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_TX_ASSEMBLER_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_EMAC_ENABLE () {(1<<9);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_EMAC_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_RX_PARSER_MAC_ENABLE () {(1<<10);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_RX_PARSER_MAC_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_RX_PARSER_CATCHUP_ENABLE () {(1<<11);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_RX_PARSER_CATCHUP_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_RX_MBUF_ENABLE () {(1<<12);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_RX_MBUF_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_RX_LOOKUP_ENABLE () {(1<<13);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_RX_LOOKUP_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_RX_PROCESSOR_ENABLE () {(1<<14);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_RX_PROCESSOR_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_RX_V2P_ENABLE () {(1<<15);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_RX_V2P_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_RX_BD_CACHE_ENABLE () {(1<<16);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_RX_BD_CACHE_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_RX_DMA_ENABLE () {(1<<17);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_RX_DMA_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_COMPLETION_ENABLE () {(1<<18);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_COMPLETION_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_HOST_COALESCE_ENABLE () {(1<<19);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_HOST_COALESCE_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_MAILBOX_QUEUE_ENABLE () {(1<<20);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_MAILBOX_QUEUE_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_CONTEXT_ENABLE () {(1<<21);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_CONTEXT_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_CMD_SCHEDULER_ENABLE () {(1<<22);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_CMD_SCHEDULER_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_CMD_PROCESSOR_ENABLE () {(1<<23);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_CMD_PROCESSOR_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_MGMT_PROCESSOR_ENABLE () {(1<<24);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_MGMT_PROCESSOR_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_TIMER_ENABLE () {(1<<25);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_TIMER_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_DMA_ENGINE_ENABLE () {(1<<26);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_DMA_ENGINE_ENABLE);
	eval 'sub BNX_MISC_ENABLE_SET_BITS_UMP_ENABLE () {(1<<27);}' unless defined(&BNX_MISC_ENABLE_SET_BITS_UMP_ENABLE);
	eval 'sub BNX_MISC_ENABLE_DEFAULT () {0x5ffffff;}' unless defined(&BNX_MISC_ENABLE_DEFAULT);
	eval 'sub BNX_MISC_ENABLE_DEFAULT_XI () {0x17ffffff;}' unless defined(&BNX_MISC_ENABLE_DEFAULT_XI);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS () {0x814;}' unless defined(&BNX_MISC_ENABLE_CLR_BITS);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_TX_SCHEDULER_ENABLE () {(1<<0);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_TX_SCHEDULER_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_TX_BD_READ_ENABLE () {(1<<1);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_TX_BD_READ_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_TX_BD_CACHE_ENABLE () {(1<<2);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_TX_BD_CACHE_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_TX_PROCESSOR_ENABLE () {(1<<3);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_TX_PROCESSOR_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_TX_DMA_ENABLE () {(1<<4);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_TX_DMA_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_TX_PATCHUP_ENABLE () {(1<<5);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_TX_PATCHUP_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_TX_PAYLOAD_Q_ENABLE () {(1<<6);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_TX_PAYLOAD_Q_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_TX_HEADER_Q_ENABLE () {(1<<7);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_TX_HEADER_Q_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_TX_ASSEMBLER_ENABLE () {(1<<8);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_TX_ASSEMBLER_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_EMAC_ENABLE () {(1<<9);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_EMAC_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_RX_PARSER_MAC_ENABLE () {(1<<10);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_RX_PARSER_MAC_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_RX_PARSER_CATCHUP_ENABLE () {(1<<11);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_RX_PARSER_CATCHUP_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_RX_MBUF_ENABLE () {(1<<12);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_RX_MBUF_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_RX_LOOKUP_ENABLE () {(1<<13);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_RX_LOOKUP_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_RX_PROCESSOR_ENABLE () {(1<<14);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_RX_PROCESSOR_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_RX_V2P_ENABLE () {(1<<15);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_RX_V2P_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_RX_BD_CACHE_ENABLE () {(1<<16);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_RX_BD_CACHE_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_RX_DMA_ENABLE () {(1<<17);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_RX_DMA_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_COMPLETION_ENABLE () {(1<<18);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_COMPLETION_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_HOST_COALESCE_ENABLE () {(1<<19);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_HOST_COALESCE_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_MAILBOX_QUEUE_ENABLE () {(1<<20);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_MAILBOX_QUEUE_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_CONTEXT_ENABLE () {(1<<21);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_CONTEXT_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_CMD_SCHEDULER_ENABLE () {(1<<22);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_CMD_SCHEDULER_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_CMD_PROCESSOR_ENABLE () {(1<<23);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_CMD_PROCESSOR_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_MGMT_PROCESSOR_ENABLE () {(1<<24);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_MGMT_PROCESSOR_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_TIMER_ENABLE () {(1<<25);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_TIMER_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_DMA_ENGINE_ENABLE () {(1<<26);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_DMA_ENGINE_ENABLE);
	eval 'sub BNX_MISC_ENABLE_CLR_BITS_UMP_ENABLE () {(1<<27);}' unless defined(&BNX_MISC_ENABLE_CLR_BITS_UMP_ENABLE);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS () {0x818;}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET () {(0xf<<0);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_32MHZ () {(0<<0);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_32MHZ);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_38MHZ () {(1<<0);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_38MHZ);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_48MHZ () {(2<<0);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_48MHZ);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_55MHZ () {(3<<0);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_55MHZ);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_66MHZ () {(4<<0);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_66MHZ);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_80MHZ () {(5<<0);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_80MHZ);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_95MHZ () {(6<<0);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_95MHZ);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_133MHZ () {(7<<0);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_133MHZ);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_LOW () {(0xf<<0);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_PCI_CLK_SPD_DET_LOW);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_DISABLE () {(1<<6);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_DISABLE);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT () {(1<<7);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC () {(0x7<<8);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_UNDEF () {(0<<8);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_UNDEF);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_12 () {(1<<8);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_12);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_6 () {(2<<8);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_6);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_62 () {(4<<8);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_ALT_SRC_62);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_PLAY_DEAD () {(1<<11);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_PLAY_DEAD);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED () {(0xf<<12);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_100 () {(0<<12);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_100);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_80 () {(1<<12);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_80);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_50 () {(2<<12);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_50);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_40 () {(4<<12);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_40);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_25 () {(8<<12);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_SPEED_25);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_STOP () {(1<<16);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_CORE_CLK_PLL_STOP);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_PCI_PLL_STOP () {(1<<17);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_PCI_PLL_STOP);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_RESERVED_18 () {(1<<18);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_RESERVED_18);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_USE_SPD_DET () {(1<<19);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_USE_SPD_DET);
	eval 'sub BNX_MISC_CLOCK_CONTROL_BITS_RESERVED () {(0xfff<<20);}' unless defined(&BNX_MISC_CLOCK_CONTROL_BITS_RESERVED);
	eval 'sub BNX_MISC_GPIO () {0x81c;}' unless defined(&BNX_MISC_GPIO);
	eval 'sub BNX_MISC_GPIO_VALUE () {(0xff<<0);}' unless defined(&BNX_MISC_GPIO_VALUE);
	eval 'sub BNX_MISC_GPIO_SET () {(0xff<<8);}' unless defined(&BNX_MISC_GPIO_SET);
	eval 'sub BNX_MISC_GPIO_CLR () {(0xff<<16);}' unless defined(&BNX_MISC_GPIO_CLR);
	eval 'sub BNX_MISC_GPIO_FLOAT () {(0xff<<24);}' unless defined(&BNX_MISC_GPIO_FLOAT);
	eval 'sub BNX_MISC_GPIO_INT () {0x820;}' unless defined(&BNX_MISC_GPIO_INT);
	eval 'sub BNX_MISC_GPIO_INT_INT_STATE () {(0xf<<0);}' unless defined(&BNX_MISC_GPIO_INT_INT_STATE);
	eval 'sub BNX_MISC_GPIO_INT_OLD_VALUE () {(0xf<<8);}' unless defined(&BNX_MISC_GPIO_INT_OLD_VALUE);
	eval 'sub BNX_MISC_GPIO_INT_OLD_SET () {(0xf<<16);}' unless defined(&BNX_MISC_GPIO_INT_OLD_SET);
	eval 'sub BNX_MISC_GPIO_INT_OLD_CLR () {(0xf<<24);}' unless defined(&BNX_MISC_GPIO_INT_OLD_CLR);
	eval 'sub BNX_MISC_CONFIG_LFSR () {0x824;}' unless defined(&BNX_MISC_CONFIG_LFSR);
	eval 'sub BNX_MISC_CONFIG_LFSR_DIV () {(0xffff<<0);}' unless defined(&BNX_MISC_CONFIG_LFSR_DIV);
	eval 'sub BNX_MISC_LFSR_MASK_BITS () {0x828;}' unless defined(&BNX_MISC_LFSR_MASK_BITS);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_TX_SCHEDULER_ENABLE () {(1<<0);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_TX_SCHEDULER_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_TX_BD_READ_ENABLE () {(1<<1);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_TX_BD_READ_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_TX_BD_CACHE_ENABLE () {(1<<2);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_TX_BD_CACHE_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_TX_PROCESSOR_ENABLE () {(1<<3);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_TX_PROCESSOR_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_TX_DMA_ENABLE () {(1<<4);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_TX_DMA_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_TX_PATCHUP_ENABLE () {(1<<5);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_TX_PATCHUP_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_TX_PAYLOAD_Q_ENABLE () {(1<<6);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_TX_PAYLOAD_Q_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_TX_HEADER_Q_ENABLE () {(1<<7);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_TX_HEADER_Q_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_TX_ASSEMBLER_ENABLE () {(1<<8);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_TX_ASSEMBLER_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_EMAC_ENABLE () {(1<<9);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_EMAC_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_RX_PARSER_MAC_ENABLE () {(1<<10);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_RX_PARSER_MAC_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_RX_PARSER_CATCHUP_ENABLE () {(1<<11);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_RX_PARSER_CATCHUP_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_RX_MBUF_ENABLE () {(1<<12);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_RX_MBUF_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_RX_LOOKUP_ENABLE () {(1<<13);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_RX_LOOKUP_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_RX_PROCESSOR_ENABLE () {(1<<14);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_RX_PROCESSOR_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_RX_V2P_ENABLE () {(1<<15);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_RX_V2P_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_RX_BD_CACHE_ENABLE () {(1<<16);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_RX_BD_CACHE_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_RX_DMA_ENABLE () {(1<<17);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_RX_DMA_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_COMPLETION_ENABLE () {(1<<18);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_COMPLETION_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_HOST_COALESCE_ENABLE () {(1<<19);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_HOST_COALESCE_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_MAILBOX_QUEUE_ENABLE () {(1<<20);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_MAILBOX_QUEUE_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_CONTEXT_ENABLE () {(1<<21);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_CONTEXT_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_CMD_SCHEDULER_ENABLE () {(1<<22);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_CMD_SCHEDULER_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_CMD_PROCESSOR_ENABLE () {(1<<23);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_CMD_PROCESSOR_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_MGMT_PROCESSOR_ENABLE () {(1<<24);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_MGMT_PROCESSOR_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_TIMER_ENABLE () {(1<<25);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_TIMER_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_DMA_ENGINE_ENABLE () {(1<<26);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_DMA_ENGINE_ENABLE);
	eval 'sub BNX_MISC_LFSR_MASK_BITS_UMP_ENABLE () {(1<<27);}' unless defined(&BNX_MISC_LFSR_MASK_BITS_UMP_ENABLE);
	eval 'sub BNX_MISC_ARB_REQ0 () {0x82c;}' unless defined(&BNX_MISC_ARB_REQ0);
	eval 'sub BNX_MISC_ARB_REQ1 () {0x830;}' unless defined(&BNX_MISC_ARB_REQ1);
	eval 'sub BNX_MISC_ARB_REQ2 () {0x834;}' unless defined(&BNX_MISC_ARB_REQ2);
	eval 'sub BNX_MISC_ARB_REQ3 () {0x838;}' unless defined(&BNX_MISC_ARB_REQ3);
	eval 'sub BNX_MISC_ARB_REQ4 () {0x83c;}' unless defined(&BNX_MISC_ARB_REQ4);
	eval 'sub BNX_MISC_ARB_FREE0 () {0x840;}' unless defined(&BNX_MISC_ARB_FREE0);
	eval 'sub BNX_MISC_ARB_FREE1 () {0x844;}' unless defined(&BNX_MISC_ARB_FREE1);
	eval 'sub BNX_MISC_ARB_FREE2 () {0x848;}' unless defined(&BNX_MISC_ARB_FREE2);
	eval 'sub BNX_MISC_ARB_FREE3 () {0x84c;}' unless defined(&BNX_MISC_ARB_FREE3);
	eval 'sub BNX_MISC_ARB_FREE4 () {0x850;}' unless defined(&BNX_MISC_ARB_FREE4);
	eval 'sub BNX_MISC_ARB_REQ_STATUS0 () {0x854;}' unless defined(&BNX_MISC_ARB_REQ_STATUS0);
	eval 'sub BNX_MISC_ARB_REQ_STATUS1 () {0x858;}' unless defined(&BNX_MISC_ARB_REQ_STATUS1);
	eval 'sub BNX_MISC_ARB_REQ_STATUS2 () {0x85c;}' unless defined(&BNX_MISC_ARB_REQ_STATUS2);
	eval 'sub BNX_MISC_ARB_REQ_STATUS3 () {0x860;}' unless defined(&BNX_MISC_ARB_REQ_STATUS3);
	eval 'sub BNX_MISC_ARB_REQ_STATUS4 () {0x864;}' unless defined(&BNX_MISC_ARB_REQ_STATUS4);
	eval 'sub BNX_MISC_ARB_GNT0 () {0x868;}' unless defined(&BNX_MISC_ARB_GNT0);
	eval 'sub BNX_MISC_ARB_GNT0_0 () {(0x7<<0);}' unless defined(&BNX_MISC_ARB_GNT0_0);
	eval 'sub BNX_MISC_ARB_GNT0_1 () {(0x7<<4);}' unless defined(&BNX_MISC_ARB_GNT0_1);
	eval 'sub BNX_MISC_ARB_GNT0_2 () {(0x7<<8);}' unless defined(&BNX_MISC_ARB_GNT0_2);
	eval 'sub BNX_MISC_ARB_GNT0_3 () {(0x7<<12);}' unless defined(&BNX_MISC_ARB_GNT0_3);
	eval 'sub BNX_MISC_ARB_GNT0_4 () {(0x7<<16);}' unless defined(&BNX_MISC_ARB_GNT0_4);
	eval 'sub BNX_MISC_ARB_GNT0_5 () {(0x7<<20);}' unless defined(&BNX_MISC_ARB_GNT0_5);
	eval 'sub BNX_MISC_ARB_GNT0_6 () {(0x7<<24);}' unless defined(&BNX_MISC_ARB_GNT0_6);
	eval 'sub BNX_MISC_ARB_GNT0_7 () {(0x7<<28);}' unless defined(&BNX_MISC_ARB_GNT0_7);
	eval 'sub BNX_MISC_ARB_GNT1 () {0x86c;}' unless defined(&BNX_MISC_ARB_GNT1);
	eval 'sub BNX_MISC_ARB_GNT1_8 () {(0x7<<0);}' unless defined(&BNX_MISC_ARB_GNT1_8);
	eval 'sub BNX_MISC_ARB_GNT1_9 () {(0x7<<4);}' unless defined(&BNX_MISC_ARB_GNT1_9);
	eval 'sub BNX_MISC_ARB_GNT1_10 () {(0x7<<8);}' unless defined(&BNX_MISC_ARB_GNT1_10);
	eval 'sub BNX_MISC_ARB_GNT1_11 () {(0x7<<12);}' unless defined(&BNX_MISC_ARB_GNT1_11);
	eval 'sub BNX_MISC_ARB_GNT1_12 () {(0x7<<16);}' unless defined(&BNX_MISC_ARB_GNT1_12);
	eval 'sub BNX_MISC_ARB_GNT1_13 () {(0x7<<20);}' unless defined(&BNX_MISC_ARB_GNT1_13);
	eval 'sub BNX_MISC_ARB_GNT1_14 () {(0x7<<24);}' unless defined(&BNX_MISC_ARB_GNT1_14);
	eval 'sub BNX_MISC_ARB_GNT1_15 () {(0x7<<28);}' unless defined(&BNX_MISC_ARB_GNT1_15);
	eval 'sub BNX_MISC_ARB_GNT2 () {0x870;}' unless defined(&BNX_MISC_ARB_GNT2);
	eval 'sub BNX_MISC_ARB_GNT2_16 () {(0x7<<0);}' unless defined(&BNX_MISC_ARB_GNT2_16);
	eval 'sub BNX_MISC_ARB_GNT2_17 () {(0x7<<4);}' unless defined(&BNX_MISC_ARB_GNT2_17);
	eval 'sub BNX_MISC_ARB_GNT2_18 () {(0x7<<8);}' unless defined(&BNX_MISC_ARB_GNT2_18);
	eval 'sub BNX_MISC_ARB_GNT2_19 () {(0x7<<12);}' unless defined(&BNX_MISC_ARB_GNT2_19);
	eval 'sub BNX_MISC_ARB_GNT2_20 () {(0x7<<16);}' unless defined(&BNX_MISC_ARB_GNT2_20);
	eval 'sub BNX_MISC_ARB_GNT2_21 () {(0x7<<20);}' unless defined(&BNX_MISC_ARB_GNT2_21);
	eval 'sub BNX_MISC_ARB_GNT2_22 () {(0x7<<24);}' unless defined(&BNX_MISC_ARB_GNT2_22);
	eval 'sub BNX_MISC_ARB_GNT2_23 () {(0x7<<28);}' unless defined(&BNX_MISC_ARB_GNT2_23);
	eval 'sub BNX_MISC_ARB_GNT3 () {0x874;}' unless defined(&BNX_MISC_ARB_GNT3);
	eval 'sub BNX_MISC_ARB_GNT3_24 () {(0x7<<0);}' unless defined(&BNX_MISC_ARB_GNT3_24);
	eval 'sub BNX_MISC_ARB_GNT3_25 () {(0x7<<4);}' unless defined(&BNX_MISC_ARB_GNT3_25);
	eval 'sub BNX_MISC_ARB_GNT3_26 () {(0x7<<8);}' unless defined(&BNX_MISC_ARB_GNT3_26);
	eval 'sub BNX_MISC_ARB_GNT3_27 () {(0x7<<12);}' unless defined(&BNX_MISC_ARB_GNT3_27);
	eval 'sub BNX_MISC_ARB_GNT3_28 () {(0x7<<16);}' unless defined(&BNX_MISC_ARB_GNT3_28);
	eval 'sub BNX_MISC_ARB_GNT3_29 () {(0x7<<20);}' unless defined(&BNX_MISC_ARB_GNT3_29);
	eval 'sub BNX_MISC_ARB_GNT3_30 () {(0x7<<24);}' unless defined(&BNX_MISC_ARB_GNT3_30);
	eval 'sub BNX_MISC_ARB_GNT3_31 () {(0x7<<28);}' unless defined(&BNX_MISC_ARB_GNT3_31);
	eval 'sub BNX_MISC_PRBS_CONTROL () {0x878;}' unless defined(&BNX_MISC_PRBS_CONTROL);
	eval 'sub BNX_MISC_PRBS_CONTROL_EN () {(1<<0);}' unless defined(&BNX_MISC_PRBS_CONTROL_EN);
	eval 'sub BNX_MISC_PRBS_CONTROL_RSTB () {(1<<1);}' unless defined(&BNX_MISC_PRBS_CONTROL_RSTB);
	eval 'sub BNX_MISC_PRBS_CONTROL_INV () {(1<<2);}' unless defined(&BNX_MISC_PRBS_CONTROL_INV);
	eval 'sub BNX_MISC_PRBS_CONTROL_ERR_CLR () {(1<<3);}' unless defined(&BNX_MISC_PRBS_CONTROL_ERR_CLR);
	eval 'sub BNX_MISC_PRBS_CONTROL_ORDER () {(0x3<<4);}' unless defined(&BNX_MISC_PRBS_CONTROL_ORDER);
	eval 'sub BNX_MISC_PRBS_CONTROL_ORDER_7TH () {(0<<4);}' unless defined(&BNX_MISC_PRBS_CONTROL_ORDER_7TH);
	eval 'sub BNX_MISC_PRBS_CONTROL_ORDER_15TH () {(1<<4);}' unless defined(&BNX_MISC_PRBS_CONTROL_ORDER_15TH);
	eval 'sub BNX_MISC_PRBS_CONTROL_ORDER_23RD () {(2<<4);}' unless defined(&BNX_MISC_PRBS_CONTROL_ORDER_23RD);
	eval 'sub BNX_MISC_PRBS_CONTROL_ORDER_31ST () {(3<<4);}' unless defined(&BNX_MISC_PRBS_CONTROL_ORDER_31ST);
	eval 'sub BNX_MISC_PRBS_STATUS () {0x87c;}' unless defined(&BNX_MISC_PRBS_STATUS);
	eval 'sub BNX_MISC_PRBS_STATUS_LOCK () {(1<<0);}' unless defined(&BNX_MISC_PRBS_STATUS_LOCK);
	eval 'sub BNX_MISC_PRBS_STATUS_STKY () {(1<<1);}' unless defined(&BNX_MISC_PRBS_STATUS_STKY);
	eval 'sub BNX_MISC_PRBS_STATUS_ERRORS () {(0x3fff<<2);}' unless defined(&BNX_MISC_PRBS_STATUS_ERRORS);
	eval 'sub BNX_MISC_PRBS_STATUS_STATE () {(0xf<<16);}' unless defined(&BNX_MISC_PRBS_STATUS_STATE);
	eval 'sub BNX_MISC_SM_ASF_CONTROL () {0x880;}' unless defined(&BNX_MISC_SM_ASF_CONTROL);
	eval 'sub BNX_MISC_SM_ASF_CONTROL_ASF_RST () {(1<<0);}' unless defined(&BNX_MISC_SM_ASF_CONTROL_ASF_RST);
	eval 'sub BNX_MISC_SM_ASF_CONTROL_TSC_EN () {(1<<1);}' unless defined(&BNX_MISC_SM_ASF_CONTROL_TSC_EN);
	eval 'sub BNX_MISC_SM_ASF_CONTROL_WG_TO () {(1<<2);}' unless defined(&BNX_MISC_SM_ASF_CONTROL_WG_TO);
	eval 'sub BNX_MISC_SM_ASF_CONTROL_HB_TO () {(1<<3);}' unless defined(&BNX_MISC_SM_ASF_CONTROL_HB_TO);
	eval 'sub BNX_MISC_SM_ASF_CONTROL_PA_TO () {(1<<4);}' unless defined(&BNX_MISC_SM_ASF_CONTROL_PA_TO);
	eval 'sub BNX_MISC_SM_ASF_CONTROL_PL_TO () {(1<<5);}' unless defined(&BNX_MISC_SM_ASF_CONTROL_PL_TO);
	eval 'sub BNX_MISC_SM_ASF_CONTROL_RT_TO () {(1<<6);}' unless defined(&BNX_MISC_SM_ASF_CONTROL_RT_TO);
	eval 'sub BNX_MISC_SM_ASF_CONTROL_SMB_EVENT () {(1<<7);}' unless defined(&BNX_MISC_SM_ASF_CONTROL_SMB_EVENT);
	eval 'sub BNX_MISC_SM_ASF_CONTROL_RES () {(0xf<<8);}' unless defined(&BNX_MISC_SM_ASF_CONTROL_RES);
	eval 'sub BNX_MISC_SM_ASF_CONTROL_SMB_EN () {(1<<12);}' unless defined(&BNX_MISC_SM_ASF_CONTROL_SMB_EN);
	eval 'sub BNX_MISC_SM_ASF_CONTROL_SMB_BB_EN () {(1<<13);}' unless defined(&BNX_MISC_SM_ASF_CONTROL_SMB_BB_EN);
	eval 'sub BNX_MISC_SM_ASF_CONTROL_SMB_NO_ADDR_FILT () {(1<<14);}' unless defined(&BNX_MISC_SM_ASF_CONTROL_SMB_NO_ADDR_FILT);
	eval 'sub BNX_MISC_SM_ASF_CONTROL_SMB_AUTOREAD () {(1<<15);}' unless defined(&BNX_MISC_SM_ASF_CONTROL_SMB_AUTOREAD);
	eval 'sub BNX_MISC_SM_ASF_CONTROL_NIC_SMB_ADDR1 () {(0x3f<<16);}' unless defined(&BNX_MISC_SM_ASF_CONTROL_NIC_SMB_ADDR1);
	eval 'sub BNX_MISC_SM_ASF_CONTROL_NIC_SMB_ADDR2 () {(0x3f<<24);}' unless defined(&BNX_MISC_SM_ASF_CONTROL_NIC_SMB_ADDR2);
	eval 'sub BNX_MISC_SM_ASF_CONTROL_EN_NIC_SMB_ADDR_0 () {(1<<30);}' unless defined(&BNX_MISC_SM_ASF_CONTROL_EN_NIC_SMB_ADDR_0);
	eval 'sub BNX_MISC_SM_ASF_CONTROL_SMB_EARLY_ATTN () {(1<<31);}' unless defined(&BNX_MISC_SM_ASF_CONTROL_SMB_EARLY_ATTN);
	eval 'sub BNX_MISC_SMB_IN () {0x884;}' unless defined(&BNX_MISC_SMB_IN);
	eval 'sub BNX_MISC_SMB_IN_DAT_IN () {(0xff<<0);}' unless defined(&BNX_MISC_SMB_IN_DAT_IN);
	eval 'sub BNX_MISC_SMB_IN_RDY () {(1<<8);}' unless defined(&BNX_MISC_SMB_IN_RDY);
	eval 'sub BNX_MISC_SMB_IN_DONE () {(1<<9);}' unless defined(&BNX_MISC_SMB_IN_DONE);
	eval 'sub BNX_MISC_SMB_IN_FIRSTBYTE () {(1<<10);}' unless defined(&BNX_MISC_SMB_IN_FIRSTBYTE);
	eval 'sub BNX_MISC_SMB_IN_STATUS () {(0x7<<11);}' unless defined(&BNX_MISC_SMB_IN_STATUS);
	eval 'sub BNX_MISC_SMB_IN_STATUS_OK () {(0x<<11);}' unless defined(&BNX_MISC_SMB_IN_STATUS_OK);
	eval 'sub BNX_MISC_SMB_IN_STATUS_PEC () {(0x1<<11);}' unless defined(&BNX_MISC_SMB_IN_STATUS_PEC);
	eval 'sub BNX_MISC_SMB_IN_STATUS_OFLOW () {(0x2<<11);}' unless defined(&BNX_MISC_SMB_IN_STATUS_OFLOW);
	eval 'sub BNX_MISC_SMB_IN_STATUS_STOP () {(0x3<<11);}' unless defined(&BNX_MISC_SMB_IN_STATUS_STOP);
	eval 'sub BNX_MISC_SMB_IN_STATUS_TIMEOUT () {(0x4<<11);}' unless defined(&BNX_MISC_SMB_IN_STATUS_TIMEOUT);
	eval 'sub BNX_MISC_SMB_OUT () {0x888;}' unless defined(&BNX_MISC_SMB_OUT);
	eval 'sub BNX_MISC_SMB_OUT_DAT_OUT () {(0xff<<0);}' unless defined(&BNX_MISC_SMB_OUT_DAT_OUT);
	eval 'sub BNX_MISC_SMB_OUT_RDY () {(1<<8);}' unless defined(&BNX_MISC_SMB_OUT_RDY);
	eval 'sub BNX_MISC_SMB_OUT_START () {(1<<9);}' unless defined(&BNX_MISC_SMB_OUT_START);
	eval 'sub BNX_MISC_SMB_OUT_LAST () {(1<<10);}' unless defined(&BNX_MISC_SMB_OUT_LAST);
	eval 'sub BNX_MISC_SMB_OUT_ACC_TYPE () {(1<<11);}' unless defined(&BNX_MISC_SMB_OUT_ACC_TYPE);
	eval 'sub BNX_MISC_SMB_OUT_ENB_PEC () {(1<<12);}' unless defined(&BNX_MISC_SMB_OUT_ENB_PEC);
	eval 'sub BNX_MISC_SMB_OUT_GET_RX_LEN () {(1<<13);}' unless defined(&BNX_MISC_SMB_OUT_GET_RX_LEN);
	eval 'sub BNX_MISC_SMB_OUT_SMB_READ_LEN () {(0x3f<<14);}' unless defined(&BNX_MISC_SMB_OUT_SMB_READ_LEN);
	eval 'sub BNX_MISC_SMB_OUT_SMB_OUT_STATUS () {(0xf<<20);}' unless defined(&BNX_MISC_SMB_OUT_SMB_OUT_STATUS);
	eval 'sub BNX_MISC_SMB_OUT_SMB_OUT_STATUS_OK () {(0<<20);}' unless defined(&BNX_MISC_SMB_OUT_SMB_OUT_STATUS_OK);
	eval 'sub BNX_MISC_SMB_OUT_SMB_OUT_STATUS_FIRST_NACK () {(1<<20);}' unless defined(&BNX_MISC_SMB_OUT_SMB_OUT_STATUS_FIRST_NACK);
	eval 'sub BNX_MISC_SMB_OUT_SMB_OUT_STATUS_SUB_NACK () {(9<<20);}' unless defined(&BNX_MISC_SMB_OUT_SMB_OUT_STATUS_SUB_NACK);
	eval 'sub BNX_MISC_SMB_OUT_SMB_OUT_STATUS_UFLOW () {(2<<20);}' unless defined(&BNX_MISC_SMB_OUT_SMB_OUT_STATUS_UFLOW);
	eval 'sub BNX_MISC_SMB_OUT_SMB_OUT_STATUS_STOP () {(3<<20);}' unless defined(&BNX_MISC_SMB_OUT_SMB_OUT_STATUS_STOP);
	eval 'sub BNX_MISC_SMB_OUT_SMB_OUT_STATUS_TIMEOUT () {(4<<20);}' unless defined(&BNX_MISC_SMB_OUT_SMB_OUT_STATUS_TIMEOUT);
	eval 'sub BNX_MISC_SMB_OUT_SMB_OUT_STATUS_FIRST_LOST () {(5<<20);}' unless defined(&BNX_MISC_SMB_OUT_SMB_OUT_STATUS_FIRST_LOST);
	eval 'sub BNX_MISC_SMB_OUT_SMB_OUT_STATUS_SUB_LOST () {(0xd<<20);}' unless defined(&BNX_MISC_SMB_OUT_SMB_OUT_STATUS_SUB_LOST);
	eval 'sub BNX_MISC_SMB_OUT_SMB_OUT_STATUS_BADACK () {(0x6<<20);}' unless defined(&BNX_MISC_SMB_OUT_SMB_OUT_STATUS_BADACK);
	eval 'sub BNX_MISC_SMB_OUT_SMB_OUT_SLAVEMODE () {(1<<24);}' unless defined(&BNX_MISC_SMB_OUT_SMB_OUT_SLAVEMODE);
	eval 'sub BNX_MISC_SMB_OUT_SMB_OUT_DAT_EN () {(1<<25);}' unless defined(&BNX_MISC_SMB_OUT_SMB_OUT_DAT_EN);
	eval 'sub BNX_MISC_SMB_OUT_SMB_OUT_DAT_IN () {(1<<26);}' unless defined(&BNX_MISC_SMB_OUT_SMB_OUT_DAT_IN);
	eval 'sub BNX_MISC_SMB_OUT_SMB_OUT_CLK_EN () {(1<<27);}' unless defined(&BNX_MISC_SMB_OUT_SMB_OUT_CLK_EN);
	eval 'sub BNX_MISC_SMB_OUT_SMB_OUT_CLK_IN () {(1<<28);}' unless defined(&BNX_MISC_SMB_OUT_SMB_OUT_CLK_IN);
	eval 'sub BNX_MISC_SMB_WATCHDOG () {0x88c;}' unless defined(&BNX_MISC_SMB_WATCHDOG);
	eval 'sub BNX_MISC_SMB_WATCHDOG_WATCHDOG () {(0xffff<<0);}' unless defined(&BNX_MISC_SMB_WATCHDOG_WATCHDOG);
	eval 'sub BNX_MISC_SMB_HEARTBEAT () {0x890;}' unless defined(&BNX_MISC_SMB_HEARTBEAT);
	eval 'sub BNX_MISC_SMB_HEARTBEAT_HEARTBEAT () {(0xffff<<0);}' unless defined(&BNX_MISC_SMB_HEARTBEAT_HEARTBEAT);
	eval 'sub BNX_MISC_SMB_POLL_ASF () {0x894;}' unless defined(&BNX_MISC_SMB_POLL_ASF);
	eval 'sub BNX_MISC_SMB_POLL_ASF_POLL_ASF () {(0xffff<<0);}' unless defined(&BNX_MISC_SMB_POLL_ASF_POLL_ASF);
	eval 'sub BNX_MISC_SMB_POLL_LEGACY () {0x898;}' unless defined(&BNX_MISC_SMB_POLL_LEGACY);
	eval 'sub BNX_MISC_SMB_POLL_LEGACY_POLL_LEGACY () {(0xffff<<0);}' unless defined(&BNX_MISC_SMB_POLL_LEGACY_POLL_LEGACY);
	eval 'sub BNX_MISC_SMB_RETRAN () {0x89c;}' unless defined(&BNX_MISC_SMB_RETRAN);
	eval 'sub BNX_MISC_SMB_RETRAN_RETRAN () {(0xff<<0);}' unless defined(&BNX_MISC_SMB_RETRAN_RETRAN);
	eval 'sub BNX_MISC_SMB_TIMESTAMP () {0x8a0;}' unless defined(&BNX_MISC_SMB_TIMESTAMP);
	eval 'sub BNX_MISC_SMB_TIMESTAMP_TIMESTAMP () {(0xffffffff<<0);}' unless defined(&BNX_MISC_SMB_TIMESTAMP_TIMESTAMP);
	eval 'sub BNX_MISC_PERR_ENA0 () {0x8a4;}' unless defined(&BNX_MISC_PERR_ENA0);
	eval 'sub BNX_MISC_PERR_ENA0_COM_MISC_CTXC () {(1<<0);}' unless defined(&BNX_MISC_PERR_ENA0_COM_MISC_CTXC);
	eval 'sub BNX_MISC_PERR_ENA0_COM_MISC_REGF () {(1<<1);}' unless defined(&BNX_MISC_PERR_ENA0_COM_MISC_REGF);
	eval 'sub BNX_MISC_PERR_ENA0_COM_MISC_SCPAD () {(1<<2);}' unless defined(&BNX_MISC_PERR_ENA0_COM_MISC_SCPAD);
	eval 'sub BNX_MISC_PERR_ENA0_CP_MISC_CTXC () {(1<<3);}' unless defined(&BNX_MISC_PERR_ENA0_CP_MISC_CTXC);
	eval 'sub BNX_MISC_PERR_ENA0_CP_MISC_REGF () {(1<<4);}' unless defined(&BNX_MISC_PERR_ENA0_CP_MISC_REGF);
	eval 'sub BNX_MISC_PERR_ENA0_CP_MISC_SCPAD () {(1<<5);}' unless defined(&BNX_MISC_PERR_ENA0_CP_MISC_SCPAD);
	eval 'sub BNX_MISC_PERR_ENA0_CS_MISC_TMEM () {(1<<6);}' unless defined(&BNX_MISC_PERR_ENA0_CS_MISC_TMEM);
	eval 'sub BNX_MISC_PERR_ENA0_CTX_MISC_ACCM0 () {(1<<7);}' unless defined(&BNX_MISC_PERR_ENA0_CTX_MISC_ACCM0);
	eval 'sub BNX_MISC_PERR_ENA0_CTX_MISC_ACCM1 () {(1<<8);}' unless defined(&BNX_MISC_PERR_ENA0_CTX_MISC_ACCM1);
	eval 'sub BNX_MISC_PERR_ENA0_CTX_MISC_ACCM2 () {(1<<9);}' unless defined(&BNX_MISC_PERR_ENA0_CTX_MISC_ACCM2);
	eval 'sub BNX_MISC_PERR_ENA0_CTX_MISC_ACCM3 () {(1<<10);}' unless defined(&BNX_MISC_PERR_ENA0_CTX_MISC_ACCM3);
	eval 'sub BNX_MISC_PERR_ENA0_CTX_MISC_ACCM4 () {(1<<11);}' unless defined(&BNX_MISC_PERR_ENA0_CTX_MISC_ACCM4);
	eval 'sub BNX_MISC_PERR_ENA0_CTX_MISC_ACCM5 () {(1<<12);}' unless defined(&BNX_MISC_PERR_ENA0_CTX_MISC_ACCM5);
	eval 'sub BNX_MISC_PERR_ENA0_CTX_MISC_PGTBL () {(1<<13);}' unless defined(&BNX_MISC_PERR_ENA0_CTX_MISC_PGTBL);
	eval 'sub BNX_MISC_PERR_ENA0_DMAE_MISC_DR0 () {(1<<14);}' unless defined(&BNX_MISC_PERR_ENA0_DMAE_MISC_DR0);
	eval 'sub BNX_MISC_PERR_ENA0_DMAE_MISC_DR1 () {(1<<15);}' unless defined(&BNX_MISC_PERR_ENA0_DMAE_MISC_DR1);
	eval 'sub BNX_MISC_PERR_ENA0_DMAE_MISC_DR2 () {(1<<16);}' unless defined(&BNX_MISC_PERR_ENA0_DMAE_MISC_DR2);
	eval 'sub BNX_MISC_PERR_ENA0_DMAE_MISC_DR3 () {(1<<17);}' unless defined(&BNX_MISC_PERR_ENA0_DMAE_MISC_DR3);
	eval 'sub BNX_MISC_PERR_ENA0_DMAE_MISC_DR4 () {(1<<18);}' unless defined(&BNX_MISC_PERR_ENA0_DMAE_MISC_DR4);
	eval 'sub BNX_MISC_PERR_ENA0_DMAE_MISC_DW0 () {(1<<19);}' unless defined(&BNX_MISC_PERR_ENA0_DMAE_MISC_DW0);
	eval 'sub BNX_MISC_PERR_ENA0_DMAE_MISC_DW1 () {(1<<20);}' unless defined(&BNX_MISC_PERR_ENA0_DMAE_MISC_DW1);
	eval 'sub BNX_MISC_PERR_ENA0_DMAE_MISC_DW2 () {(1<<21);}' unless defined(&BNX_MISC_PERR_ENA0_DMAE_MISC_DW2);
	eval 'sub BNX_MISC_PERR_ENA0_HC_MISC_DMA () {(1<<22);}' unless defined(&BNX_MISC_PERR_ENA0_HC_MISC_DMA);
	eval 'sub BNX_MISC_PERR_ENA0_MCP_MISC_REGF () {(1<<23);}' unless defined(&BNX_MISC_PERR_ENA0_MCP_MISC_REGF);
	eval 'sub BNX_MISC_PERR_ENA0_MCP_MISC_SCPAD () {(1<<24);}' unless defined(&BNX_MISC_PERR_ENA0_MCP_MISC_SCPAD);
	eval 'sub BNX_MISC_PERR_ENA0_MQ_MISC_CTX () {(1<<25);}' unless defined(&BNX_MISC_PERR_ENA0_MQ_MISC_CTX);
	eval 'sub BNX_MISC_PERR_ENA0_RBDC_MISC () {(1<<26);}' unless defined(&BNX_MISC_PERR_ENA0_RBDC_MISC);
	eval 'sub BNX_MISC_PERR_ENA0_RBUF_MISC_MB () {(1<<27);}' unless defined(&BNX_MISC_PERR_ENA0_RBUF_MISC_MB);
	eval 'sub BNX_MISC_PERR_ENA0_RBUF_MISC_PTR () {(1<<28);}' unless defined(&BNX_MISC_PERR_ENA0_RBUF_MISC_PTR);
	eval 'sub BNX_MISC_PERR_ENA0_RDE_MISC_RPC () {(1<<29);}' unless defined(&BNX_MISC_PERR_ENA0_RDE_MISC_RPC);
	eval 'sub BNX_MISC_PERR_ENA0_RDE_MISC_RPM () {(1<<30);}' unless defined(&BNX_MISC_PERR_ENA0_RDE_MISC_RPM);
	eval 'sub BNX_MISC_PERR_ENA0_RV2P_MISC_CB0REGS () {(1<<31);}' unless defined(&BNX_MISC_PERR_ENA0_RV2P_MISC_CB0REGS);
	eval 'sub BNX_MISC_PERR_ENA1 () {0x8a8;}' unless defined(&BNX_MISC_PERR_ENA1);
	eval 'sub BNX_MISC_PERR_ENA1_RV2P_MISC_CB1REGS () {(1<<0);}' unless defined(&BNX_MISC_PERR_ENA1_RV2P_MISC_CB1REGS);
	eval 'sub BNX_MISC_PERR_ENA1_RV2P_MISC_P1IRAM () {(1<<1);}' unless defined(&BNX_MISC_PERR_ENA1_RV2P_MISC_P1IRAM);
	eval 'sub BNX_MISC_PERR_ENA1_RV2P_MISC_P2IRAM () {(1<<2);}' unless defined(&BNX_MISC_PERR_ENA1_RV2P_MISC_P2IRAM);
	eval 'sub BNX_MISC_PERR_ENA1_RXP_MISC_CTXC () {(1<<3);}' unless defined(&BNX_MISC_PERR_ENA1_RXP_MISC_CTXC);
	eval 'sub BNX_MISC_PERR_ENA1_RXP_MISC_REGF () {(1<<4);}' unless defined(&BNX_MISC_PERR_ENA1_RXP_MISC_REGF);
	eval 'sub BNX_MISC_PERR_ENA1_RXP_MISC_SCPAD () {(1<<5);}' unless defined(&BNX_MISC_PERR_ENA1_RXP_MISC_SCPAD);
	eval 'sub BNX_MISC_PERR_ENA1_RXP_MISC_RBUFC () {(1<<6);}' unless defined(&BNX_MISC_PERR_ENA1_RXP_MISC_RBUFC);
	eval 'sub BNX_MISC_PERR_ENA1_TBDC_MISC () {(1<<7);}' unless defined(&BNX_MISC_PERR_ENA1_TBDC_MISC);
	eval 'sub BNX_MISC_PERR_ENA1_TDMA_MISC () {(1<<8);}' unless defined(&BNX_MISC_PERR_ENA1_TDMA_MISC);
	eval 'sub BNX_MISC_PERR_ENA1_THBUF_MISC_MB0 () {(1<<9);}' unless defined(&BNX_MISC_PERR_ENA1_THBUF_MISC_MB0);
	eval 'sub BNX_MISC_PERR_ENA1_THBUF_MISC_MB1 () {(1<<10);}' unless defined(&BNX_MISC_PERR_ENA1_THBUF_MISC_MB1);
	eval 'sub BNX_MISC_PERR_ENA1_TPAT_MISC_REGF () {(1<<11);}' unless defined(&BNX_MISC_PERR_ENA1_TPAT_MISC_REGF);
	eval 'sub BNX_MISC_PERR_ENA1_TPAT_MISC_SCPAD () {(1<<12);}' unless defined(&BNX_MISC_PERR_ENA1_TPAT_MISC_SCPAD);
	eval 'sub BNX_MISC_PERR_ENA1_TPBUF_MISC_MB () {(1<<13);}' unless defined(&BNX_MISC_PERR_ENA1_TPBUF_MISC_MB);
	eval 'sub BNX_MISC_PERR_ENA1_TSCH_MISC_LR () {(1<<14);}' unless defined(&BNX_MISC_PERR_ENA1_TSCH_MISC_LR);
	eval 'sub BNX_MISC_PERR_ENA1_TXP_MISC_CTXC () {(1<<15);}' unless defined(&BNX_MISC_PERR_ENA1_TXP_MISC_CTXC);
	eval 'sub BNX_MISC_PERR_ENA1_TXP_MISC_REGF () {(1<<16);}' unless defined(&BNX_MISC_PERR_ENA1_TXP_MISC_REGF);
	eval 'sub BNX_MISC_PERR_ENA1_TXP_MISC_SCPAD () {(1<<17);}' unless defined(&BNX_MISC_PERR_ENA1_TXP_MISC_SCPAD);
	eval 'sub BNX_MISC_PERR_ENA1_UMP_MISC_FIORX () {(1<<18);}' unless defined(&BNX_MISC_PERR_ENA1_UMP_MISC_FIORX);
	eval 'sub BNX_MISC_PERR_ENA1_UMP_MISC_FIOTX () {(1<<19);}' unless defined(&BNX_MISC_PERR_ENA1_UMP_MISC_FIOTX);
	eval 'sub BNX_MISC_PERR_ENA1_UMP_MISC_RX () {(1<<20);}' unless defined(&BNX_MISC_PERR_ENA1_UMP_MISC_RX);
	eval 'sub BNX_MISC_PERR_ENA1_UMP_MISC_TX () {(1<<21);}' unless defined(&BNX_MISC_PERR_ENA1_UMP_MISC_TX);
	eval 'sub BNX_MISC_PERR_ENA1_RDMAQ_MISC () {(1<<22);}' unless defined(&BNX_MISC_PERR_ENA1_RDMAQ_MISC);
	eval 'sub BNX_MISC_PERR_ENA1_CSQ_MISC () {(1<<23);}' unless defined(&BNX_MISC_PERR_ENA1_CSQ_MISC);
	eval 'sub BNX_MISC_PERR_ENA1_CPQ_MISC () {(1<<24);}' unless defined(&BNX_MISC_PERR_ENA1_CPQ_MISC);
	eval 'sub BNX_MISC_PERR_ENA1_MCPQ_MISC () {(1<<25);}' unless defined(&BNX_MISC_PERR_ENA1_MCPQ_MISC);
	eval 'sub BNX_MISC_PERR_ENA1_RV2PMQ_MISC () {(1<<26);}' unless defined(&BNX_MISC_PERR_ENA1_RV2PMQ_MISC);
	eval 'sub BNX_MISC_PERR_ENA1_RV2PPQ_MISC () {(1<<27);}' unless defined(&BNX_MISC_PERR_ENA1_RV2PPQ_MISC);
	eval 'sub BNX_MISC_PERR_ENA1_RV2PTQ_MISC () {(1<<28);}' unless defined(&BNX_MISC_PERR_ENA1_RV2PTQ_MISC);
	eval 'sub BNX_MISC_PERR_ENA1_RXPQ_MISC () {(1<<29);}' unless defined(&BNX_MISC_PERR_ENA1_RXPQ_MISC);
	eval 'sub BNX_MISC_PERR_ENA1_RXPCQ_MISC () {(1<<30);}' unless defined(&BNX_MISC_PERR_ENA1_RXPCQ_MISC);
	eval 'sub BNX_MISC_PERR_ENA1_RLUPQ_MISC () {(1<<31);}' unless defined(&BNX_MISC_PERR_ENA1_RLUPQ_MISC);
	eval 'sub BNX_MISC_PERR_ENA2 () {0x8ac;}' unless defined(&BNX_MISC_PERR_ENA2);
	eval 'sub BNX_MISC_PERR_ENA2_COMQ_MISC () {(1<<0);}' unless defined(&BNX_MISC_PERR_ENA2_COMQ_MISC);
	eval 'sub BNX_MISC_PERR_ENA2_COMXQ_MISC () {(1<<1);}' unless defined(&BNX_MISC_PERR_ENA2_COMXQ_MISC);
	eval 'sub BNX_MISC_PERR_ENA2_COMTQ_MISC () {(1<<2);}' unless defined(&BNX_MISC_PERR_ENA2_COMTQ_MISC);
	eval 'sub BNX_MISC_PERR_ENA2_TSCHQ_MISC () {(1<<3);}' unless defined(&BNX_MISC_PERR_ENA2_TSCHQ_MISC);
	eval 'sub BNX_MISC_PERR_ENA2_TBDRQ_MISC () {(1<<4);}' unless defined(&BNX_MISC_PERR_ENA2_TBDRQ_MISC);
	eval 'sub BNX_MISC_PERR_ENA2_TXPQ_MISC () {(1<<5);}' unless defined(&BNX_MISC_PERR_ENA2_TXPQ_MISC);
	eval 'sub BNX_MISC_PERR_ENA2_TDMAQ_MISC () {(1<<6);}' unless defined(&BNX_MISC_PERR_ENA2_TDMAQ_MISC);
	eval 'sub BNX_MISC_PERR_ENA2_TPATQ_MISC () {(1<<7);}' unless defined(&BNX_MISC_PERR_ENA2_TPATQ_MISC);
	eval 'sub BNX_MISC_PERR_ENA2_TASQ_MISC () {(1<<8);}' unless defined(&BNX_MISC_PERR_ENA2_TASQ_MISC);
	eval 'sub BNX_MISC_DEBUG_VECTOR_SEL () {0x8b0;}' unless defined(&BNX_MISC_DEBUG_VECTOR_SEL);
	eval 'sub BNX_MISC_DEBUG_VECTOR_SEL_0 () {(0xfff<<0);}' unless defined(&BNX_MISC_DEBUG_VECTOR_SEL_0);
	eval 'sub BNX_MISC_DEBUG_VECTOR_SEL_1 () {(0xfff<<12);}' unless defined(&BNX_MISC_DEBUG_VECTOR_SEL_1);
	eval 'sub BNX_MISC_VREG_CONTROL () {0x8b4;}' unless defined(&BNX_MISC_VREG_CONTROL);
	eval 'sub BNX_MISC_VREG_CONTROL_1_2 () {(0xf<<0);}' unless defined(&BNX_MISC_VREG_CONTROL_1_2);
	eval 'sub BNX_MISC_VREG_CONTROL_2_5 () {(0xf<<4);}' unless defined(&BNX_MISC_VREG_CONTROL_2_5);
	eval 'sub BNX_MISC_FINAL_CLK_CTL_VAL () {0x8b8;}' unless defined(&BNX_MISC_FINAL_CLK_CTL_VAL);
	eval 'sub BNX_MISC_FINAL_CLK_CTL_VAL_MISC_FINAL_CLK_CTL_VAL () {(0x3ffffff<<6);}' unless defined(&BNX_MISC_FINAL_CLK_CTL_VAL_MISC_FINAL_CLK_CTL_VAL);
	eval 'sub BNX_MISC_NEW_CORE_CTL () {0x8c8;}' unless defined(&BNX_MISC_NEW_CORE_CTL);
	eval 'sub BNX_MISC_NEW_CORE_CTL_LINK_HOLDOFF_SUCCESS () {(1<<0);}' unless defined(&BNX_MISC_NEW_CORE_CTL_LINK_HOLDOFF_SUCCESS);
	eval 'sub BNX_MISC_NEW_CORE_CTL_LINK_HOLDOFF_REQ () {(1<<1);}' unless defined(&BNX_MISC_NEW_CORE_CTL_LINK_HOLDOFF_REQ);
	eval 'sub BNX_MISC_NEW_CORE_CTL_DMA_ENABLE () {(1<<16);}' unless defined(&BNX_MISC_NEW_CORE_CTL_DMA_ENABLE);
	eval 'sub BNX_MISC_NEW_CORE_CTL_RESERVED_CMN () {(0x3fff<<2);}' unless defined(&BNX_MISC_NEW_CORE_CTL_RESERVED_CMN);
	eval 'sub BNX_MISC_NEW_CORE_CTL_RESERVED_TC () {(0xffff<<16);}' unless defined(&BNX_MISC_NEW_CORE_CTL_RESERVED_TC);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL () {0x8ec;}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_BOND_ID () {(0xff<<0);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_BOND_ID);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_BOND_ID_X () {(0<<0);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_BOND_ID_X);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_BOND_ID_C () {(3<<0);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_BOND_ID_C);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_BOND_ID_S () {(12<<0);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_BOND_ID_S);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_PHY_CTRL_STRAP () {(0x7<<8);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_PHY_CTRL_STRAP);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_PORT_SWAP_PIN () {(1<<11);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_PORT_SWAP_PIN);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_SERDES1_SIGDET () {(1<<12);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_SERDES1_SIGDET);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_SERDES0_SIGDET () {(1<<13);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_SERDES0_SIGDET);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_PHY1_SIGDET () {(1<<14);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_PHY1_SIGDET);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_PHY0_SIGDET () {(1<<15);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_PHY0_SIGDET);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_LCPLL_RST () {(1<<16);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_LCPLL_RST);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_SERDES1_RST () {(1<<17);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_SERDES1_RST);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_SERDES0_RST () {(1<<18);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_SERDES0_RST);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_PHY1_RST () {(1<<19);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_PHY1_RST);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_PHY0_RST () {(1<<20);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_PHY0_RST);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_PHY_CTRL () {(0x7<<21);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_PHY_CTRL);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_PORT_SWAP () {(1<<24);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_PORT_SWAP);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_STRAP_OVERRIDE () {(1<<25);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_STRAP_OVERRIDE);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_PHY_SERDES_IDDQ () {(0xf<<26);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_PHY_SERDES_IDDQ);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_PHY_SERDES_IDDQ_SER1_IDDQ () {(1<<26);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_PHY_SERDES_IDDQ_SER1_IDDQ);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_PHY_SERDES_IDDQ_SER0_IDDQ () {(2<<26);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_PHY_SERDES_IDDQ_SER0_IDDQ);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_PHY_SERDES_IDDQ_PHY1_IDDQ () {(4<<26);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_PHY_SERDES_IDDQ_PHY1_IDDQ);
	eval 'sub BNX_MISC_DUAL_MEDIA_CTRL_PHY_SERDES_IDDQ_PHY0_IDDQ () {(8<<26);}' unless defined(&BNX_MISC_DUAL_MEDIA_CTRL_PHY_SERDES_IDDQ_PHY0_IDDQ);
	eval 'sub BNX_MISC_UNUSED0 () {0x8bc;}' unless defined(&BNX_MISC_UNUSED0);
	eval 'sub BNX_NVM_COMMAND () {0x6400;}' unless defined(&BNX_NVM_COMMAND);
	eval 'sub BNX_NVM_COMMAND_RST () {(1<<0);}' unless defined(&BNX_NVM_COMMAND_RST);
	eval 'sub BNX_NVM_COMMAND_DONE () {(1<<3);}' unless defined(&BNX_NVM_COMMAND_DONE);
	eval 'sub BNX_NVM_COMMAND_DOIT () {(1<<4);}' unless defined(&BNX_NVM_COMMAND_DOIT);
	eval 'sub BNX_NVM_COMMAND_WR () {(1<<5);}' unless defined(&BNX_NVM_COMMAND_WR);
	eval 'sub BNX_NVM_COMMAND_ERASE () {(1<<6);}' unless defined(&BNX_NVM_COMMAND_ERASE);
	eval 'sub BNX_NVM_COMMAND_FIRST () {(1<<7);}' unless defined(&BNX_NVM_COMMAND_FIRST);
	eval 'sub BNX_NVM_COMMAND_LAST () {(1<<8);}' unless defined(&BNX_NVM_COMMAND_LAST);
	eval 'sub BNX_NVM_COMMAND_WREN () {(1<<16);}' unless defined(&BNX_NVM_COMMAND_WREN);
	eval 'sub BNX_NVM_COMMAND_WRDI () {(1<<17);}' unless defined(&BNX_NVM_COMMAND_WRDI);
	eval 'sub BNX_NVM_COMMAND_EWSR () {(1<<18);}' unless defined(&BNX_NVM_COMMAND_EWSR);
	eval 'sub BNX_NVM_COMMAND_WRSR () {(1<<19);}' unless defined(&BNX_NVM_COMMAND_WRSR);
	eval 'sub BNX_NVM_STATUS () {0x6404;}' unless defined(&BNX_NVM_STATUS);
	eval 'sub BNX_NVM_STATUS_PI_FSM_STATE () {(0xf<<0);}' unless defined(&BNX_NVM_STATUS_PI_FSM_STATE);
	eval 'sub BNX_NVM_STATUS_EE_FSM_STATE () {(0xf<<4);}' unless defined(&BNX_NVM_STATUS_EE_FSM_STATE);
	eval 'sub BNX_NVM_STATUS_EQ_FSM_STATE () {(0xf<<8);}' unless defined(&BNX_NVM_STATUS_EQ_FSM_STATE);
	eval 'sub BNX_NVM_WRITE () {0x6408;}' unless defined(&BNX_NVM_WRITE);
	eval 'sub BNX_NVM_WRITE_NVM_WRITE_VALUE () {(0xffffffff<<0);}' unless defined(&BNX_NVM_WRITE_NVM_WRITE_VALUE);
	eval 'sub BNX_NVM_WRITE_NVM_WRITE_VALUE_BIT_BANG () {(0<<0);}' unless defined(&BNX_NVM_WRITE_NVM_WRITE_VALUE_BIT_BANG);
	eval 'sub BNX_NVM_WRITE_NVM_WRITE_VALUE_EECLK () {(1<<0);}' unless defined(&BNX_NVM_WRITE_NVM_WRITE_VALUE_EECLK);
	eval 'sub BNX_NVM_WRITE_NVM_WRITE_VALUE_EEDATA () {(2<<0);}' unless defined(&BNX_NVM_WRITE_NVM_WRITE_VALUE_EEDATA);
	eval 'sub BNX_NVM_WRITE_NVM_WRITE_VALUE_SCLK () {(4<<0);}' unless defined(&BNX_NVM_WRITE_NVM_WRITE_VALUE_SCLK);
	eval 'sub BNX_NVM_WRITE_NVM_WRITE_VALUE_CS_B () {(8<<0);}' unless defined(&BNX_NVM_WRITE_NVM_WRITE_VALUE_CS_B);
	eval 'sub BNX_NVM_WRITE_NVM_WRITE_VALUE_SO () {(16<<0);}' unless defined(&BNX_NVM_WRITE_NVM_WRITE_VALUE_SO);
	eval 'sub BNX_NVM_WRITE_NVM_WRITE_VALUE_SI () {(32<<0);}' unless defined(&BNX_NVM_WRITE_NVM_WRITE_VALUE_SI);
	eval 'sub BNX_NVM_ADDR () {0x640c;}' unless defined(&BNX_NVM_ADDR);
	eval 'sub BNX_NVM_ADDR_NVM_ADDR_VALUE () {(0xffffff<<0);}' unless defined(&BNX_NVM_ADDR_NVM_ADDR_VALUE);
	eval 'sub BNX_NVM_ADDR_NVM_ADDR_VALUE_BIT_BANG () {(0<<0);}' unless defined(&BNX_NVM_ADDR_NVM_ADDR_VALUE_BIT_BANG);
	eval 'sub BNX_NVM_ADDR_NVM_ADDR_VALUE_EECLK () {(1<<0);}' unless defined(&BNX_NVM_ADDR_NVM_ADDR_VALUE_EECLK);
	eval 'sub BNX_NVM_ADDR_NVM_ADDR_VALUE_EEDATA () {(2<<0);}' unless defined(&BNX_NVM_ADDR_NVM_ADDR_VALUE_EEDATA);
	eval 'sub BNX_NVM_ADDR_NVM_ADDR_VALUE_SCLK () {(4<<0);}' unless defined(&BNX_NVM_ADDR_NVM_ADDR_VALUE_SCLK);
	eval 'sub BNX_NVM_ADDR_NVM_ADDR_VALUE_CS_B () {(8<<0);}' unless defined(&BNX_NVM_ADDR_NVM_ADDR_VALUE_CS_B);
	eval 'sub BNX_NVM_ADDR_NVM_ADDR_VALUE_SO () {(16<<0);}' unless defined(&BNX_NVM_ADDR_NVM_ADDR_VALUE_SO);
	eval 'sub BNX_NVM_ADDR_NVM_ADDR_VALUE_SI () {(32<<0);}' unless defined(&BNX_NVM_ADDR_NVM_ADDR_VALUE_SI);
	eval 'sub BNX_NVM_READ () {0x6410;}' unless defined(&BNX_NVM_READ);
	eval 'sub BNX_NVM_READ_NVM_READ_VALUE () {(0xffffffff<<0);}' unless defined(&BNX_NVM_READ_NVM_READ_VALUE);
	eval 'sub BNX_NVM_READ_NVM_READ_VALUE_BIT_BANG () {(0<<0);}' unless defined(&BNX_NVM_READ_NVM_READ_VALUE_BIT_BANG);
	eval 'sub BNX_NVM_READ_NVM_READ_VALUE_EECLK () {(1<<0);}' unless defined(&BNX_NVM_READ_NVM_READ_VALUE_EECLK);
	eval 'sub BNX_NVM_READ_NVM_READ_VALUE_EEDATA () {(2<<0);}' unless defined(&BNX_NVM_READ_NVM_READ_VALUE_EEDATA);
	eval 'sub BNX_NVM_READ_NVM_READ_VALUE_SCLK () {(4<<0);}' unless defined(&BNX_NVM_READ_NVM_READ_VALUE_SCLK);
	eval 'sub BNX_NVM_READ_NVM_READ_VALUE_CS_B () {(8<<0);}' unless defined(&BNX_NVM_READ_NVM_READ_VALUE_CS_B);
	eval 'sub BNX_NVM_READ_NVM_READ_VALUE_SO () {(16<<0);}' unless defined(&BNX_NVM_READ_NVM_READ_VALUE_SO);
	eval 'sub BNX_NVM_READ_NVM_READ_VALUE_SI () {(32<<0);}' unless defined(&BNX_NVM_READ_NVM_READ_VALUE_SI);
	eval 'sub BNX_NVM_CFG1 () {0x6414;}' unless defined(&BNX_NVM_CFG1);
	eval 'sub BNX_NVM_CFG1_FLASH_MODE () {(1<<0);}' unless defined(&BNX_NVM_CFG1_FLASH_MODE);
	eval 'sub BNX_NVM_CFG1_BUFFER_MODE () {(1<<1);}' unless defined(&BNX_NVM_CFG1_BUFFER_MODE);
	eval 'sub BNX_NVM_CFG1_PASS_MODE () {(1<<2);}' unless defined(&BNX_NVM_CFG1_PASS_MODE);
	eval 'sub BNX_NVM_CFG1_BITBANG_MODE () {(1<<3);}' unless defined(&BNX_NVM_CFG1_BITBANG_MODE);
	eval 'sub BNX_NVM_CFG1_STATUS_BIT () {(0x7<<4);}' unless defined(&BNX_NVM_CFG1_STATUS_BIT);
	eval 'sub BNX_NVM_CFG1_STATUS_BIT_FLASH_RDY () {(0<<4);}' unless defined(&BNX_NVM_CFG1_STATUS_BIT_FLASH_RDY);
	eval 'sub BNX_NVM_CFG1_STATUS_BIT_BUFFER_RDY () {(7<<4);}' unless defined(&BNX_NVM_CFG1_STATUS_BIT_BUFFER_RDY);
	eval 'sub BNX_NVM_CFG1_SPI_CLK_DIV () {(0xf<<7);}' unless defined(&BNX_NVM_CFG1_SPI_CLK_DIV);
	eval 'sub BNX_NVM_CFG1_SEE_CLK_DIV () {(0x7ff<<11);}' unless defined(&BNX_NVM_CFG1_SEE_CLK_DIV);
	eval 'sub BNX_NVM_CFG1_PROTECT_MODE () {(1<<24);}' unless defined(&BNX_NVM_CFG1_PROTECT_MODE);
	eval 'sub BNX_NVM_CFG1_FLASH_SIZE () {(1<<25);}' unless defined(&BNX_NVM_CFG1_FLASH_SIZE);
	eval 'sub BNX_NVM_CFG1_COMPAT_BYPASSS () {(1<<31);}' unless defined(&BNX_NVM_CFG1_COMPAT_BYPASSS);
	eval 'sub BNX_NVM_CFG2 () {0x6418;}' unless defined(&BNX_NVM_CFG2);
	eval 'sub BNX_NVM_CFG2_ERASE_CMD () {(0xff<<0);}' unless defined(&BNX_NVM_CFG2_ERASE_CMD);
	eval 'sub BNX_NVM_CFG2_DUMMY () {(0xff<<8);}' unless defined(&BNX_NVM_CFG2_DUMMY);
	eval 'sub BNX_NVM_CFG2_STATUS_CMD () {(0xff<<16);}' unless defined(&BNX_NVM_CFG2_STATUS_CMD);
	eval 'sub BNX_NVM_CFG3 () {0x641c;}' unless defined(&BNX_NVM_CFG3);
	eval 'sub BNX_NVM_CFG3_BUFFER_RD_CMD () {(0xff<<0);}' unless defined(&BNX_NVM_CFG3_BUFFER_RD_CMD);
	eval 'sub BNX_NVM_CFG3_WRITE_CMD () {(0xff<<8);}' unless defined(&BNX_NVM_CFG3_WRITE_CMD);
	eval 'sub BNX_NVM_CFG3_BUFFER_WRITE_CMD () {(0xff<<16);}' unless defined(&BNX_NVM_CFG3_BUFFER_WRITE_CMD);
	eval 'sub BNX_NVM_CFG3_READ_CMD () {(0xff<<24);}' unless defined(&BNX_NVM_CFG3_READ_CMD);
	eval 'sub BNX_NVM_SW_ARB () {0x6420;}' unless defined(&BNX_NVM_SW_ARB);
	eval 'sub BNX_NVM_SW_ARB_ARB_REQ_SET0 () {(1<<0);}' unless defined(&BNX_NVM_SW_ARB_ARB_REQ_SET0);
	eval 'sub BNX_NVM_SW_ARB_ARB_REQ_SET1 () {(1<<1);}' unless defined(&BNX_NVM_SW_ARB_ARB_REQ_SET1);
	eval 'sub BNX_NVM_SW_ARB_ARB_REQ_SET2 () {(1<<2);}' unless defined(&BNX_NVM_SW_ARB_ARB_REQ_SET2);
	eval 'sub BNX_NVM_SW_ARB_ARB_REQ_SET3 () {(1<<3);}' unless defined(&BNX_NVM_SW_ARB_ARB_REQ_SET3);
	eval 'sub BNX_NVM_SW_ARB_ARB_REQ_CLR0 () {(1<<4);}' unless defined(&BNX_NVM_SW_ARB_ARB_REQ_CLR0);
	eval 'sub BNX_NVM_SW_ARB_ARB_REQ_CLR1 () {(1<<5);}' unless defined(&BNX_NVM_SW_ARB_ARB_REQ_CLR1);
	eval 'sub BNX_NVM_SW_ARB_ARB_REQ_CLR2 () {(1<<6);}' unless defined(&BNX_NVM_SW_ARB_ARB_REQ_CLR2);
	eval 'sub BNX_NVM_SW_ARB_ARB_REQ_CLR3 () {(1<<7);}' unless defined(&BNX_NVM_SW_ARB_ARB_REQ_CLR3);
	eval 'sub BNX_NVM_SW_ARB_ARB_ARB0 () {(1<<8);}' unless defined(&BNX_NVM_SW_ARB_ARB_ARB0);
	eval 'sub BNX_NVM_SW_ARB_ARB_ARB1 () {(1<<9);}' unless defined(&BNX_NVM_SW_ARB_ARB_ARB1);
	eval 'sub BNX_NVM_SW_ARB_ARB_ARB2 () {(1<<10);}' unless defined(&BNX_NVM_SW_ARB_ARB_ARB2);
	eval 'sub BNX_NVM_SW_ARB_ARB_ARB3 () {(1<<11);}' unless defined(&BNX_NVM_SW_ARB_ARB_ARB3);
	eval 'sub BNX_NVM_SW_ARB_REQ0 () {(1<<12);}' unless defined(&BNX_NVM_SW_ARB_REQ0);
	eval 'sub BNX_NVM_SW_ARB_REQ1 () {(1<<13);}' unless defined(&BNX_NVM_SW_ARB_REQ1);
	eval 'sub BNX_NVM_SW_ARB_REQ2 () {(1<<14);}' unless defined(&BNX_NVM_SW_ARB_REQ2);
	eval 'sub BNX_NVM_SW_ARB_REQ3 () {(1<<15);}' unless defined(&BNX_NVM_SW_ARB_REQ3);
	eval 'sub BNX_NVM_ACCESS_ENABLE () {0x6424;}' unless defined(&BNX_NVM_ACCESS_ENABLE);
	eval 'sub BNX_NVM_ACCESS_ENABLE_EN () {(1<<0);}' unless defined(&BNX_NVM_ACCESS_ENABLE_EN);
	eval 'sub BNX_NVM_ACCESS_ENABLE_WR_EN () {(1<<1);}' unless defined(&BNX_NVM_ACCESS_ENABLE_WR_EN);
	eval 'sub BNX_NVM_WRITE1 () {0x6428;}' unless defined(&BNX_NVM_WRITE1);
	eval 'sub BNX_NVM_WRITE1_WREN_CMD () {(0xff<<0);}' unless defined(&BNX_NVM_WRITE1_WREN_CMD);
	eval 'sub BNX_NVM_WRITE1_WRDI_CMD () {(0xff<<8);}' unless defined(&BNX_NVM_WRITE1_WRDI_CMD);
	eval 'sub BNX_NVM_WRITE1_SR_DATA () {(0xff<<16);}' unless defined(&BNX_NVM_WRITE1_SR_DATA);
	eval 'sub BNX_DMA_COMMAND () {0xc00;}' unless defined(&BNX_DMA_COMMAND);
	eval 'sub BNX_DMA_COMMAND_ENABLE () {(1<<0);}' unless defined(&BNX_DMA_COMMAND_ENABLE);
	eval 'sub BNX_DMA_STATUS () {0xc04;}' unless defined(&BNX_DMA_STATUS);
	eval 'sub BNX_DMA_STATUS_PAR_ERROR_STATE () {(1<<0);}' unless defined(&BNX_DMA_STATUS_PAR_ERROR_STATE);
	eval 'sub BNX_DMA_STATUS_READ_TRANSFERS_STAT () {(1<<16);}' unless defined(&BNX_DMA_STATUS_READ_TRANSFERS_STAT);
	eval 'sub BNX_DMA_STATUS_READ_DELAY_PCI_CLKS_STAT () {(1<<17);}' unless defined(&BNX_DMA_STATUS_READ_DELAY_PCI_CLKS_STAT);
	eval 'sub BNX_DMA_STATUS_BIG_READ_TRANSFERS_STAT () {(1<<18);}' unless defined(&BNX_DMA_STATUS_BIG_READ_TRANSFERS_STAT);
	eval 'sub BNX_DMA_STATUS_BIG_READ_DELAY_PCI_CLKS_STAT () {(1<<19);}' unless defined(&BNX_DMA_STATUS_BIG_READ_DELAY_PCI_CLKS_STAT);
	eval 'sub BNX_DMA_STATUS_BIG_READ_RETRY_AFTER_DATA_STAT () {(1<<20);}' unless defined(&BNX_DMA_STATUS_BIG_READ_RETRY_AFTER_DATA_STAT);
	eval 'sub BNX_DMA_STATUS_WRITE_TRANSFERS_STAT () {(1<<21);}' unless defined(&BNX_DMA_STATUS_WRITE_TRANSFERS_STAT);
	eval 'sub BNX_DMA_STATUS_WRITE_DELAY_PCI_CLKS_STAT () {(1<<22);}' unless defined(&BNX_DMA_STATUS_WRITE_DELAY_PCI_CLKS_STAT);
	eval 'sub BNX_DMA_STATUS_BIG_WRITE_TRANSFERS_STAT () {(1<<23);}' unless defined(&BNX_DMA_STATUS_BIG_WRITE_TRANSFERS_STAT);
	eval 'sub BNX_DMA_STATUS_BIG_WRITE_DELAY_PCI_CLKS_STAT () {(1<<24);}' unless defined(&BNX_DMA_STATUS_BIG_WRITE_DELAY_PCI_CLKS_STAT);
	eval 'sub BNX_DMA_STATUS_BIG_WRITE_RETRY_AFTER_DATA_STAT () {(1<<25);}' unless defined(&BNX_DMA_STATUS_BIG_WRITE_RETRY_AFTER_DATA_STAT);
	eval 'sub BNX_DMA_CONFIG () {0xc08;}' unless defined(&BNX_DMA_CONFIG);
	eval 'sub BNX_DMA_CONFIG_DATA_BYTE_SWAP () {(1<<0);}' unless defined(&BNX_DMA_CONFIG_DATA_BYTE_SWAP);
	eval 'sub BNX_DMA_CONFIG_DATA_WORD_SWAP () {(1<<1);}' unless defined(&BNX_DMA_CONFIG_DATA_WORD_SWAP);
	eval 'sub BNX_DMA_CONFIG_CNTL_BYTE_SWAP () {(1<<4);}' unless defined(&BNX_DMA_CONFIG_CNTL_BYTE_SWAP);
	eval 'sub BNX_DMA_CONFIG_CNTL_WORD_SWAP () {(1<<5);}' unless defined(&BNX_DMA_CONFIG_CNTL_WORD_SWAP);
	eval 'sub BNX_DMA_CONFIG_ONE_DMA () {(1<<6);}' unless defined(&BNX_DMA_CONFIG_ONE_DMA);
	eval 'sub BNX_DMA_CONFIG_CNTL_TWO_DMA () {(1<<7);}' unless defined(&BNX_DMA_CONFIG_CNTL_TWO_DMA);
	eval 'sub BNX_DMA_CONFIG_CNTL_FPGA_MODE () {(1<<8);}' unless defined(&BNX_DMA_CONFIG_CNTL_FPGA_MODE);
	eval 'sub BNX_DMA_CONFIG_CNTL_PING_PONG_DMA () {(1<<10);}' unless defined(&BNX_DMA_CONFIG_CNTL_PING_PONG_DMA);
	eval 'sub BNX_DMA_CONFIG_CNTL_PCI_COMP_DLY () {(1<<11);}' unless defined(&BNX_DMA_CONFIG_CNTL_PCI_COMP_DLY);
	eval 'sub BNX_DMA_CONFIG_NO_RCHANS_IN_USE () {(0xf<<12);}' unless defined(&BNX_DMA_CONFIG_NO_RCHANS_IN_USE);
	eval 'sub BNX_DMA_CONFIG_NO_WCHANS_IN_USE () {(0xf<<16);}' unless defined(&BNX_DMA_CONFIG_NO_WCHANS_IN_USE);
	eval 'sub BNX_DMA_CONFIG_PCI_CLK_CMP_BITS () {(0x7<<20);}' unless defined(&BNX_DMA_CONFIG_PCI_CLK_CMP_BITS);
	eval 'sub BNX_DMA_CONFIG_PCI_FAST_CLK_CMP () {(1<<23);}' unless defined(&BNX_DMA_CONFIG_PCI_FAST_CLK_CMP);
	eval 'sub BNX_DMA_CONFIG_BIG_SIZE () {(0xf<<24);}' unless defined(&BNX_DMA_CONFIG_BIG_SIZE);
	eval 'sub BNX_DMA_CONFIG_BIG_SIZE_NONE () {(0x<<24);}' unless defined(&BNX_DMA_CONFIG_BIG_SIZE_NONE);
	eval 'sub BNX_DMA_CONFIG_BIG_SIZE_64 () {(0x1<<24);}' unless defined(&BNX_DMA_CONFIG_BIG_SIZE_64);
	eval 'sub BNX_DMA_CONFIG_BIG_SIZE_128 () {(0x2<<24);}' unless defined(&BNX_DMA_CONFIG_BIG_SIZE_128);
	eval 'sub BNX_DMA_CONFIG_BIG_SIZE_256 () {(0x4<<24);}' unless defined(&BNX_DMA_CONFIG_BIG_SIZE_256);
	eval 'sub BNX_DMA_CONFIG_BIG_SIZE_512 () {(0x8<<24);}' unless defined(&BNX_DMA_CONFIG_BIG_SIZE_512);
	eval 'sub BNX_DMA_BLACKOUT () {0xc0c;}' unless defined(&BNX_DMA_BLACKOUT);
	eval 'sub BNX_DMA_BLACKOUT_RD_RETRY_BLACKOUT () {(0xff<<0);}' unless defined(&BNX_DMA_BLACKOUT_RD_RETRY_BLACKOUT);
	eval 'sub BNX_DMA_BLACKOUT_2ND_RD_RETRY_BLACKOUT () {(0xff<<8);}' unless defined(&BNX_DMA_BLACKOUT_2ND_RD_RETRY_BLACKOUT);
	eval 'sub BNX_DMA_BLACKOUT_WR_RETRY_BLACKOUT () {(0xff<<16);}' unless defined(&BNX_DMA_BLACKOUT_WR_RETRY_BLACKOUT);
	eval 'sub BNX_DMA_RCHAN_STAT () {0xc30;}' unless defined(&BNX_DMA_RCHAN_STAT);
	eval 'sub BNX_DMA_RCHAN_STAT_COMP_CODE_0 () {(0x7<<0);}' unless defined(&BNX_DMA_RCHAN_STAT_COMP_CODE_0);
	eval 'sub BNX_DMA_RCHAN_STAT_PAR_ERR_0 () {(1<<3);}' unless defined(&BNX_DMA_RCHAN_STAT_PAR_ERR_0);
	eval 'sub BNX_DMA_RCHAN_STAT_COMP_CODE_1 () {(0x7<<4);}' unless defined(&BNX_DMA_RCHAN_STAT_COMP_CODE_1);
	eval 'sub BNX_DMA_RCHAN_STAT_PAR_ERR_1 () {(1<<7);}' unless defined(&BNX_DMA_RCHAN_STAT_PAR_ERR_1);
	eval 'sub BNX_DMA_RCHAN_STAT_COMP_CODE_2 () {(0x7<<8);}' unless defined(&BNX_DMA_RCHAN_STAT_COMP_CODE_2);
	eval 'sub BNX_DMA_RCHAN_STAT_PAR_ERR_2 () {(1<<11);}' unless defined(&BNX_DMA_RCHAN_STAT_PAR_ERR_2);
	eval 'sub BNX_DMA_RCHAN_STAT_COMP_CODE_3 () {(0x7<<12);}' unless defined(&BNX_DMA_RCHAN_STAT_COMP_CODE_3);
	eval 'sub BNX_DMA_RCHAN_STAT_PAR_ERR_3 () {(1<<15);}' unless defined(&BNX_DMA_RCHAN_STAT_PAR_ERR_3);
	eval 'sub BNX_DMA_RCHAN_STAT_COMP_CODE_4 () {(0x7<<16);}' unless defined(&BNX_DMA_RCHAN_STAT_COMP_CODE_4);
	eval 'sub BNX_DMA_RCHAN_STAT_PAR_ERR_4 () {(1<<19);}' unless defined(&BNX_DMA_RCHAN_STAT_PAR_ERR_4);
	eval 'sub BNX_DMA_RCHAN_STAT_COMP_CODE_5 () {(0x7<<20);}' unless defined(&BNX_DMA_RCHAN_STAT_COMP_CODE_5);
	eval 'sub BNX_DMA_RCHAN_STAT_PAR_ERR_5 () {(1<<23);}' unless defined(&BNX_DMA_RCHAN_STAT_PAR_ERR_5);
	eval 'sub BNX_DMA_RCHAN_STAT_COMP_CODE_6 () {(0x7<<24);}' unless defined(&BNX_DMA_RCHAN_STAT_COMP_CODE_6);
	eval 'sub BNX_DMA_RCHAN_STAT_PAR_ERR_6 () {(1<<27);}' unless defined(&BNX_DMA_RCHAN_STAT_PAR_ERR_6);
	eval 'sub BNX_DMA_RCHAN_STAT_COMP_CODE_7 () {(0x7<<28);}' unless defined(&BNX_DMA_RCHAN_STAT_COMP_CODE_7);
	eval 'sub BNX_DMA_RCHAN_STAT_PAR_ERR_7 () {(1<<31);}' unless defined(&BNX_DMA_RCHAN_STAT_PAR_ERR_7);
	eval 'sub BNX_DMA_WCHAN_STAT () {0xc34;}' unless defined(&BNX_DMA_WCHAN_STAT);
	eval 'sub BNX_DMA_WCHAN_STAT_COMP_CODE_0 () {(0x7<<0);}' unless defined(&BNX_DMA_WCHAN_STAT_COMP_CODE_0);
	eval 'sub BNX_DMA_WCHAN_STAT_PAR_ERR_0 () {(1<<3);}' unless defined(&BNX_DMA_WCHAN_STAT_PAR_ERR_0);
	eval 'sub BNX_DMA_WCHAN_STAT_COMP_CODE_1 () {(0x7<<4);}' unless defined(&BNX_DMA_WCHAN_STAT_COMP_CODE_1);
	eval 'sub BNX_DMA_WCHAN_STAT_PAR_ERR_1 () {(1<<7);}' unless defined(&BNX_DMA_WCHAN_STAT_PAR_ERR_1);
	eval 'sub BNX_DMA_WCHAN_STAT_COMP_CODE_2 () {(0x7<<8);}' unless defined(&BNX_DMA_WCHAN_STAT_COMP_CODE_2);
	eval 'sub BNX_DMA_WCHAN_STAT_PAR_ERR_2 () {(1<<11);}' unless defined(&BNX_DMA_WCHAN_STAT_PAR_ERR_2);
	eval 'sub BNX_DMA_WCHAN_STAT_COMP_CODE_3 () {(0x7<<12);}' unless defined(&BNX_DMA_WCHAN_STAT_COMP_CODE_3);
	eval 'sub BNX_DMA_WCHAN_STAT_PAR_ERR_3 () {(1<<15);}' unless defined(&BNX_DMA_WCHAN_STAT_PAR_ERR_3);
	eval 'sub BNX_DMA_WCHAN_STAT_COMP_CODE_4 () {(0x7<<16);}' unless defined(&BNX_DMA_WCHAN_STAT_COMP_CODE_4);
	eval 'sub BNX_DMA_WCHAN_STAT_PAR_ERR_4 () {(1<<19);}' unless defined(&BNX_DMA_WCHAN_STAT_PAR_ERR_4);
	eval 'sub BNX_DMA_WCHAN_STAT_COMP_CODE_5 () {(0x7<<20);}' unless defined(&BNX_DMA_WCHAN_STAT_COMP_CODE_5);
	eval 'sub BNX_DMA_WCHAN_STAT_PAR_ERR_5 () {(1<<23);}' unless defined(&BNX_DMA_WCHAN_STAT_PAR_ERR_5);
	eval 'sub BNX_DMA_WCHAN_STAT_COMP_CODE_6 () {(0x7<<24);}' unless defined(&BNX_DMA_WCHAN_STAT_COMP_CODE_6);
	eval 'sub BNX_DMA_WCHAN_STAT_PAR_ERR_6 () {(1<<27);}' unless defined(&BNX_DMA_WCHAN_STAT_PAR_ERR_6);
	eval 'sub BNX_DMA_WCHAN_STAT_COMP_CODE_7 () {(0x7<<28);}' unless defined(&BNX_DMA_WCHAN_STAT_COMP_CODE_7);
	eval 'sub BNX_DMA_WCHAN_STAT_PAR_ERR_7 () {(1<<31);}' unless defined(&BNX_DMA_WCHAN_STAT_PAR_ERR_7);
	eval 'sub BNX_DMA_RCHAN_ASSIGNMENT () {0xc38;}' unless defined(&BNX_DMA_RCHAN_ASSIGNMENT);
	eval 'sub BNX_DMA_RCHAN_ASSIGNMENT_0 () {(0xf<<0);}' unless defined(&BNX_DMA_RCHAN_ASSIGNMENT_0);
	eval 'sub BNX_DMA_RCHAN_ASSIGNMENT_1 () {(0xf<<4);}' unless defined(&BNX_DMA_RCHAN_ASSIGNMENT_1);
	eval 'sub BNX_DMA_RCHAN_ASSIGNMENT_2 () {(0xf<<8);}' unless defined(&BNX_DMA_RCHAN_ASSIGNMENT_2);
	eval 'sub BNX_DMA_RCHAN_ASSIGNMENT_3 () {(0xf<<12);}' unless defined(&BNX_DMA_RCHAN_ASSIGNMENT_3);
	eval 'sub BNX_DMA_RCHAN_ASSIGNMENT_4 () {(0xf<<16);}' unless defined(&BNX_DMA_RCHAN_ASSIGNMENT_4);
	eval 'sub BNX_DMA_RCHAN_ASSIGNMENT_5 () {(0xf<<20);}' unless defined(&BNX_DMA_RCHAN_ASSIGNMENT_5);
	eval 'sub BNX_DMA_RCHAN_ASSIGNMENT_6 () {(0xf<<24);}' unless defined(&BNX_DMA_RCHAN_ASSIGNMENT_6);
	eval 'sub BNX_DMA_RCHAN_ASSIGNMENT_7 () {(0xf<<28);}' unless defined(&BNX_DMA_RCHAN_ASSIGNMENT_7);
	eval 'sub BNX_DMA_WCHAN_ASSIGNMENT () {0xc3c;}' unless defined(&BNX_DMA_WCHAN_ASSIGNMENT);
	eval 'sub BNX_DMA_WCHAN_ASSIGNMENT_0 () {(0xf<<0);}' unless defined(&BNX_DMA_WCHAN_ASSIGNMENT_0);
	eval 'sub BNX_DMA_WCHAN_ASSIGNMENT_1 () {(0xf<<4);}' unless defined(&BNX_DMA_WCHAN_ASSIGNMENT_1);
	eval 'sub BNX_DMA_WCHAN_ASSIGNMENT_2 () {(0xf<<8);}' unless defined(&BNX_DMA_WCHAN_ASSIGNMENT_2);
	eval 'sub BNX_DMA_WCHAN_ASSIGNMENT_3 () {(0xf<<12);}' unless defined(&BNX_DMA_WCHAN_ASSIGNMENT_3);
	eval 'sub BNX_DMA_WCHAN_ASSIGNMENT_4 () {(0xf<<16);}' unless defined(&BNX_DMA_WCHAN_ASSIGNMENT_4);
	eval 'sub BNX_DMA_WCHAN_ASSIGNMENT_5 () {(0xf<<20);}' unless defined(&BNX_DMA_WCHAN_ASSIGNMENT_5);
	eval 'sub BNX_DMA_WCHAN_ASSIGNMENT_6 () {(0xf<<24);}' unless defined(&BNX_DMA_WCHAN_ASSIGNMENT_6);
	eval 'sub BNX_DMA_WCHAN_ASSIGNMENT_7 () {(0xf<<28);}' unless defined(&BNX_DMA_WCHAN_ASSIGNMENT_7);
	eval 'sub BNX_DMA_RCHAN_STAT_00 () {0xc40;}' unless defined(&BNX_DMA_RCHAN_STAT_00);
	eval 'sub BNX_DMA_RCHAN_STAT_00_RCHAN_STA_HOST_ADDR_LOW () {(0xffffffff<<0);}' unless defined(&BNX_DMA_RCHAN_STAT_00_RCHAN_STA_HOST_ADDR_LOW);
	eval 'sub BNX_DMA_RCHAN_STAT_01 () {0xc44;}' unless defined(&BNX_DMA_RCHAN_STAT_01);
	eval 'sub BNX_DMA_RCHAN_STAT_01_RCHAN_STA_HOST_ADDR_HIGH () {(0xffffffff<<0);}' unless defined(&BNX_DMA_RCHAN_STAT_01_RCHAN_STA_HOST_ADDR_HIGH);
	eval 'sub BNX_DMA_RCHAN_STAT_02 () {0xc48;}' unless defined(&BNX_DMA_RCHAN_STAT_02);
	eval 'sub BNX_DMA_RCHAN_STAT_02_LENGTH () {(0xffff<<0);}' unless defined(&BNX_DMA_RCHAN_STAT_02_LENGTH);
	eval 'sub BNX_DMA_RCHAN_STAT_02_WORD_SWAP () {(1<<16);}' unless defined(&BNX_DMA_RCHAN_STAT_02_WORD_SWAP);
	eval 'sub BNX_DMA_RCHAN_STAT_02_BYTE_SWAP () {(1<<17);}' unless defined(&BNX_DMA_RCHAN_STAT_02_BYTE_SWAP);
	eval 'sub BNX_DMA_RCHAN_STAT_02_PRIORITY_LVL () {(1<<18);}' unless defined(&BNX_DMA_RCHAN_STAT_02_PRIORITY_LVL);
	eval 'sub BNX_DMA_RCHAN_STAT_10 () {0xc4c;}' unless defined(&BNX_DMA_RCHAN_STAT_10);
	eval 'sub BNX_DMA_RCHAN_STAT_11 () {0xc50;}' unless defined(&BNX_DMA_RCHAN_STAT_11);
	eval 'sub BNX_DMA_RCHAN_STAT_12 () {0xc54;}' unless defined(&BNX_DMA_RCHAN_STAT_12);
	eval 'sub BNX_DMA_RCHAN_STAT_20 () {0xc58;}' unless defined(&BNX_DMA_RCHAN_STAT_20);
	eval 'sub BNX_DMA_RCHAN_STAT_21 () {0xc5c;}' unless defined(&BNX_DMA_RCHAN_STAT_21);
	eval 'sub BNX_DMA_RCHAN_STAT_22 () {0xc60;}' unless defined(&BNX_DMA_RCHAN_STAT_22);
	eval 'sub BNX_DMA_RCHAN_STAT_30 () {0xc64;}' unless defined(&BNX_DMA_RCHAN_STAT_30);
	eval 'sub BNX_DMA_RCHAN_STAT_31 () {0xc68;}' unless defined(&BNX_DMA_RCHAN_STAT_31);
	eval 'sub BNX_DMA_RCHAN_STAT_32 () {0xc6c;}' unless defined(&BNX_DMA_RCHAN_STAT_32);
	eval 'sub BNX_DMA_RCHAN_STAT_40 () {0xc70;}' unless defined(&BNX_DMA_RCHAN_STAT_40);
	eval 'sub BNX_DMA_RCHAN_STAT_41 () {0xc74;}' unless defined(&BNX_DMA_RCHAN_STAT_41);
	eval 'sub BNX_DMA_RCHAN_STAT_42 () {0xc78;}' unless defined(&BNX_DMA_RCHAN_STAT_42);
	eval 'sub BNX_DMA_RCHAN_STAT_50 () {0xc7c;}' unless defined(&BNX_DMA_RCHAN_STAT_50);
	eval 'sub BNX_DMA_RCHAN_STAT_51 () {0xc80;}' unless defined(&BNX_DMA_RCHAN_STAT_51);
	eval 'sub BNX_DMA_RCHAN_STAT_52 () {0xc84;}' unless defined(&BNX_DMA_RCHAN_STAT_52);
	eval 'sub BNX_DMA_RCHAN_STAT_60 () {0xc88;}' unless defined(&BNX_DMA_RCHAN_STAT_60);
	eval 'sub BNX_DMA_RCHAN_STAT_61 () {0xc8c;}' unless defined(&BNX_DMA_RCHAN_STAT_61);
	eval 'sub BNX_DMA_RCHAN_STAT_62 () {0xc90;}' unless defined(&BNX_DMA_RCHAN_STAT_62);
	eval 'sub BNX_DMA_RCHAN_STAT_70 () {0xc94;}' unless defined(&BNX_DMA_RCHAN_STAT_70);
	eval 'sub BNX_DMA_RCHAN_STAT_71 () {0xc98;}' unless defined(&BNX_DMA_RCHAN_STAT_71);
	eval 'sub BNX_DMA_RCHAN_STAT_72 () {0xc9c;}' unless defined(&BNX_DMA_RCHAN_STAT_72);
	eval 'sub BNX_DMA_WCHAN_STAT_00 () {0xca0;}' unless defined(&BNX_DMA_WCHAN_STAT_00);
	eval 'sub BNX_DMA_WCHAN_STAT_00_WCHAN_STA_HOST_ADDR_LOW () {(0xffffffff<<0);}' unless defined(&BNX_DMA_WCHAN_STAT_00_WCHAN_STA_HOST_ADDR_LOW);
	eval 'sub BNX_DMA_WCHAN_STAT_01 () {0xca4;}' unless defined(&BNX_DMA_WCHAN_STAT_01);
	eval 'sub BNX_DMA_WCHAN_STAT_01_WCHAN_STA_HOST_ADDR_HIGH () {(0xffffffff<<0);}' unless defined(&BNX_DMA_WCHAN_STAT_01_WCHAN_STA_HOST_ADDR_HIGH);
	eval 'sub BNX_DMA_WCHAN_STAT_02 () {0xca8;}' unless defined(&BNX_DMA_WCHAN_STAT_02);
	eval 'sub BNX_DMA_WCHAN_STAT_02_LENGTH () {(0xffff<<0);}' unless defined(&BNX_DMA_WCHAN_STAT_02_LENGTH);
	eval 'sub BNX_DMA_WCHAN_STAT_02_WORD_SWAP () {(1<<16);}' unless defined(&BNX_DMA_WCHAN_STAT_02_WORD_SWAP);
	eval 'sub BNX_DMA_WCHAN_STAT_02_BYTE_SWAP () {(1<<17);}' unless defined(&BNX_DMA_WCHAN_STAT_02_BYTE_SWAP);
	eval 'sub BNX_DMA_WCHAN_STAT_02_PRIORITY_LVL () {(1<<18);}' unless defined(&BNX_DMA_WCHAN_STAT_02_PRIORITY_LVL);
	eval 'sub BNX_DMA_WCHAN_STAT_10 () {0xcac;}' unless defined(&BNX_DMA_WCHAN_STAT_10);
	eval 'sub BNX_DMA_WCHAN_STAT_11 () {0xcb0;}' unless defined(&BNX_DMA_WCHAN_STAT_11);
	eval 'sub BNX_DMA_WCHAN_STAT_12 () {0xcb4;}' unless defined(&BNX_DMA_WCHAN_STAT_12);
	eval 'sub BNX_DMA_WCHAN_STAT_20 () {0xcb8;}' unless defined(&BNX_DMA_WCHAN_STAT_20);
	eval 'sub BNX_DMA_WCHAN_STAT_21 () {0xcbc;}' unless defined(&BNX_DMA_WCHAN_STAT_21);
	eval 'sub BNX_DMA_WCHAN_STAT_22 () {0xcc0;}' unless defined(&BNX_DMA_WCHAN_STAT_22);
	eval 'sub BNX_DMA_WCHAN_STAT_30 () {0xcc4;}' unless defined(&BNX_DMA_WCHAN_STAT_30);
	eval 'sub BNX_DMA_WCHAN_STAT_31 () {0xcc8;}' unless defined(&BNX_DMA_WCHAN_STAT_31);
	eval 'sub BNX_DMA_WCHAN_STAT_32 () {0xccc;}' unless defined(&BNX_DMA_WCHAN_STAT_32);
	eval 'sub BNX_DMA_WCHAN_STAT_40 () {0xcd0;}' unless defined(&BNX_DMA_WCHAN_STAT_40);
	eval 'sub BNX_DMA_WCHAN_STAT_41 () {0xcd4;}' unless defined(&BNX_DMA_WCHAN_STAT_41);
	eval 'sub BNX_DMA_WCHAN_STAT_42 () {0xcd8;}' unless defined(&BNX_DMA_WCHAN_STAT_42);
	eval 'sub BNX_DMA_WCHAN_STAT_50 () {0xcdc;}' unless defined(&BNX_DMA_WCHAN_STAT_50);
	eval 'sub BNX_DMA_WCHAN_STAT_51 () {0xce0;}' unless defined(&BNX_DMA_WCHAN_STAT_51);
	eval 'sub BNX_DMA_WCHAN_STAT_52 () {0xce4;}' unless defined(&BNX_DMA_WCHAN_STAT_52);
	eval 'sub BNX_DMA_WCHAN_STAT_60 () {0xce8;}' unless defined(&BNX_DMA_WCHAN_STAT_60);
	eval 'sub BNX_DMA_WCHAN_STAT_61 () {0xcec;}' unless defined(&BNX_DMA_WCHAN_STAT_61);
	eval 'sub BNX_DMA_WCHAN_STAT_62 () {0xcf0;}' unless defined(&BNX_DMA_WCHAN_STAT_62);
	eval 'sub BNX_DMA_WCHAN_STAT_70 () {0xcf4;}' unless defined(&BNX_DMA_WCHAN_STAT_70);
	eval 'sub BNX_DMA_WCHAN_STAT_71 () {0xcf8;}' unless defined(&BNX_DMA_WCHAN_STAT_71);
	eval 'sub BNX_DMA_WCHAN_STAT_72 () {0xcfc;}' unless defined(&BNX_DMA_WCHAN_STAT_72);
	eval 'sub BNX_DMA_ARB_STAT_00 () {0xd00;}' unless defined(&BNX_DMA_ARB_STAT_00);
	eval 'sub BNX_DMA_ARB_STAT_00_MASTER () {(0xffff<<0);}' unless defined(&BNX_DMA_ARB_STAT_00_MASTER);
	eval 'sub BNX_DMA_ARB_STAT_00_MASTER_ENC () {(0xff<<16);}' unless defined(&BNX_DMA_ARB_STAT_00_MASTER_ENC);
	eval 'sub BNX_DMA_ARB_STAT_00_CUR_BINMSTR () {(0xff<<24);}' unless defined(&BNX_DMA_ARB_STAT_00_CUR_BINMSTR);
	eval 'sub BNX_DMA_ARB_STAT_01 () {0xd04;}' unless defined(&BNX_DMA_ARB_STAT_01);
	eval 'sub BNX_DMA_ARB_STAT_01_LPR_RPTR () {(0xf<<0);}' unless defined(&BNX_DMA_ARB_STAT_01_LPR_RPTR);
	eval 'sub BNX_DMA_ARB_STAT_01_LPR_WPTR () {(0xf<<4);}' unless defined(&BNX_DMA_ARB_STAT_01_LPR_WPTR);
	eval 'sub BNX_DMA_ARB_STAT_01_LPB_RPTR () {(0xf<<8);}' unless defined(&BNX_DMA_ARB_STAT_01_LPB_RPTR);
	eval 'sub BNX_DMA_ARB_STAT_01_LPB_WPTR () {(0xf<<12);}' unless defined(&BNX_DMA_ARB_STAT_01_LPB_WPTR);
	eval 'sub BNX_DMA_ARB_STAT_01_HPR_RPTR () {(0xf<<16);}' unless defined(&BNX_DMA_ARB_STAT_01_HPR_RPTR);
	eval 'sub BNX_DMA_ARB_STAT_01_HPR_WPTR () {(0xf<<20);}' unless defined(&BNX_DMA_ARB_STAT_01_HPR_WPTR);
	eval 'sub BNX_DMA_ARB_STAT_01_HPB_RPTR () {(0xf<<24);}' unless defined(&BNX_DMA_ARB_STAT_01_HPB_RPTR);
	eval 'sub BNX_DMA_ARB_STAT_01_HPB_WPTR () {(0xf<<28);}' unless defined(&BNX_DMA_ARB_STAT_01_HPB_WPTR);
	eval 'sub BNX_DMA_FUSE_CTRL0_CMD () {0xf00;}' unless defined(&BNX_DMA_FUSE_CTRL0_CMD);
	eval 'sub BNX_DMA_FUSE_CTRL0_CMD_PWRUP_DONE () {(1<<0);}' unless defined(&BNX_DMA_FUSE_CTRL0_CMD_PWRUP_DONE);
	eval 'sub BNX_DMA_FUSE_CTRL0_CMD_SHIFT_DONE () {(1<<1);}' unless defined(&BNX_DMA_FUSE_CTRL0_CMD_SHIFT_DONE);
	eval 'sub BNX_DMA_FUSE_CTRL0_CMD_SHIFT () {(1<<2);}' unless defined(&BNX_DMA_FUSE_CTRL0_CMD_SHIFT);
	eval 'sub BNX_DMA_FUSE_CTRL0_CMD_LOAD () {(1<<3);}' unless defined(&BNX_DMA_FUSE_CTRL0_CMD_LOAD);
	eval 'sub BNX_DMA_FUSE_CTRL0_CMD_SEL () {(0xf<<8);}' unless defined(&BNX_DMA_FUSE_CTRL0_CMD_SEL);
	eval 'sub BNX_DMA_FUSE_CTRL0_DATA () {0xf04;}' unless defined(&BNX_DMA_FUSE_CTRL0_DATA);
	eval 'sub BNX_DMA_FUSE_CTRL1_CMD () {0xf08;}' unless defined(&BNX_DMA_FUSE_CTRL1_CMD);
	eval 'sub BNX_DMA_FUSE_CTRL1_CMD_PWRUP_DONE () {(1<<0);}' unless defined(&BNX_DMA_FUSE_CTRL1_CMD_PWRUP_DONE);
	eval 'sub BNX_DMA_FUSE_CTRL1_CMD_SHIFT_DONE () {(1<<1);}' unless defined(&BNX_DMA_FUSE_CTRL1_CMD_SHIFT_DONE);
	eval 'sub BNX_DMA_FUSE_CTRL1_CMD_SHIFT () {(1<<2);}' unless defined(&BNX_DMA_FUSE_CTRL1_CMD_SHIFT);
	eval 'sub BNX_DMA_FUSE_CTRL1_CMD_LOAD () {(1<<3);}' unless defined(&BNX_DMA_FUSE_CTRL1_CMD_LOAD);
	eval 'sub BNX_DMA_FUSE_CTRL1_CMD_SEL () {(0xf<<8);}' unless defined(&BNX_DMA_FUSE_CTRL1_CMD_SEL);
	eval 'sub BNX_DMA_FUSE_CTRL1_DATA () {0xf0c;}' unless defined(&BNX_DMA_FUSE_CTRL1_DATA);
	eval 'sub BNX_DMA_FUSE_CTRL2_CMD () {0xf10;}' unless defined(&BNX_DMA_FUSE_CTRL2_CMD);
	eval 'sub BNX_DMA_FUSE_CTRL2_CMD_PWRUP_DONE () {(1<<0);}' unless defined(&BNX_DMA_FUSE_CTRL2_CMD_PWRUP_DONE);
	eval 'sub BNX_DMA_FUSE_CTRL2_CMD_SHIFT_DONE () {(1<<1);}' unless defined(&BNX_DMA_FUSE_CTRL2_CMD_SHIFT_DONE);
	eval 'sub BNX_DMA_FUSE_CTRL2_CMD_SHIFT () {(1<<2);}' unless defined(&BNX_DMA_FUSE_CTRL2_CMD_SHIFT);
	eval 'sub BNX_DMA_FUSE_CTRL2_CMD_LOAD () {(1<<3);}' unless defined(&BNX_DMA_FUSE_CTRL2_CMD_LOAD);
	eval 'sub BNX_DMA_FUSE_CTRL2_CMD_SEL () {(0xf<<8);}' unless defined(&BNX_DMA_FUSE_CTRL2_CMD_SEL);
	eval 'sub BNX_DMA_FUSE_CTRL2_DATA () {0xf14;}' unless defined(&BNX_DMA_FUSE_CTRL2_DATA);
	eval 'sub BNX_CTX_COMMAND () {0x1000;}' unless defined(&BNX_CTX_COMMAND);
	eval 'sub BNX_CTX_COMMAND_ENABLED () {(1<<0);}' unless defined(&BNX_CTX_COMMAND_ENABLED);
	eval 'sub BNX_CTX_COMMAND_DISABLE_USAGE_CNT () {(1<<1);}' unless defined(&BNX_CTX_COMMAND_DISABLE_USAGE_CNT);
	eval 'sub BNX_CTX_COMMAND_DISABLE_PLRU () {(1<<2);}' unless defined(&BNX_CTX_COMMAND_DISABLE_PLRU);
	eval 'sub BNX_CTX_COMMAND_DISABLE_COMBINE_READ () {(1<<3);}' unless defined(&BNX_CTX_COMMAND_DISABLE_COMBINE_READ);
	eval 'sub BNX_CTX_COMMAND_FLUSH_AHEAD () {(0x1f<<8);}' unless defined(&BNX_CTX_COMMAND_FLUSH_AHEAD);
	eval 'sub BNX_CTX_COMMAND_MEM_INIT () {(1<<13);}' unless defined(&BNX_CTX_COMMAND_MEM_INIT);
	eval 'sub BNX_CTX_COMMAND_PAGE_SIZE () {(0xf<<16);}' unless defined(&BNX_CTX_COMMAND_PAGE_SIZE);
	eval 'sub BNX_CTX_COMMAND_PAGE_SIZE_256 () {(0<<16);}' unless defined(&BNX_CTX_COMMAND_PAGE_SIZE_256);
	eval 'sub BNX_CTX_COMMAND_PAGE_SIZE_512 () {(1<<16);}' unless defined(&BNX_CTX_COMMAND_PAGE_SIZE_512);
	eval 'sub BNX_CTX_COMMAND_PAGE_SIZE_1K () {(2<<16);}' unless defined(&BNX_CTX_COMMAND_PAGE_SIZE_1K);
	eval 'sub BNX_CTX_COMMAND_PAGE_SIZE_2K () {(3<<16);}' unless defined(&BNX_CTX_COMMAND_PAGE_SIZE_2K);
	eval 'sub BNX_CTX_COMMAND_PAGE_SIZE_4K () {(4<<16);}' unless defined(&BNX_CTX_COMMAND_PAGE_SIZE_4K);
	eval 'sub BNX_CTX_COMMAND_PAGE_SIZE_8K () {(5<<16);}' unless defined(&BNX_CTX_COMMAND_PAGE_SIZE_8K);
	eval 'sub BNX_CTX_COMMAND_PAGE_SIZE_16K () {(6<<16);}' unless defined(&BNX_CTX_COMMAND_PAGE_SIZE_16K);
	eval 'sub BNX_CTX_COMMAND_PAGE_SIZE_32K () {(7<<16);}' unless defined(&BNX_CTX_COMMAND_PAGE_SIZE_32K);
	eval 'sub BNX_CTX_COMMAND_PAGE_SIZE_64K () {(8<<16);}' unless defined(&BNX_CTX_COMMAND_PAGE_SIZE_64K);
	eval 'sub BNX_CTX_COMMAND_PAGE_SIZE_128K () {(9<<16);}' unless defined(&BNX_CTX_COMMAND_PAGE_SIZE_128K);
	eval 'sub BNX_CTX_COMMAND_PAGE_SIZE_256K () {(10<<16);}' unless defined(&BNX_CTX_COMMAND_PAGE_SIZE_256K);
	eval 'sub BNX_CTX_COMMAND_PAGE_SIZE_512K () {(11<<16);}' unless defined(&BNX_CTX_COMMAND_PAGE_SIZE_512K);
	eval 'sub BNX_CTX_COMMAND_PAGE_SIZE_1M () {(12<<16);}' unless defined(&BNX_CTX_COMMAND_PAGE_SIZE_1M);
	eval 'sub BNX_CTX_STATUS () {0x1004;}' unless defined(&BNX_CTX_STATUS);
	eval 'sub BNX_CTX_STATUS_LOCK_WAIT () {(1<<0);}' unless defined(&BNX_CTX_STATUS_LOCK_WAIT);
	eval 'sub BNX_CTX_STATUS_READ_STAT () {(1<<16);}' unless defined(&BNX_CTX_STATUS_READ_STAT);
	eval 'sub BNX_CTX_STATUS_WRITE_STAT () {(1<<17);}' unless defined(&BNX_CTX_STATUS_WRITE_STAT);
	eval 'sub BNX_CTX_STATUS_ACC_STALL_STAT () {(1<<18);}' unless defined(&BNX_CTX_STATUS_ACC_STALL_STAT);
	eval 'sub BNX_CTX_STATUS_LOCK_STALL_STAT () {(1<<19);}' unless defined(&BNX_CTX_STATUS_LOCK_STALL_STAT);
	eval 'sub BNX_CTX_VIRT_ADDR () {0x1008;}' unless defined(&BNX_CTX_VIRT_ADDR);
	eval 'sub BNX_CTX_VIRT_ADDR_VIRT_ADDR () {(0x7fff<<6);}' unless defined(&BNX_CTX_VIRT_ADDR_VIRT_ADDR);
	eval 'sub BNX_CTX_PAGE_TBL () {0x100c;}' unless defined(&BNX_CTX_PAGE_TBL);
	eval 'sub BNX_CTX_PAGE_TBL_PAGE_TBL () {(0x3fff<<6);}' unless defined(&BNX_CTX_PAGE_TBL_PAGE_TBL);
	eval 'sub BNX_CTX_DATA_ADR () {0x1010;}' unless defined(&BNX_CTX_DATA_ADR);
	eval 'sub BNX_CTX_DATA_ADR_DATA_ADR () {(0x7ffff<<2);}' unless defined(&BNX_CTX_DATA_ADR_DATA_ADR);
	eval 'sub BNX_CTX_DATA () {0x1014;}' unless defined(&BNX_CTX_DATA);
	eval 'sub BNX_CTX_LOCK () {0x1018;}' unless defined(&BNX_CTX_LOCK);
	eval 'sub BNX_CTX_LOCK_TYPE () {(0x7<<0);}' unless defined(&BNX_CTX_LOCK_TYPE);
	eval 'sub BNX_CTX_LOCK_TYPE_LOCK_TYPE_VOID () {(0x<<0);}' unless defined(&BNX_CTX_LOCK_TYPE_LOCK_TYPE_VOID);
	eval 'sub BNX_CTX_LOCK_TYPE_LOCK_TYPE_COMPLETE () {(0x7<<0);}' unless defined(&BNX_CTX_LOCK_TYPE_LOCK_TYPE_COMPLETE);
	eval 'sub BNX_CTX_LOCK_TYPE_LOCK_TYPE_PROTOCOL () {(0x1<<0);}' unless defined(&BNX_CTX_LOCK_TYPE_LOCK_TYPE_PROTOCOL);
	eval 'sub BNX_CTX_LOCK_TYPE_LOCK_TYPE_TX () {(0x2<<0);}' unless defined(&BNX_CTX_LOCK_TYPE_LOCK_TYPE_TX);
	eval 'sub BNX_CTX_LOCK_TYPE_LOCK_TYPE_TIMER () {(0x4<<0);}' unless defined(&BNX_CTX_LOCK_TYPE_LOCK_TYPE_TIMER);
	eval 'sub BNX_CTX_LOCK_CID_VALUE () {(0x3fff<<7);}' unless defined(&BNX_CTX_LOCK_CID_VALUE);
	eval 'sub BNX_CTX_LOCK_GRANTED () {(1<<26);}' unless defined(&BNX_CTX_LOCK_GRANTED);
	eval 'sub BNX_CTX_LOCK_MODE () {(0x7<<27);}' unless defined(&BNX_CTX_LOCK_MODE);
	eval 'sub BNX_CTX_LOCK_MODE_UNLOCK () {(0x<<27);}' unless defined(&BNX_CTX_LOCK_MODE_UNLOCK);
	eval 'sub BNX_CTX_LOCK_MODE_IMMEDIATE () {(0x1<<27);}' unless defined(&BNX_CTX_LOCK_MODE_IMMEDIATE);
	eval 'sub BNX_CTX_LOCK_MODE_SURE () {(0x2<<27);}' unless defined(&BNX_CTX_LOCK_MODE_SURE);
	eval 'sub BNX_CTX_LOCK_STATUS () {(1<<30);}' unless defined(&BNX_CTX_LOCK_STATUS);
	eval 'sub BNX_CTX_LOCK_REQ () {(1<<31);}' unless defined(&BNX_CTX_LOCK_REQ);
	eval 'sub BNX_CTX_CTX_CTRL () {0x101c;}' unless defined(&BNX_CTX_CTX_CTRL);
	eval 'sub BNX_CTX_CTX_CTRL_CTX_ADDR () {(0x7ffff<<2);}' unless defined(&BNX_CTX_CTX_CTRL_CTX_ADDR);
	eval 'sub BNX_CTX_CTX_CTRL_MOD_USAGE_CNT () {(0x3<<21);}' unless defined(&BNX_CTX_CTX_CTRL_MOD_USAGE_CNT);
	eval 'sub BNX_CTX_CTX_CTRL_NO_RAM_ACC () {(1<<23);}' unless defined(&BNX_CTX_CTX_CTRL_NO_RAM_ACC);
	eval 'sub BNX_CTX_CTX_CTRL_PREFETCH_SIZE () {(0x3<<24);}' unless defined(&BNX_CTX_CTX_CTRL_PREFETCH_SIZE);
	eval 'sub BNX_CTX_CTX_CTRL_ATTR () {(1<<26);}' unless defined(&BNX_CTX_CTX_CTRL_ATTR);
	eval 'sub BNX_CTX_CTX_CTRL_WRITE_REQ () {(1<<30);}' unless defined(&BNX_CTX_CTX_CTRL_WRITE_REQ);
	eval 'sub BNX_CTX_CTX_CTRL_READ_REQ () {(1<<31);}' unless defined(&BNX_CTX_CTX_CTRL_READ_REQ);
	eval 'sub BNX_CTX_CTX_DATA () {0x1020;}' unless defined(&BNX_CTX_CTX_DATA);
	eval 'sub BNX_CTX_ACCESS_STATUS () {0x1040;}' unless defined(&BNX_CTX_ACCESS_STATUS);
	eval 'sub BNX_CTX_ACCESS_STATUS_MASTERENCODED () {(0xf<<0);}' unless defined(&BNX_CTX_ACCESS_STATUS_MASTERENCODED);
	eval 'sub BNX_CTX_ACCESS_STATUS_ACCESSMEMORYSM () {(0x3<<10);}' unless defined(&BNX_CTX_ACCESS_STATUS_ACCESSMEMORYSM);
	eval 'sub BNX_CTX_ACCESS_STATUS_PAGETABLEINITSM () {(0x3<<12);}' unless defined(&BNX_CTX_ACCESS_STATUS_PAGETABLEINITSM);
	eval 'sub BNX_CTX_ACCESS_STATUS_ACCESSMEMORYINITSM () {(0x3<<14);}' unless defined(&BNX_CTX_ACCESS_STATUS_ACCESSMEMORYINITSM);
	eval 'sub BNX_CTX_ACCESS_STATUS_QUALIFIED_REQUEST () {(0x7ff<<17);}' unless defined(&BNX_CTX_ACCESS_STATUS_QUALIFIED_REQUEST);
	eval 'sub BNX_CTX_ACCESS_STATUS_CAMMASTERENCODED_XI () {(0x1f<<0);}' unless defined(&BNX_CTX_ACCESS_STATUS_CAMMASTERENCODED_XI);
	eval 'sub BNX_CTX_ACCESS_STATUS_CACHEMASTERENCODED_XI () {(0x1f<<5);}' unless defined(&BNX_CTX_ACCESS_STATUS_CACHEMASTERENCODED_XI);
	eval 'sub BNX_CTX_ACCESS_STATUS_REQUEST_XI () {(0x3fffff<<10);}' unless defined(&BNX_CTX_ACCESS_STATUS_REQUEST_XI);
	eval 'sub BNX_CTX_DBG_LOCK_STATUS () {0x1044;}' unless defined(&BNX_CTX_DBG_LOCK_STATUS);
	eval 'sub BNX_CTX_DBG_LOCK_STATUS_SM () {(0x3ff<<0);}' unless defined(&BNX_CTX_DBG_LOCK_STATUS_SM);
	eval 'sub BNX_CTX_DBG_LOCK_STATUS_MATCH () {(0x3ff<<22);}' unless defined(&BNX_CTX_DBG_LOCK_STATUS_MATCH);
	eval 'sub BNX_CTX_CHNL_LOCK_STATUS_0 () {0x1080;}' unless defined(&BNX_CTX_CHNL_LOCK_STATUS_0);
	eval 'sub BNX_CTX_CHNL_LOCK_STATUS_0_CID () {(0x3fff<<0);}' unless defined(&BNX_CTX_CHNL_LOCK_STATUS_0_CID);
	eval 'sub BNX_CTX_CHNL_LOCK_STATUS_0_TYPE () {(0x3<<14);}' unless defined(&BNX_CTX_CHNL_LOCK_STATUS_0_TYPE);
	eval 'sub BNX_CTX_CHNL_LOCK_STATUS_0_MODE () {(1<<16);}' unless defined(&BNX_CTX_CHNL_LOCK_STATUS_0_MODE);
	eval 'sub BNX_CTX_CHNL_LOCK_STATUS_1 () {0x1084;}' unless defined(&BNX_CTX_CHNL_LOCK_STATUS_1);
	eval 'sub BNX_CTX_CHNL_LOCK_STATUS_2 () {0x1088;}' unless defined(&BNX_CTX_CHNL_LOCK_STATUS_2);
	eval 'sub BNX_CTX_CHNL_LOCK_STATUS_3 () {0x108c;}' unless defined(&BNX_CTX_CHNL_LOCK_STATUS_3);
	eval 'sub BNX_CTX_CHNL_LOCK_STATUS_4 () {0x1090;}' unless defined(&BNX_CTX_CHNL_LOCK_STATUS_4);
	eval 'sub BNX_CTX_CHNL_LOCK_STATUS_5 () {0x1094;}' unless defined(&BNX_CTX_CHNL_LOCK_STATUS_5);
	eval 'sub BNX_CTX_CHNL_LOCK_STATUS_6 () {0x1098;}' unless defined(&BNX_CTX_CHNL_LOCK_STATUS_6);
	eval 'sub BNX_CTX_CHNL_LOCK_STATUS_7 () {0x109c;}' unless defined(&BNX_CTX_CHNL_LOCK_STATUS_7);
	eval 'sub BNX_CTX_CHNL_LOCK_STATUS_8 () {0x10a0;}' unless defined(&BNX_CTX_CHNL_LOCK_STATUS_8);
	eval 'sub BNX_CTX_CACHE_DATA () {0x10c4;}' unless defined(&BNX_CTX_CACHE_DATA);
	eval 'sub BNX_CTX_HOST_PAGE_TBL_CTRL () {0x10c8;}' unless defined(&BNX_CTX_HOST_PAGE_TBL_CTRL);
	eval 'sub BNX_CTX_HOST_PAGE_TBL_CTRL_PAGE_TBL_ADDR () {(0x1ff<<0);}' unless defined(&BNX_CTX_HOST_PAGE_TBL_CTRL_PAGE_TBL_ADDR);
	eval 'sub BNX_CTX_HOST_PAGE_TBL_CTRL_WRITE_REQ () {(1<<30);}' unless defined(&BNX_CTX_HOST_PAGE_TBL_CTRL_WRITE_REQ);
	eval 'sub BNX_CTX_HOST_PAGE_TBL_CTRL_READ_REQ () {(1<<31);}' unless defined(&BNX_CTX_HOST_PAGE_TBL_CTRL_READ_REQ);
	eval 'sub BNX_CTX_HOST_PAGE_TBL_DATA0 () {0x10cc;}' unless defined(&BNX_CTX_HOST_PAGE_TBL_DATA0);
	eval 'sub BNX_CTX_HOST_PAGE_TBL_DATA0_VALID () {(1<<0);}' unless defined(&BNX_CTX_HOST_PAGE_TBL_DATA0_VALID);
	eval 'sub BNX_CTX_HOST_PAGE_TBL_DATA0_VALUE () {(0xffffff<<8);}' unless defined(&BNX_CTX_HOST_PAGE_TBL_DATA0_VALUE);
	eval 'sub BNX_CTX_HOST_PAGE_TBL_DATA1 () {0x10d0;}' unless defined(&BNX_CTX_HOST_PAGE_TBL_DATA1);
	eval 'sub BNX_EMAC_MODE () {0x1400;}' unless defined(&BNX_EMAC_MODE);
	eval 'sub BNX_EMAC_MODE_RESET () {(1<<0);}' unless defined(&BNX_EMAC_MODE_RESET);
	eval 'sub BNX_EMAC_MODE_HALF_DUPLEX () {(1<<1);}' unless defined(&BNX_EMAC_MODE_HALF_DUPLEX);
	eval 'sub BNX_EMAC_MODE_PORT () {(0x3<<2);}' unless defined(&BNX_EMAC_MODE_PORT);
	eval 'sub BNX_EMAC_MODE_PORT_NONE () {(0<<2);}' unless defined(&BNX_EMAC_MODE_PORT_NONE);
	eval 'sub BNX_EMAC_MODE_PORT_MII () {(1<<2);}' unless defined(&BNX_EMAC_MODE_PORT_MII);
	eval 'sub BNX_EMAC_MODE_PORT_GMII () {(2<<2);}' unless defined(&BNX_EMAC_MODE_PORT_GMII);
	eval 'sub BNX_EMAC_MODE_PORT_MII_10 () {(3<<2);}' unless defined(&BNX_EMAC_MODE_PORT_MII_10);
	eval 'sub BNX_EMAC_MODE_MAC_LOOP () {(1<<4);}' unless defined(&BNX_EMAC_MODE_MAC_LOOP);
	eval 'sub BNX_EMAC_MODE_25G () {(1<<5);}' unless defined(&BNX_EMAC_MODE_25G);
	eval 'sub BNX_EMAC_MODE_TAGGED_MAC_CTL () {(1<<7);}' unless defined(&BNX_EMAC_MODE_TAGGED_MAC_CTL);
	eval 'sub BNX_EMAC_MODE_TX_BURST () {(1<<8);}' unless defined(&BNX_EMAC_MODE_TX_BURST);
	eval 'sub BNX_EMAC_MODE_MAX_DEFER_DROP_ENA () {(1<<9);}' unless defined(&BNX_EMAC_MODE_MAX_DEFER_DROP_ENA);
	eval 'sub BNX_EMAC_MODE_EXT_LINK_POL () {(1<<10);}' unless defined(&BNX_EMAC_MODE_EXT_LINK_POL);
	eval 'sub BNX_EMAC_MODE_FORCE_LINK () {(1<<11);}' unless defined(&BNX_EMAC_MODE_FORCE_LINK);
	eval 'sub BNX_EMAC_MODE_MPKT () {(1<<18);}' unless defined(&BNX_EMAC_MODE_MPKT);
	eval 'sub BNX_EMAC_MODE_MPKT_RCVD () {(1<<19);}' unless defined(&BNX_EMAC_MODE_MPKT_RCVD);
	eval 'sub BNX_EMAC_MODE_ACPI_RCVD () {(1<<20);}' unless defined(&BNX_EMAC_MODE_ACPI_RCVD);
	eval 'sub BNX_EMAC_STATUS () {0x1404;}' unless defined(&BNX_EMAC_STATUS);
	eval 'sub BNX_EMAC_STATUS_LINK () {(1<<11);}' unless defined(&BNX_EMAC_STATUS_LINK);
	eval 'sub BNX_EMAC_STATUS_LINK_CHANGE () {(1<<12);}' unless defined(&BNX_EMAC_STATUS_LINK_CHANGE);
	eval 'sub BNX_EMAC_STATUS_MI_COMPLETE () {(1<<22);}' unless defined(&BNX_EMAC_STATUS_MI_COMPLETE);
	eval 'sub BNX_EMAC_STATUS_MI_INT () {(1<<23);}' unless defined(&BNX_EMAC_STATUS_MI_INT);
	eval 'sub BNX_EMAC_STATUS_AP_ERROR () {(1<<24);}' unless defined(&BNX_EMAC_STATUS_AP_ERROR);
	eval 'sub BNX_EMAC_STATUS_PARITY_ERROR_STATE () {(1<<31);}' unless defined(&BNX_EMAC_STATUS_PARITY_ERROR_STATE);
	eval 'sub BNX_EMAC_ATTENTION_ENA () {0x1408;}' unless defined(&BNX_EMAC_ATTENTION_ENA);
	eval 'sub BNX_EMAC_ATTENTION_ENA_LINK () {(1<<11);}' unless defined(&BNX_EMAC_ATTENTION_ENA_LINK);
	eval 'sub BNX_EMAC_ATTENTION_ENA_MI_COMPLETE () {(1<<22);}' unless defined(&BNX_EMAC_ATTENTION_ENA_MI_COMPLETE);
	eval 'sub BNX_EMAC_ATTENTION_ENA_MI_INT () {(1<<23);}' unless defined(&BNX_EMAC_ATTENTION_ENA_MI_INT);
	eval 'sub BNX_EMAC_ATTENTION_ENA_AP_ERROR () {(1<<24);}' unless defined(&BNX_EMAC_ATTENTION_ENA_AP_ERROR);
	eval 'sub BNX_EMAC_LED () {0x140c;}' unless defined(&BNX_EMAC_LED);
	eval 'sub BNX_EMAC_LED_OVERRIDE () {(1<<0);}' unless defined(&BNX_EMAC_LED_OVERRIDE);
	eval 'sub BNX_EMAC_LED_1000MB_OVERRIDE () {(1<<1);}' unless defined(&BNX_EMAC_LED_1000MB_OVERRIDE);
	eval 'sub BNX_EMAC_LED_100MB_OVERRIDE () {(1<<2);}' unless defined(&BNX_EMAC_LED_100MB_OVERRIDE);
	eval 'sub BNX_EMAC_LED_10MB_OVERRIDE () {(1<<3);}' unless defined(&BNX_EMAC_LED_10MB_OVERRIDE);
	eval 'sub BNX_EMAC_LED_TRAFFIC_OVERRIDE () {(1<<4);}' unless defined(&BNX_EMAC_LED_TRAFFIC_OVERRIDE);
	eval 'sub BNX_EMAC_LED_BLNK_TRAFFIC () {(1<<5);}' unless defined(&BNX_EMAC_LED_BLNK_TRAFFIC);
	eval 'sub BNX_EMAC_LED_TRAFFIC () {(1<<6);}' unless defined(&BNX_EMAC_LED_TRAFFIC);
	eval 'sub BNX_EMAC_LED_1000MB () {(1<<7);}' unless defined(&BNX_EMAC_LED_1000MB);
	eval 'sub BNX_EMAC_LED_100MB () {(1<<8);}' unless defined(&BNX_EMAC_LED_100MB);
	eval 'sub BNX_EMAC_LED_10MB () {(1<<9);}' unless defined(&BNX_EMAC_LED_10MB);
	eval 'sub BNX_EMAC_LED_TRAFFIC_STAT () {(1<<10);}' unless defined(&BNX_EMAC_LED_TRAFFIC_STAT);
	eval 'sub BNX_EMAC_LED_BLNK_RATE () {(0xfff<<19);}' unless defined(&BNX_EMAC_LED_BLNK_RATE);
	eval 'sub BNX_EMAC_LED_BLNK_RATE_ENA () {(1<<31);}' unless defined(&BNX_EMAC_LED_BLNK_RATE_ENA);
	eval 'sub BNX_EMAC_MAC_MATCH0 () {0x1410;}' unless defined(&BNX_EMAC_MAC_MATCH0);
	eval 'sub BNX_EMAC_MAC_MATCH1 () {0x1414;}' unless defined(&BNX_EMAC_MAC_MATCH1);
	eval 'sub BNX_EMAC_MAC_MATCH2 () {0x1418;}' unless defined(&BNX_EMAC_MAC_MATCH2);
	eval 'sub BNX_EMAC_MAC_MATCH3 () {0x141c;}' unless defined(&BNX_EMAC_MAC_MATCH3);
	eval 'sub BNX_EMAC_MAC_MATCH4 () {0x1420;}' unless defined(&BNX_EMAC_MAC_MATCH4);
	eval 'sub BNX_EMAC_MAC_MATCH5 () {0x1424;}' unless defined(&BNX_EMAC_MAC_MATCH5);
	eval 'sub BNX_EMAC_MAC_MATCH6 () {0x1428;}' unless defined(&BNX_EMAC_MAC_MATCH6);
	eval 'sub BNX_EMAC_MAC_MATCH7 () {0x142c;}' unless defined(&BNX_EMAC_MAC_MATCH7);
	eval 'sub BNX_EMAC_MAC_MATCH8 () {0x1430;}' unless defined(&BNX_EMAC_MAC_MATCH8);
	eval 'sub BNX_EMAC_MAC_MATCH9 () {0x1434;}' unless defined(&BNX_EMAC_MAC_MATCH9);
	eval 'sub BNX_EMAC_MAC_MATCH10 () {0x1438;}' unless defined(&BNX_EMAC_MAC_MATCH10);
	eval 'sub BNX_EMAC_MAC_MATCH11 () {0x143c;}' unless defined(&BNX_EMAC_MAC_MATCH11);
	eval 'sub BNX_EMAC_MAC_MATCH12 () {0x1440;}' unless defined(&BNX_EMAC_MAC_MATCH12);
	eval 'sub BNX_EMAC_MAC_MATCH13 () {0x1444;}' unless defined(&BNX_EMAC_MAC_MATCH13);
	eval 'sub BNX_EMAC_MAC_MATCH14 () {0x1448;}' unless defined(&BNX_EMAC_MAC_MATCH14);
	eval 'sub BNX_EMAC_MAC_MATCH15 () {0x144c;}' unless defined(&BNX_EMAC_MAC_MATCH15);
	eval 'sub BNX_EMAC_MAC_MATCH16 () {0x1450;}' unless defined(&BNX_EMAC_MAC_MATCH16);
	eval 'sub BNX_EMAC_MAC_MATCH17 () {0x1454;}' unless defined(&BNX_EMAC_MAC_MATCH17);
	eval 'sub BNX_EMAC_MAC_MATCH18 () {0x1458;}' unless defined(&BNX_EMAC_MAC_MATCH18);
	eval 'sub BNX_EMAC_MAC_MATCH19 () {0x145c;}' unless defined(&BNX_EMAC_MAC_MATCH19);
	eval 'sub BNX_EMAC_MAC_MATCH20 () {0x1460;}' unless defined(&BNX_EMAC_MAC_MATCH20);
	eval 'sub BNX_EMAC_MAC_MATCH21 () {0x1464;}' unless defined(&BNX_EMAC_MAC_MATCH21);
	eval 'sub BNX_EMAC_MAC_MATCH22 () {0x1468;}' unless defined(&BNX_EMAC_MAC_MATCH22);
	eval 'sub BNX_EMAC_MAC_MATCH23 () {0x146c;}' unless defined(&BNX_EMAC_MAC_MATCH23);
	eval 'sub BNX_EMAC_MAC_MATCH24 () {0x1470;}' unless defined(&BNX_EMAC_MAC_MATCH24);
	eval 'sub BNX_EMAC_MAC_MATCH25 () {0x1474;}' unless defined(&BNX_EMAC_MAC_MATCH25);
	eval 'sub BNX_EMAC_MAC_MATCH26 () {0x1478;}' unless defined(&BNX_EMAC_MAC_MATCH26);
	eval 'sub BNX_EMAC_MAC_MATCH27 () {0x147c;}' unless defined(&BNX_EMAC_MAC_MATCH27);
	eval 'sub BNX_EMAC_MAC_MATCH28 () {0x1480;}' unless defined(&BNX_EMAC_MAC_MATCH28);
	eval 'sub BNX_EMAC_MAC_MATCH29 () {0x1484;}' unless defined(&BNX_EMAC_MAC_MATCH29);
	eval 'sub BNX_EMAC_MAC_MATCH30 () {0x1488;}' unless defined(&BNX_EMAC_MAC_MATCH30);
	eval 'sub BNX_EMAC_MAC_MATCH31 () {0x148c;}' unless defined(&BNX_EMAC_MAC_MATCH31);
	eval 'sub BNX_EMAC_BACKOFF_SEED () {0x1498;}' unless defined(&BNX_EMAC_BACKOFF_SEED);
	eval 'sub BNX_EMAC_BACKOFF_SEED_EMAC_BACKOFF_SEED () {(0x3ff<<0);}' unless defined(&BNX_EMAC_BACKOFF_SEED_EMAC_BACKOFF_SEED);
	eval 'sub BNX_EMAC_RX_MTU_SIZE () {0x149c;}' unless defined(&BNX_EMAC_RX_MTU_SIZE);
	eval 'sub BNX_EMAC_RX_MTU_SIZE_MTU_SIZE () {(0xffff<<0);}' unless defined(&BNX_EMAC_RX_MTU_SIZE_MTU_SIZE);
	eval 'sub BNX_EMAC_RX_MTU_SIZE_JUMBO_ENA () {(1<<31);}' unless defined(&BNX_EMAC_RX_MTU_SIZE_JUMBO_ENA);
	eval 'sub BNX_EMAC_SERDES_CNTL () {0x14a4;}' unless defined(&BNX_EMAC_SERDES_CNTL);
	eval 'sub BNX_EMAC_SERDES_CNTL_RXR () {(0x7<<0);}' unless defined(&BNX_EMAC_SERDES_CNTL_RXR);
	eval 'sub BNX_EMAC_SERDES_CNTL_RXG () {(0x3<<3);}' unless defined(&BNX_EMAC_SERDES_CNTL_RXG);
	eval 'sub BNX_EMAC_SERDES_CNTL_RXCKSEL () {(1<<6);}' unless defined(&BNX_EMAC_SERDES_CNTL_RXCKSEL);
	eval 'sub BNX_EMAC_SERDES_CNTL_TXBIAS () {(0x7<<7);}' unless defined(&BNX_EMAC_SERDES_CNTL_TXBIAS);
	eval 'sub BNX_EMAC_SERDES_CNTL_BGMAX () {(1<<10);}' unless defined(&BNX_EMAC_SERDES_CNTL_BGMAX);
	eval 'sub BNX_EMAC_SERDES_CNTL_BGMIN () {(1<<11);}' unless defined(&BNX_EMAC_SERDES_CNTL_BGMIN);
	eval 'sub BNX_EMAC_SERDES_CNTL_TXMODE () {(1<<12);}' unless defined(&BNX_EMAC_SERDES_CNTL_TXMODE);
	eval 'sub BNX_EMAC_SERDES_CNTL_TXEDGE () {(1<<13);}' unless defined(&BNX_EMAC_SERDES_CNTL_TXEDGE);
	eval 'sub BNX_EMAC_SERDES_CNTL_SERDES_MODE () {(1<<14);}' unless defined(&BNX_EMAC_SERDES_CNTL_SERDES_MODE);
	eval 'sub BNX_EMAC_SERDES_CNTL_PLLTEST () {(1<<15);}' unless defined(&BNX_EMAC_SERDES_CNTL_PLLTEST);
	eval 'sub BNX_EMAC_SERDES_CNTL_CDET_EN () {(1<<16);}' unless defined(&BNX_EMAC_SERDES_CNTL_CDET_EN);
	eval 'sub BNX_EMAC_SERDES_CNTL_TBI_LBK () {(1<<17);}' unless defined(&BNX_EMAC_SERDES_CNTL_TBI_LBK);
	eval 'sub BNX_EMAC_SERDES_CNTL_REMOTE_LBK () {(1<<18);}' unless defined(&BNX_EMAC_SERDES_CNTL_REMOTE_LBK);
	eval 'sub BNX_EMAC_SERDES_CNTL_REV_PHASE () {(1<<19);}' unless defined(&BNX_EMAC_SERDES_CNTL_REV_PHASE);
	eval 'sub BNX_EMAC_SERDES_CNTL_REGCTL12 () {(0x3<<20);}' unless defined(&BNX_EMAC_SERDES_CNTL_REGCTL12);
	eval 'sub BNX_EMAC_SERDES_CNTL_REGCTL25 () {(0x3<<22);}' unless defined(&BNX_EMAC_SERDES_CNTL_REGCTL25);
	eval 'sub BNX_EMAC_SERDES_STATUS () {0x14a8;}' unless defined(&BNX_EMAC_SERDES_STATUS);
	eval 'sub BNX_EMAC_SERDES_STATUS_RX_STAT () {(0xff<<0);}' unless defined(&BNX_EMAC_SERDES_STATUS_RX_STAT);
	eval 'sub BNX_EMAC_SERDES_STATUS_COMMA_DET () {(1<<8);}' unless defined(&BNX_EMAC_SERDES_STATUS_COMMA_DET);
	eval 'sub BNX_EMAC_MDIO_COMM () {0x14ac;}' unless defined(&BNX_EMAC_MDIO_COMM);
	eval 'sub BNX_EMAC_MDIO_COMM_DATA () {(0xffff<<0);}' unless defined(&BNX_EMAC_MDIO_COMM_DATA);
	eval 'sub BNX_EMAC_MDIO_COMM_REG_ADDR () {(0x1f<<16);}' unless defined(&BNX_EMAC_MDIO_COMM_REG_ADDR);
	eval 'sub BNX_EMAC_MDIO_COMM_PHY_ADDR () {(0x1f<<21);}' unless defined(&BNX_EMAC_MDIO_COMM_PHY_ADDR);
	eval 'sub BNX_EMAC_MDIO_COMM_COMMAND () {(0x3<<26);}' unless defined(&BNX_EMAC_MDIO_COMM_COMMAND);
	eval 'sub BNX_EMAC_MDIO_COMM_COMMAND_UNDEFINED_0 () {(0<<26);}' unless defined(&BNX_EMAC_MDIO_COMM_COMMAND_UNDEFINED_0);
	eval 'sub BNX_EMAC_MDIO_COMM_COMMAND_WRITE () {(1<<26);}' unless defined(&BNX_EMAC_MDIO_COMM_COMMAND_WRITE);
	eval 'sub BNX_EMAC_MDIO_COMM_COMMAND_READ () {(2<<26);}' unless defined(&BNX_EMAC_MDIO_COMM_COMMAND_READ);
	eval 'sub BNX_EMAC_MDIO_COMM_COMMAND_UNDEFINED_3 () {(3<<26);}' unless defined(&BNX_EMAC_MDIO_COMM_COMMAND_UNDEFINED_3);
	eval 'sub BNX_EMAC_MDIO_COMM_FAIL () {(1<<28);}' unless defined(&BNX_EMAC_MDIO_COMM_FAIL);
	eval 'sub BNX_EMAC_MDIO_COMM_START_BUSY () {(1<<29);}' unless defined(&BNX_EMAC_MDIO_COMM_START_BUSY);
	eval 'sub BNX_EMAC_MDIO_COMM_DISEXT () {(1<<30);}' unless defined(&BNX_EMAC_MDIO_COMM_DISEXT);
	eval 'sub BNX_EMAC_MDIO_STATUS () {0x14b0;}' unless defined(&BNX_EMAC_MDIO_STATUS);
	eval 'sub BNX_EMAC_MDIO_STATUS_LINK () {(1<<0);}' unless defined(&BNX_EMAC_MDIO_STATUS_LINK);
	eval 'sub BNX_EMAC_MDIO_STATUS_10MB () {(1<<1);}' unless defined(&BNX_EMAC_MDIO_STATUS_10MB);
	eval 'sub BNX_EMAC_MDIO_MODE () {0x14b4;}' unless defined(&BNX_EMAC_MDIO_MODE);
	eval 'sub BNX_EMAC_MDIO_MODE_SHORT_PREAMBLE () {(1<<1);}' unless defined(&BNX_EMAC_MDIO_MODE_SHORT_PREAMBLE);
	eval 'sub BNX_EMAC_MDIO_MODE_AUTO_POLL () {(1<<4);}' unless defined(&BNX_EMAC_MDIO_MODE_AUTO_POLL);
	eval 'sub BNX_EMAC_MDIO_MODE_BIT_BANG () {(1<<8);}' unless defined(&BNX_EMAC_MDIO_MODE_BIT_BANG);
	eval 'sub BNX_EMAC_MDIO_MODE_MDIO () {(1<<9);}' unless defined(&BNX_EMAC_MDIO_MODE_MDIO);
	eval 'sub BNX_EMAC_MDIO_MODE_MDIO_OE () {(1<<10);}' unless defined(&BNX_EMAC_MDIO_MODE_MDIO_OE);
	eval 'sub BNX_EMAC_MDIO_MODE_MDC () {(1<<11);}' unless defined(&BNX_EMAC_MDIO_MODE_MDC);
	eval 'sub BNX_EMAC_MDIO_MODE_MDINT () {(1<<12);}' unless defined(&BNX_EMAC_MDIO_MODE_MDINT);
	eval 'sub BNX_EMAC_MDIO_MODE_CLOCK_CNT () {(0x1f<<16);}' unless defined(&BNX_EMAC_MDIO_MODE_CLOCK_CNT);
	eval 'sub BNX_EMAC_MDIO_AUTO_STATUS () {0x14b8;}' unless defined(&BNX_EMAC_MDIO_AUTO_STATUS);
	eval 'sub BNX_EMAC_MDIO_AUTO_STATUS_AUTO_ERR () {(1<<0);}' unless defined(&BNX_EMAC_MDIO_AUTO_STATUS_AUTO_ERR);
	eval 'sub BNX_EMAC_TX_MODE () {0x14bc;}' unless defined(&BNX_EMAC_TX_MODE);
	eval 'sub BNX_EMAC_TX_MODE_RESET () {(1<<0);}' unless defined(&BNX_EMAC_TX_MODE_RESET);
	eval 'sub BNX_EMAC_TX_MODE_EXT_PAUSE_EN () {(1<<3);}' unless defined(&BNX_EMAC_TX_MODE_EXT_PAUSE_EN);
	eval 'sub BNX_EMAC_TX_MODE_FLOW_EN () {(1<<4);}' unless defined(&BNX_EMAC_TX_MODE_FLOW_EN);
	eval 'sub BNX_EMAC_TX_MODE_BIG_BACKOFF () {(1<<5);}' unless defined(&BNX_EMAC_TX_MODE_BIG_BACKOFF);
	eval 'sub BNX_EMAC_TX_MODE_LONG_PAUSE () {(1<<6);}' unless defined(&BNX_EMAC_TX_MODE_LONG_PAUSE);
	eval 'sub BNX_EMAC_TX_MODE_LINK_AWARE () {(1<<7);}' unless defined(&BNX_EMAC_TX_MODE_LINK_AWARE);
	eval 'sub BNX_EMAC_TX_STATUS () {0x14c0;}' unless defined(&BNX_EMAC_TX_STATUS);
	eval 'sub BNX_EMAC_TX_STATUS_XOFFED () {(1<<0);}' unless defined(&BNX_EMAC_TX_STATUS_XOFFED);
	eval 'sub BNX_EMAC_TX_STATUS_XOFF_SENT () {(1<<1);}' unless defined(&BNX_EMAC_TX_STATUS_XOFF_SENT);
	eval 'sub BNX_EMAC_TX_STATUS_XON_SENT () {(1<<2);}' unless defined(&BNX_EMAC_TX_STATUS_XON_SENT);
	eval 'sub BNX_EMAC_TX_STATUS_LINK_UP () {(1<<3);}' unless defined(&BNX_EMAC_TX_STATUS_LINK_UP);
	eval 'sub BNX_EMAC_TX_STATUS_UNDERRUN () {(1<<4);}' unless defined(&BNX_EMAC_TX_STATUS_UNDERRUN);
	eval 'sub BNX_EMAC_TX_LENGTHS () {0x14c4;}' unless defined(&BNX_EMAC_TX_LENGTHS);
	eval 'sub BNX_EMAC_TX_LENGTHS_SLOT () {(0xff<<0);}' unless defined(&BNX_EMAC_TX_LENGTHS_SLOT);
	eval 'sub BNX_EMAC_TX_LENGTHS_IPG () {(0xf<<8);}' unless defined(&BNX_EMAC_TX_LENGTHS_IPG);
	eval 'sub BNX_EMAC_TX_LENGTHS_IPG_CRS () {(0x3<<12);}' unless defined(&BNX_EMAC_TX_LENGTHS_IPG_CRS);
	eval 'sub BNX_EMAC_RX_MODE () {0x14c8;}' unless defined(&BNX_EMAC_RX_MODE);
	eval 'sub BNX_EMAC_RX_MODE_RESET () {(1<<0);}' unless defined(&BNX_EMAC_RX_MODE_RESET);
	eval 'sub BNX_EMAC_RX_MODE_FLOW_EN () {(1<<2);}' unless defined(&BNX_EMAC_RX_MODE_FLOW_EN);
	eval 'sub BNX_EMAC_RX_MODE_KEEP_MAC_CONTROL () {(1<<3);}' unless defined(&BNX_EMAC_RX_MODE_KEEP_MAC_CONTROL);
	eval 'sub BNX_EMAC_RX_MODE_KEEP_PAUSE () {(1<<4);}' unless defined(&BNX_EMAC_RX_MODE_KEEP_PAUSE);
	eval 'sub BNX_EMAC_RX_MODE_ACCEPT_OVERSIZE () {(1<<5);}' unless defined(&BNX_EMAC_RX_MODE_ACCEPT_OVERSIZE);
	eval 'sub BNX_EMAC_RX_MODE_ACCEPT_RUNTS () {(1<<6);}' unless defined(&BNX_EMAC_RX_MODE_ACCEPT_RUNTS);
	eval 'sub BNX_EMAC_RX_MODE_LLC_CHK () {(1<<7);}' unless defined(&BNX_EMAC_RX_MODE_LLC_CHK);
	eval 'sub BNX_EMAC_RX_MODE_PROMISCUOUS () {(1<<8);}' unless defined(&BNX_EMAC_RX_MODE_PROMISCUOUS);
	eval 'sub BNX_EMAC_RX_MODE_NO_CRC_CHK () {(1<<9);}' unless defined(&BNX_EMAC_RX_MODE_NO_CRC_CHK);
	eval 'sub BNX_EMAC_RX_MODE_KEEP_VLAN_TAG () {(1<<10);}' unless defined(&BNX_EMAC_RX_MODE_KEEP_VLAN_TAG);
	eval 'sub BNX_EMAC_RX_MODE_FILT_BROADCAST () {(1<<11);}' unless defined(&BNX_EMAC_RX_MODE_FILT_BROADCAST);
	eval 'sub BNX_EMAC_RX_MODE_SORT_MODE () {(1<<12);}' unless defined(&BNX_EMAC_RX_MODE_SORT_MODE);
	eval 'sub BNX_EMAC_RX_STATUS () {0x14cc;}' unless defined(&BNX_EMAC_RX_STATUS);
	eval 'sub BNX_EMAC_RX_STATUS_FFED () {(1<<0);}' unless defined(&BNX_EMAC_RX_STATUS_FFED);
	eval 'sub BNX_EMAC_RX_STATUS_FF_RECEIVED () {(1<<1);}' unless defined(&BNX_EMAC_RX_STATUS_FF_RECEIVED);
	eval 'sub BNX_EMAC_RX_STATUS_N_RECEIVED () {(1<<2);}' unless defined(&BNX_EMAC_RX_STATUS_N_RECEIVED);
	eval 'sub BNX_EMAC_MULTICAST_HASH0 () {0x14d0;}' unless defined(&BNX_EMAC_MULTICAST_HASH0);
	eval 'sub BNX_EMAC_MULTICAST_HASH1 () {0x14d4;}' unless defined(&BNX_EMAC_MULTICAST_HASH1);
	eval 'sub BNX_EMAC_MULTICAST_HASH2 () {0x14d8;}' unless defined(&BNX_EMAC_MULTICAST_HASH2);
	eval 'sub BNX_EMAC_MULTICAST_HASH3 () {0x14dc;}' unless defined(&BNX_EMAC_MULTICAST_HASH3);
	eval 'sub BNX_EMAC_MULTICAST_HASH4 () {0x14e0;}' unless defined(&BNX_EMAC_MULTICAST_HASH4);
	eval 'sub BNX_EMAC_MULTICAST_HASH5 () {0x14e4;}' unless defined(&BNX_EMAC_MULTICAST_HASH5);
	eval 'sub BNX_EMAC_MULTICAST_HASH6 () {0x14e8;}' unless defined(&BNX_EMAC_MULTICAST_HASH6);
	eval 'sub BNX_EMAC_MULTICAST_HASH7 () {0x14ec;}' unless defined(&BNX_EMAC_MULTICAST_HASH7);
	eval 'sub BNX_EMAC_RX_STAT_IFHCINOCTETS () {0x1500;}' unless defined(&BNX_EMAC_RX_STAT_IFHCINOCTETS);
	eval 'sub BNX_EMAC_RX_STAT_IFHCINBADOCTETS () {0x1504;}' unless defined(&BNX_EMAC_RX_STAT_IFHCINBADOCTETS);
	eval 'sub BNX_EMAC_RX_STAT_ETHERSTATSFRAGMENTS () {0x1508;}' unless defined(&BNX_EMAC_RX_STAT_ETHERSTATSFRAGMENTS);
	eval 'sub BNX_EMAC_RX_STAT_IFHCINUCASTPKTS () {0x150c;}' unless defined(&BNX_EMAC_RX_STAT_IFHCINUCASTPKTS);
	eval 'sub BNX_EMAC_RX_STAT_IFHCINMULTICASTPKTS () {0x1510;}' unless defined(&BNX_EMAC_RX_STAT_IFHCINMULTICASTPKTS);
	eval 'sub BNX_EMAC_RX_STAT_IFHCINBROADCASTPKTS () {0x1514;}' unless defined(&BNX_EMAC_RX_STAT_IFHCINBROADCASTPKTS);
	eval 'sub BNX_EMAC_RX_STAT_DOT3STATSFCSERRORS () {0x1518;}' unless defined(&BNX_EMAC_RX_STAT_DOT3STATSFCSERRORS);
	eval 'sub BNX_EMAC_RX_STAT_DOT3STATSALIGNMENTERRORS () {0x151c;}' unless defined(&BNX_EMAC_RX_STAT_DOT3STATSALIGNMENTERRORS);
	eval 'sub BNX_EMAC_RX_STAT_DOT3STATSCARRIERSENSEERRORS () {0x1520;}' unless defined(&BNX_EMAC_RX_STAT_DOT3STATSCARRIERSENSEERRORS);
	eval 'sub BNX_EMAC_RX_STAT_XONPAUSEFRAMESRECEIVED () {0x1524;}' unless defined(&BNX_EMAC_RX_STAT_XONPAUSEFRAMESRECEIVED);
	eval 'sub BNX_EMAC_RX_STAT_XOFFPAUSEFRAMESRECEIVED () {0x1528;}' unless defined(&BNX_EMAC_RX_STAT_XOFFPAUSEFRAMESRECEIVED);
	eval 'sub BNX_EMAC_RX_STAT_MACCONTROLFRAMESRECEIVED () {0x152c;}' unless defined(&BNX_EMAC_RX_STAT_MACCONTROLFRAMESRECEIVED);
	eval 'sub BNX_EMAC_RX_STAT_XOFFSTATEENTERED () {0x1530;}' unless defined(&BNX_EMAC_RX_STAT_XOFFSTATEENTERED);
	eval 'sub BNX_EMAC_RX_STAT_DOT3STATSFRAMESTOOLONG () {0x1534;}' unless defined(&BNX_EMAC_RX_STAT_DOT3STATSFRAMESTOOLONG);
	eval 'sub BNX_EMAC_RX_STAT_ETHERSTATSJABBERS () {0x1538;}' unless defined(&BNX_EMAC_RX_STAT_ETHERSTATSJABBERS);
	eval 'sub BNX_EMAC_RX_STAT_ETHERSTATSUNDERSIZEPKTS () {0x153c;}' unless defined(&BNX_EMAC_RX_STAT_ETHERSTATSUNDERSIZEPKTS);
	eval 'sub BNX_EMAC_RX_STAT_ETHERSTATSPKTS64OCTETS () {0x1540;}' unless defined(&BNX_EMAC_RX_STAT_ETHERSTATSPKTS64OCTETS);
	eval 'sub BNX_EMAC_RX_STAT_ETHERSTATSPKTS65OCTETSTO127OCTETS () {0x1544;}' unless defined(&BNX_EMAC_RX_STAT_ETHERSTATSPKTS65OCTETSTO127OCTETS);
	eval 'sub BNX_EMAC_RX_STAT_ETHERSTATSPKTS128OCTETSTO255OCTETS () {0x1548;}' unless defined(&BNX_EMAC_RX_STAT_ETHERSTATSPKTS128OCTETSTO255OCTETS);
	eval 'sub BNX_EMAC_RX_STAT_ETHERSTATSPKTS256OCTETSTO511OCTETS () {0x154c;}' unless defined(&BNX_EMAC_RX_STAT_ETHERSTATSPKTS256OCTETSTO511OCTETS);
	eval 'sub BNX_EMAC_RX_STAT_ETHERSTATSPKTS512OCTETSTO1023OCTETS () {0x1550;}' unless defined(&BNX_EMAC_RX_STAT_ETHERSTATSPKTS512OCTETSTO1023OCTETS);
	eval 'sub BNX_EMAC_RX_STAT_ETHERSTATSPKTS1024OCTETSTO1522OCTETS () {0x1554;}' unless defined(&BNX_EMAC_RX_STAT_ETHERSTATSPKTS1024OCTETSTO1522OCTETS);
	eval 'sub BNX_EMAC_RX_STAT_ETHERSTATSPKTS1523OCTETSTO9022OCTETS () {0x1558;}' unless defined(&BNX_EMAC_RX_STAT_ETHERSTATSPKTS1523OCTETSTO9022OCTETS);
	eval 'sub BNX_EMAC_RXMAC_DEBUG0 () {0x155c;}' unless defined(&BNX_EMAC_RXMAC_DEBUG0);
	eval 'sub BNX_EMAC_RXMAC_DEBUG1 () {0x1560;}' unless defined(&BNX_EMAC_RXMAC_DEBUG1);
	eval 'sub BNX_EMAC_RXMAC_DEBUG1_LENGTH_NE_BYTE_COUNT () {(1<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG1_LENGTH_NE_BYTE_COUNT);
	eval 'sub BNX_EMAC_RXMAC_DEBUG1_LENGTH_OUT_RANGE () {(1<<1);}' unless defined(&BNX_EMAC_RXMAC_DEBUG1_LENGTH_OUT_RANGE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG1_BAD_CRC () {(1<<2);}' unless defined(&BNX_EMAC_RXMAC_DEBUG1_BAD_CRC);
	eval 'sub BNX_EMAC_RXMAC_DEBUG1_RX_ERROR () {(1<<3);}' unless defined(&BNX_EMAC_RXMAC_DEBUG1_RX_ERROR);
	eval 'sub BNX_EMAC_RXMAC_DEBUG1_ALIGN_ERROR () {(1<<4);}' unless defined(&BNX_EMAC_RXMAC_DEBUG1_ALIGN_ERROR);
	eval 'sub BNX_EMAC_RXMAC_DEBUG1_LAST_DATA () {(1<<5);}' unless defined(&BNX_EMAC_RXMAC_DEBUG1_LAST_DATA);
	eval 'sub BNX_EMAC_RXMAC_DEBUG1_ODD_BYTE_START () {(1<<6);}' unless defined(&BNX_EMAC_RXMAC_DEBUG1_ODD_BYTE_START);
	eval 'sub BNX_EMAC_RXMAC_DEBUG1_BYTE_COUNT () {(0xffff<<7);}' unless defined(&BNX_EMAC_RXMAC_DEBUG1_BYTE_COUNT);
	eval 'sub BNX_EMAC_RXMAC_DEBUG1_SLOT_TIME () {(0xff<<23);}' unless defined(&BNX_EMAC_RXMAC_DEBUG1_SLOT_TIME);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2 () {0x1564;}' unless defined(&BNX_EMAC_RXMAC_DEBUG2);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_SM_STATE () {(0x7<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_SM_STATE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_SM_STATE_IDLE () {(0x<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_SM_STATE_IDLE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_SM_STATE_SFD () {(0x1<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_SM_STATE_SFD);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_SM_STATE_DATA () {(0x2<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_SM_STATE_DATA);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_SM_STATE_SKEEP () {(0x3<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_SM_STATE_SKEEP);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_SM_STATE_EXT () {(0x4<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_SM_STATE_EXT);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_SM_STATE_DROP () {(0x5<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_SM_STATE_DROP);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_SM_STATE_SDROP () {(0x6<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_SM_STATE_SDROP);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_SM_STATE_FC () {(0x7<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_SM_STATE_FC);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_IDI_STATE () {(0xf<<3);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_IDI_STATE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_IDI_STATE_IDLE () {(0x<<3);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_IDI_STATE_IDLE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_IDI_STATE_DATA0 () {(0x1<<3);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_IDI_STATE_DATA0);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_IDI_STATE_DATA1 () {(0x2<<3);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_IDI_STATE_DATA1);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_IDI_STATE_DATA2 () {(0x3<<3);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_IDI_STATE_DATA2);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_IDI_STATE_DATA3 () {(0x4<<3);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_IDI_STATE_DATA3);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_IDI_STATE_ABORT () {(0x5<<3);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_IDI_STATE_ABORT);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_IDI_STATE_WAIT () {(0x6<<3);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_IDI_STATE_WAIT);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_IDI_STATE_STATUS () {(0x7<<3);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_IDI_STATE_STATUS);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_IDI_STATE_LAST () {(0x8<<3);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_IDI_STATE_LAST);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_BYTE_IN () {(0xff<<7);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_BYTE_IN);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_FALSEC () {(1<<15);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_FALSEC);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_TAGGED () {(1<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_TAGGED);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_PAUSE_STATE () {(1<<18);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_PAUSE_STATE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_PAUSE_STATE_IDLE () {(0<<18);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_PAUSE_STATE_IDLE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_PAUSE_STATE_PAUSED () {(1<<18);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_PAUSE_STATE_PAUSED);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_SE_COUNTER () {(0xf<<19);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_SE_COUNTER);
	eval 'sub BNX_EMAC_RXMAC_DEBUG2_QUANTA () {(0x1f<<23);}' unless defined(&BNX_EMAC_RXMAC_DEBUG2_QUANTA);
	eval 'sub BNX_EMAC_RXMAC_DEBUG3 () {0x1568;}' unless defined(&BNX_EMAC_RXMAC_DEBUG3);
	eval 'sub BNX_EMAC_RXMAC_DEBUG3_PAUSE_CTR () {(0xffff<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG3_PAUSE_CTR);
	eval 'sub BNX_EMAC_RXMAC_DEBUG3_TMP_PAUSE_CTR () {(0xffff<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG3_TMP_PAUSE_CTR);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4 () {0x156c;}' unless defined(&BNX_EMAC_RXMAC_DEBUG4);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_TYPE_FIELD () {(0xffff<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_TYPE_FIELD);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE () {(0x3f<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_IDLE () {(0x<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_IDLE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_UMAC2 () {(0x1<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_UMAC2);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_UMAC3 () {(0x2<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_UMAC3);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_UNI () {(0x3<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_UNI);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MMAC2 () {(0x7<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MMAC2);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MMAC3 () {(0x5<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MMAC3);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_PSA1 () {(0x6<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_PSA1);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_PSA2 () {(0x7<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_PSA2);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_PSA3 () {(0x8<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_PSA3);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MC2 () {(0x9<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MC2);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MC3 () {(0xa<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MC3);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MWAIT1 () {(0xe<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MWAIT1);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MWAIT2 () {(0xf<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MWAIT2);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MCHECK () {(0x10<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MCHECK);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MC () {(0x11<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MC);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_BC2 () {(0x12<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_BC2);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_BC3 () {(0x13<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_BC3);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_BSA1 () {(0x14<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_BSA1);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_BSA2 () {(0x15<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_BSA2);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_BSA3 () {(0x16<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_BSA3);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_BTYPE () {(0x17<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_BTYPE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_BC () {(0x18<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_BC);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_PTYPE () {(0x19<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_PTYPE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_CMD () {(0x1a<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_CMD);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MAC () {(0x1b<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MAC);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_LATCH () {(0x1c<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_LATCH);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_XOFF () {(0x1d<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_XOFF);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_XON () {(0x1e<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_XON);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_PAUSED () {(0x1f<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_PAUSED);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_NPAUSED () {(0x20<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_NPAUSED);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_TTYPE () {(0x21<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_TTYPE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_TVAL () {(0x22<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_TVAL);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_USA1 () {(0x23<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_USA1);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_USA2 () {(0x24<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_USA2);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_USA3 () {(0x25<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_USA3);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_UTYPE () {(0x26<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_UTYPE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_UTTYPE () {(0x27<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_UTTYPE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_UTVAL () {(0x28<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_UTVAL);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MTYPE () {(0x29<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_MTYPE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_DROP () {(0x2a<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FILT_STATE_DROP);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_DROP_PKT () {(1<<22);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_DROP_PKT);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_SLOT_FILLED () {(1<<23);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_SLOT_FILLED);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_FALSE_CARRIER () {(1<<24);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_FALSE_CARRIER);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_LAST_DATA () {(1<<25);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_LAST_DATA);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_sfd_FOUND () {(1<<26);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_sfd_FOUND);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_ADVANCE () {(1<<27);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_ADVANCE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG4_START () {(1<<28);}' unless defined(&BNX_EMAC_RXMAC_DEBUG4_START);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5 () {0x1570;}' unless defined(&BNX_EMAC_RXMAC_DEBUG5);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_PS_IDISM () {(0x7<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_PS_IDISM);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_PS_IDISM_IDLE () {(0<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_PS_IDISM_IDLE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_PS_IDISM_WAIT_EOF () {(1<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_PS_IDISM_WAIT_EOF);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_PS_IDISM_WAIT_STAT () {(2<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_PS_IDISM_WAIT_STAT);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_PS_IDISM_SET_EOF4FCRC () {(3<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_PS_IDISM_SET_EOF4FCRC);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_PS_IDISM_SET_EOF4RDE () {(4<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_PS_IDISM_SET_EOF4RDE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_PS_IDISM_SET_EOF4ALL () {(5<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_PS_IDISM_SET_EOF4ALL);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_PS_IDISM_1WD_WAIT_STAT () {(6<<0);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_PS_IDISM_1WD_WAIT_STAT);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_CCODE_BUF1 () {(0x7<<4);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_CCODE_BUF1);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_CCODE_BUF1_VDW () {(0x<<4);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_CCODE_BUF1_VDW);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_CCODE_BUF1_STAT () {(0x1<<4);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_CCODE_BUF1_STAT);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_CCODE_BUF1_AEOF () {(0x2<<4);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_CCODE_BUF1_AEOF);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_CCODE_BUF1_NEOF () {(0x3<<4);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_CCODE_BUF1_NEOF);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_CCODE_BUF1_SOF () {(0x4<<4);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_CCODE_BUF1_SOF);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_CCODE_BUF1_SAEOF () {(0x6<<4);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_CCODE_BUF1_SAEOF);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_CCODE_BUF1_SNEOF () {(0x7<<4);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_CCODE_BUF1_SNEOF);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_EOF_DETECTED () {(1<<7);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_EOF_DETECTED);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_CCODE_BUF0 () {(0x7<<8);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_CCODE_BUF0);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_RPM_IDI_FIFO_FULL () {(1<<11);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_RPM_IDI_FIFO_FULL);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_LOAD_CCODE () {(1<<12);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_LOAD_CCODE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_LOAD_DATA () {(1<<13);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_LOAD_DATA);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_LOAD_STAT () {(1<<14);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_LOAD_STAT);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_CLR_STAT () {(1<<15);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_CLR_STAT);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_IDI_RPM_CCODE () {(0x3<<16);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_IDI_RPM_CCODE);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_IDI_RPM_ACCEPT () {(1<<19);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_IDI_RPM_ACCEPT);
	eval 'sub BNX_EMAC_RXMAC_DEBUG5_FMLEN () {(0xfff<<20);}' unless defined(&BNX_EMAC_RXMAC_DEBUG5_FMLEN);
	eval 'sub BNX_EMAC_RX_STAT_AC0 () {0x1580;}' unless defined(&BNX_EMAC_RX_STAT_AC0);
	eval 'sub BNX_EMAC_RX_STAT_AC1 () {0x1584;}' unless defined(&BNX_EMAC_RX_STAT_AC1);
	eval 'sub BNX_EMAC_RX_STAT_AC2 () {0x1588;}' unless defined(&BNX_EMAC_RX_STAT_AC2);
	eval 'sub BNX_EMAC_RX_STAT_AC3 () {0x158c;}' unless defined(&BNX_EMAC_RX_STAT_AC3);
	eval 'sub BNX_EMAC_RX_STAT_AC4 () {0x1590;}' unless defined(&BNX_EMAC_RX_STAT_AC4);
	eval 'sub BNX_EMAC_RX_STAT_AC5 () {0x1594;}' unless defined(&BNX_EMAC_RX_STAT_AC5);
	eval 'sub BNX_EMAC_RX_STAT_AC6 () {0x1598;}' unless defined(&BNX_EMAC_RX_STAT_AC6);
	eval 'sub BNX_EMAC_RX_STAT_AC7 () {0x159c;}' unless defined(&BNX_EMAC_RX_STAT_AC7);
	eval 'sub BNX_EMAC_RX_STAT_AC8 () {0x15a0;}' unless defined(&BNX_EMAC_RX_STAT_AC8);
	eval 'sub BNX_EMAC_RX_STAT_AC9 () {0x15a4;}' unless defined(&BNX_EMAC_RX_STAT_AC9);
	eval 'sub BNX_EMAC_RX_STAT_AC10 () {0x15a8;}' unless defined(&BNX_EMAC_RX_STAT_AC10);
	eval 'sub BNX_EMAC_RX_STAT_AC11 () {0x15ac;}' unless defined(&BNX_EMAC_RX_STAT_AC11);
	eval 'sub BNX_EMAC_RX_STAT_AC12 () {0x15b0;}' unless defined(&BNX_EMAC_RX_STAT_AC12);
	eval 'sub BNX_EMAC_RX_STAT_AC13 () {0x15b4;}' unless defined(&BNX_EMAC_RX_STAT_AC13);
	eval 'sub BNX_EMAC_RX_STAT_AC14 () {0x15b8;}' unless defined(&BNX_EMAC_RX_STAT_AC14);
	eval 'sub BNX_EMAC_RX_STAT_AC15 () {0x15bc;}' unless defined(&BNX_EMAC_RX_STAT_AC15);
	eval 'sub BNX_EMAC_RX_STAT_AC16 () {0x15c0;}' unless defined(&BNX_EMAC_RX_STAT_AC16);
	eval 'sub BNX_EMAC_RX_STAT_AC17 () {0x15c4;}' unless defined(&BNX_EMAC_RX_STAT_AC17);
	eval 'sub BNX_EMAC_RX_STAT_AC18 () {0x15c8;}' unless defined(&BNX_EMAC_RX_STAT_AC18);
	eval 'sub BNX_EMAC_RX_STAT_AC19 () {0x15cc;}' unless defined(&BNX_EMAC_RX_STAT_AC19);
	eval 'sub BNX_EMAC_RX_STAT_AC20 () {0x15d0;}' unless defined(&BNX_EMAC_RX_STAT_AC20);
	eval 'sub BNX_EMAC_RX_STAT_AC21 () {0x15d4;}' unless defined(&BNX_EMAC_RX_STAT_AC21);
	eval 'sub BNX_EMAC_RX_STAT_AC22 () {0x15d8;}' unless defined(&BNX_EMAC_RX_STAT_AC22);
	eval 'sub BNX_EMAC_RXMAC_SUC_DBG_OVERRUNVEC () {0x15dc;}' unless defined(&BNX_EMAC_RXMAC_SUC_DBG_OVERRUNVEC);
	eval 'sub BNX_EMAC_TX_STAT_IFHCOUTOCTETS () {0x1600;}' unless defined(&BNX_EMAC_TX_STAT_IFHCOUTOCTETS);
	eval 'sub BNX_EMAC_TX_STAT_IFHCOUTBADOCTETS () {0x1604;}' unless defined(&BNX_EMAC_TX_STAT_IFHCOUTBADOCTETS);
	eval 'sub BNX_EMAC_TX_STAT_ETHERSTATSCOLLISIONS () {0x1608;}' unless defined(&BNX_EMAC_TX_STAT_ETHERSTATSCOLLISIONS);
	eval 'sub BNX_EMAC_TX_STAT_OUTXONSENT () {0x160c;}' unless defined(&BNX_EMAC_TX_STAT_OUTXONSENT);
	eval 'sub BNX_EMAC_TX_STAT_OUTXOFFSENT () {0x1610;}' unless defined(&BNX_EMAC_TX_STAT_OUTXOFFSENT);
	eval 'sub BNX_EMAC_TX_STAT_FLOWCONTROLDONE () {0x1614;}' unless defined(&BNX_EMAC_TX_STAT_FLOWCONTROLDONE);
	eval 'sub BNX_EMAC_TX_STAT_DOT3STATSSINGLECOLLISIONFRAMES () {0x1618;}' unless defined(&BNX_EMAC_TX_STAT_DOT3STATSSINGLECOLLISIONFRAMES);
	eval 'sub BNX_EMAC_TX_STAT_DOT3STATSMULTIPLECOLLISIONFRAMES () {0x161c;}' unless defined(&BNX_EMAC_TX_STAT_DOT3STATSMULTIPLECOLLISIONFRAMES);
	eval 'sub BNX_EMAC_TX_STAT_DOT3STATSDEFERREDTRANSMISSIONS () {0x1620;}' unless defined(&BNX_EMAC_TX_STAT_DOT3STATSDEFERREDTRANSMISSIONS);
	eval 'sub BNX_EMAC_TX_STAT_DOT3STATSEXCESSIVECOLLISIONS () {0x1624;}' unless defined(&BNX_EMAC_TX_STAT_DOT3STATSEXCESSIVECOLLISIONS);
	eval 'sub BNX_EMAC_TX_STAT_DOT3STATSLATECOLLISIONS () {0x1628;}' unless defined(&BNX_EMAC_TX_STAT_DOT3STATSLATECOLLISIONS);
	eval 'sub BNX_EMAC_TX_STAT_IFHCOUTUCASTPKTS () {0x162c;}' unless defined(&BNX_EMAC_TX_STAT_IFHCOUTUCASTPKTS);
	eval 'sub BNX_EMAC_TX_STAT_IFHCOUTMULTICASTPKTS () {0x1630;}' unless defined(&BNX_EMAC_TX_STAT_IFHCOUTMULTICASTPKTS);
	eval 'sub BNX_EMAC_TX_STAT_IFHCOUTBROADCASTPKTS () {0x1634;}' unless defined(&BNX_EMAC_TX_STAT_IFHCOUTBROADCASTPKTS);
	eval 'sub BNX_EMAC_TX_STAT_ETHERSTATSPKTS64OCTETS () {0x1638;}' unless defined(&BNX_EMAC_TX_STAT_ETHERSTATSPKTS64OCTETS);
	eval 'sub BNX_EMAC_TX_STAT_ETHERSTATSPKTS65OCTETSTO127OCTETS () {0x163c;}' unless defined(&BNX_EMAC_TX_STAT_ETHERSTATSPKTS65OCTETSTO127OCTETS);
	eval 'sub BNX_EMAC_TX_STAT_ETHERSTATSPKTS128OCTETSTO255OCTETS () {0x1640;}' unless defined(&BNX_EMAC_TX_STAT_ETHERSTATSPKTS128OCTETSTO255OCTETS);
	eval 'sub BNX_EMAC_TX_STAT_ETHERSTATSPKTS256OCTETSTO511OCTETS () {0x1644;}' unless defined(&BNX_EMAC_TX_STAT_ETHERSTATSPKTS256OCTETSTO511OCTETS);
	eval 'sub BNX_EMAC_TX_STAT_ETHERSTATSPKTS512OCTETSTO1023OCTETS () {0x1648;}' unless defined(&BNX_EMAC_TX_STAT_ETHERSTATSPKTS512OCTETSTO1023OCTETS);
	eval 'sub BNX_EMAC_TX_STAT_ETHERSTATSPKTS1024OCTETSTO1522OCTETS () {0x164c;}' unless defined(&BNX_EMAC_TX_STAT_ETHERSTATSPKTS1024OCTETSTO1522OCTETS);
	eval 'sub BNX_EMAC_TX_STAT_ETHERSTATSPKTS1523OCTETSTO9022OCTETS () {0x1650;}' unless defined(&BNX_EMAC_TX_STAT_ETHERSTATSPKTS1523OCTETSTO9022OCTETS);
	eval 'sub BNX_EMAC_TX_STAT_DOT3STATSINTERNALMACTRANSMITERRORS () {0x1654;}' unless defined(&BNX_EMAC_TX_STAT_DOT3STATSINTERNALMACTRANSMITERRORS);
	eval 'sub BNX_EMAC_TXMAC_DEBUG0 () {0x1658;}' unless defined(&BNX_EMAC_TXMAC_DEBUG0);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1 () {0x165c;}' unless defined(&BNX_EMAC_TXMAC_DEBUG1);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_ODI_STATE () {(0xf<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_ODI_STATE);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_ODI_STATE_IDLE () {(0x<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_ODI_STATE_IDLE);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_ODI_STATE_START0 () {(0x1<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_ODI_STATE_START0);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_ODI_STATE_DATA0 () {(0x4<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_ODI_STATE_DATA0);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_ODI_STATE_DATA1 () {(0x5<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_ODI_STATE_DATA1);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_ODI_STATE_DATA2 () {(0x6<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_ODI_STATE_DATA2);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_ODI_STATE_DATA3 () {(0x7<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_ODI_STATE_DATA3);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_ODI_STATE_WAIT0 () {(0x8<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_ODI_STATE_WAIT0);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_ODI_STATE_WAIT1 () {(0x9<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_ODI_STATE_WAIT1);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_CRS_ENABLE () {(1<<4);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_CRS_ENABLE);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_BAD_CRC () {(1<<5);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_BAD_CRC);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_SE_COUNTER () {(0xf<<6);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_SE_COUNTER);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_SEND_PAUSE () {(1<<10);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_SEND_PAUSE);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_LATE_COLLISION () {(1<<11);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_LATE_COLLISION);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_MAX_DEFER () {(1<<12);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_MAX_DEFER);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_DEFERRED () {(1<<13);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_DEFERRED);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_ONE_BYTE () {(1<<14);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_ONE_BYTE);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_IPG_TIME () {(0xf<<15);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_IPG_TIME);
	eval 'sub BNX_EMAC_TXMAC_DEBUG1_SLOT_TIME () {(0xff<<19);}' unless defined(&BNX_EMAC_TXMAC_DEBUG1_SLOT_TIME);
	eval 'sub BNX_EMAC_TXMAC_DEBUG2 () {0x1660;}' unless defined(&BNX_EMAC_TXMAC_DEBUG2);
	eval 'sub BNX_EMAC_TXMAC_DEBUG2_BACK_OFF () {(0x3ff<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG2_BACK_OFF);
	eval 'sub BNX_EMAC_TXMAC_DEBUG2_BYTE_COUNT () {(0xffff<<10);}' unless defined(&BNX_EMAC_TXMAC_DEBUG2_BYTE_COUNT);
	eval 'sub BNX_EMAC_TXMAC_DEBUG2_COL_COUNT () {(0x1f<<26);}' unless defined(&BNX_EMAC_TXMAC_DEBUG2_COL_COUNT);
	eval 'sub BNX_EMAC_TXMAC_DEBUG2_COL_BIT () {(1<<31);}' unless defined(&BNX_EMAC_TXMAC_DEBUG2_COL_BIT);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3 () {0x1664;}' unless defined(&BNX_EMAC_TXMAC_DEBUG3);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_SM_STATE () {(0xf<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_SM_STATE);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_SM_STATE_IDLE () {(0x<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_SM_STATE_IDLE);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_SM_STATE_PRE1 () {(0x1<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_SM_STATE_PRE1);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_SM_STATE_PRE2 () {(0x2<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_SM_STATE_PRE2);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_SM_STATE_SFD () {(0x3<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_SM_STATE_SFD);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_SM_STATE_DATA () {(0x4<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_SM_STATE_DATA);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_SM_STATE_CRC1 () {(0x5<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_SM_STATE_CRC1);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_SM_STATE_CRC2 () {(0x6<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_SM_STATE_CRC2);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_SM_STATE_EXT () {(0x7<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_SM_STATE_EXT);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_SM_STATE_STATB () {(0x8<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_SM_STATE_STATB);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_SM_STATE_STATG () {(0x9<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_SM_STATE_STATG);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_SM_STATE_JAM () {(0xa<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_SM_STATE_JAM);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_SM_STATE_EJAM () {(0xb<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_SM_STATE_EJAM);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_SM_STATE_BJAM () {(0xc<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_SM_STATE_BJAM);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_SM_STATE_SWAIT () {(0xd<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_SM_STATE_SWAIT);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_SM_STATE_BACKOFF () {(0xe<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_SM_STATE_BACKOFF);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_FILT_STATE () {(0x7<<4);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_FILT_STATE);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_FILT_STATE_IDLE () {(0x<<4);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_FILT_STATE_IDLE);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_FILT_STATE_WAIT () {(0x1<<4);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_FILT_STATE_WAIT);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_FILT_STATE_UNI () {(0x2<<4);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_FILT_STATE_UNI);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_FILT_STATE_MC () {(0x3<<4);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_FILT_STATE_MC);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_FILT_STATE_BC2 () {(0x4<<4);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_FILT_STATE_BC2);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_FILT_STATE_BC3 () {(0x5<<4);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_FILT_STATE_BC3);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_FILT_STATE_BC () {(0x6<<4);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_FILT_STATE_BC);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_CRS_DONE () {(1<<7);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_CRS_DONE);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_XOFF () {(1<<8);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_XOFF);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_SE_COUNTER () {(0xf<<9);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_SE_COUNTER);
	eval 'sub BNX_EMAC_TXMAC_DEBUG3_QUANTA_COUNTER () {(0x1f<<13);}' unless defined(&BNX_EMAC_TXMAC_DEBUG3_QUANTA_COUNTER);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4 () {0x1668;}' unless defined(&BNX_EMAC_TXMAC_DEBUG4);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_PAUSE_COUNTER () {(0xffff<<0);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_PAUSE_COUNTER);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE () {(0xf<<16);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_IDLE () {(0x<<16);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_IDLE);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_MCA1 () {(0x2<<16);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_MCA1);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_MCA2 () {(0x3<<16);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_MCA2);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_MCA3 () {(0x6<<16);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_MCA3);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_SRC1 () {(0x7<<16);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_SRC1);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_SRC2 () {(0x5<<16);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_SRC2);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_SRC3 () {(0x4<<16);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_SRC3);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_TYPE () {(0xc<<16);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_TYPE);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_CMD () {(0xe<<16);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_CMD);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_TIME () {(0xa<<16);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_TIME);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_CRC1 () {(0x8<<16);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_CRC1);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_CRC2 () {(0x9<<16);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_CRC2);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_WAIT () {(0xd<<16);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_PAUSE_STATE_WAIT);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_STATS0_VALID () {(1<<20);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_STATS0_VALID);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_APPEND_CRC () {(1<<21);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_APPEND_CRC);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_SLOT_FILLED () {(1<<22);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_SLOT_FILLED);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_MAX_DEFER () {(1<<23);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_MAX_DEFER);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_SEND_EXTEND () {(1<<24);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_SEND_EXTEND);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_SEND_PADDING () {(1<<25);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_SEND_PADDING);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_EOF_LOC () {(1<<26);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_EOF_LOC);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_COLLIDING () {(1<<27);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_COLLIDING);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_COL_IN () {(1<<28);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_COL_IN);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_BURSTING () {(1<<29);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_BURSTING);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_ADVANCE () {(1<<30);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_ADVANCE);
	eval 'sub BNX_EMAC_TXMAC_DEBUG4_GO () {(1<<31);}' unless defined(&BNX_EMAC_TXMAC_DEBUG4_GO);
	eval 'sub BNX_EMAC_TX_STAT_AC0 () {0x1680;}' unless defined(&BNX_EMAC_TX_STAT_AC0);
	eval 'sub BNX_EMAC_TX_STAT_AC1 () {0x1684;}' unless defined(&BNX_EMAC_TX_STAT_AC1);
	eval 'sub BNX_EMAC_TX_STAT_AC2 () {0x1688;}' unless defined(&BNX_EMAC_TX_STAT_AC2);
	eval 'sub BNX_EMAC_TX_STAT_AC3 () {0x168c;}' unless defined(&BNX_EMAC_TX_STAT_AC3);
	eval 'sub BNX_EMAC_TX_STAT_AC4 () {0x1690;}' unless defined(&BNX_EMAC_TX_STAT_AC4);
	eval 'sub BNX_EMAC_TX_STAT_AC5 () {0x1694;}' unless defined(&BNX_EMAC_TX_STAT_AC5);
	eval 'sub BNX_EMAC_TX_STAT_AC6 () {0x1698;}' unless defined(&BNX_EMAC_TX_STAT_AC6);
	eval 'sub BNX_EMAC_TX_STAT_AC7 () {0x169c;}' unless defined(&BNX_EMAC_TX_STAT_AC7);
	eval 'sub BNX_EMAC_TX_STAT_AC8 () {0x16a0;}' unless defined(&BNX_EMAC_TX_STAT_AC8);
	eval 'sub BNX_EMAC_TX_STAT_AC9 () {0x16a4;}' unless defined(&BNX_EMAC_TX_STAT_AC9);
	eval 'sub BNX_EMAC_TX_STAT_AC10 () {0x16a8;}' unless defined(&BNX_EMAC_TX_STAT_AC10);
	eval 'sub BNX_EMAC_TX_STAT_AC11 () {0x16ac;}' unless defined(&BNX_EMAC_TX_STAT_AC11);
	eval 'sub BNX_EMAC_TX_STAT_AC12 () {0x16b0;}' unless defined(&BNX_EMAC_TX_STAT_AC12);
	eval 'sub BNX_EMAC_TX_STAT_AC13 () {0x16b4;}' unless defined(&BNX_EMAC_TX_STAT_AC13);
	eval 'sub BNX_EMAC_TX_STAT_AC14 () {0x16b8;}' unless defined(&BNX_EMAC_TX_STAT_AC14);
	eval 'sub BNX_EMAC_TX_STAT_AC15 () {0x16bc;}' unless defined(&BNX_EMAC_TX_STAT_AC15);
	eval 'sub BNX_EMAC_TX_STAT_AC16 () {0x16c0;}' unless defined(&BNX_EMAC_TX_STAT_AC16);
	eval 'sub BNX_EMAC_TX_STAT_AC17 () {0x16c4;}' unless defined(&BNX_EMAC_TX_STAT_AC17);
	eval 'sub BNX_EMAC_TX_STAT_AC18 () {0x16c8;}' unless defined(&BNX_EMAC_TX_STAT_AC18);
	eval 'sub BNX_EMAC_TX_STAT_AC19 () {0x16cc;}' unless defined(&BNX_EMAC_TX_STAT_AC19);
	eval 'sub BNX_EMAC_TX_STAT_AC20 () {0x16d0;}' unless defined(&BNX_EMAC_TX_STAT_AC20);
	eval 'sub BNX_EMAC_TX_STAT_AC21 () {0x16d4;}' unless defined(&BNX_EMAC_TX_STAT_AC21);
	eval 'sub BNX_EMAC_TXMAC_SUC_DBG_OVERRUNVEC () {0x16d8;}' unless defined(&BNX_EMAC_TXMAC_SUC_DBG_OVERRUNVEC);
	eval 'sub BNX_RPM_COMMAND () {0x1800;}' unless defined(&BNX_RPM_COMMAND);
	eval 'sub BNX_RPM_COMMAND_ENABLED () {(1<<0);}' unless defined(&BNX_RPM_COMMAND_ENABLED);
	eval 'sub BNX_RPM_COMMAND_OVERRUN_ABORT () {(1<<4);}' unless defined(&BNX_RPM_COMMAND_OVERRUN_ABORT);
	eval 'sub BNX_RPM_STATUS () {0x1804;}' unless defined(&BNX_RPM_STATUS);
	eval 'sub BNX_RPM_STATUS_MBUF_WAIT () {(1<<0);}' unless defined(&BNX_RPM_STATUS_MBUF_WAIT);
	eval 'sub BNX_RPM_STATUS_FREE_WAIT () {(1<<1);}' unless defined(&BNX_RPM_STATUS_FREE_WAIT);
	eval 'sub BNX_RPM_CONFIG () {0x1808;}' unless defined(&BNX_RPM_CONFIG);
	eval 'sub BNX_RPM_CONFIG_NO_PSD_HDR_CKSUM () {(1<<0);}' unless defined(&BNX_RPM_CONFIG_NO_PSD_HDR_CKSUM);
	eval 'sub BNX_RPM_CONFIG_ACPI_ENA () {(1<<1);}' unless defined(&BNX_RPM_CONFIG_ACPI_ENA);
	eval 'sub BNX_RPM_CONFIG_ACPI_KEEP () {(1<<2);}' unless defined(&BNX_RPM_CONFIG_ACPI_KEEP);
	eval 'sub BNX_RPM_CONFIG_MP_KEEP () {(1<<3);}' unless defined(&BNX_RPM_CONFIG_MP_KEEP);
	eval 'sub BNX_RPM_CONFIG_SORT_VECT_VAL () {(0xf<<4);}' unless defined(&BNX_RPM_CONFIG_SORT_VECT_VAL);
	eval 'sub BNX_RPM_CONFIG_IGNORE_VLAN () {(1<<31);}' unless defined(&BNX_RPM_CONFIG_IGNORE_VLAN);
	eval 'sub BNX_RPM_VLAN_MATCH0 () {0x1810;}' unless defined(&BNX_RPM_VLAN_MATCH0);
	eval 'sub BNX_RPM_VLAN_MATCH0_RPM_VLAN_MTCH0_VALUE () {(0xfff<<0);}' unless defined(&BNX_RPM_VLAN_MATCH0_RPM_VLAN_MTCH0_VALUE);
	eval 'sub BNX_RPM_VLAN_MATCH1 () {0x1814;}' unless defined(&BNX_RPM_VLAN_MATCH1);
	eval 'sub BNX_RPM_VLAN_MATCH1_RPM_VLAN_MTCH1_VALUE () {(0xfff<<0);}' unless defined(&BNX_RPM_VLAN_MATCH1_RPM_VLAN_MTCH1_VALUE);
	eval 'sub BNX_RPM_VLAN_MATCH2 () {0x1818;}' unless defined(&BNX_RPM_VLAN_MATCH2);
	eval 'sub BNX_RPM_VLAN_MATCH2_RPM_VLAN_MTCH2_VALUE () {(0xfff<<0);}' unless defined(&BNX_RPM_VLAN_MATCH2_RPM_VLAN_MTCH2_VALUE);
	eval 'sub BNX_RPM_VLAN_MATCH3 () {0x181c;}' unless defined(&BNX_RPM_VLAN_MATCH3);
	eval 'sub BNX_RPM_VLAN_MATCH3_RPM_VLAN_MTCH3_VALUE () {(0xfff<<0);}' unless defined(&BNX_RPM_VLAN_MATCH3_RPM_VLAN_MTCH3_VALUE);
	eval 'sub BNX_RPM_SORT_USER0 () {0x1820;}' unless defined(&BNX_RPM_SORT_USER0);
	eval 'sub BNX_RPM_SORT_USER0_PM_EN () {(0xffff<<0);}' unless defined(&BNX_RPM_SORT_USER0_PM_EN);
	eval 'sub BNX_RPM_SORT_USER0_BC_EN () {(1<<16);}' unless defined(&BNX_RPM_SORT_USER0_BC_EN);
	eval 'sub BNX_RPM_SORT_USER0_MC_EN () {(1<<17);}' unless defined(&BNX_RPM_SORT_USER0_MC_EN);
	eval 'sub BNX_RPM_SORT_USER0_MC_HSH_EN () {(1<<18);}' unless defined(&BNX_RPM_SORT_USER0_MC_HSH_EN);
	eval 'sub BNX_RPM_SORT_USER0_PROM_EN () {(1<<19);}' unless defined(&BNX_RPM_SORT_USER0_PROM_EN);
	eval 'sub BNX_RPM_SORT_USER0_VLAN_EN () {(0xf<<20);}' unless defined(&BNX_RPM_SORT_USER0_VLAN_EN);
	eval 'sub BNX_RPM_SORT_USER0_PROM_VLAN () {(1<<24);}' unless defined(&BNX_RPM_SORT_USER0_PROM_VLAN);
	eval 'sub BNX_RPM_SORT_USER0_ENA () {(1<<31);}' unless defined(&BNX_RPM_SORT_USER0_ENA);
	eval 'sub BNX_RPM_SORT_USER1 () {0x1824;}' unless defined(&BNX_RPM_SORT_USER1);
	eval 'sub BNX_RPM_SORT_USER1_PM_EN () {(0xffff<<0);}' unless defined(&BNX_RPM_SORT_USER1_PM_EN);
	eval 'sub BNX_RPM_SORT_USER1_BC_EN () {(1<<16);}' unless defined(&BNX_RPM_SORT_USER1_BC_EN);
	eval 'sub BNX_RPM_SORT_USER1_MC_EN () {(1<<17);}' unless defined(&BNX_RPM_SORT_USER1_MC_EN);
	eval 'sub BNX_RPM_SORT_USER1_MC_HSH_EN () {(1<<18);}' unless defined(&BNX_RPM_SORT_USER1_MC_HSH_EN);
	eval 'sub BNX_RPM_SORT_USER1_PROM_EN () {(1<<19);}' unless defined(&BNX_RPM_SORT_USER1_PROM_EN);
	eval 'sub BNX_RPM_SORT_USER1_VLAN_EN () {(0xf<<20);}' unless defined(&BNX_RPM_SORT_USER1_VLAN_EN);
	eval 'sub BNX_RPM_SORT_USER1_PROM_VLAN () {(1<<24);}' unless defined(&BNX_RPM_SORT_USER1_PROM_VLAN);
	eval 'sub BNX_RPM_SORT_USER1_ENA () {(1<<31);}' unless defined(&BNX_RPM_SORT_USER1_ENA);
	eval 'sub BNX_RPM_SORT_USER2 () {0x1828;}' unless defined(&BNX_RPM_SORT_USER2);
	eval 'sub BNX_RPM_SORT_USER2_PM_EN () {(0xffff<<0);}' unless defined(&BNX_RPM_SORT_USER2_PM_EN);
	eval 'sub BNX_RPM_SORT_USER2_BC_EN () {(1<<16);}' unless defined(&BNX_RPM_SORT_USER2_BC_EN);
	eval 'sub BNX_RPM_SORT_USER2_MC_EN () {(1<<17);}' unless defined(&BNX_RPM_SORT_USER2_MC_EN);
	eval 'sub BNX_RPM_SORT_USER2_MC_HSH_EN () {(1<<18);}' unless defined(&BNX_RPM_SORT_USER2_MC_HSH_EN);
	eval 'sub BNX_RPM_SORT_USER2_PROM_EN () {(1<<19);}' unless defined(&BNX_RPM_SORT_USER2_PROM_EN);
	eval 'sub BNX_RPM_SORT_USER2_VLAN_EN () {(0xf<<20);}' unless defined(&BNX_RPM_SORT_USER2_VLAN_EN);
	eval 'sub BNX_RPM_SORT_USER2_PROM_VLAN () {(1<<24);}' unless defined(&BNX_RPM_SORT_USER2_PROM_VLAN);
	eval 'sub BNX_RPM_SORT_USER2_ENA () {(1<<31);}' unless defined(&BNX_RPM_SORT_USER2_ENA);
	eval 'sub BNX_RPM_SORT_USER3 () {0x182c;}' unless defined(&BNX_RPM_SORT_USER3);
	eval 'sub BNX_RPM_SORT_USER3_PM_EN () {(0xffff<<0);}' unless defined(&BNX_RPM_SORT_USER3_PM_EN);
	eval 'sub BNX_RPM_SORT_USER3_BC_EN () {(1<<16);}' unless defined(&BNX_RPM_SORT_USER3_BC_EN);
	eval 'sub BNX_RPM_SORT_USER3_MC_EN () {(1<<17);}' unless defined(&BNX_RPM_SORT_USER3_MC_EN);
	eval 'sub BNX_RPM_SORT_USER3_MC_HSH_EN () {(1<<18);}' unless defined(&BNX_RPM_SORT_USER3_MC_HSH_EN);
	eval 'sub BNX_RPM_SORT_USER3_PROM_EN () {(1<<19);}' unless defined(&BNX_RPM_SORT_USER3_PROM_EN);
	eval 'sub BNX_RPM_SORT_USER3_VLAN_EN () {(0xf<<20);}' unless defined(&BNX_RPM_SORT_USER3_VLAN_EN);
	eval 'sub BNX_RPM_SORT_USER3_PROM_VLAN () {(1<<24);}' unless defined(&BNX_RPM_SORT_USER3_PROM_VLAN);
	eval 'sub BNX_RPM_SORT_USER3_ENA () {(1<<31);}' unless defined(&BNX_RPM_SORT_USER3_ENA);
	eval 'sub BNX_RPM_STAT_L2_FILTER_DISCARDS () {0x1840;}' unless defined(&BNX_RPM_STAT_L2_FILTER_DISCARDS);
	eval 'sub BNX_RPM_STAT_RULE_CHECKER_DISCARDS () {0x1844;}' unless defined(&BNX_RPM_STAT_RULE_CHECKER_DISCARDS);
	eval 'sub BNX_RPM_STAT_IFINFTQDISCARDS () {0x1848;}' unless defined(&BNX_RPM_STAT_IFINFTQDISCARDS);
	eval 'sub BNX_RPM_STAT_IFINMBUFDISCARD () {0x184c;}' unless defined(&BNX_RPM_STAT_IFINMBUFDISCARD);
	eval 'sub BNX_RPM_STAT_RULE_CHECKER_P4_HIT () {0x1850;}' unless defined(&BNX_RPM_STAT_RULE_CHECKER_P4_HIT);
	eval 'sub BNX_RPM_STAT_AC0 () {0x1880;}' unless defined(&BNX_RPM_STAT_AC0);
	eval 'sub BNX_RPM_STAT_AC1 () {0x1884;}' unless defined(&BNX_RPM_STAT_AC1);
	eval 'sub BNX_RPM_STAT_AC2 () {0x1888;}' unless defined(&BNX_RPM_STAT_AC2);
	eval 'sub BNX_RPM_STAT_AC3 () {0x188c;}' unless defined(&BNX_RPM_STAT_AC3);
	eval 'sub BNX_RPM_STAT_AC4 () {0x1890;}' unless defined(&BNX_RPM_STAT_AC4);
	eval 'sub BNX_RPM_RC_CNTL_0 () {0x1900;}' unless defined(&BNX_RPM_RC_CNTL_0);
	eval 'sub BNX_RPM_RC_CNTL_0_OFFSET () {(0xff<<0);}' unless defined(&BNX_RPM_RC_CNTL_0_OFFSET);
	eval 'sub BNX_RPM_RC_CNTL_0_CLASS () {(0x7<<8);}' unless defined(&BNX_RPM_RC_CNTL_0_CLASS);
	eval 'sub BNX_RPM_RC_CNTL_0_PRIORITY () {(1<<11);}' unless defined(&BNX_RPM_RC_CNTL_0_PRIORITY);
	eval 'sub BNX_RPM_RC_CNTL_0_P4 () {(1<<12);}' unless defined(&BNX_RPM_RC_CNTL_0_P4);
	eval 'sub BNX_RPM_RC_CNTL_0_HDR_TYPE () {(0x7<<13);}' unless defined(&BNX_RPM_RC_CNTL_0_HDR_TYPE);
	eval 'sub BNX_RPM_RC_CNTL_0_HDR_TYPE_START () {(0<<13);}' unless defined(&BNX_RPM_RC_CNTL_0_HDR_TYPE_START);
	eval 'sub BNX_RPM_RC_CNTL_0_HDR_TYPE_IP () {(1<<13);}' unless defined(&BNX_RPM_RC_CNTL_0_HDR_TYPE_IP);
	eval 'sub BNX_RPM_RC_CNTL_0_HDR_TYPE_TCP () {(2<<13);}' unless defined(&BNX_RPM_RC_CNTL_0_HDR_TYPE_TCP);
	eval 'sub BNX_RPM_RC_CNTL_0_HDR_TYPE_UDP () {(3<<13);}' unless defined(&BNX_RPM_RC_CNTL_0_HDR_TYPE_UDP);
	eval 'sub BNX_RPM_RC_CNTL_0_HDR_TYPE_DATA () {(4<<13);}' unless defined(&BNX_RPM_RC_CNTL_0_HDR_TYPE_DATA);
	eval 'sub BNX_RPM_RC_CNTL_0_COMP () {(0x3<<16);}' unless defined(&BNX_RPM_RC_CNTL_0_COMP);
	eval 'sub BNX_RPM_RC_CNTL_0_COMP_EQUAL () {(0<<16);}' unless defined(&BNX_RPM_RC_CNTL_0_COMP_EQUAL);
	eval 'sub BNX_RPM_RC_CNTL_0_COMP_NEQUAL () {(1<<16);}' unless defined(&BNX_RPM_RC_CNTL_0_COMP_NEQUAL);
	eval 'sub BNX_RPM_RC_CNTL_0_COMP_GREATER () {(2<<16);}' unless defined(&BNX_RPM_RC_CNTL_0_COMP_GREATER);
	eval 'sub BNX_RPM_RC_CNTL_0_COMP_LESS () {(3<<16);}' unless defined(&BNX_RPM_RC_CNTL_0_COMP_LESS);
	eval 'sub BNX_RPM_RC_CNTL_0_SBIT () {(1<<19);}' unless defined(&BNX_RPM_RC_CNTL_0_SBIT);
	eval 'sub BNX_RPM_RC_CNTL_0_CMDSEL () {(0xf<<20);}' unless defined(&BNX_RPM_RC_CNTL_0_CMDSEL);
	eval 'sub BNX_RPM_RC_CNTL_0_MAP () {(1<<24);}' unless defined(&BNX_RPM_RC_CNTL_0_MAP);
	eval 'sub BNX_RPM_RC_CNTL_0_DISCARD () {(1<<25);}' unless defined(&BNX_RPM_RC_CNTL_0_DISCARD);
	eval 'sub BNX_RPM_RC_CNTL_0_MASK () {(1<<26);}' unless defined(&BNX_RPM_RC_CNTL_0_MASK);
	eval 'sub BNX_RPM_RC_CNTL_0_P1 () {(1<<27);}' unless defined(&BNX_RPM_RC_CNTL_0_P1);
	eval 'sub BNX_RPM_RC_CNTL_0_P2 () {(1<<28);}' unless defined(&BNX_RPM_RC_CNTL_0_P2);
	eval 'sub BNX_RPM_RC_CNTL_0_P3 () {(1<<29);}' unless defined(&BNX_RPM_RC_CNTL_0_P3);
	eval 'sub BNX_RPM_RC_CNTL_0_NBIT () {(1<<30);}' unless defined(&BNX_RPM_RC_CNTL_0_NBIT);
	eval 'sub BNX_RPM_RC_VALUE_MASK_0 () {0x1904;}' unless defined(&BNX_RPM_RC_VALUE_MASK_0);
	eval 'sub BNX_RPM_RC_VALUE_MASK_0_VALUE () {(0xffff<<0);}' unless defined(&BNX_RPM_RC_VALUE_MASK_0_VALUE);
	eval 'sub BNX_RPM_RC_VALUE_MASK_0_MASK () {(0xffff<<16);}' unless defined(&BNX_RPM_RC_VALUE_MASK_0_MASK);
	eval 'sub BNX_RPM_RC_CNTL_1 () {0x1908;}' unless defined(&BNX_RPM_RC_CNTL_1);
	eval 'sub BNX_RPM_RC_CNTL_1_A () {(0x3ffff<<0);}' unless defined(&BNX_RPM_RC_CNTL_1_A);
	eval 'sub BNX_RPM_RC_CNTL_1_B () {(0xfff<<19);}' unless defined(&BNX_RPM_RC_CNTL_1_B);
	eval 'sub BNX_RPM_RC_VALUE_MASK_1 () {0x190c;}' unless defined(&BNX_RPM_RC_VALUE_MASK_1);
	eval 'sub BNX_RPM_RC_CNTL_2 () {0x1910;}' unless defined(&BNX_RPM_RC_CNTL_2);
	eval 'sub BNX_RPM_RC_CNTL_2_A () {(0x3ffff<<0);}' unless defined(&BNX_RPM_RC_CNTL_2_A);
	eval 'sub BNX_RPM_RC_CNTL_2_B () {(0xfff<<19);}' unless defined(&BNX_RPM_RC_CNTL_2_B);
	eval 'sub BNX_RPM_RC_VALUE_MASK_2 () {0x1914;}' unless defined(&BNX_RPM_RC_VALUE_MASK_2);
	eval 'sub BNX_RPM_RC_CNTL_3 () {0x1918;}' unless defined(&BNX_RPM_RC_CNTL_3);
	eval 'sub BNX_RPM_RC_CNTL_3_A () {(0x3ffff<<0);}' unless defined(&BNX_RPM_RC_CNTL_3_A);
	eval 'sub BNX_RPM_RC_CNTL_3_B () {(0xfff<<19);}' unless defined(&BNX_RPM_RC_CNTL_3_B);
	eval 'sub BNX_RPM_RC_VALUE_MASK_3 () {0x191c;}' unless defined(&BNX_RPM_RC_VALUE_MASK_3);
	eval 'sub BNX_RPM_RC_CNTL_4 () {0x1920;}' unless defined(&BNX_RPM_RC_CNTL_4);
	eval 'sub BNX_RPM_RC_CNTL_4_A () {(0x3ffff<<0);}' unless defined(&BNX_RPM_RC_CNTL_4_A);
	eval 'sub BNX_RPM_RC_CNTL_4_B () {(0xfff<<19);}' unless defined(&BNX_RPM_RC_CNTL_4_B);
	eval 'sub BNX_RPM_RC_VALUE_MASK_4 () {0x1924;}' unless defined(&BNX_RPM_RC_VALUE_MASK_4);
	eval 'sub BNX_RPM_RC_CNTL_5 () {0x1928;}' unless defined(&BNX_RPM_RC_CNTL_5);
	eval 'sub BNX_RPM_RC_CNTL_5_A () {(0x3ffff<<0);}' unless defined(&BNX_RPM_RC_CNTL_5_A);
	eval 'sub BNX_RPM_RC_CNTL_5_B () {(0xfff<<19);}' unless defined(&BNX_RPM_RC_CNTL_5_B);
	eval 'sub BNX_RPM_RC_VALUE_MASK_5 () {0x192c;}' unless defined(&BNX_RPM_RC_VALUE_MASK_5);
	eval 'sub BNX_RPM_RC_CNTL_6 () {0x1930;}' unless defined(&BNX_RPM_RC_CNTL_6);
	eval 'sub BNX_RPM_RC_CNTL_6_A () {(0x3ffff<<0);}' unless defined(&BNX_RPM_RC_CNTL_6_A);
	eval 'sub BNX_RPM_RC_CNTL_6_B () {(0xfff<<19);}' unless defined(&BNX_RPM_RC_CNTL_6_B);
	eval 'sub BNX_RPM_RC_VALUE_MASK_6 () {0x1934;}' unless defined(&BNX_RPM_RC_VALUE_MASK_6);
	eval 'sub BNX_RPM_RC_CNTL_7 () {0x1938;}' unless defined(&BNX_RPM_RC_CNTL_7);
	eval 'sub BNX_RPM_RC_CNTL_7_A () {(0x3ffff<<0);}' unless defined(&BNX_RPM_RC_CNTL_7_A);
	eval 'sub BNX_RPM_RC_CNTL_7_B () {(0xfff<<19);}' unless defined(&BNX_RPM_RC_CNTL_7_B);
	eval 'sub BNX_RPM_RC_VALUE_MASK_7 () {0x193c;}' unless defined(&BNX_RPM_RC_VALUE_MASK_7);
	eval 'sub BNX_RPM_RC_CNTL_8 () {0x1940;}' unless defined(&BNX_RPM_RC_CNTL_8);
	eval 'sub BNX_RPM_RC_CNTL_8_A () {(0x3ffff<<0);}' unless defined(&BNX_RPM_RC_CNTL_8_A);
	eval 'sub BNX_RPM_RC_CNTL_8_B () {(0xfff<<19);}' unless defined(&BNX_RPM_RC_CNTL_8_B);
	eval 'sub BNX_RPM_RC_VALUE_MASK_8 () {0x1944;}' unless defined(&BNX_RPM_RC_VALUE_MASK_8);
	eval 'sub BNX_RPM_RC_CNTL_9 () {0x1948;}' unless defined(&BNX_RPM_RC_CNTL_9);
	eval 'sub BNX_RPM_RC_CNTL_9_A () {(0x3ffff<<0);}' unless defined(&BNX_RPM_RC_CNTL_9_A);
	eval 'sub BNX_RPM_RC_CNTL_9_B () {(0xfff<<19);}' unless defined(&BNX_RPM_RC_CNTL_9_B);
	eval 'sub BNX_RPM_RC_VALUE_MASK_9 () {0x194c;}' unless defined(&BNX_RPM_RC_VALUE_MASK_9);
	eval 'sub BNX_RPM_RC_CNTL_10 () {0x1950;}' unless defined(&BNX_RPM_RC_CNTL_10);
	eval 'sub BNX_RPM_RC_CNTL_10_A () {(0x3ffff<<0);}' unless defined(&BNX_RPM_RC_CNTL_10_A);
	eval 'sub BNX_RPM_RC_CNTL_10_B () {(0xfff<<19);}' unless defined(&BNX_RPM_RC_CNTL_10_B);
	eval 'sub BNX_RPM_RC_VALUE_MASK_10 () {0x1954;}' unless defined(&BNX_RPM_RC_VALUE_MASK_10);
	eval 'sub BNX_RPM_RC_CNTL_11 () {0x1958;}' unless defined(&BNX_RPM_RC_CNTL_11);
	eval 'sub BNX_RPM_RC_CNTL_11_A () {(0x3ffff<<0);}' unless defined(&BNX_RPM_RC_CNTL_11_A);
	eval 'sub BNX_RPM_RC_CNTL_11_B () {(0xfff<<19);}' unless defined(&BNX_RPM_RC_CNTL_11_B);
	eval 'sub BNX_RPM_RC_VALUE_MASK_11 () {0x195c;}' unless defined(&BNX_RPM_RC_VALUE_MASK_11);
	eval 'sub BNX_RPM_RC_CNTL_12 () {0x1960;}' unless defined(&BNX_RPM_RC_CNTL_12);
	eval 'sub BNX_RPM_RC_CNTL_12_A () {(0x3ffff<<0);}' unless defined(&BNX_RPM_RC_CNTL_12_A);
	eval 'sub BNX_RPM_RC_CNTL_12_B () {(0xfff<<19);}' unless defined(&BNX_RPM_RC_CNTL_12_B);
	eval 'sub BNX_RPM_RC_VALUE_MASK_12 () {0x1964;}' unless defined(&BNX_RPM_RC_VALUE_MASK_12);
	eval 'sub BNX_RPM_RC_CNTL_13 () {0x1968;}' unless defined(&BNX_RPM_RC_CNTL_13);
	eval 'sub BNX_RPM_RC_CNTL_13_A () {(0x3ffff<<0);}' unless defined(&BNX_RPM_RC_CNTL_13_A);
	eval 'sub BNX_RPM_RC_CNTL_13_B () {(0xfff<<19);}' unless defined(&BNX_RPM_RC_CNTL_13_B);
	eval 'sub BNX_RPM_RC_VALUE_MASK_13 () {0x196c;}' unless defined(&BNX_RPM_RC_VALUE_MASK_13);
	eval 'sub BNX_RPM_RC_CNTL_14 () {0x1970;}' unless defined(&BNX_RPM_RC_CNTL_14);
	eval 'sub BNX_RPM_RC_CNTL_14_A () {(0x3ffff<<0);}' unless defined(&BNX_RPM_RC_CNTL_14_A);
	eval 'sub BNX_RPM_RC_CNTL_14_B () {(0xfff<<19);}' unless defined(&BNX_RPM_RC_CNTL_14_B);
	eval 'sub BNX_RPM_RC_VALUE_MASK_14 () {0x1974;}' unless defined(&BNX_RPM_RC_VALUE_MASK_14);
	eval 'sub BNX_RPM_RC_CNTL_15 () {0x1978;}' unless defined(&BNX_RPM_RC_CNTL_15);
	eval 'sub BNX_RPM_RC_CNTL_15_A () {(0x3ffff<<0);}' unless defined(&BNX_RPM_RC_CNTL_15_A);
	eval 'sub BNX_RPM_RC_CNTL_15_B () {(0xfff<<19);}' unless defined(&BNX_RPM_RC_CNTL_15_B);
	eval 'sub BNX_RPM_RC_VALUE_MASK_15 () {0x197c;}' unless defined(&BNX_RPM_RC_VALUE_MASK_15);
	eval 'sub BNX_RPM_RC_CONFIG () {0x1980;}' unless defined(&BNX_RPM_RC_CONFIG);
	eval 'sub BNX_RPM_RC_CONFIG_RULE_ENABLE () {(0xffff<<0);}' unless defined(&BNX_RPM_RC_CONFIG_RULE_ENABLE);
	eval 'sub BNX_RPM_RC_CONFIG_DEF_CLASS () {(0x7<<24);}' unless defined(&BNX_RPM_RC_CONFIG_DEF_CLASS);
	eval 'sub BNX_RPM_DEBUG0 () {0x1984;}' unless defined(&BNX_RPM_DEBUG0);
	eval 'sub BNX_RPM_DEBUG0_FM_BCNT () {(0xffff<<0);}' unless defined(&BNX_RPM_DEBUG0_FM_BCNT);
	eval 'sub BNX_RPM_DEBUG0_T_DATA_OFST_VLD () {(1<<16);}' unless defined(&BNX_RPM_DEBUG0_T_DATA_OFST_VLD);
	eval 'sub BNX_RPM_DEBUG0_T_UDP_OFST_VLD () {(1<<17);}' unless defined(&BNX_RPM_DEBUG0_T_UDP_OFST_VLD);
	eval 'sub BNX_RPM_DEBUG0_T_TCP_OFST_VLD () {(1<<18);}' unless defined(&BNX_RPM_DEBUG0_T_TCP_OFST_VLD);
	eval 'sub BNX_RPM_DEBUG0_T_IP_OFST_VLD () {(1<<19);}' unless defined(&BNX_RPM_DEBUG0_T_IP_OFST_VLD);
	eval 'sub BNX_RPM_DEBUG0_IP_MORE_FRGMT () {(1<<20);}' unless defined(&BNX_RPM_DEBUG0_IP_MORE_FRGMT);
	eval 'sub BNX_RPM_DEBUG0_T_IP_NO_TCP_UDP_HDR () {(1<<21);}' unless defined(&BNX_RPM_DEBUG0_T_IP_NO_TCP_UDP_HDR);
	eval 'sub BNX_RPM_DEBUG0_LLC_SNAP () {(1<<22);}' unless defined(&BNX_RPM_DEBUG0_LLC_SNAP);
	eval 'sub BNX_RPM_DEBUG0_FM_STARTED () {(1<<23);}' unless defined(&BNX_RPM_DEBUG0_FM_STARTED);
	eval 'sub BNX_RPM_DEBUG0_DONE () {(1<<24);}' unless defined(&BNX_RPM_DEBUG0_DONE);
	eval 'sub BNX_RPM_DEBUG0_WAIT_4_DONE () {(1<<25);}' unless defined(&BNX_RPM_DEBUG0_WAIT_4_DONE);
	eval 'sub BNX_RPM_DEBUG0_USE_TPBUF_CKSUM () {(1<<26);}' unless defined(&BNX_RPM_DEBUG0_USE_TPBUF_CKSUM);
	eval 'sub BNX_RPM_DEBUG0_RX_NO_PSD_HDR_CKSUM () {(1<<27);}' unless defined(&BNX_RPM_DEBUG0_RX_NO_PSD_HDR_CKSUM);
	eval 'sub BNX_RPM_DEBUG0_IGNORE_VLAN () {(1<<28);}' unless defined(&BNX_RPM_DEBUG0_IGNORE_VLAN);
	eval 'sub BNX_RPM_DEBUG0_RP_ENA_ACTIVE () {(1<<31);}' unless defined(&BNX_RPM_DEBUG0_RP_ENA_ACTIVE);
	eval 'sub BNX_RPM_DEBUG1 () {0x1988;}' unless defined(&BNX_RPM_DEBUG1);
	eval 'sub BNX_RPM_DEBUG1_FSM_CUR_ST () {(0xffff<<0);}' unless defined(&BNX_RPM_DEBUG1_FSM_CUR_ST);
	eval 'sub BNX_RPM_DEBUG1_FSM_CUR_ST_IDLE () {(0<<0);}' unless defined(&BNX_RPM_DEBUG1_FSM_CUR_ST_IDLE);
	eval 'sub BNX_RPM_DEBUG1_FSM_CUR_ST_ETYPE_B6_ALL () {(1<<0);}' unless defined(&BNX_RPM_DEBUG1_FSM_CUR_ST_ETYPE_B6_ALL);
	eval 'sub BNX_RPM_DEBUG1_FSM_CUR_ST_ETYPE_B2_IPLLC () {(2<<0);}' unless defined(&BNX_RPM_DEBUG1_FSM_CUR_ST_ETYPE_B2_IPLLC);
	eval 'sub BNX_RPM_DEBUG1_FSM_CUR_ST_ETYPE_B6_IP () {(4<<0);}' unless defined(&BNX_RPM_DEBUG1_FSM_CUR_ST_ETYPE_B6_IP);
	eval 'sub BNX_RPM_DEBUG1_FSM_CUR_ST_ETYPE_B2_IP () {(8<<0);}' unless defined(&BNX_RPM_DEBUG1_FSM_CUR_ST_ETYPE_B2_IP);
	eval 'sub BNX_RPM_DEBUG1_FSM_CUR_ST_IP_START () {(16<<0);}' unless defined(&BNX_RPM_DEBUG1_FSM_CUR_ST_IP_START);
	eval 'sub BNX_RPM_DEBUG1_FSM_CUR_ST_IP () {(32<<0);}' unless defined(&BNX_RPM_DEBUG1_FSM_CUR_ST_IP);
	eval 'sub BNX_RPM_DEBUG1_FSM_CUR_ST_TCP () {(64<<0);}' unless defined(&BNX_RPM_DEBUG1_FSM_CUR_ST_TCP);
	eval 'sub BNX_RPM_DEBUG1_FSM_CUR_ST_UDP () {(128<<0);}' unless defined(&BNX_RPM_DEBUG1_FSM_CUR_ST_UDP);
	eval 'sub BNX_RPM_DEBUG1_FSM_CUR_ST_AH () {(256<<0);}' unless defined(&BNX_RPM_DEBUG1_FSM_CUR_ST_AH);
	eval 'sub BNX_RPM_DEBUG1_FSM_CUR_ST_ESP () {(512<<0);}' unless defined(&BNX_RPM_DEBUG1_FSM_CUR_ST_ESP);
	eval 'sub BNX_RPM_DEBUG1_FSM_CUR_ST_ESP_PAYLOAD () {(1024<<0);}' unless defined(&BNX_RPM_DEBUG1_FSM_CUR_ST_ESP_PAYLOAD);
	eval 'sub BNX_RPM_DEBUG1_FSM_CUR_ST_DATA () {(2048<<0);}' unless defined(&BNX_RPM_DEBUG1_FSM_CUR_ST_DATA);
	eval 'sub BNX_RPM_DEBUG1_FSM_CUR_ST_ADD_CARRY () {(0x2000<<0);}' unless defined(&BNX_RPM_DEBUG1_FSM_CUR_ST_ADD_CARRY);
	eval 'sub BNX_RPM_DEBUG1_FSM_CUR_ST_ADD_CARRYOUT () {(0x4000<<0);}' unless defined(&BNX_RPM_DEBUG1_FSM_CUR_ST_ADD_CARRYOUT);
	eval 'sub BNX_RPM_DEBUG1_FSM_CUR_ST_LATCH_RESULT () {(0x8000<<0);}' unless defined(&BNX_RPM_DEBUG1_FSM_CUR_ST_LATCH_RESULT);
	eval 'sub BNX_RPM_DEBUG1_HDR_BCNT () {(0x7ff<<16);}' unless defined(&BNX_RPM_DEBUG1_HDR_BCNT);
	eval 'sub BNX_RPM_DEBUG1_UNKNOWN_ETYPE_D () {(1<<28);}' unless defined(&BNX_RPM_DEBUG1_UNKNOWN_ETYPE_D);
	eval 'sub BNX_RPM_DEBUG1_VLAN_REMOVED_D2 () {(1<<29);}' unless defined(&BNX_RPM_DEBUG1_VLAN_REMOVED_D2);
	eval 'sub BNX_RPM_DEBUG1_VLAN_REMOVED_D1 () {(1<<30);}' unless defined(&BNX_RPM_DEBUG1_VLAN_REMOVED_D1);
	eval 'sub BNX_RPM_DEBUG1_EOF_0XTRA_WD () {(1<<31);}' unless defined(&BNX_RPM_DEBUG1_EOF_0XTRA_WD);
	eval 'sub BNX_RPM_DEBUG2 () {0x198c;}' unless defined(&BNX_RPM_DEBUG2);
	eval 'sub BNX_RPM_DEBUG2_CMD_HIT_VEC () {(0xffff<<0);}' unless defined(&BNX_RPM_DEBUG2_CMD_HIT_VEC);
	eval 'sub BNX_RPM_DEBUG2_IP_BCNT () {(0xff<<16);}' unless defined(&BNX_RPM_DEBUG2_IP_BCNT);
	eval 'sub BNX_RPM_DEBUG2_THIS_CMD_M4 () {(1<<24);}' unless defined(&BNX_RPM_DEBUG2_THIS_CMD_M4);
	eval 'sub BNX_RPM_DEBUG2_THIS_CMD_M3 () {(1<<25);}' unless defined(&BNX_RPM_DEBUG2_THIS_CMD_M3);
	eval 'sub BNX_RPM_DEBUG2_THIS_CMD_M2 () {(1<<26);}' unless defined(&BNX_RPM_DEBUG2_THIS_CMD_M2);
	eval 'sub BNX_RPM_DEBUG2_THIS_CMD_M1 () {(1<<27);}' unless defined(&BNX_RPM_DEBUG2_THIS_CMD_M1);
	eval 'sub BNX_RPM_DEBUG2_IPIPE_EMPTY () {(1<<28);}' unless defined(&BNX_RPM_DEBUG2_IPIPE_EMPTY);
	eval 'sub BNX_RPM_DEBUG2_FM_DISCARD () {(1<<29);}' unless defined(&BNX_RPM_DEBUG2_FM_DISCARD);
	eval 'sub BNX_RPM_DEBUG2_LAST_RULE_IN_FM_D2 () {(1<<30);}' unless defined(&BNX_RPM_DEBUG2_LAST_RULE_IN_FM_D2);
	eval 'sub BNX_RPM_DEBUG2_LAST_RULE_IN_FM_D1 () {(1<<31);}' unless defined(&BNX_RPM_DEBUG2_LAST_RULE_IN_FM_D1);
	eval 'sub BNX_RPM_DEBUG3 () {0x1990;}' unless defined(&BNX_RPM_DEBUG3);
	eval 'sub BNX_RPM_DEBUG3_AVAIL_MBUF_PTR () {(0x1ff<<0);}' unless defined(&BNX_RPM_DEBUG3_AVAIL_MBUF_PTR);
	eval 'sub BNX_RPM_DEBUG3_RDE_RLUPQ_WR_REQ_INT () {(1<<9);}' unless defined(&BNX_RPM_DEBUG3_RDE_RLUPQ_WR_REQ_INT);
	eval 'sub BNX_RPM_DEBUG3_RDE_RBUF_WR_LAST_INT () {(1<<10);}' unless defined(&BNX_RPM_DEBUG3_RDE_RBUF_WR_LAST_INT);
	eval 'sub BNX_RPM_DEBUG3_RDE_RBUF_WR_REQ_INT () {(1<<11);}' unless defined(&BNX_RPM_DEBUG3_RDE_RBUF_WR_REQ_INT);
	eval 'sub BNX_RPM_DEBUG3_RDE_RBUF_FREE_REQ () {(1<<12);}' unless defined(&BNX_RPM_DEBUG3_RDE_RBUF_FREE_REQ);
	eval 'sub BNX_RPM_DEBUG3_RDE_RBUF_ALLOC_REQ () {(1<<13);}' unless defined(&BNX_RPM_DEBUG3_RDE_RBUF_ALLOC_REQ);
	eval 'sub BNX_RPM_DEBUG3_DFSM_MBUF_NOTAVAIL () {(1<<14);}' unless defined(&BNX_RPM_DEBUG3_DFSM_MBUF_NOTAVAIL);
	eval 'sub BNX_RPM_DEBUG3_RBUF_RDE_SOF_DROP () {(1<<15);}' unless defined(&BNX_RPM_DEBUG3_RBUF_RDE_SOF_DROP);
	eval 'sub BNX_RPM_DEBUG3_DFIFO_VLD_ENTRY_CT () {(0xf<<16);}' unless defined(&BNX_RPM_DEBUG3_DFIFO_VLD_ENTRY_CT);
	eval 'sub BNX_RPM_DEBUG3_RDE_SRC_FIFO_ALMFULL () {(1<<21);}' unless defined(&BNX_RPM_DEBUG3_RDE_SRC_FIFO_ALMFULL);
	eval 'sub BNX_RPM_DEBUG3_DROP_NXT_VLD () {(1<<22);}' unless defined(&BNX_RPM_DEBUG3_DROP_NXT_VLD);
	eval 'sub BNX_RPM_DEBUG3_DROP_NXT () {(1<<23);}' unless defined(&BNX_RPM_DEBUG3_DROP_NXT);
	eval 'sub BNX_RPM_DEBUG3_FTQ_FSM () {(0x3<<24);}' unless defined(&BNX_RPM_DEBUG3_FTQ_FSM);
	eval 'sub BNX_RPM_DEBUG3_FTQ_FSM_IDLE () {(0x<<24);}' unless defined(&BNX_RPM_DEBUG3_FTQ_FSM_IDLE);
	eval 'sub BNX_RPM_DEBUG3_FTQ_FSM_WAIT_ACK () {(0x1<<24);}' unless defined(&BNX_RPM_DEBUG3_FTQ_FSM_WAIT_ACK);
	eval 'sub BNX_RPM_DEBUG3_FTQ_FSM_WAIT_FREE () {(0x2<<24);}' unless defined(&BNX_RPM_DEBUG3_FTQ_FSM_WAIT_FREE);
	eval 'sub BNX_RPM_DEBUG3_MBWRITE_FSM () {(0x3<<26);}' unless defined(&BNX_RPM_DEBUG3_MBWRITE_FSM);
	eval 'sub BNX_RPM_DEBUG3_MBWRITE_FSM_WAIT_SOF () {(0x<<26);}' unless defined(&BNX_RPM_DEBUG3_MBWRITE_FSM_WAIT_SOF);
	eval 'sub BNX_RPM_DEBUG3_MBWRITE_FSM_GET_MBUF () {(0x1<<26);}' unless defined(&BNX_RPM_DEBUG3_MBWRITE_FSM_GET_MBUF);
	eval 'sub BNX_RPM_DEBUG3_MBWRITE_FSM_DMA_DATA () {(0x2<<26);}' unless defined(&BNX_RPM_DEBUG3_MBWRITE_FSM_DMA_DATA);
	eval 'sub BNX_RPM_DEBUG3_MBWRITE_FSM_WAIT_DATA () {(0x3<<26);}' unless defined(&BNX_RPM_DEBUG3_MBWRITE_FSM_WAIT_DATA);
	eval 'sub BNX_RPM_DEBUG3_MBWRITE_FSM_WAIT_EOF () {(0x4<<26);}' unless defined(&BNX_RPM_DEBUG3_MBWRITE_FSM_WAIT_EOF);
	eval 'sub BNX_RPM_DEBUG3_MBWRITE_FSM_WAIT_MF_ACK () {(0x5<<26);}' unless defined(&BNX_RPM_DEBUG3_MBWRITE_FSM_WAIT_MF_ACK);
	eval 'sub BNX_RPM_DEBUG3_MBWRITE_FSM_WAIT_DROP_NXT_VLD () {(0x6<<26);}' unless defined(&BNX_RPM_DEBUG3_MBWRITE_FSM_WAIT_DROP_NXT_VLD);
	eval 'sub BNX_RPM_DEBUG3_MBWRITE_FSM_DONE () {(0x7<<26);}' unless defined(&BNX_RPM_DEBUG3_MBWRITE_FSM_DONE);
	eval 'sub BNX_RPM_DEBUG3_MBFREE_FSM () {(1<<29);}' unless defined(&BNX_RPM_DEBUG3_MBFREE_FSM);
	eval 'sub BNX_RPM_DEBUG3_MBFREE_FSM_IDLE () {(0<<29);}' unless defined(&BNX_RPM_DEBUG3_MBFREE_FSM_IDLE);
	eval 'sub BNX_RPM_DEBUG3_MBFREE_FSM_WAIT_ACK () {(1<<29);}' unless defined(&BNX_RPM_DEBUG3_MBFREE_FSM_WAIT_ACK);
	eval 'sub BNX_RPM_DEBUG3_MBALLOC_FSM () {(1<<30);}' unless defined(&BNX_RPM_DEBUG3_MBALLOC_FSM);
	eval 'sub BNX_RPM_DEBUG3_MBALLOC_FSM_ET_MBUF () {(0x<<30);}' unless defined(&BNX_RPM_DEBUG3_MBALLOC_FSM_ET_MBUF);
	eval 'sub BNX_RPM_DEBUG3_MBALLOC_FSM_IVE_MBUF () {(0x1<<30);}' unless defined(&BNX_RPM_DEBUG3_MBALLOC_FSM_IVE_MBUF);
	eval 'sub BNX_RPM_DEBUG3_CCODE_EOF_ERROR () {(1<<31);}' unless defined(&BNX_RPM_DEBUG3_CCODE_EOF_ERROR);
	eval 'sub BNX_RPM_DEBUG4 () {0x1994;}' unless defined(&BNX_RPM_DEBUG4);
	eval 'sub BNX_RPM_DEBUG4_DFSM_MBUF_CLUSTER () {(0x1ffffff<<0);}' unless defined(&BNX_RPM_DEBUG4_DFSM_MBUF_CLUSTER);
	eval 'sub BNX_RPM_DEBUG4_DFIFO_CUR_CCODE () {(0x7<<25);}' unless defined(&BNX_RPM_DEBUG4_DFIFO_CUR_CCODE);
	eval 'sub BNX_RPM_DEBUG4_MBWRITE_FSM () {(0x7<<28);}' unless defined(&BNX_RPM_DEBUG4_MBWRITE_FSM);
	eval 'sub BNX_RPM_DEBUG4_DFIFO_EMPTY () {(1<<31);}' unless defined(&BNX_RPM_DEBUG4_DFIFO_EMPTY);
	eval 'sub BNX_RPM_DEBUG5 () {0x1998;}' unless defined(&BNX_RPM_DEBUG5);
	eval 'sub BNX_RPM_DEBUG5_RDROP_WPTR () {(0x1f<<0);}' unless defined(&BNX_RPM_DEBUG5_RDROP_WPTR);
	eval 'sub BNX_RPM_DEBUG5_RDROP_ACPI_RPTR () {(0x1f<<5);}' unless defined(&BNX_RPM_DEBUG5_RDROP_ACPI_RPTR);
	eval 'sub BNX_RPM_DEBUG5_RDROP_MC_RPTR () {(0x1f<<10);}' unless defined(&BNX_RPM_DEBUG5_RDROP_MC_RPTR);
	eval 'sub BNX_RPM_DEBUG5_RDROP_RC_RPTR () {(0x1f<<15);}' unless defined(&BNX_RPM_DEBUG5_RDROP_RC_RPTR);
	eval 'sub BNX_RPM_DEBUG5_RDROP_ACPI_EMPTY () {(1<<20);}' unless defined(&BNX_RPM_DEBUG5_RDROP_ACPI_EMPTY);
	eval 'sub BNX_RPM_DEBUG5_RDROP_MC_EMPTY () {(1<<21);}' unless defined(&BNX_RPM_DEBUG5_RDROP_MC_EMPTY);
	eval 'sub BNX_RPM_DEBUG5_RDROP_AEOF_VEC_AT_RDROP_MC_RPTR () {(1<<22);}' unless defined(&BNX_RPM_DEBUG5_RDROP_AEOF_VEC_AT_RDROP_MC_RPTR);
	eval 'sub BNX_RPM_DEBUG5_HOLDREG_WOL_DROP_INT () {(1<<23);}' unless defined(&BNX_RPM_DEBUG5_HOLDREG_WOL_DROP_INT);
	eval 'sub BNX_RPM_DEBUG5_HOLDREG_DISCARD () {(1<<24);}' unless defined(&BNX_RPM_DEBUG5_HOLDREG_DISCARD);
	eval 'sub BNX_RPM_DEBUG5_HOLDREG_MBUF_NOTAVAIL () {(1<<25);}' unless defined(&BNX_RPM_DEBUG5_HOLDREG_MBUF_NOTAVAIL);
	eval 'sub BNX_RPM_DEBUG5_HOLDREG_MC_EMPTY () {(1<<26);}' unless defined(&BNX_RPM_DEBUG5_HOLDREG_MC_EMPTY);
	eval 'sub BNX_RPM_DEBUG5_HOLDREG_RC_EMPTY () {(1<<27);}' unless defined(&BNX_RPM_DEBUG5_HOLDREG_RC_EMPTY);
	eval 'sub BNX_RPM_DEBUG5_HOLDREG_FC_EMPTY () {(1<<28);}' unless defined(&BNX_RPM_DEBUG5_HOLDREG_FC_EMPTY);
	eval 'sub BNX_RPM_DEBUG5_HOLDREG_ACPI_EMPTY () {(1<<29);}' unless defined(&BNX_RPM_DEBUG5_HOLDREG_ACPI_EMPTY);
	eval 'sub BNX_RPM_DEBUG5_HOLDREG_FULL_T () {(1<<30);}' unless defined(&BNX_RPM_DEBUG5_HOLDREG_FULL_T);
	eval 'sub BNX_RPM_DEBUG5_HOLDREG_RD () {(1<<31);}' unless defined(&BNX_RPM_DEBUG5_HOLDREG_RD);
	eval 'sub BNX_RPM_DEBUG6 () {0x199c;}' unless defined(&BNX_RPM_DEBUG6);
	eval 'sub BNX_RPM_DEBUG6_ACPI_VEC () {(0xffff<<0);}' unless defined(&BNX_RPM_DEBUG6_ACPI_VEC);
	eval 'sub BNX_RPM_DEBUG6_VEC () {(0xffff<<16);}' unless defined(&BNX_RPM_DEBUG6_VEC);
	eval 'sub BNX_RPM_DEBUG7 () {0x19a0;}' unless defined(&BNX_RPM_DEBUG7);
	eval 'sub BNX_RPM_DEBUG7_RPM_DBG7_LAST_CRC () {(0xffffffff<<0);}' unless defined(&BNX_RPM_DEBUG7_RPM_DBG7_LAST_CRC);
	eval 'sub BNX_RPM_DEBUG8 () {0x19a4;}' unless defined(&BNX_RPM_DEBUG8);
	eval 'sub BNX_RPM_DEBUG8_PS_ACPI_FSM () {(0xf<<0);}' unless defined(&BNX_RPM_DEBUG8_PS_ACPI_FSM);
	eval 'sub BNX_RPM_DEBUG8_PS_ACPI_FSM_IDLE () {(0<<0);}' unless defined(&BNX_RPM_DEBUG8_PS_ACPI_FSM_IDLE);
	eval 'sub BNX_RPM_DEBUG8_PS_ACPI_FSM_SOF_W1_ADDR () {(1<<0);}' unless defined(&BNX_RPM_DEBUG8_PS_ACPI_FSM_SOF_W1_ADDR);
	eval 'sub BNX_RPM_DEBUG8_PS_ACPI_FSM_SOF_W2_ADDR () {(2<<0);}' unless defined(&BNX_RPM_DEBUG8_PS_ACPI_FSM_SOF_W2_ADDR);
	eval 'sub BNX_RPM_DEBUG8_PS_ACPI_FSM_SOF_W3_ADDR () {(3<<0);}' unless defined(&BNX_RPM_DEBUG8_PS_ACPI_FSM_SOF_W3_ADDR);
	eval 'sub BNX_RPM_DEBUG8_PS_ACPI_FSM_SOF_WAIT_THBUF () {(4<<0);}' unless defined(&BNX_RPM_DEBUG8_PS_ACPI_FSM_SOF_WAIT_THBUF);
	eval 'sub BNX_RPM_DEBUG8_PS_ACPI_FSM_W3_DATA () {(5<<0);}' unless defined(&BNX_RPM_DEBUG8_PS_ACPI_FSM_W3_DATA);
	eval 'sub BNX_RPM_DEBUG8_PS_ACPI_FSM_W0_ADDR () {(6<<0);}' unless defined(&BNX_RPM_DEBUG8_PS_ACPI_FSM_W0_ADDR);
	eval 'sub BNX_RPM_DEBUG8_PS_ACPI_FSM_W1_ADDR () {(7<<0);}' unless defined(&BNX_RPM_DEBUG8_PS_ACPI_FSM_W1_ADDR);
	eval 'sub BNX_RPM_DEBUG8_PS_ACPI_FSM_W2_ADDR () {(8<<0);}' unless defined(&BNX_RPM_DEBUG8_PS_ACPI_FSM_W2_ADDR);
	eval 'sub BNX_RPM_DEBUG8_PS_ACPI_FSM_W3_ADDR () {(9<<0);}' unless defined(&BNX_RPM_DEBUG8_PS_ACPI_FSM_W3_ADDR);
	eval 'sub BNX_RPM_DEBUG8_PS_ACPI_FSM_WAIT_THBUF () {(10<<0);}' unless defined(&BNX_RPM_DEBUG8_PS_ACPI_FSM_WAIT_THBUF);
	eval 'sub BNX_RPM_DEBUG8_COMPARE_AT_W0 () {(1<<4);}' unless defined(&BNX_RPM_DEBUG8_COMPARE_AT_W0);
	eval 'sub BNX_RPM_DEBUG8_COMPARE_AT_W3_DATA () {(1<<5);}' unless defined(&BNX_RPM_DEBUG8_COMPARE_AT_W3_DATA);
	eval 'sub BNX_RPM_DEBUG8_COMPARE_AT_SOF_WAIT () {(1<<6);}' unless defined(&BNX_RPM_DEBUG8_COMPARE_AT_SOF_WAIT);
	eval 'sub BNX_RPM_DEBUG8_COMPARE_AT_SOF_W3 () {(1<<7);}' unless defined(&BNX_RPM_DEBUG8_COMPARE_AT_SOF_W3);
	eval 'sub BNX_RPM_DEBUG8_COMPARE_AT_SOF_W2 () {(1<<8);}' unless defined(&BNX_RPM_DEBUG8_COMPARE_AT_SOF_W2);
	eval 'sub BNX_RPM_DEBUG8_EOF_W_LTEQ6_VLDBYTES () {(1<<9);}' unless defined(&BNX_RPM_DEBUG8_EOF_W_LTEQ6_VLDBYTES);
	eval 'sub BNX_RPM_DEBUG8_EOF_W_LTEQ4_VLDBYTES () {(1<<10);}' unless defined(&BNX_RPM_DEBUG8_EOF_W_LTEQ4_VLDBYTES);
	eval 'sub BNX_RPM_DEBUG8_NXT_EOF_W_12_VLDBYTES () {(1<<11);}' unless defined(&BNX_RPM_DEBUG8_NXT_EOF_W_12_VLDBYTES);
	eval 'sub BNX_RPM_DEBUG8_EOF_DET () {(1<<12);}' unless defined(&BNX_RPM_DEBUG8_EOF_DET);
	eval 'sub BNX_RPM_DEBUG8_SOF_DET () {(1<<13);}' unless defined(&BNX_RPM_DEBUG8_SOF_DET);
	eval 'sub BNX_RPM_DEBUG8_WAIT_4_SOF () {(1<<14);}' unless defined(&BNX_RPM_DEBUG8_WAIT_4_SOF);
	eval 'sub BNX_RPM_DEBUG8_ALL_DONE () {(1<<15);}' unless defined(&BNX_RPM_DEBUG8_ALL_DONE);
	eval 'sub BNX_RPM_DEBUG8_THBUF_ADDR () {(0x7f<<16);}' unless defined(&BNX_RPM_DEBUG8_THBUF_ADDR);
	eval 'sub BNX_RPM_DEBUG8_BYTE_CTR () {(0xff<<24);}' unless defined(&BNX_RPM_DEBUG8_BYTE_CTR);
	eval 'sub BNX_RPM_DEBUG9 () {0x19a8;}' unless defined(&BNX_RPM_DEBUG9);
	eval 'sub BNX_RPM_DEBUG9_OUTFIFO_COUNT () {(0x7<<0);}' unless defined(&BNX_RPM_DEBUG9_OUTFIFO_COUNT);
	eval 'sub BNX_RPM_DEBUG9_RDE_ACPI_RDY () {(1<<3);}' unless defined(&BNX_RPM_DEBUG9_RDE_ACPI_RDY);
	eval 'sub BNX_RPM_DEBUG9_VLD_RD_ENTRY_CT () {(0x7<<4);}' unless defined(&BNX_RPM_DEBUG9_VLD_RD_ENTRY_CT);
	eval 'sub BNX_RPM_DEBUG9_OUTFIFO_OVERRUN_OCCURRED () {(1<<28);}' unless defined(&BNX_RPM_DEBUG9_OUTFIFO_OVERRUN_OCCURRED);
	eval 'sub BNX_RPM_DEBUG9_INFIFO_OVERRUN_OCCURRED () {(1<<29);}' unless defined(&BNX_RPM_DEBUG9_INFIFO_OVERRUN_OCCURRED);
	eval 'sub BNX_RPM_DEBUG9_ACPI_MATCH_INT () {(1<<30);}' unless defined(&BNX_RPM_DEBUG9_ACPI_MATCH_INT);
	eval 'sub BNX_RPM_DEBUG9_ACPI_ENABLE_SYN () {(1<<31);}' unless defined(&BNX_RPM_DEBUG9_ACPI_ENABLE_SYN);
	eval 'sub BNX_RPM_ACPI_DBG_BUF_W00 () {0x19c0;}' unless defined(&BNX_RPM_ACPI_DBG_BUF_W00);
	eval 'sub BNX_RPM_ACPI_DBG_BUF_W01 () {0x19c4;}' unless defined(&BNX_RPM_ACPI_DBG_BUF_W01);
	eval 'sub BNX_RPM_ACPI_DBG_BUF_W02 () {0x19c8;}' unless defined(&BNX_RPM_ACPI_DBG_BUF_W02);
	eval 'sub BNX_RPM_ACPI_DBG_BUF_W03 () {0x19cc;}' unless defined(&BNX_RPM_ACPI_DBG_BUF_W03);
	eval 'sub BNX_RPM_ACPI_DBG_BUF_W10 () {0x19d0;}' unless defined(&BNX_RPM_ACPI_DBG_BUF_W10);
	eval 'sub BNX_RPM_ACPI_DBG_BUF_W11 () {0x19d4;}' unless defined(&BNX_RPM_ACPI_DBG_BUF_W11);
	eval 'sub BNX_RPM_ACPI_DBG_BUF_W12 () {0x19d8;}' unless defined(&BNX_RPM_ACPI_DBG_BUF_W12);
	eval 'sub BNX_RPM_ACPI_DBG_BUF_W13 () {0x19dc;}' unless defined(&BNX_RPM_ACPI_DBG_BUF_W13);
	eval 'sub BNX_RPM_ACPI_DBG_BUF_W20 () {0x19e0;}' unless defined(&BNX_RPM_ACPI_DBG_BUF_W20);
	eval 'sub BNX_RPM_ACPI_DBG_BUF_W21 () {0x19e4;}' unless defined(&BNX_RPM_ACPI_DBG_BUF_W21);
	eval 'sub BNX_RPM_ACPI_DBG_BUF_W22 () {0x19e8;}' unless defined(&BNX_RPM_ACPI_DBG_BUF_W22);
	eval 'sub BNX_RPM_ACPI_DBG_BUF_W23 () {0x19ec;}' unless defined(&BNX_RPM_ACPI_DBG_BUF_W23);
	eval 'sub BNX_RPM_ACPI_DBG_BUF_W30 () {0x19f0;}' unless defined(&BNX_RPM_ACPI_DBG_BUF_W30);
	eval 'sub BNX_RPM_ACPI_DBG_BUF_W31 () {0x19f4;}' unless defined(&BNX_RPM_ACPI_DBG_BUF_W31);
	eval 'sub BNX_RPM_ACPI_DBG_BUF_W32 () {0x19f8;}' unless defined(&BNX_RPM_ACPI_DBG_BUF_W32);
	eval 'sub BNX_RPM_ACPI_DBG_BUF_W33 () {0x19fc;}' unless defined(&BNX_RPM_ACPI_DBG_BUF_W33);
	eval 'sub BNX_RBUF_COMMAND () {0x200000;}' unless defined(&BNX_RBUF_COMMAND);
	eval 'sub BNX_RBUF_COMMAND_ENABLED () {(1<<0);}' unless defined(&BNX_RBUF_COMMAND_ENABLED);
	eval 'sub BNX_RBUF_COMMAND_FREE_INIT () {(1<<1);}' unless defined(&BNX_RBUF_COMMAND_FREE_INIT);
	eval 'sub BNX_RBUF_COMMAND_RAM_INIT () {(1<<2);}' unless defined(&BNX_RBUF_COMMAND_RAM_INIT);
	eval 'sub BNX_RBUF_COMMAND_OVER_FREE () {(1<<4);}' unless defined(&BNX_RBUF_COMMAND_OVER_FREE);
	eval 'sub BNX_RBUF_COMMAND_ALLOC_REQ () {(1<<5);}' unless defined(&BNX_RBUF_COMMAND_ALLOC_REQ);
	eval 'sub BNX_RBUF_STATUS1 () {0x200004;}' unless defined(&BNX_RBUF_STATUS1);
	eval 'sub BNX_RBUF_STATUS1_FREE_COUNT () {(0x3ff<<0);}' unless defined(&BNX_RBUF_STATUS1_FREE_COUNT);
	eval 'sub BNX_RBUF_STATUS2 () {0x200008;}' unless defined(&BNX_RBUF_STATUS2);
	eval 'sub BNX_RBUF_STATUS2_FREE_TAIL () {(0x3ff<<0);}' unless defined(&BNX_RBUF_STATUS2_FREE_TAIL);
	eval 'sub BNX_RBUF_STATUS2_FREE_HEAD () {(0x3ff<<16);}' unless defined(&BNX_RBUF_STATUS2_FREE_HEAD);
	eval 'sub BNX_RBUF_CONFIG () {0x20000c;}' unless defined(&BNX_RBUF_CONFIG);
	eval 'sub BNX_RBUF_CONFIG_XOFF_TRIP () {(0x3ff<<0);}' unless defined(&BNX_RBUF_CONFIG_XOFF_TRIP);
	eval 'sub BNX_RBUF_CONFIG_XON_TRIP () {(0x3ff<<16);}' unless defined(&BNX_RBUF_CONFIG_XON_TRIP);
	eval 'sub BNX_RBUF_FW_BUF_ALLOC () {0x200010;}' unless defined(&BNX_RBUF_FW_BUF_ALLOC);
	eval 'sub BNX_RBUF_FW_BUF_ALLOC_VALUE () {(0x1ff<<7);}' unless defined(&BNX_RBUF_FW_BUF_ALLOC_VALUE);
	eval 'sub BNX_RBUF_FW_BUF_FREE () {0x200014;}' unless defined(&BNX_RBUF_FW_BUF_FREE);
	eval 'sub BNX_RBUF_FW_BUF_FREE_COUNT () {(0x7f<<0);}' unless defined(&BNX_RBUF_FW_BUF_FREE_COUNT);
	eval 'sub BNX_RBUF_FW_BUF_FREE_TAIL () {(0x1ff<<7);}' unless defined(&BNX_RBUF_FW_BUF_FREE_TAIL);
	eval 'sub BNX_RBUF_FW_BUF_FREE_HEAD () {(0x1ff<<16);}' unless defined(&BNX_RBUF_FW_BUF_FREE_HEAD);
	eval 'sub BNX_RBUF_FW_BUF_SEL () {0x200018;}' unless defined(&BNX_RBUF_FW_BUF_SEL);
	eval 'sub BNX_RBUF_FW_BUF_SEL_COUNT () {(0x7f<<0);}' unless defined(&BNX_RBUF_FW_BUF_SEL_COUNT);
	eval 'sub BNX_RBUF_FW_BUF_SEL_TAIL () {(0x1ff<<7);}' unless defined(&BNX_RBUF_FW_BUF_SEL_TAIL);
	eval 'sub BNX_RBUF_FW_BUF_SEL_HEAD () {(0x1ff<<16);}' unless defined(&BNX_RBUF_FW_BUF_SEL_HEAD);
	eval 'sub BNX_RBUF_CONFIG2 () {0x20001c;}' unless defined(&BNX_RBUF_CONFIG2);
	eval 'sub BNX_RBUF_CONFIG2_MAC_DROP_TRIP () {(0x3ff<<0);}' unless defined(&BNX_RBUF_CONFIG2_MAC_DROP_TRIP);
	eval 'sub BNX_RBUF_CONFIG2_MAC_KEEP_TRIP () {(0x3ff<<16);}' unless defined(&BNX_RBUF_CONFIG2_MAC_KEEP_TRIP);
	eval 'sub BNX_RBUF_CONFIG3 () {0x200020;}' unless defined(&BNX_RBUF_CONFIG3);
	eval 'sub BNX_RBUF_CONFIG3_CU_DROP_TRIP () {(0x3ff<<0);}' unless defined(&BNX_RBUF_CONFIG3_CU_DROP_TRIP);
	eval 'sub BNX_RBUF_CONFIG3_CU_KEEP_TRIP () {(0x3ff<<16);}' unless defined(&BNX_RBUF_CONFIG3_CU_KEEP_TRIP);
	eval 'sub BNX_RBUF_PKT_DATA () {0x208000;}' unless defined(&BNX_RBUF_PKT_DATA);
	eval 'sub BNX_RBUF_CLIST_DATA () {0x210000;}' unless defined(&BNX_RBUF_CLIST_DATA);
	eval 'sub BNX_RBUF_BUF_DATA () {0x220000;}' unless defined(&BNX_RBUF_BUF_DATA);
	eval 'sub BNX_RV2P_COMMAND () {0x2800;}' unless defined(&BNX_RV2P_COMMAND);
	eval 'sub BNX_RV2P_COMMAND_ENABLED () {(1<<0);}' unless defined(&BNX_RV2P_COMMAND_ENABLED);
	eval 'sub BNX_RV2P_COMMAND_PROC1_INTRPT () {(1<<1);}' unless defined(&BNX_RV2P_COMMAND_PROC1_INTRPT);
	eval 'sub BNX_RV2P_COMMAND_PROC2_INTRPT () {(1<<2);}' unless defined(&BNX_RV2P_COMMAND_PROC2_INTRPT);
	eval 'sub BNX_RV2P_COMMAND_ABORT0 () {(1<<4);}' unless defined(&BNX_RV2P_COMMAND_ABORT0);
	eval 'sub BNX_RV2P_COMMAND_ABORT1 () {(1<<5);}' unless defined(&BNX_RV2P_COMMAND_ABORT1);
	eval 'sub BNX_RV2P_COMMAND_ABORT2 () {(1<<6);}' unless defined(&BNX_RV2P_COMMAND_ABORT2);
	eval 'sub BNX_RV2P_COMMAND_ABORT3 () {(1<<7);}' unless defined(&BNX_RV2P_COMMAND_ABORT3);
	eval 'sub BNX_RV2P_COMMAND_ABORT4 () {(1<<8);}' unless defined(&BNX_RV2P_COMMAND_ABORT4);
	eval 'sub BNX_RV2P_COMMAND_ABORT5 () {(1<<9);}' unless defined(&BNX_RV2P_COMMAND_ABORT5);
	eval 'sub BNX_RV2P_COMMAND_PROC1_RESET () {(1<<16);}' unless defined(&BNX_RV2P_COMMAND_PROC1_RESET);
	eval 'sub BNX_RV2P_COMMAND_PROC2_RESET () {(1<<17);}' unless defined(&BNX_RV2P_COMMAND_PROC2_RESET);
	eval 'sub BNX_RV2P_COMMAND_CTXIF_RESET () {(1<<18);}' unless defined(&BNX_RV2P_COMMAND_CTXIF_RESET);
	eval 'sub BNX_RV2P_STATUS () {0x2804;}' unless defined(&BNX_RV2P_STATUS);
	eval 'sub BNX_RV2P_STATUS_ALWAYS_0 () {(1<<0);}' unless defined(&BNX_RV2P_STATUS_ALWAYS_0);
	eval 'sub BNX_RV2P_STATUS_RV2P_GEN_STAT0_CNT () {(1<<8);}' unless defined(&BNX_RV2P_STATUS_RV2P_GEN_STAT0_CNT);
	eval 'sub BNX_RV2P_STATUS_RV2P_GEN_STAT1_CNT () {(1<<9);}' unless defined(&BNX_RV2P_STATUS_RV2P_GEN_STAT1_CNT);
	eval 'sub BNX_RV2P_STATUS_RV2P_GEN_STAT2_CNT () {(1<<10);}' unless defined(&BNX_RV2P_STATUS_RV2P_GEN_STAT2_CNT);
	eval 'sub BNX_RV2P_STATUS_RV2P_GEN_STAT3_CNT () {(1<<11);}' unless defined(&BNX_RV2P_STATUS_RV2P_GEN_STAT3_CNT);
	eval 'sub BNX_RV2P_STATUS_RV2P_GEN_STAT4_CNT () {(1<<12);}' unless defined(&BNX_RV2P_STATUS_RV2P_GEN_STAT4_CNT);
	eval 'sub BNX_RV2P_STATUS_RV2P_GEN_STAT5_CNT () {(1<<13);}' unless defined(&BNX_RV2P_STATUS_RV2P_GEN_STAT5_CNT);
	eval 'sub BNX_RV2P_CONFIG () {0x2808;}' unless defined(&BNX_RV2P_CONFIG);
	eval 'sub BNX_RV2P_CONFIG_STALL_PROC1 () {(1<<0);}' unless defined(&BNX_RV2P_CONFIG_STALL_PROC1);
	eval 'sub BNX_RV2P_CONFIG_STALL_PROC2 () {(1<<1);}' unless defined(&BNX_RV2P_CONFIG_STALL_PROC2);
	eval 'sub BNX_RV2P_CONFIG_PROC1_STALL_ON_ABORT0 () {(1<<8);}' unless defined(&BNX_RV2P_CONFIG_PROC1_STALL_ON_ABORT0);
	eval 'sub BNX_RV2P_CONFIG_PROC1_STALL_ON_ABORT1 () {(1<<9);}' unless defined(&BNX_RV2P_CONFIG_PROC1_STALL_ON_ABORT1);
	eval 'sub BNX_RV2P_CONFIG_PROC1_STALL_ON_ABORT2 () {(1<<10);}' unless defined(&BNX_RV2P_CONFIG_PROC1_STALL_ON_ABORT2);
	eval 'sub BNX_RV2P_CONFIG_PROC1_STALL_ON_ABORT3 () {(1<<11);}' unless defined(&BNX_RV2P_CONFIG_PROC1_STALL_ON_ABORT3);
	eval 'sub BNX_RV2P_CONFIG_PROC1_STALL_ON_ABORT4 () {(1<<12);}' unless defined(&BNX_RV2P_CONFIG_PROC1_STALL_ON_ABORT4);
	eval 'sub BNX_RV2P_CONFIG_PROC1_STALL_ON_ABORT5 () {(1<<13);}' unless defined(&BNX_RV2P_CONFIG_PROC1_STALL_ON_ABORT5);
	eval 'sub BNX_RV2P_CONFIG_PROC2_STALL_ON_ABORT0 () {(1<<16);}' unless defined(&BNX_RV2P_CONFIG_PROC2_STALL_ON_ABORT0);
	eval 'sub BNX_RV2P_CONFIG_PROC2_STALL_ON_ABORT1 () {(1<<17);}' unless defined(&BNX_RV2P_CONFIG_PROC2_STALL_ON_ABORT1);
	eval 'sub BNX_RV2P_CONFIG_PROC2_STALL_ON_ABORT2 () {(1<<18);}' unless defined(&BNX_RV2P_CONFIG_PROC2_STALL_ON_ABORT2);
	eval 'sub BNX_RV2P_CONFIG_PROC2_STALL_ON_ABORT3 () {(1<<19);}' unless defined(&BNX_RV2P_CONFIG_PROC2_STALL_ON_ABORT3);
	eval 'sub BNX_RV2P_CONFIG_PROC2_STALL_ON_ABORT4 () {(1<<20);}' unless defined(&BNX_RV2P_CONFIG_PROC2_STALL_ON_ABORT4);
	eval 'sub BNX_RV2P_CONFIG_PROC2_STALL_ON_ABORT5 () {(1<<21);}' unless defined(&BNX_RV2P_CONFIG_PROC2_STALL_ON_ABORT5);
	eval 'sub BNX_RV2P_CONFIG_PAGE_SIZE () {(0xf<<24);}' unless defined(&BNX_RV2P_CONFIG_PAGE_SIZE);
	eval 'sub BNX_RV2P_CONFIG_PAGE_SIZE_256 () {(0<<24);}' unless defined(&BNX_RV2P_CONFIG_PAGE_SIZE_256);
	eval 'sub BNX_RV2P_CONFIG_PAGE_SIZE_512 () {(1<<24);}' unless defined(&BNX_RV2P_CONFIG_PAGE_SIZE_512);
	eval 'sub BNX_RV2P_CONFIG_PAGE_SIZE_1K () {(2<<24);}' unless defined(&BNX_RV2P_CONFIG_PAGE_SIZE_1K);
	eval 'sub BNX_RV2P_CONFIG_PAGE_SIZE_2K () {(3<<24);}' unless defined(&BNX_RV2P_CONFIG_PAGE_SIZE_2K);
	eval 'sub BNX_RV2P_CONFIG_PAGE_SIZE_4K () {(4<<24);}' unless defined(&BNX_RV2P_CONFIG_PAGE_SIZE_4K);
	eval 'sub BNX_RV2P_CONFIG_PAGE_SIZE_8K () {(5<<24);}' unless defined(&BNX_RV2P_CONFIG_PAGE_SIZE_8K);
	eval 'sub BNX_RV2P_CONFIG_PAGE_SIZE_16K () {(6<<24);}' unless defined(&BNX_RV2P_CONFIG_PAGE_SIZE_16K);
	eval 'sub BNX_RV2P_CONFIG_PAGE_SIZE_32K () {(7<<24);}' unless defined(&BNX_RV2P_CONFIG_PAGE_SIZE_32K);
	eval 'sub BNX_RV2P_CONFIG_PAGE_SIZE_64K () {(8<<24);}' unless defined(&BNX_RV2P_CONFIG_PAGE_SIZE_64K);
	eval 'sub BNX_RV2P_CONFIG_PAGE_SIZE_128K () {(9<<24);}' unless defined(&BNX_RV2P_CONFIG_PAGE_SIZE_128K);
	eval 'sub BNX_RV2P_CONFIG_PAGE_SIZE_256K () {(10<<24);}' unless defined(&BNX_RV2P_CONFIG_PAGE_SIZE_256K);
	eval 'sub BNX_RV2P_CONFIG_PAGE_SIZE_512K () {(11<<24);}' unless defined(&BNX_RV2P_CONFIG_PAGE_SIZE_512K);
	eval 'sub BNX_RV2P_CONFIG_PAGE_SIZE_1M () {(12<<24);}' unless defined(&BNX_RV2P_CONFIG_PAGE_SIZE_1M);
	eval 'sub BNX_RV2P_GEN_BFR_ADDR_0 () {0x2810;}' unless defined(&BNX_RV2P_GEN_BFR_ADDR_0);
	eval 'sub BNX_RV2P_GEN_BFR_ADDR_0_VALUE () {(0xffff<<16);}' unless defined(&BNX_RV2P_GEN_BFR_ADDR_0_VALUE);
	eval 'sub BNX_RV2P_GEN_BFR_ADDR_1 () {0x2814;}' unless defined(&BNX_RV2P_GEN_BFR_ADDR_1);
	eval 'sub BNX_RV2P_GEN_BFR_ADDR_1_VALUE () {(0xffff<<16);}' unless defined(&BNX_RV2P_GEN_BFR_ADDR_1_VALUE);
	eval 'sub BNX_RV2P_GEN_BFR_ADDR_2 () {0x2818;}' unless defined(&BNX_RV2P_GEN_BFR_ADDR_2);
	eval 'sub BNX_RV2P_GEN_BFR_ADDR_2_VALUE () {(0xffff<<16);}' unless defined(&BNX_RV2P_GEN_BFR_ADDR_2_VALUE);
	eval 'sub BNX_RV2P_GEN_BFR_ADDR_3 () {0x281c;}' unless defined(&BNX_RV2P_GEN_BFR_ADDR_3);
	eval 'sub BNX_RV2P_GEN_BFR_ADDR_3_VALUE () {(0xffff<<16);}' unless defined(&BNX_RV2P_GEN_BFR_ADDR_3_VALUE);
	eval 'sub BNX_RV2P_INSTR_HIGH () {0x2830;}' unless defined(&BNX_RV2P_INSTR_HIGH);
	eval 'sub BNX_RV2P_INSTR_HIGH_HIGH () {(0x1f<<0);}' unless defined(&BNX_RV2P_INSTR_HIGH_HIGH);
	eval 'sub BNX_RV2P_INSTR_LOW () {0x2834;}' unless defined(&BNX_RV2P_INSTR_LOW);
	eval 'sub BNX_RV2P_PROC1_ADDR_CMD () {0x2838;}' unless defined(&BNX_RV2P_PROC1_ADDR_CMD);
	eval 'sub BNX_RV2P_PROC1_ADDR_CMD_ADD () {(0x3ff<<0);}' unless defined(&BNX_RV2P_PROC1_ADDR_CMD_ADD);
	eval 'sub BNX_RV2P_PROC1_ADDR_CMD_RDWR () {(1<<31);}' unless defined(&BNX_RV2P_PROC1_ADDR_CMD_RDWR);
	eval 'sub BNX_RV2P_PROC2_ADDR_CMD () {0x283c;}' unless defined(&BNX_RV2P_PROC2_ADDR_CMD);
	eval 'sub BNX_RV2P_PROC2_ADDR_CMD_ADD () {(0x3ff<<0);}' unless defined(&BNX_RV2P_PROC2_ADDR_CMD_ADD);
	eval 'sub BNX_RV2P_PROC2_ADDR_CMD_RDWR () {(1<<31);}' unless defined(&BNX_RV2P_PROC2_ADDR_CMD_RDWR);
	eval 'sub BNX_RV2P_PROC1_GRC_DEBUG () {0x2840;}' unless defined(&BNX_RV2P_PROC1_GRC_DEBUG);
	eval 'sub BNX_RV2P_PROC2_GRC_DEBUG () {0x2844;}' unless defined(&BNX_RV2P_PROC2_GRC_DEBUG);
	eval 'sub BNX_RV2P_GRC_PROC_DEBUG () {0x2848;}' unless defined(&BNX_RV2P_GRC_PROC_DEBUG);
	eval 'sub BNX_RV2P_DEBUG_VECT_PEEK () {0x284c;}' unless defined(&BNX_RV2P_DEBUG_VECT_PEEK);
	eval 'sub BNX_RV2P_DEBUG_VECT_PEEK_1_VALUE () {(0x7ff<<0);}' unless defined(&BNX_RV2P_DEBUG_VECT_PEEK_1_VALUE);
	eval 'sub BNX_RV2P_DEBUG_VECT_PEEK_1_PEEK_EN () {(1<<11);}' unless defined(&BNX_RV2P_DEBUG_VECT_PEEK_1_PEEK_EN);
	eval 'sub BNX_RV2P_DEBUG_VECT_PEEK_1_SEL () {(0xf<<12);}' unless defined(&BNX_RV2P_DEBUG_VECT_PEEK_1_SEL);
	eval 'sub BNX_RV2P_DEBUG_VECT_PEEK_2_VALUE () {(0x7ff<<16);}' unless defined(&BNX_RV2P_DEBUG_VECT_PEEK_2_VALUE);
	eval 'sub BNX_RV2P_DEBUG_VECT_PEEK_2_PEEK_EN () {(1<<27);}' unless defined(&BNX_RV2P_DEBUG_VECT_PEEK_2_PEEK_EN);
	eval 'sub BNX_RV2P_DEBUG_VECT_PEEK_2_SEL () {(0xf<<28);}' unless defined(&BNX_RV2P_DEBUG_VECT_PEEK_2_SEL);
	eval 'sub BNX_RV2P_PFTQ_DATA () {0x2b40;}' unless defined(&BNX_RV2P_PFTQ_DATA);
	eval 'sub BNX_RV2P_PFTQ_CMD () {0x2b78;}' unless defined(&BNX_RV2P_PFTQ_CMD);
	eval 'sub BNX_RV2P_PFTQ_CMD_OFFSET () {(0x3ff<<0);}' unless defined(&BNX_RV2P_PFTQ_CMD_OFFSET);
	eval 'sub BNX_RV2P_PFTQ_CMD_WR_TOP () {(1<<10);}' unless defined(&BNX_RV2P_PFTQ_CMD_WR_TOP);
	eval 'sub BNX_RV2P_PFTQ_CMD_WR_TOP_0 () {(0<<10);}' unless defined(&BNX_RV2P_PFTQ_CMD_WR_TOP_0);
	eval 'sub BNX_RV2P_PFTQ_CMD_WR_TOP_1 () {(1<<10);}' unless defined(&BNX_RV2P_PFTQ_CMD_WR_TOP_1);
	eval 'sub BNX_RV2P_PFTQ_CMD_SFT_RESET () {(1<<25);}' unless defined(&BNX_RV2P_PFTQ_CMD_SFT_RESET);
	eval 'sub BNX_RV2P_PFTQ_CMD_RD_DATA () {(1<<26);}' unless defined(&BNX_RV2P_PFTQ_CMD_RD_DATA);
	eval 'sub BNX_RV2P_PFTQ_CMD_ADD_INTERVEN () {(1<<27);}' unless defined(&BNX_RV2P_PFTQ_CMD_ADD_INTERVEN);
	eval 'sub BNX_RV2P_PFTQ_CMD_ADD_DATA () {(1<<28);}' unless defined(&BNX_RV2P_PFTQ_CMD_ADD_DATA);
	eval 'sub BNX_RV2P_PFTQ_CMD_INTERVENE_CLR () {(1<<29);}' unless defined(&BNX_RV2P_PFTQ_CMD_INTERVENE_CLR);
	eval 'sub BNX_RV2P_PFTQ_CMD_POP () {(1<<30);}' unless defined(&BNX_RV2P_PFTQ_CMD_POP);
	eval 'sub BNX_RV2P_PFTQ_CMD_BUSY () {(1<<31);}' unless defined(&BNX_RV2P_PFTQ_CMD_BUSY);
	eval 'sub BNX_RV2P_PFTQ_CTL () {0x2b7c;}' unless defined(&BNX_RV2P_PFTQ_CTL);
	eval 'sub BNX_RV2P_PFTQ_CTL_INTERVENE () {(1<<0);}' unless defined(&BNX_RV2P_PFTQ_CTL_INTERVENE);
	eval 'sub BNX_RV2P_PFTQ_CTL_OVERFLOW () {(1<<1);}' unless defined(&BNX_RV2P_PFTQ_CTL_OVERFLOW);
	eval 'sub BNX_RV2P_PFTQ_CTL_FORCE_INTERVENE () {(1<<2);}' unless defined(&BNX_RV2P_PFTQ_CTL_FORCE_INTERVENE);
	eval 'sub BNX_RV2P_PFTQ_CTL_MAX_DEPTH () {(0x3ff<<12);}' unless defined(&BNX_RV2P_PFTQ_CTL_MAX_DEPTH);
	eval 'sub BNX_RV2P_PFTQ_CTL_CUR_DEPTH () {(0x3ff<<22);}' unless defined(&BNX_RV2P_PFTQ_CTL_CUR_DEPTH);
	eval 'sub BNX_RV2P_TFTQ_DATA () {0x2b80;}' unless defined(&BNX_RV2P_TFTQ_DATA);
	eval 'sub BNX_RV2P_TFTQ_CMD () {0x2bb8;}' unless defined(&BNX_RV2P_TFTQ_CMD);
	eval 'sub BNX_RV2P_TFTQ_CMD_OFFSET () {(0x3ff<<0);}' unless defined(&BNX_RV2P_TFTQ_CMD_OFFSET);
	eval 'sub BNX_RV2P_TFTQ_CMD_WR_TOP () {(1<<10);}' unless defined(&BNX_RV2P_TFTQ_CMD_WR_TOP);
	eval 'sub BNX_RV2P_TFTQ_CMD_WR_TOP_0 () {(0<<10);}' unless defined(&BNX_RV2P_TFTQ_CMD_WR_TOP_0);
	eval 'sub BNX_RV2P_TFTQ_CMD_WR_TOP_1 () {(1<<10);}' unless defined(&BNX_RV2P_TFTQ_CMD_WR_TOP_1);
	eval 'sub BNX_RV2P_TFTQ_CMD_SFT_RESET () {(1<<25);}' unless defined(&BNX_RV2P_TFTQ_CMD_SFT_RESET);
	eval 'sub BNX_RV2P_TFTQ_CMD_RD_DATA () {(1<<26);}' unless defined(&BNX_RV2P_TFTQ_CMD_RD_DATA);
	eval 'sub BNX_RV2P_TFTQ_CMD_ADD_INTERVEN () {(1<<27);}' unless defined(&BNX_RV2P_TFTQ_CMD_ADD_INTERVEN);
	eval 'sub BNX_RV2P_TFTQ_CMD_ADD_DATA () {(1<<28);}' unless defined(&BNX_RV2P_TFTQ_CMD_ADD_DATA);
	eval 'sub BNX_RV2P_TFTQ_CMD_INTERVENE_CLR () {(1<<29);}' unless defined(&BNX_RV2P_TFTQ_CMD_INTERVENE_CLR);
	eval 'sub BNX_RV2P_TFTQ_CMD_POP () {(1<<30);}' unless defined(&BNX_RV2P_TFTQ_CMD_POP);
	eval 'sub BNX_RV2P_TFTQ_CMD_BUSY () {(1<<31);}' unless defined(&BNX_RV2P_TFTQ_CMD_BUSY);
	eval 'sub BNX_RV2P_TFTQ_CTL () {0x2bbc;}' unless defined(&BNX_RV2P_TFTQ_CTL);
	eval 'sub BNX_RV2P_TFTQ_CTL_INTERVENE () {(1<<0);}' unless defined(&BNX_RV2P_TFTQ_CTL_INTERVENE);
	eval 'sub BNX_RV2P_TFTQ_CTL_OVERFLOW () {(1<<1);}' unless defined(&BNX_RV2P_TFTQ_CTL_OVERFLOW);
	eval 'sub BNX_RV2P_TFTQ_CTL_FORCE_INTERVENE () {(1<<2);}' unless defined(&BNX_RV2P_TFTQ_CTL_FORCE_INTERVENE);
	eval 'sub BNX_RV2P_TFTQ_CTL_MAX_DEPTH () {(0x3ff<<12);}' unless defined(&BNX_RV2P_TFTQ_CTL_MAX_DEPTH);
	eval 'sub BNX_RV2P_TFTQ_CTL_CUR_DEPTH () {(0x3ff<<22);}' unless defined(&BNX_RV2P_TFTQ_CTL_CUR_DEPTH);
	eval 'sub BNX_RV2P_MFTQ_DATA () {0x2bc0;}' unless defined(&BNX_RV2P_MFTQ_DATA);
	eval 'sub BNX_RV2P_MFTQ_CMD () {0x2bf8;}' unless defined(&BNX_RV2P_MFTQ_CMD);
	eval 'sub BNX_RV2P_MFTQ_CMD_OFFSET () {(0x3ff<<0);}' unless defined(&BNX_RV2P_MFTQ_CMD_OFFSET);
	eval 'sub BNX_RV2P_MFTQ_CMD_WR_TOP () {(1<<10);}' unless defined(&BNX_RV2P_MFTQ_CMD_WR_TOP);
	eval 'sub BNX_RV2P_MFTQ_CMD_WR_TOP_0 () {(0<<10);}' unless defined(&BNX_RV2P_MFTQ_CMD_WR_TOP_0);
	eval 'sub BNX_RV2P_MFTQ_CMD_WR_TOP_1 () {(1<<10);}' unless defined(&BNX_RV2P_MFTQ_CMD_WR_TOP_1);
	eval 'sub BNX_RV2P_MFTQ_CMD_SFT_RESET () {(1<<25);}' unless defined(&BNX_RV2P_MFTQ_CMD_SFT_RESET);
	eval 'sub BNX_RV2P_MFTQ_CMD_RD_DATA () {(1<<26);}' unless defined(&BNX_RV2P_MFTQ_CMD_RD_DATA);
	eval 'sub BNX_RV2P_MFTQ_CMD_ADD_INTERVEN () {(1<<27);}' unless defined(&BNX_RV2P_MFTQ_CMD_ADD_INTERVEN);
	eval 'sub BNX_RV2P_MFTQ_CMD_ADD_DATA () {(1<<28);}' unless defined(&BNX_RV2P_MFTQ_CMD_ADD_DATA);
	eval 'sub BNX_RV2P_MFTQ_CMD_INTERVENE_CLR () {(1<<29);}' unless defined(&BNX_RV2P_MFTQ_CMD_INTERVENE_CLR);
	eval 'sub BNX_RV2P_MFTQ_CMD_POP () {(1<<30);}' unless defined(&BNX_RV2P_MFTQ_CMD_POP);
	eval 'sub BNX_RV2P_MFTQ_CMD_BUSY () {(1<<31);}' unless defined(&BNX_RV2P_MFTQ_CMD_BUSY);
	eval 'sub BNX_RV2P_MFTQ_CTL () {0x2bfc;}' unless defined(&BNX_RV2P_MFTQ_CTL);
	eval 'sub BNX_RV2P_MFTQ_CTL_INTERVENE () {(1<<0);}' unless defined(&BNX_RV2P_MFTQ_CTL_INTERVENE);
	eval 'sub BNX_RV2P_MFTQ_CTL_OVERFLOW () {(1<<1);}' unless defined(&BNX_RV2P_MFTQ_CTL_OVERFLOW);
	eval 'sub BNX_RV2P_MFTQ_CTL_FORCE_INTERVENE () {(1<<2);}' unless defined(&BNX_RV2P_MFTQ_CTL_FORCE_INTERVENE);
	eval 'sub BNX_RV2P_MFTQ_CTL_MAX_DEPTH () {(0x3ff<<12);}' unless defined(&BNX_RV2P_MFTQ_CTL_MAX_DEPTH);
	eval 'sub BNX_RV2P_MFTQ_CTL_CUR_DEPTH () {(0x3ff<<22);}' unless defined(&BNX_RV2P_MFTQ_CTL_CUR_DEPTH);
	eval 'sub BNX_MQ_COMMAND () {0x3c00;}' unless defined(&BNX_MQ_COMMAND);
	eval 'sub BNX_MQ_COMMAND_ENABLED () {(1<<0);}' unless defined(&BNX_MQ_COMMAND_ENABLED);
	eval 'sub BNX_MQ_COMMAND_OVERFLOW () {(1<<4);}' unless defined(&BNX_MQ_COMMAND_OVERFLOW);
	eval 'sub BNX_MQ_COMMAND_WR_ERROR () {(1<<5);}' unless defined(&BNX_MQ_COMMAND_WR_ERROR);
	eval 'sub BNX_MQ_COMMAND_RD_ERROR () {(1<<6);}' unless defined(&BNX_MQ_COMMAND_RD_ERROR);
	eval 'sub BNX_MQ_STATUS () {0x3c04;}' unless defined(&BNX_MQ_STATUS);
	eval 'sub BNX_MQ_STATUS_CTX_ACCESS_STAT () {(1<<16);}' unless defined(&BNX_MQ_STATUS_CTX_ACCESS_STAT);
	eval 'sub BNX_MQ_STATUS_CTX_ACCESS64_STAT () {(1<<17);}' unless defined(&BNX_MQ_STATUS_CTX_ACCESS64_STAT);
	eval 'sub BNX_MQ_STATUS_PCI_STALL_STAT () {(1<<18);}' unless defined(&BNX_MQ_STATUS_PCI_STALL_STAT);
	eval 'sub BNX_MQ_CONFIG () {0x3c08;}' unless defined(&BNX_MQ_CONFIG);
	eval 'sub BNX_MQ_CONFIG_TX_HIGH_PRI () {(1<<0);}' unless defined(&BNX_MQ_CONFIG_TX_HIGH_PRI);
	eval 'sub BNX_MQ_CONFIG_HALT_DIS () {(1<<1);}' unless defined(&BNX_MQ_CONFIG_HALT_DIS);
	eval 'sub BNX_MQ_CONFIG_BIN_MQ_MODE () {(1<<2);}' unless defined(&BNX_MQ_CONFIG_BIN_MQ_MODE);
	eval 'sub BNX_MQ_CONFIG_DIS_IDB_DROP () {(1<<3);}' unless defined(&BNX_MQ_CONFIG_DIS_IDB_DROP);
	eval 'sub BNX_MQ_CONFIG_KNL_BYP_BLK_SIZE () {(0x7<<4);}' unless defined(&BNX_MQ_CONFIG_KNL_BYP_BLK_SIZE);
	eval 'sub BNX_MQ_CONFIG_KNL_BYP_BLK_SIZE_256 () {(0<<4);}' unless defined(&BNX_MQ_CONFIG_KNL_BYP_BLK_SIZE_256);
	eval 'sub BNX_MQ_CONFIG_KNL_BYP_BLK_SIZE_512 () {(1<<4);}' unless defined(&BNX_MQ_CONFIG_KNL_BYP_BLK_SIZE_512);
	eval 'sub BNX_MQ_CONFIG_KNL_BYP_BLK_SIZE_1K () {(2<<4);}' unless defined(&BNX_MQ_CONFIG_KNL_BYP_BLK_SIZE_1K);
	eval 'sub BNX_MQ_CONFIG_KNL_BYP_BLK_SIZE_2K () {(3<<4);}' unless defined(&BNX_MQ_CONFIG_KNL_BYP_BLK_SIZE_2K);
	eval 'sub BNX_MQ_CONFIG_KNL_BYP_BLK_SIZE_4K () {(4<<4);}' unless defined(&BNX_MQ_CONFIG_KNL_BYP_BLK_SIZE_4K);
	eval 'sub BNX_MQ_CONFIG_MAX_DEPTH () {(0x7f<<8);}' unless defined(&BNX_MQ_CONFIG_MAX_DEPTH);
	eval 'sub BNX_MQ_CONFIG_CUR_DEPTH () {(0x7f<<20);}' unless defined(&BNX_MQ_CONFIG_CUR_DEPTH);
	eval 'sub BNX_MQ_ENQUEUE1 () {0x3c0c;}' unless defined(&BNX_MQ_ENQUEUE1);
	eval 'sub BNX_MQ_ENQUEUE1_OFFSET () {(0x3f<<2);}' unless defined(&BNX_MQ_ENQUEUE1_OFFSET);
	eval 'sub BNX_MQ_ENQUEUE1_CID () {(0x3fff<<8);}' unless defined(&BNX_MQ_ENQUEUE1_CID);
	eval 'sub BNX_MQ_ENQUEUE1_BYTE_MASK () {(0xf<<24);}' unless defined(&BNX_MQ_ENQUEUE1_BYTE_MASK);
	eval 'sub BNX_MQ_ENQUEUE1_KNL_MODE () {(1<<28);}' unless defined(&BNX_MQ_ENQUEUE1_KNL_MODE);
	eval 'sub BNX_MQ_ENQUEUE2 () {0x3c10;}' unless defined(&BNX_MQ_ENQUEUE2);
	eval 'sub BNX_MQ_BAD_WR_ADDR () {0x3c14;}' unless defined(&BNX_MQ_BAD_WR_ADDR);
	eval 'sub BNX_MQ_BAD_RD_ADDR () {0x3c18;}' unless defined(&BNX_MQ_BAD_RD_ADDR);
	eval 'sub BNX_MQ_KNL_BYP_WIND_START () {0x3c1c;}' unless defined(&BNX_MQ_KNL_BYP_WIND_START);
	eval 'sub BNX_MQ_KNL_BYP_WIND_START_VALUE () {(0xfffff<<12);}' unless defined(&BNX_MQ_KNL_BYP_WIND_START_VALUE);
	eval 'sub BNX_MQ_KNL_WIND_END () {0x3c20;}' unless defined(&BNX_MQ_KNL_WIND_END);
	eval 'sub BNX_MQ_KNL_WIND_END_VALUE () {(0xffffff<<8);}' unless defined(&BNX_MQ_KNL_WIND_END_VALUE);
	eval 'sub BNX_MQ_KNL_WRITE_MASK1 () {0x3c24;}' unless defined(&BNX_MQ_KNL_WRITE_MASK1);
	eval 'sub BNX_MQ_KNL_TX_MASK1 () {0x3c28;}' unless defined(&BNX_MQ_KNL_TX_MASK1);
	eval 'sub BNX_MQ_KNL_CMD_MASK1 () {0x3c2c;}' unless defined(&BNX_MQ_KNL_CMD_MASK1);
	eval 'sub BNX_MQ_KNL_COND_ENQUEUE_MASK1 () {0x3c30;}' unless defined(&BNX_MQ_KNL_COND_ENQUEUE_MASK1);
	eval 'sub BNX_MQ_KNL_RX_V2P_MASK1 () {0x3c34;}' unless defined(&BNX_MQ_KNL_RX_V2P_MASK1);
	eval 'sub BNX_MQ_KNL_WRITE_MASK2 () {0x3c38;}' unless defined(&BNX_MQ_KNL_WRITE_MASK2);
	eval 'sub BNX_MQ_KNL_TX_MASK2 () {0x3c3c;}' unless defined(&BNX_MQ_KNL_TX_MASK2);
	eval 'sub BNX_MQ_KNL_CMD_MASK2 () {0x3c40;}' unless defined(&BNX_MQ_KNL_CMD_MASK2);
	eval 'sub BNX_MQ_KNL_COND_ENQUEUE_MASK2 () {0x3c44;}' unless defined(&BNX_MQ_KNL_COND_ENQUEUE_MASK2);
	eval 'sub BNX_MQ_KNL_RX_V2P_MASK2 () {0x3c48;}' unless defined(&BNX_MQ_KNL_RX_V2P_MASK2);
	eval 'sub BNX_MQ_KNL_BYP_WRITE_MASK1 () {0x3c4c;}' unless defined(&BNX_MQ_KNL_BYP_WRITE_MASK1);
	eval 'sub BNX_MQ_KNL_BYP_TX_MASK1 () {0x3c50;}' unless defined(&BNX_MQ_KNL_BYP_TX_MASK1);
	eval 'sub BNX_MQ_KNL_BYP_CMD_MASK1 () {0x3c54;}' unless defined(&BNX_MQ_KNL_BYP_CMD_MASK1);
	eval 'sub BNX_MQ_KNL_BYP_COND_ENQUEUE_MASK1 () {0x3c58;}' unless defined(&BNX_MQ_KNL_BYP_COND_ENQUEUE_MASK1);
	eval 'sub BNX_MQ_KNL_BYP_RX_V2P_MASK1 () {0x3c5c;}' unless defined(&BNX_MQ_KNL_BYP_RX_V2P_MASK1);
	eval 'sub BNX_MQ_KNL_BYP_WRITE_MASK2 () {0x3c60;}' unless defined(&BNX_MQ_KNL_BYP_WRITE_MASK2);
	eval 'sub BNX_MQ_KNL_BYP_TX_MASK2 () {0x3c64;}' unless defined(&BNX_MQ_KNL_BYP_TX_MASK2);
	eval 'sub BNX_MQ_KNL_BYP_CMD_MASK2 () {0x3c68;}' unless defined(&BNX_MQ_KNL_BYP_CMD_MASK2);
	eval 'sub BNX_MQ_KNL_BYP_COND_ENQUEUE_MASK2 () {0x3c6c;}' unless defined(&BNX_MQ_KNL_BYP_COND_ENQUEUE_MASK2);
	eval 'sub BNX_MQ_KNL_BYP_RX_V2P_MASK2 () {0x3c70;}' unless defined(&BNX_MQ_KNL_BYP_RX_V2P_MASK2);
	eval 'sub BNX_MQ_MEM_WR_ADDR () {0x3c74;}' unless defined(&BNX_MQ_MEM_WR_ADDR);
	eval 'sub BNX_MQ_MEM_WR_ADDR_VALUE () {(0x3f<<0);}' unless defined(&BNX_MQ_MEM_WR_ADDR_VALUE);
	eval 'sub BNX_MQ_MEM_WR_DATA0 () {0x3c78;}' unless defined(&BNX_MQ_MEM_WR_DATA0);
	eval 'sub BNX_MQ_MEM_WR_DATA0_VALUE () {(0xffffffff<<0);}' unless defined(&BNX_MQ_MEM_WR_DATA0_VALUE);
	eval 'sub BNX_MQ_MEM_WR_DATA1 () {0x3c7c;}' unless defined(&BNX_MQ_MEM_WR_DATA1);
	eval 'sub BNX_MQ_MEM_WR_DATA1_VALUE () {(0xffffffff<<0);}' unless defined(&BNX_MQ_MEM_WR_DATA1_VALUE);
	eval 'sub BNX_MQ_MEM_WR_DATA2 () {0x3c80;}' unless defined(&BNX_MQ_MEM_WR_DATA2);
	eval 'sub BNX_MQ_MEM_WR_DATA2_VALUE () {(0x3fffffff<<0);}' unless defined(&BNX_MQ_MEM_WR_DATA2_VALUE);
	eval 'sub BNX_MQ_MEM_RD_ADDR () {0x3c84;}' unless defined(&BNX_MQ_MEM_RD_ADDR);
	eval 'sub BNX_MQ_MEM_RD_ADDR_VALUE () {(0x3f<<0);}' unless defined(&BNX_MQ_MEM_RD_ADDR_VALUE);
	eval 'sub BNX_MQ_MEM_RD_DATA0 () {0x3c88;}' unless defined(&BNX_MQ_MEM_RD_DATA0);
	eval 'sub BNX_MQ_MEM_RD_DATA0_VALUE () {(0xffffffff<<0);}' unless defined(&BNX_MQ_MEM_RD_DATA0_VALUE);
	eval 'sub BNX_MQ_MEM_RD_DATA1 () {0x3c8c;}' unless defined(&BNX_MQ_MEM_RD_DATA1);
	eval 'sub BNX_MQ_MEM_RD_DATA1_VALUE () {(0xffffffff<<0);}' unless defined(&BNX_MQ_MEM_RD_DATA1_VALUE);
	eval 'sub BNX_MQ_MEM_RD_DATA2 () {0x3c90;}' unless defined(&BNX_MQ_MEM_RD_DATA2);
	eval 'sub BNX_MQ_MEM_RD_DATA2_VALUE () {(0x3fffffff<<0);}' unless defined(&BNX_MQ_MEM_RD_DATA2_VALUE);
	eval 'sub BNX_MQ_MAP_L2_5 () {0x3d34;}' unless defined(&BNX_MQ_MAP_L2_5);
	eval 'sub BNX_MQ_MAP_L2_5_MQ_OFFSET () {(0xff<<0);}' unless defined(&BNX_MQ_MAP_L2_5_MQ_OFFSET);
	eval 'sub BNX_MQ_MAP_L2_5_SZ () {(0x3<<8);}' unless defined(&BNX_MQ_MAP_L2_5_SZ);
	eval 'sub BNX_MQ_MAP_L2_5_CTX_OFFSET () {(0x2ff<<10);}' unless defined(&BNX_MQ_MAP_L2_5_CTX_OFFSET);
	eval 'sub BNX_MQ_MAP_L2_5_BIN_OFFSET () {(0x7<<23);}' unless defined(&BNX_MQ_MAP_L2_5_BIN_OFFSET);
	eval 'sub BNX_MQ_MAP_L2_5_ARM () {(0x3<<26);}' unless defined(&BNX_MQ_MAP_L2_5_ARM);
	eval 'sub BNX_MQ_MAP_L2_5_ENA () {(0x1<<31);}' unless defined(&BNX_MQ_MAP_L2_5_ENA);
	eval 'sub BNX_MQ_MAP_L2_5_DEFAULT () {0x83000b08;}' unless defined(&BNX_MQ_MAP_L2_5_DEFAULT);
	eval 'sub BNX_TBDR_COMMAND () {0x5000;}' unless defined(&BNX_TBDR_COMMAND);
	eval 'sub BNX_TBDR_COMMAND_ENABLE () {(1<<0);}' unless defined(&BNX_TBDR_COMMAND_ENABLE);
	eval 'sub BNX_TBDR_COMMAND_SOFT_RST () {(1<<1);}' unless defined(&BNX_TBDR_COMMAND_SOFT_RST);
	eval 'sub BNX_TBDR_COMMAND_MSTR_ABORT () {(1<<4);}' unless defined(&BNX_TBDR_COMMAND_MSTR_ABORT);
	eval 'sub BNX_TBDR_STATUS () {0x5004;}' unless defined(&BNX_TBDR_STATUS);
	eval 'sub BNX_TBDR_STATUS_DMA_WAIT () {(1<<0);}' unless defined(&BNX_TBDR_STATUS_DMA_WAIT);
	eval 'sub BNX_TBDR_STATUS_FTQ_WAIT () {(1<<1);}' unless defined(&BNX_TBDR_STATUS_FTQ_WAIT);
	eval 'sub BNX_TBDR_STATUS_FIFO_OVERFLOW () {(1<<2);}' unless defined(&BNX_TBDR_STATUS_FIFO_OVERFLOW);
	eval 'sub BNX_TBDR_STATUS_FIFO_UNDERFLOW () {(1<<3);}' unless defined(&BNX_TBDR_STATUS_FIFO_UNDERFLOW);
	eval 'sub BNX_TBDR_STATUS_SEARCHMISS_ERROR () {(1<<4);}' unless defined(&BNX_TBDR_STATUS_SEARCHMISS_ERROR);
	eval 'sub BNX_TBDR_STATUS_FTQ_ENTRY_CNT () {(1<<5);}' unless defined(&BNX_TBDR_STATUS_FTQ_ENTRY_CNT);
	eval 'sub BNX_TBDR_STATUS_BURST_CNT () {(1<<6);}' unless defined(&BNX_TBDR_STATUS_BURST_CNT);
	eval 'sub BNX_TBDR_CONFIG () {0x5008;}' unless defined(&BNX_TBDR_CONFIG);
	eval 'sub BNX_TBDR_CONFIG_MAX_BDS () {(0xff<<0);}' unless defined(&BNX_TBDR_CONFIG_MAX_BDS);
	eval 'sub BNX_TBDR_CONFIG_SWAP_MODE () {(1<<8);}' unless defined(&BNX_TBDR_CONFIG_SWAP_MODE);
	eval 'sub BNX_TBDR_CONFIG_PRIORITY () {(1<<9);}' unless defined(&BNX_TBDR_CONFIG_PRIORITY);
	eval 'sub BNX_TBDR_CONFIG_CACHE_NEXT_PAGE_PTRS () {(1<<10);}' unless defined(&BNX_TBDR_CONFIG_CACHE_NEXT_PAGE_PTRS);
	eval 'sub BNX_TBDR_CONFIG_PAGE_SIZE () {(0xf<<24);}' unless defined(&BNX_TBDR_CONFIG_PAGE_SIZE);
	eval 'sub BNX_TBDR_CONFIG_PAGE_SIZE_256 () {(0<<24);}' unless defined(&BNX_TBDR_CONFIG_PAGE_SIZE_256);
	eval 'sub BNX_TBDR_CONFIG_PAGE_SIZE_512 () {(1<<24);}' unless defined(&BNX_TBDR_CONFIG_PAGE_SIZE_512);
	eval 'sub BNX_TBDR_CONFIG_PAGE_SIZE_1K () {(2<<24);}' unless defined(&BNX_TBDR_CONFIG_PAGE_SIZE_1K);
	eval 'sub BNX_TBDR_CONFIG_PAGE_SIZE_2K () {(3<<24);}' unless defined(&BNX_TBDR_CONFIG_PAGE_SIZE_2K);
	eval 'sub BNX_TBDR_CONFIG_PAGE_SIZE_4K () {(4<<24);}' unless defined(&BNX_TBDR_CONFIG_PAGE_SIZE_4K);
	eval 'sub BNX_TBDR_CONFIG_PAGE_SIZE_8K () {(5<<24);}' unless defined(&BNX_TBDR_CONFIG_PAGE_SIZE_8K);
	eval 'sub BNX_TBDR_CONFIG_PAGE_SIZE_16K () {(6<<24);}' unless defined(&BNX_TBDR_CONFIG_PAGE_SIZE_16K);
	eval 'sub BNX_TBDR_CONFIG_PAGE_SIZE_32K () {(7<<24);}' unless defined(&BNX_TBDR_CONFIG_PAGE_SIZE_32K);
	eval 'sub BNX_TBDR_CONFIG_PAGE_SIZE_64K () {(8<<24);}' unless defined(&BNX_TBDR_CONFIG_PAGE_SIZE_64K);
	eval 'sub BNX_TBDR_CONFIG_PAGE_SIZE_128K () {(9<<24);}' unless defined(&BNX_TBDR_CONFIG_PAGE_SIZE_128K);
	eval 'sub BNX_TBDR_CONFIG_PAGE_SIZE_256K () {(10<<24);}' unless defined(&BNX_TBDR_CONFIG_PAGE_SIZE_256K);
	eval 'sub BNX_TBDR_CONFIG_PAGE_SIZE_512K () {(11<<24);}' unless defined(&BNX_TBDR_CONFIG_PAGE_SIZE_512K);
	eval 'sub BNX_TBDR_CONFIG_PAGE_SIZE_1M () {(12<<24);}' unless defined(&BNX_TBDR_CONFIG_PAGE_SIZE_1M);
	eval 'sub BNX_TBDR_DEBUG_VECT_PEEK () {0x500c;}' unless defined(&BNX_TBDR_DEBUG_VECT_PEEK);
	eval 'sub BNX_TBDR_DEBUG_VECT_PEEK_1_VALUE () {(0x7ff<<0);}' unless defined(&BNX_TBDR_DEBUG_VECT_PEEK_1_VALUE);
	eval 'sub BNX_TBDR_DEBUG_VECT_PEEK_1_PEEK_EN () {(1<<11);}' unless defined(&BNX_TBDR_DEBUG_VECT_PEEK_1_PEEK_EN);
	eval 'sub BNX_TBDR_DEBUG_VECT_PEEK_1_SEL () {(0xf<<12);}' unless defined(&BNX_TBDR_DEBUG_VECT_PEEK_1_SEL);
	eval 'sub BNX_TBDR_DEBUG_VECT_PEEK_2_VALUE () {(0x7ff<<16);}' unless defined(&BNX_TBDR_DEBUG_VECT_PEEK_2_VALUE);
	eval 'sub BNX_TBDR_DEBUG_VECT_PEEK_2_PEEK_EN () {(1<<27);}' unless defined(&BNX_TBDR_DEBUG_VECT_PEEK_2_PEEK_EN);
	eval 'sub BNX_TBDR_DEBUG_VECT_PEEK_2_SEL () {(0xf<<28);}' unless defined(&BNX_TBDR_DEBUG_VECT_PEEK_2_SEL);
	eval 'sub BNX_TBDR_FTQ_DATA () {0x53c0;}' unless defined(&BNX_TBDR_FTQ_DATA);
	eval 'sub BNX_TBDR_FTQ_CMD () {0x53f8;}' unless defined(&BNX_TBDR_FTQ_CMD);
	eval 'sub BNX_TBDR_FTQ_CMD_OFFSET () {(0x3ff<<0);}' unless defined(&BNX_TBDR_FTQ_CMD_OFFSET);
	eval 'sub BNX_TBDR_FTQ_CMD_WR_TOP () {(1<<10);}' unless defined(&BNX_TBDR_FTQ_CMD_WR_TOP);
	eval 'sub BNX_TBDR_FTQ_CMD_WR_TOP_0 () {(0<<10);}' unless defined(&BNX_TBDR_FTQ_CMD_WR_TOP_0);
	eval 'sub BNX_TBDR_FTQ_CMD_WR_TOP_1 () {(1<<10);}' unless defined(&BNX_TBDR_FTQ_CMD_WR_TOP_1);
	eval 'sub BNX_TBDR_FTQ_CMD_SFT_RESET () {(1<<25);}' unless defined(&BNX_TBDR_FTQ_CMD_SFT_RESET);
	eval 'sub BNX_TBDR_FTQ_CMD_RD_DATA () {(1<<26);}' unless defined(&BNX_TBDR_FTQ_CMD_RD_DATA);
	eval 'sub BNX_TBDR_FTQ_CMD_ADD_INTERVEN () {(1<<27);}' unless defined(&BNX_TBDR_FTQ_CMD_ADD_INTERVEN);
	eval 'sub BNX_TBDR_FTQ_CMD_ADD_DATA () {(1<<28);}' unless defined(&BNX_TBDR_FTQ_CMD_ADD_DATA);
	eval 'sub BNX_TBDR_FTQ_CMD_INTERVENE_CLR () {(1<<29);}' unless defined(&BNX_TBDR_FTQ_CMD_INTERVENE_CLR);
	eval 'sub BNX_TBDR_FTQ_CMD_POP () {(1<<30);}' unless defined(&BNX_TBDR_FTQ_CMD_POP);
	eval 'sub BNX_TBDR_FTQ_CMD_BUSY () {(1<<31);}' unless defined(&BNX_TBDR_FTQ_CMD_BUSY);
	eval 'sub BNX_TBDR_FTQ_CTL () {0x53fc;}' unless defined(&BNX_TBDR_FTQ_CTL);
	eval 'sub BNX_TBDR_FTQ_CTL_INTERVENE () {(1<<0);}' unless defined(&BNX_TBDR_FTQ_CTL_INTERVENE);
	eval 'sub BNX_TBDR_FTQ_CTL_OVERFLOW () {(1<<1);}' unless defined(&BNX_TBDR_FTQ_CTL_OVERFLOW);
	eval 'sub BNX_TBDR_FTQ_CTL_FORCE_INTERVENE () {(1<<2);}' unless defined(&BNX_TBDR_FTQ_CTL_FORCE_INTERVENE);
	eval 'sub BNX_TBDR_FTQ_CTL_MAX_DEPTH () {(0x3ff<<12);}' unless defined(&BNX_TBDR_FTQ_CTL_MAX_DEPTH);
	eval 'sub BNX_TBDR_FTQ_CTL_CUR_DEPTH () {(0x3ff<<22);}' unless defined(&BNX_TBDR_FTQ_CTL_CUR_DEPTH);
	eval 'sub BNX_TDMA_COMMAND () {0x5c00;}' unless defined(&BNX_TDMA_COMMAND);
	eval 'sub BNX_TDMA_COMMAND_ENABLED () {(1<<0);}' unless defined(&BNX_TDMA_COMMAND_ENABLED);
	eval 'sub BNX_TDMA_COMMAND_MASTER_ABORT () {(1<<4);}' unless defined(&BNX_TDMA_COMMAND_MASTER_ABORT);
	eval 'sub BNX_TDMA_COMMAND_BAD_L2_LENGTH_ABORT () {(1<<7);}' unless defined(&BNX_TDMA_COMMAND_BAD_L2_LENGTH_ABORT);
	eval 'sub BNX_TDMA_STATUS () {0x5c04;}' unless defined(&BNX_TDMA_STATUS);
	eval 'sub BNX_TDMA_STATUS_DMA_WAIT () {(1<<0);}' unless defined(&BNX_TDMA_STATUS_DMA_WAIT);
	eval 'sub BNX_TDMA_STATUS_PAYLOAD_WAIT () {(1<<1);}' unless defined(&BNX_TDMA_STATUS_PAYLOAD_WAIT);
	eval 'sub BNX_TDMA_STATUS_PATCH_FTQ_WAIT () {(1<<2);}' unless defined(&BNX_TDMA_STATUS_PATCH_FTQ_WAIT);
	eval 'sub BNX_TDMA_STATUS_LOCK_WAIT () {(1<<3);}' unless defined(&BNX_TDMA_STATUS_LOCK_WAIT);
	eval 'sub BNX_TDMA_STATUS_FTQ_ENTRY_CNT () {(1<<16);}' unless defined(&BNX_TDMA_STATUS_FTQ_ENTRY_CNT);
	eval 'sub BNX_TDMA_STATUS_BURST_CNT () {(1<<17);}' unless defined(&BNX_TDMA_STATUS_BURST_CNT);
	eval 'sub BNX_TDMA_CONFIG () {0x5c08;}' unless defined(&BNX_TDMA_CONFIG);
	eval 'sub BNX_TDMA_CONFIG_ONE_DMA () {(1<<0);}' unless defined(&BNX_TDMA_CONFIG_ONE_DMA);
	eval 'sub BNX_TDMA_CONFIG_ONE_RECORD () {(1<<1);}' unless defined(&BNX_TDMA_CONFIG_ONE_RECORD);
	eval 'sub BNX_TDMA_CONFIG_LIMIT_SZ () {(0xf<<4);}' unless defined(&BNX_TDMA_CONFIG_LIMIT_SZ);
	eval 'sub BNX_TDMA_CONFIG_LIMIT_SZ_64 () {(0<<4);}' unless defined(&BNX_TDMA_CONFIG_LIMIT_SZ_64);
	eval 'sub BNX_TDMA_CONFIG_LIMIT_SZ_128 () {(0x4<<4);}' unless defined(&BNX_TDMA_CONFIG_LIMIT_SZ_128);
	eval 'sub BNX_TDMA_CONFIG_LIMIT_SZ_256 () {(0x6<<4);}' unless defined(&BNX_TDMA_CONFIG_LIMIT_SZ_256);
	eval 'sub BNX_TDMA_CONFIG_LIMIT_SZ_512 () {(0x8<<4);}' unless defined(&BNX_TDMA_CONFIG_LIMIT_SZ_512);
	eval 'sub BNX_TDMA_CONFIG_LINE_SZ () {(0xf<<8);}' unless defined(&BNX_TDMA_CONFIG_LINE_SZ);
	eval 'sub BNX_TDMA_CONFIG_LINE_SZ_64 () {(0<<8);}' unless defined(&BNX_TDMA_CONFIG_LINE_SZ_64);
	eval 'sub BNX_TDMA_CONFIG_LINE_SZ_128 () {(4<<8);}' unless defined(&BNX_TDMA_CONFIG_LINE_SZ_128);
	eval 'sub BNX_TDMA_CONFIG_LINE_SZ_256 () {(6<<8);}' unless defined(&BNX_TDMA_CONFIG_LINE_SZ_256);
	eval 'sub BNX_TDMA_CONFIG_LINE_SZ_512 () {(8<<8);}' unless defined(&BNX_TDMA_CONFIG_LINE_SZ_512);
	eval 'sub BNX_TDMA_CONFIG_ALIGN_ENA () {(1<<15);}' unless defined(&BNX_TDMA_CONFIG_ALIGN_ENA);
	eval 'sub BNX_TDMA_CONFIG_CHK_L2_BD () {(1<<16);}' unless defined(&BNX_TDMA_CONFIG_CHK_L2_BD);
	eval 'sub BNX_TDMA_CONFIG_FIFO_CMP () {(0xf<<20);}' unless defined(&BNX_TDMA_CONFIG_FIFO_CMP);
	eval 'sub BNX_TDMA_PAYLOAD_PROD () {0x5c0c;}' unless defined(&BNX_TDMA_PAYLOAD_PROD);
	eval 'sub BNX_TDMA_PAYLOAD_PROD_VALUE () {(0x1fff<<3);}' unless defined(&BNX_TDMA_PAYLOAD_PROD_VALUE);
	eval 'sub BNX_TDMA_DBG_WATCHDOG () {0x5c10;}' unless defined(&BNX_TDMA_DBG_WATCHDOG);
	eval 'sub BNX_TDMA_DBG_TRIGGER () {0x5c14;}' unless defined(&BNX_TDMA_DBG_TRIGGER);
	eval 'sub BNX_TDMA_DMAD_FSM () {0x5c80;}' unless defined(&BNX_TDMA_DMAD_FSM);
	eval 'sub BNX_TDMA_DMAD_FSM_BD_INVLD () {(1<<0);}' unless defined(&BNX_TDMA_DMAD_FSM_BD_INVLD);
	eval 'sub BNX_TDMA_DMAD_FSM_PUSH () {(0xf<<4);}' unless defined(&BNX_TDMA_DMAD_FSM_PUSH);
	eval 'sub BNX_TDMA_DMAD_FSM_ARB_TBDC () {(0x3<<8);}' unless defined(&BNX_TDMA_DMAD_FSM_ARB_TBDC);
	eval 'sub BNX_TDMA_DMAD_FSM_ARB_CTX () {(1<<12);}' unless defined(&BNX_TDMA_DMAD_FSM_ARB_CTX);
	eval 'sub BNX_TDMA_DMAD_FSM_DR_INTF () {(1<<16);}' unless defined(&BNX_TDMA_DMAD_FSM_DR_INTF);
	eval 'sub BNX_TDMA_DMAD_FSM_DMAD () {(0x7<<20);}' unless defined(&BNX_TDMA_DMAD_FSM_DMAD);
	eval 'sub BNX_TDMA_DMAD_FSM_BD () {(0xf<<24);}' unless defined(&BNX_TDMA_DMAD_FSM_BD);
	eval 'sub BNX_TDMA_DMAD_STATUS () {0x5c84;}' unless defined(&BNX_TDMA_DMAD_STATUS);
	eval 'sub BNX_TDMA_DMAD_STATUS_RHOLD_PUSH_ENTRY () {(0x3<<0);}' unless defined(&BNX_TDMA_DMAD_STATUS_RHOLD_PUSH_ENTRY);
	eval 'sub BNX_TDMA_DMAD_STATUS_RHOLD_DMAD_ENTRY () {(0x3<<4);}' unless defined(&BNX_TDMA_DMAD_STATUS_RHOLD_DMAD_ENTRY);
	eval 'sub BNX_TDMA_DMAD_STATUS_RHOLD_BD_ENTRY () {(0x3<<8);}' unless defined(&BNX_TDMA_DMAD_STATUS_RHOLD_BD_ENTRY);
	eval 'sub BNX_TDMA_DMAD_STATUS_IFTQ_ENUM () {(0xf<<12);}' unless defined(&BNX_TDMA_DMAD_STATUS_IFTQ_ENUM);
	eval 'sub BNX_TDMA_DR_INTF_FSM () {0x5c88;}' unless defined(&BNX_TDMA_DR_INTF_FSM);
	eval 'sub BNX_TDMA_DR_INTF_FSM_L2_COMP () {(0x3<<0);}' unless defined(&BNX_TDMA_DR_INTF_FSM_L2_COMP);
	eval 'sub BNX_TDMA_DR_INTF_FSM_TPATQ () {(0x7<<4);}' unless defined(&BNX_TDMA_DR_INTF_FSM_TPATQ);
	eval 'sub BNX_TDMA_DR_INTF_FSM_TPBUF () {(0x3<<8);}' unless defined(&BNX_TDMA_DR_INTF_FSM_TPBUF);
	eval 'sub BNX_TDMA_DR_INTF_FSM_DR_BUF () {(0x7<<12);}' unless defined(&BNX_TDMA_DR_INTF_FSM_DR_BUF);
	eval 'sub BNX_TDMA_DR_INTF_FSM_DMAD () {(0x7<<16);}' unless defined(&BNX_TDMA_DR_INTF_FSM_DMAD);
	eval 'sub BNX_TDMA_DR_INTF_STATUS () {0x5c8c;}' unless defined(&BNX_TDMA_DR_INTF_STATUS);
	eval 'sub BNX_TDMA_DR_INTF_STATUS_HOLE_PHASE () {(0x7<<0);}' unless defined(&BNX_TDMA_DR_INTF_STATUS_HOLE_PHASE);
	eval 'sub BNX_TDMA_DR_INTF_STATUS_DATA_AVAIL () {(0x3<<4);}' unless defined(&BNX_TDMA_DR_INTF_STATUS_DATA_AVAIL);
	eval 'sub BNX_TDMA_DR_INTF_STATUS_SHIFT_ADDR () {(0x7<<8);}' unless defined(&BNX_TDMA_DR_INTF_STATUS_SHIFT_ADDR);
	eval 'sub BNX_TDMA_DR_INTF_STATUS_NXT_PNTR () {(0xf<<12);}' unless defined(&BNX_TDMA_DR_INTF_STATUS_NXT_PNTR);
	eval 'sub BNX_TDMA_DR_INTF_STATUS_BYTE_COUNT () {(0x7<<16);}' unless defined(&BNX_TDMA_DR_INTF_STATUS_BYTE_COUNT);
	eval 'sub BNX_TDMA_FTQ_DATA () {0x5fc0;}' unless defined(&BNX_TDMA_FTQ_DATA);
	eval 'sub BNX_TDMA_FTQ_CMD () {0x5ff8;}' unless defined(&BNX_TDMA_FTQ_CMD);
	eval 'sub BNX_TDMA_FTQ_CMD_OFFSET () {(0x3ff<<0);}' unless defined(&BNX_TDMA_FTQ_CMD_OFFSET);
	eval 'sub BNX_TDMA_FTQ_CMD_WR_TOP () {(1<<10);}' unless defined(&BNX_TDMA_FTQ_CMD_WR_TOP);
	eval 'sub BNX_TDMA_FTQ_CMD_WR_TOP_0 () {(0<<10);}' unless defined(&BNX_TDMA_FTQ_CMD_WR_TOP_0);
	eval 'sub BNX_TDMA_FTQ_CMD_WR_TOP_1 () {(1<<10);}' unless defined(&BNX_TDMA_FTQ_CMD_WR_TOP_1);
	eval 'sub BNX_TDMA_FTQ_CMD_SFT_RESET () {(1<<25);}' unless defined(&BNX_TDMA_FTQ_CMD_SFT_RESET);
	eval 'sub BNX_TDMA_FTQ_CMD_RD_DATA () {(1<<26);}' unless defined(&BNX_TDMA_FTQ_CMD_RD_DATA);
	eval 'sub BNX_TDMA_FTQ_CMD_ADD_INTERVEN () {(1<<27);}' unless defined(&BNX_TDMA_FTQ_CMD_ADD_INTERVEN);
	eval 'sub BNX_TDMA_FTQ_CMD_ADD_DATA () {(1<<28);}' unless defined(&BNX_TDMA_FTQ_CMD_ADD_DATA);
	eval 'sub BNX_TDMA_FTQ_CMD_INTERVENE_CLR () {(1<<29);}' unless defined(&BNX_TDMA_FTQ_CMD_INTERVENE_CLR);
	eval 'sub BNX_TDMA_FTQ_CMD_POP () {(1<<30);}' unless defined(&BNX_TDMA_FTQ_CMD_POP);
	eval 'sub BNX_TDMA_FTQ_CMD_BUSY () {(1<<31);}' unless defined(&BNX_TDMA_FTQ_CMD_BUSY);
	eval 'sub BNX_TDMA_FTQ_CTL () {0x5ffc;}' unless defined(&BNX_TDMA_FTQ_CTL);
	eval 'sub BNX_TDMA_FTQ_CTL_INTERVENE () {(1<<0);}' unless defined(&BNX_TDMA_FTQ_CTL_INTERVENE);
	eval 'sub BNX_TDMA_FTQ_CTL_OVERFLOW () {(1<<1);}' unless defined(&BNX_TDMA_FTQ_CTL_OVERFLOW);
	eval 'sub BNX_TDMA_FTQ_CTL_FORCE_INTERVENE () {(1<<2);}' unless defined(&BNX_TDMA_FTQ_CTL_FORCE_INTERVENE);
	eval 'sub BNX_TDMA_FTQ_CTL_MAX_DEPTH () {(0x3ff<<12);}' unless defined(&BNX_TDMA_FTQ_CTL_MAX_DEPTH);
	eval 'sub BNX_TDMA_FTQ_CTL_CUR_DEPTH () {(0x3ff<<22);}' unless defined(&BNX_TDMA_FTQ_CTL_CUR_DEPTH);
	eval 'sub BNX_HC_COMMAND () {0x6800;}' unless defined(&BNX_HC_COMMAND);
	eval 'sub BNX_HC_COMMAND_ENABLE () {(1<<0);}' unless defined(&BNX_HC_COMMAND_ENABLE);
	eval 'sub BNX_HC_COMMAND_SKIP_ABORT () {(1<<4);}' unless defined(&BNX_HC_COMMAND_SKIP_ABORT);
	eval 'sub BNX_HC_COMMAND_COAL_NOW () {(1<<16);}' unless defined(&BNX_HC_COMMAND_COAL_NOW);
	eval 'sub BNX_HC_COMMAND_COAL_NOW_WO_INT () {(1<<17);}' unless defined(&BNX_HC_COMMAND_COAL_NOW_WO_INT);
	eval 'sub BNX_HC_COMMAND_STATS_NOW () {(1<<18);}' unless defined(&BNX_HC_COMMAND_STATS_NOW);
	eval 'sub BNX_HC_COMMAND_FORCE_INT () {(0x3<<19);}' unless defined(&BNX_HC_COMMAND_FORCE_INT);
	eval 'sub BNX_HC_COMMAND_FORCE_INT_NULL () {(0<<19);}' unless defined(&BNX_HC_COMMAND_FORCE_INT_NULL);
	eval 'sub BNX_HC_COMMAND_FORCE_INT_HIGH () {(1<<19);}' unless defined(&BNX_HC_COMMAND_FORCE_INT_HIGH);
	eval 'sub BNX_HC_COMMAND_FORCE_INT_LOW () {(2<<19);}' unless defined(&BNX_HC_COMMAND_FORCE_INT_LOW);
	eval 'sub BNX_HC_COMMAND_FORCE_INT_FREE () {(3<<19);}' unless defined(&BNX_HC_COMMAND_FORCE_INT_FREE);
	eval 'sub BNX_HC_COMMAND_CLR_STAT_NOW () {(1<<21);}' unless defined(&BNX_HC_COMMAND_CLR_STAT_NOW);
	eval 'sub BNX_HC_STATUS () {0x6804;}' unless defined(&BNX_HC_STATUS);
	eval 'sub BNX_HC_STATUS_MASTER_ABORT () {(1<<0);}' unless defined(&BNX_HC_STATUS_MASTER_ABORT);
	eval 'sub BNX_HC_STATUS_PARITY_ERROR_STATE () {(1<<1);}' unless defined(&BNX_HC_STATUS_PARITY_ERROR_STATE);
	eval 'sub BNX_HC_STATUS_PCI_CLK_CNT_STAT () {(1<<16);}' unless defined(&BNX_HC_STATUS_PCI_CLK_CNT_STAT);
	eval 'sub BNX_HC_STATUS_CORE_CLK_CNT_STAT () {(1<<17);}' unless defined(&BNX_HC_STATUS_CORE_CLK_CNT_STAT);
	eval 'sub BNX_HC_STATUS_NUM_STATUS_BLOCKS_STAT () {(1<<18);}' unless defined(&BNX_HC_STATUS_NUM_STATUS_BLOCKS_STAT);
	eval 'sub BNX_HC_STATUS_NUM_INT_GEN_STAT () {(1<<19);}' unless defined(&BNX_HC_STATUS_NUM_INT_GEN_STAT);
	eval 'sub BNX_HC_STATUS_NUM_INT_MBOX_WR_STAT () {(1<<20);}' unless defined(&BNX_HC_STATUS_NUM_INT_MBOX_WR_STAT);
	eval 'sub BNX_HC_STATUS_CORE_CLKS_TO_HW_INTACK_STAT () {(1<<23);}' unless defined(&BNX_HC_STATUS_CORE_CLKS_TO_HW_INTACK_STAT);
	eval 'sub BNX_HC_STATUS_CORE_CLKS_TO_SW_INTACK_STAT () {(1<<24);}' unless defined(&BNX_HC_STATUS_CORE_CLKS_TO_SW_INTACK_STAT);
	eval 'sub BNX_HC_STATUS_CORE_CLKS_DURING_SW_INTACK_STAT () {(1<<25);}' unless defined(&BNX_HC_STATUS_CORE_CLKS_DURING_SW_INTACK_STAT);
	eval 'sub BNX_HC_CONFIG () {0x6808;}' unless defined(&BNX_HC_CONFIG);
	eval 'sub BNX_HC_CONFIG_COLLECT_STATS () {(1<<0);}' unless defined(&BNX_HC_CONFIG_COLLECT_STATS);
	eval 'sub BNX_HC_CONFIG_RX_TMR_MODE () {(1<<1);}' unless defined(&BNX_HC_CONFIG_RX_TMR_MODE);
	eval 'sub BNX_HC_CONFIG_TX_TMR_MODE () {(1<<2);}' unless defined(&BNX_HC_CONFIG_TX_TMR_MODE);
	eval 'sub BNX_HC_CONFIG_COM_TMR_MODE () {(1<<3);}' unless defined(&BNX_HC_CONFIG_COM_TMR_MODE);
	eval 'sub BNX_HC_CONFIG_CMD_TMR_MODE () {(1<<4);}' unless defined(&BNX_HC_CONFIG_CMD_TMR_MODE);
	eval 'sub BNX_HC_CONFIG_STATISTIC_PRIORITY () {(1<<5);}' unless defined(&BNX_HC_CONFIG_STATISTIC_PRIORITY);
	eval 'sub BNX_HC_CONFIG_STATUS_PRIORITY () {(1<<6);}' unless defined(&BNX_HC_CONFIG_STATUS_PRIORITY);
	eval 'sub BNX_HC_CONFIG_STAT_MEM_ADDR () {(0xff<<8);}' unless defined(&BNX_HC_CONFIG_STAT_MEM_ADDR);
	eval 'sub BNX_HC_ATTN_BITS_ENABLE () {0x680c;}' unless defined(&BNX_HC_ATTN_BITS_ENABLE);
	eval 'sub BNX_HC_STATUS_ADDR_L () {0x6810;}' unless defined(&BNX_HC_STATUS_ADDR_L);
	eval 'sub BNX_HC_STATUS_ADDR_H () {0x6814;}' unless defined(&BNX_HC_STATUS_ADDR_H);
	eval 'sub BNX_HC_STATISTICS_ADDR_L () {0x6818;}' unless defined(&BNX_HC_STATISTICS_ADDR_L);
	eval 'sub BNX_HC_STATISTICS_ADDR_H () {0x681c;}' unless defined(&BNX_HC_STATISTICS_ADDR_H);
	eval 'sub BNX_HC_TX_QUICK_CONS_TRIP () {0x6820;}' unless defined(&BNX_HC_TX_QUICK_CONS_TRIP);
	eval 'sub BNX_HC_TX_QUICK_CONS_TRIP_VALUE () {(0xff<<0);}' unless defined(&BNX_HC_TX_QUICK_CONS_TRIP_VALUE);
	eval 'sub BNX_HC_TX_QUICK_CONS_TRIP_INT () {(0xff<<16);}' unless defined(&BNX_HC_TX_QUICK_CONS_TRIP_INT);
	eval 'sub BNX_HC_COMP_PROD_TRIP () {0x6824;}' unless defined(&BNX_HC_COMP_PROD_TRIP);
	eval 'sub BNX_HC_COMP_PROD_TRIP_VALUE () {(0xff<<0);}' unless defined(&BNX_HC_COMP_PROD_TRIP_VALUE);
	eval 'sub BNX_HC_COMP_PROD_TRIP_INT () {(0xff<<16);}' unless defined(&BNX_HC_COMP_PROD_TRIP_INT);
	eval 'sub BNX_HC_RX_QUICK_CONS_TRIP () {0x6828;}' unless defined(&BNX_HC_RX_QUICK_CONS_TRIP);
	eval 'sub BNX_HC_RX_QUICK_CONS_TRIP_VALUE () {(0xff<<0);}' unless defined(&BNX_HC_RX_QUICK_CONS_TRIP_VALUE);
	eval 'sub BNX_HC_RX_QUICK_CONS_TRIP_INT () {(0xff<<16);}' unless defined(&BNX_HC_RX_QUICK_CONS_TRIP_INT);
	eval 'sub BNX_HC_RX_TICKS () {0x682c;}' unless defined(&BNX_HC_RX_TICKS);
	eval 'sub BNX_HC_RX_TICKS_VALUE () {(0x3ff<<0);}' unless defined(&BNX_HC_RX_TICKS_VALUE);
	eval 'sub BNX_HC_RX_TICKS_INT () {(0x3ff<<16);}' unless defined(&BNX_HC_RX_TICKS_INT);
	eval 'sub BNX_HC_TX_TICKS () {0x6830;}' unless defined(&BNX_HC_TX_TICKS);
	eval 'sub BNX_HC_TX_TICKS_VALUE () {(0x3ff<<0);}' unless defined(&BNX_HC_TX_TICKS_VALUE);
	eval 'sub BNX_HC_TX_TICKS_INT () {(0x3ff<<16);}' unless defined(&BNX_HC_TX_TICKS_INT);
	eval 'sub BNX_HC_COM_TICKS () {0x6834;}' unless defined(&BNX_HC_COM_TICKS);
	eval 'sub BNX_HC_COM_TICKS_VALUE () {(0x3ff<<0);}' unless defined(&BNX_HC_COM_TICKS_VALUE);
	eval 'sub BNX_HC_COM_TICKS_INT () {(0x3ff<<16);}' unless defined(&BNX_HC_COM_TICKS_INT);
	eval 'sub BNX_HC_CMD_TICKS () {0x6838;}' unless defined(&BNX_HC_CMD_TICKS);
	eval 'sub BNX_HC_CMD_TICKS_VALUE () {(0x3ff<<0);}' unless defined(&BNX_HC_CMD_TICKS_VALUE);
	eval 'sub BNX_HC_CMD_TICKS_INT () {(0x3ff<<16);}' unless defined(&BNX_HC_CMD_TICKS_INT);
	eval 'sub BNX_HC_PERIODIC_TICKS () {0x683c;}' unless defined(&BNX_HC_PERIODIC_TICKS);
	eval 'sub BNX_HC_PERIODIC_TICKS_HC_PERIODIC_TICKS () {(0xffff<<0);}' unless defined(&BNX_HC_PERIODIC_TICKS_HC_PERIODIC_TICKS);
	eval 'sub BNX_HC_STAT_COLLECT_TICKS () {0x6840;}' unless defined(&BNX_HC_STAT_COLLECT_TICKS);
	eval 'sub BNX_HC_STAT_COLLECT_TICKS_HC_STAT_COLL_TICKS () {(0xff<<4);}' unless defined(&BNX_HC_STAT_COLLECT_TICKS_HC_STAT_COLL_TICKS);
	eval 'sub BNX_HC_STATS_TICKS () {0x6844;}' unless defined(&BNX_HC_STATS_TICKS);
	eval 'sub BNX_HC_STATS_TICKS_HC_STAT_TICKS () {(0xffff<<8);}' unless defined(&BNX_HC_STATS_TICKS_HC_STAT_TICKS);
	eval 'sub BNX_HC_STAT_MEM_DATA () {0x684c;}' unless defined(&BNX_HC_STAT_MEM_DATA);
	eval 'sub BNX_HC_STAT_GEN_SEL_0 () {0x6850;}' unless defined(&BNX_HC_STAT_GEN_SEL_0);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0 () {(0x7f<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT0 () {(0<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT0);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT1 () {(1<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT1);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT2 () {(2<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT2);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT3 () {(3<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT3);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT4 () {(4<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT4);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT5 () {(5<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT5);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT6 () {(6<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT6);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT7 () {(7<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT7);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT8 () {(8<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT8);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT9 () {(9<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT9);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT10 () {(10<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT10);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT11 () {(11<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXP_STAT11);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TXP_STAT0 () {(12<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TXP_STAT0);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TXP_STAT1 () {(13<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TXP_STAT1);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TXP_STAT2 () {(14<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TXP_STAT2);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TXP_STAT3 () {(15<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TXP_STAT3);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TXP_STAT4 () {(16<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TXP_STAT4);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TXP_STAT5 () {(17<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TXP_STAT5);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TXP_STAT6 () {(18<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TXP_STAT6);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TXP_STAT7 () {(19<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TXP_STAT7);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT0 () {(20<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT0);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT1 () {(21<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT1);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT2 () {(22<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT2);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT3 () {(23<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT3);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT4 () {(24<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT4);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT5 () {(25<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT5);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT6 () {(26<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT6);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT7 () {(27<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT7);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT8 () {(28<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT8);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT9 () {(29<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT9);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT10 () {(30<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT10);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT11 () {(31<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COM_STAT11);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TPAT_STAT0 () {(32<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TPAT_STAT0);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TPAT_STAT1 () {(33<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TPAT_STAT1);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TPAT_STAT2 () {(34<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TPAT_STAT2);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TPAT_STAT3 () {(35<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TPAT_STAT3);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CP_STAT0 () {(36<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CP_STAT0);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CP_STAT1 () {(37<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CP_STAT1);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CP_STAT2 () {(38<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CP_STAT2);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CP_STAT3 () {(39<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CP_STAT3);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CP_STAT4 () {(40<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CP_STAT4);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CP_STAT5 () {(41<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CP_STAT5);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CP_STAT6 () {(42<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CP_STAT6);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CP_STAT7 () {(43<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CP_STAT7);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MCP_STAT0 () {(44<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MCP_STAT0);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MCP_STAT1 () {(45<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MCP_STAT1);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MCP_STAT2 () {(46<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MCP_STAT2);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MCP_STAT3 () {(47<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MCP_STAT3);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MCP_STAT4 () {(48<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MCP_STAT4);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MCP_STAT5 () {(49<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MCP_STAT5);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MCP_STAT6 () {(50<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MCP_STAT6);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MCP_STAT7 () {(51<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MCP_STAT7);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_PCI_CLK_CNT () {(52<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_PCI_CLK_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CORE_CLK_CNT () {(53<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CORE_CLK_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_HC_NUM_STATUS_BLOCKS () {(54<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_HC_NUM_STATUS_BLOCKS);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_HC_NUM_INT_GEN () {(55<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_HC_NUM_INT_GEN);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_HC_NUM_INT_MBOX_WR () {(56<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_HC_NUM_INT_MBOX_WR);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_HC_CORE_CLKS_TO_HW_INTACK () {(59<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_HC_CORE_CLKS_TO_HW_INTACK);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_HC_CORE_CLKS_TO_SW_INTACK () {(60<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_HC_CORE_CLKS_TO_SW_INTACK);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_HC_CORE_CLKS_DURING_SW_INTACK () {(61<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_HC_CORE_CLKS_DURING_SW_INTACK);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TSCH_CMD_CNT () {(62<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TSCH_CMD_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TSCH_SLOT_CNT () {(63<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TSCH_SLOT_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CSCH_CMD_CNT () {(64<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CSCH_CMD_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CSCH_SLOT_CNT () {(65<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CSCH_SLOT_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RLUPQ_VALID_CNT () {(66<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RLUPQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXPQ_VALID_CNT () {(67<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXPQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXPCQ_VALID_CNT () {(68<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RXPCQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RV2PPQ_VALID_CNT () {(69<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RV2PPQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RV2PMQ_VALID_CNT () {(70<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RV2PMQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RV2PTQ_VALID_CNT () {(71<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RV2PTQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RDMAQ_VALID_CNT () {(72<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RDMAQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TSCHQ_VALID_CNT () {(73<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TSCHQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TBDRQ_VALID_CNT () {(74<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TBDRQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TXPQ_VALID_CNT () {(75<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TXPQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TDMAQ_VALID_CNT () {(76<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TDMAQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TPATQ_VALID_CNT () {(77<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TPATQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TASQ_VALID_CNT () {(78<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TASQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CSQ_VALID_CNT () {(79<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CSQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CPQ_VALID_CNT () {(80<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CPQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COMXQ_VALID_CNT () {(81<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COMXQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COMTQ_VALID_CNT () {(82<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COMTQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COMQ_VALID_CNT () {(83<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_COMQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MGMQ_VALID_CNT () {(84<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MGMQ_VALID_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_READ_TRANSFERS_CNT () {(85<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_READ_TRANSFERS_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_READ_DELAY_PCI_CLKS_CNT () {(86<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_READ_DELAY_PCI_CLKS_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_BIG_READ_TRANSFERS_CNT () {(87<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_BIG_READ_TRANSFERS_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_BIG_READ_DELAY_PCI_CLKS_CNT () {(88<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_BIG_READ_DELAY_PCI_CLKS_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_BIG_READ_RETRY_AFTER_DATA_CNT () {(89<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_BIG_READ_RETRY_AFTER_DATA_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_WRITE_TRANSFERS_CNT () {(90<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_WRITE_TRANSFERS_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_WRITE_DELAY_PCI_CLKS_CNT () {(91<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_WRITE_DELAY_PCI_CLKS_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_BIG_WRITE_TRANSFERS_CNT () {(92<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_BIG_WRITE_TRANSFERS_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_BIG_WRITE_DELAY_PCI_CLKS_CNT () {(93<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_BIG_WRITE_DELAY_PCI_CLKS_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_BIG_WRITE_RETRY_AFTER_DATA_CNT () {(94<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_DMAE_BIG_WRITE_RETRY_AFTER_DATA_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CTX_WR_CNT64 () {(95<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CTX_WR_CNT64);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CTX_RD_CNT64 () {(96<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CTX_RD_CNT64);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CTX_ACC_STALL_CLKS () {(97<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CTX_ACC_STALL_CLKS);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CTX_LOCK_STALL_CLKS () {(98<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_CTX_LOCK_STALL_CLKS);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MBQ_CTX_ACCESS_STAT () {(99<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MBQ_CTX_ACCESS_STAT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MBQ_CTX_ACCESS64_STAT () {(100<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MBQ_CTX_ACCESS64_STAT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MBQ_PCI_STALL_STAT () {(101<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_MBQ_PCI_STALL_STAT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TBDR_FTQ_ENTRY_CNT () {(102<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TBDR_FTQ_ENTRY_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TBDR_BURST_CNT () {(103<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TBDR_BURST_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TDMA_FTQ_ENTRY_CNT () {(104<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TDMA_FTQ_ENTRY_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TDMA_BURST_CNT () {(105<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TDMA_BURST_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RDMA_FTQ_ENTRY_CNT () {(106<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RDMA_FTQ_ENTRY_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RDMA_BURST_CNT () {(107<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RDMA_BURST_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RLUP_MATCH_CNT () {(108<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RLUP_MATCH_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TMR_POLL_PASS_CNT () {(109<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TMR_POLL_PASS_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TMR_TMR1_CNT () {(110<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TMR_TMR1_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TMR_TMR2_CNT () {(111<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TMR_TMR2_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TMR_TMR3_CNT () {(112<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TMR_TMR3_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TMR_TMR4_CNT () {(113<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TMR_TMR4_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TMR_TMR5_CNT () {(114<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_TMR_TMR5_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RV2P_STAT0 () {(115<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RV2P_STAT0);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RV2P_STAT1 () {(116<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RV2P_STAT1);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RV2P_STAT2 () {(117<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RV2P_STAT2);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RV2P_STAT3 () {(118<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RV2P_STAT3);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RV2P_STAT4 () {(119<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RV2P_STAT4);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RV2P_STAT5 () {(120<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RV2P_STAT5);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RBDC_PROC1_MISS () {(121<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RBDC_PROC1_MISS);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RBDC_PROC2_MISS () {(122<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RBDC_PROC2_MISS);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RBDC_BURST_CNT () {(127<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_0_RBDC_BURST_CNT);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_1 () {(0x7f<<8);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_1);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_2 () {(0x7f<<16);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_2);
	eval 'sub BNX_HC_STAT_GEN_SEL_0_GEN_SEL_3 () {(0x7f<<24);}' unless defined(&BNX_HC_STAT_GEN_SEL_0_GEN_SEL_3);
	eval 'sub BNX_HC_STAT_GEN_SEL_1 () {0x6854;}' unless defined(&BNX_HC_STAT_GEN_SEL_1);
	eval 'sub BNX_HC_STAT_GEN_SEL_1_GEN_SEL_4 () {(0x7f<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_1_GEN_SEL_4);
	eval 'sub BNX_HC_STAT_GEN_SEL_1_GEN_SEL_5 () {(0x7f<<8);}' unless defined(&BNX_HC_STAT_GEN_SEL_1_GEN_SEL_5);
	eval 'sub BNX_HC_STAT_GEN_SEL_1_GEN_SEL_6 () {(0x7f<<16);}' unless defined(&BNX_HC_STAT_GEN_SEL_1_GEN_SEL_6);
	eval 'sub BNX_HC_STAT_GEN_SEL_1_GEN_SEL_7 () {(0x7f<<24);}' unless defined(&BNX_HC_STAT_GEN_SEL_1_GEN_SEL_7);
	eval 'sub BNX_HC_STAT_GEN_SEL_2 () {0x6858;}' unless defined(&BNX_HC_STAT_GEN_SEL_2);
	eval 'sub BNX_HC_STAT_GEN_SEL_2_GEN_SEL_8 () {(0x7f<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_2_GEN_SEL_8);
	eval 'sub BNX_HC_STAT_GEN_SEL_2_GEN_SEL_9 () {(0x7f<<8);}' unless defined(&BNX_HC_STAT_GEN_SEL_2_GEN_SEL_9);
	eval 'sub BNX_HC_STAT_GEN_SEL_2_GEN_SEL_10 () {(0x7f<<16);}' unless defined(&BNX_HC_STAT_GEN_SEL_2_GEN_SEL_10);
	eval 'sub BNX_HC_STAT_GEN_SEL_2_GEN_SEL_11 () {(0x7f<<24);}' unless defined(&BNX_HC_STAT_GEN_SEL_2_GEN_SEL_11);
	eval 'sub BNX_HC_STAT_GEN_SEL_3 () {0x685c;}' unless defined(&BNX_HC_STAT_GEN_SEL_3);
	eval 'sub BNX_HC_STAT_GEN_SEL_3_GEN_SEL_12 () {(0x7f<<0);}' unless defined(&BNX_HC_STAT_GEN_SEL_3_GEN_SEL_12);
	eval 'sub BNX_HC_STAT_GEN_SEL_3_GEN_SEL_13 () {(0x7f<<8);}' unless defined(&BNX_HC_STAT_GEN_SEL_3_GEN_SEL_13);
	eval 'sub BNX_HC_STAT_GEN_SEL_3_GEN_SEL_14 () {(0x7f<<16);}' unless defined(&BNX_HC_STAT_GEN_SEL_3_GEN_SEL_14);
	eval 'sub BNX_HC_STAT_GEN_SEL_3_GEN_SEL_15 () {(0x7f<<24);}' unless defined(&BNX_HC_STAT_GEN_SEL_3_GEN_SEL_15);
	eval 'sub BNX_HC_STAT_GEN_STAT0 () {0x6888;}' unless defined(&BNX_HC_STAT_GEN_STAT0);
	eval 'sub BNX_HC_STAT_GEN_STAT1 () {0x688c;}' unless defined(&BNX_HC_STAT_GEN_STAT1);
	eval 'sub BNX_HC_STAT_GEN_STAT2 () {0x6890;}' unless defined(&BNX_HC_STAT_GEN_STAT2);
	eval 'sub BNX_HC_STAT_GEN_STAT3 () {0x6894;}' unless defined(&BNX_HC_STAT_GEN_STAT3);
	eval 'sub BNX_HC_STAT_GEN_STAT4 () {0x6898;}' unless defined(&BNX_HC_STAT_GEN_STAT4);
	eval 'sub BNX_HC_STAT_GEN_STAT5 () {0x689c;}' unless defined(&BNX_HC_STAT_GEN_STAT5);
	eval 'sub BNX_HC_STAT_GEN_STAT6 () {0x68a0;}' unless defined(&BNX_HC_STAT_GEN_STAT6);
	eval 'sub BNX_HC_STAT_GEN_STAT7 () {0x68a4;}' unless defined(&BNX_HC_STAT_GEN_STAT7);
	eval 'sub BNX_HC_STAT_GEN_STAT8 () {0x68a8;}' unless defined(&BNX_HC_STAT_GEN_STAT8);
	eval 'sub BNX_HC_STAT_GEN_STAT9 () {0x68ac;}' unless defined(&BNX_HC_STAT_GEN_STAT9);
	eval 'sub BNX_HC_STAT_GEN_STAT10 () {0x68b0;}' unless defined(&BNX_HC_STAT_GEN_STAT10);
	eval 'sub BNX_HC_STAT_GEN_STAT11 () {0x68b4;}' unless defined(&BNX_HC_STAT_GEN_STAT11);
	eval 'sub BNX_HC_STAT_GEN_STAT12 () {0x68b8;}' unless defined(&BNX_HC_STAT_GEN_STAT12);
	eval 'sub BNX_HC_STAT_GEN_STAT13 () {0x68bc;}' unless defined(&BNX_HC_STAT_GEN_STAT13);
	eval 'sub BNX_HC_STAT_GEN_STAT14 () {0x68c0;}' unless defined(&BNX_HC_STAT_GEN_STAT14);
	eval 'sub BNX_HC_STAT_GEN_STAT15 () {0x68c4;}' unless defined(&BNX_HC_STAT_GEN_STAT15);
	eval 'sub BNX_HC_STAT_GEN_STAT_AC0 () {0x68c8;}' unless defined(&BNX_HC_STAT_GEN_STAT_AC0);
	eval 'sub BNX_HC_STAT_GEN_STAT_AC1 () {0x68cc;}' unless defined(&BNX_HC_STAT_GEN_STAT_AC1);
	eval 'sub BNX_HC_STAT_GEN_STAT_AC2 () {0x68d0;}' unless defined(&BNX_HC_STAT_GEN_STAT_AC2);
	eval 'sub BNX_HC_STAT_GEN_STAT_AC3 () {0x68d4;}' unless defined(&BNX_HC_STAT_GEN_STAT_AC3);
	eval 'sub BNX_HC_STAT_GEN_STAT_AC4 () {0x68d8;}' unless defined(&BNX_HC_STAT_GEN_STAT_AC4);
	eval 'sub BNX_HC_STAT_GEN_STAT_AC5 () {0x68dc;}' unless defined(&BNX_HC_STAT_GEN_STAT_AC5);
	eval 'sub BNX_HC_STAT_GEN_STAT_AC6 () {0x68e0;}' unless defined(&BNX_HC_STAT_GEN_STAT_AC6);
	eval 'sub BNX_HC_STAT_GEN_STAT_AC7 () {0x68e4;}' unless defined(&BNX_HC_STAT_GEN_STAT_AC7);
	eval 'sub BNX_HC_STAT_GEN_STAT_AC8 () {0x68e8;}' unless defined(&BNX_HC_STAT_GEN_STAT_AC8);
	eval 'sub BNX_HC_STAT_GEN_STAT_AC9 () {0x68ec;}' unless defined(&BNX_HC_STAT_GEN_STAT_AC9);
	eval 'sub BNX_HC_STAT_GEN_STAT_AC10 () {0x68f0;}' unless defined(&BNX_HC_STAT_GEN_STAT_AC10);
	eval 'sub BNX_HC_STAT_GEN_STAT_AC11 () {0x68f4;}' unless defined(&BNX_HC_STAT_GEN_STAT_AC11);
	eval 'sub BNX_HC_STAT_GEN_STAT_AC12 () {0x68f8;}' unless defined(&BNX_HC_STAT_GEN_STAT_AC12);
	eval 'sub BNX_HC_STAT_GEN_STAT_AC13 () {0x68fc;}' unless defined(&BNX_HC_STAT_GEN_STAT_AC13);
	eval 'sub BNX_HC_STAT_GEN_STAT_AC14 () {0x6900;}' unless defined(&BNX_HC_STAT_GEN_STAT_AC14);
	eval 'sub BNX_HC_STAT_GEN_STAT_AC15 () {0x6904;}' unless defined(&BNX_HC_STAT_GEN_STAT_AC15);
	eval 'sub BNX_HC_VIS () {0x6908;}' unless defined(&BNX_HC_VIS);
	eval 'sub BNX_HC_VIS_STAT_BUILD_STATE () {(0xf<<0);}' unless defined(&BNX_HC_VIS_STAT_BUILD_STATE);
	eval 'sub BNX_HC_VIS_STAT_BUILD_STATE_IDLE () {(0<<0);}' unless defined(&BNX_HC_VIS_STAT_BUILD_STATE_IDLE);
	eval 'sub BNX_HC_VIS_STAT_BUILD_STATE_START () {(1<<0);}' unless defined(&BNX_HC_VIS_STAT_BUILD_STATE_START);
	eval 'sub BNX_HC_VIS_STAT_BUILD_STATE_REQUEST () {(2<<0);}' unless defined(&BNX_HC_VIS_STAT_BUILD_STATE_REQUEST);
	eval 'sub BNX_HC_VIS_STAT_BUILD_STATE_UPDATE64 () {(3<<0);}' unless defined(&BNX_HC_VIS_STAT_BUILD_STATE_UPDATE64);
	eval 'sub BNX_HC_VIS_STAT_BUILD_STATE_UPDATE32 () {(4<<0);}' unless defined(&BNX_HC_VIS_STAT_BUILD_STATE_UPDATE32);
	eval 'sub BNX_HC_VIS_STAT_BUILD_STATE_UPDATE_DONE () {(5<<0);}' unless defined(&BNX_HC_VIS_STAT_BUILD_STATE_UPDATE_DONE);
	eval 'sub BNX_HC_VIS_STAT_BUILD_STATE_DMA () {(6<<0);}' unless defined(&BNX_HC_VIS_STAT_BUILD_STATE_DMA);
	eval 'sub BNX_HC_VIS_STAT_BUILD_STATE_MSI_CONTROL () {(7<<0);}' unless defined(&BNX_HC_VIS_STAT_BUILD_STATE_MSI_CONTROL);
	eval 'sub BNX_HC_VIS_STAT_BUILD_STATE_MSI_LOW () {(8<<0);}' unless defined(&BNX_HC_VIS_STAT_BUILD_STATE_MSI_LOW);
	eval 'sub BNX_HC_VIS_STAT_BUILD_STATE_MSI_HIGH () {(9<<0);}' unless defined(&BNX_HC_VIS_STAT_BUILD_STATE_MSI_HIGH);
	eval 'sub BNX_HC_VIS_STAT_BUILD_STATE_MSI_DATA () {(10<<0);}' unless defined(&BNX_HC_VIS_STAT_BUILD_STATE_MSI_DATA);
	eval 'sub BNX_HC_VIS_DMA_STAT_STATE () {(0xf<<8);}' unless defined(&BNX_HC_VIS_DMA_STAT_STATE);
	eval 'sub BNX_HC_VIS_DMA_STAT_STATE_IDLE () {(0<<8);}' unless defined(&BNX_HC_VIS_DMA_STAT_STATE_IDLE);
	eval 'sub BNX_HC_VIS_DMA_STAT_STATE_STATUS_PARAM () {(1<<8);}' unless defined(&BNX_HC_VIS_DMA_STAT_STATE_STATUS_PARAM);
	eval 'sub BNX_HC_VIS_DMA_STAT_STATE_STATUS_DMA () {(2<<8);}' unless defined(&BNX_HC_VIS_DMA_STAT_STATE_STATUS_DMA);
	eval 'sub BNX_HC_VIS_DMA_STAT_STATE_WRITE_COMP () {(3<<8);}' unless defined(&BNX_HC_VIS_DMA_STAT_STATE_WRITE_COMP);
	eval 'sub BNX_HC_VIS_DMA_STAT_STATE_COMP () {(4<<8);}' unless defined(&BNX_HC_VIS_DMA_STAT_STATE_COMP);
	eval 'sub BNX_HC_VIS_DMA_STAT_STATE_STATISTIC_PARAM () {(5<<8);}' unless defined(&BNX_HC_VIS_DMA_STAT_STATE_STATISTIC_PARAM);
	eval 'sub BNX_HC_VIS_DMA_STAT_STATE_STATISTIC_DMA () {(6<<8);}' unless defined(&BNX_HC_VIS_DMA_STAT_STATE_STATISTIC_DMA);
	eval 'sub BNX_HC_VIS_DMA_STAT_STATE_WRITE_COMP_1 () {(7<<8);}' unless defined(&BNX_HC_VIS_DMA_STAT_STATE_WRITE_COMP_1);
	eval 'sub BNX_HC_VIS_DMA_STAT_STATE_WRITE_COMP_2 () {(8<<8);}' unless defined(&BNX_HC_VIS_DMA_STAT_STATE_WRITE_COMP_2);
	eval 'sub BNX_HC_VIS_DMA_STAT_STATE_WAIT () {(9<<8);}' unless defined(&BNX_HC_VIS_DMA_STAT_STATE_WAIT);
	eval 'sub BNX_HC_VIS_DMA_STAT_STATE_ABORT () {(15<<8);}' unless defined(&BNX_HC_VIS_DMA_STAT_STATE_ABORT);
	eval 'sub BNX_HC_VIS_DMA_MSI_STATE () {(0x7<<12);}' unless defined(&BNX_HC_VIS_DMA_MSI_STATE);
	eval 'sub BNX_HC_VIS_STATISTIC_DMA_EN_STATE () {(0x3<<15);}' unless defined(&BNX_HC_VIS_STATISTIC_DMA_EN_STATE);
	eval 'sub BNX_HC_VIS_STATISTIC_DMA_EN_STATE_IDLE () {(0<<15);}' unless defined(&BNX_HC_VIS_STATISTIC_DMA_EN_STATE_IDLE);
	eval 'sub BNX_HC_VIS_STATISTIC_DMA_EN_STATE_COUNT () {(1<<15);}' unless defined(&BNX_HC_VIS_STATISTIC_DMA_EN_STATE_COUNT);
	eval 'sub BNX_HC_VIS_STATISTIC_DMA_EN_STATE_START () {(2<<15);}' unless defined(&BNX_HC_VIS_STATISTIC_DMA_EN_STATE_START);
	eval 'sub BNX_HC_VIS_1 () {0x690c;}' unless defined(&BNX_HC_VIS_1);
	eval 'sub BNX_HC_VIS_1_HW_INTACK_STATE () {(1<<4);}' unless defined(&BNX_HC_VIS_1_HW_INTACK_STATE);
	eval 'sub BNX_HC_VIS_1_HW_INTACK_STATE_IDLE () {(0<<4);}' unless defined(&BNX_HC_VIS_1_HW_INTACK_STATE_IDLE);
	eval 'sub BNX_HC_VIS_1_HW_INTACK_STATE_COUNT () {(1<<4);}' unless defined(&BNX_HC_VIS_1_HW_INTACK_STATE_COUNT);
	eval 'sub BNX_HC_VIS_1_SW_INTACK_STATE () {(1<<5);}' unless defined(&BNX_HC_VIS_1_SW_INTACK_STATE);
	eval 'sub BNX_HC_VIS_1_SW_INTACK_STATE_IDLE () {(0<<5);}' unless defined(&BNX_HC_VIS_1_SW_INTACK_STATE_IDLE);
	eval 'sub BNX_HC_VIS_1_SW_INTACK_STATE_COUNT () {(1<<5);}' unless defined(&BNX_HC_VIS_1_SW_INTACK_STATE_COUNT);
	eval 'sub BNX_HC_VIS_1_DURING_SW_INTACK_STATE () {(1<<6);}' unless defined(&BNX_HC_VIS_1_DURING_SW_INTACK_STATE);
	eval 'sub BNX_HC_VIS_1_DURING_SW_INTACK_STATE_IDLE () {(0<<6);}' unless defined(&BNX_HC_VIS_1_DURING_SW_INTACK_STATE_IDLE);
	eval 'sub BNX_HC_VIS_1_DURING_SW_INTACK_STATE_COUNT () {(1<<6);}' unless defined(&BNX_HC_VIS_1_DURING_SW_INTACK_STATE_COUNT);
	eval 'sub BNX_HC_VIS_1_MAILBOX_COUNT_STATE () {(1<<7);}' unless defined(&BNX_HC_VIS_1_MAILBOX_COUNT_STATE);
	eval 'sub BNX_HC_VIS_1_MAILBOX_COUNT_STATE_IDLE () {(0<<7);}' unless defined(&BNX_HC_VIS_1_MAILBOX_COUNT_STATE_IDLE);
	eval 'sub BNX_HC_VIS_1_MAILBOX_COUNT_STATE_COUNT () {(1<<7);}' unless defined(&BNX_HC_VIS_1_MAILBOX_COUNT_STATE_COUNT);
	eval 'sub BNX_HC_VIS_1_RAM_RD_ARB_STATE () {(0xf<<17);}' unless defined(&BNX_HC_VIS_1_RAM_RD_ARB_STATE);
	eval 'sub BNX_HC_VIS_1_RAM_RD_ARB_STATE_IDLE () {(0<<17);}' unless defined(&BNX_HC_VIS_1_RAM_RD_ARB_STATE_IDLE);
	eval 'sub BNX_HC_VIS_1_RAM_RD_ARB_STATE_DMA () {(1<<17);}' unless defined(&BNX_HC_VIS_1_RAM_RD_ARB_STATE_DMA);
	eval 'sub BNX_HC_VIS_1_RAM_RD_ARB_STATE_UPDATE () {(2<<17);}' unless defined(&BNX_HC_VIS_1_RAM_RD_ARB_STATE_UPDATE);
	eval 'sub BNX_HC_VIS_1_RAM_RD_ARB_STATE_ASSIGN () {(3<<17);}' unless defined(&BNX_HC_VIS_1_RAM_RD_ARB_STATE_ASSIGN);
	eval 'sub BNX_HC_VIS_1_RAM_RD_ARB_STATE_WAIT () {(4<<17);}' unless defined(&BNX_HC_VIS_1_RAM_RD_ARB_STATE_WAIT);
	eval 'sub BNX_HC_VIS_1_RAM_RD_ARB_STATE_REG_UPDATE () {(5<<17);}' unless defined(&BNX_HC_VIS_1_RAM_RD_ARB_STATE_REG_UPDATE);
	eval 'sub BNX_HC_VIS_1_RAM_RD_ARB_STATE_REG_ASSIGN () {(6<<17);}' unless defined(&BNX_HC_VIS_1_RAM_RD_ARB_STATE_REG_ASSIGN);
	eval 'sub BNX_HC_VIS_1_RAM_RD_ARB_STATE_REG_WAIT () {(7<<17);}' unless defined(&BNX_HC_VIS_1_RAM_RD_ARB_STATE_REG_WAIT);
	eval 'sub BNX_HC_VIS_1_RAM_WR_ARB_STATE () {(0x3<<21);}' unless defined(&BNX_HC_VIS_1_RAM_WR_ARB_STATE);
	eval 'sub BNX_HC_VIS_1_RAM_WR_ARB_STATE_NORMAL () {(0<<21);}' unless defined(&BNX_HC_VIS_1_RAM_WR_ARB_STATE_NORMAL);
	eval 'sub BNX_HC_VIS_1_RAM_WR_ARB_STATE_CLEAR () {(1<<21);}' unless defined(&BNX_HC_VIS_1_RAM_WR_ARB_STATE_CLEAR);
	eval 'sub BNX_HC_VIS_1_INT_GEN_STATE () {(1<<23);}' unless defined(&BNX_HC_VIS_1_INT_GEN_STATE);
	eval 'sub BNX_HC_VIS_1_INT_GEN_STATE_DLE () {(0<<23);}' unless defined(&BNX_HC_VIS_1_INT_GEN_STATE_DLE);
	eval 'sub BNX_HC_VIS_1_INT_GEN_STATE_NTERRUPT () {(1<<23);}' unless defined(&BNX_HC_VIS_1_INT_GEN_STATE_NTERRUPT);
	eval 'sub BNX_HC_VIS_1_STAT_CHAN_ID () {(0x7<<24);}' unless defined(&BNX_HC_VIS_1_STAT_CHAN_ID);
	eval 'sub BNX_HC_VIS_1_INT_B () {(1<<27);}' unless defined(&BNX_HC_VIS_1_INT_B);
	eval 'sub BNX_HC_DEBUG_VECT_PEEK () {0x6910;}' unless defined(&BNX_HC_DEBUG_VECT_PEEK);
	eval 'sub BNX_HC_DEBUG_VECT_PEEK_1_VALUE () {(0x7ff<<0);}' unless defined(&BNX_HC_DEBUG_VECT_PEEK_1_VALUE);
	eval 'sub BNX_HC_DEBUG_VECT_PEEK_1_PEEK_EN () {(1<<11);}' unless defined(&BNX_HC_DEBUG_VECT_PEEK_1_PEEK_EN);
	eval 'sub BNX_HC_DEBUG_VECT_PEEK_1_SEL () {(0xf<<12);}' unless defined(&BNX_HC_DEBUG_VECT_PEEK_1_SEL);
	eval 'sub BNX_HC_DEBUG_VECT_PEEK_2_VALUE () {(0x7ff<<16);}' unless defined(&BNX_HC_DEBUG_VECT_PEEK_2_VALUE);
	eval 'sub BNX_HC_DEBUG_VECT_PEEK_2_PEEK_EN () {(1<<27);}' unless defined(&BNX_HC_DEBUG_VECT_PEEK_2_PEEK_EN);
	eval 'sub BNX_HC_DEBUG_VECT_PEEK_2_SEL () {(0xf<<28);}' unless defined(&BNX_HC_DEBUG_VECT_PEEK_2_SEL);
	eval 'sub BNX_TXP_CPU_MODE () {0x45000;}' unless defined(&BNX_TXP_CPU_MODE);
	eval 'sub BNX_TXP_CPU_MODE_LOCAL_RST () {(1<<0);}' unless defined(&BNX_TXP_CPU_MODE_LOCAL_RST);
	eval 'sub BNX_TXP_CPU_MODE_STEP_ENA () {(1<<1);}' unless defined(&BNX_TXP_CPU_MODE_STEP_ENA);
	eval 'sub BNX_TXP_CPU_MODE_PAGE_0_DATA_ENA () {(1<<2);}' unless defined(&BNX_TXP_CPU_MODE_PAGE_0_DATA_ENA);
	eval 'sub BNX_TXP_CPU_MODE_PAGE_0_INST_ENA () {(1<<3);}' unless defined(&BNX_TXP_CPU_MODE_PAGE_0_INST_ENA);
	eval 'sub BNX_TXP_CPU_MODE_MSG_BIT1 () {(1<<6);}' unless defined(&BNX_TXP_CPU_MODE_MSG_BIT1);
	eval 'sub BNX_TXP_CPU_MODE_INTERRUPT_ENA () {(1<<7);}' unless defined(&BNX_TXP_CPU_MODE_INTERRUPT_ENA);
	eval 'sub BNX_TXP_CPU_MODE_SOFT_HALT () {(1<<10);}' unless defined(&BNX_TXP_CPU_MODE_SOFT_HALT);
	eval 'sub BNX_TXP_CPU_MODE_BAD_DATA_HALT_ENA () {(1<<11);}' unless defined(&BNX_TXP_CPU_MODE_BAD_DATA_HALT_ENA);
	eval 'sub BNX_TXP_CPU_MODE_BAD_INST_HALT_ENA () {(1<<12);}' unless defined(&BNX_TXP_CPU_MODE_BAD_INST_HALT_ENA);
	eval 'sub BNX_TXP_CPU_MODE_FIO_ABORT_HALT_ENA () {(1<<13);}' unless defined(&BNX_TXP_CPU_MODE_FIO_ABORT_HALT_ENA);
	eval 'sub BNX_TXP_CPU_MODE_SPAD_UNDERFLOW_HALT_ENA () {(1<<15);}' unless defined(&BNX_TXP_CPU_MODE_SPAD_UNDERFLOW_HALT_ENA);
	eval 'sub BNX_TXP_CPU_STATE () {0x45004;}' unless defined(&BNX_TXP_CPU_STATE);
	eval 'sub BNX_TXP_CPU_STATE_BREAKPOINT () {(1<<0);}' unless defined(&BNX_TXP_CPU_STATE_BREAKPOINT);
	eval 'sub BNX_TXP_CPU_STATE_BAD_INST_HALTED () {(1<<2);}' unless defined(&BNX_TXP_CPU_STATE_BAD_INST_HALTED);
	eval 'sub BNX_TXP_CPU_STATE_PAGE_0_DATA_HALTED () {(1<<3);}' unless defined(&BNX_TXP_CPU_STATE_PAGE_0_DATA_HALTED);
	eval 'sub BNX_TXP_CPU_STATE_PAGE_0_INST_HALTED () {(1<<4);}' unless defined(&BNX_TXP_CPU_STATE_PAGE_0_INST_HALTED);
	eval 'sub BNX_TXP_CPU_STATE_BAD_DATA_ADDR_HALTED () {(1<<5);}' unless defined(&BNX_TXP_CPU_STATE_BAD_DATA_ADDR_HALTED);
	eval 'sub BNX_TXP_CPU_STATE_BAD_pc_HALTED () {(1<<6);}' unless defined(&BNX_TXP_CPU_STATE_BAD_pc_HALTED);
	eval 'sub BNX_TXP_CPU_STATE_ALIGN_HALTED () {(1<<7);}' unless defined(&BNX_TXP_CPU_STATE_ALIGN_HALTED);
	eval 'sub BNX_TXP_CPU_STATE_FIO_ABORT_HALTED () {(1<<8);}' unless defined(&BNX_TXP_CPU_STATE_FIO_ABORT_HALTED);
	eval 'sub BNX_TXP_CPU_STATE_SOFT_HALTED () {(1<<10);}' unless defined(&BNX_TXP_CPU_STATE_SOFT_HALTED);
	eval 'sub BNX_TXP_CPU_STATE_SPAD_UNDERFLOW () {(1<<11);}' unless defined(&BNX_TXP_CPU_STATE_SPAD_UNDERFLOW);
	eval 'sub BNX_TXP_CPU_STATE_INTERRRUPT () {(1<<12);}' unless defined(&BNX_TXP_CPU_STATE_INTERRRUPT);
	eval 'sub BNX_TXP_CPU_STATE_DATA_ACCESS_STALL () {(1<<14);}' unless defined(&BNX_TXP_CPU_STATE_DATA_ACCESS_STALL);
	eval 'sub BNX_TXP_CPU_STATE_INST_FETCH_STALL () {(1<<15);}' unless defined(&BNX_TXP_CPU_STATE_INST_FETCH_STALL);
	eval 'sub BNX_TXP_CPU_STATE_BLOCKED_READ () {(1<<31);}' unless defined(&BNX_TXP_CPU_STATE_BLOCKED_READ);
	eval 'sub BNX_TXP_CPU_EVENT_MASK () {0x45008;}' unless defined(&BNX_TXP_CPU_EVENT_MASK);
	eval 'sub BNX_TXP_CPU_EVENT_MASK_BREAKPOINT_MASK () {(1<<0);}' unless defined(&BNX_TXP_CPU_EVENT_MASK_BREAKPOINT_MASK);
	eval 'sub BNX_TXP_CPU_EVENT_MASK_BAD_INST_HALTED_MASK () {(1<<2);}' unless defined(&BNX_TXP_CPU_EVENT_MASK_BAD_INST_HALTED_MASK);
	eval 'sub BNX_TXP_CPU_EVENT_MASK_PAGE_0_DATA_HALTED_MASK () {(1<<3);}' unless defined(&BNX_TXP_CPU_EVENT_MASK_PAGE_0_DATA_HALTED_MASK);
	eval 'sub BNX_TXP_CPU_EVENT_MASK_PAGE_0_INST_HALTED_MASK () {(1<<4);}' unless defined(&BNX_TXP_CPU_EVENT_MASK_PAGE_0_INST_HALTED_MASK);
	eval 'sub BNX_TXP_CPU_EVENT_MASK_BAD_DATA_ADDR_HALTED_MASK () {(1<<5);}' unless defined(&BNX_TXP_CPU_EVENT_MASK_BAD_DATA_ADDR_HALTED_MASK);
	eval 'sub BNX_TXP_CPU_EVENT_MASK_BAD_PC_HALTED_MASK () {(1<<6);}' unless defined(&BNX_TXP_CPU_EVENT_MASK_BAD_PC_HALTED_MASK);
	eval 'sub BNX_TXP_CPU_EVENT_MASK_ALIGN_HALTED_MASK () {(1<<7);}' unless defined(&BNX_TXP_CPU_EVENT_MASK_ALIGN_HALTED_MASK);
	eval 'sub BNX_TXP_CPU_EVENT_MASK_FIO_ABORT_MASK () {(1<<8);}' unless defined(&BNX_TXP_CPU_EVENT_MASK_FIO_ABORT_MASK);
	eval 'sub BNX_TXP_CPU_EVENT_MASK_SOFT_HALTED_MASK () {(1<<10);}' unless defined(&BNX_TXP_CPU_EVENT_MASK_SOFT_HALTED_MASK);
	eval 'sub BNX_TXP_CPU_EVENT_MASK_SPAD_UNDERFLOW_MASK () {(1<<11);}' unless defined(&BNX_TXP_CPU_EVENT_MASK_SPAD_UNDERFLOW_MASK);
	eval 'sub BNX_TXP_CPU_EVENT_MASK_INTERRUPT_MASK () {(1<<12);}' unless defined(&BNX_TXP_CPU_EVENT_MASK_INTERRUPT_MASK);
	eval 'sub BNX_TXP_CPU_PROGRAM_COUNTER () {0x4501c;}' unless defined(&BNX_TXP_CPU_PROGRAM_COUNTER);
	eval 'sub BNX_TXP_CPU_INSTRUCTION () {0x45020;}' unless defined(&BNX_TXP_CPU_INSTRUCTION);
	eval 'sub BNX_TXP_CPU_DATA_ACCESS () {0x45024;}' unless defined(&BNX_TXP_CPU_DATA_ACCESS);
	eval 'sub BNX_TXP_CPU_INTERRUPT_ENABLE () {0x45028;}' unless defined(&BNX_TXP_CPU_INTERRUPT_ENABLE);
	eval 'sub BNX_TXP_CPU_INTERRUPT_VECTOR () {0x4502c;}' unless defined(&BNX_TXP_CPU_INTERRUPT_VECTOR);
	eval 'sub BNX_TXP_CPU_INTERRUPT_SAVED_PC () {0x45030;}' unless defined(&BNX_TXP_CPU_INTERRUPT_SAVED_PC);
	eval 'sub BNX_TXP_CPU_HW_BREAKPOINT () {0x45034;}' unless defined(&BNX_TXP_CPU_HW_BREAKPOINT);
	eval 'sub BNX_TXP_CPU_HW_BREAKPOINT_DISABLE () {(1<<0);}' unless defined(&BNX_TXP_CPU_HW_BREAKPOINT_DISABLE);
	eval 'sub BNX_TXP_CPU_HW_BREAKPOINT_ADDRESS () {(0x3fffffff<<2);}' unless defined(&BNX_TXP_CPU_HW_BREAKPOINT_ADDRESS);
	eval 'sub BNX_TXP_CPU_DEBUG_VECT_PEEK () {0x45038;}' unless defined(&BNX_TXP_CPU_DEBUG_VECT_PEEK);
	eval 'sub BNX_TXP_CPU_DEBUG_VECT_PEEK_1_VALUE () {(0x7ff<<0);}' unless defined(&BNX_TXP_CPU_DEBUG_VECT_PEEK_1_VALUE);
	eval 'sub BNX_TXP_CPU_DEBUG_VECT_PEEK_1_PEEK_EN () {(1<<11);}' unless defined(&BNX_TXP_CPU_DEBUG_VECT_PEEK_1_PEEK_EN);
	eval 'sub BNX_TXP_CPU_DEBUG_VECT_PEEK_1_SEL () {(0xf<<12);}' unless defined(&BNX_TXP_CPU_DEBUG_VECT_PEEK_1_SEL);
	eval 'sub BNX_TXP_CPU_DEBUG_VECT_PEEK_2_VALUE () {(0x7ff<<16);}' unless defined(&BNX_TXP_CPU_DEBUG_VECT_PEEK_2_VALUE);
	eval 'sub BNX_TXP_CPU_DEBUG_VECT_PEEK_2_PEEK_EN () {(1<<27);}' unless defined(&BNX_TXP_CPU_DEBUG_VECT_PEEK_2_PEEK_EN);
	eval 'sub BNX_TXP_CPU_DEBUG_VECT_PEEK_2_SEL () {(0xf<<28);}' unless defined(&BNX_TXP_CPU_DEBUG_VECT_PEEK_2_SEL);
	eval 'sub BNX_TXP_CPU_LAST_BRANCH_ADDR () {0x45048;}' unless defined(&BNX_TXP_CPU_LAST_BRANCH_ADDR);
	eval 'sub BNX_TXP_CPU_LAST_BRANCH_ADDR_TYPE () {(1<<1);}' unless defined(&BNX_TXP_CPU_LAST_BRANCH_ADDR_TYPE);
	eval 'sub BNX_TXP_CPU_LAST_BRANCH_ADDR_TYPE_JUMP () {(0<<1);}' unless defined(&BNX_TXP_CPU_LAST_BRANCH_ADDR_TYPE_JUMP);
	eval 'sub BNX_TXP_CPU_LAST_BRANCH_ADDR_TYPE_BRANCH () {(1<<1);}' unless defined(&BNX_TXP_CPU_LAST_BRANCH_ADDR_TYPE_BRANCH);
	eval 'sub BNX_TXP_CPU_LAST_BRANCH_ADDR_LBA () {(0x3fffffff<<2);}' unless defined(&BNX_TXP_CPU_LAST_BRANCH_ADDR_LBA);
	eval 'sub BNX_TXP_CPU_REG_FILE () {0x45200;}' unless defined(&BNX_TXP_CPU_REG_FILE);
	eval 'sub BNX_TXP_FTQ_DATA () {0x453c0;}' unless defined(&BNX_TXP_FTQ_DATA);
	eval 'sub BNX_TXP_FTQ_CMD () {0x453f8;}' unless defined(&BNX_TXP_FTQ_CMD);
	eval 'sub BNX_TXP_FTQ_CMD_OFFSET () {(0x3ff<<0);}' unless defined(&BNX_TXP_FTQ_CMD_OFFSET);
	eval 'sub BNX_TXP_FTQ_CMD_WR_TOP () {(1<<10);}' unless defined(&BNX_TXP_FTQ_CMD_WR_TOP);
	eval 'sub BNX_TXP_FTQ_CMD_WR_TOP_0 () {(0<<10);}' unless defined(&BNX_TXP_FTQ_CMD_WR_TOP_0);
	eval 'sub BNX_TXP_FTQ_CMD_WR_TOP_1 () {(1<<10);}' unless defined(&BNX_TXP_FTQ_CMD_WR_TOP_1);
	eval 'sub BNX_TXP_FTQ_CMD_SFT_RESET () {(1<<25);}' unless defined(&BNX_TXP_FTQ_CMD_SFT_RESET);
	eval 'sub BNX_TXP_FTQ_CMD_RD_DATA () {(1<<26);}' unless defined(&BNX_TXP_FTQ_CMD_RD_DATA);
	eval 'sub BNX_TXP_FTQ_CMD_ADD_INTERVEN () {(1<<27);}' unless defined(&BNX_TXP_FTQ_CMD_ADD_INTERVEN);
	eval 'sub BNX_TXP_FTQ_CMD_ADD_DATA () {(1<<28);}' unless defined(&BNX_TXP_FTQ_CMD_ADD_DATA);
	eval 'sub BNX_TXP_FTQ_CMD_INTERVENE_CLR () {(1<<29);}' unless defined(&BNX_TXP_FTQ_CMD_INTERVENE_CLR);
	eval 'sub BNX_TXP_FTQ_CMD_POP () {(1<<30);}' unless defined(&BNX_TXP_FTQ_CMD_POP);
	eval 'sub BNX_TXP_FTQ_CMD_BUSY () {(1<<31);}' unless defined(&BNX_TXP_FTQ_CMD_BUSY);
	eval 'sub BNX_TXP_FTQ_CTL () {0x453fc;}' unless defined(&BNX_TXP_FTQ_CTL);
	eval 'sub BNX_TXP_FTQ_CTL_INTERVENE () {(1<<0);}' unless defined(&BNX_TXP_FTQ_CTL_INTERVENE);
	eval 'sub BNX_TXP_FTQ_CTL_OVERFLOW () {(1<<1);}' unless defined(&BNX_TXP_FTQ_CTL_OVERFLOW);
	eval 'sub BNX_TXP_FTQ_CTL_FORCE_INTERVENE () {(1<<2);}' unless defined(&BNX_TXP_FTQ_CTL_FORCE_INTERVENE);
	eval 'sub BNX_TXP_FTQ_CTL_MAX_DEPTH () {(0x3ff<<12);}' unless defined(&BNX_TXP_FTQ_CTL_MAX_DEPTH);
	eval 'sub BNX_TXP_FTQ_CTL_CUR_DEPTH () {(0x3ff<<22);}' unless defined(&BNX_TXP_FTQ_CTL_CUR_DEPTH);
	eval 'sub BNX_TXP_SCRATCH () {0x60000;}' unless defined(&BNX_TXP_SCRATCH);
	eval 'sub BNX_TPAT_CPU_MODE () {0x85000;}' unless defined(&BNX_TPAT_CPU_MODE);
	eval 'sub BNX_TPAT_CPU_MODE_LOCAL_RST () {(1<<0);}' unless defined(&BNX_TPAT_CPU_MODE_LOCAL_RST);
	eval 'sub BNX_TPAT_CPU_MODE_STEP_ENA () {(1<<1);}' unless defined(&BNX_TPAT_CPU_MODE_STEP_ENA);
	eval 'sub BNX_TPAT_CPU_MODE_PAGE_0_DATA_ENA () {(1<<2);}' unless defined(&BNX_TPAT_CPU_MODE_PAGE_0_DATA_ENA);
	eval 'sub BNX_TPAT_CPU_MODE_PAGE_0_INST_ENA () {(1<<3);}' unless defined(&BNX_TPAT_CPU_MODE_PAGE_0_INST_ENA);
	eval 'sub BNX_TPAT_CPU_MODE_MSG_BIT1 () {(1<<6);}' unless defined(&BNX_TPAT_CPU_MODE_MSG_BIT1);
	eval 'sub BNX_TPAT_CPU_MODE_INTERRUPT_ENA () {(1<<7);}' unless defined(&BNX_TPAT_CPU_MODE_INTERRUPT_ENA);
	eval 'sub BNX_TPAT_CPU_MODE_SOFT_HALT () {(1<<10);}' unless defined(&BNX_TPAT_CPU_MODE_SOFT_HALT);
	eval 'sub BNX_TPAT_CPU_MODE_BAD_DATA_HALT_ENA () {(1<<11);}' unless defined(&BNX_TPAT_CPU_MODE_BAD_DATA_HALT_ENA);
	eval 'sub BNX_TPAT_CPU_MODE_BAD_INST_HALT_ENA () {(1<<12);}' unless defined(&BNX_TPAT_CPU_MODE_BAD_INST_HALT_ENA);
	eval 'sub BNX_TPAT_CPU_MODE_FIO_ABORT_HALT_ENA () {(1<<13);}' unless defined(&BNX_TPAT_CPU_MODE_FIO_ABORT_HALT_ENA);
	eval 'sub BNX_TPAT_CPU_MODE_SPAD_UNDERFLOW_HALT_ENA () {(1<<15);}' unless defined(&BNX_TPAT_CPU_MODE_SPAD_UNDERFLOW_HALT_ENA);
	eval 'sub BNX_TPAT_CPU_STATE () {0x85004;}' unless defined(&BNX_TPAT_CPU_STATE);
	eval 'sub BNX_TPAT_CPU_STATE_BREAKPOINT () {(1<<0);}' unless defined(&BNX_TPAT_CPU_STATE_BREAKPOINT);
	eval 'sub BNX_TPAT_CPU_STATE_BAD_INST_HALTED () {(1<<2);}' unless defined(&BNX_TPAT_CPU_STATE_BAD_INST_HALTED);
	eval 'sub BNX_TPAT_CPU_STATE_PAGE_0_DATA_HALTED () {(1<<3);}' unless defined(&BNX_TPAT_CPU_STATE_PAGE_0_DATA_HALTED);
	eval 'sub BNX_TPAT_CPU_STATE_PAGE_0_INST_HALTED () {(1<<4);}' unless defined(&BNX_TPAT_CPU_STATE_PAGE_0_INST_HALTED);
	eval 'sub BNX_TPAT_CPU_STATE_BAD_DATA_ADDR_HALTED () {(1<<5);}' unless defined(&BNX_TPAT_CPU_STATE_BAD_DATA_ADDR_HALTED);
	eval 'sub BNX_TPAT_CPU_STATE_BAD_pc_HALTED () {(1<<6);}' unless defined(&BNX_TPAT_CPU_STATE_BAD_pc_HALTED);
	eval 'sub BNX_TPAT_CPU_STATE_ALIGN_HALTED () {(1<<7);}' unless defined(&BNX_TPAT_CPU_STATE_ALIGN_HALTED);
	eval 'sub BNX_TPAT_CPU_STATE_FIO_ABORT_HALTED () {(1<<8);}' unless defined(&BNX_TPAT_CPU_STATE_FIO_ABORT_HALTED);
	eval 'sub BNX_TPAT_CPU_STATE_SOFT_HALTED () {(1<<10);}' unless defined(&BNX_TPAT_CPU_STATE_SOFT_HALTED);
	eval 'sub BNX_TPAT_CPU_STATE_SPAD_UNDERFLOW () {(1<<11);}' unless defined(&BNX_TPAT_CPU_STATE_SPAD_UNDERFLOW);
	eval 'sub BNX_TPAT_CPU_STATE_INTERRRUPT () {(1<<12);}' unless defined(&BNX_TPAT_CPU_STATE_INTERRRUPT);
	eval 'sub BNX_TPAT_CPU_STATE_DATA_ACCESS_STALL () {(1<<14);}' unless defined(&BNX_TPAT_CPU_STATE_DATA_ACCESS_STALL);
	eval 'sub BNX_TPAT_CPU_STATE_INST_FETCH_STALL () {(1<<15);}' unless defined(&BNX_TPAT_CPU_STATE_INST_FETCH_STALL);
	eval 'sub BNX_TPAT_CPU_STATE_BLOCKED_READ () {(1<<31);}' unless defined(&BNX_TPAT_CPU_STATE_BLOCKED_READ);
	eval 'sub BNX_TPAT_CPU_EVENT_MASK () {0x85008;}' unless defined(&BNX_TPAT_CPU_EVENT_MASK);
	eval 'sub BNX_TPAT_CPU_EVENT_MASK_BREAKPOINT_MASK () {(1<<0);}' unless defined(&BNX_TPAT_CPU_EVENT_MASK_BREAKPOINT_MASK);
	eval 'sub BNX_TPAT_CPU_EVENT_MASK_BAD_INST_HALTED_MASK () {(1<<2);}' unless defined(&BNX_TPAT_CPU_EVENT_MASK_BAD_INST_HALTED_MASK);
	eval 'sub BNX_TPAT_CPU_EVENT_MASK_PAGE_0_DATA_HALTED_MASK () {(1<<3);}' unless defined(&BNX_TPAT_CPU_EVENT_MASK_PAGE_0_DATA_HALTED_MASK);
	eval 'sub BNX_TPAT_CPU_EVENT_MASK_PAGE_0_INST_HALTED_MASK () {(1<<4);}' unless defined(&BNX_TPAT_CPU_EVENT_MASK_PAGE_0_INST_HALTED_MASK);
	eval 'sub BNX_TPAT_CPU_EVENT_MASK_BAD_DATA_ADDR_HALTED_MASK () {(1<<5);}' unless defined(&BNX_TPAT_CPU_EVENT_MASK_BAD_DATA_ADDR_HALTED_MASK);
	eval 'sub BNX_TPAT_CPU_EVENT_MASK_BAD_PC_HALTED_MASK () {(1<<6);}' unless defined(&BNX_TPAT_CPU_EVENT_MASK_BAD_PC_HALTED_MASK);
	eval 'sub BNX_TPAT_CPU_EVENT_MASK_ALIGN_HALTED_MASK () {(1<<7);}' unless defined(&BNX_TPAT_CPU_EVENT_MASK_ALIGN_HALTED_MASK);
	eval 'sub BNX_TPAT_CPU_EVENT_MASK_FIO_ABORT_MASK () {(1<<8);}' unless defined(&BNX_TPAT_CPU_EVENT_MASK_FIO_ABORT_MASK);
	eval 'sub BNX_TPAT_CPU_EVENT_MASK_SOFT_HALTED_MASK () {(1<<10);}' unless defined(&BNX_TPAT_CPU_EVENT_MASK_SOFT_HALTED_MASK);
	eval 'sub BNX_TPAT_CPU_EVENT_MASK_SPAD_UNDERFLOW_MASK () {(1<<11);}' unless defined(&BNX_TPAT_CPU_EVENT_MASK_SPAD_UNDERFLOW_MASK);
	eval 'sub BNX_TPAT_CPU_EVENT_MASK_INTERRUPT_MASK () {(1<<12);}' unless defined(&BNX_TPAT_CPU_EVENT_MASK_INTERRUPT_MASK);
	eval 'sub BNX_TPAT_CPU_PROGRAM_COUNTER () {0x8501c;}' unless defined(&BNX_TPAT_CPU_PROGRAM_COUNTER);
	eval 'sub BNX_TPAT_CPU_INSTRUCTION () {0x85020;}' unless defined(&BNX_TPAT_CPU_INSTRUCTION);
	eval 'sub BNX_TPAT_CPU_DATA_ACCESS () {0x85024;}' unless defined(&BNX_TPAT_CPU_DATA_ACCESS);
	eval 'sub BNX_TPAT_CPU_INTERRUPT_ENABLE () {0x85028;}' unless defined(&BNX_TPAT_CPU_INTERRUPT_ENABLE);
	eval 'sub BNX_TPAT_CPU_INTERRUPT_VECTOR () {0x8502c;}' unless defined(&BNX_TPAT_CPU_INTERRUPT_VECTOR);
	eval 'sub BNX_TPAT_CPU_INTERRUPT_SAVED_PC () {0x85030;}' unless defined(&BNX_TPAT_CPU_INTERRUPT_SAVED_PC);
	eval 'sub BNX_TPAT_CPU_HW_BREAKPOINT () {0x85034;}' unless defined(&BNX_TPAT_CPU_HW_BREAKPOINT);
	eval 'sub BNX_TPAT_CPU_HW_BREAKPOINT_DISABLE () {(1<<0);}' unless defined(&BNX_TPAT_CPU_HW_BREAKPOINT_DISABLE);
	eval 'sub BNX_TPAT_CPU_HW_BREAKPOINT_ADDRESS () {(0x3fffffff<<2);}' unless defined(&BNX_TPAT_CPU_HW_BREAKPOINT_ADDRESS);
	eval 'sub BNX_TPAT_CPU_DEBUG_VECT_PEEK () {0x85038;}' unless defined(&BNX_TPAT_CPU_DEBUG_VECT_PEEK);
	eval 'sub BNX_TPAT_CPU_DEBUG_VECT_PEEK_1_VALUE () {(0x7ff<<0);}' unless defined(&BNX_TPAT_CPU_DEBUG_VECT_PEEK_1_VALUE);
	eval 'sub BNX_TPAT_CPU_DEBUG_VECT_PEEK_1_PEEK_EN () {(1<<11);}' unless defined(&BNX_TPAT_CPU_DEBUG_VECT_PEEK_1_PEEK_EN);
	eval 'sub BNX_TPAT_CPU_DEBUG_VECT_PEEK_1_SEL () {(0xf<<12);}' unless defined(&BNX_TPAT_CPU_DEBUG_VECT_PEEK_1_SEL);
	eval 'sub BNX_TPAT_CPU_DEBUG_VECT_PEEK_2_VALUE () {(0x7ff<<16);}' unless defined(&BNX_TPAT_CPU_DEBUG_VECT_PEEK_2_VALUE);
	eval 'sub BNX_TPAT_CPU_DEBUG_VECT_PEEK_2_PEEK_EN () {(1<<27);}' unless defined(&BNX_TPAT_CPU_DEBUG_VECT_PEEK_2_PEEK_EN);
	eval 'sub BNX_TPAT_CPU_DEBUG_VECT_PEEK_2_SEL () {(0xf<<28);}' unless defined(&BNX_TPAT_CPU_DEBUG_VECT_PEEK_2_SEL);
	eval 'sub BNX_TPAT_CPU_LAST_BRANCH_ADDR () {0x85048;}' unless defined(&BNX_TPAT_CPU_LAST_BRANCH_ADDR);
	eval 'sub BNX_TPAT_CPU_LAST_BRANCH_ADDR_TYPE () {(1<<1);}' unless defined(&BNX_TPAT_CPU_LAST_BRANCH_ADDR_TYPE);
	eval 'sub BNX_TPAT_CPU_LAST_BRANCH_ADDR_TYPE_JUMP () {(0<<1);}' unless defined(&BNX_TPAT_CPU_LAST_BRANCH_ADDR_TYPE_JUMP);
	eval 'sub BNX_TPAT_CPU_LAST_BRANCH_ADDR_TYPE_BRANCH () {(1<<1);}' unless defined(&BNX_TPAT_CPU_LAST_BRANCH_ADDR_TYPE_BRANCH);
	eval 'sub BNX_TPAT_CPU_LAST_BRANCH_ADDR_LBA () {(0x3fffffff<<2);}' unless defined(&BNX_TPAT_CPU_LAST_BRANCH_ADDR_LBA);
	eval 'sub BNX_TPAT_CPU_REG_FILE () {0x85200;}' unless defined(&BNX_TPAT_CPU_REG_FILE);
	eval 'sub BNX_TPAT_FTQ_DATA () {0x853c0;}' unless defined(&BNX_TPAT_FTQ_DATA);
	eval 'sub BNX_TPAT_FTQ_CMD () {0x853f8;}' unless defined(&BNX_TPAT_FTQ_CMD);
	eval 'sub BNX_TPAT_FTQ_CMD_OFFSET () {(0x3ff<<0);}' unless defined(&BNX_TPAT_FTQ_CMD_OFFSET);
	eval 'sub BNX_TPAT_FTQ_CMD_WR_TOP () {(1<<10);}' unless defined(&BNX_TPAT_FTQ_CMD_WR_TOP);
	eval 'sub BNX_TPAT_FTQ_CMD_WR_TOP_0 () {(0<<10);}' unless defined(&BNX_TPAT_FTQ_CMD_WR_TOP_0);
	eval 'sub BNX_TPAT_FTQ_CMD_WR_TOP_1 () {(1<<10);}' unless defined(&BNX_TPAT_FTQ_CMD_WR_TOP_1);
	eval 'sub BNX_TPAT_FTQ_CMD_SFT_RESET () {(1<<25);}' unless defined(&BNX_TPAT_FTQ_CMD_SFT_RESET);
	eval 'sub BNX_TPAT_FTQ_CMD_RD_DATA () {(1<<26);}' unless defined(&BNX_TPAT_FTQ_CMD_RD_DATA);
	eval 'sub BNX_TPAT_FTQ_CMD_ADD_INTERVEN () {(1<<27);}' unless defined(&BNX_TPAT_FTQ_CMD_ADD_INTERVEN);
	eval 'sub BNX_TPAT_FTQ_CMD_ADD_DATA () {(1<<28);}' unless defined(&BNX_TPAT_FTQ_CMD_ADD_DATA);
	eval 'sub BNX_TPAT_FTQ_CMD_INTERVENE_CLR () {(1<<29);}' unless defined(&BNX_TPAT_FTQ_CMD_INTERVENE_CLR);
	eval 'sub BNX_TPAT_FTQ_CMD_POP () {(1<<30);}' unless defined(&BNX_TPAT_FTQ_CMD_POP);
	eval 'sub BNX_TPAT_FTQ_CMD_BUSY () {(1<<31);}' unless defined(&BNX_TPAT_FTQ_CMD_BUSY);
	eval 'sub BNX_TPAT_FTQ_CTL () {0x853fc;}' unless defined(&BNX_TPAT_FTQ_CTL);
	eval 'sub BNX_TPAT_FTQ_CTL_INTERVENE () {(1<<0);}' unless defined(&BNX_TPAT_FTQ_CTL_INTERVENE);
	eval 'sub BNX_TPAT_FTQ_CTL_OVERFLOW () {(1<<1);}' unless defined(&BNX_TPAT_FTQ_CTL_OVERFLOW);
	eval 'sub BNX_TPAT_FTQ_CTL_FORCE_INTERVENE () {(1<<2);}' unless defined(&BNX_TPAT_FTQ_CTL_FORCE_INTERVENE);
	eval 'sub BNX_TPAT_FTQ_CTL_MAX_DEPTH () {(0x3ff<<12);}' unless defined(&BNX_TPAT_FTQ_CTL_MAX_DEPTH);
	eval 'sub BNX_TPAT_FTQ_CTL_CUR_DEPTH () {(0x3ff<<22);}' unless defined(&BNX_TPAT_FTQ_CTL_CUR_DEPTH);
	eval 'sub BNX_TPAT_SCRATCH () {0xa0000;}' unless defined(&BNX_TPAT_SCRATCH);
	eval 'sub BNX_RXP_CPU_MODE () {0xc5000;}' unless defined(&BNX_RXP_CPU_MODE);
	eval 'sub BNX_RXP_CPU_MODE_LOCAL_RST () {(1<<0);}' unless defined(&BNX_RXP_CPU_MODE_LOCAL_RST);
	eval 'sub BNX_RXP_CPU_MODE_STEP_ENA () {(1<<1);}' unless defined(&BNX_RXP_CPU_MODE_STEP_ENA);
	eval 'sub BNX_RXP_CPU_MODE_PAGE_0_DATA_ENA () {(1<<2);}' unless defined(&BNX_RXP_CPU_MODE_PAGE_0_DATA_ENA);
	eval 'sub BNX_RXP_CPU_MODE_PAGE_0_INST_ENA () {(1<<3);}' unless defined(&BNX_RXP_CPU_MODE_PAGE_0_INST_ENA);
	eval 'sub BNX_RXP_CPU_MODE_MSG_BIT1 () {(1<<6);}' unless defined(&BNX_RXP_CPU_MODE_MSG_BIT1);
	eval 'sub BNX_RXP_CPU_MODE_INTERRUPT_ENA () {(1<<7);}' unless defined(&BNX_RXP_CPU_MODE_INTERRUPT_ENA);
	eval 'sub BNX_RXP_CPU_MODE_SOFT_HALT () {(1<<10);}' unless defined(&BNX_RXP_CPU_MODE_SOFT_HALT);
	eval 'sub BNX_RXP_CPU_MODE_BAD_DATA_HALT_ENA () {(1<<11);}' unless defined(&BNX_RXP_CPU_MODE_BAD_DATA_HALT_ENA);
	eval 'sub BNX_RXP_CPU_MODE_BAD_INST_HALT_ENA () {(1<<12);}' unless defined(&BNX_RXP_CPU_MODE_BAD_INST_HALT_ENA);
	eval 'sub BNX_RXP_CPU_MODE_FIO_ABORT_HALT_ENA () {(1<<13);}' unless defined(&BNX_RXP_CPU_MODE_FIO_ABORT_HALT_ENA);
	eval 'sub BNX_RXP_CPU_MODE_SPAD_UNDERFLOW_HALT_ENA () {(1<<15);}' unless defined(&BNX_RXP_CPU_MODE_SPAD_UNDERFLOW_HALT_ENA);
	eval 'sub BNX_RXP_CPU_STATE () {0xc5004;}' unless defined(&BNX_RXP_CPU_STATE);
	eval 'sub BNX_RXP_CPU_STATE_BREAKPOINT () {(1<<0);}' unless defined(&BNX_RXP_CPU_STATE_BREAKPOINT);
	eval 'sub BNX_RXP_CPU_STATE_BAD_INST_HALTED () {(1<<2);}' unless defined(&BNX_RXP_CPU_STATE_BAD_INST_HALTED);
	eval 'sub BNX_RXP_CPU_STATE_PAGE_0_DATA_HALTED () {(1<<3);}' unless defined(&BNX_RXP_CPU_STATE_PAGE_0_DATA_HALTED);
	eval 'sub BNX_RXP_CPU_STATE_PAGE_0_INST_HALTED () {(1<<4);}' unless defined(&BNX_RXP_CPU_STATE_PAGE_0_INST_HALTED);
	eval 'sub BNX_RXP_CPU_STATE_BAD_DATA_ADDR_HALTED () {(1<<5);}' unless defined(&BNX_RXP_CPU_STATE_BAD_DATA_ADDR_HALTED);
	eval 'sub BNX_RXP_CPU_STATE_BAD_pc_HALTED () {(1<<6);}' unless defined(&BNX_RXP_CPU_STATE_BAD_pc_HALTED);
	eval 'sub BNX_RXP_CPU_STATE_ALIGN_HALTED () {(1<<7);}' unless defined(&BNX_RXP_CPU_STATE_ALIGN_HALTED);
	eval 'sub BNX_RXP_CPU_STATE_FIO_ABORT_HALTED () {(1<<8);}' unless defined(&BNX_RXP_CPU_STATE_FIO_ABORT_HALTED);
	eval 'sub BNX_RXP_CPU_STATE_SOFT_HALTED () {(1<<10);}' unless defined(&BNX_RXP_CPU_STATE_SOFT_HALTED);
	eval 'sub BNX_RXP_CPU_STATE_SPAD_UNDERFLOW () {(1<<11);}' unless defined(&BNX_RXP_CPU_STATE_SPAD_UNDERFLOW);
	eval 'sub BNX_RXP_CPU_STATE_INTERRRUPT () {(1<<12);}' unless defined(&BNX_RXP_CPU_STATE_INTERRRUPT);
	eval 'sub BNX_RXP_CPU_STATE_DATA_ACCESS_STALL () {(1<<14);}' unless defined(&BNX_RXP_CPU_STATE_DATA_ACCESS_STALL);
	eval 'sub BNX_RXP_CPU_STATE_INST_FETCH_STALL () {(1<<15);}' unless defined(&BNX_RXP_CPU_STATE_INST_FETCH_STALL);
	eval 'sub BNX_RXP_CPU_STATE_BLOCKED_READ () {(1<<31);}' unless defined(&BNX_RXP_CPU_STATE_BLOCKED_READ);
	eval 'sub BNX_RXP_CPU_EVENT_MASK () {0xc5008;}' unless defined(&BNX_RXP_CPU_EVENT_MASK);
	eval 'sub BNX_RXP_CPU_EVENT_MASK_BREAKPOINT_MASK () {(1<<0);}' unless defined(&BNX_RXP_CPU_EVENT_MASK_BREAKPOINT_MASK);
	eval 'sub BNX_RXP_CPU_EVENT_MASK_BAD_INST_HALTED_MASK () {(1<<2);}' unless defined(&BNX_RXP_CPU_EVENT_MASK_BAD_INST_HALTED_MASK);
	eval 'sub BNX_RXP_CPU_EVENT_MASK_PAGE_0_DATA_HALTED_MASK () {(1<<3);}' unless defined(&BNX_RXP_CPU_EVENT_MASK_PAGE_0_DATA_HALTED_MASK);
	eval 'sub BNX_RXP_CPU_EVENT_MASK_PAGE_0_INST_HALTED_MASK () {(1<<4);}' unless defined(&BNX_RXP_CPU_EVENT_MASK_PAGE_0_INST_HALTED_MASK);
	eval 'sub BNX_RXP_CPU_EVENT_MASK_BAD_DATA_ADDR_HALTED_MASK () {(1<<5);}' unless defined(&BNX_RXP_CPU_EVENT_MASK_BAD_DATA_ADDR_HALTED_MASK);
	eval 'sub BNX_RXP_CPU_EVENT_MASK_BAD_PC_HALTED_MASK () {(1<<6);}' unless defined(&BNX_RXP_CPU_EVENT_MASK_BAD_PC_HALTED_MASK);
	eval 'sub BNX_RXP_CPU_EVENT_MASK_ALIGN_HALTED_MASK () {(1<<7);}' unless defined(&BNX_RXP_CPU_EVENT_MASK_ALIGN_HALTED_MASK);
	eval 'sub BNX_RXP_CPU_EVENT_MASK_FIO_ABORT_MASK () {(1<<8);}' unless defined(&BNX_RXP_CPU_EVENT_MASK_FIO_ABORT_MASK);
	eval 'sub BNX_RXP_CPU_EVENT_MASK_SOFT_HALTED_MASK () {(1<<10);}' unless defined(&BNX_RXP_CPU_EVENT_MASK_SOFT_HALTED_MASK);
	eval 'sub BNX_RXP_CPU_EVENT_MASK_SPAD_UNDERFLOW_MASK () {(1<<11);}' unless defined(&BNX_RXP_CPU_EVENT_MASK_SPAD_UNDERFLOW_MASK);
	eval 'sub BNX_RXP_CPU_EVENT_MASK_INTERRUPT_MASK () {(1<<12);}' unless defined(&BNX_RXP_CPU_EVENT_MASK_INTERRUPT_MASK);
	eval 'sub BNX_RXP_CPU_PROGRAM_COUNTER () {0xc501c;}' unless defined(&BNX_RXP_CPU_PROGRAM_COUNTER);
	eval 'sub BNX_RXP_CPU_INSTRUCTION () {0xc5020;}' unless defined(&BNX_RXP_CPU_INSTRUCTION);
	eval 'sub BNX_RXP_CPU_DATA_ACCESS () {0xc5024;}' unless defined(&BNX_RXP_CPU_DATA_ACCESS);
	eval 'sub BNX_RXP_CPU_INTERRUPT_ENABLE () {0xc5028;}' unless defined(&BNX_RXP_CPU_INTERRUPT_ENABLE);
	eval 'sub BNX_RXP_CPU_INTERRUPT_VECTOR () {0xc502c;}' unless defined(&BNX_RXP_CPU_INTERRUPT_VECTOR);
	eval 'sub BNX_RXP_CPU_INTERRUPT_SAVED_PC () {0xc5030;}' unless defined(&BNX_RXP_CPU_INTERRUPT_SAVED_PC);
	eval 'sub BNX_RXP_CPU_HW_BREAKPOINT () {0xc5034;}' unless defined(&BNX_RXP_CPU_HW_BREAKPOINT);
	eval 'sub BNX_RXP_CPU_HW_BREAKPOINT_DISABLE () {(1<<0);}' unless defined(&BNX_RXP_CPU_HW_BREAKPOINT_DISABLE);
	eval 'sub BNX_RXP_CPU_HW_BREAKPOINT_ADDRESS () {(0x3fffffff<<2);}' unless defined(&BNX_RXP_CPU_HW_BREAKPOINT_ADDRESS);
	eval 'sub BNX_RXP_CPU_DEBUG_VECT_PEEK () {0xc5038;}' unless defined(&BNX_RXP_CPU_DEBUG_VECT_PEEK);
	eval 'sub BNX_RXP_CPU_DEBUG_VECT_PEEK_1_VALUE () {(0x7ff<<0);}' unless defined(&BNX_RXP_CPU_DEBUG_VECT_PEEK_1_VALUE);
	eval 'sub BNX_RXP_CPU_DEBUG_VECT_PEEK_1_PEEK_EN () {(1<<11);}' unless defined(&BNX_RXP_CPU_DEBUG_VECT_PEEK_1_PEEK_EN);
	eval 'sub BNX_RXP_CPU_DEBUG_VECT_PEEK_1_SEL () {(0xf<<12);}' unless defined(&BNX_RXP_CPU_DEBUG_VECT_PEEK_1_SEL);
	eval 'sub BNX_RXP_CPU_DEBUG_VECT_PEEK_2_VALUE () {(0x7ff<<16);}' unless defined(&BNX_RXP_CPU_DEBUG_VECT_PEEK_2_VALUE);
	eval 'sub BNX_RXP_CPU_DEBUG_VECT_PEEK_2_PEEK_EN () {(1<<27);}' unless defined(&BNX_RXP_CPU_DEBUG_VECT_PEEK_2_PEEK_EN);
	eval 'sub BNX_RXP_CPU_DEBUG_VECT_PEEK_2_SEL () {(0xf<<28);}' unless defined(&BNX_RXP_CPU_DEBUG_VECT_PEEK_2_SEL);
	eval 'sub BNX_RXP_CPU_LAST_BRANCH_ADDR () {0xc5048;}' unless defined(&BNX_RXP_CPU_LAST_BRANCH_ADDR);
	eval 'sub BNX_RXP_CPU_LAST_BRANCH_ADDR_TYPE () {(1<<1);}' unless defined(&BNX_RXP_CPU_LAST_BRANCH_ADDR_TYPE);
	eval 'sub BNX_RXP_CPU_LAST_BRANCH_ADDR_TYPE_JUMP () {(0<<1);}' unless defined(&BNX_RXP_CPU_LAST_BRANCH_ADDR_TYPE_JUMP);
	eval 'sub BNX_RXP_CPU_LAST_BRANCH_ADDR_TYPE_BRANCH () {(1<<1);}' unless defined(&BNX_RXP_CPU_LAST_BRANCH_ADDR_TYPE_BRANCH);
	eval 'sub BNX_RXP_CPU_LAST_BRANCH_ADDR_LBA () {(0x3fffffff<<2);}' unless defined(&BNX_RXP_CPU_LAST_BRANCH_ADDR_LBA);
	eval 'sub BNX_RXP_CPU_REG_FILE () {0xc5200;}' unless defined(&BNX_RXP_CPU_REG_FILE);
	eval 'sub BNX_RXP_CFTQ_DATA () {0xc5380;}' unless defined(&BNX_RXP_CFTQ_DATA);
	eval 'sub BNX_RXP_CFTQ_CMD () {0xc53b8;}' unless defined(&BNX_RXP_CFTQ_CMD);
	eval 'sub BNX_RXP_CFTQ_CMD_OFFSET () {(0x3ff<<0);}' unless defined(&BNX_RXP_CFTQ_CMD_OFFSET);
	eval 'sub BNX_RXP_CFTQ_CMD_WR_TOP () {(1<<10);}' unless defined(&BNX_RXP_CFTQ_CMD_WR_TOP);
	eval 'sub BNX_RXP_CFTQ_CMD_WR_TOP_0 () {(0<<10);}' unless defined(&BNX_RXP_CFTQ_CMD_WR_TOP_0);
	eval 'sub BNX_RXP_CFTQ_CMD_WR_TOP_1 () {(1<<10);}' unless defined(&BNX_RXP_CFTQ_CMD_WR_TOP_1);
	eval 'sub BNX_RXP_CFTQ_CMD_SFT_RESET () {(1<<25);}' unless defined(&BNX_RXP_CFTQ_CMD_SFT_RESET);
	eval 'sub BNX_RXP_CFTQ_CMD_RD_DATA () {(1<<26);}' unless defined(&BNX_RXP_CFTQ_CMD_RD_DATA);
	eval 'sub BNX_RXP_CFTQ_CMD_ADD_INTERVEN () {(1<<27);}' unless defined(&BNX_RXP_CFTQ_CMD_ADD_INTERVEN);
	eval 'sub BNX_RXP_CFTQ_CMD_ADD_DATA () {(1<<28);}' unless defined(&BNX_RXP_CFTQ_CMD_ADD_DATA);
	eval 'sub BNX_RXP_CFTQ_CMD_INTERVENE_CLR () {(1<<29);}' unless defined(&BNX_RXP_CFTQ_CMD_INTERVENE_CLR);
	eval 'sub BNX_RXP_CFTQ_CMD_POP () {(1<<30);}' unless defined(&BNX_RXP_CFTQ_CMD_POP);
	eval 'sub BNX_RXP_CFTQ_CMD_BUSY () {(1<<31);}' unless defined(&BNX_RXP_CFTQ_CMD_BUSY);
	eval 'sub BNX_RXP_CFTQ_CTL () {0xc53bc;}' unless defined(&BNX_RXP_CFTQ_CTL);
	eval 'sub BNX_RXP_CFTQ_CTL_INTERVENE () {(1<<0);}' unless defined(&BNX_RXP_CFTQ_CTL_INTERVENE);
	eval 'sub BNX_RXP_CFTQ_CTL_OVERFLOW () {(1<<1);}' unless defined(&BNX_RXP_CFTQ_CTL_OVERFLOW);
	eval 'sub BNX_RXP_CFTQ_CTL_FORCE_INTERVENE () {(1<<2);}' unless defined(&BNX_RXP_CFTQ_CTL_FORCE_INTERVENE);
	eval 'sub BNX_RXP_CFTQ_CTL_MAX_DEPTH () {(0x3ff<<12);}' unless defined(&BNX_RXP_CFTQ_CTL_MAX_DEPTH);
	eval 'sub BNX_RXP_CFTQ_CTL_CUR_DEPTH () {(0x3ff<<22);}' unless defined(&BNX_RXP_CFTQ_CTL_CUR_DEPTH);
	eval 'sub BNX_RXP_FTQ_DATA () {0xc53c0;}' unless defined(&BNX_RXP_FTQ_DATA);
	eval 'sub BNX_RXP_FTQ_CMD () {0xc53f8;}' unless defined(&BNX_RXP_FTQ_CMD);
	eval 'sub BNX_RXP_FTQ_CMD_OFFSET () {(0x3ff<<0);}' unless defined(&BNX_RXP_FTQ_CMD_OFFSET);
	eval 'sub BNX_RXP_FTQ_CMD_WR_TOP () {(1<<10);}' unless defined(&BNX_RXP_FTQ_CMD_WR_TOP);
	eval 'sub BNX_RXP_FTQ_CMD_WR_TOP_0 () {(0<<10);}' unless defined(&BNX_RXP_FTQ_CMD_WR_TOP_0);
	eval 'sub BNX_RXP_FTQ_CMD_WR_TOP_1 () {(1<<10);}' unless defined(&BNX_RXP_FTQ_CMD_WR_TOP_1);
	eval 'sub BNX_RXP_FTQ_CMD_SFT_RESET () {(1<<25);}' unless defined(&BNX_RXP_FTQ_CMD_SFT_RESET);
	eval 'sub BNX_RXP_FTQ_CMD_RD_DATA () {(1<<26);}' unless defined(&BNX_RXP_FTQ_CMD_RD_DATA);
	eval 'sub BNX_RXP_FTQ_CMD_ADD_INTERVEN () {(1<<27);}' unless defined(&BNX_RXP_FTQ_CMD_ADD_INTERVEN);
	eval 'sub BNX_RXP_FTQ_CMD_ADD_DATA () {(1<<28);}' unless defined(&BNX_RXP_FTQ_CMD_ADD_DATA);
	eval 'sub BNX_RXP_FTQ_CMD_INTERVENE_CLR () {(1<<29);}' unless defined(&BNX_RXP_FTQ_CMD_INTERVENE_CLR);
	eval 'sub BNX_RXP_FTQ_CMD_POP () {(1<<30);}' unless defined(&BNX_RXP_FTQ_CMD_POP);
	eval 'sub BNX_RXP_FTQ_CMD_BUSY () {(1<<31);}' unless defined(&BNX_RXP_FTQ_CMD_BUSY);
	eval 'sub BNX_RXP_FTQ_CTL () {0xc53fc;}' unless defined(&BNX_RXP_FTQ_CTL);
	eval 'sub BNX_RXP_FTQ_CTL_INTERVENE () {(1<<0);}' unless defined(&BNX_RXP_FTQ_CTL_INTERVENE);
	eval 'sub BNX_RXP_FTQ_CTL_OVERFLOW () {(1<<1);}' unless defined(&BNX_RXP_FTQ_CTL_OVERFLOW);
	eval 'sub BNX_RXP_FTQ_CTL_FORCE_INTERVENE () {(1<<2);}' unless defined(&BNX_RXP_FTQ_CTL_FORCE_INTERVENE);
	eval 'sub BNX_RXP_FTQ_CTL_MAX_DEPTH () {(0x3ff<<12);}' unless defined(&BNX_RXP_FTQ_CTL_MAX_DEPTH);
	eval 'sub BNX_RXP_FTQ_CTL_CUR_DEPTH () {(0x3ff<<22);}' unless defined(&BNX_RXP_FTQ_CTL_CUR_DEPTH);
	eval 'sub BNX_RXP_SCRATCH () {0xe0000;}' unless defined(&BNX_RXP_SCRATCH);
	eval 'sub BNX_COM_CPU_MODE () {0x105000;}' unless defined(&BNX_COM_CPU_MODE);
	eval 'sub BNX_COM_CPU_MODE_LOCAL_RST () {(1<<0);}' unless defined(&BNX_COM_CPU_MODE_LOCAL_RST);
	eval 'sub BNX_COM_CPU_MODE_STEP_ENA () {(1<<1);}' unless defined(&BNX_COM_CPU_MODE_STEP_ENA);
	eval 'sub BNX_COM_CPU_MODE_PAGE_0_DATA_ENA () {(1<<2);}' unless defined(&BNX_COM_CPU_MODE_PAGE_0_DATA_ENA);
	eval 'sub BNX_COM_CPU_MODE_PAGE_0_INST_ENA () {(1<<3);}' unless defined(&BNX_COM_CPU_MODE_PAGE_0_INST_ENA);
	eval 'sub BNX_COM_CPU_MODE_MSG_BIT1 () {(1<<6);}' unless defined(&BNX_COM_CPU_MODE_MSG_BIT1);
	eval 'sub BNX_COM_CPU_MODE_INTERRUPT_ENA () {(1<<7);}' unless defined(&BNX_COM_CPU_MODE_INTERRUPT_ENA);
	eval 'sub BNX_COM_CPU_MODE_SOFT_HALT () {(1<<10);}' unless defined(&BNX_COM_CPU_MODE_SOFT_HALT);
	eval 'sub BNX_COM_CPU_MODE_BAD_DATA_HALT_ENA () {(1<<11);}' unless defined(&BNX_COM_CPU_MODE_BAD_DATA_HALT_ENA);
	eval 'sub BNX_COM_CPU_MODE_BAD_INST_HALT_ENA () {(1<<12);}' unless defined(&BNX_COM_CPU_MODE_BAD_INST_HALT_ENA);
	eval 'sub BNX_COM_CPU_MODE_FIO_ABORT_HALT_ENA () {(1<<13);}' unless defined(&BNX_COM_CPU_MODE_FIO_ABORT_HALT_ENA);
	eval 'sub BNX_COM_CPU_MODE_SPAD_UNDERFLOW_HALT_ENA () {(1<<15);}' unless defined(&BNX_COM_CPU_MODE_SPAD_UNDERFLOW_HALT_ENA);
	eval 'sub BNX_COM_CPU_STATE () {0x105004;}' unless defined(&BNX_COM_CPU_STATE);
	eval 'sub BNX_COM_CPU_STATE_BREAKPOINT () {(1<<0);}' unless defined(&BNX_COM_CPU_STATE_BREAKPOINT);
	eval 'sub BNX_COM_CPU_STATE_BAD_INST_HALTED () {(1<<2);}' unless defined(&BNX_COM_CPU_STATE_BAD_INST_HALTED);
	eval 'sub BNX_COM_CPU_STATE_PAGE_0_DATA_HALTED () {(1<<3);}' unless defined(&BNX_COM_CPU_STATE_PAGE_0_DATA_HALTED);
	eval 'sub BNX_COM_CPU_STATE_PAGE_0_INST_HALTED () {(1<<4);}' unless defined(&BNX_COM_CPU_STATE_PAGE_0_INST_HALTED);
	eval 'sub BNX_COM_CPU_STATE_BAD_DATA_ADDR_HALTED () {(1<<5);}' unless defined(&BNX_COM_CPU_STATE_BAD_DATA_ADDR_HALTED);
	eval 'sub BNX_COM_CPU_STATE_BAD_pc_HALTED () {(1<<6);}' unless defined(&BNX_COM_CPU_STATE_BAD_pc_HALTED);
	eval 'sub BNX_COM_CPU_STATE_ALIGN_HALTED () {(1<<7);}' unless defined(&BNX_COM_CPU_STATE_ALIGN_HALTED);
	eval 'sub BNX_COM_CPU_STATE_FIO_ABORT_HALTED () {(1<<8);}' unless defined(&BNX_COM_CPU_STATE_FIO_ABORT_HALTED);
	eval 'sub BNX_COM_CPU_STATE_SOFT_HALTED () {(1<<10);}' unless defined(&BNX_COM_CPU_STATE_SOFT_HALTED);
	eval 'sub BNX_COM_CPU_STATE_SPAD_UNDERFLOW () {(1<<11);}' unless defined(&BNX_COM_CPU_STATE_SPAD_UNDERFLOW);
	eval 'sub BNX_COM_CPU_STATE_INTERRRUPT () {(1<<12);}' unless defined(&BNX_COM_CPU_STATE_INTERRRUPT);
	eval 'sub BNX_COM_CPU_STATE_DATA_ACCESS_STALL () {(1<<14);}' unless defined(&BNX_COM_CPU_STATE_DATA_ACCESS_STALL);
	eval 'sub BNX_COM_CPU_STATE_INST_FETCH_STALL () {(1<<15);}' unless defined(&BNX_COM_CPU_STATE_INST_FETCH_STALL);
	eval 'sub BNX_COM_CPU_STATE_BLOCKED_READ () {(1<<31);}' unless defined(&BNX_COM_CPU_STATE_BLOCKED_READ);
	eval 'sub BNX_COM_CPU_EVENT_MASK () {0x105008;}' unless defined(&BNX_COM_CPU_EVENT_MASK);
	eval 'sub BNX_COM_CPU_EVENT_MASK_BREAKPOINT_MASK () {(1<<0);}' unless defined(&BNX_COM_CPU_EVENT_MASK_BREAKPOINT_MASK);
	eval 'sub BNX_COM_CPU_EVENT_MASK_BAD_INST_HALTED_MASK () {(1<<2);}' unless defined(&BNX_COM_CPU_EVENT_MASK_BAD_INST_HALTED_MASK);
	eval 'sub BNX_COM_CPU_EVENT_MASK_PAGE_0_DATA_HALTED_MASK () {(1<<3);}' unless defined(&BNX_COM_CPU_EVENT_MASK_PAGE_0_DATA_HALTED_MASK);
	eval 'sub BNX_COM_CPU_EVENT_MASK_PAGE_0_INST_HALTED_MASK () {(1<<4);}' unless defined(&BNX_COM_CPU_EVENT_MASK_PAGE_0_INST_HALTED_MASK);
	eval 'sub BNX_COM_CPU_EVENT_MASK_BAD_DATA_ADDR_HALTED_MASK () {(1<<5);}' unless defined(&BNX_COM_CPU_EVENT_MASK_BAD_DATA_ADDR_HALTED_MASK);
	eval 'sub BNX_COM_CPU_EVENT_MASK_BAD_PC_HALTED_MASK () {(1<<6);}' unless defined(&BNX_COM_CPU_EVENT_MASK_BAD_PC_HALTED_MASK);
	eval 'sub BNX_COM_CPU_EVENT_MASK_ALIGN_HALTED_MASK () {(1<<7);}' unless defined(&BNX_COM_CPU_EVENT_MASK_ALIGN_HALTED_MASK);
	eval 'sub BNX_COM_CPU_EVENT_MASK_FIO_ABORT_MASK () {(1<<8);}' unless defined(&BNX_COM_CPU_EVENT_MASK_FIO_ABORT_MASK);
	eval 'sub BNX_COM_CPU_EVENT_MASK_SOFT_HALTED_MASK () {(1<<10);}' unless defined(&BNX_COM_CPU_EVENT_MASK_SOFT_HALTED_MASK);
	eval 'sub BNX_COM_CPU_EVENT_MASK_SPAD_UNDERFLOW_MASK () {(1<<11);}' unless defined(&BNX_COM_CPU_EVENT_MASK_SPAD_UNDERFLOW_MASK);
	eval 'sub BNX_COM_CPU_EVENT_MASK_INTERRUPT_MASK () {(1<<12);}' unless defined(&BNX_COM_CPU_EVENT_MASK_INTERRUPT_MASK);
	eval 'sub BNX_COM_CPU_PROGRAM_COUNTER () {0x10501c;}' unless defined(&BNX_COM_CPU_PROGRAM_COUNTER);
	eval 'sub BNX_COM_CPU_INSTRUCTION () {0x105020;}' unless defined(&BNX_COM_CPU_INSTRUCTION);
	eval 'sub BNX_COM_CPU_DATA_ACCESS () {0x105024;}' unless defined(&BNX_COM_CPU_DATA_ACCESS);
	eval 'sub BNX_COM_CPU_INTERRUPT_ENABLE () {0x105028;}' unless defined(&BNX_COM_CPU_INTERRUPT_ENABLE);
	eval 'sub BNX_COM_CPU_INTERRUPT_VECTOR () {0x10502c;}' unless defined(&BNX_COM_CPU_INTERRUPT_VECTOR);
	eval 'sub BNX_COM_CPU_INTERRUPT_SAVED_PC () {0x105030;}' unless defined(&BNX_COM_CPU_INTERRUPT_SAVED_PC);
	eval 'sub BNX_COM_CPU_HW_BREAKPOINT () {0x105034;}' unless defined(&BNX_COM_CPU_HW_BREAKPOINT);
	eval 'sub BNX_COM_CPU_HW_BREAKPOINT_DISABLE () {(1<<0);}' unless defined(&BNX_COM_CPU_HW_BREAKPOINT_DISABLE);
	eval 'sub BNX_COM_CPU_HW_BREAKPOINT_ADDRESS () {(0x3fffffff<<2);}' unless defined(&BNX_COM_CPU_HW_BREAKPOINT_ADDRESS);
	eval 'sub BNX_COM_CPU_DEBUG_VECT_PEEK () {0x105038;}' unless defined(&BNX_COM_CPU_DEBUG_VECT_PEEK);
	eval 'sub BNX_COM_CPU_DEBUG_VECT_PEEK_1_VALUE () {(0x7ff<<0);}' unless defined(&BNX_COM_CPU_DEBUG_VECT_PEEK_1_VALUE);
	eval 'sub BNX_COM_CPU_DEBUG_VECT_PEEK_1_PEEK_EN () {(1<<11);}' unless defined(&BNX_COM_CPU_DEBUG_VECT_PEEK_1_PEEK_EN);
	eval 'sub BNX_COM_CPU_DEBUG_VECT_PEEK_1_SEL () {(0xf<<12);}' unless defined(&BNX_COM_CPU_DEBUG_VECT_PEEK_1_SEL);
	eval 'sub BNX_COM_CPU_DEBUG_VECT_PEEK_2_VALUE () {(0x7ff<<16);}' unless defined(&BNX_COM_CPU_DEBUG_VECT_PEEK_2_VALUE);
	eval 'sub BNX_COM_CPU_DEBUG_VECT_PEEK_2_PEEK_EN () {(1<<27);}' unless defined(&BNX_COM_CPU_DEBUG_VECT_PEEK_2_PEEK_EN);
	eval 'sub BNX_COM_CPU_DEBUG_VECT_PEEK_2_SEL () {(0xf<<28);}' unless defined(&BNX_COM_CPU_DEBUG_VECT_PEEK_2_SEL);
	eval 'sub BNX_COM_CPU_LAST_BRANCH_ADDR () {0x105048;}' unless defined(&BNX_COM_CPU_LAST_BRANCH_ADDR);
	eval 'sub BNX_COM_CPU_LAST_BRANCH_ADDR_TYPE () {(1<<1);}' unless defined(&BNX_COM_CPU_LAST_BRANCH_ADDR_TYPE);
	eval 'sub BNX_COM_CPU_LAST_BRANCH_ADDR_TYPE_JUMP () {(0<<1);}' unless defined(&BNX_COM_CPU_LAST_BRANCH_ADDR_TYPE_JUMP);
	eval 'sub BNX_COM_CPU_LAST_BRANCH_ADDR_TYPE_BRANCH () {(1<<1);}' unless defined(&BNX_COM_CPU_LAST_BRANCH_ADDR_TYPE_BRANCH);
	eval 'sub BNX_COM_CPU_LAST_BRANCH_ADDR_LBA () {(0x3fffffff<<2);}' unless defined(&BNX_COM_CPU_LAST_BRANCH_ADDR_LBA);
	eval 'sub BNX_COM_CPU_REG_FILE () {0x105200;}' unless defined(&BNX_COM_CPU_REG_FILE);
	eval 'sub BNX_COM_COMXQ_FTQ_DATA () {0x105340;}' unless defined(&BNX_COM_COMXQ_FTQ_DATA);
	eval 'sub BNX_COM_COMXQ_FTQ_CMD () {0x105378;}' unless defined(&BNX_COM_COMXQ_FTQ_CMD);
	eval 'sub BNX_COM_COMXQ_FTQ_CMD_OFFSET () {(0x3ff<<0);}' unless defined(&BNX_COM_COMXQ_FTQ_CMD_OFFSET);
	eval 'sub BNX_COM_COMXQ_FTQ_CMD_WR_TOP () {(1<<10);}' unless defined(&BNX_COM_COMXQ_FTQ_CMD_WR_TOP);
	eval 'sub BNX_COM_COMXQ_FTQ_CMD_WR_TOP_0 () {(0<<10);}' unless defined(&BNX_COM_COMXQ_FTQ_CMD_WR_TOP_0);
	eval 'sub BNX_COM_COMXQ_FTQ_CMD_WR_TOP_1 () {(1<<10);}' unless defined(&BNX_COM_COMXQ_FTQ_CMD_WR_TOP_1);
	eval 'sub BNX_COM_COMXQ_FTQ_CMD_SFT_RESET () {(1<<25);}' unless defined(&BNX_COM_COMXQ_FTQ_CMD_SFT_RESET);
	eval 'sub BNX_COM_COMXQ_FTQ_CMD_RD_DATA () {(1<<26);}' unless defined(&BNX_COM_COMXQ_FTQ_CMD_RD_DATA);
	eval 'sub BNX_COM_COMXQ_FTQ_CMD_ADD_INTERVEN () {(1<<27);}' unless defined(&BNX_COM_COMXQ_FTQ_CMD_ADD_INTERVEN);
	eval 'sub BNX_COM_COMXQ_FTQ_CMD_ADD_DATA () {(1<<28);}' unless defined(&BNX_COM_COMXQ_FTQ_CMD_ADD_DATA);
	eval 'sub BNX_COM_COMXQ_FTQ_CMD_INTERVENE_CLR () {(1<<29);}' unless defined(&BNX_COM_COMXQ_FTQ_CMD_INTERVENE_CLR);
	eval 'sub BNX_COM_COMXQ_FTQ_CMD_POP () {(1<<30);}' unless defined(&BNX_COM_COMXQ_FTQ_CMD_POP);
	eval 'sub BNX_COM_COMXQ_FTQ_CMD_BUSY () {(1<<31);}' unless defined(&BNX_COM_COMXQ_FTQ_CMD_BUSY);
	eval 'sub BNX_COM_COMXQ_FTQ_CTL () {0x10537c;}' unless defined(&BNX_COM_COMXQ_FTQ_CTL);
	eval 'sub BNX_COM_COMXQ_FTQ_CTL_INTERVENE () {(1<<0);}' unless defined(&BNX_COM_COMXQ_FTQ_CTL_INTERVENE);
	eval 'sub BNX_COM_COMXQ_FTQ_CTL_OVERFLOW () {(1<<1);}' unless defined(&BNX_COM_COMXQ_FTQ_CTL_OVERFLOW);
	eval 'sub BNX_COM_COMXQ_FTQ_CTL_FORCE_INTERVENE () {(1<<2);}' unless defined(&BNX_COM_COMXQ_FTQ_CTL_FORCE_INTERVENE);
	eval 'sub BNX_COM_COMXQ_FTQ_CTL_MAX_DEPTH () {(0x3ff<<12);}' unless defined(&BNX_COM_COMXQ_FTQ_CTL_MAX_DEPTH);
	eval 'sub BNX_COM_COMXQ_FTQ_CTL_CUR_DEPTH () {(0x3ff<<22);}' unless defined(&BNX_COM_COMXQ_FTQ_CTL_CUR_DEPTH);
	eval 'sub BNX_COM_COMTQ_FTQ_DATA () {0x105380;}' unless defined(&BNX_COM_COMTQ_FTQ_DATA);
	eval 'sub BNX_COM_COMTQ_FTQ_CMD () {0x1053b8;}' unless defined(&BNX_COM_COMTQ_FTQ_CMD);
	eval 'sub BNX_COM_COMTQ_FTQ_CMD_OFFSET () {(0x3ff<<0);}' unless defined(&BNX_COM_COMTQ_FTQ_CMD_OFFSET);
	eval 'sub BNX_COM_COMTQ_FTQ_CMD_WR_TOP () {(1<<10);}' unless defined(&BNX_COM_COMTQ_FTQ_CMD_WR_TOP);
	eval 'sub BNX_COM_COMTQ_FTQ_CMD_WR_TOP_0 () {(0<<10);}' unless defined(&BNX_COM_COMTQ_FTQ_CMD_WR_TOP_0);
	eval 'sub BNX_COM_COMTQ_FTQ_CMD_WR_TOP_1 () {(1<<10);}' unless defined(&BNX_COM_COMTQ_FTQ_CMD_WR_TOP_1);
	eval 'sub BNX_COM_COMTQ_FTQ_CMD_SFT_RESET () {(1<<25);}' unless defined(&BNX_COM_COMTQ_FTQ_CMD_SFT_RESET);
	eval 'sub BNX_COM_COMTQ_FTQ_CMD_RD_DATA () {(1<<26);}' unless defined(&BNX_COM_COMTQ_FTQ_CMD_RD_DATA);
	eval 'sub BNX_COM_COMTQ_FTQ_CMD_ADD_INTERVEN () {(1<<27);}' unless defined(&BNX_COM_COMTQ_FTQ_CMD_ADD_INTERVEN);
	eval 'sub BNX_COM_COMTQ_FTQ_CMD_ADD_DATA () {(1<<28);}' unless defined(&BNX_COM_COMTQ_FTQ_CMD_ADD_DATA);
	eval 'sub BNX_COM_COMTQ_FTQ_CMD_INTERVENE_CLR () {(1<<29);}' unless defined(&BNX_COM_COMTQ_FTQ_CMD_INTERVENE_CLR);
	eval 'sub BNX_COM_COMTQ_FTQ_CMD_POP () {(1<<30);}' unless defined(&BNX_COM_COMTQ_FTQ_CMD_POP);
	eval 'sub BNX_COM_COMTQ_FTQ_CMD_BUSY () {(1<<31);}' unless defined(&BNX_COM_COMTQ_FTQ_CMD_BUSY);
	eval 'sub BNX_COM_COMTQ_FTQ_CTL () {0x1053bc;}' unless defined(&BNX_COM_COMTQ_FTQ_CTL);
	eval 'sub BNX_COM_COMTQ_FTQ_CTL_INTERVENE () {(1<<0);}' unless defined(&BNX_COM_COMTQ_FTQ_CTL_INTERVENE);
	eval 'sub BNX_COM_COMTQ_FTQ_CTL_OVERFLOW () {(1<<1);}' unless defined(&BNX_COM_COMTQ_FTQ_CTL_OVERFLOW);
	eval 'sub BNX_COM_COMTQ_FTQ_CTL_FORCE_INTERVENE () {(1<<2);}' unless defined(&BNX_COM_COMTQ_FTQ_CTL_FORCE_INTERVENE);
	eval 'sub BNX_COM_COMTQ_FTQ_CTL_MAX_DEPTH () {(0x3ff<<12);}' unless defined(&BNX_COM_COMTQ_FTQ_CTL_MAX_DEPTH);
	eval 'sub BNX_COM_COMTQ_FTQ_CTL_CUR_DEPTH () {(0x3ff<<22);}' unless defined(&BNX_COM_COMTQ_FTQ_CTL_CUR_DEPTH);
	eval 'sub BNX_COM_COMQ_FTQ_DATA () {0x1053c0;}' unless defined(&BNX_COM_COMQ_FTQ_DATA);
	eval 'sub BNX_COM_COMQ_FTQ_CMD () {0x1053f8;}' unless defined(&BNX_COM_COMQ_FTQ_CMD);
	eval 'sub BNX_COM_COMQ_FTQ_CMD_OFFSET () {(0x3ff<<0);}' unless defined(&BNX_COM_COMQ_FTQ_CMD_OFFSET);
	eval 'sub BNX_COM_COMQ_FTQ_CMD_WR_TOP () {(1<<10);}' unless defined(&BNX_COM_COMQ_FTQ_CMD_WR_TOP);
	eval 'sub BNX_COM_COMQ_FTQ_CMD_WR_TOP_0 () {(0<<10);}' unless defined(&BNX_COM_COMQ_FTQ_CMD_WR_TOP_0);
	eval 'sub BNX_COM_COMQ_FTQ_CMD_WR_TOP_1 () {(1<<10);}' unless defined(&BNX_COM_COMQ_FTQ_CMD_WR_TOP_1);
	eval 'sub BNX_COM_COMQ_FTQ_CMD_SFT_RESET () {(1<<25);}' unless defined(&BNX_COM_COMQ_FTQ_CMD_SFT_RESET);
	eval 'sub BNX_COM_COMQ_FTQ_CMD_RD_DATA () {(1<<26);}' unless defined(&BNX_COM_COMQ_FTQ_CMD_RD_DATA);
	eval 'sub BNX_COM_COMQ_FTQ_CMD_ADD_INTERVEN () {(1<<27);}' unless defined(&BNX_COM_COMQ_FTQ_CMD_ADD_INTERVEN);
	eval 'sub BNX_COM_COMQ_FTQ_CMD_ADD_DATA () {(1<<28);}' unless defined(&BNX_COM_COMQ_FTQ_CMD_ADD_DATA);
	eval 'sub BNX_COM_COMQ_FTQ_CMD_INTERVENE_CLR () {(1<<29);}' unless defined(&BNX_COM_COMQ_FTQ_CMD_INTERVENE_CLR);
	eval 'sub BNX_COM_COMQ_FTQ_CMD_POP () {(1<<30);}' unless defined(&BNX_COM_COMQ_FTQ_CMD_POP);
	eval 'sub BNX_COM_COMQ_FTQ_CMD_BUSY () {(1<<31);}' unless defined(&BNX_COM_COMQ_FTQ_CMD_BUSY);
	eval 'sub BNX_COM_COMQ_FTQ_CTL () {0x1053fc;}' unless defined(&BNX_COM_COMQ_FTQ_CTL);
	eval 'sub BNX_COM_COMQ_FTQ_CTL_INTERVENE () {(1<<0);}' unless defined(&BNX_COM_COMQ_FTQ_CTL_INTERVENE);
	eval 'sub BNX_COM_COMQ_FTQ_CTL_OVERFLOW () {(1<<1);}' unless defined(&BNX_COM_COMQ_FTQ_CTL_OVERFLOW);
	eval 'sub BNX_COM_COMQ_FTQ_CTL_FORCE_INTERVENE () {(1<<2);}' unless defined(&BNX_COM_COMQ_FTQ_CTL_FORCE_INTERVENE);
	eval 'sub BNX_COM_COMQ_FTQ_CTL_MAX_DEPTH () {(0x3ff<<12);}' unless defined(&BNX_COM_COMQ_FTQ_CTL_MAX_DEPTH);
	eval 'sub BNX_COM_COMQ_FTQ_CTL_CUR_DEPTH () {(0x3ff<<22);}' unless defined(&BNX_COM_COMQ_FTQ_CTL_CUR_DEPTH);
	eval 'sub BNX_COM_SCRATCH () {0x120000;}' unless defined(&BNX_COM_SCRATCH);
	eval 'sub BNX_CP_CPU_MODE () {0x185000;}' unless defined(&BNX_CP_CPU_MODE);
	eval 'sub BNX_CP_CPU_MODE_LOCAL_RST () {(1<<0);}' unless defined(&BNX_CP_CPU_MODE_LOCAL_RST);
	eval 'sub BNX_CP_CPU_MODE_STEP_ENA () {(1<<1);}' unless defined(&BNX_CP_CPU_MODE_STEP_ENA);
	eval 'sub BNX_CP_CPU_MODE_PAGE_0_DATA_ENA () {(1<<2);}' unless defined(&BNX_CP_CPU_MODE_PAGE_0_DATA_ENA);
	eval 'sub BNX_CP_CPU_MODE_PAGE_0_INST_ENA () {(1<<3);}' unless defined(&BNX_CP_CPU_MODE_PAGE_0_INST_ENA);
	eval 'sub BNX_CP_CPU_MODE_MSG_BIT1 () {(1<<6);}' unless defined(&BNX_CP_CPU_MODE_MSG_BIT1);
	eval 'sub BNX_CP_CPU_MODE_INTERRUPT_ENA () {(1<<7);}' unless defined(&BNX_CP_CPU_MODE_INTERRUPT_ENA);
	eval 'sub BNX_CP_CPU_MODE_SOFT_HALT () {(1<<10);}' unless defined(&BNX_CP_CPU_MODE_SOFT_HALT);
	eval 'sub BNX_CP_CPU_MODE_BAD_DATA_HALT_ENA () {(1<<11);}' unless defined(&BNX_CP_CPU_MODE_BAD_DATA_HALT_ENA);
	eval 'sub BNX_CP_CPU_MODE_BAD_INST_HALT_ENA () {(1<<12);}' unless defined(&BNX_CP_CPU_MODE_BAD_INST_HALT_ENA);
	eval 'sub BNX_CP_CPU_MODE_FIO_ABORT_HALT_ENA () {(1<<13);}' unless defined(&BNX_CP_CPU_MODE_FIO_ABORT_HALT_ENA);
	eval 'sub BNX_CP_CPU_MODE_SPAD_UNDERFLOW_HALT_ENA () {(1<<15);}' unless defined(&BNX_CP_CPU_MODE_SPAD_UNDERFLOW_HALT_ENA);
	eval 'sub BNX_CP_CPU_STATE () {0x185004;}' unless defined(&BNX_CP_CPU_STATE);
	eval 'sub BNX_CP_CPU_STATE_BREAKPOINT () {(1<<0);}' unless defined(&BNX_CP_CPU_STATE_BREAKPOINT);
	eval 'sub BNX_CP_CPU_STATE_BAD_INST_HALTED () {(1<<2);}' unless defined(&BNX_CP_CPU_STATE_BAD_INST_HALTED);
	eval 'sub BNX_CP_CPU_STATE_PAGE_0_DATA_HALTED () {(1<<3);}' unless defined(&BNX_CP_CPU_STATE_PAGE_0_DATA_HALTED);
	eval 'sub BNX_CP_CPU_STATE_PAGE_0_INST_HALTED () {(1<<4);}' unless defined(&BNX_CP_CPU_STATE_PAGE_0_INST_HALTED);
	eval 'sub BNX_CP_CPU_STATE_BAD_DATA_ADDR_HALTED () {(1<<5);}' unless defined(&BNX_CP_CPU_STATE_BAD_DATA_ADDR_HALTED);
	eval 'sub BNX_CP_CPU_STATE_BAD_pc_HALTED () {(1<<6);}' unless defined(&BNX_CP_CPU_STATE_BAD_pc_HALTED);
	eval 'sub BNX_CP_CPU_STATE_ALIGN_HALTED () {(1<<7);}' unless defined(&BNX_CP_CPU_STATE_ALIGN_HALTED);
	eval 'sub BNX_CP_CPU_STATE_FIO_ABORT_HALTED () {(1<<8);}' unless defined(&BNX_CP_CPU_STATE_FIO_ABORT_HALTED);
	eval 'sub BNX_CP_CPU_STATE_SOFT_HALTED () {(1<<10);}' unless defined(&BNX_CP_CPU_STATE_SOFT_HALTED);
	eval 'sub BNX_CP_CPU_STATE_SPAD_UNDERFLOW () {(1<<11);}' unless defined(&BNX_CP_CPU_STATE_SPAD_UNDERFLOW);
	eval 'sub BNX_CP_CPU_STATE_INTERRRUPT () {(1<<12);}' unless defined(&BNX_CP_CPU_STATE_INTERRRUPT);
	eval 'sub BNX_CP_CPU_STATE_DATA_ACCESS_STALL () {(1<<14);}' unless defined(&BNX_CP_CPU_STATE_DATA_ACCESS_STALL);
	eval 'sub BNX_CP_CPU_STATE_INST_FETCH_STALL () {(1<<15);}' unless defined(&BNX_CP_CPU_STATE_INST_FETCH_STALL);
	eval 'sub BNX_CP_CPU_STATE_BLOCKED_READ () {(1<<31);}' unless defined(&BNX_CP_CPU_STATE_BLOCKED_READ);
	eval 'sub BNX_CP_CPU_EVENT_MASK () {0x185008;}' unless defined(&BNX_CP_CPU_EVENT_MASK);
	eval 'sub BNX_CP_CPU_EVENT_MASK_BREAKPOINT_MASK () {(1<<0);}' unless defined(&BNX_CP_CPU_EVENT_MASK_BREAKPOINT_MASK);
	eval 'sub BNX_CP_CPU_EVENT_MASK_BAD_INST_HALTED_MASK () {(1<<2);}' unless defined(&BNX_CP_CPU_EVENT_MASK_BAD_INST_HALTED_MASK);
	eval 'sub BNX_CP_CPU_EVENT_MASK_PAGE_0_DATA_HALTED_MASK () {(1<<3);}' unless defined(&BNX_CP_CPU_EVENT_MASK_PAGE_0_DATA_HALTED_MASK);
	eval 'sub BNX_CP_CPU_EVENT_MASK_PAGE_0_INST_HALTED_MASK () {(1<<4);}' unless defined(&BNX_CP_CPU_EVENT_MASK_PAGE_0_INST_HALTED_MASK);
	eval 'sub BNX_CP_CPU_EVENT_MASK_BAD_DATA_ADDR_HALTED_MASK () {(1<<5);}' unless defined(&BNX_CP_CPU_EVENT_MASK_BAD_DATA_ADDR_HALTED_MASK);
	eval 'sub BNX_CP_CPU_EVENT_MASK_BAD_PC_HALTED_MASK () {(1<<6);}' unless defined(&BNX_CP_CPU_EVENT_MASK_BAD_PC_HALTED_MASK);
	eval 'sub BNX_CP_CPU_EVENT_MASK_ALIGN_HALTED_MASK () {(1<<7);}' unless defined(&BNX_CP_CPU_EVENT_MASK_ALIGN_HALTED_MASK);
	eval 'sub BNX_CP_CPU_EVENT_MASK_FIO_ABORT_MASK () {(1<<8);}' unless defined(&BNX_CP_CPU_EVENT_MASK_FIO_ABORT_MASK);
	eval 'sub BNX_CP_CPU_EVENT_MASK_SOFT_HALTED_MASK () {(1<<10);}' unless defined(&BNX_CP_CPU_EVENT_MASK_SOFT_HALTED_MASK);
	eval 'sub BNX_CP_CPU_EVENT_MASK_SPAD_UNDERFLOW_MASK () {(1<<11);}' unless defined(&BNX_CP_CPU_EVENT_MASK_SPAD_UNDERFLOW_MASK);
	eval 'sub BNX_CP_CPU_EVENT_MASK_INTERRUPT_MASK () {(1<<12);}' unless defined(&BNX_CP_CPU_EVENT_MASK_INTERRUPT_MASK);
	eval 'sub BNX_CP_CPU_PROGRAM_COUNTER () {0x18501c;}' unless defined(&BNX_CP_CPU_PROGRAM_COUNTER);
	eval 'sub BNX_CP_CPU_INSTRUCTION () {0x185020;}' unless defined(&BNX_CP_CPU_INSTRUCTION);
	eval 'sub BNX_CP_CPU_DATA_ACCESS () {0x185024;}' unless defined(&BNX_CP_CPU_DATA_ACCESS);
	eval 'sub BNX_CP_CPU_INTERRUPT_ENABLE () {0x185028;}' unless defined(&BNX_CP_CPU_INTERRUPT_ENABLE);
	eval 'sub BNX_CP_CPU_INTERRUPT_VECTOR () {0x18502c;}' unless defined(&BNX_CP_CPU_INTERRUPT_VECTOR);
	eval 'sub BNX_CP_CPU_INTERRUPT_SAVED_PC () {0x185030;}' unless defined(&BNX_CP_CPU_INTERRUPT_SAVED_PC);
	eval 'sub BNX_CP_CPU_HW_BREAKPOINT () {0x185034;}' unless defined(&BNX_CP_CPU_HW_BREAKPOINT);
	eval 'sub BNX_CP_CPU_HW_BREAKPOINT_DISABLE () {(1<<0);}' unless defined(&BNX_CP_CPU_HW_BREAKPOINT_DISABLE);
	eval 'sub BNX_CP_CPU_HW_BREAKPOINT_ADDRESS () {(0x3fffffff<<2);}' unless defined(&BNX_CP_CPU_HW_BREAKPOINT_ADDRESS);
	eval 'sub BNX_CP_CPU_DEBUG_VECT_PEEK () {0x185038;}' unless defined(&BNX_CP_CPU_DEBUG_VECT_PEEK);
	eval 'sub BNX_CP_CPU_DEBUG_VECT_PEEK_1_VALUE () {(0x7ff<<0);}' unless defined(&BNX_CP_CPU_DEBUG_VECT_PEEK_1_VALUE);
	eval 'sub BNX_CP_CPU_DEBUG_VECT_PEEK_1_PEEK_EN () {(1<<11);}' unless defined(&BNX_CP_CPU_DEBUG_VECT_PEEK_1_PEEK_EN);
	eval 'sub BNX_CP_CPU_DEBUG_VECT_PEEK_1_SEL () {(0xf<<12);}' unless defined(&BNX_CP_CPU_DEBUG_VECT_PEEK_1_SEL);
	eval 'sub BNX_CP_CPU_DEBUG_VECT_PEEK_2_VALUE () {(0x7ff<<16);}' unless defined(&BNX_CP_CPU_DEBUG_VECT_PEEK_2_VALUE);
	eval 'sub BNX_CP_CPU_DEBUG_VECT_PEEK_2_PEEK_EN () {(1<<27);}' unless defined(&BNX_CP_CPU_DEBUG_VECT_PEEK_2_PEEK_EN);
	eval 'sub BNX_CP_CPU_DEBUG_VECT_PEEK_2_SEL () {(0xf<<28);}' unless defined(&BNX_CP_CPU_DEBUG_VECT_PEEK_2_SEL);
	eval 'sub BNX_CP_CPU_LAST_BRANCH_ADDR () {0x185048;}' unless defined(&BNX_CP_CPU_LAST_BRANCH_ADDR);
	eval 'sub BNX_CP_CPU_LAST_BRANCH_ADDR_TYPE () {(1<<1);}' unless defined(&BNX_CP_CPU_LAST_BRANCH_ADDR_TYPE);
	eval 'sub BNX_CP_CPU_LAST_BRANCH_ADDR_TYPE_JUMP () {(0<<1);}' unless defined(&BNX_CP_CPU_LAST_BRANCH_ADDR_TYPE_JUMP);
	eval 'sub BNX_CP_CPU_LAST_BRANCH_ADDR_TYPE_BRANCH () {(1<<1);}' unless defined(&BNX_CP_CPU_LAST_BRANCH_ADDR_TYPE_BRANCH);
	eval 'sub BNX_CP_CPU_LAST_BRANCH_ADDR_LBA () {(0x3fffffff<<2);}' unless defined(&BNX_CP_CPU_LAST_BRANCH_ADDR_LBA);
	eval 'sub BNX_CP_CPU_REG_FILE () {0x185200;}' unless defined(&BNX_CP_CPU_REG_FILE);
	eval 'sub BNX_CP_CPQ_FTQ_DATA () {0x1853c0;}' unless defined(&BNX_CP_CPQ_FTQ_DATA);
	eval 'sub BNX_CP_CPQ_FTQ_CMD () {0x1853f8;}' unless defined(&BNX_CP_CPQ_FTQ_CMD);
	eval 'sub BNX_CP_CPQ_FTQ_CMD_OFFSET () {(0x3ff<<0);}' unless defined(&BNX_CP_CPQ_FTQ_CMD_OFFSET);
	eval 'sub BNX_CP_CPQ_FTQ_CMD_WR_TOP () {(1<<10);}' unless defined(&BNX_CP_CPQ_FTQ_CMD_WR_TOP);
	eval 'sub BNX_CP_CPQ_FTQ_CMD_WR_TOP_0 () {(0<<10);}' unless defined(&BNX_CP_CPQ_FTQ_CMD_WR_TOP_0);
	eval 'sub BNX_CP_CPQ_FTQ_CMD_WR_TOP_1 () {(1<<10);}' unless defined(&BNX_CP_CPQ_FTQ_CMD_WR_TOP_1);
	eval 'sub BNX_CP_CPQ_FTQ_CMD_SFT_RESET () {(1<<25);}' unless defined(&BNX_CP_CPQ_FTQ_CMD_SFT_RESET);
	eval 'sub BNX_CP_CPQ_FTQ_CMD_RD_DATA () {(1<<26);}' unless defined(&BNX_CP_CPQ_FTQ_CMD_RD_DATA);
	eval 'sub BNX_CP_CPQ_FTQ_CMD_ADD_INTERVEN () {(1<<27);}' unless defined(&BNX_CP_CPQ_FTQ_CMD_ADD_INTERVEN);
	eval 'sub BNX_CP_CPQ_FTQ_CMD_ADD_DATA () {(1<<28);}' unless defined(&BNX_CP_CPQ_FTQ_CMD_ADD_DATA);
	eval 'sub BNX_CP_CPQ_FTQ_CMD_INTERVENE_CLR () {(1<<29);}' unless defined(&BNX_CP_CPQ_FTQ_CMD_INTERVENE_CLR);
	eval 'sub BNX_CP_CPQ_FTQ_CMD_POP () {(1<<30);}' unless defined(&BNX_CP_CPQ_FTQ_CMD_POP);
	eval 'sub BNX_CP_CPQ_FTQ_CMD_BUSY () {(1<<31);}' unless defined(&BNX_CP_CPQ_FTQ_CMD_BUSY);
	eval 'sub BNX_CP_CPQ_FTQ_CTL () {0x1853fc;}' unless defined(&BNX_CP_CPQ_FTQ_CTL);
	eval 'sub BNX_CP_CPQ_FTQ_CTL_INTERVENE () {(1<<0);}' unless defined(&BNX_CP_CPQ_FTQ_CTL_INTERVENE);
	eval 'sub BNX_CP_CPQ_FTQ_CTL_OVERFLOW () {(1<<1);}' unless defined(&BNX_CP_CPQ_FTQ_CTL_OVERFLOW);
	eval 'sub BNX_CP_CPQ_FTQ_CTL_FORCE_INTERVENE () {(1<<2);}' unless defined(&BNX_CP_CPQ_FTQ_CTL_FORCE_INTERVENE);
	eval 'sub BNX_CP_CPQ_FTQ_CTL_MAX_DEPTH () {(0x3ff<<12);}' unless defined(&BNX_CP_CPQ_FTQ_CTL_MAX_DEPTH);
	eval 'sub BNX_CP_CPQ_FTQ_CTL_CUR_DEPTH () {(0x3ff<<22);}' unless defined(&BNX_CP_CPQ_FTQ_CTL_CUR_DEPTH);
	eval 'sub BNX_CP_SCRATCH () {0x1a0000;}' unless defined(&BNX_CP_SCRATCH);
	eval 'sub BNX_MCP_CPU_MODE () {0x145000;}' unless defined(&BNX_MCP_CPU_MODE);
	eval 'sub BNX_MCP_CPU_MODE_LOCAL_RST () {(1<<0);}' unless defined(&BNX_MCP_CPU_MODE_LOCAL_RST);
	eval 'sub BNX_MCP_CPU_MODE_STEP_ENA () {(1<<1);}' unless defined(&BNX_MCP_CPU_MODE_STEP_ENA);
	eval 'sub BNX_MCP_CPU_MODE_PAGE_0_DATA_ENA () {(1<<2);}' unless defined(&BNX_MCP_CPU_MODE_PAGE_0_DATA_ENA);
	eval 'sub BNX_MCP_CPU_MODE_PAGE_0_INST_ENA () {(1<<3);}' unless defined(&BNX_MCP_CPU_MODE_PAGE_0_INST_ENA);
	eval 'sub BNX_MCP_CPU_MODE_MSG_BIT1 () {(1<<6);}' unless defined(&BNX_MCP_CPU_MODE_MSG_BIT1);
	eval 'sub BNX_MCP_CPU_MODE_INTERRUPT_ENA () {(1<<7);}' unless defined(&BNX_MCP_CPU_MODE_INTERRUPT_ENA);
	eval 'sub BNX_MCP_CPU_MODE_SOFT_HALT () {(1<<10);}' unless defined(&BNX_MCP_CPU_MODE_SOFT_HALT);
	eval 'sub BNX_MCP_CPU_MODE_BAD_DATA_HALT_ENA () {(1<<11);}' unless defined(&BNX_MCP_CPU_MODE_BAD_DATA_HALT_ENA);
	eval 'sub BNX_MCP_CPU_MODE_BAD_INST_HALT_ENA () {(1<<12);}' unless defined(&BNX_MCP_CPU_MODE_BAD_INST_HALT_ENA);
	eval 'sub BNX_MCP_CPU_MODE_FIO_ABORT_HALT_ENA () {(1<<13);}' unless defined(&BNX_MCP_CPU_MODE_FIO_ABORT_HALT_ENA);
	eval 'sub BNX_MCP_CPU_MODE_SPAD_UNDERFLOW_HALT_ENA () {(1<<15);}' unless defined(&BNX_MCP_CPU_MODE_SPAD_UNDERFLOW_HALT_ENA);
	eval 'sub BNX_MCP_CPU_STATE () {0x145004;}' unless defined(&BNX_MCP_CPU_STATE);
	eval 'sub BNX_MCP_CPU_STATE_BREAKPOINT () {(1<<0);}' unless defined(&BNX_MCP_CPU_STATE_BREAKPOINT);
	eval 'sub BNX_MCP_CPU_STATE_BAD_INST_HALTED () {(1<<2);}' unless defined(&BNX_MCP_CPU_STATE_BAD_INST_HALTED);
	eval 'sub BNX_MCP_CPU_STATE_PAGE_0_DATA_HALTED () {(1<<3);}' unless defined(&BNX_MCP_CPU_STATE_PAGE_0_DATA_HALTED);
	eval 'sub BNX_MCP_CPU_STATE_PAGE_0_INST_HALTED () {(1<<4);}' unless defined(&BNX_MCP_CPU_STATE_PAGE_0_INST_HALTED);
	eval 'sub BNX_MCP_CPU_STATE_BAD_DATA_ADDR_HALTED () {(1<<5);}' unless defined(&BNX_MCP_CPU_STATE_BAD_DATA_ADDR_HALTED);
	eval 'sub BNX_MCP_CPU_STATE_BAD_pc_HALTED () {(1<<6);}' unless defined(&BNX_MCP_CPU_STATE_BAD_pc_HALTED);
	eval 'sub BNX_MCP_CPU_STATE_ALIGN_HALTED () {(1<<7);}' unless defined(&BNX_MCP_CPU_STATE_ALIGN_HALTED);
	eval 'sub BNX_MCP_CPU_STATE_FIO_ABORT_HALTED () {(1<<8);}' unless defined(&BNX_MCP_CPU_STATE_FIO_ABORT_HALTED);
	eval 'sub BNX_MCP_CPU_STATE_SOFT_HALTED () {(1<<10);}' unless defined(&BNX_MCP_CPU_STATE_SOFT_HALTED);
	eval 'sub BNX_MCP_CPU_STATE_SPAD_UNDERFLOW () {(1<<11);}' unless defined(&BNX_MCP_CPU_STATE_SPAD_UNDERFLOW);
	eval 'sub BNX_MCP_CPU_STATE_INTERRRUPT () {(1<<12);}' unless defined(&BNX_MCP_CPU_STATE_INTERRRUPT);
	eval 'sub BNX_MCP_CPU_STATE_DATA_ACCESS_STALL () {(1<<14);}' unless defined(&BNX_MCP_CPU_STATE_DATA_ACCESS_STALL);
	eval 'sub BNX_MCP_CPU_STATE_INST_FETCH_STALL () {(1<<15);}' unless defined(&BNX_MCP_CPU_STATE_INST_FETCH_STALL);
	eval 'sub BNX_MCP_CPU_STATE_BLOCKED_READ () {(1<<31);}' unless defined(&BNX_MCP_CPU_STATE_BLOCKED_READ);
	eval 'sub BNX_MCP_CPU_EVENT_MASK () {0x145008;}' unless defined(&BNX_MCP_CPU_EVENT_MASK);
	eval 'sub BNX_MCP_CPU_EVENT_MASK_BREAKPOINT_MASK () {(1<<0);}' unless defined(&BNX_MCP_CPU_EVENT_MASK_BREAKPOINT_MASK);
	eval 'sub BNX_MCP_CPU_EVENT_MASK_BAD_INST_HALTED_MASK () {(1<<2);}' unless defined(&BNX_MCP_CPU_EVENT_MASK_BAD_INST_HALTED_MASK);
	eval 'sub BNX_MCP_CPU_EVENT_MASK_PAGE_0_DATA_HALTED_MASK () {(1<<3);}' unless defined(&BNX_MCP_CPU_EVENT_MASK_PAGE_0_DATA_HALTED_MASK);
	eval 'sub BNX_MCP_CPU_EVENT_MASK_PAGE_0_INST_HALTED_MASK () {(1<<4);}' unless defined(&BNX_MCP_CPU_EVENT_MASK_PAGE_0_INST_HALTED_MASK);
	eval 'sub BNX_MCP_CPU_EVENT_MASK_BAD_DATA_ADDR_HALTED_MASK () {(1<<5);}' unless defined(&BNX_MCP_CPU_EVENT_MASK_BAD_DATA_ADDR_HALTED_MASK);
	eval 'sub BNX_MCP_CPU_EVENT_MASK_BAD_PC_HALTED_MASK () {(1<<6);}' unless defined(&BNX_MCP_CPU_EVENT_MASK_BAD_PC_HALTED_MASK);
	eval 'sub BNX_MCP_CPU_EVENT_MASK_ALIGN_HALTED_MASK () {(1<<7);}' unless defined(&BNX_MCP_CPU_EVENT_MASK_ALIGN_HALTED_MASK);
	eval 'sub BNX_MCP_CPU_EVENT_MASK_FIO_ABORT_MASK () {(1<<8);}' unless defined(&BNX_MCP_CPU_EVENT_MASK_FIO_ABORT_MASK);
	eval 'sub BNX_MCP_CPU_EVENT_MASK_SOFT_HALTED_MASK () {(1<<10);}' unless defined(&BNX_MCP_CPU_EVENT_MASK_SOFT_HALTED_MASK);
	eval 'sub BNX_MCP_CPU_EVENT_MASK_SPAD_UNDERFLOW_MASK () {(1<<11);}' unless defined(&BNX_MCP_CPU_EVENT_MASK_SPAD_UNDERFLOW_MASK);
	eval 'sub BNX_MCP_CPU_EVENT_MASK_INTERRUPT_MASK () {(1<<12);}' unless defined(&BNX_MCP_CPU_EVENT_MASK_INTERRUPT_MASK);
	eval 'sub BNX_MCP_CPU_PROGRAM_COUNTER () {0x14501c;}' unless defined(&BNX_MCP_CPU_PROGRAM_COUNTER);
	eval 'sub BNX_MCP_CPU_INSTRUCTION () {0x145020;}' unless defined(&BNX_MCP_CPU_INSTRUCTION);
	eval 'sub BNX_MCP_CPU_DATA_ACCESS () {0x145024;}' unless defined(&BNX_MCP_CPU_DATA_ACCESS);
	eval 'sub BNX_MCP_CPU_INTERRUPT_ENABLE () {0x145028;}' unless defined(&BNX_MCP_CPU_INTERRUPT_ENABLE);
	eval 'sub BNX_MCP_CPU_INTERRUPT_VECTOR () {0x14502c;}' unless defined(&BNX_MCP_CPU_INTERRUPT_VECTOR);
	eval 'sub BNX_MCP_CPU_INTERRUPT_SAVED_PC () {0x145030;}' unless defined(&BNX_MCP_CPU_INTERRUPT_SAVED_PC);
	eval 'sub BNX_MCP_CPU_HW_BREAKPOINT () {0x145034;}' unless defined(&BNX_MCP_CPU_HW_BREAKPOINT);
	eval 'sub BNX_MCP_CPU_HW_BREAKPOINT_DISABLE () {(1<<0);}' unless defined(&BNX_MCP_CPU_HW_BREAKPOINT_DISABLE);
	eval 'sub BNX_MCP_CPU_HW_BREAKPOINT_ADDRESS () {(0x3fffffff<<2);}' unless defined(&BNX_MCP_CPU_HW_BREAKPOINT_ADDRESS);
	eval 'sub BNX_MCP_CPU_DEBUG_VECT_PEEK () {0x145038;}' unless defined(&BNX_MCP_CPU_DEBUG_VECT_PEEK);
	eval 'sub BNX_MCP_CPU_DEBUG_VECT_PEEK_1_VALUE () {(0x7ff<<0);}' unless defined(&BNX_MCP_CPU_DEBUG_VECT_PEEK_1_VALUE);
	eval 'sub BNX_MCP_CPU_DEBUG_VECT_PEEK_1_PEEK_EN () {(1<<11);}' unless defined(&BNX_MCP_CPU_DEBUG_VECT_PEEK_1_PEEK_EN);
	eval 'sub BNX_MCP_CPU_DEBUG_VECT_PEEK_1_SEL () {(0xf<<12);}' unless defined(&BNX_MCP_CPU_DEBUG_VECT_PEEK_1_SEL);
	eval 'sub BNX_MCP_CPU_DEBUG_VECT_PEEK_2_VALUE () {(0x7ff<<16);}' unless defined(&BNX_MCP_CPU_DEBUG_VECT_PEEK_2_VALUE);
	eval 'sub BNX_MCP_CPU_DEBUG_VECT_PEEK_2_PEEK_EN () {(1<<27);}' unless defined(&BNX_MCP_CPU_DEBUG_VECT_PEEK_2_PEEK_EN);
	eval 'sub BNX_MCP_CPU_DEBUG_VECT_PEEK_2_SEL () {(0xf<<28);}' unless defined(&BNX_MCP_CPU_DEBUG_VECT_PEEK_2_SEL);
	eval 'sub BNX_MCP_CPU_LAST_BRANCH_ADDR () {0x145048;}' unless defined(&BNX_MCP_CPU_LAST_BRANCH_ADDR);
	eval 'sub BNX_MCP_CPU_LAST_BRANCH_ADDR_TYPE () {(1<<1);}' unless defined(&BNX_MCP_CPU_LAST_BRANCH_ADDR_TYPE);
	eval 'sub BNX_MCP_CPU_LAST_BRANCH_ADDR_TYPE_JUMP () {(0<<1);}' unless defined(&BNX_MCP_CPU_LAST_BRANCH_ADDR_TYPE_JUMP);
	eval 'sub BNX_MCP_CPU_LAST_BRANCH_ADDR_TYPE_BRANCH () {(1<<1);}' unless defined(&BNX_MCP_CPU_LAST_BRANCH_ADDR_TYPE_BRANCH);
	eval 'sub BNX_MCP_CPU_LAST_BRANCH_ADDR_LBA () {(0x3fffffff<<2);}' unless defined(&BNX_MCP_CPU_LAST_BRANCH_ADDR_LBA);
	eval 'sub BNX_MCP_CPU_REG_FILE () {0x145200;}' unless defined(&BNX_MCP_CPU_REG_FILE);
	eval 'sub BNX_MCP_MCPQ_FTQ_DATA () {0x1453c0;}' unless defined(&BNX_MCP_MCPQ_FTQ_DATA);
	eval 'sub BNX_MCP_MCPQ_FTQ_CMD () {0x1453f8;}' unless defined(&BNX_MCP_MCPQ_FTQ_CMD);
	eval 'sub BNX_MCP_MCPQ_FTQ_CMD_OFFSET () {(0x3ff<<0);}' unless defined(&BNX_MCP_MCPQ_FTQ_CMD_OFFSET);
	eval 'sub BNX_MCP_MCPQ_FTQ_CMD_WR_TOP () {(1<<10);}' unless defined(&BNX_MCP_MCPQ_FTQ_CMD_WR_TOP);
	eval 'sub BNX_MCP_MCPQ_FTQ_CMD_WR_TOP_0 () {(0<<10);}' unless defined(&BNX_MCP_MCPQ_FTQ_CMD_WR_TOP_0);
	eval 'sub BNX_MCP_MCPQ_FTQ_CMD_WR_TOP_1 () {(1<<10);}' unless defined(&BNX_MCP_MCPQ_FTQ_CMD_WR_TOP_1);
	eval 'sub BNX_MCP_MCPQ_FTQ_CMD_SFT_RESET () {(1<<25);}' unless defined(&BNX_MCP_MCPQ_FTQ_CMD_SFT_RESET);
	eval 'sub BNX_MCP_MCPQ_FTQ_CMD_RD_DATA () {(1<<26);}' unless defined(&BNX_MCP_MCPQ_FTQ_CMD_RD_DATA);
	eval 'sub BNX_MCP_MCPQ_FTQ_CMD_ADD_INTERVEN () {(1<<27);}' unless defined(&BNX_MCP_MCPQ_FTQ_CMD_ADD_INTERVEN);
	eval 'sub BNX_MCP_MCPQ_FTQ_CMD_ADD_DATA () {(1<<28);}' unless defined(&BNX_MCP_MCPQ_FTQ_CMD_ADD_DATA);
	eval 'sub BNX_MCP_MCPQ_FTQ_CMD_INTERVENE_CLR () {(1<<29);}' unless defined(&BNX_MCP_MCPQ_FTQ_CMD_INTERVENE_CLR);
	eval 'sub BNX_MCP_MCPQ_FTQ_CMD_POP () {(1<<30);}' unless defined(&BNX_MCP_MCPQ_FTQ_CMD_POP);
	eval 'sub BNX_MCP_MCPQ_FTQ_CMD_BUSY () {(1<<31);}' unless defined(&BNX_MCP_MCPQ_FTQ_CMD_BUSY);
	eval 'sub BNX_MCP_MCPQ_FTQ_CTL () {0x1453fc;}' unless defined(&BNX_MCP_MCPQ_FTQ_CTL);
	eval 'sub BNX_MCP_MCPQ_FTQ_CTL_INTERVENE () {(1<<0);}' unless defined(&BNX_MCP_MCPQ_FTQ_CTL_INTERVENE);
	eval 'sub BNX_MCP_MCPQ_FTQ_CTL_OVERFLOW () {(1<<1);}' unless defined(&BNX_MCP_MCPQ_FTQ_CTL_OVERFLOW);
	eval 'sub BNX_MCP_MCPQ_FTQ_CTL_FORCE_INTERVENE () {(1<<2);}' unless defined(&BNX_MCP_MCPQ_FTQ_CTL_FORCE_INTERVENE);
	eval 'sub BNX_MCP_MCPQ_FTQ_CTL_MAX_DEPTH () {(0x3ff<<12);}' unless defined(&BNX_MCP_MCPQ_FTQ_CTL_MAX_DEPTH);
	eval 'sub BNX_MCP_MCPQ_FTQ_CTL_CUR_DEPTH () {(0x3ff<<22);}' unless defined(&BNX_MCP_MCPQ_FTQ_CTL_CUR_DEPTH);
	eval 'sub BNX_MCP_ROM () {0x150000;}' unless defined(&BNX_MCP_ROM);
	eval 'sub BNX_MCP_SCRATCH () {0x160000;}' unless defined(&BNX_MCP_SCRATCH);
	eval 'sub BNX_SHM_HDR_SIGNATURE () { &BNX_MCP_SCRATCH;}' unless defined(&BNX_SHM_HDR_SIGNATURE);
	eval 'sub BNX_SHM_HDR_SIGNATURE_SIG_MASK () {0xffff0000;}' unless defined(&BNX_SHM_HDR_SIGNATURE_SIG_MASK);
	eval 'sub BNX_SHM_HDR_SIGNATURE_SIG () {0x53530000;}' unless defined(&BNX_SHM_HDR_SIGNATURE_SIG);
	eval 'sub BNX_SHM_HDR_SIGNATURE_VER_MASK () {0xff;}' unless defined(&BNX_SHM_HDR_SIGNATURE_VER_MASK);
	eval 'sub BNX_SHM_HDR_SIGNATURE_VER_ONE () {0x1;}' unless defined(&BNX_SHM_HDR_SIGNATURE_VER_ONE);
	eval 'sub BNX_SHM_HDR_ADDR_0 () { &BNX_MCP_SCRATCH + 4;}' unless defined(&BNX_SHM_HDR_ADDR_0);
	eval 'sub BNX_SHM_HDR_ADDR_1 () { &BNX_MCP_SCRATCH + 8;}' unless defined(&BNX_SHM_HDR_ADDR_1);
	eval 'sub NUM_MC_HASH_REGISTERS () {8;}' unless defined(&NUM_MC_HASH_REGISTERS);
	eval 'sub PHY_BCM5706_PHY_ID () {0x206160;}' unless defined(&PHY_BCM5706_PHY_ID);
	eval 'sub PHY_ID {
	    my($id) = @_;
    	    eval q((($id) & 0xfffffff0));
	}' unless defined(&PHY_ID);
	eval 'sub PHY_REV_ID {
	    my($id) = @_;
    	    eval q((($id) & 0xf));
	}' unless defined(&PHY_REV_ID);
	eval 'sub BCM5708S_UP1 () {0xb;}' unless defined(&BCM5708S_UP1);
	eval 'sub BCM5708S_UP1_2G5 () {0x1;}' unless defined(&BCM5708S_UP1_2G5);
	eval 'sub BCM5708S_BLK_ADDR () {0x1f;}' unless defined(&BCM5708S_BLK_ADDR);
	eval 'sub BCM5708S_BLK_ADDR_DIG () {0x;}' unless defined(&BCM5708S_BLK_ADDR_DIG);
	eval 'sub BCM5708S_BLK_ADDR_DIG3 () {0x2;}' unless defined(&BCM5708S_BLK_ADDR_DIG3);
	eval 'sub BCM5708S_BLK_ADDR_TX_MISC () {0x5;}' unless defined(&BCM5708S_BLK_ADDR_TX_MISC);
	eval 'sub BCM5708S_1000X_CTL1 () {0x10;}' unless defined(&BCM5708S_1000X_CTL1);
	eval 'sub BCM5708S_1000X_CTL1_FIBER_MODE () {0x1;}' unless defined(&BCM5708S_1000X_CTL1_FIBER_MODE);
	eval 'sub BCM5708S_1000X_CTL1_AUTODET_EN () {0x10;}' unless defined(&BCM5708S_1000X_CTL1_AUTODET_EN);
	eval 'sub BCM5708S_1000X_CTL2 () {0x11;}' unless defined(&BCM5708S_1000X_CTL2);
	eval 'sub BCM5708S_1000X_CTL2_PLLEL_DET_EN () {0x1;}' unless defined(&BCM5708S_1000X_CTL2_PLLEL_DET_EN);
	eval 'sub BCM5708S_1000X_STAT1 () {0x14;}' unless defined(&BCM5708S_1000X_STAT1);
	eval 'sub BCM5708S_1000X_STAT1_SGMII () {0x1;}' unless defined(&BCM5708S_1000X_STAT1_SGMII);
	eval 'sub BCM5708S_1000X_STAT1_LINK () {0x2;}' unless defined(&BCM5708S_1000X_STAT1_LINK);
	eval 'sub BCM5708S_1000X_STAT1_FD () {0x4;}' unless defined(&BCM5708S_1000X_STAT1_FD);
	eval 'sub BCM5708S_1000X_STAT1_SPEED_MASK () {0x18;}' unless defined(&BCM5708S_1000X_STAT1_SPEED_MASK);
	eval 'sub BCM5708S_1000X_STAT1_SPEED_10 () {0x;}' unless defined(&BCM5708S_1000X_STAT1_SPEED_10);
	eval 'sub BCM5708S_1000X_STAT1_SPEED_100 () {0x8;}' unless defined(&BCM5708S_1000X_STAT1_SPEED_100);
	eval 'sub BCM5708S_1000X_STAT1_SPEED_1G () {0x10;}' unless defined(&BCM5708S_1000X_STAT1_SPEED_1G);
	eval 'sub BCM5708S_1000X_STAT1_SPEED_2G5 () {0x18;}' unless defined(&BCM5708S_1000X_STAT1_SPEED_2G5);
	eval 'sub BCM5708S_1000X_STAT1_TX_PAUSE () {0x20;}' unless defined(&BCM5708S_1000X_STAT1_TX_PAUSE);
	eval 'sub BCM5708S_1000X_STAT1_RX_PAUSE () {0x40;}' unless defined(&BCM5708S_1000X_STAT1_RX_PAUSE);
	eval 'sub BCM5708S_DIG_3_0 () {0x10;}' unless defined(&BCM5708S_DIG_3_0);
	eval 'sub BCM5708S_DIG_3_0_USE_IEEE () {0x1;}' unless defined(&BCM5708S_DIG_3_0_USE_IEEE);
	eval 'sub BCM5708S_TX_ACTL1 () {0x15;}' unless defined(&BCM5708S_TX_ACTL1);
	eval 'sub BCM5708S_TX_ACTL1_DRIVER_VCM () {0x30;}' unless defined(&BCM5708S_TX_ACTL1_DRIVER_VCM);
	eval 'sub BCM5708S_TX_ACTL3 () {0x17;}' unless defined(&BCM5708S_TX_ACTL3);
	eval 'sub RX_COPY_THRESH () {92;}' unless defined(&RX_COPY_THRESH);
	eval 'sub DMA_READ_CHANS () {5;}' unless defined(&DMA_READ_CHANS);
	eval 'sub DMA_WRITE_CHANS () {3;}' unless defined(&DMA_WRITE_CHANS);
	eval 'sub BCM_PAGE_BITS () { &PAGE_SHIFT;}' unless defined(&BCM_PAGE_BITS);
	eval 'sub BCM_PAGE_SIZE () { &PAGE_SIZE;}' unless defined(&BCM_PAGE_SIZE);
	eval 'sub TX_PAGES () {2;}' unless defined(&TX_PAGES);
	eval 'sub TOTAL_TX_BD_PER_PAGE () {( &BCM_PAGE_SIZE / $sizeof{\'struct tx_bd\'});}' unless defined(&TOTAL_TX_BD_PER_PAGE);
	eval 'sub USABLE_TX_BD_PER_PAGE () {( &TOTAL_TX_BD_PER_PAGE - 1);}' unless defined(&USABLE_TX_BD_PER_PAGE);
	eval 'sub TOTAL_TX_BD () {( &TOTAL_TX_BD_PER_PAGE *  &TX_PAGES);}' unless defined(&TOTAL_TX_BD);
	eval 'sub USABLE_TX_BD () {( &USABLE_TX_BD_PER_PAGE *  &TX_PAGES);}' unless defined(&USABLE_TX_BD);
	eval 'sub MAX_TX_BD () {( &TOTAL_TX_BD - 1);}' unless defined(&MAX_TX_BD);
	eval 'sub RX_PAGES () {2;}' unless defined(&RX_PAGES);
	eval 'sub TOTAL_RX_BD_PER_PAGE () {( &BCM_PAGE_SIZE / $sizeof{\'struct rx_bd\'});}' unless defined(&TOTAL_RX_BD_PER_PAGE);
	eval 'sub USABLE_RX_BD_PER_PAGE () {( &TOTAL_RX_BD_PER_PAGE - 1);}' unless defined(&USABLE_RX_BD_PER_PAGE);
	eval 'sub TOTAL_RX_BD () {( &TOTAL_RX_BD_PER_PAGE *  &RX_PAGES);}' unless defined(&TOTAL_RX_BD);
	eval 'sub USABLE_RX_BD () {( &USABLE_RX_BD_PER_PAGE *  &RX_PAGES);}' unless defined(&USABLE_RX_BD);
	eval 'sub MAX_RX_BD () {( &TOTAL_RX_BD - 1);}' unless defined(&MAX_RX_BD);
	eval 'sub NEXT_TX_BD {
	    my($x) = @_;
    	    eval q(((($x) &  &USABLE_TX_BD_PER_PAGE) == ( &USABLE_TX_BD_PER_PAGE - 1)) ? ($x) + 2: ($x) + 1);
	}' unless defined(&NEXT_TX_BD);
	eval 'sub TX_CHAIN_IDX {
	    my($x) = @_;
    	    eval q((($x) &  &MAX_TX_BD));
	}' unless defined(&TX_CHAIN_IDX);
	eval 'sub TX_PAGE {
	    my($x) = @_;
    	    eval q(((($x) & ~ &USABLE_TX_BD_PER_PAGE) >> 8));
	}' unless defined(&TX_PAGE);
	eval 'sub TX_IDX {
	    my($x) = @_;
    	    eval q((($x) &  &USABLE_TX_BD_PER_PAGE));
	}' unless defined(&TX_IDX);
	eval 'sub NEXT_RX_BD {
	    my($x) = @_;
    	    eval q(((($x) &  &USABLE_RX_BD_PER_PAGE) == ( &USABLE_RX_BD_PER_PAGE - 1)) ? ($x) + 2: ($x) + 1);
	}' unless defined(&NEXT_RX_BD);
	eval 'sub RX_CHAIN_IDX {
	    my($x) = @_;
    	    eval q((($x) &  &MAX_RX_BD));
	}' unless defined(&RX_CHAIN_IDX);
	eval 'sub RX_PAGE {
	    my($x) = @_;
    	    eval q(((($x) & ~ &USABLE_RX_BD_PER_PAGE) >> 8));
	}' unless defined(&RX_PAGE);
	eval 'sub RX_IDX {
	    my($x) = @_;
    	    eval q((($x) &  &USABLE_RX_BD_PER_PAGE));
	}' unless defined(&RX_IDX);
	eval 'sub CTX_SHIFT () {7;}' unless defined(&CTX_SHIFT);
	eval 'sub CTX_SIZE () {(1<<  &CTX_SHIFT);}' unless defined(&CTX_SIZE);
	eval 'sub CTX_MASK () {( &CTX_SIZE - 1);}' unless defined(&CTX_MASK);
	eval 'sub GET_CID_ADDR {
	    my($_cid) = @_;
    	    eval q((($_cid) <<  &CTX_SHIFT));
	}' unless defined(&GET_CID_ADDR);
	eval 'sub GET_CID {
	    my($_cid_addr) = @_;
    	    eval q((($_cid_addr) >>  &CTX_SHIFT));
	}' unless defined(&GET_CID);
	eval 'sub PHY_CTX_SHIFT () {6;}' unless defined(&PHY_CTX_SHIFT);
	eval 'sub PHY_CTX_SIZE () {(1<<  &PHY_CTX_SHIFT);}' unless defined(&PHY_CTX_SIZE);
	eval 'sub PHY_CTX_MASK () {( &PHY_CTX_SIZE - 1);}' unless defined(&PHY_CTX_MASK);
	eval 'sub GET_PCID_ADDR {
	    my($_pcid) = @_;
    	    eval q((($_pcid) <<  &PHY_CTX_SHIFT));
	}' unless defined(&GET_PCID_ADDR);
	eval 'sub GET_PCID {
	    my($_pcid_addr) = @_;
    	    eval q((($_pcid_addr) >>  &PHY_CTX_SHIFT));
	}' unless defined(&GET_PCID);
	eval 'sub MB_KERNEL_CTX_SHIFT () {8;}' unless defined(&MB_KERNEL_CTX_SHIFT);
	eval 'sub MB_KERNEL_CTX_SIZE () {(1<<  &MB_KERNEL_CTX_SHIFT);}' unless defined(&MB_KERNEL_CTX_SIZE);
	eval 'sub MB_KERNEL_CTX_MASK () {( &MB_KERNEL_CTX_SIZE - 1);}' unless defined(&MB_KERNEL_CTX_MASK);
	eval 'sub MB_GET_CID_ADDR {
	    my($_cid) = @_;
    	    eval q((0x10000 + (($_cid) <<  &MB_KERNEL_CTX_SHIFT)));
	}' unless defined(&MB_GET_CID_ADDR);
	eval 'sub MAX_CID_CNT () {0x4000;}' unless defined(&MAX_CID_CNT);
	eval 'sub MAX_CID_ADDR () {( &GET_CID_ADDR( &MAX_CID_CNT));}' unless defined(&MAX_CID_ADDR);
	eval 'sub INVALID_CID_ADDR () {0xffffffff;}' unless defined(&INVALID_CID_ADDR);
	eval 'sub TX_CID () {16;}' unless defined(&TX_CID);
	eval 'sub RX_CID () {0;}' unless defined(&RX_CID);
	eval 'sub MB_TX_CID_ADDR () { &MB_GET_CID_ADDR( &TX_CID);}' unless defined(&MB_TX_CID_ADDR);
	eval 'sub MB_RX_CID_ADDR () { &MB_GET_CID_ADDR( &RX_CID);}' unless defined(&MB_RX_CID_ADDR);
	eval 'sub RV2P_PROC1 () {0;}' unless defined(&RV2P_PROC1);
	eval 'sub RV2P_PROC2 () {1;}' unless defined(&RV2P_PROC2);
	eval 'sub BNX_MIREG {
	    my($x) = @_;
    	    eval q((($x & 0x1f) << 16));
	}' unless defined(&BNX_MIREG);
	eval 'sub BNX_MIPHY {
	    my($x) = @_;
    	    eval q((($x & 0x1f) << 21));
	}' unless defined(&BNX_MIPHY);
	eval 'sub BNX_PHY_TIMEOUT () {50;}' unless defined(&BNX_PHY_TIMEOUT);
	eval 'sub BNX_NVRAM_SIZE () {0x200;}' unless defined(&BNX_NVRAM_SIZE);
	eval 'sub BNX_NVRAM_MAGIC () {0x669955aa;}' unless defined(&BNX_NVRAM_MAGIC);
	eval 'sub BNX_CRC32_RESIDUAL () {0xdebb20e3;}' unless defined(&BNX_CRC32_RESIDUAL);
	eval 'sub BNX_TX_TIMEOUT () {5;}' unless defined(&BNX_TX_TIMEOUT);
	eval 'sub BNX_MAX_SEGMENTS () {8;}' unless defined(&BNX_MAX_SEGMENTS);
	eval 'sub BNX_DMA_ALIGN () {8;}' unless defined(&BNX_DMA_ALIGN);
	eval 'sub BNX_DMA_BOUNDARY () {0;}' unless defined(&BNX_DMA_BOUNDARY);
	eval 'sub BNX_MIN_MTU () {60;}' unless defined(&BNX_MIN_MTU);
	eval 'sub BNX_MIN_ETHER_MTU () {64;}' unless defined(&BNX_MIN_ETHER_MTU);
	eval 'sub BNX_MAX_STD_MTU () {1500;}' unless defined(&BNX_MAX_STD_MTU);
	eval 'sub BNX_MAX_STD_ETHER_MTU () {1518;}' unless defined(&BNX_MAX_STD_ETHER_MTU);
	eval 'sub BNX_MAX_STD_ETHER_MTU_VLAN () {1522;}' unless defined(&BNX_MAX_STD_ETHER_MTU_VLAN);
	eval 'sub BNX_MAX_JUMBO_MTU () {9000;}' unless defined(&BNX_MAX_JUMBO_MTU);
	eval 'sub BNX_MAX_JUMBO_ETHER_MTU () {9018;}' unless defined(&BNX_MAX_JUMBO_ETHER_MTU);
	eval 'sub BNX_MAX_JUMBO_ETHER_MTU_VLAN () {9022;}' unless defined(&BNX_MAX_JUMBO_ETHER_MTU_VLAN);
	eval 'sub BNX_MAX_MRU () { &MCLBYTES;}' unless defined(&BNX_MAX_MRU);
	eval 'sub BNX_MAX_JUMBO_MRU () {9216;}' unless defined(&BNX_MAX_JUMBO_MRU);
	eval 'sub BNX_STATUS_BLK_SZ () {$sizeof{\'struct status_block\'};}' unless defined(&BNX_STATUS_BLK_SZ);
	eval 'sub BNX_STATS_BLK_SZ () {$sizeof{\'struct statistics_block\'};}' unless defined(&BNX_STATS_BLK_SZ);
	eval 'sub BNX_TX_CHAIN_PAGE_SZ () { &BCM_PAGE_SIZE;}' unless defined(&BNX_TX_CHAIN_PAGE_SZ);
	eval 'sub BNX_RX_CHAIN_PAGE_SZ () { &BCM_PAGE_SIZE;}' unless defined(&BNX_RX_CHAIN_PAGE_SZ);
	eval 'sub BNX_PCIX_FLAG () {0x1;}' unless defined(&BNX_PCIX_FLAG);
	eval 'sub BNX_PCI_32BIT_FLAG () {0x2;}' unless defined(&BNX_PCI_32BIT_FLAG);
	eval 'sub BNX_ONE_TDMA_FLAG () {0x4;}' unless defined(&BNX_ONE_TDMA_FLAG);
	eval 'sub BNX_NO_WOL_FLAG () {0x8;}' unless defined(&BNX_NO_WOL_FLAG);
	eval 'sub BNX_USING_DAC_FLAG () {0x10;}' unless defined(&BNX_USING_DAC_FLAG);
	eval 'sub BNX_USING_MSI_FLAG () {0x20;}' unless defined(&BNX_USING_MSI_FLAG);
	eval 'sub BNX_MFW_ENABLE_FLAG () {0x40;}' unless defined(&BNX_MFW_ENABLE_FLAG);
	eval 'sub BNX_ACTIVE_FLAG () {0x80;}' unless defined(&BNX_ACTIVE_FLAG);
	eval 'sub BNX_ALLOC_PKTS_FLAG () {0x100;}' unless defined(&BNX_ALLOC_PKTS_FLAG);
	eval 'sub BNX_PHY_SERDES_FLAG () {0x1;}' unless defined(&BNX_PHY_SERDES_FLAG);
	eval 'sub BNX_PHY_CRC_FIX_FLAG () {0x2;}' unless defined(&BNX_PHY_CRC_FIX_FLAG);
	eval 'sub BNX_PHY_PARALLEL_DETECT_FLAG () {0x4;}' unless defined(&BNX_PHY_PARALLEL_DETECT_FLAG);
	eval 'sub BNX_PHY_2_5G_CAPABLE_FLAG () {0x8;}' unless defined(&BNX_PHY_2_5G_CAPABLE_FLAG);
	eval 'sub BNX_PHY_INT_MODE_MASK_FLAG () {0x300;}' unless defined(&BNX_PHY_INT_MODE_MASK_FLAG);
	eval 'sub BNX_PHY_INT_MODE_AUTO_POLLING_FLAG () {0x100;}' unless defined(&BNX_PHY_INT_MODE_AUTO_POLLING_FLAG);
	eval 'sub BNX_PHY_INT_MODE_LINK_READY_FLAG () {0x200;}' unless defined(&BNX_PHY_INT_MODE_LINK_READY_FLAG);
	if(defined(&BNX_DEBUG)) {
	}
    }
    eval 'sub BNX_RV2P_PROC2_MAX_BD_PAGE_LOC () {5;}' unless defined(&BNX_RV2P_PROC2_MAX_BD_PAGE_LOC);
    eval 'sub BNX_RV2P_PROC2_CHG_MAX_BD_PAGE {
        my($_rv2p, $_v) = @_;
	    eval q({ $_rv2p->[ &BNX_RV2P_PROC2_MAX_BD_PAGE_LOC] = ($_rv2p->[ &BNX_RV2P_PROC2_MAX_BD_PAGE_LOC] & ~0xffff) | ($_v); });
    }' unless defined(&BNX_RV2P_PROC2_CHG_MAX_BD_PAGE);
}
1;
