require '_h2ph_pre.ph';

no warnings 'redefine';

require 'sys/timeout.ph';
unless(defined(&vh_iot)) {
    sub vh_iot () {	 ($vh_ph->{ph_iot});}
}
unless(defined(&vh_memt)) {
    sub vh_memt () {	 ($vh_ph->{ph_memt});}
}
unless(defined(&vh_ioh_6845)) {
    sub vh_ioh_6845 () {	 ($vh_ph->{ph_ioh_6845});}
}
unless(defined(&vh_memh)) {
    sub vh_memh () {	 ($vh_ph->{ph_memh});}
}
unless(defined(&vga_raw_read)) {
    sub vga_raw_read {
	my($vh, $reg) = @_;
	eval q( &bus_space_read_1( ($vh->{vh_iot}),  ($vh->{vh_ioh_vga}), $reg));
    }
}
unless(defined(&vga_raw_write)) {
    sub vga_raw_write {
	my($vh, $reg, $value) = @_;
	eval q( &bus_space_write_1( ($vh->{vh_iot}),  ($vh->{vh_ioh_vga}), $reg, $value));
    }
}
unless(defined(&vga_enable)) {
    sub vga_enable {
	my($vh) = @_;
	eval q( &vga_raw_write($vh, 0, 0x20););
    }
}
unless(defined(&vga_attr_read)) {
    sub vga_attr_read {
	my($vh, $reg) = @_;
	eval q( &_vga_attr_read($vh,  &offsetof('struct reg_vgaattr', $reg)));
    }
}
unless(defined(&vga_attr_write)) {
    sub vga_attr_write {
	my($vh, $reg, $val) = @_;
	eval q( &_vga_attr_write($vh,  &offsetof('struct reg_vgaattr', $reg), $val));
    }
}
unless(defined(&vga_ts_read)) {
    sub vga_ts_read {
	my($vh, $reg) = @_;
	eval q( &_vga_ts_read($vh,  &offsetof('struct reg_vgats', $reg)));
    }
}
unless(defined(&vga_ts_write)) {
    sub vga_ts_write {
	my($vh, $reg, $val) = @_;
	eval q( &_vga_ts_write($vh,  &offsetof('struct reg_vgats', $reg), $val));
    }
}
unless(defined(&vga_gdc_read)) {
    sub vga_gdc_read {
	my($vh, $reg) = @_;
	eval q( &_vga_gdc_read($vh,  &offsetof('struct reg_vgagdc', $reg)));
    }
}
unless(defined(&vga_gdc_write)) {
    sub vga_gdc_write {
	my($vh, $reg, $val) = @_;
	eval q( &_vga_gdc_write($vh,  &offsetof('struct reg_vgagdc', $reg), $val));
    }
}
unless(defined(&vga_6845_read)) {
    sub vga_6845_read {
	my($vh, $reg) = @_;
	eval q( &pcdisplay_6845_read(($vh)-> &vh_ph, $reg));
    }
}
unless(defined(&vga_6845_write)) {
    sub vga_6845_write {
	my($vh, $reg, $val) = @_;
	eval q( &pcdisplay_6845_write(($vh)-> &vh_ph, $reg, $val));
    }
}
if((defined(&NVGA_PCI) ? &NVGA_PCI : undef) > 0) {
}
1;
