require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_CPU_H_)) {
    eval 'sub _CPU_H_ () {1;}' unless defined(&_CPU_H_);
    eval 'sub CPU_LED_BLINK () {2;}' unless defined(&CPU_LED_BLINK);
    eval 'sub CPU_ALLOWAPERTURE () {3;}' unless defined(&CPU_ALLOWAPERTURE);
    eval 'sub CPU_CPUTYPE () {4;}' unless defined(&CPU_CPUTYPE);
    eval 'sub CPU_CECCERRORS () {5;}' unless defined(&CPU_CECCERRORS);
    eval 'sub CPU_CECCLAST () {6;}' unless defined(&CPU_CECCLAST);
    eval 'sub CPU_KBDRESET () {7;}' unless defined(&CPU_KBDRESET);
    eval 'sub CPU_MAXID () {8;}' unless defined(&CPU_MAXID);
    eval 'sub CTL_MACHDEP_NAMES () {{ { 0, 0}, { 0, 0}, { "led_blink",  &CTLTYPE_INT }, { "allowaperture",  &CTLTYPE_INT }, { "cputype",  &CTLTYPE_INT }, { "ceccerrs",  &CTLTYPE_INT }, { "cecclast",  &CTLTYPE_QUAD }, { "kbdreset",  &CTLTYPE_INT }, };}' unless defined(&CTL_MACHDEP_NAMES);
    if(defined(&_KERNEL)) {
	require 'machine/ctlreg.ph';
	require 'machine/psl.ph';
	require 'machine/reg.ph';
	require 'machine/intr.ph';
	require 'sys/sched.ph';
	if(defined(&MULTIPROCESSOR)) {
	}
	if(defined(&SUN4V)) {
	}
	eval 'sub CPUF_RUNNING () {0x1;}' unless defined(&CPUF_RUNNING);
	eval 'sub curpcb () { &curcpu()-> &ci_cpcb;}' unless defined(&curpcb);
	eval 'sub fpproc () { &curcpu()-> &ci_fpproc;}' unless defined(&fpproc);
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub cpu_number () {
	        eval q(( &curcpu()-> &ci_number));
	    }' unless defined(&cpu_number);
	    eval 'sub curcpu {
	        my($void) = @_;
    		eval q({ \'struct cpu_info\' * &ci;  &__asm  &__volatile(\\"mov %%g7, %0\\" : \\"=r\\"( &ci)); ( ($ci->{ci_self})); });
	    }' unless defined(&curcpu);
	    eval 'sub CPU_IS_PRIMARY {
	        my($ci) = @_;
    		eval q((($ci)-> &ci_number == 0));
	    }' unless defined(&CPU_IS_PRIMARY);
	    eval 'sub CPU_INFO_ITERATOR () {\'int\';}' unless defined(&CPU_INFO_ITERATOR);
	    eval 'sub CPU_INFO_FOREACH {
	        my($cii, $ci) = @_;
    		eval q( &for ($cii = 0, $ci =  &cpus; $ci !=  &NULL; $ci =  ($ci->{ci_next})));
	    }' unless defined(&CPU_INFO_FOREACH);
	    eval 'sub CPU_INFO_UNIT {
	        my($ci) = @_;
    		eval q((($ci)-> &ci_number));
	    }' unless defined(&CPU_INFO_UNIT);
	    eval 'sub MAXCPUS () {256;}' unless defined(&MAXCPUS);
	} else {
	    eval 'sub cpu_number () {
	        eval q(0);
	    }' unless defined(&cpu_number);
	    eval 'sub curcpu () {
	        eval q(( &CPUINFO_VA));
	    }' unless defined(&curcpu);
	    eval 'sub CPU_IS_PRIMARY {
	        my($ci) = @_;
    		eval q(1);
	    }' unless defined(&CPU_IS_PRIMARY);
	    eval 'sub CPU_INFO_ITERATOR () {\'int\';}' unless defined(&CPU_INFO_ITERATOR);
	    eval 'sub CPU_INFO_FOREACH {
	        my($cii, $ci) = @_;
    		eval q( &for ($cii = 0, $ci =  &curcpu(); $ci !=  &NULL; $ci =  &NULL));
	    }' unless defined(&CPU_INFO_FOREACH);
	    eval 'sub CPU_INFO_UNIT {
	        my($ci) = @_;
    		eval q(0);
	    }' unless defined(&CPU_INFO_UNIT);
	    eval 'sub MAXCPUS () {1;}' unless defined(&MAXCPUS);
	    eval 'sub cpu_unidle {
	        my($ci) = @_;
    		eval q();
	    }' unless defined(&cpu_unidle);
	}
	eval 'sub CLKF_USERMODE {
	    my($framep) = @_;
    	    eval q(((($framep)-> ($t->{tf_tstate}) &  &TSTATE_PRIV) == 0));
	}' unless defined(&CLKF_USERMODE);
	eval 'sub CLKF_PC {
	    my($framep) = @_;
    	    eval q((($framep)-> ($t->{tf_pc})));
	}' unless defined(&CLKF_PC);
	eval 'sub CLKF_INTR {
	    my($framep) = @_;
    	    eval q((($framep)-> &saved_intr_level != 0));
	}' unless defined(&CLKF_INTR);
	eval 'sub aston {
	    my($p) = @_;
    	    eval q((($p)-> ($p_md->{md_astpending}) = 1));
	}' unless defined(&aston);
	eval 'sub clear_resched {
	    my($ci) = @_;
    	    eval q(($ci)-> &ci_want_resched = 0);
	}' unless defined(&clear_resched);
	eval 'sub PROC_PC {
	    my($p) = @_;
    	    eval q((($p)-> ($p_md->{md_tf}->{tf_pc})));
	}' unless defined(&PROC_PC);
	eval 'sub need_proftick {
	    my($p) = @_;
    	    eval q( &aston($p));
	}' unless defined(&need_proftick);
	eval 'sub write_all_windows () {
	    eval q( &__asm  &__volatile(\\"flushw\\" : : ));
	}' unless defined(&write_all_windows);
	if(defined(&MULTIPROCESSOR)) {
	    require 'sys/mplock.ph';
	}
    }
}
1;
