<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2158 $
 * $Id: ViewScheduleLinear.php 2158 2008-09-15 23:26:15Z ipso $
 * $Date: 2008-09-15 16:26:15 -0700 (Mon, 15 Sep 2008) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');
require_once(Environment::getBasePath() .'classes/misc/arr_multisort.class.php');

//Debug::setVerbosity(11);

if ( !$permission->Check('schedule','enabled')
		OR !( $permission->Check('schedule','view') OR $permission->Check('schedule','view_own') OR $permission->Check('schedule','view_child') ) ) {
	$permission->Redirect( FALSE ); //Redirect
}

$smarty->assign('title', TTi18n::gettext($title = 'My Schedule')); // See index.php
//BreadCrumb::setCrumb($title);
BreadCrumb::setCrumb($title, str_replace('ViewScheduleLinear.php', 'ViewSchedule.php', $_SERVER['REQUEST_URI']) );


/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'do',
												'page',
												'sort_column',
												'sort_order',
												'filter_data',
												) ) );

URLBuilder::setURL($_SERVER['SCRIPT_NAME'],
											array(
													'sort_column' => $sort_column,
													'sort_order' => $sort_order,
													'page' => $page
												) );

if ( isset( $filter_data['start_date'] ) AND $filter_data['start_date'] != '' ) {
	$filter_data['start_date'] = TTDate::parseDateTime($filter_data['start_date']);
} else {
	$filter_data['start_date'] = time();
}


if ( !isset($filter_data['show_days']) OR ( isset($filter_data['show_days']) AND $filter_data['show_days'] == '' )  ) {
	$filter_data['show_days'] = 1;
}
$filter_data['show_days'] = $filter_data['show_days'] * 7;

//Get Permission Hierarchy Children first, as this can be used for viewing, or editing.
$hlf = new HierarchyListFactory();
$permission_children_ids = $hlf->getHierarchyChildrenByCompanyIdAndUserIdAndObjectTypeID( $current_company->getId(), $current_user->getId() );
if ( $permission->Check('schedule','view') == FALSE ) {
	if ( $permission->Check('schedule','view_child') == FALSE ) {
		$permission_children_ids = array();
	}
	if ( $permission->Check('schedule','view_own') ) {
		$permission_children_ids[] = $current_user->getId();
	}

	$filter_data['permission_children_ids'] = $permission_children_ids;
}

$do = Misc::findSubmitButton('do');
switch ($do) {
	case 'view_schedule':
	default:
		$user_ids = array();

		if ( $filter_data['start_date'] != '' AND $filter_data['show_days'] != '' ) {
			$start_date = $filter_data['start_date'] = TTDate::getBeginDayEpoch( TTDate::parseDateTime($filter_data['start_date']) );
			$end_date = $start_date + ($filter_data['show_days']*86400-3601);
		} else {
			$start_date = $filter_data['start_date'] = TTDate::getBeginWeekEpoch( TTDate::getTime(), $current_user_prefs->getStartWeekDay() );
			$end_date = $start_date + ($filter_data['show_days']*(86400-3601));
		}

		Debug::text(' Start Date: '. TTDate::getDate('DATE+TIME', $start_date) .' End Date: '. TTDate::getDate('DATE+TIME', $end_date) , __FILE__, __LINE__, __METHOD__,10);

		$i=0;
		$min_hour = 0;
		$max_hour = 0;

		$ulf = new UserListFactory();
		$ulf->getSearchByCompanyIdAndArrayCriteria( $current_company->getId(), $filter_data );
		if ( $ulf->getRecordCount() > 0 ) {
			foreach( $ulf as $u_obj ) {
				$user_id = $user_ids[] = $u_obj->getId();

				$sf = new ScheduleFactory();
				$raw_schedule_shifts = $sf->getScheduleArray( $user_id, $start_date, $end_date);
				//var_dump($raw_schedule_shifts);
				if ( is_array($raw_schedule_shifts) ) {
					foreach( $raw_schedule_shifts as $day_epoch => $day_schedule_shifts ) {
						foreach ( $day_schedule_shifts as $day_schedule_shift ) {
							$day_schedule_shift['is_owner'] = $permission->isOwner( $u_obj->getCreatedBy(), $u_obj->getId() );
							$day_schedule_shift['is_child'] = $permission->isChild( $u_obj->getId(), $permission_children_ids );

							$day_schedule_shift['span_day'] = FALSE;
							$day_schedule_shift['span_day_split'] = TRUE;

							//var_dump($day_schedule_shift);
							$tmp_start_hour = TTDate::getHour( $day_schedule_shift['start_time'] );
							$tmp_end_hour = TTDate::getHour( $day_schedule_shift['end_time'] );
							Debug::text(' Schedule: Start Date: '. TTDate::getDate('DATE+TIME', $day_schedule_shift['start_time']) .' End Date: '. TTDate::getDate('DATE+TIME',  $day_schedule_shift['end_time']) , __FILE__, __LINE__, __METHOD__,10);

							if ( $i == 0 OR $tmp_start_hour < $min_hour ) {
								$min_hour = $tmp_start_hour;
								//Always try to keep one hour before the actual min time,
								//otherwise the schedule looks cluttered.
								if ( $min_hour > 0 ) {
									$min_hour--;
								}
								//Debug::text(' aSetting Min Hour: '. $min_hour, __FILE__, __LINE__, __METHOD__,10);
							}

							if ( $i == 0 OR $tmp_end_hour > $max_hour ) {
								$max_hour = $tmp_end_hour;
								//Debug::text(' aSetting Max Hour: '. $max_hour, __FILE__, __LINE__, __METHOD__,10);
								if ( $max_hour < 22 ) {
									$max_hour = $max_hour + 2;
								}
								//Debug::text(' bSetting Max Hour: '. $max_hour, __FILE__, __LINE__, __METHOD__,10);
							}

							if ( TTDate::getDayOfMonth( $day_schedule_shift['start_time'] ) != TTDate::getDayOfMonth( $day_schedule_shift['end_time'] ) ) {
								Debug::text(' aSchedule Spans the Day boundary!', __FILE__, __LINE__, __METHOD__,10);
								$day_schedule_shift['span_day'] = TRUE;
								$min_hour = 0;
								$max_hour = 24;
							}

							if ( $day_schedule_shift['span_day'] == TRUE ) {

								//Cut shift into two days.
								$tmp_schedule_shift_day1 = $tmp_schedule_shift_day2 = $day_schedule_shift;
								$tmp_schedule_shift_day1['span_day_split'] = TRUE;
								$tmp_schedule_shift_day1['end_time'] = TTDate::getEndDayEpoch( $day_schedule_shift['start_time'] )+1;
								$tmp_schedule_shift_day2['start_time'] = TTDate::getBeginDayEpoch( $day_schedule_shift['end_time'] );
								$tmp_schedule_shift_day2['span_day_split'] = FALSE;

								$tmp_schedule_shifts[$day_epoch][$day_schedule_shift['branch']][$day_schedule_shift['department']][$day_schedule_shift['user_id']][] = $tmp_schedule_shift_day1;
								$tmp_schedule_shifts[$tmp_schedule_shift_day2['start_time']][$day_schedule_shift['branch']][$day_schedule_shift['department']][$day_schedule_shift['user_id']][] = $tmp_schedule_shift_day2;

								Debug::text(' Shift SPans the Day Boundary: First End Date: '. TTDate::getDate('DATE+TIME', $tmp_schedule_shift_day1['end_time'] ) .' Second Start Date: '. TTDate::getDate('DATE+TIME', $tmp_schedule_shift_day2['start_time'] ) , __FILE__, __LINE__, __METHOD__,10);
							} else {
								$tmp_schedule_shifts[$day_epoch][$day_schedule_shift['branch']][$day_schedule_shift['department']][$day_schedule_shift['user_id']][] = $day_schedule_shift;
							}

							//$schedule_shifts[$day_epoch][] = $day_schedule_shift;
							if ( $day_schedule_shift['status_id'] == 10 ) { //Working
								if ( isset($schedule_shift_totals[$day_epoch]['total_time']) ) {
									$schedule_shift_totals[$day_epoch]['total_time'] += $day_schedule_shift['total_time'];
								} else {
									$schedule_shift_totals[$day_epoch]['total_time'] = $day_schedule_shift['total_time'];
								}
								$schedule_shift_totals[$day_epoch]['users'][] = $day_schedule_shift['user_id'];

							} elseif ( $day_schedule_shift['status_id'] == 20 ) { //Absent
								if ( isset($schedule_shift_totals[$day_epoch]['absent_total_time']) ) {
									$schedule_shift_totals[$day_epoch]['absent_total_time'] += $day_schedule_shift['total_time'];
								} else {
									$schedule_shift_totals[$day_epoch]['absent_total_time'] = $day_schedule_shift['total_time'];
								}
								$schedule_shift_totals[$day_epoch]['absent_users'][] = $day_schedule_shift['user_id'];
							}

							$i++;
						}
					}
				}
			}
		}
		unset($tmp_start_hour, $tmp_end_hour);
		//Debug::text(' Min Hour: '. $min_hour.' Max Hour: '. $max_hour, __FILE__, __LINE__, __METHOD__,10);

		$total_span_hours = 1;
		if ( isset($schedule_shift_totals) ) {
			//Find out how many hours to span
			$total_span_hours = abs($max_hour - $min_hour);
			Debug::text(' Total Hours Span: '. $total_span_hours, __FILE__, __LINE__, __METHOD__,10);

			if ( $min_hour > $max_hour) {
				$tmp_max_hour = $max_hour+24;
				$tmp_min_hour = $min_hour;
			} else {
				$tmp_max_hour = $max_hour;
				$tmp_min_hour = $min_hour;
			}


			//Generate smarty array for table header
			for($i=$tmp_min_hour; $i < $tmp_max_hour; $i++) {
				$header_hours[] = array('hour' => TTDate::getTimeStamp( "","","", $i ) );
			}
			unset($tmp_min_hour, $tmp_max_hour);
			//var_dump($header_hours);

			//Total up employees/time per day.
			if ( isset($schedule_shift_totals) ) {
				foreach( $schedule_shift_totals as $day_epoch => $total_arr) {
					if ( !isset($total_arr['users']) ) {
						$total_arr['users'] = array();
					}
					$schedule_shift_totals[$day_epoch]['total_users'] = count(array_unique($total_arr['users']));
				}
			}
			//var_dump($tmp_schedule_shifts);
		}

		if ( isset($tmp_schedule_shifts) ) {
			//Sort Branches/Departments first
			foreach ( $tmp_schedule_shifts as $day_epoch => $day_tmp_schedule_shift ) {
				ksort($day_tmp_schedule_shift);
				$tmp_schedule_shifts[$day_epoch] = $day_tmp_schedule_shift;

				foreach ( $day_tmp_schedule_shift as $branch => $department_schedule_shifts ) {
					ksort($tmp_schedule_shifts[$day_epoch][$branch]);
				}
			}

			//Sort each department by start time.
			//Remember that we have to handle split shifts here, so its more difficult to sort by last name.
			foreach ( $tmp_schedule_shifts as $day_epoch => $day_tmp_schedule_shift ) {
				foreach ( $day_tmp_schedule_shift as $branch => $department_schedule_shifts ) {
					foreach ( $department_schedule_shifts as $department => $department_schedule_shift ) {
						$tmp2_schedule_shifts[$day_epoch][$branch][$department] = Sort::multiSort( $department_schedule_shift, 'start_time' );
/*
						//var_dump($department_schedule_shift);
						$sort = new arr_multisort();
						$sort->setArray($department_schedule_shift);
						$sort->addColumn('start_time', 1);
						$department_schedule_shift = $sort->Sort();
						unset($sort);

						$tmp2_schedule_shifts[$day_epoch][$branch][$department] = $department_schedule_shift;
*/
					}
				}
			}

			//Sort each department by start time.
			foreach ( $tmp2_schedule_shifts as $day_epoch => $day_tmp_schedule_shift ) {
				foreach ( $day_tmp_schedule_shift as $branch => $department_schedule_shifts ) {
					foreach ( $department_schedule_shifts as $department => $user_schedule_shifts ) {
						foreach ( $user_schedule_shifts as $user => $user_schedule_shift ) {
							$schedule_shifts[$day_epoch][$branch][$department][$user] = Sort::multiSort( $user_schedule_shift, 'start_time');
/*
							//var_dump($department_schedule_shift);
							$sort = new arr_multisort();
							$sort->setArray($user_schedule_shift);
							$sort->addColumn('start_time', 1);
							$user_schedule_shift = $sort->Sort();
							unset($sort);

							$schedule_shifts[$day_epoch][$branch][$department][$user] = $user_schedule_shift;
*/
						}
					}
				}
			}
			unset($tmp_schedule_shifts, $tmp2_schedule_shifts);
			$tmp_schedule_shifts = $schedule_shifts;
		}
		//print_r($schedule_shifts);

		if ( isset($tmp_schedule_shifts) ) {
			//Format array so Smarty has an easier time.
			foreach ( $tmp_schedule_shifts as $day_epoch => $day_tmp_schedule_shift ) {
				foreach ( $day_tmp_schedule_shift as $branch => $department_schedule_shifts ) {
					foreach ( $department_schedule_shifts as $department => $user_schedule_shifts ) {
						foreach ( $user_schedule_shifts as $user_id => $user_schedule_shifts ) {
							$x=0;
							foreach( $user_schedule_shifts as $user_schedule_shift ) {

								if ( $x == 0 ) {
									$tmp_min_start_date = TTDate::getTimeStamp( date('Y', $user_schedule_shift['start_time']),date('m', $user_schedule_shift['start_time']),date('d', $user_schedule_shift['start_time']), $min_hour );
								} else {
									$tmp_min_start_date = $prev_user_schedule_shift['end_time'];
								}

								$off_duty = ($user_schedule_shift['start_time'] - $tmp_min_start_date) / 900; //15 Min increments
								$on_duty = ($user_schedule_shift['end_time'] - $user_schedule_shift['start_time']) / 900;
								$user_schedule_shift['off_duty'] = $off_duty;
								$user_schedule_shift['on_duty'] = $on_duty;

								$schedule_shifts[$day_epoch][$branch][$department][$user_id][] = $user_schedule_shift;

								$prev_user_schedule_shift = $user_schedule_shift;
								$x++;
							}
						}
					}
				}
			}
		}

		$smarty->assign_by_ref('header_hours', $header_hours);
		$smarty->assign_by_ref('total_span_hours', $total_span_hours);
		$smarty->assign('total_span_columns', ($total_span_hours*4)+1);
		$smarty->assign('column_widths', round( floor(99 / $total_span_hours) / 4 ) );

		$calendar_array = TTDate::getCalendarArray($start_date, $end_date, $current_user_prefs->getStartWeekDay(), FALSE);
		//var_dump($calendar_array);
		$smarty->assign_by_ref('calendar_array', $calendar_array);

		$hlf = new HolidayListFactory();
		$holiday_array = $hlf->getArrayByPolicyGroupUserId( $user_ids, $start_date, $end_date );
		//var_dump($holiday_array);

		$smarty->assign_by_ref('holidays', $holiday_array);

		//$smarty->assign_by_ref('filter_start_date', $filter_start_date);
		//$smarty->assign_by_ref('filter_show_days', $filter_show_days);

		$smarty->assign_by_ref('schedule_shifts', $schedule_shifts);
		$smarty->assign_by_ref('schedule_shift_totals', $schedule_shift_totals);

		$smarty->assign_by_ref('do', $do );

		break;
}
$smarty->display('schedule/ViewScheduleLinear.tpl');
?>