<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: install.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */

/*

	This files only purpose is to confirm we are running PHP5, and that the
	templates_c directory is writable so we can forward the user to License.php

*/
ini_set('default_socket_timeout', 5);
ini_set('allow_url_fopen', 1);

if ( isset($_GET['external_installer']) ) {
	$external_installer = (int)$_GET['external_installer'];
} else {
	$external_installer = 0;
}

$templates_c_dir = dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'templates_c';

$redir = TRUE;
if ( version_compare( PHP_VERSION, 5, '<') == 1 ) {
	echo "You are currenting using PHP v<b>". PHP_VERSION ."</b> TimeTrex requires PHP <b>v5</b> or greater!<br><br>\n";

	$redir = FALSE;
}

if ( !is_writeable($templates_c_dir) ) {
	echo "<b>". $templates_c_dir ."</b> is NOT writable by your web server! For help on this topic click <a href='http://forums.timetrex.com/viewtopic.php?t=66'>here</a>.<br><br>\n";

	$redir = FALSE;
}

if ( extension_loaded( 'gettext' ) == FALSE ) {
	echo "PHP GetText extension is not installed, TimeTrex requires GetText to be installed.<br><br>\n";

	$redir = FALSE;
}

/*
//CGI mode should work after v1.6.4, due to the REQUEST_URI changes in global.inc.php.
if (  PHP_SAPI == 'cgi' ) {
	echo "<b>PHP CGI</b> mode detected. TimeTrex requires PHP to be built as a module for your web server in order to run correctly.<br><br>\n";

	$redir = FALSE;
}
*/

if ( !include('PEAR.php') ) {
	echo "<b>PHP's PEAR</b> package is not installed. TimeTrex requires PEAR to be installed.<br>\n";

	if (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN') {
		echo "On Windows PHP includes a file called <b>go-pear.bat</b> that you can use to install PEAR.<br><br>\n";
	} else {
		echo "On most Linux distributions installing the <b>php-pear</b> package is enough.<br><br>\n";
	}

	$redir = FALSE;
}

$test_template_c_sub_dir = $templates_c_dir. DIRECTORY_SEPARATOR .uniqid();
if ( @mkdir( $test_template_c_sub_dir ) !== TRUE ) {
	echo "Your web server is unable to create directories inside of: <b>". $templates_c_dir ."</b>, please give your webserver write permissions to this directory. For help on this topic click <a href='http://forums.timetrex.com/viewtopic.php?t=66'>here</a>.<br><br>\n";

	$redir = FALSE;
}
@rmdir( $test_template_c_sub_dir );
unset($test_template_c_sub_dir);

$handle = @fopen('http://www.timetrex.com/pre_install.php?os='. PHP_OS .'&php_version='. PHP_VERSION .'&redir='. (int)$redir .'&web_server='. urlencode( substr( $_SERVER['SERVER_SOFTWARE'], 0, 20 ) ) .'&external_installer='. $external_installer .'&url='. urlencode($_SERVER['HTTP_HOST'].':'.$_SERVER['SERVER_PORT'].$_SERVER['REQUEST_URI']), "r");
@fclose($handle);

if ( $redir == TRUE ) {
	header("Location: License.php?external_installer=". $external_installer ."\n\n");
} else {
	echo "For installation support, please join our community <a href=\"http://forums.timetrex.com\" target=\"_blank\">forums</a> or
		contact a TimeTrex support expert for <a href=\"http://www.timetrex.com/setup_support.php\" target=\"_blank\">Implementation Support Services</a>.
		<br>\n";
}
?>
