<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1378 $
 * $Id: UserWageFactory.class.php 1378 2007-11-02 22:09:17Z ipso $
 * $Date: 2007-11-02 15:09:17 -0700 (Fri, 02 Nov 2007) $
 */


/**
 * @package Module_Users
 */
class UserIdentificationFactory extends Factory {
	protected $table = 'user_identification';
	protected $pk_sequence_name = 'user_identification_id_seq'; //PK Sequence name

	var $user_obj = NULL;

	function _getFactoryOptions( $name ) {

		$retval = NULL;
		switch( $name ) {
			case 'type':
				$retval = array(
											10 	=> TTi18n::gettext('iButton'),
											20	=> TTi18n::gettext('Griaule Fingerprint'),
											25	=> TTi18n::gettext('LibFingerPrint'),
											30	=> TTi18n::gettext('Barcode'), //For barcode readers and USB proximity card readers.
											40	=> TTi18n::gettext('Proximity Card'), //Mainly for proximity cards on timeclocks.
											100	=> TTi18n::gettext('ZK Fingerprint'), //TimeClocks
									);
				break;

		}

		return $retval;
	}

	function getUserObject() {
		if ( is_object($this->user_obj) ) {
			return $this->user_obj;
		} else {
			$ulf = new UserListFactory();
			$this->user_obj = $ulf->getById( $this->getUser() )->getCurrent();

			return $this->user_obj;
		}
	}

	function getUser() {
		return $this->data['user_id'];
	}
	function setUser($id) {
		$id = trim($id);

		$ulf = new UserListFactory();

		if ( $id == 0
				OR $this->Validator->isResultSetWithRows(	'user',
															$ulf->getByID($id),
															TTi18n::gettext('Invalid User')
															) ) {
			$this->data['user_id'] = $id;

			return TRUE;
		}

		return FALSE;
	}

	function getType() {
		if ( isset($this->data['type_id']) ) {
			return $this->data['type_id'];
		}

		return FALSE;
	}
	function setType($type) {
		$type = trim($type);

		$key = Option::getByValue($type, $this->getOptions('type') );
		if ($key !== FALSE) {
			$type = $key;
		}

		if ( $this->Validator->inArrayKey(	'type',
											$type,
											TTi18n::gettext('Incorrect Type'),
											$this->getOptions('type')) ) {

			$this->data['type_id'] = $type;

			return TRUE;
		}

		return FALSE;
	}

	/*
		For fingerprints,
			10 = Fingerprint 1	Pass 0.
			11 = Fingerprint 1	Pass 1.
			12 = Fingerprint 1	Pass 2.

			20 = Fingerprint 2	Pass 0.
			21 = Fingerprint 2	Pass 1.
			...
	*/
	function getNumber() {
		if ( isset($this->data['number']) ) {
			return $this->data['number'];
		}

		return FALSE;
	}
	function setNumber($value) {
		$value = trim($value);

		//Pull out only digits
		$value = $this->Validator->stripNonNumeric($value);

		if (	$this->Validator->isFloat(	'number',
											$value,
											TTi18n::gettext('Incorrect Number')) ) {

			$this->data['number'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function isUniqueValue($user_id, $type_id, $value) {
		$ph = array(
					'user_id' => (int)$user_id,
					'type_id' => (int)$type_id,
					'value' => (string)$value,
					);

		$uf = new UserFactory();

		$query = 'select a.id
					from '. $this->getTable() .' as a,
						'. $uf->getTable() .' as b
					where a.user_id = b.id
						AND b.company_id = ( select z.company_id from '. $uf->getTable() .' as z where z.id = ? and z.deleted = 0 )
						AND a.type_id = ?
						AND a.value = ?
						AND ( a.deleted = 0 AND b.deleted = 0 )';
		$id = $this->db->GetOne($query, $ph);
		//Debug::Arr($id,'Unique Value: '. $value, __FILE__, __LINE__, __METHOD__,10);

		if ( $id === FALSE ) {
			return TRUE;
		} else {
			if ($id == $this->getId() ) {
				return TRUE;
			}
		}

		return FALSE;
	}

	function getValue() {
		if ( isset($this->data['value']) ) {
			return $this->data['value'];
		}

		return FALSE;
	}
	function setValue($value) {
		$value = trim($value);

		if (
				$this->Validator->isLength(			'value',
													$value,
													TTi18n::gettext('Value is too short or too long'),
													1,
													32000)
			) {

			$this->data['value'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getExtraValue() {
		if ( isset($this->data['extra_value']) ) {
			return $this->data['extra_value'];
		}

		return FALSE;
	}
	function setExtraValue($value) {
		$value = trim($value);

		if (
				$this->Validator->isLength(			'extra_value',
													$value,
													TTi18n::gettext('Extra Value is too long'),
													1,
													256000)
			) {

			$this->data['extra_value'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function Validate() {
		if ( $this->getValue() == FALSE ) {
				$this->Validator->isTRUE(			'value',
													FALSE,
													TTi18n::gettext('Value is not defined') );

		} else {
			$this->Validator->isTrue(		'value',
											$this->isUniqueValue( $this->getUser(), $this->getType(), $this->getValue() ),
											TTi18n::gettext('Value is already in use, please enter a different one'));
		}
		return TRUE;
	}

	function preSave() {
		if (  $this->getNumber() == '' ) {
			$this->setNumber( 0 );
		}

		return TRUE;
	}

	function postSave() {
		$this->removeCache( $this->getId() );

		return TRUE;
	}

	function addLog( $log_action ) {
		return TTLog::addEntry( $this->getId(), $log_action, TTi18n::getText('Employee Identification - Employee: '. $this->getUser() .' Type: '. $this->getType() ), NULL, $this->getTable() );
	}
}
?>
