# Manipulate library path and maybe search path.

# Problem to be solved:

# We don't want to require Windows users to install Ruby and Tcl/Tk so
# we offer a package with a built-in Ruby subset. This subset is
# slightly modified from the subset created by rubyscript2exe
# (http://www.erikveen.dds.nl/rubyscript2exe/).

# The rubyscript2exe directory structure is simplified compared to the
# original Ruby directory structure, so we need to modify the library
# search path and also the general search path.

# Assumptions:

# - The script itself is at the root or in a toplevel subdirectory.
# - If an rbconfig.rb is found at the root or in
#   a toplevel directory then there is a Ruby subset.
#   If that is the Ruby which is used
#   then it needs help to find its files.

dir = File.expand_path( File.dirname( __FILE__ ) )
parent = File.dirname( dir )
parent_sl = parent.dup + ( parent =~ /[\\\/]$/ ? '' : '/' )
dir_sl = dir.dup  + ( parent =~ /[\\\/]$/ ? '' : '/' )
spath = ENV['PATH'].dup

if test( ?e, parent_sl + 'lib/rbconfig.rb' )
  root_sl = parent_sl
elsif test( ?e, dir_sl + 'lib/rbconfig.rb' )
  root_sl = dir_sl
else
  root_sl = nil
end

if root_sl
  $: << "#{root_sl}lib"
end

$:.unshift( dir )
