/*
 * Galago Image API
 *
 * Copyright (C) 2004-2006 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_IMAGE_H_
#define _GALAGO_IMAGE_H_

#include <stdlib.h>

typedef struct _GalagoImage        GalagoImage;
typedef struct _GalagoImageClass   GalagoImageClass;
typedef struct _GalagoImagePrivate GalagoImagePrivate;

#include <libgalago/galago-object.h>

struct _GalagoImage
{
	GalagoObject parent_object;

	GalagoImagePrivate *priv;

	void (*reserved_1)(void);
	void (*reserved_2)(void);
	void (*reserved_3)(void);
	void (*reserved_4)(void);
};

struct _GalagoImageClass
{
	GalagoObjectClass parent_class;

	void (*image_data_set)(GalagoImage *image);

	void (*reserved_1)(void);
	void (*reserved_2)(void);
	void (*reserved_3)(void);
	void (*reserved_4)(void);
};

#define GALAGO_TYPE_IMAGE (galago_image_get_type())
#define GALAGO_IMAGE(obj) \
		(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGO_TYPE_IMAGE, GalagoImage))
#define GALAGO_IMAGE_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), GALAGO_TYPE_IMAGE, GalagoImageClass))
#define GALAGO_IS_IMAGE(obj) \
		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGO_TYPE_IMAGE))
#define GALAGO_IS_IMAGE_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), GALAGO_TYPE_IMAGE))
#define GALAGO_IMAGE_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS((obj), GALAGO_TYPE_IMAGE, GalagoImageClass))

#define GALAGO_DBUS_IMAGE_INTERFACE "org.freedesktop.Galago.Image"

G_BEGIN_DECLS

GType galago_image_get_type(void);

GalagoImage *galago_image_new_from_file(const gchar *filename);
GalagoImage *galago_image_new_from_data(const guchar *data, gsize len);

void galago_image_get_data(const GalagoImage *image, guchar **ret_data,
						   gsize *ret_len);

G_END_DECLS

#endif /* _GALAGO_IMAGE_H_ */
