/*
 * D-BUS Support API
 *
 * Copyright (C) 2004-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_DBUS_H_
#define _GALAGO_DBUS_H_

#define DBUS_API_SUBJECT_TO_CHANGE

#include <dbus/dbus.h>
#include <libgalago/galago-object.h>
#include <libgalago/galago-value.h>

#define GALAGO_DBUS_SERVICE "org.freedesktop.Galago"

#define GALAGO_DBUS_ERROR_INVALID_ATTRIBUTE "org.freedesktop.Galago.Error.InvalidAttribute"
#define GALAGO_DBUS_ERROR_OBJECT_NOT_FOUND "org.freedesktop.Galago.Error.ObjectNotFound"

G_BEGIN_DECLS

void galago_dbus_message_iter_append_string_or_nil(DBusMessageIter *iter,
												   const char *str);
const char *galago_dbus_message_iter_get_string_or_nil(DBusMessageIter *iter);

void galago_dbus_message_iter_append_object(DBusMessageIter *iter,
											const GalagoObject *object);
void galago_dbus_message_iter_append_object_list(DBusMessageIter *iter,
												 GType type, GList *list);
void *galago_dbus_message_iter_get_object(DBusMessageIter *iter, GType type);

GList *galago_dbus_message_iter_get_object_list(DBusMessageIter *iter,
												GType type);

DBusMessage *galago_dbus_message_new_method_call(const GalagoObject *object,
												 const char *name,
												 gboolean reply,
												 DBusMessageIter *ret_iter);
DBusMessage *galago_dbus_message_new_method_call_vargs(
	const GalagoObject *object, const char *name,
	gboolean reply, va_list args);

DBusMessage *galago_dbus_message_new_method_call_args(
	const GalagoObject *object, const char *name,
	gboolean reply, ...);

void galago_dbus_send_message(const GalagoObject *object,
							  const char *name, ...);
GList *galago_dbus_send_message_with_reply_list(const GalagoObject *object,
												const char *name,
												GList *return_types, ...);
void *galago_dbus_send_message_with_reply(const GalagoObject *object,
										  const char *name,
										  GalagoValue *return_type, ...);
GalagoCallHandle galago_dbus_send_message_with_reply_async(
	const GalagoObject *object,
	const char *name,
	GCallback cb,
	gpointer user_data,
	GFreeFunc destroy_data,
	GClosureMarshal marshal,
	GalagoValue *return_value, ...);

void galago_dbus_object_push_full(GalagoObject *object);

G_END_DECLS

#endif /* _GALAGO_DBUS_H_ */
