/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.rmi.registry;

import gnu.classpath.tools.rmi.Persistent;
import gnu.classpath.tools.rmi.REGISTRY;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Map;
import java.util.TimerTask;

public class RegistryImpl
implements Registry {
    Map bindings;

    public RegistryImpl(Map map) {
        this.bindings = map;
    }

    public Remote lookup(String string) throws RemoteException, NotBoundException, AccessException {
        Object v = this.bindings.get(string);
        if (v == null) {
            throw new NotBoundException(string);
        }
        return (Remote)v;
    }

    public void bind(String string, Remote remote) throws RemoteException, AlreadyBoundException, AccessException {
        if (REGISTRY.verbose) {
            System.out.println("Bind " + string);
        }
        if (this.bindings.containsKey(string)) {
            throw new AlreadyBoundException(string);
        }
        this.bindings.put(string, remote);
    }

    public void unbind(String string) throws RemoteException, NotBoundException, AccessException {
        if (string.equals(REGISTRY.STOP)) {
            if (this.bindings instanceof Persistent) {
                ((Persistent)((Object)this.bindings)).writeContent();
            }
            System.out.println("Shutdown command received. Will terminate in 10 s");
            Persistent.timer.schedule((TimerTask)new Persistent.ExitTask(), 10000);
        } else {
            if (REGISTRY.verbose) {
                System.out.println("Unbind " + string);
            }
            if (!this.bindings.containsKey(string)) {
                throw new NotBoundException(string);
            }
            this.bindings.remove(string);
        }
    }

    public void rebind(String string, Remote remote) throws RemoteException, AccessException {
        if (REGISTRY.verbose) {
            System.out.println("Rebind " + string);
        }
        this.bindings.put(string, remote);
    }

    public String[] list() throws RemoteException, AccessException {
        ArrayList arrayList = new ArrayList(this.bindings.keySet());
        int n = arrayList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }
}

