/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.getopt.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import gnu.java.security.x509.X500DistinguishedName;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;

class SelfCertCmd
extends Command {
    private static final Logger log = Logger.getLogger(SelfCertCmd.class$("gnu.classpath.tools.keytool.SelfCertCmd").getName());
    protected String _alias;
    protected String _sigAlgorithm;
    protected String _dName;
    protected String _password;
    protected String _validityStr;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    private X500DistinguishedName distinguishedName;
    private int validityInDays;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setAlias(String string) {
        this._alias = string;
    }

    public void setSigalg(String string) {
        this._sigAlgorithm = string;
    }

    public void setDname(String string) {
        this._dName = string;
    }

    public void setValidity(String string) {
        this._validityStr = string;
    }

    public void setKeypass(String string) {
        this._password = string;
    }

    public void setStoretype(String string) {
        this._ksType = string;
    }

    public void setKeystore(String string) {
        this._ksURL = string;
    }

    public void setStorepass(String string) {
        this._ksPassword = string;
    }

    public void setProvider(String string) {
        this._providerClassName = string;
    }

    void setup() throws Exception {
        this.setKeyStoreParams(this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        this.setAliasParam(this._alias);
        this.setKeyPasswordNoPrompt(this._password);
        this.setValidityParam(this._validityStr);
        if (Configuration.DEBUG) {
            log.fine("-selfcert handler will use the following options:");
            log.fine("  -alias=" + this.alias);
            log.fine("  -sigalg=" + this._sigAlgorithm);
            log.fine("  -dname=" + this._dName);
            log.fine("  -validity=" + this.validityInDays);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
        }
    }

    void start() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, UnsupportedCallbackException, InvalidKeyException, SignatureException, CertificateException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        Key key = this.getAliasPrivateKey();
        Certificate[] certificateArray = this.store.getCertificateChain(this.alias);
        X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        this.setDName(this._dName, x500Principal);
        PublicKey publicKey = x509Certificate.getPublicKey();
        this.setSignatureAlgorithmParam(this._sigAlgorithm, key);
        byte[] byArray = this.getSelfSignedCertificate(this.distinguishedName, publicKey, (PrivateKey)key);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Certificate certificate = certificateFactory.generateCertificate(byteArrayInputStream);
        certificateArray = new Certificate[]{certificate};
        this.store.setKeyEntry(this.alias, key, this.keyPasswordChars, certificateArray);
        this.saveKeyStore();
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser classpathToolParser = new ClasspathToolParser("selfcert", true);
        classpathToolParser.setHeader(Messages.getString("SelfCertCmd.14"));
        classpathToolParser.setFooter(Messages.getString("SelfCertCmd.15"));
        OptionGroup optionGroup = new OptionGroup(Messages.getString("SelfCertCmd.16"));
        optionGroup.add(new Option(this, "alias", Messages.getString("SelfCertCmd.17"), Messages.getString("SelfCertCmd.18")){
            private /* synthetic */ SelfCertCmd this$0;
            {
                this.this$0 = selfCertCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._alias = string;
            }
        });
        optionGroup.add(new Option(this, "sigalg", Messages.getString("SelfCertCmd.19"), Messages.getString("SelfCertCmd.20")){
            private /* synthetic */ SelfCertCmd this$0;
            {
                this.this$0 = selfCertCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._sigAlgorithm = string;
            }
        });
        optionGroup.add(new Option(this, "dname", Messages.getString("SelfCertCmd.21"), Messages.getString("SelfCertCmd.22")){
            private /* synthetic */ SelfCertCmd this$0;
            {
                this.this$0 = selfCertCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._dName = string;
            }
        });
        optionGroup.add(new Option(this, "keypass", Messages.getString("SelfCertCmd.23"), Messages.getString("SelfCertCmd.24")){
            private /* synthetic */ SelfCertCmd this$0;
            {
                this.this$0 = selfCertCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._password = string;
            }
        });
        optionGroup.add(new Option(this, "validity", Messages.getString("SelfCertCmd.25"), Messages.getString("SelfCertCmd.26")){
            private /* synthetic */ SelfCertCmd this$0;
            {
                this.this$0 = selfCertCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._validityStr = string;
            }
        });
        optionGroup.add(new Option(this, "storetype", Messages.getString("SelfCertCmd.27"), Messages.getString("SelfCertCmd.28")){
            private /* synthetic */ SelfCertCmd this$0;
            {
                this.this$0 = selfCertCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksType = string;
            }
        });
        optionGroup.add(new Option(this, "keystore", Messages.getString("SelfCertCmd.29"), Messages.getString("SelfCertCmd.30")){
            private /* synthetic */ SelfCertCmd this$0;
            {
                this.this$0 = selfCertCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksURL = string;
            }
        });
        optionGroup.add(new Option(this, "storepass", Messages.getString("SelfCertCmd.31"), Messages.getString("SelfCertCmd.32")){
            private /* synthetic */ SelfCertCmd this$0;
            {
                this.this$0 = selfCertCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksPassword = string;
            }
        });
        optionGroup.add(new Option(this, "provider", Messages.getString("SelfCertCmd.33"), Messages.getString("SelfCertCmd.34")){
            private /* synthetic */ SelfCertCmd this$0;
            {
                this.this$0 = selfCertCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._providerClassName = string;
            }
        });
        optionGroup.add(new Option(this, "v", Messages.getString("SelfCertCmd.35")){
            private /* synthetic */ SelfCertCmd this$0;
            {
                this.this$0 = selfCertCmd;
                super(string, string2);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.verbose = true;
            }
        });
        classpathToolParser.add(optionGroup);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", classpathToolParser);
        }
        return classpathToolParser;
    }

    private void setDName(String string, X500Principal x500Principal) {
        string = string != null && string.trim().length() > 0 ? string.trim() : x500Principal.toString().trim();
        this.distinguishedName = new X500DistinguishedName(string);
    }

    SelfCertCmd() {
    }
}

