/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.getopt.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import java.io.File;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.logging.Logger;

public class CACertCmd
extends Command {
    private static final Logger log = Logger.getLogger(CACertCmd.class$("gnu.classpath.tools.keytool.CACertCmd").getName());
    protected String _certFileName;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    private CertificateFactory x509Factory;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setFile(String string) {
        this._certFileName = string;
    }

    public void setStoretype(String string) {
        this._ksType = string;
    }

    public void setKeystore(String string) {
        this._ksURL = string;
    }

    public void setStorepass(String string) {
        this._ksPassword = string;
    }

    public void setProvider(String string) {
        this._providerClassName = string;
    }

    void setup() throws Exception {
        this.setInputStreamParam(this._certFileName);
        this.setKeyStoreParams(this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        if (Configuration.DEBUG) {
            log.fine("-cacert handler will use the following options:");
            log.fine("  -file=" + this._certFileName);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
        }
    }

    void start() throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        this.alias = this.getAliasFromFileName(this._certFileName);
        if (this.store.containsAlias(this.alias)) {
            throw new IllegalArgumentException(Messages.getFormattedString("CACertCmd.0", this.alias));
        }
        this.x509Factory = CertificateFactory.getInstance("X.509");
        Certificate certificate = this.x509Factory.generateCertificate(this.inStream);
        if (Configuration.DEBUG) {
            log.fine("certificate = " + certificate);
        }
        this.store.setCertificateEntry(this.alias, certificate);
        this.saveKeyStore();
        if (this.verbose) {
            System.out.println(Messages.getFormattedString("CACertCmd.1", new Object[]{this._certFileName, this.alias}));
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser classpathToolParser = new ClasspathToolParser("cacert", true);
        classpathToolParser.setHeader(Messages.getString("CACertCmd.2"));
        classpathToolParser.setFooter(Messages.getString("CACertCmd.3"));
        OptionGroup optionGroup = new OptionGroup(Messages.getString("CACertCmd.4"));
        optionGroup.add(new Option(this, "file", Messages.getString("CACertCmd.5"), Messages.getString("CACertCmd.6")){
            private /* synthetic */ CACertCmd this$0;
            {
                this.this$0 = cACertCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._certFileName = string;
            }
        });
        optionGroup.add(new Option(this, "storetype", Messages.getString("CACertCmd.7"), Messages.getString("CACertCmd.8")){
            private /* synthetic */ CACertCmd this$0;
            {
                this.this$0 = cACertCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksType = string;
            }
        });
        optionGroup.add(new Option(this, "keystore", Messages.getString("CACertCmd.9"), Messages.getString("CACertCmd.10")){
            private /* synthetic */ CACertCmd this$0;
            {
                this.this$0 = cACertCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksURL = string;
            }
        });
        optionGroup.add(new Option(this, "storepass", Messages.getString("CACertCmd.11"), Messages.getString("CACertCmd.12")){
            private /* synthetic */ CACertCmd this$0;
            {
                this.this$0 = cACertCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksPassword = string;
            }
        });
        optionGroup.add(new Option(this, "provider", Messages.getString("CACertCmd.13"), Messages.getString("CACertCmd.14")){
            private /* synthetic */ CACertCmd this$0;
            {
                this.this$0 = cACertCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._providerClassName = string;
            }
        });
        optionGroup.add(new Option(this, "v", Messages.getString("CACertCmd.15")){
            private /* synthetic */ CACertCmd this$0;
            {
                this.this$0 = cACertCmd;
                super(string, string2);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.verbose = true;
            }
        });
        classpathToolParser.add(optionGroup);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", classpathToolParser);
        }
        return classpathToolParser;
    }

    private String getAliasFromFileName(String string) {
        int n;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getAliasFromFileName", string);
        }
        if ((string = new File(string).getName()).startsWith(".")) {
            string = string.substring(1);
        }
        if ((n = string.lastIndexOf(46)) > 0) {
            string = string.substring(0, n);
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c != ' ' && c != '.') continue;
            cArray[i] = 95;
        }
        String string2 = new String(cArray);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getAliasFromFileName", string2);
        }
        return string2;
    }
}

