/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.appletviewer;

import gnu.classpath.tools.appletviewer.Main;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class ConsoleDialog
extends Frame
implements ActionListener {
    private TextArea textArea;
    private Button buttonClear;
    private Button buttonHide;
    private PrintStream printStream;

    public ConsoleDialog() {
        super(Main.messages.getString("gcjwebplugin.console_title"));
        this.setSize(400, 200);
        this.setLayout(new BorderLayout());
        this.addWindowListener(new WindowAdapter(this){
            private /* synthetic */ ConsoleDialog this$0;
            {
                this.this$0 = consoleDialog;
            }

            public void windowClosing(WindowEvent windowEvent) {
                this.this$0.hide();
            }
        });
        this.textArea = new TextArea();
        this.textArea.setEditable(false);
        this.add(this.textArea);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        this.add((Component)panel, "South");
        this.buttonClear = new Button(Main.messages.getString("gcjwebplugin.console_clear"));
        this.buttonClear.addActionListener(this);
        panel.add(this.buttonClear);
        this.buttonHide = new Button(Main.messages.getString("gcjwebplugin.console_hide"));
        this.buttonHide.addActionListener(this);
        panel.add(this.buttonHide);
        this.printStream = new PrintStream(new InternalOutputStream(this));
        this.clearTextArea();
    }

    public void clearTextArea() {
        this.textArea.setText("");
        this.println("java.vm.version: " + System.getProperty("java.vm.version"));
        this.println("java.vm.vendor: " + System.getProperty("java.vm.vendor"));
    }

    public void print(String string) {
        this.textArea.append(string);
    }

    public void println(String string) {
        this.print(string + "\n");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttonHide) {
            this.hide();
        } else if (actionEvent.getSource() == this.buttonClear) {
            this.clearTextArea();
        }
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    static class InternalOutputStream
    extends OutputStream {
        private ConsoleDialog console;

        public InternalOutputStream(ConsoleDialog consoleDialog) {
            this.console = consoleDialog;
        }

        public void write(int n) throws IOException {
            this.console.print(String.valueOf((char)n));
        }
    }
}

