/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.stream;

import gnu.xml.stream.XMLEventFactoryImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.Location;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;

public abstract class XMLEventFactory {
    protected XMLEventFactory() {
    }

    public static XMLEventFactory newInstance() throws FactoryConfigurationError {
        return XMLEventFactory.newInstance(null, null);
    }

    static XMLEventFactory newInstance(String string, ClassLoader classLoader) throws FactoryConfigurationError {
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader2 == null) {
            classLoader2 = XMLEventFactory.class$("javax.xml.stream.XMLEventFactory").getClassLoader();
        }
        String string2 = null;
        int n = 0;
        do {
            if ((string2 = XMLEventFactory.getFactoryClassName(classLoader2, n++)) == null) continue;
            try {
                Class clazz = classLoader2 != null ? classLoader2.loadClass(string2) : Class.forName(string2);
                return (XMLEventFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                string2 = null;
            }
            catch (Exception exception) {
                throw new FactoryConfigurationError(exception, "error instantiating class " + string2);
            }
        } while (string2 == null && n < 3);
        return new XMLEventFactoryImpl();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static String getFactoryClassName(ClassLoader classLoader, int n) {
        String string = "javax.xml.stream.XMLEventFactory";
        switch (n) {
            case 0: {
                return System.getProperty(string);
            }
            case 1: {
                try {
                    File file = new File(System.getProperty("java.home"));
                    file = new File(file, "lib");
                    file = new File(file, "stax.properties");
                    FileInputStream fileInputStream = new FileInputStream(file);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    ((InputStream)fileInputStream).close();
                    return properties.getProperty(string);
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            case 2: {
                try {
                    InputStream inputStream;
                    String string2 = "/META-INF/services/" + string;
                    InputStream inputStream2 = inputStream = classLoader != null ? classLoader.getResourceAsStream(string2) : XMLEventFactory.class$("javax.xml.stream.XMLEventFactory").getResourceAsStream(string2);
                    if (inputStream != null) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        String string3 = bufferedReader.readLine();
                        bufferedReader.close();
                        return string3;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        return null;
    }

    public abstract void setLocation(Location var1);

    public abstract Attribute createAttribute(String var1, String var2, String var3, String var4);

    public abstract Attribute createAttribute(String var1, String var2);

    public abstract Attribute createAttribute(QName var1, String var2);

    public abstract Namespace createNamespace(String var1);

    public abstract Namespace createNamespace(String var1, String var2);

    public abstract StartElement createStartElement(QName var1, Iterator var2, Iterator var3);

    public abstract StartElement createStartElement(String var1, String var2, String var3);

    public abstract StartElement createStartElement(String var1, String var2, String var3, Iterator var4, Iterator var5);

    public abstract StartElement createStartElement(String var1, String var2, String var3, Iterator var4, Iterator var5, NamespaceContext var6);

    public abstract EndElement createEndElement(QName var1, Iterator var2);

    public abstract EndElement createEndElement(String var1, String var2, String var3);

    public abstract EndElement createEndElement(String var1, String var2, String var3, Iterator var4);

    public abstract Characters createCharacters(String var1);

    public abstract Characters createCData(String var1);

    public abstract Characters createSpace(String var1);

    public abstract Characters createIgnorableSpace(String var1);

    public abstract StartDocument createStartDocument();

    public abstract StartDocument createStartDocument(String var1, String var2, boolean var3);

    public abstract StartDocument createStartDocument(String var1, String var2);

    public abstract StartDocument createStartDocument(String var1);

    public abstract EndDocument createEndDocument();

    public abstract EntityReference createEntityReference(String var1, EntityDeclaration var2);

    public abstract Comment createComment(String var1);

    public abstract ProcessingInstruction createProcessingInstruction(String var1, String var2);

    public abstract DTD createDTD(String var1);
}

