/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class CompoundEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = -6512679249930119683L;
    protected Vector edits = new Vector();
    private boolean inProgress = true;

    public void undo() throws CannotUndoException {
        super.undo();
        for (int i = this.edits.size() - 1; i >= 0; --i) {
            ((UndoableEdit)this.edits.elementAt(i)).undo();
        }
    }

    public void redo() throws CannotRedoException {
        super.redo();
        for (int i = 0; i < this.edits.size(); ++i) {
            ((UndoableEdit)this.edits.elementAt(i)).redo();
        }
    }

    protected UndoableEdit lastEdit() {
        if (this.edits.size() == 0) {
            return null;
        }
        return (UndoableEdit)this.edits.elementAt(this.edits.size() - 1);
    }

    public void die() {
        for (int i = this.edits.size() - 1; i >= 0; --i) {
            ((UndoableEdit)this.edits.elementAt(i)).die();
        }
        super.die();
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        if (!this.inProgress) {
            return false;
        }
        UndoableEdit undoableEdit2 = this.lastEdit();
        if (undoableEdit2 == null) {
            this.edits.add(undoableEdit);
            return true;
        }
        if (undoableEdit2.addEdit(undoableEdit)) {
            return true;
        }
        if (undoableEdit.replaceEdit(undoableEdit2)) {
            this.edits.set(this.edits.size() - 1, undoableEdit);
            return true;
        }
        this.edits.add(undoableEdit);
        return true;
    }

    public void end() {
        this.inProgress = false;
    }

    public boolean canUndo() {
        return !this.inProgress && super.canUndo();
    }

    public boolean canRedo() {
        return !this.inProgress && super.canRedo();
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public boolean isSignificant() {
        for (int i = this.edits.size() - 1; i >= 0; --i) {
            if (!((UndoableEdit)this.edits.elementAt(i)).isSignificant()) continue;
            return true;
        }
        return false;
    }

    public String getPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit == null) {
            return super.getPresentationName();
        }
        return undoableEdit.getPresentationName();
    }

    public String getUndoPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit == null) {
            return super.getUndoPresentationName();
        }
        return undoableEdit.getUndoPresentationName();
    }

    public String getRedoPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit == null) {
            return super.getRedoPresentationName();
        }
        return undoableEdit.getRedoPresentationName();
    }

    public String toString() {
        return super.toString() + " inProgress: " + this.inProgress + " edits: " + this.edits;
    }
}

