/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.javax.swing.text.html.CombinedAttributes;
import gnu.javax.swing.text.html.ImageViewIconFactory;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class ImageView
extends View {
    boolean loadOnDemand;
    ImageIcon imageIcon;
    byte imageState;

    private /* synthetic */ void finit$() {
        this.imageState = 1;
    }

    public ImageView(Element element) {
        super(element);
        this.finit$();
    }

    void reloadImage(boolean bl) {
        URL uRL = this.getImageURL();
        if (uRL == null) {
            this.imageState = (byte)4;
        } else if (!this.loadOnDemand || bl) {
            this.imageIcon = new ImageIcon(uRL);
        } else {
            this.imageState = 1;
        }
    }

    public float getAlignment(int n) {
        AttributeSet attributeSet = this.getAttributes();
        Object object = attributeSet.getAttribute(HTML.Attribute.ALIGN);
        if (object == null) {
            return 0.0f;
        }
        String string = object.toString();
        if (n == 0) {
            if (string.equals("middle")) {
                return 0.5f;
            }
            if (string.equals("left")) {
                return 0.0f;
            }
            if (string.equals("right")) {
                return 1.0f;
            }
            return 0.0f;
        }
        if (n == 1) {
            if (string.equals("middle")) {
                return 0.5f;
            }
            if (string.equals("top")) {
                return 0.0f;
            }
            if (string.equals("bottom")) {
                return 1.0f;
            }
            return 0.0f;
        }
        throw new IllegalArgumentException("axis " + n);
    }

    public String getAltText() {
        Object object = this.getAttributes().getAttribute(HTML.Attribute.ALT);
        if (object != null) {
            return object.toString();
        }
        URL uRL = this.getImageURL();
        if (uRL == null) {
            return "";
        }
        return uRL.getFile();
    }

    public AttributeSet getAttributes() {
        StyleSheet styleSheet = this.getStyleSheet();
        if (styleSheet == null) {
            return super.getAttributes();
        }
        return CombinedAttributes.combine(super.getAttributes(), styleSheet.getViewAttributes(this));
    }

    public Image getImage() {
        if (this.imageIcon == null) {
            return null;
        }
        return this.imageIcon.getImage();
    }

    public URL getImageURL() {
        Object object = this.getAttributes().getAttribute(HTML.Attribute.SRC);
        if (object == null) {
            return null;
        }
        try {
            return new URL(object.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Icon getLoadingImageIcon() {
        return ImageViewIconFactory.getLoadingImageIcon();
    }

    public boolean getLoadsSynchronously() {
        return this.loadOnDemand;
    }

    public Icon getNoImageIcon() {
        return ImageViewIconFactory.getNoImageIcon();
    }

    public float getPreferredSpan(int n) {
        AttributeSet attributeSet = this.getAttributes();
        Image image = this.getImage();
        if (n == 0) {
            Object object = attributeSet.getAttribute(HTML.Attribute.WIDTH);
            if (object != null) {
                return Integer.parseInt(object.toString());
            }
            if (image != null) {
                return image.getWidth(this.getContainer());
            }
            return this.getNoImageIcon().getIconWidth();
        }
        if (n == 1) {
            Object object = attributeSet.getAttribute(HTML.Attribute.HEIGHT);
            if (object != null) {
                return Integer.parseInt(object.toString());
            }
            if (image != null) {
                return image.getHeight(this.getContainer());
            }
            return this.getNoImageIcon().getIconHeight();
        }
        throw new IllegalArgumentException("axis " + n);
    }

    protected StyleSheet getStyleSheet() {
        Document document = this.getElement().getDocument();
        if (document instanceof HTMLDocument) {
            return ((HTMLDocument)document).getStyleSheet();
        }
        return null;
    }

    public String getToolTipText(float f, float f2, Shape shape) {
        return this.getAltText();
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        if (this.imageIcon == null) {
            this.reloadImage(true);
            if (this.imageIcon != null) {
                if (this.imageIcon.getImageLoadStatus() != 8) {
                    this.renderIcon(graphics, rectangle, this.getLoadingImageIcon());
                    this.imageIcon.setImageObserver(this.getContainer());
                    return;
                }
            } else {
                this.renderIcon(graphics, rectangle, this.getNoImageIcon());
                return;
            }
        }
        this.imageState = (byte)this.imageIcon.getImageLoadStatus();
        switch (this.imageState) {
            case 2: 
            case 4: {
                this.renderIcon(graphics, rectangle, this.getNoImageIcon());
                break;
            }
            case 1: 
            case 8: {
                Image image = this.imageIcon.getImage().getScaledInstance(rectangle.width, rectangle.height, 1);
                ImageIcon imageIcon = new ImageIcon(image);
                imageIcon.paintIcon(this.getContainer(), graphics, rectangle.x, rectangle.y);
            }
        }
    }

    private void renderIcon(Graphics graphics, Rectangle rectangle, Icon icon) {
        Shape shape;
        block2: {
            shape = graphics.getClip();
            try {
                graphics.setClip(rectangle);
                if (icon == null) break block2;
                icon.paintIcon(this.getContainer(), graphics, rectangle.x, rectangle.y);
                graphics.drawString(this.getAltText(), rectangle.x + icon.getIconWidth(), rectangle.y + icon.getIconHeight());
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                graphics.setClip(shape);
                throw throwable;
            }
        }
        Object var5_5 = null;
        graphics.setClip(shape);
    }

    public void setLoadsSynchronously(boolean bl) {
        this.loadOnDemand = bl;
    }

    protected void setPropertiesFromAttributes() {
        this.imageIcon = null;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        return this.getStartOffset();
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        return shape;
    }

    public void setSize(float f, float f2) {
        if (this.imageIcon == null) {
            this.reloadImage(false);
        }
    }
}

