/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.SharedUIDefaults;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class BasicTextUI
extends TextUI
implements ViewFactory {
    static EditorKit kit = new DefaultEditorKit();
    RootView rootView;
    JTextComponent textComponent;
    private PropertyChangeHandler updateHandler;
    DocumentHandler documentHandler;
    private FocusListener focuslistener;

    private /* synthetic */ void finit$() {
        this.rootView = new RootView(this);
        this.updateHandler = new PropertyChangeHandler(this);
        this.documentHandler = new DocumentHandler(this);
        this.focuslistener = new FocusListener(this){
            private /* synthetic */ BasicTextUI this$0;
            {
                this.this$0 = basicTextUI;
            }

            public void focusGained(FocusEvent focusEvent) {
                this.this$0.textComponent.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                this.this$0.textComponent.repaint();
                if (!focusEvent.isTemporary() && this.this$0.textComponent.getSelectionStart() != this.this$0.textComponent.getSelectionEnd()) {
                    SecurityManager securityManager = System.getSecurityManager();
                    try {
                        Clipboard clipboard;
                        if (securityManager != null) {
                            securityManager.checkSystemClipboardAccess();
                        }
                        if ((clipboard = Toolkit.getDefaultToolkit().getSystemSelection()) != null) {
                            StringSelection stringSelection = new StringSelection(this.this$0.textComponent.getSelectedText());
                            clipboard.setContents(stringSelection, stringSelection);
                        }
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (HeadlessException headlessException) {
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public BasicTextUI() {
        this.finit$();
    }

    protected Caret createCaret() {
        return new BasicCaret();
    }

    protected Highlighter createHighlighter() {
        return new BasicHighlighter();
    }

    protected final JTextComponent getComponent() {
        return this.textComponent;
    }

    public void installUI(JComponent jComponent) {
        this.textComponent = (JTextComponent)jComponent;
        this.installDefaults();
        this.textComponent.addPropertyChangeListener(this.updateHandler);
        Document document = this.textComponent.getDocument();
        if (document == null) {
            document = this.getEditorKit(this.textComponent).createDefaultDocument();
            this.textComponent.setDocument(document);
        } else {
            document.addDocumentListener(this.documentHandler);
            this.modelChanged();
        }
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        Highlighter highlighter;
        Caret caret;
        Insets insets;
        String string = this.getPropertyPrefix();
        LookAndFeel.installColorsAndFont(this.textComponent, string + ".background", string + ".foreground", string + ".font");
        LookAndFeel.installBorder(this.textComponent, string + ".border");
        this.textComponent.setMargin(UIManager.getInsets(string + ".margin"));
        Color color = this.textComponent.getCaretColor();
        if (color == null || color instanceof UIResource) {
            color = UIManager.getColor(string + ".caretForeground");
            this.textComponent.setCaretColor(color);
        }
        if ((color = this.textComponent.getDisabledTextColor()) == null || color instanceof UIResource) {
            color = UIManager.getColor(string + ".inactiveBackground");
            this.textComponent.setDisabledTextColor(color);
        }
        if ((color = this.textComponent.getSelectedTextColor()) == null || color instanceof UIResource) {
            color = UIManager.getColor(string + ".selectionForeground");
            this.textComponent.setSelectedTextColor(color);
        }
        if ((color = this.textComponent.getSelectionColor()) == null || color instanceof UIResource) {
            color = UIManager.getColor(string + ".selectionBackground");
            this.textComponent.setSelectionColor(color);
        }
        if ((insets = this.textComponent.getMargin()) == null || insets instanceof UIResource) {
            insets = UIManager.getInsets(string + ".margin");
            this.textComponent.setMargin(insets);
        }
        if ((caret = this.textComponent.getCaret()) == null || caret instanceof UIResource) {
            caret = this.createCaret();
            this.textComponent.setCaret(caret);
            caret.setBlinkRate(UIManager.getInt(string + ".caretBlinkRate"));
        }
        if ((highlighter = this.textComponent.getHighlighter()) == null || highlighter instanceof UIResource) {
            this.textComponent.setHighlighter(this.createHighlighter());
        }
    }

    protected void installListeners() {
        this.textComponent.addFocusListener(this.focuslistener);
    }

    protected String getKeymapName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1);
        return string2;
    }

    protected Keymap createKeymap() {
        String string = this.getKeymapName();
        Keymap keymap = JTextComponent.getKeymap(string);
        if (keymap == null) {
            Keymap keymap2 = JTextComponent.getKeymap("default");
            keymap = JTextComponent.addKeymap(string, keymap2);
            Object object = UIManager.get(this.getPropertyPrefix() + ".keyBindings");
            if (object != null && object instanceof JTextComponent.KeyBinding[]) {
                JTextComponent.KeyBinding[] keyBindingArray = (JTextComponent.KeyBinding[])object;
                JTextComponent.loadKeymap(keymap, keyBindingArray, this.getComponent().getActions());
            }
        }
        return keymap;
    }

    protected void installKeyboardActions() {
        this.textComponent.setKeymap(this.createKeymap());
        SwingUtilities.replaceUIInputMap(this.textComponent, 0, this.getInputMap());
        SwingUtilities.replaceUIActionMap(this.textComponent, this.getActionMap());
    }

    private ActionMap getActionMap() {
        String string = this.getPropertyPrefix();
        String string2 = string + ".actionMap";
        ActionMap actionMap = (ActionMap)UIManager.get(string2);
        if (actionMap == null) {
            actionMap = this.createActionMap();
            UIManager.put(string2, actionMap);
        }
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.setParent(actionMap);
        return actionMapUIResource;
    }

    private ActionMap createActionMap() {
        Action action;
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        Action[] actionArray = this.textComponent.getActions();
        for (int i = actionArray.length - 1; i >= 0; --i) {
            action = actionArray[i];
            actionMapUIResource.put(action.getValue("Name"), action);
        }
        Action action2 = TransferHandler.getCopyAction();
        actionMapUIResource.put(action2.getValue("Name"), action2);
        action = TransferHandler.getCutAction();
        actionMapUIResource.put(action.getValue("Name"), action);
        Action action3 = TransferHandler.getPasteAction();
        actionMapUIResource.put(action3.getValue("Name"), action3);
        return actionMapUIResource;
    }

    private InputMap getInputMap() {
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        String string = this.getPropertyPrefix();
        InputMap inputMap = (InputMap)SharedUIDefaults.get(string + ".focusInputMap");
        if (inputMap != null) {
            inputMapUIResource.setParent(inputMap);
        }
        return inputMapUIResource;
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.rootView.setView(null);
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.textComponent = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.textComponent.removeFocusListener(this.focuslistener);
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.textComponent, 0, null);
        SwingUtilities.replaceUIActionMap(this.textComponent, null);
    }

    protected abstract String getPropertyPrefix();

    public Dimension getPreferredSize(JComponent jComponent) {
        View view = this.getRootView(this.textComponent);
        float f = view.getPreferredSpan(0);
        float f2 = view.getPreferredSpan(1);
        Insets insets = jComponent.getInsets();
        return new Dimension((int)f + insets.left + insets.right, (int)f2 + insets.top + insets.bottom);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        return new Dimension(insets.left + insets.right, insets.top + insets.bottom);
    }

    public final void paint(Graphics graphics, JComponent jComponent) {
        Document document;
        try {
            document = this.textComponent.getDocument();
            if (document instanceof AbstractDocument) {
                AbstractDocument abstractDocument = (AbstractDocument)document;
                abstractDocument.readLock();
            }
            this.paintSafely(graphics);
        }
        finally {
            document = null;
            Document document2 = this.textComponent.getDocument();
            if (document2 instanceof AbstractDocument) {
                AbstractDocument abstractDocument = (AbstractDocument)document2;
                abstractDocument.readUnlock();
            }
        }
    }

    protected void paintSafely(Graphics graphics) {
        Caret caret = this.textComponent.getCaret();
        Highlighter highlighter = this.textComponent.getHighlighter();
        if (this.textComponent.isOpaque()) {
            this.paintBackground(graphics);
        }
        if (highlighter != null) {
            Color color = graphics.getColor();
            highlighter.paint(graphics);
            graphics.setColor(color);
        }
        this.rootView.paint(graphics, this.getVisibleEditorRect());
        if (caret != null && this.textComponent.hasFocus()) {
            caret.paint(graphics);
        }
    }

    protected void paintBackground(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.textComponent.getBackground());
        graphics.fillRect(0, 0, this.textComponent.getWidth(), this.textComponent.getHeight());
        graphics.setColor(color);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    public void damageRange(JTextComponent jTextComponent, int n, int n2) {
        this.damageRange(jTextComponent, n, n2, Position.Bias.Forward, Position.Bias.Backward);
    }

    public void damageRange(JTextComponent jTextComponent, int n, int n2, Position.Bias bias, Position.Bias bias2) {
        Rectangle rectangle = this.getVisibleEditorRect();
        if (rectangle != null) {
            Document document = jTextComponent.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            try {
                Shape shape;
                try {
                    this.rootView.setSize(rectangle.width, rectangle.height);
                    shape = this.rootView.modelToView(n, bias, n2, bias2, rectangle);
                    Rectangle rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                    this.textComponent.repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                catch (BadLocationException badLocationException) {
                }
                shape = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
                throw throwable;
            }
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
    }

    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        return kit;
    }

    public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
        return this.rootView.getNextVisualPositionFrom(n, bias, this.getVisibleEditorRect(), n2, biasArray);
    }

    public View getRootView(JTextComponent jTextComponent) {
        return this.rootView;
    }

    public Rectangle modelToView(JTextComponent jTextComponent, int n) throws BadLocationException {
        return this.modelToView(jTextComponent, n, Position.Bias.Forward);
    }

    public Rectangle modelToView(JTextComponent jTextComponent, int n, Position.Bias bias) throws BadLocationException {
        Rectangle rectangle;
        Rectangle rectangle2;
        Document document;
        block5: {
            document = this.textComponent.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            rectangle2 = null;
            try {
                rectangle = this.getVisibleEditorRect();
                if (rectangle == null) break block5;
                this.rootView.setSize(rectangle.width, rectangle.height);
                Shape shape = this.rootView.modelToView(n, rectangle, bias);
                if (shape == null) break block5;
                rectangle2 = shape.getBounds();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
                throw throwable;
            }
        }
        rectangle = null;
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        rectangle = rectangle2;
        return rectangle;
    }

    public int viewToModel(JTextComponent jTextComponent, Point point) {
        return this.viewToModel(jTextComponent, point, null);
    }

    public int viewToModel(JTextComponent jTextComponent, Point point, Position.Bias[] biasArray) {
        return this.rootView.viewToModel(point.x, point.y, this.getVisibleEditorRect(), biasArray);
    }

    public View create(Element element) {
        return null;
    }

    public View create(Element element, int n, int n2) {
        return null;
    }

    protected Rectangle getVisibleEditorRect() {
        int n = this.textComponent.getWidth();
        int n2 = this.textComponent.getHeight();
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        Insets insets = this.textComponent.getInsets();
        return new Rectangle(insets.left, insets.top, n - insets.left - insets.right, n2 - insets.top - insets.bottom);
    }

    protected final void setView(View view) {
        this.rootView.setView(view);
        this.textComponent.revalidate();
        this.textComponent.repaint();
    }

    protected void modelChanged() {
        if (this.textComponent == null || this.rootView == null) {
            return;
        }
        ViewFactory viewFactory = this.rootView.getViewFactory();
        if (viewFactory == null) {
            return;
        }
        Document document = this.textComponent.getDocument();
        if (document == null) {
            return;
        }
        Element element = document.getDefaultRootElement();
        if (element == null) {
            return;
        }
        View view = viewFactory.create(element);
        this.setView(view);
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    class DocumentHandler
    implements DocumentListener {
        private /* synthetic */ BasicTextUI this$0;

        public void changedUpdate(DocumentEvent documentEvent) {
            this.this$0.rootView.changedUpdate(documentEvent, this.this$0.getVisibleEditorRect(), this.this$0.rootView.getViewFactory());
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.this$0.rootView.insertUpdate(documentEvent, this.this$0.getVisibleEditorRect(), this.this$0.rootView.getViewFactory());
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.this$0.rootView.removeUpdate(documentEvent, this.this$0.getVisibleEditorRect(), this.this$0.rootView.getViewFactory());
        }

        DocumentHandler(BasicTextUI basicTextUI) {
            this.this$0 = basicTextUI;
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicTextUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("document")) {
                Object object;
                Object object2 = propertyChangeEvent.getOldValue();
                if (object2 != null) {
                    object = (Document)object2;
                    object.removeDocumentListener(this.this$0.documentHandler);
                }
                if ((object = propertyChangeEvent.getNewValue()) != null) {
                    Document document = (Document)object;
                    document.addDocumentListener(this.this$0.documentHandler);
                }
                this.this$0.modelChanged();
            }
            this.this$0.propertyChange(propertyChangeEvent);
        }

        PropertyChangeHandler(BasicTextUI basicTextUI) {
            this.this$0 = basicTextUI;
        }
    }

    private class RootView
    extends View {
        private /* synthetic */ BasicTextUI this$0;
        private View view;

        public RootView(BasicTextUI basicTextUI) {
            this.this$0 = basicTextUI;
            super(null);
        }

        public ViewFactory getViewFactory() {
            ViewFactory viewFactory = null;
            EditorKit editorKit = this.this$0.getEditorKit(this.this$0.getComponent());
            viewFactory = editorKit.getViewFactory();
            if (viewFactory == null) {
                viewFactory = this.this$0;
            }
            return viewFactory;
        }

        public void preferenceChanged(View view, boolean bl, boolean bl2) {
            this.this$0.textComponent.revalidate();
        }

        public void setView(View view) {
            if (this.view != null) {
                this.view.setParent(null);
            }
            if (view != null) {
                view.setParent(this);
            }
            this.view = view;
        }

        public View getView(int n) {
            return this.view;
        }

        public int getViewCount() {
            int n = 0;
            if (this.view != null) {
                n = 1;
            }
            return n;
        }

        public Container getContainer() {
            return this.this$0.textComponent;
        }

        public float getPreferredSpan(int n) {
            if (this.view != null) {
                return this.view.getPreferredSpan(n);
            }
            return 2.1474836E9f;
        }

        public void paint(Graphics graphics, Shape shape) {
            if (this.view != null) {
                Rectangle rectangle = shape.getBounds();
                this.view.setSize(rectangle.width, rectangle.height);
                this.view.paint(graphics, shape);
            }
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            return this.view.modelToView(n, shape, bias);
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            return this.view.viewToModel(f, f2, shape, biasArray);
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.view.insertUpdate(documentEvent, shape, viewFactory);
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.view.removeUpdate(documentEvent, shape, viewFactory);
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.view.changedUpdate(documentEvent, shape, viewFactory);
        }

        public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
            return this.view.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return this.getDocument().getLength();
        }

        public Document getDocument() {
            return this.this$0.textComponent.getDocument();
        }
    }

    public static class BasicHighlighter
    extends DefaultHighlighter
    implements UIResource {
    }

    public static class BasicCaret
    extends DefaultCaret
    implements UIResource {
    }
}

