/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicScrollBarUI
extends ScrollBarUI
implements LayoutManager,
SwingConstants {
    protected ArrowButtonListener buttonListener;
    protected ModelListener modelListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ScrollListener scrollListener;
    protected TrackListener trackListener;
    protected JButton decrButton;
    protected JButton incrButton;
    protected Dimension maximumThumbSize;
    protected Dimension minimumThumbSize;
    protected Color thumbColor;
    protected Color thumbDarkShadowColor;
    protected Color thumbHighlightColor;
    protected Color thumbLightShadowColor;
    protected Color trackHighlightColor;
    protected Color trackColor;
    protected Rectangle trackRect;
    protected Rectangle thumbRect;
    protected static final int DECREASE_HIGHLIGHT = 1;
    protected static final int INCREASE_HIGHLIGHT = 2;
    protected static final int NO_HIGHLIGHT = 0;
    private static final int POSITIVE_SCROLL = 1;
    private static final int NEGATIVE_SCROLL = -1;
    private transient Dimension preferredSize;
    protected int trackHighlight;
    protected boolean isDragging;
    protected Timer scrollTimer;
    protected JScrollBar scrollbar;
    boolean thumbRollover;

    public void addLayoutComponent(String string, Component component) {
    }

    protected void configureScrollBarColors() {
        this.trackColor = UIManager.getColor("ScrollBar.track");
        this.trackHighlightColor = UIManager.getColor("ScrollBar.trackHighlight");
        this.thumbColor = UIManager.getColor("ScrollBar.thumb");
        this.thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
        this.thumbDarkShadowColor = UIManager.getColor("ScrollBar.thumbDarkShadow");
        this.thumbLightShadowColor = UIManager.getColor("ScrollBar.thumbShadow");
    }

    protected ArrowButtonListener createArrowButtonListener() {
        return new ArrowButtonListener(this);
    }

    protected JButton createIncreaseButton(int n) {
        return new BasicArrowButton(n);
    }

    protected JButton createDecreaseButton(int n) {
        return new BasicArrowButton(n);
    }

    protected ModelListener createModelListener() {
        return new ModelListener(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected ScrollListener createScrollListener() {
        return new ScrollListener(this);
    }

    protected TrackListener createTrackListener() {
        return new TrackListener(this);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicScrollBarUI();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected Dimension getMaximumThumbSize() {
        return this.maximumThumbSize;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected Dimension getMinimumThumbSize() {
        return this.minimumThumbSize;
    }

    void calculatePreferredSize() {
        int n = 0;
        int n2 = 0;
        if (this.scrollbar.getOrientation() == 0) {
            n = (int)((double)n + this.incrButton.getPreferredSize().getWidth());
            n = (int)((double)n + this.decrButton.getPreferredSize().getWidth());
            n += 16;
            n2 = UIManager.getInt("ScrollBar.width");
        } else {
            n2 = (int)((double)n2 + this.incrButton.getPreferredSize().getHeight());
            n2 = (int)((double)n2 + this.decrButton.getPreferredSize().getHeight());
            n2 += 16;
            n = UIManager.getInt("ScrollBar.width");
        }
        Insets insets = this.scrollbar.getInsets();
        this.preferredSize = new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        this.calculatePreferredSize();
        return this.preferredSize;
    }

    protected Rectangle getThumbBounds() {
        return this.thumbRect;
    }

    protected Rectangle getTrackBounds() {
        return this.trackRect;
    }

    protected void installComponents() {
        int n = this.scrollbar.getOrientation();
        if (n == 0) {
            this.incrButton = this.createIncreaseButton(3);
            this.decrButton = this.createDecreaseButton(7);
        } else {
            this.incrButton = this.createIncreaseButton(5);
            this.decrButton = this.createDecreaseButton(1);
        }
        if (this.incrButton != null) {
            this.scrollbar.add(this.incrButton);
        }
        if (this.decrButton != null) {
            this.scrollbar.add(this.decrButton);
        }
    }

    protected void installDefaults() {
        LookAndFeel.installColors(this.scrollbar, "ScrollBar.background", "ScrollBar.foreground");
        LookAndFeel.installBorder(this.scrollbar, "ScrollBar.border");
        this.scrollbar.setOpaque(true);
        this.scrollbar.setLayout(this);
        this.thumbColor = UIManager.getColor("ScrollBar.thumb");
        this.thumbDarkShadowColor = UIManager.getColor("ScrollBar.thumbDarkShadow");
        this.thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
        this.thumbLightShadowColor = UIManager.getColor("ScrollBar.thumbShadow");
        this.maximumThumbSize = UIManager.getDimension("ScrollBar.maximumThumbSize");
        this.minimumThumbSize = UIManager.getDimension("ScrollBar.minimumThumbSize");
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.scrollbar, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.scrollbar, actionMap);
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.scrollbar, null);
        SwingUtilities.replaceUIInputMap(this.scrollbar, 1, null);
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("ScrollBar.focusInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("ScrollBar.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.put("ScrollBar.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("positiveUnitIncrement", new AbstractAction(this, "positiveUnitIncrement"){
            private /* synthetic */ BasicScrollBarUI this$0;
            {
                this.this$0 = basicScrollBarUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar = (JScrollBar)actionEvent.getSource();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getUnitIncrement(1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("positiveBlockIncrement", new AbstractAction(this, "positiveBlockIncrement"){
            private /* synthetic */ BasicScrollBarUI this$0;
            {
                this.this$0 = basicScrollBarUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar = (JScrollBar)actionEvent.getSource();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getBlockIncrement(1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("negativeUnitIncrement", new AbstractAction(this, "negativeUnitIncrement"){
            private /* synthetic */ BasicScrollBarUI this$0;
            {
                this.this$0 = basicScrollBarUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar = (JScrollBar)actionEvent.getSource();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getUnitIncrement(-1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("negativeBlockIncrement", new AbstractAction(this, "negativeBlockIncrement"){
            private /* synthetic */ BasicScrollBarUI this$0;
            {
                this.this$0 = basicScrollBarUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar = (JScrollBar)actionEvent.getSource();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getBlockIncrement(-1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("minScroll", new AbstractAction(this, "minScroll"){
            private /* synthetic */ BasicScrollBarUI this$0;
            {
                this.this$0 = basicScrollBarUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar = (JScrollBar)actionEvent.getSource();
                if (jScrollBar.isVisible()) {
                    jScrollBar.setValue(jScrollBar.getMinimum());
                }
            }
        });
        actionMapUIResource.put("maxScroll", new AbstractAction(this, "maxScroll"){
            private /* synthetic */ BasicScrollBarUI this$0;
            {
                this.this$0 = basicScrollBarUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar = (JScrollBar)actionEvent.getSource();
                if (jScrollBar.isVisible()) {
                    jScrollBar.setValue(jScrollBar.getMaximum());
                }
            }
        });
        return actionMapUIResource;
    }

    protected void installListeners() {
        this.scrollListener = this.createScrollListener();
        this.trackListener = this.createTrackListener();
        this.buttonListener = this.createArrowButtonListener();
        this.modelListener = this.createModelListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.scrollbar.addMouseMotionListener(this.trackListener);
        this.scrollbar.addMouseListener(this.trackListener);
        this.incrButton.addMouseListener(this.buttonListener);
        this.decrButton.addMouseListener(this.buttonListener);
        this.scrollbar.addPropertyChangeListener(this.propertyChangeListener);
        this.scrollbar.getModel().addChangeListener(this.modelListener);
        this.scrollTimer.addActionListener(this.scrollListener);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JScrollBar) {
            this.scrollbar = (JScrollBar)jComponent;
            this.trackRect = new Rectangle();
            this.thumbRect = new Rectangle();
            this.scrollTimer = new Timer(300, null);
            this.installDefaults();
            this.installComponents();
            this.configureScrollBarColors();
            this.installListeners();
            this.installKeyboardActions();
            this.calculatePreferredSize();
        }
    }

    public void layoutContainer(Container container) {
        if (container instanceof JScrollBar) {
            if (this.scrollbar.getOrientation() == 0) {
                this.layoutHScrollbar((JScrollBar)container);
            } else {
                this.layoutVScrollbar((JScrollBar)container);
            }
        }
    }

    protected void layoutHScrollbar(JScrollBar jScrollBar) {
        Rectangle rectangle = new Rectangle();
        SwingUtilities.calculateInnerArea(this.scrollbar, rectangle);
        Dimension dimension = this.incrButton.getPreferredSize();
        Dimension dimension2 = this.decrButton.getPreferredSize();
        SwingUtilities.calculateInnerArea(this.scrollbar, this.trackRect);
        this.trackRect.width = (int)((double)this.trackRect.width - dimension.getWidth());
        this.trackRect.width = (int)((double)this.trackRect.width - dimension2.getWidth());
        this.trackRect.x = (int)((double)this.trackRect.x + dimension2.getWidth());
        this.updateThumbRect();
        this.decrButton.setBounds(rectangle.x, rectangle.y, dimension2.width, this.trackRect.height);
        this.incrButton.setBounds(this.trackRect.x + this.trackRect.width, rectangle.y, dimension.width, this.trackRect.height);
    }

    protected void layoutVScrollbar(JScrollBar jScrollBar) {
        Rectangle rectangle = new Rectangle();
        SwingUtilities.calculateInnerArea(this.scrollbar, rectangle);
        Dimension dimension = this.incrButton.getPreferredSize();
        Dimension dimension2 = this.decrButton.getPreferredSize();
        SwingUtilities.calculateInnerArea(this.scrollbar, this.trackRect);
        this.trackRect.height = (int)((double)this.trackRect.height - dimension.getHeight());
        this.trackRect.height = (int)((double)this.trackRect.height - dimension2.getHeight());
        this.trackRect.y = (int)((double)this.trackRect.y + dimension2.getHeight());
        this.updateThumbRect();
        this.decrButton.setBounds(rectangle.x, rectangle.y, this.trackRect.width, dimension2.height);
        this.incrButton.setBounds(rectangle.x, this.trackRect.y + this.trackRect.height, this.trackRect.width, dimension.height);
    }

    void updateThumbRect() {
        int n = this.scrollbar.getMaximum();
        int n2 = this.scrollbar.getMinimum();
        int n3 = this.scrollbar.getValue();
        int n4 = this.scrollbar.getVisibleAmount();
        if (n - n4 <= n2) {
            if (this.scrollbar.getOrientation() == 0) {
                this.thumbRect.x = this.trackRect.x;
                this.thumbRect.y = this.trackRect.y;
                this.thumbRect.width = this.getMinimumThumbSize().width;
                this.thumbRect.height = this.trackRect.height;
            } else {
                this.thumbRect.x = this.trackRect.x;
                this.thumbRect.y = this.trackRect.y;
                this.thumbRect.width = this.trackRect.width;
                this.thumbRect.height = this.getMinimumThumbSize().height;
            }
        } else if (this.scrollbar.getOrientation() == 0) {
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.width = Math.max(n4 * this.trackRect.width / (n - n2), this.getMinimumThumbSize().width);
            int n5 = this.trackRect.width - this.thumbRect.width;
            this.thumbRect.x += (n3 - n2) * n5 / (n - n2 - n4);
            this.thumbRect.y = this.trackRect.y;
            this.thumbRect.height = this.trackRect.height;
        } else {
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.height = Math.max(n4 * this.trackRect.height / (n - n2), this.getMinimumThumbSize().height);
            int n6 = this.trackRect.height - this.thumbRect.height;
            this.thumbRect.y = this.trackRect.y + (n3 - n2) * n6 / (n - n2 - n4);
            this.thumbRect.width = this.trackRect.width;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintTrack(graphics, jComponent, this.getTrackBounds());
        this.paintThumb(graphics, jComponent, this.getThumbBounds());
        if (this.trackHighlight == 2) {
            this.paintIncreaseHighlight(graphics);
        } else if (this.trackHighlight == 1) {
            this.paintDecreaseHighlight(graphics);
        }
    }

    protected void paintDecreaseHighlight(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.trackHighlightColor);
        if (this.scrollbar.getOrientation() == 0) {
            graphics.fillRect(this.trackRect.x, this.trackRect.y, this.thumbRect.x - this.trackRect.x, this.trackRect.height);
        } else {
            graphics.fillRect(this.trackRect.x, this.trackRect.y, this.trackRect.width, this.thumbRect.y - this.trackRect.y);
        }
        graphics.setColor(color);
    }

    protected void paintIncreaseHighlight(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.trackHighlightColor);
        if (this.scrollbar.getOrientation() == 0) {
            graphics.fillRect(this.thumbRect.x + this.thumbRect.width, this.trackRect.y, this.trackRect.x + this.trackRect.width - this.thumbRect.x - this.thumbRect.width, this.trackRect.height);
        } else {
            graphics.fillRect(this.trackRect.x, this.thumbRect.y + this.thumbRect.height, this.trackRect.width, this.trackRect.y + this.trackRect.height - this.thumbRect.y - this.thumbRect.height);
        }
        graphics.setColor(color);
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.setColor(this.thumbColor);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        BasicGraphicsUtils.drawBezel(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, false, false, this.thumbDarkShadowColor, this.thumbDarkShadowColor, this.thumbHighlightColor, this.thumbHighlightColor);
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this.trackColor);
        graphics.fill3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        graphics.setColor(color);
    }

    public Dimension preferredLayoutSize(Container container) {
        if (container instanceof JComponent) {
            return this.getPreferredSize((JComponent)container);
        }
        return null;
    }

    public void removeLayoutComponent(Component component) {
    }

    protected void scrollByBlock(int n) {
        this.scrollbar.setValue(this.scrollbar.getValue() + this.scrollbar.getBlockIncrement(n));
    }

    protected void scrollByUnit(int n) {
        this.scrollbar.setValue(this.scrollbar.getValue() + this.scrollbar.getUnitIncrement(n));
    }

    protected void setThumbBounds(int n, int n2, int n3, int n4) {
        this.thumbRect.x = n;
        this.thumbRect.y = n2;
        this.thumbRect.width = n3;
        this.thumbRect.height = n4;
    }

    protected void uninstallComponents() {
        if (this.incrButton != null) {
            this.scrollbar.remove(this.incrButton);
        }
        if (this.decrButton != null) {
            this.scrollbar.remove(this.decrButton);
        }
    }

    protected void uninstallDefaults() {
        this.scrollbar.setForeground(null);
        this.scrollbar.setBackground(null);
        LookAndFeel.uninstallBorder(this.scrollbar);
        this.incrButton = null;
        this.decrButton = null;
    }

    protected void uninstallListeners() {
        if (this.scrollTimer != null) {
            this.scrollTimer.removeActionListener(this.scrollListener);
        }
        if (this.scrollbar != null) {
            this.scrollbar.getModel().removeChangeListener(this.modelListener);
            this.scrollbar.removePropertyChangeListener(this.propertyChangeListener);
            this.scrollbar.removeMouseListener(this.trackListener);
            this.scrollbar.removeMouseMotionListener(this.trackListener);
        }
        if (this.decrButton != null) {
            this.decrButton.removeMouseListener(this.buttonListener);
        }
        if (this.incrButton != null) {
            this.incrButton.removeMouseListener(this.buttonListener);
        }
        this.propertyChangeListener = null;
        this.modelListener = null;
        this.buttonListener = null;
        this.trackListener = null;
        this.scrollListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.scrollTimer = null;
        this.thumbRect = null;
        this.trackRect = null;
        this.trackColor = null;
        this.trackHighlightColor = null;
        this.thumbColor = null;
        this.thumbHighlightColor = null;
        this.thumbDarkShadowColor = null;
        this.thumbLightShadowColor = null;
        this.scrollbar = null;
    }

    int valueForYPosition(int n) {
        int n2 = this.scrollbar.getMinimum();
        int n3 = this.scrollbar.getMaximum();
        int n4 = this.trackRect.height;
        if (n4 == 0) {
            return (n3 - n2) / 2;
        }
        int n5 = (n - this.trackRect.y) * (n3 - n2) / n4 + n2;
        if (n5 > n3) {
            n5 = n3;
        } else if (n5 < n2) {
            n5 = n2;
        }
        return n5;
    }

    int valueForXPosition(int n) {
        int n2 = this.scrollbar.getMinimum();
        int n3 = this.scrollbar.getMaximum();
        int n4 = this.trackRect.width;
        if (n4 == 0) {
            return (n3 - n2) / 2;
        }
        int n5 = (n - this.trackRect.x) * (n3 - n2) / n4 + n2;
        if (n5 > n3) {
            n5 = n3;
        } else if (n5 < n2) {
            n5 = n2;
        }
        return n5;
    }

    public boolean isThumbRollover() {
        return this.thumbRollover;
    }

    protected void setThumbRollover(boolean bl) {
        this.thumbRollover = bl;
    }

    public boolean getSupportsAbsolutePositioning() {
        return false;
    }

    protected class TrackListener
    extends MouseAdapter
    implements MouseMotionListener {
        private /* synthetic */ BasicScrollBarUI this$0;
        protected int currentMouseX;
        protected int currentMouseY;
        protected int offset;

        public void mouseDragged(MouseEvent mouseEvent) {
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (this.this$0.scrollbar.getValueIsAdjusting()) {
                int n = this.this$0.scrollbar.getOrientation() == 0 ? this.this$0.valueForXPosition(this.currentMouseX) - this.offset : this.this$0.valueForYPosition(this.currentMouseY) - this.offset;
                this.this$0.scrollbar.setValue(n);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.this$0.thumbRollover = this.this$0.thumbRect.contains(mouseEvent.getPoint());
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            int n = this.this$0.scrollbar.getOrientation() == 0 ? this.this$0.valueForXPosition(this.currentMouseX) : this.this$0.valueForYPosition(this.currentMouseY);
            if (!this.this$0.thumbRect.contains(mouseEvent.getPoint())) {
                this.this$0.scrollTimer.stop();
                this.this$0.scrollListener.setScrollByBlock(true);
                if (n > this.this$0.scrollbar.getValue()) {
                    this.this$0.trackHighlight = 2;
                    this.this$0.scrollListener.setDirection(1);
                } else {
                    this.this$0.trackHighlight = 1;
                    this.this$0.scrollListener.setDirection(-1);
                }
                this.this$0.scrollTimer.setDelay(100);
                this.this$0.scrollTimer.start();
            } else {
                this.this$0.scrollListener.setScrollByBlock(false);
                this.this$0.scrollbar.setValueIsAdjusting(true);
                this.offset = n - this.this$0.scrollbar.getValue();
            }
            this.this$0.scrollbar.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.this$0.scrollTimer.stop();
            this.this$0.scrollTimer.setDelay(300);
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (this.shouldScroll(1)) {
                this.this$0.scrollByBlock(1);
            } else if (this.shouldScroll(-1)) {
                this.this$0.scrollByBlock(-1);
            }
            this.this$0.trackHighlight = 0;
            this.this$0.scrollListener.setScrollByBlock(false);
            this.this$0.scrollbar.setValueIsAdjusting(true);
            this.this$0.scrollbar.repaint();
        }

        boolean shouldScroll(int n) {
            int n2 = this.this$0.scrollbar.getOrientation() == 0 ? this.this$0.valueForXPosition(this.currentMouseX) : this.this$0.valueForYPosition(this.currentMouseY);
            if (this.this$0.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                return false;
            }
            if (n == 1) {
                return n2 > this.this$0.scrollbar.getValue();
            }
            return n2 < this.this$0.scrollbar.getValue();
        }

        protected TrackListener(BasicScrollBarUI basicScrollBarUI) {
            this.this$0 = basicScrollBarUI;
        }
    }

    protected class ScrollListener
    implements ActionListener {
        private /* synthetic */ BasicScrollBarUI this$0;
        private transient int direction;
        private transient boolean block;

        public ScrollListener(BasicScrollBarUI basicScrollBarUI) {
            this.this$0 = basicScrollBarUI;
            this.direction = 1;
            this.block = true;
        }

        public ScrollListener(BasicScrollBarUI basicScrollBarUI, int n, boolean bl) {
            this.this$0 = basicScrollBarUI;
            this.direction = n;
            this.block = bl;
        }

        public void setDirection(int n) {
            this.direction = n;
        }

        public void setScrollByBlock(boolean bl) {
            this.block = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.block) {
                if (!this.this$0.trackListener.shouldScroll(this.direction)) {
                    this.this$0.trackHighlight = 0;
                    this.this$0.scrollbar.repaint();
                    return;
                }
                this.this$0.scrollByBlock(this.direction);
            } else {
                this.this$0.scrollByUnit(this.direction);
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicScrollBarUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("model")) {
                ((BoundedRangeModel)propertyChangeEvent.getOldValue()).removeChangeListener(this.this$0.modelListener);
                this.this$0.scrollbar.getModel().addChangeListener(this.this$0.modelListener);
                this.this$0.updateThumbRect();
            } else if (propertyChangeEvent.getPropertyName().equals("orientation")) {
                this.this$0.uninstallListeners();
                this.this$0.uninstallComponents();
                this.this$0.uninstallDefaults();
                this.this$0.installDefaults();
                this.this$0.installComponents();
                this.this$0.installListeners();
            } else if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                if (this.this$0.incrButton != null) {
                    this.this$0.incrButton.setEnabled(bl);
                }
                if (this.this$0.decrButton != null) {
                    this.this$0.decrButton.setEnabled(bl);
                }
            }
        }

        public PropertyChangeHandler(BasicScrollBarUI basicScrollBarUI) {
            this.this$0 = basicScrollBarUI;
        }
    }

    protected class ModelListener
    implements ChangeListener {
        private /* synthetic */ BasicScrollBarUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            this.this$0.calculatePreferredSize();
            this.this$0.updateThumbRect();
            this.this$0.scrollbar.repaint();
        }

        protected ModelListener(BasicScrollBarUI basicScrollBarUI) {
            this.this$0 = basicScrollBarUI;
        }
    }

    protected class ArrowButtonListener
    extends MouseAdapter {
        private /* synthetic */ BasicScrollBarUI this$0;

        public void mousePressed(MouseEvent mouseEvent) {
            this.this$0.scrollTimer.stop();
            this.this$0.scrollListener.setScrollByBlock(false);
            if (mouseEvent.getSource() == this.this$0.incrButton) {
                this.this$0.scrollListener.setDirection(1);
            } else if (mouseEvent.getSource() == this.this$0.decrButton) {
                this.this$0.scrollListener.setDirection(-1);
            }
            this.this$0.scrollTimer.setDelay(100);
            this.this$0.scrollTimer.start();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.this$0.scrollTimer.stop();
            this.this$0.scrollTimer.setDelay(300);
            if (mouseEvent.getSource() == this.this$0.incrButton) {
                this.this$0.scrollByUnit(1);
            } else if (mouseEvent.getSource() == this.this$0.decrButton) {
                this.this$0.scrollByUnit(-1);
            }
        }

        protected ArrowButtonListener(BasicScrollBarUI basicScrollBarUI) {
            this.this$0 = basicScrollBarUI;
        }
    }
}

