/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import gnu.classpath.NotImplementedException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class BasicMenuUI
extends BasicMenuItemUI {
    protected ChangeListener changeListener;
    protected MenuListener menuListener;
    protected PropertyChangeListener propertyChangeListener;

    public BasicMenuUI() {
        this.mouseInputListener = this.createMouseInputListener((JMenu)this.menuItem);
        this.menuListener = this.createMenuListener((JMenu)this.menuItem);
        this.propertyChangeListener = this.createPropertyChangeListener((JMenu)this.menuItem);
    }

    protected ChangeListener createChangeListener(JComponent jComponent) {
        return new ChangeHandler(this, (JMenu)jComponent, this);
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler(this);
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler(this);
    }

    protected MenuListener createMenuListener(JComponent jComponent) {
        return new MenuHandler(this);
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new BasicMenuItemUI.PropertyChangeHandler(this);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuUI();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return jComponent.getPreferredSize();
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.menuItem, "Menu.border");
        LookAndFeel.installColorsAndFont(this.menuItem, "Menu.background", "Menu.foreground", "Menu.font");
        this.menuItem.setMargin(UIManager.getInsets("Menu.margin"));
        this.acceleratorFont = UIManager.getFont("Menu.acceleratorFont");
        this.acceleratorForeground = UIManager.getColor("Menu.acceleratorForeground");
        this.acceleratorSelectionForeground = UIManager.getColor("Menu.acceleratorSelectionForeground");
        this.selectionBackground = UIManager.getColor("Menu.selectionBackground");
        this.selectionForeground = UIManager.getColor("Menu.selectionForeground");
        this.arrowIcon = UIManager.getIcon("Menu.arrowIcon");
        this.oldBorderPainted = UIManager.getBoolean("Menu.borderPainted");
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
    }

    protected void installListeners() {
        super.installListeners();
        ((JMenu)this.menuItem).addMenuListener(this.menuListener);
    }

    protected void setupPostTimer(JMenu jMenu) throws NotImplementedException {
    }

    protected void uninstallDefaults() {
        this.menuItem.setBackground(null);
        this.menuItem.setBorder(null);
        this.menuItem.setFont(null);
        this.menuItem.setForeground(null);
        this.menuItem.setMargin(null);
        this.acceleratorFont = null;
        this.acceleratorForeground = null;
        this.acceleratorSelectionForeground = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.arrowIcon = null;
    }

    protected void uninstallKeyboardActions() {
        super.installKeyboardActions();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private /* synthetic */ BasicMenuUI this$0;

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) throws NotImplementedException {
        }

        MenuKeyHandler(BasicMenuUI basicMenuUI) {
            this.this$0 = basicMenuUI;
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private /* synthetic */ BasicMenuUI this$0;

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.setSelectedPath(menuDragMouseEvent.getPath());
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.setSelectedPath(menuDragMouseEvent.getPath());
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        }

        MenuDragMouseHandler(BasicMenuUI basicMenuUI) {
            this.this$0 = basicMenuUI;
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        private /* synthetic */ BasicMenuUI this$0;
        public boolean isSelected;
        public JMenu menu;
        public BasicMenuUI ui;
        public Component wasFocused;

        public ChangeHandler(BasicMenuUI basicMenuUI, JMenu jMenu, BasicMenuUI basicMenuUI2) {
            this.this$0 = basicMenuUI;
            this.menu = jMenu;
            this.ui = basicMenuUI2;
        }

        public void stateChanged(ChangeEvent changeEvent) {
        }
    }

    private class MenuHandler
    implements MenuListener {
        private /* synthetic */ BasicMenuUI this$0;

        public void menuCanceled(MenuEvent menuEvent) {
            this.menuDeselected(menuEvent);
        }

        public void menuDeselected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)this.this$0.menuItem;
            if (jMenu.getParent() != null) {
                if (jMenu.isTopLevelMenu()) {
                    ((JMenuBar)jMenu.getParent()).getSelectionModel().clearSelection();
                } else {
                    ((JPopupMenu)jMenu.getParent()).getSelectionModel().clearSelection();
                }
            }
        }

        public void menuSelected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)this.this$0.menuItem;
            if (jMenu.isTopLevelMenu()) {
                ((JMenuBar)jMenu.getParent()).setSelected(jMenu);
            } else {
                ((JPopupMenu)jMenu.getParent()).setSelected(jMenu);
            }
        }

        MenuHandler(BasicMenuUI basicMenuUI) {
            this.this$0 = basicMenuUI;
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ BasicMenuUI this$0;

        public void mouseClicked(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        private boolean popupVisible() {
            JMenuBar jMenuBar = (JMenuBar)((JMenu)this.this$0.menuItem).getParent();
            if (!jMenuBar.isSelected()) {
                return false;
            }
            for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
                JMenu jMenu = jMenuBar.getMenu(i);
                if (jMenu == null || !jMenu.isPopupMenuVisible()) continue;
                return true;
            }
            return false;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)this.this$0.menuItem;
            if (!jMenu.isTopLevelMenu() || this.popupVisible()) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                menuSelectionManager.setSelectedPath(this.this$0.getPath());
                menuSelectionManager.processMouseEvent(mouseEvent);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            JMenu jMenu = (JMenu)this.this$0.menuItem;
            menuSelectionManager.processMouseEvent(mouseEvent);
            if (jMenu.isTopLevelMenu()) {
                if (jMenu.getPopupMenu().isVisible()) {
                    menuSelectionManager.clearSelectedPath();
                } else {
                    boolean bl = false;
                    int n = jMenu.getHeight();
                    menuSelectionManager.setSelectedPath(this.this$0.getPath());
                    JMenuBar jMenuBar = (JMenuBar)jMenu.getParent();
                    jMenuBar.getSelectionModel().setSelectedIndex(jMenuBar.getComponentIndex(jMenu));
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        protected MouseInputHandler(BasicMenuUI basicMenuUI) {
            this.this$0 = basicMenuUI;
        }
    }
}

