/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicButtonUI
extends ButtonUI {
    protected int defaultTextIconGap;
    protected int defaultTextShiftOffset;
    private int textShiftOffset;
    protected BasicButtonListener listener;

    private /* synthetic */ void finit$() {
        this.defaultTextIconGap = 4;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicButtonUI();
    }

    public int getDefaultTextIconGap(AbstractButton abstractButton) {
        return this.defaultTextIconGap;
    }

    protected void clearTextShiftOffset() {
        this.textShiftOffset = 0;
    }

    protected int getTextShiftOffset() {
        return this.textShiftOffset;
    }

    protected void setTextShiftOffset() {
        this.textShiftOffset = this.defaultTextShiftOffset;
    }

    protected String getPropertyPrefix() {
        return "Button.";
    }

    protected void installDefaults(AbstractButton abstractButton) {
        String string = this.getPropertyPrefix();
        LookAndFeel.installColorsAndFont(abstractButton, string + "background", string + "foreground", string + "font");
        LookAndFeel.installBorder(abstractButton, string + "border");
        if (abstractButton.getMargin() == null || abstractButton.getMargin() instanceof UIResource) {
            abstractButton.setMargin(UIManager.getInsets(string + "margin"));
        }
        abstractButton.setIconTextGap(UIManager.getInt(string + "textIconGap"));
        abstractButton.setInputMap(0, (InputMap)UIManager.get(string + "focusInputMap"));
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        if (abstractButton.getFont() instanceof UIResource) {
            abstractButton.setFont(null);
        }
        if (abstractButton.getForeground() instanceof UIResource) {
            abstractButton.setForeground(null);
        }
        if (abstractButton.getBackground() instanceof UIResource) {
            abstractButton.setBackground(null);
        }
        if (abstractButton.getBorder() instanceof UIResource) {
            abstractButton.setBorder(null);
        }
        abstractButton.setIconTextGap(this.defaultTextIconGap);
        if (abstractButton.getMargin() instanceof UIResource) {
            abstractButton.setMargin(null);
        }
    }

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new BasicButtonListener(abstractButton);
    }

    protected void installListeners(AbstractButton abstractButton) {
        this.listener = this.createButtonListener(abstractButton);
        abstractButton.addChangeListener(this.listener);
        abstractButton.addPropertyChangeListener(this.listener);
        abstractButton.addFocusListener(this.listener);
        abstractButton.addMouseListener(this.listener);
        abstractButton.addMouseMotionListener(this.listener);
    }

    protected void uninstallListeners(AbstractButton abstractButton) {
        abstractButton.removeChangeListener(this.listener);
        abstractButton.removePropertyChangeListener(this.listener);
        abstractButton.removeFocusListener(this.listener);
        abstractButton.removeMouseListener(this.listener);
        abstractButton.removeMouseMotionListener(this.listener);
    }

    protected void installKeyboardActions(AbstractButton abstractButton) {
        this.listener.installKeyboardActions(abstractButton);
    }

    protected void uninstallKeyboardActions(AbstractButton abstractButton) {
        this.listener.uninstallKeyboardActions(abstractButton);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            this.installDefaults(abstractButton);
            this.installListeners(abstractButton);
            this.installKeyboardActions(abstractButton);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Dimension dimension = BasicGraphicsUtils.getPreferredButtonSize(abstractButton, this.defaultTextIconGap + this.defaultTextShiftOffset);
        return dimension;
    }

    static Icon currentIcon(AbstractButton abstractButton) {
        Icon icon = abstractButton.getIcon();
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isPressed() && abstractButton.getPressedIcon() != null && abstractButton.isEnabled()) {
            icon = abstractButton.getPressedIcon();
        } else if (buttonModel.isRollover()) {
            if (abstractButton.isSelected() && abstractButton.getRolloverSelectedIcon() != null) {
                icon = abstractButton.getRolloverSelectedIcon();
            } else if (abstractButton.getRolloverIcon() != null) {
                icon = abstractButton.getRolloverIcon();
            }
        } else if (abstractButton.isSelected() && abstractButton.isEnabled()) {
            if (abstractButton.isEnabled() && abstractButton.getSelectedIcon() != null) {
                icon = abstractButton.getSelectedIcon();
            } else if (abstractButton.getDisabledSelectedIcon() != null) {
                icon = abstractButton.getDisabledSelectedIcon();
            }
        } else if (!abstractButton.isEnabled() && abstractButton.getDisabledIcon() != null) {
            icon = abstractButton.getDisabledIcon();
        }
        return icon;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        if (abstractButton.isBorderPainted()) {
            SwingUtilities.calculateInnerArea(abstractButton, rectangle3);
        } else {
            rectangle3 = SwingUtilities.getLocalBounds(abstractButton);
        }
        String string = SwingUtilities.layoutCompoundLabel(jComponent, graphics.getFontMetrics(font), abstractButton.getText(), BasicButtonUI.currentIcon(abstractButton), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle2, rectangle, abstractButton.getIconTextGap() + this.defaultTextShiftOffset);
        if (abstractButton.getModel().isArmed() && abstractButton.getModel().isPressed() || abstractButton.isSelected()) {
            this.paintButtonPressed(graphics, abstractButton);
        }
        this.paintIcon(graphics, jComponent, rectangle2);
        if (string != null) {
            this.paintText(graphics, abstractButton, rectangle, string);
        }
        if (abstractButton.isFocusOwner() && abstractButton.isFocusPainted()) {
            this.paintFocus(graphics, abstractButton, rectangle3, rectangle, rectangle2);
        }
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
    }

    protected void paintIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Icon icon = BasicButtonUI.currentIcon(abstractButton);
        if (icon != null) {
            icon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
        }
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.isContentAreaFilled() && abstractButton.isOpaque()) {
            Rectangle rectangle = new Rectangle();
            SwingUtilities.calculateInnerArea(abstractButton, rectangle);
            graphics.setColor(UIManager.getColor(this.getPropertyPrefix() + "shadow"));
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        this.paintText(graphics, (AbstractButton)jComponent, rectangle, string);
    }

    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        Font font = abstractButton.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        if (abstractButton.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
            BasicGraphicsUtils.drawString(abstractButton, graphics, string, -1, rectangle.x, rectangle.y + fontMetrics.getAscent());
        } else {
            String string2 = this.getPropertyPrefix();
            graphics.setColor(UIManager.getColor(string2 + "disabledText"));
            BasicGraphicsUtils.drawString(abstractButton, graphics, string, -1, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    public BasicButtonUI() {
        this.finit$();
    }
}

