/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.RootPaneUI;

public class JRootPane
extends JComponent
implements Accessible {
    private static final long serialVersionUID = 8690748000348575668L;
    public static final int NONE = 0;
    public static final int FRAME = 1;
    public static final int PLAIN_DIALOG = 2;
    public static final int INFORMATION_DIALOG = 3;
    public static final int ERROR_DIALOG = 4;
    public static final int COLOR_CHOOSER_DIALOG = 5;
    public static final int FILE_CHOOSER_DIALOG = 6;
    public static final int QUESTION_DIALOG = 7;
    public static final int WARNING_DIALOG = 8;
    protected Component glassPane;
    protected JLayeredPane layeredPane;
    protected JMenuBar menuBar;
    protected Container contentPane;
    protected JButton defaultButton;
    protected Action defaultPressAction;
    protected Action defaultReleaseAction;
    private int windowDecorationStyle;

    private /* synthetic */ void finit$() {
        this.windowDecorationStyle = 0;
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        JLayeredPane jLayeredPane = this.getLayeredPane();
        if (this.menuBar != null) {
            jLayeredPane.remove(this.menuBar);
        }
        this.menuBar = jMenuBar;
        if (this.menuBar != null) {
            jLayeredPane.add((Component)this.menuBar, JLayeredPane.FRAME_CONTENT_LAYER);
        }
    }

    public void setMenuBar(JMenuBar jMenuBar) {
        this.setJMenuBar(jMenuBar);
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public JMenuBar getMenuBar() {
        return this.getJMenuBar();
    }

    public boolean isValidateRoot() {
        return true;
    }

    public Container getContentPane() {
        if (this.contentPane == null) {
            this.setContentPane(this.createContentPane());
        }
        return this.contentPane;
    }

    public void setContentPane(Container container) {
        if (container == null) {
            throw new IllegalComponentStateException("cannot have a null content pane");
        }
        if (this.contentPane != null && this.contentPane.getParent() == this.layeredPane) {
            this.layeredPane.remove(this.contentPane);
        }
        this.contentPane = container;
        this.getLayeredPane().add((Component)this.contentPane, JLayeredPane.FRAME_CONTENT_LAYER);
    }

    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
    }

    public Component getGlassPane() {
        if (this.glassPane == null) {
            this.setGlassPane(this.createGlassPane());
        }
        return this.glassPane;
    }

    public void setGlassPane(Component component) {
        if (this.glassPane != null) {
            this.remove(this.glassPane);
        }
        this.glassPane = component;
        this.glassPane.setVisible(false);
        this.add(this.glassPane, 0);
    }

    public JLayeredPane getLayeredPane() {
        if (this.layeredPane == null) {
            this.setLayeredPane(this.createLayeredPane());
        }
        return this.layeredPane;
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        if (this.layeredPane != null) {
            this.remove(this.layeredPane);
        }
        this.layeredPane = jLayeredPane;
        this.add((Component)jLayeredPane, -1);
    }

    public JRootPane() {
        this.finit$();
        this.setLayout(this.createRootLayout());
        this.getGlassPane();
        this.getLayeredPane();
        this.getContentPane();
        this.setOpaque(true);
        this.updateUI();
    }

    protected LayoutManager createRootLayout() {
        return new RootLayout(this);
    }

    protected Container createContentPane() {
        JPanel jPanel = new JPanel();
        jPanel.setName(this.getName() + ".contentPane");
        jPanel.setLayout(new BorderLayout());
        return jPanel;
    }

    protected Component createGlassPane() {
        JPanel jPanel = new JPanel();
        jPanel.setName(this.getName() + ".glassPane");
        jPanel.setVisible(false);
        jPanel.setOpaque(false);
        return jPanel;
    }

    protected JLayeredPane createLayeredPane() {
        JLayeredPane jLayeredPane = new JLayeredPane();
        jLayeredPane.setLayout(null);
        return jLayeredPane;
    }

    public RootPaneUI getUI() {
        return (RootPaneUI)this.ui;
    }

    public void setUI(RootPaneUI rootPaneUI) {
        super.setUI(rootPaneUI);
    }

    public void updateUI() {
        this.setUI((RootPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "RootPaneUI";
    }

    public JButton getDefaultButton() {
        return this.defaultButton;
    }

    public void setDefaultButton(JButton jButton) {
        if (this.defaultButton != jButton && (jButton == null || jButton.isDefaultCapable())) {
            JButton jButton2 = this.defaultButton;
            this.defaultButton = jButton;
            this.firePropertyChange("defaultButton", jButton2, jButton);
        }
    }

    public int getWindowDecorationStyle() {
        return this.windowDecorationStyle;
    }

    public void setWindowDecorationStyle(int n) {
        if (n != 0 && n != 1 && n != 3 && n != 4 && n != 5 && n != 6 && n != 7 && n != 8 && n != 2) {
            throw new IllegalArgumentException("invalid style");
        }
        int n2 = this.windowDecorationStyle;
        this.windowDecorationStyle = n;
        this.firePropertyChange("windowDecorationStyle", n2, n);
    }

    public boolean isOptimizedDrawingEnable() {
        return this.glassPane.isVisible() ^ true;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJRootPane(this);
        }
        return this.accessibleContext;
    }

    protected class RootLayout
    implements LayoutManager2,
    Serializable {
        private /* synthetic */ JRootPane this$0;
        private static final long serialVersionUID = -4100116998559815027L;
        private Rectangle glassPaneBounds;
        private Rectangle layeredPaneBounds;
        private Rectangle contentPaneBounds;
        private Rectangle menuBarBounds;

        protected RootLayout(JRootPane jRootPane) {
            this.this$0 = jRootPane;
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
            RootLayout rootLayout = this;
            synchronized (rootLayout) {
                try {
                    this.glassPaneBounds = null;
                    this.layeredPaneBounds = null;
                    this.contentPaneBounds = null;
                    this.menuBarBounds = null;
                }
                finally {
                    Object var3_3 = null;
                }
                return;
            }
        }

        public void layoutContainer(Container container) {
            if (this.glassPaneBounds == null || this.layeredPaneBounds == null || this.contentPaneBounds == null || this.menuBarBounds == null) {
                Insets insets = this.this$0.getInsets();
                int n = container.getBounds().width - insets.left - insets.right;
                int n2 = container.getBounds().height - insets.top - insets.bottom;
                if (this.this$0.menuBar != null) {
                    Dimension dimension = this.this$0.menuBar.getPreferredSize();
                    if (dimension.height > n2) {
                        dimension.height = n2;
                    }
                    this.menuBarBounds = new Rectangle(0, 0, n, dimension.height);
                    this.contentPaneBounds = new Rectangle(0, dimension.height, n, n2 - dimension.height);
                } else {
                    this.contentPaneBounds = new Rectangle(0, 0, n, n2);
                }
                this.glassPaneBounds = new Rectangle(insets.left, insets.top, n, n2);
                this.layeredPaneBounds = new Rectangle(insets.left, insets.top, n, n2);
            }
            this.this$0.glassPane.setBounds(this.glassPaneBounds);
            this.this$0.layeredPane.setBounds(this.layeredPaneBounds);
            if (this.this$0.menuBar != null) {
                this.this$0.menuBar.setBounds(this.menuBarBounds);
            }
            this.this$0.getContentPane().setBounds(this.contentPaneBounds);
        }

        public Dimension maximumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            Insets insets = this.this$0.getInsets();
            dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
            Dimension dimension2 = this.this$0.getContentPane().getPreferredSize();
            dimension.width += dimension2.width;
            dimension.height += dimension2.height;
            if (this.this$0.menuBar != null) {
                Dimension dimension3 = this.this$0.menuBar.getPreferredSize();
                if (dimension3.width > dimension2.width) {
                    dimension.width += dimension3.width - dimension2.width;
                }
                dimension.height += dimension3.height;
            }
            return dimension;
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    protected class AccessibleJRootPane
    extends JComponent.AccessibleJComponent {
        private /* synthetic */ JRootPane this$0;
        private static final long serialVersionUID = 1082432482784468088L;

        protected AccessibleJRootPane(JRootPane jRootPane) {
            this.this$0 = jRootPane;
            super(jRootPane);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ROOT_PANE;
        }
    }
}

