/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ListUI;
import javax.swing.text.Position;

public class JList
extends JComponent
implements Accessible,
Scrollable {
    private static final long serialVersionUID = 4406629526391098046L;
    public static final int VERTICAL = 0;
    public static final int VERTICAL_WRAP = 1;
    public static final int HORIZONTAL_WRAP = 2;
    boolean dragEnabled;
    ListCellRenderer cellRenderer;
    int fixedCellWidth;
    int fixedCellHeight;
    int layoutOrientation;
    ListModel model;
    Object prototypeCellValue;
    Color selectionBackground;
    Color selectionForeground;
    ListSelectionModel selectionModel;
    int visibleRowCount;
    ListListener listListener;

    protected void fireSelectionValueChanged(int n, int n2, boolean bl) {
        ListSelectionEvent listSelectionEvent = new ListSelectionEvent(this, n, n2, bl);
        ListSelectionListener[] listSelectionListenerArray = this.getListSelectionListeners();
        for (int i = 0; i < listSelectionListenerArray.length; ++i) {
            listSelectionListenerArray[i].valueChanged(listSelectionEvent);
        }
    }

    public JList() {
        this.init(new DefaultListModel());
    }

    public JList(Object[] objectArray) {
        this.init(this.createListModel(objectArray));
    }

    public JList(Vector vector) {
        this.init(this.createListModel(vector));
    }

    public JList(ListModel listModel) {
        this.init(listModel);
    }

    private void init(ListModel listModel) {
        if (listModel == null) {
            throw new IllegalArgumentException("Null model not permitted.");
        }
        this.dragEnabled = false;
        this.fixedCellHeight = -1;
        this.fixedCellWidth = -1;
        this.layoutOrientation = 0;
        this.opaque = true;
        this.visibleRowCount = 8;
        this.cellRenderer = new DefaultListCellRenderer();
        this.listListener = new ListListener(this);
        this.model = listModel;
        if (this.model != null) {
            this.model.addListDataListener(this.listListener);
        }
        this.selectionModel = this.createSelectionModel();
        if (this.selectionModel != null) {
            this.selectionModel.addListSelectionListener(this.listListener);
            this.selectionModel.setSelectionMode(2);
        }
        this.setLayout(null);
        this.updateUI();
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    public int getFixedCellHeight() {
        return this.fixedCellHeight;
    }

    public void setFixedCellHeight(int n) {
        if (this.fixedCellHeight == n) {
            return;
        }
        int n2 = this.fixedCellHeight;
        this.fixedCellHeight = n;
        this.firePropertyChange("fixedCellHeight", n2, n);
    }

    public int getFixedCellWidth() {
        return this.fixedCellWidth;
    }

    public void setFixedCellWidth(int n) {
        if (this.fixedCellWidth == n) {
            return;
        }
        int n2 = this.fixedCellWidth;
        this.fixedCellWidth = n;
        this.firePropertyChange("fixedCellWidth", n2, n);
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int n) {
        if (this.visibleRowCount != n) {
            int n2 = this.visibleRowCount;
            this.visibleRowCount = Math.max(n, 0);
            this.firePropertyChange("visibleRowCount", n2, n);
            this.revalidate();
            this.repaint();
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.add(JList.class$("javax.swing.event.ListSelectionListener"), listSelectionListener);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(JList.class$("javax.swing.event.ListSelectionListener"), listSelectionListener);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return (ListSelectionListener[])this.getListeners(JList.class$("javax.swing.event.ListSelectionListener"));
    }

    public int getSelectionMode() {
        return this.selectionModel.getSelectionMode();
    }

    public void setSelectionMode(int n) {
        this.selectionModel.setSelectionMode(n);
    }

    public void setSelectedIndex(int n) {
        if (n < 0) {
            this.selectionModel.clearSelection();
        } else {
            this.selectionModel.setSelectionInterval(n, n);
        }
    }

    public void setSelectedIndices(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.setSelectedIndex(nArray[i]);
        }
    }

    public int getSelectedIndex() {
        return this.selectionModel.getMinSelectionIndex();
    }

    public boolean isSelectionEmpty() {
        return this.selectionModel.isSelectionEmpty();
    }

    public int getFirstVisibleIndex() {
        ComponentOrientation componentOrientation = this.getComponentOrientation();
        Rectangle rectangle = this.getVisibleRect();
        if (componentOrientation == ComponentOrientation.RIGHT_TO_LEFT) {
            rectangle.translate((int)rectangle.getWidth() - 1, 0);
        }
        return this.getUI().locationToIndex(this, rectangle.getLocation());
    }

    public int locationToIndex(Point point) {
        return this.getUI().locationToIndex(this, point);
    }

    public Point indexToLocation(int n) {
        return this.getUI().indexToLocation(this, n);
    }

    public int getLastVisibleIndex() {
        ComponentOrientation componentOrientation = this.getComponentOrientation();
        Rectangle rectangle = this.getVisibleRect();
        rectangle.translate(0, (int)rectangle.getHeight() - 1);
        if (componentOrientation == ComponentOrientation.LEFT_TO_RIGHT) {
            rectangle.translate((int)rectangle.getWidth() - 1, 0);
        }
        if (this.getUI().locationToIndex(this, rectangle.getLocation()) == -1 && this.indexToLocation((int)(this.getModel().getSize() - 1)).y < rectangle.y) {
            return this.getModel().getSize() - 1;
        }
        return this.getUI().locationToIndex(this, rectangle.getLocation());
    }

    public int[] getSelectedIndices() {
        int n;
        if (this.selectionModel.isSelectionEmpty()) {
            return new int[0];
        }
        int n2 = this.selectionModel.getMinSelectionIndex();
        int n3 = this.selectionModel.getMaxSelectionIndex();
        int n4 = 0;
        for (n = n2; n <= n3; ++n) {
            if (!this.selectionModel.isSelectedIndex(n)) continue;
            ++n4;
        }
        int[] nArray = new int[n4];
        int n5 = 0;
        for (n = n2; n <= n3; ++n) {
            if (!this.selectionModel.isSelectedIndex(n)) continue;
            nArray[n5++] = n;
        }
        return nArray;
    }

    public boolean isSelectedIndex(int n) {
        return this.selectionModel.isSelectedIndex(n);
    }

    public Object getSelectedValue() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return this.getModel().getElementAt(n);
    }

    public Object[] getSelectedValues() {
        int[] nArray = this.getSelectedIndices();
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = this.getModel().getElementAt(nArray[i]);
        }
        return objectArray;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color color) {
        if (this.selectionBackground == color) {
            return;
        }
        Color color2 = this.selectionBackground;
        this.selectionBackground = color;
        this.firePropertyChange("selectionBackground", color2, color);
        this.repaint();
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color color) {
        if (this.selectionForeground == color) {
            return;
        }
        Color color2 = this.selectionForeground;
        this.selectionForeground = color;
        this.firePropertyChange("selectionForeground", color2, color);
    }

    public void setSelectedValue(Object object, boolean bl) {
        for (int i = 0; i < this.model.getSize(); ++i) {
            if (!this.model.getElementAt(i).equals(object)) continue;
            this.setSelectedIndex(i);
            if (!bl) break;
            this.ensureIndexIsVisible(i);
            break;
        }
    }

    public void ensureIndexIsVisible(int n) {
        Rectangle rectangle = this.getUI().getCellBounds(this, n, n);
        if (rectangle != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public void setListData(Object[] objectArray) {
        this.setModel(this.createListModel(objectArray));
    }

    private ListModel createListModel(Object[] objectArray) {
        return new AbstractListModel(this, objectArray){
            private /* synthetic */ JList this$0;
            private /* synthetic */ Object[] val$items;
            {
                this.this$0 = jList;
                this.finit$(objectArray);
            }

            private /* synthetic */ void finit$(Object[] objectArray) {
                this.val$items = objectArray;
            }

            public int getSize() {
                return this.val$items.length;
            }

            public Object getElementAt(int n) {
                return this.val$items[n];
            }
        };
    }

    private ListModel createListModel(Vector vector) {
        return new AbstractListModel(this, vector){
            private /* synthetic */ JList this$0;
            private /* synthetic */ Vector val$items;
            {
                this.this$0 = jList;
                this.finit$(vector);
            }

            private /* synthetic */ void finit$(Vector vector) {
                this.val$items = vector;
            }

            public int getSize() {
                return this.val$items.size();
            }

            public Object getElementAt(int n) {
                return this.val$items.get(n);
            }
        };
    }

    public void setListData(Vector vector) {
        this.setModel(this.createListModel(vector));
    }

    public ListCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        if (this.cellRenderer == listCellRenderer) {
            return;
        }
        ListCellRenderer listCellRenderer2 = this.cellRenderer;
        this.cellRenderer = listCellRenderer;
        this.firePropertyChange("cellRenderer", listCellRenderer2, listCellRenderer);
        this.revalidate();
        this.repaint();
    }

    public ListModel getModel() {
        return this.model;
    }

    public void setModel(ListModel listModel) {
        if (listModel == null) {
            throw new IllegalArgumentException("Null 'model' argument.");
        }
        if (this.model == listModel) {
            return;
        }
        if (this.model != null) {
            this.model.removeListDataListener(this.listListener);
        }
        ListModel listModel2 = this.model;
        this.model = listModel;
        if (this.model != null) {
            this.model.addListDataListener(this.listListener);
        }
        this.firePropertyChange("model", listModel2, listModel);
        this.revalidate();
        this.repaint();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (this.selectionModel == listSelectionModel) {
            return;
        }
        if (this.selectionModel != null) {
            this.selectionModel.removeListSelectionListener(this.listListener);
        }
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        this.selectionModel = listSelectionModel;
        if (this.selectionModel != null) {
            this.selectionModel.addListSelectionListener(this.listListener);
        }
        this.firePropertyChange("selectionModel", listSelectionModel2, listSelectionModel);
        this.revalidate();
        this.repaint();
    }

    public ListUI getUI() {
        return (ListUI)this.ui;
    }

    public void setUI(ListUI listUI) {
        super.setUI(listUI);
    }

    public void updateUI() {
        this.setUI((ListUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "ListUI";
    }

    public Object getPrototypeCellValue() {
        return this.prototypeCellValue;
    }

    public void setPrototypeCellValue(Object object) {
        if (this.prototypeCellValue == object) {
            return;
        }
        Object object2 = this.prototypeCellValue;
        Component component = this.getCellRenderer().getListCellRendererComponent(this, object, 0, false, false);
        Dimension dimension = component.getPreferredSize();
        this.fixedCellWidth = dimension.width;
        this.fixedCellHeight = dimension.height;
        this.prototypeCellValue = object;
        this.firePropertyChange("prototypeCellValue", object2, object);
    }

    public AccessibleContext getAccessibleContext() {
        return new AccessibleJList(this);
    }

    public Dimension getPreferredScrollableViewportSize() {
        if (this.getLayoutOrientation() != 0) {
            return this.getPreferredSize();
        }
        int n = this.getModel().getSize();
        if (this.fixedCellHeight != -1 && this.fixedCellWidth != -1) {
            return new Dimension(this.fixedCellWidth, n * this.fixedCellHeight);
        }
        if (n == 0) {
            if (this.fixedCellWidth == -1) {
                return new Dimension(256, 16 * this.getVisibleRowCount());
            }
            return new Dimension(this.fixedCellWidth, 16 * this.getVisibleRowCount());
        }
        int n2 = this.fixedCellWidth != -1 ? this.fixedCellWidth : this.getPreferredSize().width;
        int n3 = this.fixedCellHeight != -1 ? this.fixedCellHeight : this.getVisibleRowCount() * this.getCellBounds((int)0, (int)0).height;
        return new Dimension(n2, n3);
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        ListUI listUI = this.getUI();
        if (n == 1) {
            if (n2 > 0) {
                Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
                int n3 = listUI.locationToIndex(this, point);
                Rectangle rectangle2 = listUI.getCellBounds(this, n3, n3);
                if (rectangle2.y + rectangle2.height == point.y) {
                    if (n3 + 1 < this.model.getSize()) {
                        Rectangle rectangle3 = listUI.getCellBounds(this, n3 + 1, n3 + 1);
                        return rectangle3.height;
                    }
                    return 0;
                }
                return rectangle2.y + rectangle2.height - point.y;
            }
            Point point = new Point(rectangle.x, rectangle.y);
            int n4 = listUI.locationToIndex(this, point);
            Rectangle rectangle4 = listUI.getCellBounds(this, n4, n4);
            if (rectangle4.y == point.y) {
                if (n4 > 0) {
                    Rectangle rectangle5 = listUI.getCellBounds(this, n4 - 1, n4 - 1);
                    return -rectangle5.height;
                }
                return 0;
            }
            return rectangle4.y - point.y;
        }
        return 1;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.height * n2;
        }
        return rectangle.width * n2;
    }

    public boolean getScrollableTracksViewportWidth() {
        Container container = this.getParent();
        boolean bl = false;
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            Dimension dimension = this.getPreferredSize();
            if (jViewport.getSize().width > dimension.width) {
                bl = true;
            }
            if (this.getLayoutOrientation() == 2 && this.getVisibleRowCount() <= 0) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean getScrollableTracksViewportHeight() {
        Container container = this.getParent();
        boolean bl = false;
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            Dimension dimension = this.getPreferredSize();
            if (jViewport.getSize().height > dimension.height) {
                bl = true;
            }
            if (this.getLayoutOrientation() == 1 && this.getVisibleRowCount() <= 0) {
                bl = true;
            }
        }
        return bl;
    }

    public int getAnchorSelectionIndex() {
        return this.selectionModel.getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.selectionModel.getLeadSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.selectionModel.getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.selectionModel.getMaxSelectionIndex();
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
    }

    public void setSelectionInterval(int n, int n2) {
        this.selectionModel.setSelectionInterval(n, n2);
    }

    public void addSelectionInterval(int n, int n2) {
        this.selectionModel.addSelectionInterval(n, n2);
    }

    public void removeSelectionInterval(int n, int n2) {
        this.selectionModel.removeSelectionInterval(n, n2);
    }

    public boolean getValueIsAdjusting() {
        return this.selectionModel.getValueIsAdjusting();
    }

    public void setValueIsAdjusting(boolean bl) {
        this.selectionModel.setValueIsAdjusting(bl);
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    public int getLayoutOrientation() {
        return this.layoutOrientation;
    }

    public void setLayoutOrientation(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException();
        }
        if (this.layoutOrientation == n) {
            return;
        }
        int n2 = this.layoutOrientation;
        this.layoutOrientation = n;
        this.firePropertyChange("layoutOrientation", n2, n);
    }

    public Rectangle getCellBounds(int n, int n2) {
        ListUI listUI = this.getUI();
        Rectangle rectangle = null;
        if (listUI != null) {
            rectangle = listUI.getCellBounds(this, n, n2);
        }
        return rectangle;
    }

    public int getNextMatch(String string, int n, Position.Bias bias) {
        if (string == null) {
            throw new IllegalArgumentException("The argument 'prefix' must not be null.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("The argument 'startIndex' must not be less than zero.");
        }
        int n2 = this.model.getSize();
        if (n >= this.model.getSize()) {
            throw new IllegalArgumentException("The argument 'startIndex' must not be greater than the number of elements in the ListModel.");
        }
        int n3 = -1;
        int n4 = n;
        int n5 = -1;
        int n6 = this.model.getSize();
        boolean bl = false;
        string = string.toUpperCase();
        if (bias == Position.Bias.Forward) {
            n5 = 1;
        }
        while (!bl) {
            String string2 = this.model.getElementAt(n4).toString().toUpperCase();
            if (string2.startsWith(string)) {
                return n4;
            }
            n4 = (n4 += n5) == -1 ? (n4 += n6) : (n4 %= n6);
            bl = n4 == n;
        }
        return n3;
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer(super.paramString());
        stringBuffer.append(",fixedCellHeight=").append(this.getFixedCellHeight());
        stringBuffer.append(",fixedCellWidth=").append(this.getFixedCellWidth());
        stringBuffer.append(",selectionBackground=");
        if (this.getSelectionBackground() != null) {
            stringBuffer.append(this.getSelectionBackground());
        }
        stringBuffer.append(",selectionForeground=");
        if (this.getSelectionForeground() != null) {
            stringBuffer.append(this.getSelectionForeground());
        }
        stringBuffer.append(",visibleRowCount=").append(this.getVisibleRowCount());
        stringBuffer.append(",layoutOrientation=").append(this.getLayoutOrientation());
        return stringBuffer.toString();
    }

    private class ListListener
    implements ListSelectionListener,
    ListDataListener {
        private /* synthetic */ JList this$0;

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.this$0.revalidate();
            this.this$0.repaint();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.this$0.revalidate();
            this.this$0.repaint();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.this$0.revalidate();
            this.this$0.repaint();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.this$0.fireSelectionValueChanged(listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex(), listSelectionEvent.getValueIsAdjusting());
            this.this$0.repaint();
        }

        ListListener(JList jList) {
            this.this$0 = jList;
        }
    }

    protected class AccessibleJList
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    PropertyChangeListener,
    ListSelectionListener,
    ListDataListener {
        private /* synthetic */ JList this$0;

        public AccessibleJList(JList jList) {
            this.this$0 = jList;
            super(jList);
        }

        public int getAccessibleSelectionCount() {
            return this.this$0.getSelectedIndices().length;
        }

        public Accessible getAccessibleSelection(int n) {
            return new AccessibleJListChild(this, this.this$0, this.this$0.getSelectedIndices()[n]);
        }

        public boolean isAccessibleChildSelected(int n) {
            return this.this$0.isSelectedIndex(n);
        }

        public void addAccessibleSelection(int n) {
            this.this$0.addSelectionInterval(n, n);
        }

        public void removeAccessibleSelection(int n) {
            this.this$0.removeSelectionInterval(n, n);
        }

        public void clearAccessibleSelection() {
            this.this$0.clearSelection();
        }

        public void selectAllAccessibleSelection() {
            this.this$0.addSelectionInterval(0, this.this$0.getModel().getSize());
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
            this.firePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                ListModel listModel = (ListModel)propertyChangeEvent.getOldValue();
                listModel.removeListDataListener(this);
                ListModel listModel2 = (ListModel)propertyChangeEvent.getNewValue();
                listModel2.addListDataListener(this);
            } else if (string.equals("selectionModel")) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)propertyChangeEvent.getOldValue();
                listSelectionModel.removeListSelectionListener(this);
                ListSelectionModel listSelectionModel2 = (ListSelectionModel)propertyChangeEvent.getNewValue();
                listSelectionModel.addListSelectionListener(this);
            }
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (this.this$0.getSelectionMode() != 0) {
                accessibleStateSet.add(AccessibleState.MULTISELECTABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public Accessible getAccessibleAt(Point point) {
            int n = this.this$0.locationToIndex(point);
            return this.getAccessibleChild(n);
        }

        public int getAccessibleChildrenCount() {
            return this.this$0.getModel().getSize();
        }

        public Accessible getAccessibleChild(int n) {
            if (this.this$0.getModel().getSize() <= n) {
                return null;
            }
            return new AccessibleJListChild(this, this.this$0, n);
        }

        protected class AccessibleJListChild
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private /* synthetic */ AccessibleJList this$1;
            JList parent;
            int listIndex;
            Cursor cursor;

            private /* synthetic */ void finit$() {
                this.cursor = Cursor.getDefaultCursor();
            }

            public AccessibleJListChild(AccessibleJList accessibleJList, JList jList, int n) {
                this.this$1 = accessibleJList;
                this.finit$();
                this.parent = jList;
                this.listIndex = n;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public Color getBackground() {
                return this.parent.getBackground();
            }

            public void setBackground(Color color) {
            }

            public Color getForeground() {
                return this.parent.getForeground();
            }

            public void setForeground(Color color) {
            }

            public Cursor getCursor() {
                return this.cursor;
            }

            public void setCursor(Cursor cursor) {
                this.cursor = cursor;
            }

            public Font getFont() {
                return this.parent.getFont();
            }

            public void setFont(Font font) {
            }

            public FontMetrics getFontMetrics(Font font) {
                return this.parent.getFontMetrics(font);
            }

            public boolean isEnabled() {
                return this.parent.isEnabled();
            }

            public void setEnabled(boolean bl) {
            }

            public boolean isVisible() {
                return this.listIndex >= this.parent.getFirstVisibleIndex() && this.listIndex <= this.parent.getLastVisibleIndex();
            }

            public void setVisible(boolean bl) {
            }

            public boolean isShowing() {
                return this.isVisible() && this.parent.isShowing();
            }

            public boolean contains(Point point) {
                return this.getBounds().contains(point);
            }

            public Point getLocationOnScreen() {
                Point point = this.getLocation();
                SwingUtilities.convertPointToScreen(point, this.parent);
                return point;
            }

            public Point getLocation() {
                return this.parent.indexToLocation(this.listIndex);
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                return this.parent.getCellBounds(this.listIndex, this.listIndex);
            }

            public void setBounds(Rectangle rectangle) {
            }

            public Dimension getSize() {
                Rectangle rectangle = this.getBounds();
                return rectangle.getSize();
            }

            public void setSize(Dimension dimension) {
            }

            public Accessible getAccessibleAt(Point point) {
                return null;
            }

            public boolean isFocusTraversable() {
                return true;
            }

            public void requestFocus() {
                this.parent.requestFocus();
            }

            public void addFocusListener(FocusListener focusListener) {
                this.parent.addFocusListener(focusListener);
            }

            public void removeFocusListener(FocusListener focusListener) {
                this.parent.removeFocusListener(focusListener);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LABEL;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
                if (this.isVisible()) {
                    accessibleStateSet.add(AccessibleState.VISIBLE);
                }
                if (this.isShowing()) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                }
                if (this.isFocusTraversable()) {
                    accessibleStateSet.add(AccessibleState.FOCUSABLE);
                }
                if (this.parent.isEnabled()) {
                    accessibleStateSet.add(AccessibleState.SELECTABLE);
                }
                if (this.parent.isSelectedIndex(this.listIndex)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
                return accessibleStateSet;
            }

            public int getAccessibleIndexInParent() {
                return this.listIndex;
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public Accessible getAccessibleChild(int n) {
                return null;
            }

            public Locale getLocale() {
                return this.parent.getLocale();
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }
        }
    }
}

