/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CompatibilityFocusTraversalPolicy;
import javax.swing.ComponentInputMap;
import javax.swing.DebugGraphics;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.ComponentUI;

public abstract class JComponent
extends Container
implements Serializable {
    private static final long serialVersionUID = -7908749299918704233L;
    protected AccessibleContext accessibleContext;
    Dimension preferredSize;
    Dimension minimumSize;
    Dimension maximumSize;
    float alignmentX;
    float alignmentY;
    Border border;
    String toolTipText;
    JPopupMenu componentPopupMenu;
    boolean inheritsPopupMenu;
    boolean doubleBuffered;
    int debugGraphicsOptions;
    boolean opaque;
    protected ComponentUI ui;
    boolean requestFocusEnabled;
    boolean autoscrolls;
    static boolean paintingDoubleBuffered = false;
    private static boolean isRepainting = false;
    protected EventListenerList listenerList;
    private VetoableChangeSupport vetoableChangeSupport;
    private Hashtable clientProperties;
    private InputMap inputMap_whenFocused;
    private InputMap inputMap_whenAncestorOfFocused;
    private ComponentInputMap inputMap_whenInFocusedWindow;
    private ActionMap actionMap;
    private boolean verifyInputWhenFocusTarget;
    private InputVerifier inputVerifier;
    private TransferHandler transferHandler;
    private boolean paintingTile;
    private Image dragBuffer;
    private boolean dragBufferInitialized;
    private static transient Rectangle rectCache;
    private static Locale defaultLocale;
    public static final String TOOL_TIP_TEXT_KEY = "ToolTipText";
    public static final int UNDEFINED_CONDITION = -1;
    public static final int WHEN_FOCUSED = 0;
    public static final int WHEN_ANCESTOR_OF_FOCUSED_COMPONENT = 1;
    public static final int WHEN_IN_FOCUSED_WINDOW = 2;
    private boolean clientOpaqueSet;
    private boolean clientAutoscrollsSet;

    private /* synthetic */ void finit$() {
        this.alignmentX = -1.0f;
        this.alignmentY = -1.0f;
        this.doubleBuffered = true;
        this.opaque = false;
        this.autoscrolls = false;
        this.listenerList = new EventListenerList();
        this.verifyInputWhenFocusTarget = true;
        this.clientOpaqueSet = false;
        this.clientAutoscrollsSet = false;
    }

    public JComponent() {
        this.finit$();
        this.setDropTarget(new DropTarget());
        this.setLocale(JComponent.getDefaultLocale());
        this.debugGraphicsOptions = -1;
        this.setRequestFocusEnabled(true);
    }

    private Hashtable getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable();
        }
        return this.clientProperties;
    }

    public final Object getClientProperty(Object object) {
        return this.getClientProperties().get(object);
    }

    public final void putClientProperty(Object object, Object object2) {
        Hashtable hashtable = this.getClientProperties();
        Object object3 = hashtable.get(object);
        if (object2 != null) {
            hashtable.put(object, object2);
        } else {
            hashtable.remove(object);
        }
        this.firePropertyChange(object.toString(), object3, object2);
    }

    public void removeAncestorListener(AncestorListener ancestorListener) {
        this.listenerList.remove(JComponent.class$("javax.swing.event.AncestorListener"), ancestorListener);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport != null) {
            this.vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void addAncestorListener(AncestorListener ancestorListener) {
        this.listenerList.add(JComponent.class$("javax.swing.event.AncestorListener"), ancestorListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            this.vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this.vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public EventListener[] getListeners(Class clazz) {
        if (clazz == JComponent.class$("java.beans.PropertyChangeListener")) {
            return this.getPropertyChangeListeners();
        }
        if (clazz == JComponent.class$("java.beans.VetoableChangeListener")) {
            return this.getVetoableChangeListeners();
        }
        return this.listenerList.getListeners(clazz);
    }

    public AncestorListener[] getAncestorListeners() {
        return (AncestorListener[])this.getListeners(JComponent.class$("javax.swing.event.AncestorListener"));
    }

    public VetoableChangeListener[] getVetoableChangeListeners() {
        if (this.vetoableChangeSupport == null) {
            return new VetoableChangeListener[0];
        }
        return this.vetoableChangeSupport.getVetoableChangeListeners();
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this.vetoableChangeSupport != null) {
            this.vetoableChangeSupport.fireVetoableChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, int n, int n2) {
        super.firePropertyChange(string, n, n2);
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        super.firePropertyChange(string, bl, bl2);
    }

    public void firePropertyChange(String string, char c, char c2) {
        super.firePropertyChange(string, c, c2);
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    public float getAlignmentX() {
        float f = this.alignmentX;
        if (this.alignmentX < 0.0f) {
            f = super.getAlignmentX();
        }
        return f;
    }

    public float getAlignmentY() {
        float f = this.alignmentY;
        if (this.alignmentY < 0.0f) {
            f = super.getAlignmentY();
        }
        return f;
    }

    public boolean getAutoscrolls() {
        return this.autoscrolls;
    }

    public void setBorder(Border border) {
        Border border2 = this.getBorder();
        if (border2 == border) {
            return;
        }
        this.border = border;
        this.firePropertyChange("border", border2, border);
        this.repaint();
    }

    public Border getBorder() {
        return this.border;
    }

    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        rectangle.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rectangle;
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        Graphics graphics2 = graphics;
        int n = this.getDebugGraphicsOptions();
        if (n != -1) {
            if (!(graphics2 instanceof DebugGraphics)) {
                graphics2 = new DebugGraphics(graphics);
            }
            DebugGraphics debugGraphics = (DebugGraphics)graphics2;
            debugGraphics.setDebugOptions(debugGraphics.getDebugOptions() | n);
        }
        graphics2.setFont(this.getFont());
        graphics2.setColor(this.getForeground());
        return graphics2;
    }

    public int getDebugGraphicsOptions() {
        String string = System.getProperty("gnu.javax.swing.DebugGraphics");
        int n = this.debugGraphicsOptions;
        if (string != null && string.length() != 0) {
            if (n < 0) {
                n = 0;
            }
            if (string.equals("LOG")) {
                n |= 1;
            } else if (string.equals("FLASH")) {
                n |= 2;
            }
        }
        return n;
    }

    public Insets getInsets() {
        if (this.border == null) {
            return super.getInsets();
        }
        return this.getBorder().getBorderInsets(this);
    }

    public Insets getInsets(Insets insets) {
        Insets insets2 = this.getInsets();
        if (insets == null) {
            return insets2;
        }
        insets.left = insets2.left;
        insets.right = insets2.right;
        insets.top = insets2.top;
        insets.bottom = insets2.bottom;
        return insets;
    }

    public Point getLocation(Point point) {
        if (point == null) {
            return new Point(this.getX(), this.getY());
        }
        point.setLocation(this.getX(), this.getY());
        return point;
    }

    public Dimension getMaximumSize() {
        Dimension dimension;
        if (this.maximumSize != null) {
            return this.maximumSize;
        }
        if (this.ui != null && (dimension = this.ui.getMaximumSize(this)) != null) {
            return dimension;
        }
        dimension = super.getMaximumSize();
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension;
        if (this.minimumSize != null) {
            return this.minimumSize;
        }
        if (this.ui != null && (dimension = this.ui.getMinimumSize(this)) != null) {
            return dimension;
        }
        dimension = super.getMinimumSize();
        return dimension;
    }

    public Dimension getPreferredSize() {
        Dimension dimension;
        Dimension dimension2 = null;
        if (this.preferredSize != null) {
            dimension2 = new Dimension(this.preferredSize);
        } else if (this.ui != null && (dimension = this.ui.getPreferredSize(this)) != null) {
            dimension2 = dimension;
        }
        if (dimension2 == null) {
            dimension2 = super.getPreferredSize();
        }
        return dimension2;
    }

    public boolean isMaximumSizeSet() {
        return this.maximumSize != null;
    }

    public boolean isMinimumSizeSet() {
        return this.minimumSize != null;
    }

    public boolean isPreferredSizeSet() {
        return this.preferredSize != null;
    }

    public Component getNextFocusableComponent() {
        Container container = this;
        if (!this.isFocusCycleRoot()) {
            container = this.getFocusCycleRootAncestor();
        }
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        return focusTraversalPolicy.getComponentAfter(container, this);
    }

    public KeyStroke[] getRegisteredKeyStrokes() {
        KeyStroke[] keyStrokeArray = this.inputMap_whenFocused != null ? this.inputMap_whenFocused.keys() : new KeyStroke[]{};
        KeyStroke[] keyStrokeArray2 = this.inputMap_whenAncestorOfFocused != null ? this.inputMap_whenAncestorOfFocused.keys() : new KeyStroke[]{};
        KeyStroke[] keyStrokeArray3 = this.inputMap_whenInFocusedWindow != null ? this.inputMap_whenInFocusedWindow.keys() : new KeyStroke[]{};
        int n = keyStrokeArray.length + keyStrokeArray2.length + keyStrokeArray3.length;
        KeyStroke[] keyStrokeArray4 = new KeyStroke[n];
        System.arraycopy(keyStrokeArray, 0, keyStrokeArray4, 0, keyStrokeArray.length);
        System.arraycopy(keyStrokeArray2, 0, keyStrokeArray4, keyStrokeArray.length, keyStrokeArray2.length);
        System.arraycopy(keyStrokeArray3, 0, keyStrokeArray4, keyStrokeArray.length + keyStrokeArray2.length, keyStrokeArray3.length);
        return keyStrokeArray4;
    }

    public JRootPane getRootPane() {
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        return jRootPane;
    }

    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        dimension.setSize(this.getWidth(), this.getHeight());
        return dimension;
    }

    public JToolTip createToolTip() {
        JToolTip jToolTip = new JToolTip();
        jToolTip.setComponent(this);
        jToolTip.setTipText(this.toolTipText);
        return jToolTip;
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return null;
    }

    public void setToolTipText(String string) {
        if (string == null) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
            this.toolTipText = null;
            return;
        }
        String string2 = this.toolTipText;
        this.toolTipText = string;
        if (string2 == null) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getToolTipText();
    }

    public boolean getInheritsPopupMenu() {
        return this.inheritsPopupMenu;
    }

    public void setInheritsPopupMenu(boolean bl) {
        if (this.inheritsPopupMenu != bl) {
            this.inheritsPopupMenu = bl;
            this.firePropertyChange("inheritsPopupMenu", bl ^ true, bl);
        }
    }

    public JPopupMenu getComponentPopupMenu() {
        if (this.componentPopupMenu == null && this.getInheritsPopupMenu()) {
            Container container = this.getParent();
            if (container instanceof JComponent) {
                return ((JComponent)container).getComponentPopupMenu();
            }
            return null;
        }
        return this.componentPopupMenu;
    }

    public void setComponentPopupMenu(JPopupMenu jPopupMenu) {
        if (this.componentPopupMenu != jPopupMenu) {
            JPopupMenu jPopupMenu2 = this.componentPopupMenu;
            this.componentPopupMenu = jPopupMenu;
            this.firePropertyChange("componentPopupMenu", jPopupMenu2, jPopupMenu);
        }
    }

    public Container getTopLevelAncestor() {
        Container container;
        for (Container container2 = container = this.getParent(); container2 != null; container2 = container2.getParent()) {
            container = container2;
        }
        return container;
    }

    public void computeVisibleRect(Rectangle rectangle) {
        Container container = this.getParent();
        if (container != null && container instanceof JComponent) {
            ((JComponent)container).computeVisibleRect(rectangle);
            rectangle.translate(-this.getX(), -this.getY());
            rectangle = SwingUtilities.computeIntersection(0, 0, this.getWidth(), this.getHeight(), rectangle);
        } else {
            rectangle.setRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    public Rectangle getVisibleRect() {
        Rectangle rectangle = new Rectangle();
        this.computeVisibleRect(rectangle);
        return rectangle;
    }

    public void grabFocus() {
        this.requestFocus();
    }

    public boolean isDoubleBuffered() {
        return this.doubleBuffered;
    }

    public static boolean isLightweightComponent(Component component) {
        return component.getPeer() instanceof LightweightPeer;
    }

    public boolean isManagingFocus() {
        return false;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public boolean isPaintingTile() {
        return this.paintingTile;
    }

    public boolean isRequestFocusEnabled() {
        return this.requestFocusEnabled;
    }

    public boolean isValidateRoot() {
        return false;
    }

    public void paint(Graphics graphics) {
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        if (!paintingDoubleBuffered && this.isDoubleBuffered() && repaintManager.isDoubleBufferingEnabled()) {
            Rectangle rectangle = graphics.getClipBounds();
            this.paintDoubleBuffered(rectangle);
        } else {
            if (this.getClientProperty("bufferedDragging") != null && this.dragBuffer == null) {
                this.initializeDragBuffer();
            } else if (this.getClientProperty("bufferedDragging") == null && this.dragBuffer != null) {
                this.dragBuffer = null;
            }
            if (graphics.getClip() == null) {
                graphics.setClip(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.dragBuffer != null && this.dragBufferInitialized) {
                graphics.drawImage(this.dragBuffer, 0, 0, this);
            } else {
                Graphics graphics2 = this.getComponentGraphics(graphics);
                this.paintComponent(graphics2);
                this.paintBorder(graphics2);
                this.paintChildren(graphics2);
            }
        }
    }

    private void initializeDragBuffer() {
        this.dragBufferInitialized = false;
        if (this.dragBuffer == null || this.dragBuffer.getWidth(this) < this.getWidth() || this.dragBuffer.getHeight(this) < this.getHeight()) {
            this.dragBuffer = this.createImage(this.getWidth(), this.getHeight());
        }
        Graphics graphics = this.dragBuffer.getGraphics();
        this.paint(graphics);
        graphics.dispose();
        this.dragBufferInitialized = true;
    }

    protected void paintBorder(Graphics graphics) {
        if (this.getBorder() != null) {
            this.getBorder().paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected void paintChildren(Graphics graphics) {
        if (this.getComponentCount() > 0) {
            Object object = this.getTreeLock();
            synchronized (object) {
                try {
                    Object var10_10;
                    for (int i = this.getComponentCount() - 1; i >= 0; --i) {
                        Object object2;
                        int n;
                        int n2;
                        int n3;
                        int n4;
                        Component component = this.getComponent(i);
                        if (component == null || !component.isLightweight() || !component.isVisible() || !graphics.hitClip(n4 = component.getX(), n3 = component.getY(), n2 = component.getWidth(), n = component.getHeight())) continue;
                        if (!this.isOptimizedDrawingEnabled() && i > 0) {
                            object2 = graphics.getClipBounds();
                            SwingUtilities.computeIntersection(n4, n3, n2, n, (Rectangle)object2);
                            if (this.isCompletelyObscured(i, (Rectangle)object2)) continue;
                        }
                        object2 = graphics.create(n4, n3, n2, n);
                        ((Graphics)object2).setColor(component.getForeground());
                        ((Graphics)object2).setFont(component.getFont());
                        try {
                            component.paint((Graphics)object2);
                            continue;
                        }
                        finally {
                            var10_10 = null;
                            ((Graphics)object2).dispose();
                        }
                    }
                    var10_10 = null;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    throw throwable;
                }
            }
        }
    }

    private boolean isCompletelyObscured(int n, Rectangle rectangle) {
        boolean bl = false;
        for (int i = n - 1; i >= 0 && !bl; --i) {
            Component component = this.getComponent(i);
            if (!component.isVisible()) continue;
            Rectangle rectangle2 = component.getBounds(rectCache);
            if (!component.isOpaque() || rectangle.x < rectangle2.x || rectangle.x + rectangle.width > rectangle2.x + rectangle2.width || rectangle.y < rectangle2.y || rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) continue;
            bl = true;
        }
        return bl;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.ui != null) {
            Graphics graphics2 = graphics.create();
            try {
                this.ui.update(graphics2, this);
            }
            finally {
                Object var3_3 = null;
                graphics2.dispose();
            }
        }
    }

    public void paintImmediately(int n, int n2, int n3, int n4) {
        this.paintImmediately(new Rectangle(n, n2, n3, n4));
    }

    public void paintImmediately(Rectangle rectangle) {
        Component component = this.findPaintRoot(rectangle);
        if (component == null || !component.isShowing()) {
            return;
        }
        SwingUtilities.convertRectangleToAncestor(this, rectangle, component);
        if (component instanceof JComponent) {
            ((JComponent)component).paintImmediately2(rectangle);
        } else {
            component.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    void paintImmediately2(Rectangle rectangle) {
        isRepainting = true;
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        if (repaintManager.isDoubleBufferingEnabled() && this.isPaintingDoubleBuffered()) {
            this.paintDoubleBuffered(rectangle);
        } else {
            this.paintSimple(rectangle);
        }
        isRepainting = false;
    }

    private boolean isPaintingDoubleBuffered() {
        boolean bl = this.isDoubleBuffered();
        for (Container container = this.getParent(); !bl && container != null; container = container.getParent()) {
            bl = container instanceof JComponent && ((JComponent)container).isDoubleBuffered();
        }
        return bl;
    }

    private void paintDoubleBuffered(Rectangle rectangle) {
        Graphics graphics;
        RepaintManager repaintManager;
        block4: {
            Component component;
            repaintManager = RepaintManager.currentManager(this);
            Image image = repaintManager.getVolatileOffscreenBuffer(this, (component = SwingUtilities.getRoot(this)).getWidth(), component.getHeight());
            if (image == null) {
                image = repaintManager.getOffscreenBuffer(this, component.getWidth(), component.getHeight());
            }
            graphics = image.getGraphics();
            this.clipAndTranslateGraphics(component, this, graphics);
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics = this.getComponentGraphics(graphics);
            paintingDoubleBuffered = true;
            try {
                if (isRepainting) {
                    this.paint(graphics);
                    break block4;
                }
                this.paintComponent(graphics);
                this.paintBorder(graphics);
                this.paintChildren(graphics);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                paintingDoubleBuffered = false;
                graphics.dispose();
                throw throwable;
            }
        }
        Object var6_6 = null;
        paintingDoubleBuffered = false;
        graphics.dispose();
        repaintManager.commitBuffer(this, rectangle);
    }

    private void clipAndTranslateGraphics(Component component, Component component2, Graphics graphics) {
        int n = 0;
        int n2 = 0;
        for (Component component3 = component2; component3 != component; component3 = component3.getParent()) {
            n += component3.getX();
            n2 += component3.getY();
        }
        graphics.translate(n, n2);
        graphics.clipRect(0, 0, component2.getWidth(), component2.getHeight());
    }

    void paintSimple(Rectangle rectangle) {
        Graphics graphics = this.getGraphics();
        Graphics graphics2 = this.getComponentGraphics(graphics);
        graphics2.setClip(rectangle);
        this.paint(graphics2);
        graphics2.dispose();
        if (graphics != graphics2) {
            graphics.dispose();
        }
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.paramString());
        stringBuffer.append(",alignmentX=").append(this.getAlignmentX());
        stringBuffer.append(",alignmentY=").append(this.getAlignmentY());
        stringBuffer.append(",border=");
        if (this.getBorder() != null) {
            stringBuffer.append(this.getBorder());
        }
        stringBuffer.append(",maximumSize=");
        if (this.getMaximumSize() != null) {
            stringBuffer.append(this.getMaximumSize());
        }
        stringBuffer.append(",minimumSize=");
        if (this.getMinimumSize() != null) {
            stringBuffer.append(this.getMinimumSize());
        }
        stringBuffer.append(",preferredSize=");
        if (this.getPreferredSize() != null) {
            stringBuffer.append(this.getPreferredSize());
        }
        return stringBuffer.toString();
    }

    public void registerKeyboardAction(ActionListener actionListener, KeyStroke keyStroke, int n) {
        this.registerKeyboardAction(actionListener, null, keyStroke, n);
    }

    public void registerKeyboardAction(ActionListener actionListener, String string, KeyStroke keyStroke, int n) {
        ActionListenerProxy actionListenerProxy = new ActionListenerProxy(actionListener, string);
        this.getInputMap(n).put(keyStroke, actionListenerProxy);
        this.getActionMap().put(actionListenerProxy, actionListenerProxy);
    }

    public final void setInputMap(int n, InputMap inputMap) {
        this.enableEvents(8);
        switch (n) {
            case 0: {
                this.inputMap_whenFocused = inputMap;
                break;
            }
            case 1: {
                this.inputMap_whenAncestorOfFocused = inputMap;
                break;
            }
            case 2: {
                if (inputMap != null && !(inputMap instanceof ComponentInputMap)) {
                    throw new IllegalArgumentException("WHEN_IN_FOCUSED_WINDOW InputMap must be a ComponentInputMap");
                }
                this.inputMap_whenInFocusedWindow = (ComponentInputMap)inputMap;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public final InputMap getInputMap(int n) {
        this.enableEvents(8);
        switch (n) {
            case 0: {
                if (this.inputMap_whenFocused == null) {
                    this.inputMap_whenFocused = new InputMap();
                }
                return this.inputMap_whenFocused;
            }
            case 1: {
                if (this.inputMap_whenAncestorOfFocused == null) {
                    this.inputMap_whenAncestorOfFocused = new InputMap();
                }
                return this.inputMap_whenAncestorOfFocused;
            }
            case 2: {
                if (this.inputMap_whenInFocusedWindow == null) {
                    this.inputMap_whenInFocusedWindow = new ComponentInputMap(this);
                }
                return this.inputMap_whenInFocusedWindow;
            }
        }
        throw new IllegalArgumentException("Invalid 'condition' argument: " + n);
    }

    public final InputMap getInputMap() {
        return this.getInputMap(0);
    }

    public final ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = new ActionMap();
        }
        return this.actionMap;
    }

    public final void setActionMap(ActionMap actionMap) {
        this.actionMap = actionMap;
    }

    public int getConditionForKeyStroke(KeyStroke keyStroke) {
        if (this.inputMap_whenFocused != null && this.inputMap_whenFocused.get(keyStroke) != null) {
            return 0;
        }
        if (this.inputMap_whenAncestorOfFocused != null && this.inputMap_whenAncestorOfFocused.get(keyStroke) != null) {
            return 1;
        }
        if (this.inputMap_whenInFocusedWindow != null && this.inputMap_whenInFocusedWindow.get(keyStroke) != null) {
            return 2;
        }
        return -1;
    }

    public ActionListener getActionForKeyStroke(KeyStroke keyStroke) {
        Object object = this.getInputMap(0).get(keyStroke);
        if (object == null) {
            object = this.getInputMap(1).get(keyStroke);
        }
        if (object == null) {
            object = this.getInputMap(2).get(keyStroke);
        }
        if (object != null) {
            if (object instanceof ActionListenerProxy) {
                return ((ActionListenerProxy)object).target;
            }
            return this.getActionMap().get(object);
        }
        return null;
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        Container container;
        boolean bl;
        super.processKeyEvent(keyEvent);
        this.processComponentKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        boolean bl2 = bl = keyEvent.getID() == 401;
        if (this.processKeyBinding(keyStroke, keyEvent, 0, bl)) {
            keyEvent.consume();
            return;
        }
        if (this.processKeyBinding(keyStroke, keyEvent, 1, bl)) {
            keyEvent.consume();
            return;
        }
        for (container = this.getParent(); container != null; container = container.getParent()) {
            if (container instanceof JComponent && ((JComponent)container).processKeyBinding(keyStroke, keyEvent, 1, bl)) {
                keyEvent.consume();
                return;
            }
            if (container instanceof Window || container instanceof Applet) break;
        }
        if (container == null || keyEvent.isConsumed()) {
            return;
        }
        if (KeyboardManager.getManager().processKeyStroke(container, keyStroke, keyEvent)) {
            keyEvent.consume();
        }
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (this.isEnabled()) {
            Action action = null;
            Object object = null;
            InputMap inputMap = this.getInputMap(n);
            if (inputMap != null && (object = inputMap.get(keyStroke)) != null) {
                action = object instanceof ActionListenerProxy ? (Action)object : this.getActionMap().get(object);
            }
            if (action != null && action.isEnabled()) {
                Action action2 = action;
                synchronized (action2) {
                    try {
                        action.putValue("__command__", object);
                        boolean bl2 = SwingUtilities.notifyAction(action, keyStroke, keyEvent, this, keyEvent.getModifiers());
                        Object var10_11 = null;
                        return bl2;
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        throw throwable;
                    }
                }
            }
        }
        boolean bl3 = false;
        return bl3;
    }

    public void unregisterKeyboardAction(KeyStroke keyStroke) {
        ActionMap actionMap = this.getActionMap();
        for (int i = 0; i < 3; ++i) {
            InputMap inputMap = this.getInputMap(i);
            if (inputMap == null) continue;
            Object object = inputMap.get(keyStroke);
            if (object != null && actionMap != null) {
                actionMap.remove(object);
            }
            inputMap.remove(keyStroke);
        }
    }

    public void resetKeyboardActions() {
        if (this.inputMap_whenFocused != null) {
            this.inputMap_whenFocused.clear();
        }
        if (this.inputMap_whenAncestorOfFocused != null) {
            this.inputMap_whenAncestorOfFocused.clear();
        }
        if (this.inputMap_whenInFocusedWindow != null) {
            this.inputMap_whenInFocusedWindow.clear();
        }
        if (this.actionMap != null) {
            this.actionMap.clear();
        }
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        RepaintManager.currentManager(this).addDirtyRegion(this, n, n2, n3, n4);
    }

    public void repaint(Rectangle rectangle) {
        RepaintManager.currentManager(this).addDirtyRegion(this, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean requestDefaultFocus() {
        return false;
    }

    public void revalidate() {
        if (this.getParent() == null) {
            return;
        }
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(this){
                private /* synthetic */ JComponent this$0;
                {
                    this.this$0 = jComponent;
                }

                public void run() {
                    this.this$0.revalidate();
                }
            });
        } else {
            this.invalidate();
            RepaintManager.currentManager(this).addInvalidComponent(this);
        }
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        Container container = this.getParent();
        if (container instanceof JComponent) {
            ((JComponent)container).scrollRectToVisible(rectangle);
        }
    }

    public void setAlignmentX(float f) {
        this.alignmentX = f < 0.0f ? 0.0f : ((double)f > 1.0 ? 1.0f : f);
    }

    public void setAlignmentY(float f) {
        this.alignmentY = f < 0.0f ? 0.0f : ((double)f > 1.0 ? 1.0f : f);
    }

    public void setAutoscrolls(boolean bl) {
        this.autoscrolls = bl;
        this.clientAutoscrollsSet = true;
    }

    public void setDebugGraphicsOptions(int n) {
        this.debugGraphicsOptions = n;
    }

    public void setDoubleBuffered(boolean bl) {
        this.doubleBuffered = bl;
    }

    public void setEnabled(boolean bl) {
        if (bl == this.isEnabled()) {
            return;
        }
        super.setEnabled(bl);
        this.firePropertyChange("enabled", bl ^ true, bl);
        this.repaint();
    }

    public void setFont(Font font) {
        if (font == this.getFont()) {
            return;
        }
        super.setFont(font);
        this.revalidate();
        this.repaint();
    }

    public void setBackground(Color color) {
        if (color == this.getBackground()) {
            return;
        }
        super.setBackground(color);
        this.repaint();
    }

    public void setForeground(Color color) {
        if (color == this.getForeground()) {
            return;
        }
        super.setForeground(color);
        this.repaint();
    }

    public void setMaximumSize(Dimension dimension) {
        Dimension dimension2 = this.maximumSize;
        this.maximumSize = dimension != null ? new Dimension(dimension) : null;
        this.firePropertyChange("maximumSize", dimension2, this.maximumSize);
    }

    public void setMinimumSize(Dimension dimension) {
        Dimension dimension2 = this.minimumSize;
        this.minimumSize = dimension != null ? new Dimension(dimension) : null;
        this.firePropertyChange("minimumSize", dimension2, this.minimumSize);
    }

    public void setPreferredSize(Dimension dimension) {
        Dimension dimension2 = this.preferredSize;
        this.preferredSize = dimension != null ? new Dimension(dimension) : null;
        this.firePropertyChange("preferredSize", dimension2, this.preferredSize);
    }

    public void setNextFocusableComponent(Component component) {
        FocusTraversalPolicy focusTraversalPolicy;
        Container container = this;
        if (!this.isFocusCycleRoot()) {
            container = this.getFocusCycleRootAncestor();
        }
        if ((focusTraversalPolicy = container.getFocusTraversalPolicy()) instanceof CompatibilityFocusTraversalPolicy) {
            focusTraversalPolicy = new CompatibilityFocusTraversalPolicy(focusTraversalPolicy);
            container.setFocusTraversalPolicy(focusTraversalPolicy);
        }
        CompatibilityFocusTraversalPolicy compatibilityFocusTraversalPolicy = (CompatibilityFocusTraversalPolicy)focusTraversalPolicy;
        Component component2 = this.getNextFocusableComponent();
        if (component2 != null) {
            compatibilityFocusTraversalPolicy.removeNextFocusableComponent(this, component2);
        }
        if (component != null) {
            compatibilityFocusTraversalPolicy.addNextFocusableComponent(this, component);
        }
    }

    public void setRequestFocusEnabled(boolean bl) {
        this.requestFocusEnabled = bl;
    }

    public TransferHandler getTransferHandler() {
        return this.transferHandler;
    }

    public void setTransferHandler(TransferHandler transferHandler) {
        if (this.transferHandler == transferHandler) {
            return;
        }
        TransferHandler transferHandler2 = this.transferHandler;
        this.transferHandler = transferHandler;
        this.firePropertyChange("transferHandler", transferHandler2, transferHandler);
    }

    public void setOpaque(boolean bl) {
        boolean bl2 = this.opaque;
        this.opaque = bl;
        this.clientOpaqueSet = true;
        this.firePropertyChange("opaque", bl2, this.opaque);
    }

    public void setVisible(boolean bl) {
        if (this.isVisible() == bl) {
            return;
        }
        super.setVisible(bl);
        if (bl) {
            this.fireAncestorEvent(this, 1);
        } else {
            this.fireAncestorEvent(this, 2);
        }
        Container container = this.getParent();
        if (container != null) {
            container.repaint(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        this.revalidate();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public String getUIClassID() {
        return "ComponentUI";
    }

    protected void setUI(ComponentUI componentUI) {
        if (this.ui != null) {
            this.ui.uninstallUI(this);
        }
        ComponentUI componentUI2 = this.ui;
        this.ui = componentUI;
        if (this.ui != null) {
            this.ui.installUI(this);
        }
        this.firePropertyChange("UI", componentUI2, componentUI);
        this.revalidate();
        this.repaint();
    }

    public void updateUI() {
    }

    public static Locale getDefaultLocale() {
        if (defaultLocale == null) {
            defaultLocale = Locale.getDefault();
        }
        return defaultLocale;
    }

    public static void setDefaultLocale(Locale locale) {
        defaultLocale = locale;
    }

    public InputVerifier getInputVerifier() {
        return this.inputVerifier;
    }

    public void setInputVerifier(InputVerifier inputVerifier) {
        InputVerifier inputVerifier2 = this.inputVerifier;
        this.inputVerifier = inputVerifier;
        this.firePropertyChange("inputVerifier", inputVerifier2, inputVerifier);
    }

    public boolean getVerifyInputWhenFocusTarget() {
        return this.verifyInputWhenFocusTarget;
    }

    public void setVerifyInputWhenFocusTarget(boolean bl) {
        if (this.verifyInputWhenFocusTarget == bl) {
            return;
        }
        this.verifyInputWhenFocusTarget = bl;
        this.firePropertyChange("verifyInputWhenFocusTarget", bl ^ true, bl);
    }

    public void requestFocus() {
        if (this.isRequestFocusEnabled()) {
            super.requestFocus();
        }
    }

    public boolean requestFocus(boolean bl) {
        return super.requestFocus(bl);
    }

    public boolean requestFocusInWindow() {
        if (this.isRequestFocusEnabled()) {
            return super.requestFocusInWindow();
        }
        return false;
    }

    protected boolean requestFocusInWindow(boolean bl) {
        return super.requestFocusInWindow(bl);
    }

    public void addNotify() {
        KeyboardManager keyboardManager = KeyboardManager.getManager();
        keyboardManager.clearBindingsForComp(this);
        keyboardManager.registerEntireMap((ComponentInputMap)this.getInputMap(2));
        super.addNotify();
        this.fireAncestorEvent(this, 1);
        this.firePropertyChange("ancestor", null, this.getParent());
    }

    public void removeNotify() {
        super.removeNotify();
        KeyboardManager.getManager().clearBindingsForComp(this);
        this.fireAncestorEvent(this, 2);
        this.firePropertyChange("ancestor", this.getParent(), null);
    }

    public boolean contains(int n, int n2) {
        if (this.ui == null) {
            return super.contains(n, n2);
        }
        return this.ui.contains(this, n, n2);
    }

    public void disable() {
        super.disable();
    }

    public void enable() {
        super.enable();
    }

    public Graphics getGraphics() {
        return super.getGraphics();
    }

    public int getX() {
        return super.getX();
    }

    public int getY() {
        return super.getY();
    }

    public int getHeight() {
        return super.getHeight();
    }

    public int getWidth() {
        return super.getWidth();
    }

    public void print(Graphics graphics) {
        boolean bl = this.isDoubleBuffered();
        this.setDoubleBuffered(false);
        this.printComponent(graphics);
        this.printBorder(graphics);
        this.printChildren(graphics);
        this.setDoubleBuffered(bl);
    }

    public void printAll(Graphics graphics) {
        this.print(graphics);
    }

    protected void printComponent(Graphics graphics) {
        this.paintComponent(graphics);
    }

    protected void printChildren(Graphics graphics) {
        this.paintChildren(graphics);
    }

    protected void printBorder(Graphics graphics) {
        this.paintBorder(graphics);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        int n5 = this.getX();
        int n6 = this.getY();
        super.reshape(n, n2, n3, n4);
        if (n5 != this.getX() || n6 != this.getY()) {
            this.fireAncestorEvent(this, 3);
        }
    }

    void fireAncestorEvent(JComponent jComponent, int n) {
        int n2;
        AncestorListener[] ancestorListenerArray = this.getAncestorListeners();
        if (ancestorListenerArray.length > 0) {
            AncestorEvent ancestorEvent = new AncestorEvent(this, n, jComponent, jComponent.getParent());
            block5: for (n2 = 0; n2 < ancestorListenerArray.length; ++n2) {
                switch (n) {
                    case 3: {
                        ancestorListenerArray[n2].ancestorMoved(ancestorEvent);
                        continue block5;
                    }
                    case 1: {
                        ancestorListenerArray[n2].ancestorAdded(ancestorEvent);
                        continue block5;
                    }
                    case 2: {
                        ancestorListenerArray[n2].ancestorRemoved(ancestorEvent);
                    }
                }
            }
        }
        int n3 = this.getComponentCount();
        for (n2 = 0; n2 < n3; ++n2) {
            Component component = this.getComponent(n2);
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent2 = (JComponent)component;
            jComponent2.fireAncestorEvent(jComponent, n);
        }
    }

    private Component findPaintRoot(Rectangle rectangle) {
        Component component = this.findOverlapFreeParent(rectangle);
        if (component == null) {
            return null;
        }
        Component component2 = this.findOpaqueParent(component);
        return component2;
    }

    private Component findOverlapFreeParent(Rectangle rectangle) {
        Container container;
        Rectangle rectangle2 = rectangle;
        Container container2 = this;
        Container container3 = this;
        while (container3 != null && !(container3 instanceof Window) && (container = container3.getParent()) != null && !(container instanceof Window)) {
            if (container instanceof JComponent && ((JComponent)container).isOptimizedDrawingEnabled()) {
                container3 = container;
                continue;
            }
            Rectangle rectangle3 = SwingUtilities.convertRectangle(container2, rectangle2, container);
            Rectangle rectangle4 = SwingUtilities.getLocalBounds(container);
            boolean bl = SwingUtilities.isRectangleContainingRectangle(rectangle4, rectangle3) ^ true;
            if (!bl) {
                Component component;
                int n = 0;
                while ((component = container.getComponent(n)) != container3 && !bl) {
                    Rectangle rectangle5 = component.getBounds();
                    bl = rectangle3.intersects(rectangle5);
                    ++n;
                }
            }
            if (bl) {
                container2 = container;
                rectangle2 = rectangle3;
            }
            container3 = container;
        }
        return container2;
    }

    private Component findOpaqueParent(Component component) {
        Container container;
        Component component2 = component;
        while (!(component2 instanceof JComponent && ((JComponent)component2).isOpaque() || !(component2 instanceof JComponent) && !component2.isLightweight() || (container = component2.getParent()) == null)) {
            component2 = container;
        }
        return component2;
    }

    void updateComponentInputMap(ComponentInputMap componentInputMap) {
        InputMap inputMap;
        for (inputMap = this.getInputMap(2); inputMap != null && inputMap != componentInputMap; inputMap = inputMap.getParent()) {
        }
        if (inputMap == null) {
            return;
        }
        KeyboardManager keyboardManager = KeyboardManager.getManager();
        keyboardManager.clearBindingsForComp(componentInputMap.getComponent());
        keyboardManager.registerEntireMap((ComponentInputMap)this.getInputMap(2));
    }

    void setUIProperty(String string, Object object) {
        if (string.equals("opaque")) {
            if (!this.clientOpaqueSet) {
                this.setOpaque((Boolean)object);
                this.clientOpaqueSet = false;
            }
        } else if (string.equals("autoscrolls")) {
            if (!this.clientAutoscrollsSet) {
                this.setAutoscrolls((Boolean)object);
                this.clientAutoscrollsSet = false;
            }
        } else {
            throw new IllegalArgumentException("Unsupported property for LookAndFeel.installProperty(): " + string);
        }
    }

    static {
        TOOL_TIP_TEXT_KEY = TOOL_TIP_TEXT_KEY;
    }

    private static class ActionListenerProxy
    extends AbstractAction {
        ActionListener target;
        String bindingCommandName;

        public ActionListenerProxy(ActionListener actionListener, String string) {
            this.target = actionListener;
            this.bindingCommandName = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionEvent actionEvent2 = new ActionEvent(actionEvent.getSource(), actionEvent.getID(), this.bindingCommandName, actionEvent.getModifiers());
            this.target.actionPerformed(actionEvent2);
        }
    }

    public abstract class AccessibleJComponent
    extends Container.AccessibleAWTContainer
    implements AccessibleExtendedComponent {
        private /* synthetic */ JComponent this$0;
        private static final long serialVersionUID = -7047089700479897799L;
        protected ContainerListener accessibleContainerHandler;
        protected FocusListener accessibleFocusHandler;

        protected AccessibleJComponent(JComponent jComponent) {
            this.this$0 = jComponent;
            super(jComponent);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleContainerHandler == null) {
                this.accessibleContainerHandler = new AccessibleContainerHandler(this);
                this.this$0.addContainerListener(this.accessibleContainerHandler);
            }
            if (this.accessibleFocusHandler == null) {
                this.accessibleFocusHandler = new AccessibleFocusHandler(this);
                this.addFocusListener(this.accessibleFocusHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleContainerHandler != null) {
                this.this$0.removeContainerListener(this.accessibleContainerHandler);
                this.accessibleContainerHandler = null;
            }
            if (this.accessibleFocusHandler != null) {
                this.removeFocusListener(this.accessibleFocusHandler);
                this.accessibleFocusHandler = null;
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        public int getAccessibleChildrenCount() {
            return super.getAccessibleChildrenCount();
        }

        public Accessible getAccessibleChild(int n) {
            return super.getAccessibleChild(n);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (this.this$0.isOpaque()) {
                accessibleStateSet.add(AccessibleState.OPAQUE);
            }
            return accessibleStateSet;
        }

        public String getAccessibleName() {
            Object object;
            String string = super.getAccessibleName();
            if (string == null) {
                string = this.getTitledBorderText();
            }
            if (string == null && (object = this.this$0.getClientProperty("labeledBy")) instanceof Accessible) {
                AccessibleContext accessibleContext = ((Accessible)object).getAccessibleContext();
                string = accessibleContext.getAccessibleName();
            }
            return string;
        }

        public String getAccessibleDescription() {
            Object object;
            String string = super.getAccessibleDescription();
            if (string == null) {
                string = this.getToolTipText();
            }
            if (string == null && (object = this.this$0.getClientProperty("labeledBy")) instanceof Accessible) {
                AccessibleContext accessibleContext = ((Accessible)object).getAccessibleContext();
                string = accessibleContext.getAccessibleName();
            }
            return string;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        protected String getBorderTitle(Border border) {
            String string = null;
            if (border instanceof CompoundBorder) {
                CompoundBorder compoundBorder = (CompoundBorder)border;
                Border border2 = compoundBorder.getInsideBorder();
                string = this.getBorderTitle(border2);
                if (string == null) {
                    Border border3 = compoundBorder.getOutsideBorder();
                    string = this.getBorderTitle(border3);
                }
            } else if (border instanceof TitledBorder) {
                TitledBorder titledBorder = (TitledBorder)border;
                string = titledBorder.getTitle();
            }
            return string;
        }

        public String getToolTipText() {
            return this.this$0.getToolTipText();
        }

        public String getTitledBorderText() {
            return this.getBorderTitle(this.this$0.getBorder());
        }

        public AccessibleKeyBinding getAccessibleKeyBinding() {
            return null;
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            private /* synthetic */ AccessibleJComponent this$1;

            protected AccessibleContainerHandler(AccessibleJComponent accessibleJComponent) {
                this.this$1 = accessibleJComponent;
            }

            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleContext accessibleContext = component.getAccessibleContext();
                    this.this$1.firePropertyChange("AccessibleChild", null, accessibleContext);
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleContext accessibleContext = component.getAccessibleContext();
                    this.this$1.firePropertyChange("AccessibleChild", accessibleContext, null);
                }
            }
        }

        protected class AccessibleFocusHandler
        implements FocusListener {
            private /* synthetic */ AccessibleJComponent this$1;

            protected AccessibleFocusHandler(AccessibleJComponent accessibleJComponent) {
                this.this$1 = accessibleJComponent;
            }

            public void focusGained(FocusEvent focusEvent) {
                this.this$1.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }

            public void focusLost(FocusEvent focusEvent) {
                this.this$1.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
        }
    }
}

