/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class DefaultDesktopManager
implements DesktopManager,
Serializable {
    private static final long serialVersionUID = 4657624909838017887L;
    static final String WAS_ICON_ONCE_PROPERTY = "wasIconOnce";
    private int currentDragMode;
    private transient Rectangle dragCache;
    private transient Container pane;
    private transient Rectangle[] iconRects;

    private /* synthetic */ void finit$() {
        this.currentDragMode = 0;
        this.dragCache = new Rectangle();
    }

    public DefaultDesktopManager() {
        this.finit$();
    }

    public void openFrame(JInternalFrame jInternalFrame) {
        Container container = jInternalFrame.getParent();
        if (container == null) {
            container = jInternalFrame.getDesktopIcon().getParent();
        }
        if (container == null) {
            return;
        }
        container.remove(jInternalFrame.getDesktopIcon());
        container.add(jInternalFrame);
        jInternalFrame.setVisible(true);
    }

    public void closeFrame(JInternalFrame jInternalFrame) {
        Container container = jInternalFrame.getParent();
        if (container != null) {
            if (jInternalFrame.isIcon()) {
                container.remove(jInternalFrame.getDesktopIcon());
            } else {
                container.remove(jInternalFrame);
            }
            container.repaint();
        }
    }

    public void maximizeFrame(JInternalFrame jInternalFrame) {
        if (jInternalFrame.isIcon()) {
            return;
        }
        jInternalFrame.setNormalBounds(jInternalFrame.getBounds());
        Container container = jInternalFrame.getParent();
        if (container != null) {
            Rectangle rectangle = container.getBounds();
            Insets insets = container.getInsets();
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            this.setBoundsForFrame(jInternalFrame, 0, 0, rectangle.width, rectangle.height);
        }
        if (container instanceof JDesktopPane) {
            ((JDesktopPane)container).setSelectedFrame(jInternalFrame);
        } else {
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void minimizeFrame(JInternalFrame jInternalFrame) {
        Rectangle rectangle = jInternalFrame.getNormalBounds();
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        if (jDesktopPane != null) {
            jDesktopPane.setSelectedFrame(jInternalFrame);
        } else {
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.setBoundsForFrame(jInternalFrame, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void iconifyFrame(JInternalFrame jInternalFrame) {
        Rectangle rectangle;
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        if (jDesktopPane != null && jDesktopPane.getSelectedFrame() == jInternalFrame) {
            jDesktopPane.setSelectedFrame(null);
        } else {
            try {
                jInternalFrame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        Container container = jInternalFrame.getParent();
        if (!this.wasIcon(jInternalFrame)) {
            rectangle = this.getBoundsForIconOf(jInternalFrame);
            jDesktopIcon.setBounds(rectangle);
            this.setWasIcon(jInternalFrame, Boolean.TRUE);
        }
        if (container != null) {
            if (jDesktopIcon != null) {
                container.add(jDesktopIcon);
                jDesktopIcon.setVisible(true);
            }
            rectangle = jInternalFrame.getBounds();
            container.remove(jInternalFrame);
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void deiconifyFrame(JInternalFrame jInternalFrame) {
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        Container container = jDesktopIcon.getParent();
        this.removeIconFor(jInternalFrame);
        container.add(jInternalFrame);
        jInternalFrame.setVisible(true);
        if (!jInternalFrame.isSelected()) {
            JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
            if (jDesktopPane != null) {
                jDesktopPane.setSelectedFrame(jInternalFrame);
            } else {
                try {
                    jInternalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
        container.invalidate();
    }

    public void activateFrame(JInternalFrame jInternalFrame) {
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        if (jDesktopPane != null) {
            jDesktopPane.setSelectedFrame(jInternalFrame);
        } else {
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        jInternalFrame.toFront();
    }

    public void deactivateFrame(JInternalFrame jInternalFrame) {
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        if (jDesktopPane != null) {
            if (jDesktopPane.getSelectedFrame() == jInternalFrame) {
                jDesktopPane.setSelectedFrame(null);
            }
        } else {
            try {
                jInternalFrame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void beginDraggingFrame(JComponent jComponent) {
        this.pane = jComponent instanceof JInternalFrame.JDesktopIcon ? ((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame().getDesktopPane() : ((JInternalFrame)jComponent).getDesktopPane();
        if (this.pane == null) {
            return;
        }
        this.dragCache = jComponent.getBounds();
        this.currentDragMode = !(this.pane instanceof JDesktopPane) ? 0 : ((JDesktopPane)this.pane).getDragMode();
    }

    public void dragFrame(JComponent jComponent, int n, int n2) {
        if (this.currentDragMode != 1) {
            Rectangle rectangle = jComponent.getBounds();
            if (jComponent instanceof JInternalFrame.JDesktopIcon) {
                jComponent.setBounds(n, n2, rectangle.width, rectangle.height);
            } else {
                this.setBoundsForFrame((JInternalFrame)jComponent, n, n2, rectangle.width, rectangle.height);
            }
        }
    }

    public void endDraggingFrame(JComponent jComponent) {
        if (this.currentDragMode == 1) {
            this.setBoundsForFrame((JInternalFrame)jComponent, this.dragCache.x, this.dragCache.y, this.dragCache.width, this.dragCache.height);
            this.pane = null;
            this.dragCache = null;
            jComponent.repaint();
        }
    }

    public void beginResizingFrame(JComponent jComponent, int n) {
        this.pane = ((JInternalFrame)jComponent).getDesktopPane();
        if (this.pane == null) {
            return;
        }
        this.dragCache = jComponent.getBounds();
        this.currentDragMode = !(this.pane instanceof JDesktopPane) ? 0 : ((JDesktopPane)this.pane).getDragMode();
    }

    public void resizeFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
        this.dragCache.setBounds(n, n2, n3, n4);
        if (this.currentDragMode != 1) {
            this.setBoundsForFrame(jComponent, this.dragCache.x, this.dragCache.y, this.dragCache.width, this.dragCache.height);
        }
    }

    public void endResizingFrame(JComponent jComponent) {
        if (this.currentDragMode == 1) {
            this.setBoundsForFrame((JInternalFrame)jComponent, this.dragCache.x, this.dragCache.y, this.dragCache.width, this.dragCache.height);
            this.pane = null;
            this.dragCache = null;
            jComponent.repaint();
        }
    }

    public void setBoundsForFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
        jComponent.setBounds(n, n2, n3, n4);
    }

    protected void removeIconFor(JInternalFrame jInternalFrame) {
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        Container container = jDesktopIcon.getParent();
        if (container != null && jDesktopIcon != null) {
            Rectangle rectangle = jDesktopIcon.getBounds();
            container.remove(jDesktopIcon);
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected Rectangle getBoundsForIconOf(JInternalFrame jInternalFrame) {
        int n;
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        if (jDesktopPane == null) {
            return jInternalFrame.getDesktopIcon().getBounds();
        }
        Rectangle rectangle = jDesktopPane.getBounds();
        Insets insets = jDesktopPane.getInsets();
        Dimension dimension = jInternalFrame.getDesktopIcon().getPreferredSize();
        Component[] componentArray = jDesktopPane.getComponents();
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < componentArray.length; ++n) {
            if (!(componentArray[n] instanceof JInternalFrame.JDesktopIcon) && (!(componentArray[n] instanceof JInternalFrame) || !((JInternalFrame)componentArray[n]).getWasIcon() || componentArray[n] == jInternalFrame)) continue;
            ++n2;
        }
        this.iconRects = new Rectangle[n2];
        n3 = 0;
        for (n = 0; n < componentArray.length; ++n) {
            if (componentArray[n] instanceof JInternalFrame.JDesktopIcon) {
                this.iconRects[--n2] = componentArray[n].getBounds();
                continue;
            }
            if (!(componentArray[n] instanceof JInternalFrame) || !((JInternalFrame)componentArray[n]).getWasIcon() || componentArray[n] == jInternalFrame) continue;
            this.iconRects[--n2] = ((JInternalFrame)componentArray[n]).getDesktopIcon().getBounds();
        }
        n3 = insets.left;
        n = rectangle.height - insets.bottom - dimension.height;
        Rectangle rectangle2 = new Rectangle(n3, n, dimension.width, dimension.height);
        boolean bl = true;
        while (this.iconRects.length > 0) {
            bl = true;
            for (int i = 0; i < this.iconRects.length; ++i) {
                if (this.iconRects[i] == null || !this.iconRects[i].intersects(rectangle2)) continue;
                bl = false;
                break;
            }
            if (bl) {
                return rectangle2;
            }
            if ((n3 += dimension.width) + dimension.width > rectangle.width - insets.right) {
                n3 = insets.left;
                n -= dimension.height;
            }
            rectangle2.setBounds(n3, n, dimension.width, dimension.height);
        }
        return rectangle2;
    }

    protected void setPreviousBounds(JInternalFrame jInternalFrame, Rectangle rectangle) {
        jInternalFrame.setNormalBounds(rectangle);
    }

    protected Rectangle getPreviousBounds(JInternalFrame jInternalFrame) {
        return jInternalFrame.getNormalBounds();
    }

    protected void setWasIcon(JInternalFrame jInternalFrame, Boolean bl) {
        jInternalFrame.setWasIcon(bl, WAS_ICON_ONCE_PROPERTY);
    }

    protected boolean wasIcon(JInternalFrame jInternalFrame) {
        return jInternalFrame.getWasIcon();
    }
}

