/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.HashMap;

class CompatibilityFocusTraversalPolicy
extends FocusTraversalPolicy {
    private FocusTraversalPolicy fallback;
    private HashMap forward;
    private HashMap backward;

    CompatibilityFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
        this.fallback = focusTraversalPolicy;
        this.forward = new HashMap();
        this.backward = new HashMap();
    }

    public Component getComponentAfter(Container container, Component component) {
        Component component2 = (Component)this.forward.get(component);
        if (component2 == null && this.fallback != null) {
            component2 = this.fallback.getComponentAfter(container, component);
        }
        return component2;
    }

    public Component getComponentBefore(Container container, Component component) {
        Component component2 = (Component)this.backward.get(component);
        if (component2 == null && this.fallback != null) {
            component2 = this.fallback.getComponentAfter(container, component);
        }
        return component2;
    }

    public Component getFirstComponent(Container container) {
        Component component = null;
        if (this.fallback != null) {
            component = this.fallback.getFirstComponent(container);
        }
        return component;
    }

    public Component getLastComponent(Container container) {
        Component component = null;
        if (this.fallback != null) {
            component = this.fallback.getLastComponent(container);
        }
        return component;
    }

    public Component getDefaultComponent(Container container) {
        Component component = null;
        if (this.fallback != null) {
            component = this.fallback.getDefaultComponent(container);
        }
        return component;
    }

    void setNextFocusableComponent(Component component, Component component2) {
        this.forward.put(component, component2);
        this.backward.put(component2, component);
    }

    void addNextFocusableComponent(Component component, Component component2) {
        this.forward.put(component, component2);
        this.backward.put(component2, component);
    }

    void removeNextFocusableComponent(Component component, Component component2) {
        this.forward.remove(component);
        this.backward.remove(component2);
    }
}

