/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import gnu.classpath.NotImplementedException;
import gnu.classpath.SystemProperties;
import java.io.Serializable;
import java.security.Principal;

public final class KerberosPrincipal
implements Serializable,
Principal {
    public static final int KRB_NT_PRINCIPAL = 1;
    public static final int KRB_NT_SRV_HST = 3;
    public static final int KRB_NT_SRV_INST = 2;
    public static final int KRB_NT_SRV_XHST = 4;
    public static final int KRB_NT_UID = 5;
    public static final int KRB_NT_UNKNOWN = 0;
    private String name;
    private int type;
    private String realm;

    public KerberosPrincipal(String string) {
        this(string, 1);
    }

    public KerberosPrincipal(String string, int n) throws NotImplementedException {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("unknown type: " + n);
        }
        this.name = string;
        this.type = n;
        this.realm = this.parseRealm();
    }

    private String parseRealm() {
        int n;
        int n2 = this.name.length();
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            if (bl) {
                bl = false;
                continue;
            }
            char c = this.name.charAt(n);
            if (c == '\\') {
                bl = true;
                continue;
            }
            if (c == '@') break;
        }
        if (bl || n == n2 - 1) {
            throw new IllegalArgumentException("malformed principal: " + this.name);
        }
        if (n < n2) {
            return this.name.substring(n + 1);
        }
        String string = SystemProperties.getProperty("java.security.krb5.realm");
        if (string != null) {
            return string;
        }
        throw new IllegalArgumentException("default realm can't be found");
    }

    public String getName() {
        return this.name;
    }

    public String getRealm() {
        return this.realm;
    }

    public int getNameType() {
        return this.type;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof KerberosPrincipal)) {
            return false;
        }
        KerberosPrincipal kerberosPrincipal = (KerberosPrincipal)object;
        return this.name.equals(kerberosPrincipal.name) && this.type == kerberosPrincipal.type;
    }

    public String toString() {
        return this.name + ":" + this.type;
    }
}

