/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class SecretKeySpec
implements KeySpec,
SecretKey {
    private static final long serialVersionUID = 6577238317307289933L;
    private byte[] key;
    private String algorithm;

    public SecretKeySpec(byte[] byArray, String string) {
        this(byArray, 0, byArray.length, string);
    }

    public SecretKeySpec(byte[] byArray, int n, int n2, String string) {
        this.key = new byte[n2];
        this.algorithm = string;
        System.arraycopy(byArray, n, this.key, 0, n2);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getEncoded() {
        return this.key;
    }

    public String getFormat() {
        return "RAW";
    }

    public boolean equals(Object object) {
        if (object instanceof SecretKeySpec) {
            byte[] byArray = ((SecretKeySpec)object).getEncoded();
            if (this.key.length != byArray.length) {
                return false;
            }
            for (int i = 0; i < this.key.length; ++i) {
                if (this.key[i] == byArray[i]) continue;
                return false;
            }
            return this.algorithm.equals(((SecretKeySpec)object).getAlgorithm());
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.key.length; ++i) {
            n ^= (this.key[i] & 0xFF) << (i << 3 & 0x1F);
        }
        return n ^ this.algorithm.hashCode();
    }
}

